# -----------------------------------------------------------------------------
# _utils.py - Shared utilities
#
# July 2014, Phil Connell
#
# Copyright 2014, Ensoft Ltd.
# -----------------------------------------------------------------------------

"""Shared utilities."""

__all__ = (
    "pretty_resize_string",
)


def pretty_resize_string(string, length=25, cutoff='back', exact=False):
    """
    Shortens or lengthens a string to be at most length characters long.

    cutoff should be 'front' or 'back', dictating where the ellipsis goes.
    exact toggles whitespace padding.
    """
    if len(string) > length:
        cutoff_string = '{0}...' if cutoff is 'back' else '...{0}'
        return cutoff_string.format(string[3-length:])
    else:
        exact_string = '{:>25}' if exact else '{0}'
        return exact_string.format(string)

