# -----------------------------------------------------------------------------
# EnTrails - Python Execution Tracing
# Copyright 2012, 2014, Ensoft Ltd.
# Created by Ben Eills
# -----------------------------------------------------------------------------

"""
Trace execution of Python programs.

Outputs may be loaded/unloaded during execution and tracing may be toggled
during runtime.

Example Usage as a module:
  import entrails
  t = entrails.Entrails('mylabel')
  o = entrails.LogFileOutput('/tmp/log')
  t.add_output(o)
  t.start_trace()
  do_stuff()
  t.end_trace()

Consider using trace.py to add EnTrails tracing to an existing Python program
without having to add the boilerplate code yourself.  That convenience script
should be distributed with this source file.

"""

from . import _filter
from . import _output
from . import _trace

__all__ = (
    _filter.__all__ +
    _output.__all__ +
    _trace.__all__
)

from ._filter import *
from ._output import *
from ._trace import *

