Ephemeral:  Encrypted Temporary Files
========
Ephemeral is a library that adds an encryption layer on top of python's standard ```tempfile``` module.  It provides the same benefits as using ```tempfile`` (i.e.: unlinked files, randomized filenames, delete-on-close behavior) and transparrently encrypts all data using a sessionkey.

WARNING
========

Although I have done my best to release highly-secure code, I remain an amateur coder.  In no circumstances should Ephemeral be used where strong cryptographic security is required.  If you blame me for a catastrophic leak in production code, I will personally:

1. Tie you to a chair.
2. Break your kneecaps with a tire iron.
3. Destroy everything you love.
4. Provide free chips and beverages for all who come watch.

Do not use Ephemeral in production code unless you have the knowledge and experience to audit every last line of code in this library.  If this is the case, please inform me of what you find!

Getting Ephemeral
========

Ephemeral is developed and tested on python version 2.7.  It will most likely work on older versions, but I make no guarantees.  The only external dependency is the ```pycrypto``` module, which is installed automatically if you install through pip or by using ```setup.py```.

###Installing through pip

The easiest and best way to obtain Ephemeral is through pip.  Only stable versions are published to PyPI.

```pip install ephemeral --user```

###Installing through git

If you want the latest development version, please clone this repository by issuing the following command:  ```git clone https://github.com/louist87/ephemeral.git```

You should then install the package with the following commands:

```
cd ephemeral
sudo python setup.py install
```
Using Ephemeral
========
###Assumptions

Ephemeral makes several strong assumptions in its threat model.  The three most important assumptions are:

1. Attackers do not have physical access to the machine executing Ephemeral code.
1. Attackers are running under a seperate uuid (i.e., keys cannot be read from memory).
1. Attackers cannot modify ciphertext.

Assumption 1 is more or less standard for storage encryption.  The assumption here is that keys cannot be obtained by manipulating hardware.  Assumptions 2 and 3 essentially defer problems of key storage and ciphertext authentication to operating system permissions.  In other words, it is the responsibility of the user to run ephemeral-dependent apps as apprpriately-isolated users.

Regarding the modification of ciphertext, the ```tempfile``` module implements approaches to render manipulation of temporary files difficult (randomized names and filesystem unlinking).

To be perfectly explicit:  **There is no cryptographic authentication in ephemeral**.  I do plan to switch from CTR mode to an authenticated mode once:

1. Such modes become available in pycrypto
2. The CEASAR competition is over

**In summary:**  ephemeral is intended as a mitigation measure against drive theft and undeleting.  It is a simpler (albeit slightly less secure) solution than a ram-based temp directory with an encrypted swap file.  Its main advantage is that it requires no reconfiguring of the operating system, and can be safely employed on end-user machines.

###Basic usage

Ephemeral exposes one construct:  the ```EphemeralFile```.  An ephemeral file should be thought of as a superset of ```tempfile.TemporaryFile```.  It accepts the same keyword-arguments as ```TemporaryFile``` and exposes identical methods.  Please refer to the [standard library documentation](http://docs.python.org/2/library/tempfile.html) for details pertaining to these keywords.

If it isn't already obvious, an ```EphemeralFile``` instance can be used wherever a ```tempfile.TemporaryFile``` instance would normally be used.  An ephemeral file can be instantiated in exactly the same manner as a standard ```TemporaryFile```.

```python
import ephemeral

f = ephemeral.EphemeralFile()
f.write('hello, world')
f.close()  # file is deleted
```

Naturally, ```EphemeralFile``` implements a context manager.

```python
import ephemeral

with ephemeral.EphemeralFile() as f:
    f.write('goodbye, cruel world!')
```

###Reading raw ciphertext

Normally, there is no need to manipulate ciphertext directly.  For purposes of convenent cryptanalysis, however, ephemeral file objects expose the ```read_ciphertext``` method.  This method behaves exactly like ```file.read``` (it, in fact, *is* ```file.read``` behind the scenes) and outputs raw ciphertext.

###Key length

In addition to the optional arguments inherited from ```TemporaryFile```, ephemeral files can take an optional ```key_size``` argument, which defaults to `32`.  Supported key sizes are

- 16 (16 bytes = 128 bits)
- 24 (25 bytes = 192 bits)
- 32 (32 bytes = 256 bits)

Technical Details
========

Ephemeral uses AES-CTR with a default key-length of 256 bits.  The counter function is a simple 64-bit integer incrementation function with a 64-bit, randomly-generated, nonce prepended to the counter block (final counter size:  128 bits).
