/**
 * almond 0.2.6 Copyright (c) 2011-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */

/**
 * vkBeautify - javascript plugin to pretty-print or minify text in XML, JSON, CSS and SQL formats.
 *
 * Version - 0.99.00.beta
 * Copyright (c) 2012 Vadim Kiryukhin
 * vkiryukhin @ gmail.com
 * http://www.eslinstructor.net/vkbeautify/
 *
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 *   Pretty print
 *
 *        vkbeautify.xml(text [,indent_pattern]);
 *        vkbeautify.json(text [,indent_pattern]);
 *        vkbeautify.css(text [,indent_pattern]);
 *        vkbeautify.sql(text [,indent_pattern]);
 *
 *        @text - String; text to beatufy;
 *        @indent_pattern - Integer | String;
 *                Integer:  number of white spaces;
 *                String:   character string to visualize indentation ( can also be a set of white spaces )
 *   Minify
 *
 *        vkbeautify.xmlmin(text [,preserve_comments]);
 *        vkbeautify.jsonmin(text);
 *        vkbeautify.cssmin(text [,preserve_comments]);
 *        vkbeautify.sqlmin(text);
 *
 *        @text - String; text to minify;
 *        @preserve_comments - Bool; [optional];
 *                Set this flag to true to prevent removing comments from @text ( minxml and mincss functions only. )
 *
 *   Examples:
 *        vkbeautify.xml(text); // pretty print XML
 *        vkbeautify.json(text, 4 ); // pretty print JSON
 *        vkbeautify.css(text, '. . . .'); // pretty print CSS
 *        vkbeautify.sql(text, '----'); // pretty print SQL
 *
 *        vkbeautify.xmlmin(text, true);// minify XML, preserve comments
 *        vkbeautify.jsonmin(text);// minify JSON
 *        vkbeautify.cssmin(text);// minify CSS, remove comments ( default )
 *        vkbeautify.sqlmin(text);// minify SQL
 *
 */

/*! @source http://purl.eligrey.com/github/FileSaver.js/blob/master/FileSaver.js */

/**
 * complete.ly 1.0.0
 * MIT Licensing
 * Copyright (c) 2013 Lorenzo Puccetti
 * 
 * This Software shall be used for doing good things, not bad things.
 *
 * Liberally modified by Zachary King (c) 2014.
 * 
 **/

(function(e,t){typeof define=="function"&&define.amd?define("escher",t):e.escher=t()})(this,function(){var e,t,n;(function(r){function d(e,t){return h.call(e,t)}function v(e,t){var n,r,i,s,o,u,a,f,c,h,p=t&&t.split("/"),d=l.map,v=d&&d["*"]||{};if(e&&e.charAt(0)===".")if(t){p=p.slice(0,p.length-1),e=p.concat(e.split("/"));for(f=0;f<e.length;f+=1){h=e[f];if(h===".")e.splice(f,1),f-=1;else if(h===".."){if(f===1&&(e[2]===".."||e[0]===".."))break;f>0&&(e.splice(f-1,2),f-=2)}}e=e.join("/")}else e.indexOf("./")===0&&(e=e.substring(2));if((p||v)&&d){n=e.split("/");for(f=n.length;f>0;f-=1){r=n.slice(0,f).join("/");if(p)for(c=p.length;c>0;c-=1){i=d[p.slice(0,c).join("/")];if(i){i=i[r];if(i){s=i,o=f;break}}}if(s)break;!u&&v&&v[r]&&(u=v[r],a=f)}!s&&u&&(s=u,o=a),s&&(n.splice(0,o,s),e=n.join("/"))}return e}function m(e,t){return function(){return s.apply(r,p.call(arguments,0).concat([e,t]))}}function g(e){return function(t){return v(t,e)}}function y(e){return function(t){a[e]=t}}function b(e){if(d(f,e)){var t=f[e];delete f[e],c[e]=!0,i.apply(r,t)}if(!d(a,e)&&!d(c,e))throw new Error("No "+e);return a[e]}function w(e){var t,n=e?e.indexOf("!"):-1;return n>-1&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function E(e){return function(){return l&&l.config&&l.config[e]||{}}}var i,s,o,u,a={},f={},l={},c={},h=Object.prototype.hasOwnProperty,p=[].slice;o=function(e,t){var n,r=w(e),i=r[0];return e=r[1],i&&(i=v(i,t),n=b(i)),i?n&&n.normalize?e=n.normalize(e,g(t)):e=v(e,t):(e=v(e,t),r=w(e),i=r[0],e=r[1],i&&(n=b(i))),{f:i?i+"!"+e:e,n:e,pr:i,p:n}},u={require:function(e){return m(e)},exports:function(e){var t=a[e];return typeof t!="undefined"?t:a[e]={}},module:function(e){return{id:e,uri:"",exports:a[e],config:E(e)}}},i=function(e,t,n,i){var s,l,h,p,v,g=[],w;i=i||e;if(typeof n=="function"){t=!t.length&&n.length?["require","exports","module"]:t;for(v=0;v<t.length;v+=1){p=o(t[v],i),l=p.f;if(l==="require")g[v]=u.require(e);else if(l==="exports")g[v]=u.exports(e),w=!0;else if(l==="module")s=g[v]=u.module(e);else if(d(a,l)||d(f,l)||d(c,l))g[v]=b(l);else{if(!p.p)throw new Error(e+" missing "+l);p.p.load(p.n,m(i,!0),y(l),{}),g[v]=a[l]}}h=n.apply(a[e],g);if(e)if(s&&s.exports!==r&&s.exports!==a[e])a[e]=s.exports;else if(h!==r||!w)a[e]=h}else e&&(a[e]=n)},e=t=s=function(e,t,n,a,f){return typeof e=="string"?u[e]?u[e](t):b(o(e,t).f):(e.splice||(l=e,t.splice?(e=t,t=n,n=null):e=r),t=t||function(){},typeof n=="function"&&(n=a,a=f),a?i(r,e,t,n):setTimeout(function(){i(r,e,t,n)},4),s)},s.config=function(e){return l=e,l.deps&&s(l.deps,l.callback),s},e._defined=a,n=function(e,t,n){t.splice||(n=t,t=[]),!d(a,e)&&!d(f,e)&&(f[e]=[e,t,n])},n.amd={jQuery:!0}})(),n("../build/almond",function(){}),n("lib/vkbeautify",[],function(){function e(e){var t="    ";if(isNaN(parseInt(e)))t=e;else switch(e){case 1:t=" ";break;case 2:t="  ";break;case 3:t="   ";break;case 4:t="    ";break;case 5:t="     ";break;case 6:t="      ";break;case 7:t="       ";break;case 8:t="        ";break;case 9:t="         ";break;case 10:t="          ";break;case 11:t="           ";break;case 12:t="            "}var n=["\n"];for(ix=0;ix<100;ix++)n.push(n[ix]+t);return n}function t(){this.step="    ",this.shift=e(this.step)}function n(e,t){return t-(e.replace(/\(/g,"").length-e.replace(/\)/g,"").length)}function r(e,t){return e.replace(/\s{1,}/g," ").replace(/ AND /ig,"~::~"+t+t+"AND ").replace(/ BETWEEN /ig,"~::~"+t+"BETWEEN ").replace(/ CASE /ig,"~::~"+t+"CASE ").replace(/ ELSE /ig,"~::~"+t+"ELSE ").replace(/ END /ig,"~::~"+t+"END ").replace(/ FROM /ig,"~::~FROM ").replace(/ GROUP\s{1,}BY/ig,"~::~GROUP BY ").replace(/ HAVING /ig,"~::~HAVING ").replace(/ IN /ig," IN ").replace(/ JOIN /ig,"~::~JOIN ").replace(/ CROSS~::~{1,}JOIN /ig,"~::~CROSS JOIN ").replace(/ INNER~::~{1,}JOIN /ig,"~::~INNER JOIN ").replace(/ LEFT~::~{1,}JOIN /ig,"~::~LEFT JOIN ").replace(/ RIGHT~::~{1,}JOIN /ig,"~::~RIGHT JOIN ").replace(/ ON /ig,"~::~"+t+"ON ").replace(/ OR /ig,"~::~"+t+t+"OR ").replace(/ ORDER\s{1,}BY/ig,"~::~ORDER BY ").replace(/ OVER /ig,"~::~"+t+"OVER ").replace(/\(\s{0,}SELECT /ig,"~::~(SELECT ").replace(/\)\s{0,}SELECT /ig,")~::~SELECT ").replace(/ THEN /ig," THEN~::~"+t+"").replace(/ UNION /ig,"~::~UNION~::~").replace(/ USING /ig,"~::~USING ").replace(/ WHEN /ig,"~::~"+t+"WHEN ").replace(/ WHERE /ig,"~::~WHERE ").replace(/ WITH /ig,"~::~WITH ").replace(/ ALL /ig," ALL ").replace(/ AS /ig," AS ").replace(/ ASC /ig," ASC ").replace(/ DESC /ig," DESC ").replace(/ DISTINCT /ig," DISTINCT ").replace(/ EXISTS /ig," EXISTS ").replace(/ NOT /ig," NOT ").replace(/ NULL /ig," NULL ").replace(/ LIKE /ig," LIKE ").replace(/\s{0,}SELECT /ig,"SELECT ").replace(/\s{0,}UPDATE /ig,"UPDATE ").replace(/ SET /ig," SET ").replace(/~::~{1,}/g,"~::~").split("~::~")}return t.prototype.xml=function(t,n){var r=t.replace(/>\s{0,}</g,"><").replace(/</g,"~::~<").replace(/\s*xmlns\:/g,"~::~xmlns:").replace(/\s*xmlns\=/g,"~::~xmlns=").split("~::~"),i=r.length,s=!1,o=0,u="",a=0,f=n?e(n):this.shift;for(a=0;a<i;a++)if(r[a].search(/<!/)>-1){u+=f[o]+r[a],s=!0;if(r[a].search(/-->/)>-1||r[a].search(/\]>/)>-1||r[a].search(/!DOCTYPE/)>-1)s=!1}else r[a].search(/-->/)>-1||r[a].search(/\]>/)>-1?(u+=r[a],s=!1):/^<\w/.exec(r[a-1])&&/^<\/\w/.exec(r[a])&&/^<[\w:\-\.\,]+/.exec(r[a-1])==/^<\/[\w:\-\.\,]+/.exec(r[a])[0].replace("/","")?(u+=r[a],s||o--):r[a].search(/<\w/)>-1&&r[a].search(/<\//)==-1&&r[a].search(/\/>/)==-1?u=s?u+=r[a]:u+=f[o++]+r[a]:r[a].search(/<\w/)>-1&&r[a].search(/<\//)>-1?u=s?u+=r[a]:u+=f[o]+r[a]:r[a].search(/<\//)>-1?u=s?u+=r[a]:u+=f[--o]+r[a]:r[a].search(/\/>/)>-1?u=s?u+=r[a]:u+=f[o]+r[a]:r[a].search(/<\?/)>-1?u+=f[o]+r[a]:r[a].search(/xmlns\:/)>-1||r[a].search(/xmlns\=/)>-1?u+=f[o]+r[a]:u+=r[a];return u[0]=="\n"?u.slice(1):u},t.prototype.json=function(e,t){var t=t?t:this.step;return typeof JSON=="undefined"?e:typeof e=="string"?JSON.stringify(JSON.parse(e),null,t):typeof e=="object"?JSON.stringify(e,null,t):e},t.prototype.css=function(t,n){var r=t.replace(/\s{1,}/g," ").replace(/\{/g,"{~::~").replace(/\}/g,"~::~}~::~").replace(/\;/g,";~::~").replace(/\/\*/g,"~::~/*").replace(/\*\//g,"*/~::~").replace(/~::~\s{0,}~::~/g,"~::~").split("~::~"),i=r.length,s=0,o="",u=0,a=n?e(n):this.shift;for(u=0;u<i;u++)/\{/.exec(r[u])?o+=a[s++]+r[u]:/\}/.exec(r[u])?o+=a[--s]+r[u]:/\*\\/.exec(r[u])?o+=a[s]+r[u]:o+=a[s]+r[u];return o.replace(/^\n{1,}/,"")},t.prototype.sql=function(t,i){var s=t.replace(/\s{1,}/g," ").replace(/\'/ig,"~::~'").split("~::~"),o=s.length,u=[],a=0,f=this.step,l=!0,c=!1,h=0,p="",d=0,v=i?e(i):this.shift;for(d=0;d<o;d++)d%2?u=u.concat(s[d]):u=u.concat(r(s[d],f));o=u.length;for(d=0;d<o;d++){h=n(u[d],h),/\s{0,}\s{0,}SELECT\s{0,}/.exec(u[d])&&(u[d]=u[d].replace(/\,/g,",\n"+f+f+"")),/\s{0,}\s{0,}SET\s{0,}/.exec(u[d])&&(u[d]=u[d].replace(/\,/g,",\n"+f+f+"")),/\s{0,}\(\s{0,}SELECT\s{0,}/.exec(u[d])?(a++,p+=v[a]+u[d]):/\'/.exec(u[d])?(h<1&&a&&a--,p+=u[d]):(p+=v[a]+u[d],h<1&&a&&a--);var m=0}return p=p.replace(/^\n{1,}/,"").replace(/\n{1,}/g,"\n"),p},t.prototype.xmlmin=function(e,t){var n=t?e:e.replace(/\<![ \r\n\t]*(--([^\-]|[\r\n]|-[^\-])*--[ \r\n\t]*)\>/g,"").replace(/[ \r\n\t]{1,}xmlns/g," xmlns");return n.replace(/>\s{0,}</g,"><")},t.prototype.jsonmin=function(e){return typeof JSON=="undefined"?e:JSON.stringify(JSON.parse(e),null,0)},t.prototype.cssmin=function(e,t){var n=t?e:e.replace(/\/\*([^*]|[\r\n]|(\*+([^*/]|[\r\n])))*\*+\//g,"");return n.replace(/\s{1,}/g," ").replace(/\{\s{1,}/g,"{").replace(/\}\s{1,}/g,"}").replace(/\;\s{1,}/g,";").replace(/\/\*\s{1,}/g,"/*").replace(/\*\/\s{1,}/g,"*/")},t.prototype.sqlmin=function(e){return e.replace(/\s{1,}/g," ").replace(/\s{1,}\(/,"(").replace(/\s{1,}\)/,")")},new t});var r=r||"undefined"!=typeof navigator&&navigator.msSaveOrOpenBlob&&navigator.msSaveOrOpenBlob.bind(navigator)||function(e){if("undefined"==typeof navigator||!/MSIE [1-9]\./.test(navigator.userAgent)){var t=e.document,n=t.createElementNS("http://www.w3.org/1999/xhtml","a"),r="download"in n,i=function(n){var r=t.createEvent("MouseEvents");r.initMouseEvent("click",!0,!1,e,0,0,0,0,0,!1,!1,!1,!1,0,null),n.dispatchEvent(r)},s=e.webkitRequestFileSystem,o=e.requestFileSystem||s||e.mozRequestFileSystem,u=function(t){(e.setImmediate||e.setTimeout)(function(){throw t},0)},a=0,f=function(t){var n=function(){"string"==typeof t?(e.URL||e.webkitURL||e).revokeObjectURL(t):t.remove()};e.chrome?n():setTimeout(n,10)},l=function(e,t,n){t=[].concat(t);for(var r=t.length;r--;){var i=e["on"+t[r]];if("function"==typeof i)try{i.call(e,n||e)}catch(s){u(s)}}},c=function(t,u){var c=this,h=t.type,p=!1,d,v,m=function(){l(c,["writestart","progress","write","writeend"])},g=function(){if(p||!d)d=(e.URL||e.webkitURL||e).createObjectURL(t);v?v.location.href=d:void 0==e.open(d,"_blank")&&"undefined"!=typeof safari&&(e.location.href=d),c.readyState=c.DONE,m(),f(d)},y=function(e){return function(){if(c.readyState!==c.DONE)return e.apply(this,arguments)}},b={create:!0,exclusive:!1},E;c.readyState=c.INIT,u||(u="download");if(r)d=(e.URL||e.webkitURL||e).createObjectURL(t),n.href=d,n.download=u,i(n),c.readyState=c.DONE,m(),f(d);else{e.chrome&&h&&"application/octet-stream"!==h&&(E=t.slice||t.webkitSlice,t=E.call(t,0,t.size,"application/octet-stream"),p=!0),s&&"download"!==u&&(u+=".download");if("application/octet-stream"===h||s)v=e;o?(a+=t.size,o(e.TEMPORARY,a,y(function(e){e.root.getDirectory("saved",b,y(function(e){var n=function(){e.getFile(u,b,y(function(e){e.createWriter(y(function(n){n.onwriteend=function(t){v.location.href=e.toURL(),c.readyState=c.DONE,l(c,"writeend",t),f(e)},n.onerror=function(){var e=n.error;e.code!==e.ABORT_ERR&&g()},["writestart","progress","write","abort"].forEach(function(e){n["on"+e]=c["on"+e]}),n.write(t),c.abort=function(){n.abort(),c.readyState=c.DONE},c.readyState=c.WRITING}),g)}),g)};e.getFile(u,{create:!1},y(function(e){e.remove(),n()}),y(function(e){e.code===e.NOT_FOUND_ERR?n():g()}))}),g)}),g)):g()}},h=c.prototype;return h.abort=function(){this.readyState=this.DONE,l(this,"abort")},h.readyState=h.INIT=0,h.WRITING=1,h.DONE=2,h.error=h.onwritestart=h.onprogress=h.onwrite=h.onabort=h.onerror=h.onwriteend=null,function(e,t){return new c(e,t)}}}("undefined"!=typeof self&&self||"undefined"!=typeof window&&window||this.content);return"undefined"!=typeof module&&null!==module?module.exports=r:"undefined"!=typeof n&&null!==n&&null!=n.amd&&n("lib/FileSaver",[],function(){return r}),n("utils",["lib/vkbeautify","lib/FileSaver"],function(e,t){function n(e,t,n){if(e===undefined||e===null)return t;var r=-1,i={};for(var s in t){var o=s in e&&e[s]!==null&&e[s]!==undefined,u=o?e[s]:t[s];n&&s in n&&(u=parseFloat(u),isNaN(u)&&(o?(console.warn("Bad float for option "+s),u=parseFloat(t[s]),isNaN(u)&&(console.warn("Bad float for default "+s),u=null)):(console.warn("Bad float for default "+s),u=null))),i[s]=u}return i}function r(e,t,n){var r=function(e,t){e&&(d3.select("body").classed("fill-screen-body",!0),t.classed("fill-screen-div",!0));var n=t.append("svg").attr("class","escher-svg").attr("xmlns","http://www.w3.org/2000/svg");return n},i;e.classed("escher-container",!0);if(t)return e;if(e)return r(n,e);throw new Error("No selection")}function i(e){var t=e.node();while(t.hasChildNodes())t.removeChild(t.lastChild)}function s(e,t){var n="";return e&&d3.text(e,function(e,r){e&&console.warn(e),n=r,t(n)}),!1}function o(){return"omg yes"}function u(e,t,n,r){function i(e,t){return e.indexOf(t,e.length-t.length)!==-1}if(r){t&&console.warn("File "+t+" overridden by value."),n.call(e,null,r,t);return}if(!t){n.call(e,"No filename",null,t);return}i(t,"json")?d3.json(t,function(e,r){n(e,r,t)}):i(t,"css")?d3.text(t,function(e,r){n(e,r,t)}):n.call(e,"Unrecognized file type",null,t);return}function a(e,t,n){var r=-1,i=t.length,s={};while(++r<t.length){var o=t[r].file;s[o]=t[r].callback,u(e,o,function(t,r,o){s[o].call(e,t,r),--i||n.call(e)},t[r].value)}}function f(){var e,t=function(n){if(!(this instanceof t)){e=!0;var r=new t(arguments);return e=!1,r}typeof this.init=="function"&&this.init.apply(this,e?n:arguments)};return t}function l(e,t){e.select("defs").remove();var n=e.append("defs"),r=n.node();return r.parentNode.insertBefore(r,r.parentNode.firstChild),n.append("style").attr("type","text/css").text(t),n}function c(e,t,n,r,i,s,o,u){var a={};for(var f in r)r[f]===undefined?console.warn("Undefined value for id "+f+" in object. Ignoring."):a[f]=r[f];var l=e.select(t).selectAll(n).data(d(a,i),function(e){return e[i]});s&&l.enter().call(s),o&&l.call(o),u&&l.exit().call(u)}function h(e,t,n,r,i,s,o){var u=e.selectAll(t).data(function(e){return d(e[n],r)},function(e){return e[r]});i&&u.enter().call(i),s&&u.call(s),o&&u.exit().call(o)}function p(e,t){var n=[];for(var r in e){var i=g(e[r]);i[t]=r,n.push(i)}return n}function d(e,t){var n=[];for(var r in e){var i=e[r];i[t]=r,n.push(i)}return n}function v(e,t){if(!e||!t)return!1;if(e.length!=t.length)return!1;for(var n=0,r=e.length;n<r;n++)if(e[n]!=t[n])return!1;return!0}function m(e){var t={};for(var n=0,r=e.length;n<r;n++){var i=e[n],s=Object.keys(i);for(var o=0,u=s.length;o<u;o++){var a=s[o];if(a in t)t[a][n]=i[a];else{var f=[];for(var l=0;l<r;l++)f[l]=null;f[n]=i[a],t[a]=f}}}return t}function g(e){if(null==e||"object"!=typeof e)return e;if(e instanceof Array){var t=[];for(var n=0,r=e.length;n<r;n++)t[n]=g(e[n]);return t}if(e instanceof Object){var t={};for(var i in e)e.hasOwnProperty(i)&&(t[i]=g(e[i]));return t}throw new Error("Unable to copy obj! Its type isn't supported.")}function y(e,t,n){n===undefined&&(n=!1);for(var r in t){if(r in e&&!n)throw new Error("Attribute "+r+" already in object.");e[r]=t[r]}}function b(e){var t=[];return e.forEach(function(e){e.forEach(function(e){t.indexOf(e)<0&&t.push(e)})}),t}function w(e,t){var n={},r=-1;while(++r<t.length)n[t[r]]=g(e[t[r]]);return t.length!=Object.keys(n).length&&console.warn("did not find correct reaction subset"),n}function E(e,t){var n={},r=-1;while(++r<t.length)n[t[r]]=e[t[r]];return t.length!=Object.keys(n).length&&console.warn("did not find correct reaction subset"),n}function S(e,t){return e===null||t===null||e===undefined||t===undefined?null:{x:e.x+t.x,y:e.y+t.y}}function x(e,t){return e===null||t===null||e===undefined||t===undefined?null:{x:e.x-t.x,y:e.y-t.y}}function T(e,t){return{x:e.x*t,y:e.y*t}}function N(e,n){var r=JSON.stringify(e),i=new Blob([r],{type:"octet/stream"});t(i,n+".json")}function C(e,t,n,r){window.File&&window.FileReader&&window.FileList&&window.Blob||t("The File APIs are not fully supported in this browser.",null);var i=new window.FileReader;i.onload=function(e){var n=e.target.result,r;try{r=JSON.parse(n)}catch(i){t(i,null);return}t(null,r)};if(n!==undefined&&n!==null)try{n()}catch(s){console.warn(s)}i.onabort=function(e){try{r()}catch(t){console.warn(t)}},i.onerror=function(e){try{r()}catch(t){console.warn(t)}},i.readAsText(e)}function k(e,t,n,r,i,s){window.File&&window.FileReader&&window.FileList&&window.Blob||n("The File APIs are not fully supported in this browser.",null);var o=new window.FileReader,u=function(e){var r=e.target.result,i,s;try{i=JSON.parse(r)}catch(o){s="JSON error: "+o;try{i=t(d3.csv.parseRows(r))}catch(o){n(s+"\nCSV error: "+o,null);return}}n(null,i)};if(s!==undefined&&s!==null)return console.warn("Debugging load_json_or_csv"),u(s);if(r!==undefined&&r!==null)try{r()}catch(a){console.warn(a)}o.onabort=function(e){try{i()}catch(t){console.warn(t)}},o.onerror=function(e){try{i()}catch(t){console.warn(t)}},o.onload=u,o.readAsText(e)}function L(t,n,r){function u(e){return window.btoa(unescape(encodeURIComponent(e)))}var i=document.createElement("a"),s,o;i.download=t+".svg",s=(new XMLSerializer).serializeToString(n.node()),r&&(s=e.xml(s)),s='<?xml version="1.0" encoding="utf-8"?>\n             <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN"\n         "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n'+s,i.setAttribute("href-lang","image/svg+xml"),i.href="data:image/svg+xml;base64,"+u(s),o=document.createEvent("MouseEvents"),o.initMouseEvent("click",!0,!1,self,0,0,0,0,0,!1,!1,!1,!1,0,null),i.dispatchEvent(o)}function A(e,t,n){var r=function(e){return O(e,t,n)};return e.map(r)}function O(e,t,n){var r=Math.cos(-t)*(e.x-n.x)+Math.sin(-t)*(e.y-n.y)+n.x-e.x,i=-Math.sin(-t)*(e.x-n.x)+Math.cos(-t)*(e.y-n.y)+n.y-e.y;return{x:r,y:i}}function M(e){var t=e[1].x-e[0].x,n=e[1].y-e[0].y;return t==0&&n>=0?Math.PI/2:t==0&&n<0?3*Math.PI/2:t>=0&&n>=0?Math.atan(n/t):t>=0?Math.atan(n/t)+2*Math.PI:Math.atan(n/t)+Math.PI}function _(e){return e*180/Math.PI}function D(e,t,n){var r=Math.atan2(t.x-n.x,n.y-t.y),i=Math.atan2(t.x-n.x+e.x,n.y-t.y-e.y),s=i-r;return s}function P(e,t){return Math.sqrt(Math.pow(t.y-e.y,2)+Math.pow(t.x-e.x,2))}function H(e,t){t.map(function(n,r){e[r]===undefined&&console.error("Argument is undefined: "+String(t[r]))})}function B(e,t){return e+"_"+t}function j(e){function n(e){var t=/(.*)_([a-z0-9]{1,2})$/,n=t.exec(e);return n===null?null:n.slice(1,3)}var t=n(e);return t===null&&(t=[e,null]),t}function F(e){var t=e.reduce(function(e,t){return e+t}),n=t/e.length;return n}function I(e){e.sort(function(e,t){return e-t});var t=Math.floor(e.length/2);return e.length%2==1?e[t]:(e[t-1]+e[t])/2}function q(e){e.sort(function(e,t){return e-t});var t=Math.floor(e.length/2);return e.length==1?[e[0],e[0],e[0]]:e.length%2==1?[I(e.slice(0,t)),e[t],I(e.slice(t+1))]:[I(e.slice(0,t)),(e[t-1]+e[t])/2,I(e.slice(t))]}function R(e){var t="",n="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";for(var r=0;r<e;r++)t+=n.charAt(Math.floor(Math.random()*n.length));return t}function U(e,t){e instanceof Array&&(e=e.node());while(e.parentNode!==null){e=e.parentNode;if(e.tagName===undefined)continue;if(e.tagName.toLowerCase()===t.toLowerCase())return!0}return!1}function z(e,t){return t!==undefined&&t!==null&&(t=t.replace(/^\/|\/$/g,""),e=[t,e].join("/")),e.replace(/^\/|\/$/g,"")+".json"}function W(e,t){t===undefined&&(t={});var n=e.location.search.substring(1),r=n.split("&");for(var i=0;i<r.length;i++){var s=r[i].split("="),o=decodeURIComponent(s[1]);if(s[0].indexOf("[]")==s[0].length-2){var u=s[0].replace("[]","");u in t||(t[u]=[]),t[u].push(o)}else t[s[0]]=o}return t}return{set_options:n,setup_svg:r,remove_child_nodes:i,load_css:s,load_files:a,load_the_file:u,make_class:f,setup_defs:l,draw_an_object:c,draw_a_nested_object:h,make_array:p,make_array_ref:d,compare_arrays:v,array_to_object:m,clone:g,extend:y,unique_concat:b,object_slice_for_ids:w,object_slice_for_ids_ref:E,c_plus_c:S,c_minus_c:x,c_times_scalar:T,download_json:N,load_json:C,load_json_or_csv:k,export_svg:L,rotate_coords_recursive:A,rotate_coords:O,get_angle:M,to_degrees:_,angle_for_event:D,distance:P,check_undefined:H,compartmentalize:B,decompartmentalize:j,mean:F,median:I,quartiles:q,random_characters:R,check_for_parent_tag:U,name_to_url:z,parse_url_components:W}}),n("PlacedDiv",["utils"],function(e){function n(e,t,n){this.div=e,n===undefined&&(n={x:0,y:0}),this.displacement=n,this.map=t}function r(){return this.div.style("display")!="none"}function i(e){this.div.style("display",null);var t=this.map.zoom_container.window_translate,n=this.map.zoom_container.window_scale,r=this.map.get_size(),i=Math.max(20,Math.min(r.width-270,n*e.x+t.x-this.displacement.x)),s=Math.max(20,Math.min(r.height-40,n*e.y+t.y-this.displacement.y));this.div.style("position","absolute").style("display","block").style("left",i+"px").style("top",s+"px")}function s(){this.div.style("display","none")}var t=e.make_class();return t.prototype={init:n,is_visible:r,place:i,hide:s},t}),n("lib/complete.ly",[],function(){return function(e,t){function h(e){return l===undefined&&(l=document.createElement("span"),l.style.visibility="hidden",l.style.position="fixed",l.style.outline="0",l.style.margin="0",l.style.padding="0",l.style.border="0",l.style.left="0",l.style.whiteSpace="pre",l.style.fontSize=t.fontSize,l.style.fontFamily=t.fontFamily,l.style.fontWeight="normal",document.body.appendChild(l)),l.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),l.getBoundingClientRect().right}t=t||{},t.fontSize=t.fontSize||"13px",t.fontFamily=t.fontFamily||"sans-serif",t.promptInnerHTML=t.promptInnerHTML||"",t.color=t.color||"#333",t.hintColor=t.hintColor||"#aaa",t.backgroundColor=t.backgroundColor||"#fff",t.dropDownBorderColor=t.dropDownBorderColor||"#aaa",t.dropDownZIndex=t.dropDownZIndex||"100",t.dropDownOnHoverBackgroundColor=t.dropDownOnHoverBackgroundColor||"#ddd";var n=document.createElement("input");n.type="text",n.spellcheck=!1,n.style.fontSize=t.fontSize,n.style.fontFamily=t.fontFamily,n.style.color=t.color,n.style.backgroundColor=t.backgroundColor,n.style.width="100%",n.style.outline="0",n.style.border="0",n.style.margin="0",n.style.padding="0";var r=n.cloneNode();r.disabled="",r.style.position="absolute",r.style.top="0",r.style.left="0",r.style.borderColor="transparent",r.style.boxShadow="none",r.style.color=t.hintColor,n.style.backgroundColor="transparent",n.style.verticalAlign="top",n.style.position="relative";var i=document.createElement("div");i.style.position="relative",i.style.outline="0",i.style.border="0",i.style.margin="0",i.style.padding="0";var s=document.createElement("div");s.style.position="absolute",s.style.outline="0",s.style.margin="0",s.style.padding="0",s.style.border="0",s.style.fontSize=t.fontSize,s.style.fontFamily=t.fontFamily,s.style.color=t.color,s.style.backgroundColor=t.backgroundColor,s.style.top="0",s.style.left="0",s.style.overflow="hidden",s.innerHTML=t.promptInnerHTML,s.style.background="transparent";if(document.body===undefined)throw"document.body is undefined. The library was wired up incorrectly.";document.body.appendChild(s);var o=s.getBoundingClientRect().right;i.appendChild(s),s.style.visibility="visible",s.style.left="-"+o+"px",i.style.marginLeft=o+"px",i.appendChild(r),i.appendChild(n);var u=document.createElement("div");u.style.position="absolute",u.style.visibility="hidden",u.style.outline="0",u.style.margin="0",u.style.padding="0",u.style.textAlign="left",u.style.fontSize=t.fontSize,u.style.fontFamily=t.fontFamily,u.style.backgroundColor=t.backgroundColor,u.style.zIndex=t.dropDownZIndex,u.style.cursor="default",u.style.borderStyle="solid",u.style.borderWidth="1px",u.style.borderColor=t.dropDownBorderColor,u.style.overflowX="hidden",u.style.whiteSpace="pre",u.style.overflowY="scroll";var a=function(e){var n=[],r=0,i=-1,s=null,o=function(){this.style.outline="1px solid #ddd"},u=function(){this.style.outline="0"},a=function(e){e.preventDefault(),f.onmouseselection(this.id)},f={hide:function(){e.style.visibility="hidden"},refresh:function(i,s){e.style.visibility="hidden",r=0,e.innerHTML="";var l=window.innerHeight||document.documentElement.clientHeight,c=e.parentNode.getBoundingClientRect(),h=c.top-6,d=l-c.bottom-6;n=[];for(var v=0;v<s.length;v++){var m=s[v].matches.filter(function(e){return e.toLowerCase().indexOf(i.toLowerCase())==0});if(m.length==0)continue;var g=document.createElement("div");g.style.color=t.color,g.onmouseover=o,g.onmouseout=u,g.onmousedown=function(e){e.preventDefault()},g.ondblclick=a,g.__hint=m[0],g.id=s[v].id,g.innerHTML=s[v].html,n.push(g),e.appendChild(g);if(n.length>=p.display_limit)break}if(n.length===0)return;f.highlight(0),h>d*3?(e.style.maxHeight=h+"px",e.style.top="",e.style.bottom="100%"):(e.style.top="100%",e.style.bottom="",e.style.maxHeight=d+"px"),e.style.visibility="visible"},highlight:function(e){i!=-1&&n[i]&&(n[i].style.backgroundColor=t.backgroundColor),n[e].style.backgroundColor=t.dropDownOnHoverBackgroundColor,i=e,s=n[e]},move:function(t){return e.style.visibility==="hidden"?"":r+t===-1||r+t===n.length?n[r].__hint:(r+=t,f.highlight(r),n[r].__hint)},onmouseselection:function(){},get_current_row:function(){return s}};return f},f=a(u);f.onmouseselection=function(e){p.onEnter(e),p.input.focus()},i.appendChild(u),e.appendChild(i);var l,c,p={get_hint:function(e){return e},display_limit:100,onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},onChange:function(){p.repaint()},startFrom:0,options:[],wrapper:i,input:n,hint:r,dropDown:u,prompt:s,setText:function(e){r.value=e,n.value=e},getText:function(){return n.value},hideDropDown:function(){f.hide()},repaint:function(){var e=n.value,t=p.startFrom,i=p.options,s=i.length,o=e.substring(t);c=e.substring(0,t),r.value="";for(var a=0;a<s;a++){var l=i[a].matches.filter(function(e){return e.toLowerCase().indexOf(o.toLowerCase())==0});if(l.length==0)continue;r.value=p.get_hint(l[0]);break}u.style.left=h(c)+"px",f.refresh(o,p.options)}},d,v=function(e,t){d=e.value;var n=function(){var n=e.value;d!==n&&(d=n,t(n))};e.addEventListener("input",n,!1),e.addEventListener("keyup",n,!1),e.addEventListener("change",n,!1)};v(n,function(e){p.onChange(e),p.repaint()});var m=function(e){e=e||window.event;var t=e.keyCode;if(t==33)return;if(t==34)return;if(t==39||t==35||t==9){t==9&&(e.preventDefault(),e.stopPropagation(),r.value.length==0&&p.onTab());if(r.value.length>0){n.value=r.value;var i=d!=n.value;d=n.value,i&&p.onChange(n.value)}return}if(t==13){var s=f.get_current_row().id;p.onEnter(s);return}if(t==40){var o=f.move(1);o==""&&p.onArrowDown(),r.value=p.get_hint(o);return}if(t==38){var o=f.move(-1);o==""&&p.onArrowUp(),r.value=p.get_hint(o),e.preventDefault(),e.stopPropagation();return}r.value=""};return n.addEventListener("keydown",m,!1),p}}),n("DirectionArrow",["utils"],function(e){function n(e){function t(){return"M0 -5 L0 5 L20 5 L20 10 L30 0 L20 -10 L20 -5 Z"}this.arrow_container=e.append("g").attr("id","direction-arrow-container").attr("transform","translate(0,0)rotate(0)"),this.arrow=this.arrow_container.append("path").classed("direction-arrow",!0).attr("d",t()).style("visibility","hidden").attr("transform","translate(30,0)scale(2.5)"),this.sel=e,this.center={x:0,y:0},this._setup_drag(),this.dragging=!1,this.is_visible=!1,this.show()}function r(e){this.center=e;var t=d3.transform(this.arrow_container.attr("transform"));this.arrow_container.attr("transform","translate("+e.x+","+e.y+")rotate("+t.rotate+")")}function i(e){var t=d3.transform(this.arrow_container.attr("transform"));this.arrow_container.attr("transform","translate("+t.translate+")rotate("+e+")")}function s(e){var t=d3.transform(this.arrow_container.attr("transform"));this.arrow_container.attr("transform","translate("+t.translate+")"+"rotate("+(t.rotate+e)+")")}function o(){return d3.transform(this.arrow_container.attr("transform")).rotate}function u(e){e===undefined?this.is_visible=!this.is_visible:this.is_visible=e,this.arrow.style("visibility",this.is_visible?"visible":"hidden")}function a(){this.toggle(!0)}function f(){this.toggle(!1)}function l(){this.set_rotation(0)}function c(){this.set_rotation(90)}function h(){this.set_rotation(180)}function p(){this.set_rotation(270)}function d(){var t=d3.behavior.drag().on("dragstart",function(e){d3.event.sourceEvent.stopPropagation(),this.dragging=!0}.bind(this)).on("drag.direction_arrow",function(t){var n={x:d3.event.dx,y:d3.event.dy},r={x:d3.mouse(this.sel.node())[0],y:d3.mouse(this.sel.node())[1]},i=e.angle_for_event(n,r,this.center);this.displace_rotation(e.to_degrees(i))}.bind(this)).on("dragend",function(e){window.setTimeout(function(){this.dragging=!1}.bind(this),200)}.bind(this));this.arrow_container.call(t)}var t=e.make_class();return t.prototype={init:n,set_location:r,set_rotation:i,displace_rotation:s,get_rotation:o,toggle:u,show:a,hide:f,right:l,left:h,up:p,down:c,_setup_drag:d},t}),n("data_styles",["utils"],function(e){function h(t,n,r){function s(e,t){var n={},r=[null];for(var i in e){r=e[i].map(function(){return null});break}for(var s in t){var o=t[s],u=o.bigg_id,a={},f=o.genes,l;typeof f=="undefined"?l=y(o.gene_reaction_rule):l=f.map(function(e){return e.bigg_id}),l.forEach(function(t){var n=e[t];typeof n=="undefined"&&(n=r),a[t]=n}),n[u]=a}return n}if(t===null)return null;if(["reaction_data","metabolite_data","gene_data"].indexOf(n)==-1)throw new Error("Invalid name argument: "+n);t instanceof Array||(t=[t]);var i=function(){return t===null?null:t.length==1?null:t.length==2?null:console.warn("Bad data style: "+n)};i(),t=e.array_to_object(t);if(n=="gene_data"){if(r===undefined)throw new Error("Must pass all_reactions argument for gene_data");t=s(t,r)}return t}function p(e,t,n){function o(e){return isFinite(e)?e:null}function u(e,t){return t?Math.abs(e):e}function a(e,t,n){return n?Math.abs(t-e):t-e}function f(e,t,n){return e==0||t==0?null:t>=e?t/e:-e/t}function l(e,t,n){if(e==0)return null;if(t/e<0)return null;var r=Math.log(t/e)/Math.log(2);return n?Math.abs(r):r}if(e===null)return null;var r=t.indexOf("abs")!=-1;if(e.length==1){var i=T(e[0]);return i===null?null:u(i,r)}if(e.length!=2)throw new Error("Data array must be of length 1 or 2");var s=e.map(T);if(s[0]===null||s[1]===null)return null;if(n=="diff")return a(s[0],s[1],r);if(n=="fold")return o(f(s[0],s[1],r));if(n=="log2_fold")return o(l(s[0],s[1],r));throw new Error("Bad data compare_style: "+n)}function d(e){return e===null||e[0]===null?!1:e[0]<0}function v(e,n,s,o,u,a){function c(e,t){return e===null?"nd":t(e)}var f=e,l=n===null;return s.forEach(function(e){var r=e[u];if(r===undefined)throw new Error("Bad value for identifiers_on_map: "+u);if(l)f=w(f,e.bigg_id,r+"\n");else{var i=n[e.bigg_id];typeof i=="undefined"&&(i=null);var s=p(i,o,a),h=s===null?t:d3.format(".3g");if(i.length==1)f=w(f,e.bigg_id,r+" ("+c(i[0],h)+")\n");else if(i.length==2){var d,v=i.reduce(function(e,t){return e||T(t)!==null},!1);v?d=r+" ("+c(i[0],h)+", "+c(i[1],h)+": "+c(s,h)+")\n":d=r+" ("+c(i[0],h)+", "+c(i[1],h)+")\n",f=w(f,e.bigg_id,d)}}}),f=f.replace(r,"\n").replace(i,"$1"),f}function m(e,n){function s(e,t){return e===null?"(nd)":t(e)}if(e===null)return s(null);if(e.length==1){var r=n===null?t:d3.format(".3g");return s(e[0],r)}if(e.length==2){var r=n===null?t:d3.format(".3g"),i=s(e[0],r);return i+=", "+s(e[1],r),i+=": "+s(n,r),i}return""}function g(e){var t=e[0].length,n=[];if(t<2||t>3)throw new Error("CSV file must have 2 or 3 columns");for(var r=1;r<t;r++)n[r-1]={};return e.slice(1).forEach(function(e){for(var t=1,r=e.length;t<r;t++)n[t-1][e[0]]=e[t]}),n}function y(e){var t=e.replace(s,"$1$2").replace(o,"").split(" ").filter(function(e){return e!=""});return t}function b(e,t,n){var r=[null],i=1;for(var s in t){r=t[s].map(function(){return null}),i=r.length;break}if(e=="")return r;var o=[];for(var h=0;h<i;h++){var p=e,d=!0;for(var s in t){var v=T(t[s][h]);v===null||v<0?v=0:d=!1,p=w(p,s,v)}if(d){o.push(null);continue}for(;;){var m=p;m=m.replace(u," $1 "),m=m.replace(l,function(e,t,n,r){var i=n.split(a).map(parseFloat),s=i.reduce(function(e,t){return e+t});return t+s+r}),m=m.replace(c,function(e,t,r,i){var s=r.split(f).map(parseFloat),o=n=="min"?Math.min.apply(null,s):s.reduce(function(e,t){return e+t})/s.length;return t+o+i});if(m==p)break;p=m}var g=Number(p);isNaN(g)?(console.warn("Could not evaluate "+e),o.push(null)):o.push(g)}return o}function w(e,t,r){function u(e){return e.replace(n,"\\$1")}var i="(^|[\\s\\(\\)])",s="([\\s\\(\\)]|$)",o=i+u(t)+s;return e.replace(new RegExp(o,"g"),"$1"+r+"$2")}function E(e,t,n,r){if(t===null){for(var i in e){var s=e[i];s.data=null,s.data_string="";for(var o in s.segments){var u=s.segments[o];u.data=null}s.gene_string=null}return!1}for(var i in e){var s=e[i],a=s.bigg_id in t?t[s.bigg_id]:null,f=p(a,n,r),l=d(a),c=m(a,f);s.data=f,s.data_string=c,s.reverse_flux=l,s.gene_string=null;for(var o in s.segments){var u=s.segments[o];u.data=s.data,u.reverse_flux=s.reverse_flux}}return!0}function S(e,t,n,r){if(t===null){for(var i in e)e[i].data=null,e[i].data_string="";return!1}for(var i in e){var s=e[i],o=s.bigg_id in t?t[s.bigg_id]:null,u=p(o,n,r),a=m(o,u);s.data=u,s.data_string=a}return!0}function x(e,t,n,r,i,s){if(t===null){for(var o in e){var u=e[o];u.data=null,u.data_string="",u.reverse_flux=!1;for(var a in u.segments){var f=u.segments[a];f.data=null}u.gene_string=null}return!1}var l=[null];for(var o in t){for(var c in t[o]){l=t[o][c].map(function(){return null});break}break}for(var o in e){var u=e[o],h=u.gene_reaction_rule,g,y,w=t[u.bigg_id];typeof w!="undefined"?(y=w,g=b(h,y,s)):(y={},g=l);var E=p(g,n,i),S=d(g),x=m(g,E);u.data=E,u.data_string=x,u.reverse_flux=S;for(var a in u.segments){var f=u.segments[a];f.data=u.data,f.reverse_flux=u.reverse_flux}u.gene_string=v(h,y,u.genes,n,r,i)}return!0}function T(e){var t=Number(e);return isNaN(t)||parseFloat(e)!=t?null:t}var t=function(e){return e},n=/([.*+?^=!:${}()|\[\]\/\\])/g,r=/\n\s*\n/g,i=/\n\s*(\)*)\s*$/,s=/([\(\) ])(?:and|or)([\)\( ])/ig,o=/[\(\)]/g,u=/\(\s*(\S+)\s*\)/g,a=/\s+or\s+/i,f=/\s+and\s+/i,l=/(^|\()(\s*-?[0-9.]+\s+(?:or\s+-?[0-9.]+\s*)+)(\)|$)/ig,c=/(^|\(|or\s)(\s*-?[0-9.]+\s+(?:and\s+-?[0-9.]+\s*)+)(\sor|\)|$)/ig;return{import_and_check:h,text_for_data:m,float_for_data:p,reverse_flux_for_data:d,gene_string_for_data:v,csv_converter:g,genes_for_gene_reaction_rule:y,evaluate_gene_reaction_rule:b,replace_gene_in_rule:w,apply_reaction_data_to_reactions:E,apply_metabolite_data_to_nodes:S,apply_gene_data_to_reactions:x}}),n("CobraModel",["utils","data_styles"],function(e,t){function r(e,t){var n=function(e){return e==1?"":String(e)+" "},r={},i={},s=[],o=[];for(var u in e){var a=e[u];a>0?o.push(n(a)+u):s.push(n(Math.abs(a))+u)}var f=s.join(" + ");return t?f+=" ↔ ":f+=" → ",f+=o.join(" + "),f}function i(e){if(!e.reactions||!e.metabolites)throw new Error("Bad model data.");var t=new n;return t.reactions=e.reactions,t.metabolites=e.metabolites,t}function s(r){if(!r.reactions||!r.metabolites)throw new Error("Bad model data.");var i={};for(var s=0,o=r.genes.length;s<o;s++){var u=r.genes[s],a=u.id;i[a]=u}var f=new n;f.reactions={};for(var s=0,o=r.reactions.length;s<o;s++){var u=r.reactions[s],a=u.id,l=e.clone(u);delete l.id,l.bigg_id=a,l.genes=[],l.reversibility=l.lower_bound<0&&l.upper_bound>0;if(l.upper_bound<=0&&l.lower_bound<0)for(var c in l.metabolites)l.metabolites[c]=-l.metabolites[c];delete l.lower_bound,delete l.upper_bound;if("gene_reaction_rule"in l){var h=t.genes_for_gene_reaction_rule(l.gene_reaction_rule);h.forEach(function(t){if(t in i){var n=e.clone(i[t]);n.bigg_id=n.id,delete n.id,l.genes.push(n)}else console.warn("Could not find gene for gene_id "+t)})}f.reactions[a]=l}f.metabolites={};for(var s=0,o=r.metabolites.length;s<o;s++){var u=r.metabolites[s],a=u.id,p=e.clone(u);delete p.id,p.bigg_id=a,f.metabolites[a]=p}return f}function o(){this.reactions={},this.metabolites={},this.cofactors=["atp","adp","nad","nadh","nadp","nadph","gtp","gdp","h","coa"]}function u(e,n,r){t.apply_reaction_data_to_reactions(this.reactions,e,n,r)}function a(e,n,r){t.apply_metabolite_data_to_nodes(this.metabolites,e,n,r)}function f(e,n,r,i,s){t.apply_gene_data_to_reactions(this.reactions,e,n,r,i,s)}function l(){return{reactions:this.reactions,metabolites:this.metabolites}}var n=e.make_class();return n.from_exported_data=i,n.from_cobra_json=s,n.build_reaction_string=r,n.prototype={init:o,apply_reaction_data:u,apply_metabolite_data:a,apply_gene_data:f,model_for_export:l},n}),n("BuildInput",["utils","PlacedDiv","lib/complete.ly","DirectionArrow","CobraModel"],function(e,t,n,r,i){function o(e,i,s,o){var u=e.append("div").attr("id","rxn-input");this.placed_div=t(u,i,{x:240,y:0}),this.placed_div.hide();var a=n(u.node(),{backgroundColor:"#eee"});d3.select(a.input),this.completely=a,u.append("button").attr("class","button input-close-button").text("×").on("mousedown",function(){this.hide_dropdown()}.bind(this)),this.map=i;var f=90;this.direction_arrow=new r(i.sel),this.direction_arrow.set_rotation(f),this.setup_map_callbacks(i),this.zoom_container=s,this.setup_zoom_callbacks(s),this.settings=o,this.toggle(!1),this.target_coords=null}function u(e){e.callback_manager.set("select_metabolite_with_id.input",function(e,t){this.is_active&&this.reload(e,t,!1),this.hide_target()}.bind(this)),e.callback_manager.set("select_selectable.input",function(e,t,n){this.hide_target(),e==1&&this.is_active&&n?this.reload(t,n,!1):this.toggle(!1)}.bind(this)),e.callback_manager.set("deselect_nodes",function(){this.direction_arrow.hide(),this.hide_dropdown()}.bind(this)),e.callback_manager.set("before_svg_export",function(){this.direction_arrow.hide(),this.hide_target()}.bind(this))}function a(e){e.callback_manager.set("zoom.input",function(){this.is_active&&this.place_at_selected()}.bind(this))}function f(){return this.placed_div.is_visible()}function l(e){e===undefined?this.is_active=!this.is_active:this.is_active=e,this.is_active?(this.toggle_start_reaction_listener(!0),this.target_coords!==null?this.show_dropdown(this.target_coords):this.reload_at_selected(),this.map.set_status("Click on the canvas or an existing metabolite"),this.direction_arrow.show(),this.escape=this.map.key_manager.add_escape_listener(function(){this.hide_dropdown()}.bind(this),"build_input")):(this.toggle_start_reaction_listener(!1),this.placed_div.hide(),this.completely.input.blur(),this.completely.hideDropDown(),this.map.set_status(null),this.direction_arrow.hide(),this.escape&&this.escape.clear(),this.escape=null)}function c(e){this.placed_div.place(e),this.completely.input.blur(),this.completely.repaint(),this.completely.setText(""),this.completely.input.focus()}function h(){this.placed_div.hide(),this.completely.hideDropDown()}function p(){this.map.deselect_text_labels();var e=this.map.select_single_node();if(e==null)return;var t={x:e.x,y:e.y};this.place(t)}function d(e){this.placed_div.place(e),this.direction_arrow.set_location(e),this.direction_arrow.show()}function v(){this.map.deselect_text_labels();var e=this.map.select_single_node();if(e==null)return!1;var t={x:e.x,y:e.y};return this.reload(e,t,!1),!0}function m(t,n,r){function H(e,t){for(var n in t)if(t[n].bigg_id==e)return!0;return!1}if(!r&&!t){console.error("No selected node, and not starting from scratch");return}this.place(n),this.completely.input.blur(),this.completely.repaint();if(this.map.cobra_model===null){this.completely.setText("Cannot add: No model.");return}var s=this.settings.get_option("identifiers_on_map")=="name",o=this.settings.get_option("allow_building_duplicate_reactions"),u=[],a=this.map.cobra_model.reactions,f=this.map.cobra_model.metabolites,l=this.map.reactions,c=this.map.has_data_on_reactions,h=this.map.reaction_data,p=this.map.reaction_data_styles,d=t?s?t.name:t.bigg_id:"",v=function(e,t){return e.replace(new RegExp("(^| )("+t.join("|")+")($| )","g"),"$1<b>$2</b>$3")},m={};for(var g in a){var y=a[g],b=y.name,w=s?b:g;if(!o&&H(g,l))continue;for(var E in y.metabolites)if(r||E==t.bigg_id){if(g in m)continue;var S=f[E].name;if(c)u.push({reaction_data:y.data,html:"<b>"+w+"</b>"+": "+y.data_string,matches:[w],id:g}),m[g]=!0;else{var x={},T=[];if(s)for(var N in y.metabolites){var C=f[N].name;x[C]=y.metabolites[N],T.push(C)}else{x=e.clone(y.metabolites);for(var N in y.metabolites)T.push(N)}var k=s?"name":"bigg_id",L=y.genes.map(function(e){return e[k]}),A=i.build_reaction_string(x,y.reversibility,y.lower_bound,y.upper_bound);u.push({html:"<b>"+w+"</b>"+"	"+v(A,[d]),matches:[w].concat(T).concat(L),id:g}),m[g]=!0}}}var O;c?O=function(e,t){return Math.abs(t.reaction_data)-Math.abs(e.reaction_data)}:O=function(e,t){return e.html.toLowerCase()<t.html.toLowerCase()?-1:1},u=u.sort(O);var M=20,_=this.completely;_.options=u,_.setText("");var D=this.direction_arrow,P=function(e){if(e!==null)if(r)this.map.new_reaction_from_scratch(e,n,D.get_rotation());else{if(!(t.node_id in this.map.nodes)){console.error("Selected node no longer exists"),this.hide_dropdown();return}this.map.new_reaction_for_metabolite(e,t.node_id,D.get_rotation())}}.bind(this);_.onEnter=function(e){this.setText(""),this.onChange(""),P(e)},_.repaint(),this.completely.input.focus()}function g(e){if(e===undefined)this.start_reaction_listener=!this.start_reaction_listener;else{if(this.start_reaction_listener==e)return;this.start_reaction_listener=e}this.start_reaction_listener?(this.map.sel.on("click.start_reaction",function(e){if(this.direction_arrow.dragging)return;var t={x:d3.mouse(e)[0],y:d3.mouse(e)[1]};this.map.deselect_nodes(),this.map.deselect_text_labels(),this.reload(null,t,!0),this.show_target(this.map,t)}.bind(this,this.map.sel.node())),this.map.sel.classed("start-reaction-cursor",!0)):(this.map.sel.on("click.start_reaction",null),this.map.sel.classed("start-reaction-cursor",!1),this.hide_target())}function y(){this.target_coords&&this.map.sel.selectAll(".start-reaction-target").remove(),this.target_coords=null}function b(e,t){var n=e.sel.selectAll(".start-reaction-target").data([12,5]);n.enter().append("circle").classed("start-reaction-target",!0).attr("r",function(e){return e}).style("stroke-width",4),n.style("visibility","visible").attr("transform","translate("+t.x+","+t.y+")"),this.target_coords=t}var s=e.make_class();return s.prototype={init:o,setup_map_callbacks:u,setup_zoom_callbacks:a,is_visible:f,toggle:l,show_dropdown:c,hide_dropdown:h,place_at_selected:p,place:d,reload_at_selected:v,reload:m,toggle_start_reaction_listener:g,hide_target:y,show_target:b},s}),n("CallbackManager",["utils"],function(e){function n(){}function r(e,t){return this.callbacks===undefined&&(this.callbacks={}),this.callbacks[e]===undefined&&(this.callbacks[e]=[]),this.callbacks[e].push(t),this}function i(e){return(this.callbacks===undefined||Object.keys(this.callbacks).length==0)&&console.warn("No callbacks to remove"),delete this.callbacks[e],this}function s(e,t){if(this.callbacks===undefined)return this;t===undefined&&(t=null);var n=Array.prototype.slice.call(arguments,2);for(var r in this.callbacks){var i=r.split(".")[0];i==e&&this.callbacks[r].forEach(function(e){e.apply(t,n)})}return this}var t=e.make_class();return t.prototype={init:n,set:r,remove:i,run:s},t}),n("ZoomContainer",["utils","CallbackManager"],function(e,t){function r(e,n,r){this.zoom_on=!0,this.initial_zoom=1,this.window_translate={x:0,y:0},this.window_scale=1,this.callback_manager=new t,this.size_container=n,e.select("#zoom-container").remove();var i=e.append("g").attr("id","zoom-container");this.zoomed_sel=i.append("g");var s=function(e,t){e.zoom_on&&(e.zoomed_sel.attr("transform","translate("+t.translate+")"+"scale("+t.scale+")"),e.window_translate={x:t.translate[0],y:t.translate[1]},e.window_scale=t.scale,e.callback_manager.run("zoom"))},o=this;this.zoom_behavior=d3.behavior.zoom().on("zoom",function(){s(o,d3.event)}),i.call(this.zoom_behavior),(r=="none"||r=="pan")&&i.on("mousewheel.zoom",null).on("DOMMouseScroll.zoom",null).on("wheel.zoom",null).on("dblclick.zoom",null);if(r=="pan"){var u=function(){var e=d3.event,t=.5;e.stopPropagation(),e.preventDefault(),e.returnValue=!1,this.go_to(this.window_scale,{x:this.window_translate.x-(e.wheelDeltaX!==undefined?-e.wheelDeltaX/1.5:e.deltaX)*t,y:this.window_translate.y-(e.wheelDeltaY!==undefined?-e.wheelDeltaY/1.5:e.deltaY)*t},!1)}.bind(this);i.on("mousewheel.escher",u),i.on("DOMMouseScroll.escher",u),i.on("wheel.escher",u)}this.saved_scale=null,this.saved_translate=null}function i(t){t===undefined?this.zoom_on=!this.zoom_on:this.zoom_on=t,this.zoom_on?(this.saved_scale!==null&&(this.zoom_behavior.scale(this.saved_scale),this.saved_scale=null),this.saved_translate!==null&&(this.zoom_behavior.translate(this.saved_translate),this.saved_translate=null),this.zoomed_sel.classed("cursor-grab",!0).classed("cursor-grabbing",!1),this.zoomed_sel.on("mousedown.cursor",function(e){e.classed("cursor-grab",!1).classed("cursor-grabbing",!0)}.bind(null,this.zoomed_sel)).on("mouseup.cursor",function(e){e.classed("cursor-grab",!0).classed("cursor-grabbing",!1)}.bind(null,this.zoomed_sel))):(this.saved_scale===null&&(this.saved_scale=e.clone(this.zoom_behavior.scale())),this.saved_translate===null&&(this.saved_translate=e.clone(this.zoom_behavior.translate())),this.zoomed_sel.style("cursor",null).classed("cursor-grab",!1).classed("cursor-grabbing",!1),this.zoomed_sel.on("mousedown.cursor",null),this.zoomed_sel.on("mouseup.cursor",null))}function s(t,n,r){e.check_undefined(arguments,["scale","translate"]),r===undefined&&(r=!0);if(!t)throw new Error("Bad scale value");if(!!n&&"x"in n&&"y"in n&&!isNaN(n.x)&&!isNaN(n.y)){this.zoom_behavior.scale(t),this.window_scale=t,this.saved_scale!==null&&(this.saved_scale=t);var i=[n.x,n.y];this.zoom_behavior.translate(i),this.window_translate=n,this.saved_translate!==null&&(this.saved_translate=i);var s=r?this.zoomed_sel.transition():this.zoomed_sel;return s.attr("transform","translate("+this.window_translate.x+","+this.window_translate.y+")"+"scale("+this.window_scale+")"),this.callback_manager.run("go_to"),null}return console.error("Bad translate value")}function o(t){var n=this.get_size(),r={x:n.width/2-((n.width/2-this.window_translate.x)*t+this.window_translate.x),y:n.height/2-((n.height/2-this.window_translate.y)*t+this.window_translate.y)};this.go_to(this.window_scale*t,e.c_plus_c(this.window_translate,r),!0)}function u(){this.zoom_by(1.5)}function a(){this.zoom_by(.667)}function f(){return{width:parseInt(this.size_container.style("width"),10),height:parseInt(this.size_container.style("height"),10)}}function l(e){var t=120,n=this.get_size(),r={x:{min:-this.window_translate.x/this.window_scale+t/this.window_scale,max:-this.window_translate.x/this.window_scale+(n.width-t)/this.window_scale},y:{min:-this.window_translate.y/this.window_scale+t/this.window_scale,max:-this.window_translate.y/this.window_scale+(n.height-t)/this.window_scale}};e.x<r.x.min?(this.window_translate.x=this.window_translate.x-(e.x-r.x.min)*this.window_scale,this.go_to(this.window_scale,this.window_translate)):e.x>r.x.max&&(this.window_translate.x=this.window_translate.x-(e.x-r.x.max)*this.window_scale,this.go_to(this.window_scale,this.window_translate)),e.y<r.y.min?(this.window_translate.y=this.window_translate.y-(e.y-r.y.min)*this.window_scale,this.go_to(this.window_scale,this.window_translate)):e.y>r.y.max&&(this.window_translate.y=this.window_translate.y-(e.y-r.y.max)*this.window_scale,this.go_to(this.window_scale,this.window_translate))}function c(){this.go_to(1,{x:0,y:0})}var n=e.make_class();return n.prototype={init:r,toggle_zoom:i,go_to:s,zoom_by:o,zoom_in:u,zoom_out:a,get_size:f,translate_off_screen:l,reset:c},n}),n("Draw",["utils","data_styles","CallbackManager"],function(e,t,n){function i(e,t){this.behavior=e,this.settings=t,this.callback_manager=new n}function s(e){e.append("rect").attr("class","membrane"),this.callback_manager.run("create_membrane",this,e)}function o(e){e.attr("width",function(e){return e.width}).attr("height",function(e){return e.height}).attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).style("stroke-width",function(e){return 10}).attr("rx",function(e){return 20}).attr("ry",function(e){return 20}),this.callback_manager.run("update_membrane",this,e)}function u(e){e.append("g").attr("id",function(e){return"r"+e.reaction_id}).attr("class","reaction").call(this.create_reaction_label.bind(this)),this.callback_manager.run("create_reaction",this,e);return}function a(t,n,r,i,s,o){t.select(".reaction-label-group").call(function(e){return this.update_reaction_label(e,o)}.bind(this)),e.draw_a_nested_object(t,".segment-group","segments","segment_id",this.create_segment.bind(this),function(e){return this.update_segment(e,n,r,i,s,o)}.bind(this),function(e){e.remove()}),this.callback_manager.run("update_reaction",this,t)}function f(e){var t=e.append("g").attr("class","reaction-label-group");t.append("text").attr("class","reaction-label label"),t.append("g").attr("class","gene-label-group"),this.callback_manager.run("create_reaction_label",this,e)}function l(e,n){var r=d3.format(".4g"),i=this.settings.get_option("identifiers_on_map"),s=this.settings.get_option("reaction_styles"),o=this.settings.get_option("show_gene_reaction_rules"),u=this.settings.get_option("gene_font_size"),a=this.behavior.label_mousedown,f=this.behavior.label_mouseover,l=this.behavior.label_mouseout;e.attr("transform",function(e){return"translate("+e.label_x+","+e.label_y+")"}).call(this.behavior.turn_off_drag).call(this.behavior.reaction_label_drag),e.select(".reaction-label").text(function(e){var t=e[i];return n&&s.indexOf("text")!=-1&&(t+=" "+e.data_string),t}).on("mousedown",a).on("mouseover",f).on("mouseout",l);var c=e.select(".gene-label-group").selectAll("text").data(function(e){var n="gene_string"in e&&e.gene_string!==null,r="gene_reaction_rule"in e&&e.gene_reaction_rule!==null&&o;if(n)return e.gene_string.split("\n");if(r){var s=t.gene_string_for_data(e.gene_reaction_rule,null,e.genes,null,i,null);return s.split("\n")}return[]});c.enter().append("text").attr("class","gene-label").style("font-size",u+"px"),c.attr("transform",function(e,t){return"translate(0, "+u*1.5*(t+1)+")"}).text(function(e){return e}),c.exit().remove(),this.callback_manager.run("update_reaction_label",this,e)}function c(e){var t=e.append("g").attr("class","segment-group").attr("id",function(e){return"s"+e.segment_id});t.append("path").attr("class","segment"),t.append("g").attr("class","arrowheads"),t.append("g").attr("class","stoichiometry-labels"),this.callback_manager.run("create_segment",this,e)}function h(t,n,r,i,s,o){var u=this.settings.get_option("reaction_styles"),a=o&&u.indexOf("size")!=-1,f=o&&u.indexOf("color")!=-1,l=this.settings.get_option("reaction_no_data_size"),c=this.settings.get_option("reaction_no_data_color"),h=this.settings.get_option("highlight_missing"),p=this.settings.get_option("hide_secondary_metabolites"),d=this.settings.get_option("primary_metabolite_radius"),v=this.settings.get_option("secondary_metabolite_radius"),m=function(e,t){var r=20,i=13;return t&&(i=e===null?l:n.reaction_size(e),isNaN(i)&&(i=l),r=i*2),{width:r,height:i}},g=function(e,t,n,r){var i=t||n>0?e.height:0,s=r?d:v;return s+i+10};t.selectAll(".segment").datum(function(){return this.parentNode.__data__}).style("visibility",function(e){var t=i[e.from_node_id],n=i[e.to_node_id];return p&&(n["node_type"]=="metabolite"&&!n.node_is_primary||t["node_type"]=="metabolite"&&!t.node_is_primary)?"hidden":null}).attr("d",function(e){if(e.from_node_id===null||e.to_node_id===null)return null;var t=i[e.from_node_id],n=i[e.to_node_id],r=e.b1,s=e.b2;if(t["node_type"]=="metabolite"){var o=m(e.data,a),u=g(o,e.reversibility,e.from_node_coefficient,t.node_is_primary),f=r===null?n:r;t=b(u,t,f,"start")}if(n["node_type"]=="metabolite"){var o=m(e.data,a),u=g(o,e.reversibility,e.to_node_coefficient,n.node_is_primary),f=s===null?t:s;n=b(u,f,n,"end")}var l="M"+t.x+","+t.y+" ";return r!==null&&s!==null&&(l+="C"+r.x+","+r.y+" "+s.x+","+s.y+" "),l+=n.x+","+n.y,l}).style("stroke",function(e){var t=this.parentNode.parentNode.__data__.bigg_id,i=h&&r!==null&&!(t in r.reactions);if(i)return"red";if(f){var s=e.data;return s===null?c:n.reaction_color(s)}return null}).style("stroke-width",function(e){if(a){var t=e.data;return t===null?l:n.reaction_size(t)}return null});var y=t.select(".arrowheads").selectAll(".arrowhead").data(function(t){var n=[],r=i[t.from_node_id],s=t.b1,o=i[t.to_node_id],u=t.b2;if(p&&(o["node_type"]=="metabolite"&&!o.node_is_primary||r["node_type"]=="metabolite"&&!r.node_is_primary))return n;if(r.node_type=="metabolite"&&(t.reversibility||t.from_node_coefficient>0)){var f=m(t.data,a),l=g(f,t.reversibility,t.from_node_coefficient,r.node_is_primary),c=s===null?o:s,h=e.to_degrees(e.get_angle([r,c]))+90,d=b(l,r,c,"start");n.push({data:t.data,x:d.x,y:d.y,size:f,rotation:h,show_arrowhead_flux:t.from_node_coefficient<0==t.reverse_flux||t.data==0})}if(o.node_type=="metabolite"&&(t.reversibility||t.to_node_coefficient>0)){var f=m(t.data,a),l=g(f,t.reversibility,t.to_node_coefficient,o.node_is_primary),c=u===null?r:u,h=e.to_degrees(e.get_angle([o,c]))+90,d=b(l,c,o,"end");n.push({data:t.data,x:d.x,y:d.y,size:f,rotation:h,show_arrowhead_flux:t.to_node_coefficient<0==t.reverse_flux||t.data==0})}return n});y.enter().append("path").classed("arrowhead",!0),y.attr("d",function(e){return"M"+[-e.size.width/2,0]+" L"+[0,e.size.height]+" L"+[e.size.width/2,0]+" Z"}).attr("transform",function(e){return"translate("+e.x+","+e.y+")rotate("+e.rotation+")"}).style("fill",function(e){if(f){if(e.show_arrowhead_flux){var t=e.data;return t===null?c:n.reaction_color(t)}return"#FFFFFF"}return null}).style("stroke",function(e){if(f){var t=e.data;return t===null?c:n.reaction_color(t)}return null}),y.exit().remove();var w=t.select(".stoichiometry-labels").selectAll(".stoichiometry-label").data(function(t){var n=[],r=i[t.from_node_id],s=t.b1,o=i[t.to_node_id],u=t.b2,f=1.5;if(p&&(o["node_type"]=="metabolite"&&!o.node_is_primary||r["node_type"]=="metabolite"&&!r.node_is_primary))return n;if(r.node_type=="metabolite"&&Math.abs(t.from_node_coefficient)!=1){var l=m(t.data,a),c=f*g(l,!1,0,o.node_is_primary),h=s===null?o:s;h=e.c_plus_c(h,e.rotate_coords(h,.5,r));var d=b(c,r,h,"start");d=e.c_plus_c(d,{x:0,y:7}),n.push({coefficient:Math.abs(t.from_node_coefficient),x:d.x,y:d.y,data:t.data})}if(o.node_type=="metabolite"&&Math.abs(t.to_node_coefficient)!=1){var l=m(t.data,a),c=f*g(l,!1,0,o.node_is_primary),h=u===null?r:u;h=e.c_plus_c(h,e.rotate_coords(h,.5,o));var d=b(c,h,o,"end");d=e.c_plus_c(d,{x:0,y:7}),n.push({coefficient:Math.abs(t.to_node_coefficient),x:d.x,y:d.y,data:t.data})}return n});w.enter().append("text").attr("class","stoichiometry-label").attr("text-anchor","middle"),w.attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).text(function(e){return e.coefficient}).style("fill",function(e){if(f){var t=e.data;return t===null?c:n.reaction_color(t)}return null}),w.exit().remove(),this.callback_manager.run("update_segment",this,t)}function p(e){var t=e.append("g").attr("id",function(e){return e.bezier_id}).attr("class",function(e){return"bezier"});t.append("path").attr("class","connect-line"),t.append("circle").attr("class",function(e){return"bezier-circle "+e.bezier}).style("stroke-width",String(1)+"px").attr("r",String(7)+"px"),this.callback_manager.run("create_bezier",this,e)}function d(e,t,n,r,i,s,o){if(!t){e.attr("visibility","hidden");return}e.attr("visibility","visible"),e.select(".bezier-circle").call(this.behavior.turn_off_drag).call(n).on("mouseover",r).on("mouseout",i).attr("transform",function(e){return e.x==null||e.y==null?"":"translate("+e.x+","+e.y+")"}),e.select(".connect-line").attr("d",function(e){var t,n=o[e.reaction_id].segments[e.segment_id];return t=e.bezier=="b1"?s[n.from_node_id]:s[n.to_node_id],e.x==null||e.y==null||t.x==null||t.y==null?"":"M"+e.x+", "+e.y+" "+t.x+","+t.y}),this.callback_manager.run("update_bezier",this,e)}function v(e,t,n){var r=e.append("g").attr("class","node").attr("id",function(e){return"n"+e.node_id});r.append("circle").attr("class",function(e){var t="node-circle";return e.node_type!==null&&(t+=" "+e.node_type+"-circle"),t}),r.filter(function(e){return e.node_type=="metabolite"}).append("text").attr("class","node-label label"),this.callback_manager.run("create_node",this,e)}function m(e,t,n,r,i,s,o,u,a,f,l,c){var h=this.settings.get_option("hide_secondary_metabolites"),p=this.settings.get_option("primary_metabolite_radius"),d=this.settings.get_option("secondary_metabolite_radius"),v=this.settings.get_option("marker_radius"),m=e.select(".node-circle").attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).style("visibility",function(e){return h&&!e.node_is_primary?"hidden":null}).attr("r",function(e){if(e.node_type=="metabolite"){var r=n&&i.indexOf("size")!=-1;if(r){var o=e.data;return o===null?s.size:t.metabolite_size(o)}return e.node_is_primary?p:d}return v}).style("fill",function(e){if(e.node_type=="metabolite"){var r=n&&i.indexOf("color")!=-1;if(r){var o=e.data;return o===null?s.color:t.metabolite_color(o)}return null}return null}).call(this.behavior.turn_off_drag).call(l).on("mousedown",o).on("click",u).on("mouseover",a).on("mouseout",f);e.select(".node-label").style("visibility",function(e){return h&&!e.node_is_primary?"hidden":null}).attr("transform",function(e){return"translate("+e.label_x+","+e.label_y+")"}).text(function(e){var t=e[r];return n&&i.indexOf("text")!=-1&&(t+=" "+e.data_string),t}).call(this.behavior.turn_off_drag).call(c),this.callback_manager.run("update_node",this,e)}function g(e){e.append("g").attr("id",function(e){return"l"+e.text_label_id}).attr("class","text-label").append("text").attr("class","label"),this.callback_manager.run("create_text_label",this,e)}function y(e){var t=this.behavior.text_label_mousedown,n=this.behavior.text_label_click,r=this.behavior.selectable_drag,i=this.behavior.turn_off_drag;e.select(".label").text(function(e){return e.text}).attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).on("mousedown",t).on("click",n).call(i).call(r),this.callback_manager.run("update_text_label",this,e)}function b(t,n,r,i){e.check_undefined(arguments,["reaction_arrow_displacement","start","end","displace"]);var s=t,o=e.distance(n,r),u,a;return(!s||!o)&&console.error("Bad value"),i=="start"?(u=n.x+s*(r.x-n.x)/o,a=n.y+s*(r.y-n.y)/o):i=="end"?(u=r.x-s*(r.x-n.x)/o,a=r.y-s*(r.y-n.y)/o):console.error("bad displace value: "+i),{x:u,y:a}}var r=e.make_class();return r.prototype={init:i,create_reaction:u,update_reaction:a,create_bezier:p,update_bezier:d,create_node:v,update_node:m,create_text_label:g,update_text_label:y,create_membrane:s,update_membrane:o,create_reaction_label:f,update_reaction_label:l,create_segment:c,update_segment:h},r}),n("build",["utils"],function(e){function t(t,r,i,o,u,a,f,c){c=Math.PI/180*c;var h=String(++a.reactions),p={x:u.x,y:u.y},d=300,v=[p,e.c_plus_c(p,{x:d,y:0})],m={x:(v[0].x+v[1].x)/2,y:(v[0].y+v[1].y)/2},g;Math.abs(c)<Math.PI/4||Math.abs(c-Math.PI)<Math.PI/4?g={x:-50,y:-40}:g={x:30,y:10};var y=20,b=e.clone(r);e.extend(b,{label_x:m.x+g.x,label_y:m.y+g.y,segments:{}});var w=[],E=[],S=0,x=0,T=!1;for(var N in b.metabolites){var C=i[N],k=b.metabolites[N],L=C.formula,A={coefficient:k,bigg_id:N,name:C.name};if(k<0){A.index=S;var O=/C([0-9]+)/.exec(L);u.bigg_id==A.bigg_id?w.push([A.index,Infinity]):O&&f.indexOf(e.decompartmentalize(A.bigg_id)[0])==-1&&w.push([A.index,parseInt(O[1])]),S++}else{A.index=x;var O=/C([0-9]+)/.exec(L);u.bigg_id==A.bigg_id?(E.push([A.index,Infinity]),T=!0):O&&f.indexOf(e.decompartmentalize(A.bigg_id)[0])==-1&&E.push([A.index,parseInt(O[1])]),x++}b.metabolites[N]=A}var M=function(e,t){return t[1]>e[1]?t:e},_=w.reduce(M,[0,0])[0],D=E.reduce(M,[0,0])[0];for(var N in b.metabolites){var C=b.metabolites[N];C.coefficient<0?(C.index==_&&(C.is_primary=!0),C.count=S+1):(C.index==D&&(C.is_primary=!0),C.count=x+1)}var P={},H=[{node_type:"anchor_reactants",dis:{x:y*(T?1:-1),y:0}},{node_type:"center",dis:{x:0,y:0}},{node_type:"anchor_products",dis:{x:y*(T?-1:1),y:0}}],B={};H.map(function(e){var t=String(++a.nodes),n=e.node_type=="center"?"midmarker":"multimarker";P[t]={node_type:n,x:m.x+e.dis.x,y:m.y+e.dis.y,connected_segments:[],name:null,bigg_id:null,label_x:null,label_y:null,node_is_primary:null},B[e.node_type]=t});var j=[[B.anchor_reactants,B.center],[B.anchor_products,B.center]];j.map(function(e){var t=e[0],n=e[1],r=String(++a.segments);b.segments[r]={b1:null,b2:null,from_node_id:t,to_node_id:n,from_node_coefficient:null,to_node_coefficient:null,reversibility:b.reversibility,data:b.data,reverse_flux:b.reverse_flux},P[t].connected_segments.push({segment_id:r,reaction_id:h}),P[n].connected_segments.push({segment_id:r,reaction_id:h})});var F=P;for(var N in b.metabolites){var C=b.metabolites[N],I,q;C.coefficient<0?(I=_,q=B.anchor_reactants):(I=D,q=B.anchor_products);var R=s(C,I,v,m,d,T);if(u.bigg_id==C.bigg_id){var U=String(++a.segments);b.segments[U]={b1:R.b1,b2:R.b2,from_node_id:q,to_node_id:o,from_node_coefficient:null,to_node_coefficient:C.coefficient,reversibility:b.reversibility,data:b.data,reverse_flux:b.reverse_flux},u.connected_segments.push({segment_id:U,reaction_id:h}),F[q].connected_segments.push({segment_id:U,reaction_id:h})}else{var U=String(++a.segments),z=String(++a.nodes);b.segments[U]={b1:R.b1,b2:R.b2,from_node_id:q,to_node_id:z,from_node_coefficient:null,to_node_coefficient:C.coefficient,reversibility:b.reversibility,data:b.data,reverse_flux:b.reverse_flux},F[z]={connected_segments:[{segment_id:U,reaction_id:h}],x:R.circle.x,y:R.circle.y,node_is_primary:Boolean(C.is_primary),label_x:R.circle.x+g.x,label_y:R.circle.y+g.y,name:C.name,bigg_id:C.bigg_id,node_type:"metabolite"},F[q].connected_segments.push({segment_id:U,reaction_id:h})}}var W=[];for(var t in b.metabolites)W.push({bigg_id:t,coefficient:b.metabolites[t].coefficient});b.metabolites=W;var X={};X[h]=b;var V=l(X);return F[o]=u,n(F,X,V,c,p),{new_reactions:X,new_beziers:V,new_nodes:F}}function n(t,n,r,s,o){var a=function(t){return t===null?null:e.rotate_coords(t,s,o)},f=[],l=[];for(var c in t){var h=t[c],p=a({x:h.x,y:h.y}),d=i(h,n,p);h.connected_segments.map(function(t){var i=n[t.reaction_id];if(i===undefined)return;var s=t.segment_id,o=i.segments[s];if(o.to_node_id==c&&o.b2){var f=a(o.b2),l=u(s,"b2");o.b2=e.c_plus_c(o.b2,f),r[l].x=o.b2.x,r[l].y=o.b2.y}else if(o.from_node_id==c&&o.b1){var f=a(o.b1),l=u(s,"b1");o.b1=e.c_plus_c(o.b1,f),r[l].x=o.b1.x,r[l].y=o.b1.y}}),l=e.unique_concat([l,d.reaction_ids]),f.push(c)}return{node_ids:f,reaction_ids:l}}function r(t,n,r,s,o){var a=i(t,r,o);return t.connected_segments.map(function(t){var i=r[t.reaction_id];if(i===undefined)return;var f=t.segment_id,l=i.segments[f];[["b1","from_node_id"],["b2","to_node_id"]].forEach(function(t){var r=t[0],i=t[1];if(l[i]==n&&l[r]){l[r]=e.c_plus_c(l[r],o);var a=s[u(f,r)];a.x=l[r].x,a.y=l[r].y}}),a.reaction_ids.indexOf(t.reaction_id)<0&&a.reaction_ids.push(t.reaction_id)}),a}function i(e,t,n){e.x=e.x+n.x,e.y=e.y+n.y,e.label_x=e.label_x+n.x,e.label_y=e.label_y+n.y;var r=[];return e.connected_segments.map(function(i){var s=t[i.reaction_id];r.indexOf(i.reaction_id)<0&&(r.push(i.reaction_id),e.node_type=="midmarker"&&(s.label_x=s.label_x+n.x,s.label_y=s.label_y+n.y))}),{reaction_ids:r}}function s(t,n,r,i,s,o){var u=r[0],r=[e.c_minus_c(r[0],u),e.c_minus_c(r[1],u)],i=e.c_minus_c(i,u),a=80,f=.4,l=.25,c=a*.7,h=40,p=Math.min(2,t.count-1),d,v,m;t.is_primary?d=20:(d=10,t.index>n?v=t.index-1:v=t.index);var g=s-d,y=[{x:d,y:0},{x:g,y:0}],b,w,E,S;t.coefficient<0!=o&&t.is_primary?(b={x:y[0].x,y:y[0].y},E={x:i.x*(1-f)+y[0].x*f,y:i.y*(1-f)+y[0].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[0].x,y:r[0].y}):t.coefficient<0!=o?(b={x:y[0].x+h,y:y[0].y+(c*v-c*(p-1)/2)},E={x:i.x*(1-f)+y[0].x*f,y:i.y*(1-f)+y[0].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[0].x+h,y:r[0].y+(a*v-a*(p-1)/2)}):t.coefficient>0!=o&&t.is_primary?(b={x:y[1].x,y:y[1].y},E={x:i.x*(1-f)+y[1].x*f,y:i.y*(1-f)+y[1].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[1].x,y:r[1].y}):t.coefficient>0!=o&&(b={x:y[1].x-h,y:y[1].y+(c*v-c*(p-1)/2)},E={x:i.x*(1-f)+y[1].x*f,y:i.y*(1-f)+y[1].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[1].x-h,y:r[1].y+(a*v-a*(p-1)/2)});var x={};return x.b1=e.c_plus_c(u,E),x.b2=e.c_plus_c(u,S),x.circle=e.c_plus_c(u,w),x}function o(e,t,n){var r=String(++e.text_labels),i={text:t,x:n.x,y:n.y};return{id:r,label:i}}function u(e,t){return e+"_"+t}function a(e){var t=[];for(var n in e){var r=e[n];for(var i in r.segments){var s=r.segments[i];["b1","b2"].forEach(function(e){var n=s[e];n!==null&&t.push(u(i,e))})}}return t}function f(e,t){var n={};for(var r in e){var i=e[r];["b1","b2"].forEach(function(e){var s=i[e];if(s!==null){var o=u(r,e);n[o]={bezier:e,x:s.x,y:s.y,reaction_id:t,segment_id:r}}})}return n}function l(t){var n={};for(var r in t){var i=t[r],s=f(i.segments,r);e.extend(n,s)}return n}return{new_reaction:t,rotate_nodes:n,move_node_and_dependents:r,new_text_label:o,bezier_id_for_segment_id:u,bezier_ids_for_reaction_ids:a,new_beziers_for_segments:f,new_beziers_for_reactions:l}}),n("Behavior",["utils","build"],function(e,t){function r(e,t){this.map=e,this.undo_stack=t,this.empty_behavior=function(){},this.rotation_mode_enabled=!1,this.rotation_drag=d3.behavior.drag(),this.selectable_mousedown=null,this.text_label_mousedown=null,this.text_label_click=null,this.selectable_drag=this.empty_behavior,this.node_mouseover=null,this.node_mouseout=null,this.label_mousedown=null,this.label_mouseover=null,this.label_mouseout=null,this.bezier_drag=this.empty_behavior,this.bezier_mouseover=null,this.bezier_mouseout=null,this.reaction_label_drag=this.empty_behavior,this.node_label_drag=this.empty_behavior,this.turn_everything_on()}function i(){this.toggle_selectable_click(!0),this.toggle_selectable_drag(!0),this.toggle_label_drag(!0),this.toggle_label_mousedown(!0)}function s(){this.toggle_selectable_click(!1),this.toggle_selectable_drag(!1),this.toggle_label_drag(!1),this.toggle_label_mousedown(!1)}function o(n){function g(){var e=this.map.sel.selectAll("#rotation-center").data([0]),t=e.enter().append("g").attr("id","rotation-center");t.append("path").attr("d","M-32 0 L32 0").attr("class","rotation-center-line"),t.append("path").attr("d","M0 -32 L0 32").attr("class","rotation-center-line"),e.attr("transform","translate("+this.center.x+","+this.center.y+")").attr("visibility","visible"),e.call(d3.behavior.drag().on("drag",function(e){var t=d3.transform(e.attr("transform")),n=[d3.event.dx+t.translate[0],d3.event.dy+t.translate[1]];e.attr("transform","translate("+n+")"),this.center={x:n[0],y:n[1]}}.bind(this,e))),e.on("mouseover",function(){var e=parseFloat(this.selectAll("path").style("stroke-width"));this.selectAll("path").style("stroke-width",e*2+"px")}.bind(e)),e.on("mouseout",function(){this.selectAll("path").style("stroke-width",null)}.bind(e))}function y(e){this.map.sel.select("#rotation-center").attr("visibility","hidden")}function b(t){var n=[],r=[];for(var i in t){var s=t[i];s.x!==undefined&&n.push(s.x),s.y!==undefined&&r.push(s.y)}return{x:e.mean(n),y:e.mean(r)}}n===undefined?this.rotation_mode_enabled=!this.rotation_mode_enabled:this.rotation_mode_enabled=n;var r=this.map.sel.selectAll(".node-circle"),i=this.map.sel.selectAll("#canvas");if(this.rotation_mode_enabled){this.map.callback_manager.run("start_rotation");var s=this.map.get_selected_nodes();if(Object.keys(s).length==0){console.warn("No selected nodes");return}this.center=b(s),g.call(this);var o=this.map,u=Object.keys(s),a=this.map.reactions,f=this.map.nodes,l=this.map.beziers,c=function(e){d3.event.sourceEvent.stopPropagation()},h=function(e,n,r,i){var u=t.rotate_nodes(s,a,l,n,i);o.draw_these_nodes(u.node_ids),o.draw_these_reactions(u.reaction_ids)},p=function(e){},d=function(e,n,r){var i={};u.forEach(function(e){i[e]=f[e]});var s=t.rotate_nodes(i,a,l,-n,r);o.draw_these_nodes(s.node_ids),o.draw_these_reactions(s.reaction_ids)},v=function(e,n,r){var i={};u.forEach(function(e){i[e]=f[e]});var s=t.rotate_nodes(i,a,l,n,r);o.draw_these_nodes(s.node_ids),o.draw_these_reactions(s.reaction_ids)},m=function(){return this.center}.bind(this);this.rotation_drag=this._get_generic_angular_drag(c,h,p,d,v,m,this.map.sel),i.call(this.rotation_drag)}else y.call(this),r.on("mousedown.center",null),i.on("mousedown.center",null),i.on("mousedown.drag",null),i.on("touchstart.drag",null),this.rotation_drag=null}function u(e){e===undefined&&(e=this.selectable_mousedown==null);if(e){var t=this.map;this.selectable_mousedown=function(e){d3.event.stopPropagation()},this.selectable_click=function(e){d3.event.stopPropagation();if(d3.event.defaultPrevented)return;t.select_selectable(this,e)},this.node_mouseover=function(e){d3.select(this).style("stroke-width",null);var t=parseFloat(d3.select(this).style("stroke-width"));d3.select(this.parentNode).classed("selected")||d3.select(this).style("stroke-width",t*3+"px")},this.node_mouseout=function(e){d3.select(this).style("stroke-width",null)}}else this.selectable_mousedown=null,this.selectable_click=null,this.node_mouseover=null,this.node_mouseout=null,this.map.sel.select("#nodes").selectAll(".node-circle").style("stroke-width",null)}function a(e){e===undefined&&(e=this.text_edit_mousedown==null);if(e){var t=this.map,n=this.selection;this.text_label_mousedown=function(){if(d3.event.defaultPrevented)return;var e=d3.transform(d3.select(this).attr("transform")).translate,n={x:e[0],y:e[1]};t.callback_manager.run("edit_text_label",null,d3.select(this),n),d3.event.stopPropagation()},this.text_label_click=null,this.map.sel.select("#text-labels").selectAll(".label").classed("edit-text-cursor",!0),this.map.sel.on("mousedown.new_text_label",function(e){d3.event.preventDefault();var t={x:d3.mouse(e)[0],y:d3.mouse(e)[1]};this.map.callback_manager.run("new_text_label",null,t)}.bind(this,this.map.sel.node()))}else this.text_label_mousedown=this.selectable_mousedown,this.text_label_click=this.selectable_click,this.map.sel.select("#text-labels").selectAll(".label").classed("edit-text-cursor",!1),this.map.sel.on("mousedown.new_text_label",null),this.map.callback_manager.run("hide_text_label_editor")}function f(e){e===undefined&&(e=this.selectable_drag===this.empty_behavior),e?(this.selectable_drag=this._get_selectable_drag(this.map,this.undo_stack),this.bezier_drag=this._get_bezier_drag(this.map,this.undo_stack)):(this.selectable_drag=this.empty_behavior,this.bezier_drag=this.empty_behavior)}function l(e){e===undefined&&(e=this.label_drag===this.empty_behavior),e?(this.reaction_label_drag=this._get_reaction_label_drag(this.map),this.node_label_drag=this._get_node_label_drag(this.map)):(this.reaction_label_drag=this.empty_behavior,this.node_label_drag=this.empty_behavior)}function c(e){e===undefined&&(e=this.label_mousedown==null);if(e){var t=this.map;this.label_mousedown=function(e){},this.label_mouseover=function(e){},this.label_mouseout=function(e){}}else this.label_mousedown=null,this.label_mouseover=null,this.label_mouseout=null,this.map.sel.select(".node-label,.reaction-label").style("fill",null)}function h(e){e===undefined&&(e=this.bezier_drag===this.empty_behavior),e?(this.bezier_drag=this._get_bezier_drag(this.map),this.bezier_mouseover=function(e){d3.select(this).style("stroke-width",String(3)+"px")},this.bezier_mouseout=function(e){d3.select(this).style("stroke-width",String(1)+"px")}):(this.bezier_drag=this.empty_behavior,this.bezier_mouseover=null,this.bezier_mouseout=null)}function p(e){e.on("mousedown.drag",null),e.on("touchstart.drag",null)}function d(n,r){function c(t,r){var i=n.nodes[r],s=n.nodes[t],o=[];return i.connected_segments.forEach(function(i){var u;try{u=n.reactions[i.reaction_id].segments[i.segment_id];if(u===undefined)throw new Error("undefined segment")}catch(a){console.warn("Could not find connected segment "+i.segment_id);return}if(u.from_node_id==r)u.from_node_id=t;else{if(u.to_node_id!=r){console.error("Segment does not connect to dragged node");return}u.to_node_id=t}s.connected_segments.push(i),o.push(e.clone(i));return}),n.delete_node_data([r]),n.sel.selectAll(".node-to-combine").classed("node-to-combine",!1),n.draw_everything(),o}var i=d3.behavior.drag(),s=null,o=null,u=null,a=null,f=null,l=function(e,t){var r=n.text_labels[e];r.x=r.x+t.x,r.y=r.y+t.y};return i.on("dragstart",function(e){d3.event.sourceEvent.stopPropagation(),o={x:0,y:0};if(d3.select(this).attr("class").indexOf("label")==-1){var t=this.parentNode.__data__,r=t.bigg_id,i=this.parentNode;s=window.setTimeout(function(){i.parentNode.insertBefore(i,i.parentNode.firstChild)},200),n.sel.selectAll(".metabolite-circle").on("mouseover.combine",function(e){e.bigg_id==r&&e.node_id!=t.node_id&&d3.select(this).style("stroke-width",String(12)+"px").classed("node-to-combine",!0)}).on("mouseout.combine",function(e){e.bigg_id==r&&n.sel.selectAll(".node-to-combine").style("stroke-width",String(2)+"px").classed("node-to-combine",!1)})}}),i.on("drag",function(r){d3.select(this.parentNode).classed("selected")||n.select_selectable(this,r);var i={};d3.select(this).attr("class").indexOf("label")==-1?(i.type="node",i.id=this.parentNode.__data__.node_id):(i.type="label",i.id=this.__data__.text_label_id);var s=n.get_selected_node_ids(),c=n.get_selected_text_label_ids();u=[],f=[],i["type"]=="node"&&s.indexOf(i["id"])==-1?u.push(i.id):i["type"]=="label"&&c.indexOf(i["id"])==-1?f.push(i.id):(u=s,f=c),a=[];var h={x:d3.event.dx,y:d3.event.dy};o=e.c_plus_c(o,h),u.forEach(function(r){var i=n.nodes[r],s=t.move_node_and_dependents(i,r,n.reactions,n.beziers,h);a=e.unique_concat([a,s.reaction_ids])}),f.forEach(function(e){l(e,h)}),n.draw_these_nodes(u),n.draw_these_reactions(a),n.draw_these_text_labels(f)}),i.on("dragend",function(){if(u===null){o=null,u=null,f=null,a=null,s=null;return}var i=[];n.sel.selectAll(".node-to-combine").each(function(e){i.push(e.node_id)});if(i.length==1){var h=i[0],p=this.parentNode.__data__.node_id,d=e.clone(n.nodes[p]),v=c(h,p);r.push(function(){n.nodes[p]=d;var e=n.nodes[h],t=[];v.forEach(function(r){var i=n.reactions[r.reaction_id].segments[r.segment_id];i.from_node_id==h?i.from_node_id=p:i.to_node_id==h?i.to_node_id=p:console.error("Segment does not connect to fixed node"),e.connected_segments=e.connected_segments.filter(function(e){return e.reaction_id!=r.reaction_id||e.segment_id!=r.segment_id}),t.indexOf(r.reaction_id)==-1&&t.push(r.reaction_id)}),n.draw_these_nodes([p]),n.draw_these_reactions(t)},function(){c(h,p)})}else{var m=e.clone(o),g=e.clone(u),y=e.clone(f),b=e.clone(a);r.push(function(){g.forEach(function(r){var i=n.nodes[r];t.move_node_and_dependents(i,r,n.reactions,n.beziers,e.c_times_scalar(m,-1))}),y.forEach(function(t){l(t,e.c_times_scalar(m,-1))}),n.draw_these_nodes(g),n.draw_these_reactions(b),n.draw_these_text_labels(y)},function(){g.forEach(function(e){var r=n.nodes[e];t.move_node_and_dependents(r,e,n.reactions,n.beziers,m)}),y.forEach(function(e){l(e,m)}),n.draw_these_nodes(g),n.draw_these_reactions(b),n.draw_these_text_labels(y)})}n.sel.selectAll(".metabolite-circle").on("mouseover.combine",null).on("mouseout.combine",null),window.clearTimeout(s),o=null,u=null,f=null,a=null,s=null}),i}function v(t){var n=function(n,r,i,s,o){var u=t.reactions[n].segments[r];u[i]=e.c_plus_c(u[i],o),t.beziers[s].x=u[i].x,t.beziers[s].y=u[i].y},r=function(e){e.dragging=!0},i=function(e,r,i){n(e.reaction_id,e.segment_id,e.bezier,e.bezier_id,r),t.draw_these_reactions([e.reaction_id],!1),t.draw_these_beziers([e.bezier_id])},s=function(e){e.dragging=!1},o=function(r,i){n(r.reaction_id,r.segment_id,r.bezier,r.bezier_id,e.c_times_scalar(i,-1)),t.draw_these_reactions([r.reaction_id],!1),t.draw_these_beziers([r.bezier_id])},u=function(e,r){n(e.reaction_id,e.segment_id,e.bezier,e.bezier_id,r),t.draw_these_reactions([e.reaction_id],!1),t.draw_these_beziers([e.bezier_id])};return this._get_generic_drag(r,i,s,o,u,this.map.sel)}function m(t){var n=function(e,n){var r=t.reactions[e];r.label_x=r.label_x+n.x,r.label_y=r.label_y+n.y},r=function(e){},i=function(e,r,i){n(e.reaction_id,r),t.draw_these_reactions([e.reaction_id])},s=function(e){},o=function(r,i){n(r.reaction_id,e.c_times_scalar(i,-1)),t.draw_these_reactions([r.reaction_id])},u=function(e,r){n(e.reaction_id,r),t.draw_these_reactions([e.reaction_id])};return this._get_generic_drag(r,i,s,o,u,this.map.sel)}function g(t){var n=function(e,n){var r=t.nodes[e];r.label_x=r.label_x+n.x,r.label_y=r.label_y+n.y},r=function(e){},i=function(e,r,i){n(e.node_id,r),t.draw_these_nodes([e.node_id])},s=function(e){},o=function(r,i){n(r.node_id,e.c_times_scalar(i,-1)),t.draw_these_nodes([r.node_id])},u=function(e,r){n(e.node_id,r),t.draw_these_nodes([e.node_id])};return this._get_generic_drag(r,i,s,o,u,this.map.sel)}function y(t,n,r,i,s,o){var u=d3.behavior.drag(),a,f=this.undo_stack,l=o.node();return u.on("dragstart",function(e){d3.event.sourceEvent.stopPropagation(),a={x:0,y:0},t(e)}),u.on("drag",function(t){var r={x:d3.event.dx,y:d3.event.dy},i={x:d3.mouse(l)[0],y:d3.mouse(l)[1]};a=e.c_plus_c(a,r),n(t,r,a,i)}),u.on("dragend",function(t){var n=e.clone(t),o=e.clone(a),u={x:d3.mouse(l)[0],y:d3.mouse(l)[1]};f.push(function(){i(n,o,u)},function(){s(n,o,u)}),r(t)}),u}function b(t,n,r,i,s,o,u){var a=d3.behavior.drag(),f,l=this.undo_stack,c=u.node();return a.on("dragstart",function(e){d3.event.sourceEvent.stopPropagation(),f=0,t(e)}),a.on("drag",function(t){var r={x:d3.event.dx,y:d3.event.dy},i={x:d3.mouse(c)[0],y:d3.mouse(c)[1]},s=o(),u=e.angle_for_event(r,i,s);f+=u,n(t,u,f,s)}),a.on("dragend",function(t){var n=e.clone(t),u=f,a=e.clone(o());l.push(function(){i(n,u,a)},function(){s(n,u,a)}),r(t)}),a}var n=e.make_class();return n.prototype={init:r,toggle_rotation_mode:o,turn_everything_on:i,turn_everything_off:s,toggle_selectable_click:u,toggle_text_label_edit:a,toggle_selectable_drag:f,toggle_label_drag:l,toggle_label_mousedown:c,toggle_bezier_drag:h,turn_off_drag:p,_get_selectable_drag:d,_get_bezier_drag:v,_get_reaction_label_drag:m,_get_node_label_drag:g,_get_generic_drag:y,_get_generic_angular_drag:b},n}),n("Scale",["utils"],function(e){function n(){this.x=d3.scale.linear(),this.y=d3.scale.linear(),this.x_size=d3.scale.linear(),this.y_size=d3.scale.linear(),this.size=d3.scale.linear(),this.reaction_color=d3.scale.linear().clamp(!0),this.reaction_size=d3.scale.linear().clamp(!0),this.metabolite_color=d3.scale.linear().clamp(!0),this.metabolite_size=d3.scale.linear().clamp(!0),this.scale_path=function(e){var t=this.x,n=this.y,r=d3.format(".2f"),e=e.replace(/(M|L)([0-9-.]+),?\s*([0-9-.]+)/g,function(e,i,s,o){return i+[r(t(parseFloat(s))),r(n(parseFloat(o)))].join(", ")}),i=/C([0-9-.]+),?\s*([0-9-.]+)\s*([0-9-.]+),?\s*([0-9-.]+)\s*([0-9-.]+),?\s*([0-9-.]+)/g;return e=e.replace(i,function(e,i,s,o,u,a,f){return"C"+r(t(parseFloat(i)))+","+r(n(parseFloat(s)))+" "+r(t(parseFloat(o)))+","+r(n(parseFloat(u)))+" "+[r(t(parseFloat(a)))+","+r(n(parseFloat(f)))]}),e}.bind(this),this.scale_decimals=function(e,t,n){var r=d3.format("."+String(n)+"f");return e=e.replace(/([0-9.]+)/g,function(e,n){return r(t(parseFloat(n)))}),e}}function r(e,t,n){function s(e,t){var n=e.map(function(e){var n;if(e.type in t)n=t[e.type];else{if(e.type!="value")throw new Error("Bad domain type "+e.type);n=e.value}return{v:n,color:e.color,size:e.size}}).sort(function(e,t){return e.v-t.v});return{domain:n.map(function(e){return e.v}),color_range:n.map(function(e){return e.color}),size_range:n.map(function(e){return e.size})}}var r=function(e){var t=s(e,n().reaction);this.reaction_color.domain(t.domain),this.reaction_size.domain(t.domain),this.reaction_color.range(t.color_range),this.reaction_size.range(t.size_range)}.bind(this),i=function(e){var t=s(e,n().metabolite);this.metabolite_color.domain(t.domain),this.metabolite_size.domain(t.domain),this.metabolite_color.range(t.color_range),this.metabolite_size.range(t.size_range)}.bind(this);e.streams.reaction_scale.onValue(r),e.streams.metabolite_scale.onValue(i),t.callback_manager.set("calc_data_stats__reaction",function(t){t&&r(e.get_option("reaction_scale"))}),t.callback_manager.set("calc_data_stats__metabolite",function(t){t&&i(e.get_option("metabolite_scale"))})}var t=e.make_class();return t.prototype={init:n,connect_to_settings:r},t}),n("UndoStack",["utils"],function(e){function n(){var e=40;this.stack=Array(e),this.current=-1,this.oldest=-1,this.newest=-1,this.end_of_stack=!0,this.top_of_stack=!0}function r(e,t){this.current=o(this.current,this.stack.length),this.end_of_stack?this.oldest=this.current:this.oldest==this.current&&(this.oldest=o(this.oldest,this.stack.length)),this.stack[this.current]={undo:e,redo:t},this.newest=this.current,this.top_of_stack=!0,this.end_of_stack=!1}function i(){if(this.end_of_stack)return console.warn("End of stack.");this.stack[this.current].undo(),this.current==this.oldest?this.end_of_stack=!0:this.current=u(this.current,this.stack.length),this.top_of_stack=!1}function s(){if(this.top_of_stack)return console.warn("Top of stack.");this.end_of_stack||(this.current=o(this.current,this.stack.length)),this.stack[this.current].redo(),this.current==this.newest&&(this.top_of_stack=!0),this.end_of_stack=!1}function o(e,t){return e+1>t-1?0:e+1}function u(e,t){return e-1<0?t-1:e-1}var t=e.make_class();return t.prototype={init:n,push:r,undo:i,redo:s},t}),n("KeyManager",["utils"],function(e){function n(e){e.command=!1,e.control=!1,e.option=!1,e.shift=!1}function r(e,t,r,i){e===undefined&&(e=null),this.unique_string=e===null?"":"."+e,t===undefined?this.assigned_keys={}:this.assigned_keys=t,r===undefined?this.input_list=[]:this.input_list=r,i===undefined&&(i=!0),this.ctrl_equals_cmd=i,this.held_keys={},n(this.held_keys),this.enabled=!0,this.update()}function i(){function o(e,t,n,r){for(var i in e)e[i]==n&&(t[i]=r)}function u(t,n,r,i){if(t.key!=n)return!1;var s=e.clone(t.modifiers);s===undefined&&(s={control:!1,command:!1,option:!1,shift:!1});for(var o in r){if(i&&s.control&&(o=="command"||o=="command_right"||o=="control")&&(r.command||r.command_right||r.control))continue;s[o]===undefined&&(s[o]=!1);if(s[o]!=r[o])return!1}return!0}var t=this.held_keys,r=this.assigned_keys,i=this,s={command:91,command_right:93,control:17,option:18,shift:16};d3.select(window).on("keydown.key_manager"+this.unique_string,null),d3.select(window).on("keyup.key_manager"+this.unique_string,null);if(!this.enabled)return;d3.select(window).on("keydown.key_manager"+this.unique_string,function(e,i){var a=d3.event.keyCode,f=!0,l=!1;i.forEach(function(e){e.is_visible()&&(l=!0)}),o(s,t,a,!0);for(var c in r){var h=r[c];if(u(h,a,t,e)){f=!1;if(!h.ignore_with_input||!l)h.fn?h.fn.call(h.target):console.warn("No function for key"),d3.event.preventDefault()}}for(var p in s)s[p]==a&&(f=!1);f&&n(t)}.bind(null,this.ctrl_equals_cmd,this.input_list)).on("keyup.key_manager"+this.unique_string,function(){o(s,t,d3.event.keyCode,!1)})}function s(e){e===undefined&&(e=!this.enabled),this.enabled=e,this.update()}function o(e,t){return this.add_key_listener(e,13,t)}function u(e,t){return this.add_key_listener(e,27,t)}function a(e,t,n){var r="keydown."+t;n!==undefined&&(r+="."+n),r+=this.unique_string;var i=d3.select(window);return i.on(r,function(){d3.event.keyCode==t&&e()}),{clear:function(){i.on(r,null)}}}var t=e.make_class();return t.reset_held_keys=n,t.prototype={init:r,update:i,toggle:s,add_escape_listener:u,add_enter_listener:o,add_key_listener:a},t}),n("Canvas",["utils","CallbackManager"],function(e,t){function r(e,n){this.selection=e,this.x=n.x,this.y=n.y,this.width=n.width,this.height=n.height,this.resize_enabled=!0,this.callback_manager=new t,this.setup()}function i(e){e===undefined&&(e=!this.resize_enabled),e?this.selection.selectAll(".drag-rect").style("pointer-events","auto"):this.selection.selectAll(".drag-rect").style("pointer-events","none")}function s(){function v(){d3.event.sourceEvent.stopPropagation()}function m(e,t,n){var r=d3.transform(n),i=r.translate;return e!==null&&(i[0]=e),t!==null&&(i[1]=t),"translate("+i+")"}function g(t){var i=t.x;t.x=Math.min(t.x+e.width-n/2,d3.event.x),e.x=t.x,e.width=e.width+(i-t.x),c.attr("transform",function(e){return m(e.x-n/2,null,c.attr("transform"))}),s.attr("transform",function(e){return m(e.x,null,s.attr("transform"))}).attr("width",e.width*r),o.attr("transform",function(e){return m(e.x,null,o.attr("transform"))}).attr("width",e.width),p.attr("transform",function(e){return m(e.x+n/2,null,p.attr("transform"))}).attr("width",e.width-n),d.attr("transform",function(e){return m(e.x+n/2,null,d.attr("transform"))}).attr("width",e.width-n),e.callback_manager.run("resize")}function y(t){d3.event.sourceEvent.stopPropagation();var i=Math.max(t.x+n/2,t.x+e.width+d3.event.dx);e.width=i-t.x,h.attr("transform",function(e){return m(i-n/2,null,h.attr("transform"))}),s.attr("width",e.width*r),o.attr("width",e.width),p.attr("width",e.width-n),d.attr("width",e.width-n),e.callback_manager.run("resize")}function b(t){d3.event.sourceEvent.stopPropagation();var i=t.y;t.y=Math.min(t.y+e.height-n/2,d3.event.y),e.y=t.y,e.height=e.height+(i-t.y),p.attr("transform",function(e){return m(null,e.y-n/2,p.attr("transform"))}),s.attr("transform",function(e){return m(null,e.y,s.attr("transform"))}).attr("width",e.height*r),o.attr("transform",function(e){return m(null,e.y,o.attr("transform"))}).attr("height",e.height),c.attr("transform",function(e){return m(null,e.y+n/2,c.attr("transform"))}).attr("height",e.height-n),h.attr("transform",function(e){return m(null,e.y+n/2,h.attr("transform"))}).attr("height",e.height-n),e.callback_manager.run("resize")}function w(t){d3.event.sourceEvent.stopPropagation();var i=Math.max(t.y+n/2,t.y+e.height+d3.event.dy);e.height=i-t.y,d.attr("transform",function(e){return m(null,i-n/2,d.attr("transform"))}),s.attr("height",e.height*r),o.attr("height",e.height),c.attr("height",e.height-n),h.attr("height",e.height-n),e.callback_manager.run("resize")}var e=this,t={x:this.width,y:this.height},n=100,r=10,i=this.selection.append("g").classed("canvas-group",!0).data([{x:this.x,y:this.y}]),s=i.append("rect").attr("id","mouse-node").attr("width",this.width*r).attr("height",this.height*r).attr("transform","translate("+[e.x-this.width*r/2,e.y-this.height*r/2]+")").attr("pointer-events","all");this.mouse_node=s;var o=i.append("rect").attr("id","canvas").attr("width",this.width).attr("height",this.height).attr("transform","translate("+[e.x,e.y]+")"),u=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",y),a=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",g),f=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",b),l=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",w),c=i.append("rect").classed("drag-rect",!0).attr("transform",function(e){return"translate("+[e.x-n/2,e.y+n/2]+")"}).attr("height",this.height-n).attr("id","dragleft").attr("width",n).attr("cursor","ew-resize").classed("resize-rect",!0).call(a),h=i.append("rect").classed("drag-rect",!0).attr("transform",function(t){return"translate("+[t.x+e.width-n/2,t.y+n/2]+")"}).attr("id","dragright").attr("height",this.height-n).attr("width",n).attr("cursor","ew-resize").classed("resize-rect",!0).call(u),p=i.append("rect").classed("drag-rect",!0).attr("transform",function(e){return"translate("+[e.x+n/2,e.y-n/2]+")"}).attr("height",n).attr("id","dragtop").attr("width",this.width-n).attr("cursor","ns-resize").classed("resize-rect",!0).call(f),d=i.append("rect").classed("drag-rect",!0).attr("transform",function(t){return"translate("+[t.x+n/2,t.y+e.height-n/2]+")"}).attr("id","dragbottom").attr("height",n).attr("width",this.width-n).attr("cursor","ns-resize").classed("resize-rect",!0).call(l)}function o(){return{x:this.x,y:this.y,width:this.width,height:this.height}}var n=e.make_class();return n.prototype={init:r,toggle_resize:i,setup:s,size_and_location:o},n}),n("SearchIndex",["utils"],function(e){function n(){this.index={}}function r(e,t,n,r){if(!n&&e in this.index)throw new Error("id is already in the index");if(!(!r||"name"in t&&"data"in t))throw new Error("malformed record");this.index[e]=t}function i(e){return e in this.index?(delete this.index[e],!0):!1}function s(e){var t=RegExp(e,"i"),n=[];for(var r in this.index){var i=this.index[r];t.exec(i.name)&&n.push(i.data)}return n}var t=e.make_class();return t.prototype={init:n,insert:r,remove:i,find:s},t}),function(){var e,t,r,i,s,o,u,a,f,l,c,h,p,d,v,m,g,y,b,w,E,S,x,T,N,C,k,L,A,O,M,_,D,P,H,B,j,F,I,q,R,U,z,W,X,V,$,J,K,Q,G,Y,Z,et,tt,nt,rt,it,st,ot,ut,at,ft,lt,ct,ht=[].slice,pt={}.hasOwnProperty,dt=function(e,t){function r(){this.constructor=e}for(var n in t)pt.call(t,n)&&(e[n]=t[n]);return r.prototype=t.prototype,e.prototype=new r,e.__super__=t.prototype,e},vt=function(e,t){return function(){return e.apply(t,arguments)}};e={toString:function(){return"Bacon"}},e.version="0.7.12",e.fromBinder=function(t,n){return n==null&&(n=lt.id),new c(_(e,"fromBinder",t,n),function(r){var i;return i=t(function(){var t,s,o,u,a,f;t=1<=arguments.length?ht.call(arguments,0):[],u=n.apply(null,t),I(u)&&lt.last(u)instanceof l||(u=[u]),o=e.more;for(a=0,f=u.length;a<f;a++){s=u[a],o=r(s=rt(s));if(o===e.noMore||s.isEnd())return i!=null?i():e.scheduler.setTimeout(function(){return i()},0),o}return o})})},e.$={asEventStream:function(t,n,r){var i;return R(n)&&(i=[n,null],r=i[0],n=i[1]),at(this.selector||this,"asEventStream",t,e.fromBinder(function(e){return function(r){return e.on(t,n,r),function(){return e.off(t,n,r)}}}(this),r))}},(ct=typeof jQuery!=="undefined"&&jQuery!==null?jQuery:typeof Zepto!=="undefined"&&Zepto!==null?Zepto:null)!=null&&(ct.fn.asEventStream=e.$.asEventStream),e.fromEventTarget=function(t,n,r){var i,s,o,u,a,f;return i=(o=t.addEventListener)!=null?o:(u=t.addListener)!=null?u:t.bind,s=(a=t.removeEventListener)!=null?a:(f=t.removeListener)!=null?f:t.unbind,at(e,"fromEventTarget",t,n,e.fromBinder(function(e){return i.call(t,n,e),function(){return s.call(t,n,e)}},r))},e.fromPromise=function(t,n){return at(e,"fromPromise",t,e.fromBinder(function(e){return t.then(e,function(t){return e(new f(t))}),function(){if(n)return typeof t.abort=="function"?t.abort():void 0}},function(e){return[e,D()]}))},e.noMore=["<no-more>"],e.more=["<more>"],e.later=function(t,n){return at(e,"later",t,n,e.sequentially(t,[n]))},e.sequentially=function(t,n){var r;return r=0,at(e,"sequentially",t,n,e.fromPoll(t,function(){var e;return e=n[r++],r<n.length?e:r===n.length?[e,D()]:D()}))},e.repeatedly=function(t,n){var r;return r=0,at(e,"repeatedly",t,n,e.fromPoll(t,function(){return n[r++%n.length]}))},e.spy=function(e){return tt.push(e)},tt=[],et=function(e){var t,n,r,i;if(tt.length&&!et.running)try{et.running=!0,i=[];for(n=0,r=tt.length;n<r;n++)t=tt[n],i.push(t(e));return i}finally{delete et.running}},ft=function(e){return function(){var t,n,r,i;return r=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],typeof r=="object"&&t.length&&(n=r,i=t[0],r=function(){return n[i].apply(n,arguments)},t=t.slice(1)),e.apply(null,[r].concat(ht.call(t)))}},W=function(t,n){return ft(function(){var r,i,s;return i=arguments[0],r=2<=arguments.length?ht.call(arguments,1):[],s=Y(n,[function(e,t){return i.apply(null,ht.call(e).concat([t]))}]),at.apply(null,[e,t,i].concat(ht.call(r),[e.combineAsArray(r).flatMap(s)]))})},e.fromCallback=W("fromCallback",function(){var t,n;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],e.fromBinder(function(e){return X(n,t)(e),G},function(e){return[e,D()]})}),e.fromNodeCallback=W("fromNodeCallback",function(){var t,n;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],e.fromBinder(function(e){return X(n,t)(e),G},function(e,t){return e?[new f(e),D()]:[t,D()]})}),e.fromPoll=function(t,n){return at(e,"fromPoll",t,n,e.fromBinder(function(n){var r;return r=e.scheduler.setInterval(n,t),function(){return e.scheduler.clearInterval(r)}},n))},e.interval=function(t,n){return n==null&&(n={}),at(e,"interval",t,n,e.fromPoll(t,function(){return Q(n)}))},e.constant=function(t){return new m(_(e,"constant",t),function(e){return e(F(t)),e(D()),G})},e.never=function(){return at(e,"never",e.fromArray([]))},e.once=function(t){return at(e,"once",t,e.fromArray([t]))},e.fromArray=function(t){return x(t),t=L(t),new c(_(e,"fromArray",t),function(n){var r,i;return i=!1,r=function(){var s,o;if(lt.empty(t))return n(D());o=t.splice(0,1)[0],s=n(rt(o));if(s!==e.noMore&&!i)return r()},r(),function(){return i=!0}})},e.mergeAll=function(){var t;return t=1<=arguments.length?ht.call(arguments,0):[],I(t[0])&&(t=t[0]),t.length?new c(_.apply(null,[e,"mergeAll"].concat(ht.call(t))),function(n){var r,i,s;return r=0,s=function(i){return function(s){return i.subscribeInternal(function(i){var o;return i.isEnd()?(r++,r===t.length?n(D()):e.more):(o=n(i),o===e.noMore&&s(),o)})}},i=lt.map(s,t),A.apply(null,i)}):e.never()},e.zipAsArray=function(){var t;return t=1<=arguments.length?ht.call(arguments,0):[],I(t[0])&&(t=t[0]),at.apply(null,[e,"zipAsArray"].concat(ht.call(t),[e.zipWith(t,function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],e})]))},e.zipWith=function(){var t,n,r;return t=arguments[0],n=2<=arguments.length?ht.call(arguments,1):[],R(t)||(r=[t,n[0]],n=r[0],t=r[1]),n=lt.map(function(e){return e.toEventStream()},n),at.apply(null,[e,"zipWith",t].concat(ht.call(n),[e.when(n,t)]))},e.groupSimultaneous=function(){var n,r,i;return i=1<=arguments.length?ht.call(arguments,0):[],i.length===1&&I(i[0])&&(i=i[0]),r=function(){var e,r,s;s=[];for(e=0,r=i.length;e<r;e++)n=i[e],s.push(new t(n));return s}(),at.apply(null,[e,"groupSimultaneous"].concat(ht.call(i),[e.when(r,function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],e})]))},e.combineAsArray=function(){var t,n,r,i,s,o,u;s=1<=arguments.length?ht.call(arguments,0):[],s.length===1&&I(s[0])&&(s=s[0]);for(t=o=0,u=s.length;o<u;t=++o)i=s[t],U(i)||(s[t]=e.constant(i));return s.length?(r=function(){var e,t,r;r=[];for(e=0,t=s.length;e<t;e++)n=s[e],r.push(new b(n,!0,n.subscribeInternal));return r}(),at.apply(null,[e,"combineAsArray"].concat(ht.call(s),[e.when(r,function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],e}).toProperty()]))):e.constant([])},e.onValues=function(){var t,n,r;return n=2<=arguments.length?ht.call(arguments,0,r=arguments.length-1):(r=0,[]),t=arguments[r++],e.combineAsArray(n).onValues(t)},e.combineWith=function(){var t,n;return t=arguments[0],n=2<=arguments.length?ht.call(arguments,1):[],at.apply(null,[e,"combineWith",t].concat(ht.call(n),[e.combineAsArray(n).map(function(e){return t.apply(null,e)})]))},e.combineTemplate=function(t){var n,r,i,s,o,u,a,f,l,c;return a=[],c=[],u=function(e){return e[e.length-1]},l=function(e,t,n){return u(e)[t]=n},n=function(e,t){return function(n,r){return l(n,e,r[t])}},o=function(e,t){return function(n){return l(n,e,t)}},f=function(e){return I(e)?[]:{}},i=function(e,t){var r,i;return U(t)?(c.push(t),a.push(n(e,c.length-1))):t!==Object(t)||typeof t=="function"||t instanceof RegExp||t instanceof Date?a.push(o(e,t)):(i=function(e){return function(n){var r;return r=f(t),l(n,e,r),n.push(r)}},r=function(e){return e.pop()},a.push(i(e)),s(t),a.push(r))},s=function(e){return lt.each(e,i)},s(t),r=function(e){var n,r,i,s,o;i=f(t),n=[i];for(s=0,o=a.length;s<o;s++)r=a[s],r(n,e);return i},at(e,"combineTemplate",t,e.combineAsArray(c).map(r))},e.retry=function(t){var n,r,i,s,o,u;if(!R(t.source))throw"'source' option has to be a function";return u=t.source,s=t.retries||0,i=t.maxRetries||s,n=t.interval||function(){return 0},r=t.isRetryable||function(){return!0},o=function(t){var o;return o={source:u,retries:s-1,maxRetries:i,interval:n,isRetryable:r},e.later(n(t)).filter(!1).concat(e.retry(o))},at(e,"retry",t,u().flatMapError(function(t){return r(t)&&s>0?o({error:t,retriesDone:i-s}):e.once(new e.Error(t))}))},P=0,l=function(){function e(){this.id=++P}return e.prototype.isEvent=function(){return!0},e.prototype.isEnd=function(){return!1},e.prototype.isInitial=function(){return!1},e.prototype.isNext=function(){return!1},e.prototype.isError=function(){return!1},e.prototype.hasValue=function(){return!1},e.prototype.filter=function(){return!0},e.prototype.inspect=function(){return this.toString()},e.prototype.log=function(){return this.toString()},e}(),p=function(e){function t(e){t.__super__.constructor.call(this),R(e)?this.value=lt.cached(e):this.value=lt.always(e)}return dt(t,e),t.prototype.isNext=function(){return!0},t.prototype.hasValue=function(){return!0},t.prototype.fmap=function(e){var t;return t=this.value,this.apply(function(){return e(t())})},t.prototype.apply=function(e){return new t(e)},t.prototype.filter=function(e){return e(this.value())},t.prototype.toString=function(){return lt.toString(this.value())},t.prototype.log=function(){return this.value()},t}(l),h=function(e){function t(){return t.__super__.constructor.apply(this,arguments)}return dt(t,e),t.prototype.isInitial=function(){return!0},t.prototype.isNext=function(){return!1},t.prototype.apply=function(e){return new t(e)},t.prototype.toNext=function(){return new p(this.value)},t}(p),a=function(e){function t(){return t.__super__.constructor.apply(this,arguments)}return dt(t,e),t.prototype.isEnd=function(){return!0},t.prototype.fmap=function(){return this},t.prototype.apply=function(){return this},t.prototype.toString=function(){return"<end>"},t}(l),f=function(e){function t(e){this.error=e}return dt(t,e),t.prototype.isError=function(){return!0},t.prototype.fmap=function(){return this},t.prototype.apply=function(){return this},t.prototype.toString=function(){return"<error> "+lt.toString(this.error)},t}(l),j=0,v=function(){function t(e){this.flatMapError=vt(this.flatMapError,this),this.id=++j,at(e,this)}return t.prototype.onValue=function(){var e;return e=V(arguments),this.subscribe(function(t){if(t.hasValue())return e(t.value())})},t.prototype.onValues=function(e){return this.onValue(function(t){return e.apply(null,t)})},t.prototype.onError=function(){var e;return e=V(arguments),this.subscribe(function(t){if(t.isError())return e(t.error)})},t.prototype.onEnd=function(){var e;return e=V(arguments),this.subscribe(function(t){if(t.isEnd())return e()})},t.prototype.errors=function(){return at(this,"errors",this.filter(function(){return!1}))},t.prototype.filter=function(){var t,n;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],M(this,n,t,function(t){return at(this,"filter",t,this.withHandler(function(n){return n.filter(t)?this.push(n):e.more}))})},t.prototype.takeWhile=function(){var t,n;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],M(this,n,t,function(t){return at(this,"takeWhile",t,this.withHandler(function(n){return n.filter(t)?this.push(n):(this.push(D()),e.noMore)}))})},t.prototype.endOnError=function(){var e,t;return t=arguments[0],e=2<=arguments.length?ht.call(arguments,1):[],t==null&&(t=!0),M(this,t,e,function(e){return at(this,"endOnError",this.withHandler(function(t){return t.isError()&&e(t.error)?(this.push(t),this.push(D())):this.push(t)}))})},t.prototype.take=function(t){return t<=0?e.never():at(this,"take",t,this.withHandler(function(n){return n.hasValue()?(t--,t>0?this.push(n):(t===0&&this.push(n),this.push(D()),e.noMore)):this.push(n)}))},t.prototype.map=function(){var e,t;return t=arguments[0],e=2<=arguments.length?ht.call(arguments,1):[],t instanceof m?t.sampledBy(this,B):M(this,t,e,function(e){return at(this,"map",e,this.withHandler(function(t){return this.push(t.fmap(e))}))})},t.prototype.mapError=function(){var e;return e=V(arguments),at(this,"mapError",e,this.withHandler(function(t){return t.isError()?this.push(Q(e(t.error))):this.push(t)}))},t.prototype.mapEnd=function(){var t;return t=V(arguments),at(this,"mapEnd",t,this.withHandler(function(n){return n.isEnd()?(this.push(Q(t(n))),this.push(D()),e.noMore):this.push(n)}))},t.prototype.doAction=function(){var e;return e=V(arguments),at(this,"doAction",e,this.withHandler(function(t){return t.hasValue()&&e(t.value()),this.push(t)}))},t.prototype.skip=function(t){return at(this,"skip",t,this.withHandler(function(n){return n.hasValue()?t>0?(t--,e.more):this.push(n):this.push(n)}))},t.prototype.skipDuplicates=function(e){return e==null&&(e=function(e,t){return e===t}),at(this,"skipDuplicates",this.withStateMachine(d,function(t,n){return n.hasValue()?n.isInitial()||t===d||!e(t.get(),n.value())?[new y(n.value()),[n]]:[t,[]]:[t,[n]]}))},t.prototype.skipErrors=function(){return at(this,"skipErrors",this.withHandler(function(t){return t.isError()?e.more:this.push(t)}))},t.prototype.withStateMachine=function(t,n){var r;return r=t,at(this,"withStateMachine",t,n,this.withHandler(function(t){var i,s,o,u,a,f,l;i=n(r,t),s=i[0],u=i[1],r=s,a=e.more;for(f=0,l=u.length;f<l;f++){o=u[f],a=this.push(o);if(a===e.noMore)return a}return a}))},t.prototype.scan=function(t,n,r){var i,s,o,u;return s=nt(n),n=r?s:function(e,t){return s(e(),t())},i=ot(t).map(function(e){return lt.always(e)}),u=function(t){return function(r){var s,u,a,f;return s=!1,f=G,u=e.more,a=function(){if(!s)return i.forEach(function(t){s=!0,u=r(new h(t));if(u===e.noMore)return f(),f=G})},f=t.subscribeInternal(function(t){var o,f;if(t.hasValue())return s&&t.isInitial()?e.more:(t.isInitial()||a(),s=!0,f=i.getOrElse(function(){return void 0}),o=lt.cached(function(){return n(f,t.value)}),i=new y(o),r(t.apply(o)));t.isEnd()&&(u=a());if(u!==e.noMore)return r(t)}),w.whenDoneWith(o,a),f}}(this),o=new m(_(this,"scan",t,n),u)},t.prototype.fold=function(e,t){return at(this,"fold",e,t,this.scan(e,t).sampledBy(this.filter(!1).mapEnd().toProperty()))},t.prototype.zip=function(t,n){return n==null&&(n=Array),at(this,"zip",t,e.zipWith([this,t],n))},t.prototype.diff=function(e,t){return t=nt(t),at(this,"diff",e,t,this.scan([e],function(e,n){return[n,t(e[0],n)]}).filter(function(e){return e.length===2}).map(function(e){return e[1]}))},t.prototype.flatMap=function(){return H(this,K(arguments))},t.prototype.flatMapFirst=function(){return H(this,K(arguments),!0)},t.prototype.flatMapLatest=function(){var e,t;return e=K(arguments),t=this.toEventStream(),at(this,"flatMapLatest",e,t.flatMap(function(n){return J(e(n)).takeUntil(t)}))},t.prototype.flatMapError=function(t){return at(this,"flatMapError",t,this.mapError(function(t){return new e.Error(t)}).flatMap(function(n){return n instanceof e.Error?t(n.error):e.once(n)}))},t.prototype.not=function(){return at(this,"not",this.map(function(e){return!e}))},t.prototype.log=function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],this.subscribe(function(t){return typeof console!="undefined"&&console!==null?typeof console.log=="function"?console.log.apply(console,ht.call(e).concat([t.log()])):void 0:void 0}),this},t.prototype.slidingWindow=function(e,t){return t==null&&(t=0),at(this,"slidingWindow",e,t,this.scan([],function(t,n){return t.concat([n]).slice(-e)}).filter(function(e){return e.length>=t}))},t.prototype.combine=function(t,n){var r;return r=nt(n),at(this,"combine",t,n,e.combineAsArray(this,t).map(function(e){return r(e[0],e[1])}))},t.prototype.decode=function(t){return at(this,"decode",t,this.combine(e.combineTemplate(t),function(e,t){return t[e]}))},t.prototype.awaiting=function(t){return at(this,"awaiting",t,e.groupSimultaneous(this,t).map(function(e){var t,n;return t=e[0],n=e[1],n.length===0}).toProperty(!1).skipDuplicates())},t.prototype.name=function(e){return this.toString=function(){return e},this},t.prototype.withDescription=function(){return _.apply(null,arguments).apply(this)},t}(),v.prototype.reduce=v.prototype.fold,v.prototype.assign=v.prototype.onValue,H=function(t,n,r){return new c(_(t,"flatMap"+(r?"First":""),n),function(s){var o,u;return u=new i,o=function(e){e();if(u.empty())return s(D())},u.add(function(i,a){return t.subscribeInternal(function(t){var i;return t.isEnd()?o(a):t.isError()?s(t):r&&u.count()>1?e.more:u.unsubscribed?e.noMore:(i=J(n(t.value())),u.add(function(t,n){return i.subscribeInternal(function(r){var i;return r.isEnd()?(o(n),e.noMore):(r instanceof h&&(r=r.toNext()),i=s(r),i===e.noMore&&t(),i)})}))})}),u.unsubscribe})},c=function(t){function n(e,t){var r;R(e)&&(t=e,e=[]),n.__super__.constructor.call(this,e),N(t),r=new u(t),this.subscribeInternal=r.subscribe,this.subscribe=w.wrappedSubscribe(this),this.hasSubscribers=r.hasSubscribers,et(this)}return dt(n,t),n.prototype.delay=function(t){return at(this,"delay",t,this.flatMap(function(n){return e.later(t,n)}))},n.prototype.debounce=function(t){return at(this,"debounce",t,this.flatMapLatest(function(n){return e.later(t,n)}))},n.prototype.debounceImmediate=function(t){return at(this,"debounceImmediate",t,this.flatMapFirst(function(n){return e.once(n).concat(e.later(t).filter(!1))}))},n.prototype.throttle=function(e){return at(this,"throttle",e,this.bufferWithTime(e).map(function(e){return e[e.length-1]}))},n.prototype.bufferWithTime=function(e){return at(this,"bufferWithTime",e,this.bufferWithTimeOrCount(e,Number.MAX_VALUE))},n.prototype.bufferWithCount=function(e){return at(this,"bufferWithCount",e,this.bufferWithTimeOrCount(void 0,e))},n.prototype.bufferWithTimeOrCount=function(e,t){var n;return n=function(n){if(n.values.length===t)return n.flush();if(e!==void 0)return n.schedule()},at(this,"bufferWithTimeOrCount",e,t,this.buffer(e,n,n))},n.prototype.buffer=function(t,n,r){var i,s,o;return n==null&&(n=function(){}),r==null&&(r=function(){}),i={scheduled:!1,end:null,values:[],flush:function(){var t;this.scheduled=!1;if(this.values.length>0){t=this.push(Q(this.values)),this.values=[];if(this.end!=null)return this.push(this.end);if(t!==e.noMore)return r(this)}else if(this.end!=null)return this.push(this.end)},schedule:function(){if(!this.scheduled)return this.scheduled=!0,t(function(e){return function(){return e.flush()}}(this))}},o=e.more,R(t)||(s=t,t=function(t){return e.scheduler.setTimeout(t,s)}),at(this,"buffer",this.withHandler(function(e){return i.push=this.push,e.isError()?o=this.push(e):e.isEnd()?(i.end=e,i.scheduled||i.flush()):(i.values.push(e.value()),n(i)),o}))},n.prototype.merge=function(t){var n;return T(t),n=this,at(n,"merge",t,e.mergeAll(this,t))},n.prototype.toProperty=function(e){return arguments.length===0&&(e=d),at(this,"toProperty",e,this.scan(e,z,!0))},n.prototype.toEventStream=function(){return this},n.prototype.sampledBy=function(e,t){return at(this,"sampledBy",e,t,this.toProperty().sampledBy(e,t))},n.prototype.concat=function(e){var t;return t=this,new n(_(t,"concat",e),function(n){var r,i;return i=G,r=t.subscribeInternal(function(t){return t.isEnd()?i=e.subscribeInternal(n):n(t)}),function(){return r(),i()}})},n.prototype.takeUntil=function(t){var n;return n={},at(this,"takeUntil",t,e.groupSimultaneous(this.mapEnd(n),t.skipErrors()).withHandler(function(r){var i,s,o,u,a,f;if(!r.hasValue())return this.push(r);f=r.value(),i=f[0],t=f[1];if(t.length)return this.push(D());s=e.more;for(u=0,a=i.length;u<a;u++)o=i[u],o===n?s=this.push(D()):s=this.push(Q(o));return s}))},n.prototype.skipUntil=function(e){var t;return t=e.take(1).map(!0).toProperty(!1),at(this,"skipUntil",e,this.filter(t))},n.prototype.skipWhile=function(){var t,n,r;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],r=!1,M(this,n,t,function(t){return at(this,"skipWhile",t,this.withHandler(function(n){return r||!n.hasValue()||!t(n.value())?(n.hasValue()&&(r=!0),this.push(n)):e.more}))})},n.prototype.startWith=function(t){return at(this,"startWith",t,e.once(t).concat(this))},n.prototype.withHandler=function(e){var t;return t=new u(this.subscribeInternal,e),new n(_(this,"withHandler",e),t.subscribe)},n}(v),m=function(t){function n(e,t,r){R(e)&&(r=t,t=e,e=[]),n.__super__.constructor.call(this,e),N(t),r===!0?this.subscribeInternal=t:this.subscribeInternal=(new g(this,t,r)).subscribe,this.subscribe=w.wrappedSubscribe(this),et(this)}return dt(n,t),n.prototype.sampledBy=function(t,r){var i,s,o,u,a;return r!=null?r=nt(r):(i=!0,r=function(e){return e()}),a=new b(this,!1,this.subscribeInternal,i),o=new b(t,!0,t.subscribeInternal,i),u=e.when([a,o],r),s=t instanceof n?u.toProperty():u,at(this,"sampledBy",t,r,s)},n.prototype.sample=function(t){return at(this,"sample",t,this.sampledBy(e.interval(t,{})))},n.prototype.changes=function(){return new c(_(this,"changes"),function(e){return function(t){return e.subscribeInternal(function(e){if(!e.isInitial())return t(e)})}}(this))},n.prototype.withHandler=function(e){return new n(_(this,"withHandler",e),this.subscribeInternal,e)},n.prototype.toProperty=function(){return C(arguments),this},n.prototype.toEventStream=function(){return new c(_(this,"toEventStream"),function(e){return function(t){return e.subscribeInternal(function(e){return e.isInitial()&&(e=e.toNext()),t(e)})}}(this))},n.prototype.and=function(e){return at(this,"and",e,this.combine(e,function(e,t){return e&&t}))},n.prototype.or=function(e){return at(this,"or",e,this.combine(e,function(e,t){return e||t}))},n.prototype.delay=function(e){return this.delayChanges("delay",e,function(t){return t.delay(e)})},n.prototype.debounce=function(e){return this.delayChanges("debounce",e,function(t){return t.debounce(e)})},n.prototype.throttle=function(e){return this.delayChanges("throttle",e,function(t){return t.throttle(e)})},n.prototype.delayChanges=function(){var e,t,n;return e=2<=arguments.length?ht.call(arguments,0,n=arguments.length-1):(n=0,[]),t=arguments[n++],at.apply(null,[this].concat(ht.call(e),[E(this,t(this.changes()))]))},n.prototype.takeUntil=function(e){var t;return t=this.changes().takeUntil(e),at(this,"takeUntil",e,E(this,t))},n.prototype.startWith=function(e){return at(this,"startWith",e,this.scan(e,function(e,t){return t}))},n}(v),M=function(e,t,n,r){var i;return t instanceof m?(i=t.sampledBy(e,function(e,t){return[e,t]}),r.apply(i,[function(e){var t,n;return t=e[0],n=e[1],t}]).map(function(e){var t,n;return t=e[0],n=e[1],n})):(t=X(t,n),r.apply(e,[t]))},E=function(t,n){var r;return r=new c(_(t,"justInitValue"),function(n){var i,s;return s=null,i=t.subscribeInternal(function(t){return t.hasValue()&&(s=t),e.noMore}),w.whenDoneWith(r,function(){return s!=null&&n(s),n(D())}),i}),r.concat(n).toProperty()},u=function(){function t(t,n){var r,i,s,o,u,a,f,l,c,h;t==null&&(t=function(){return G}),l=[],a=[],u=!1,i=!1,this.hasSubscribers=function(){return l.length>0},s=null,c=G,f=function(e){return l=lt.without(e,l)},h=null,r=function(){var e,t,n,r,i;if(h!=null){t=h,h=null,i=[];for(n=0,r=t.length;n<r;n++)e=t[n],i.push(e());return i}},o=function(t){var n,i,o,h,p,d;if(!u){if(t===s)return;t.isError()&&(s=t),o=!1;try{u=!0,h=l;for(p=0,d=h.length;p<d;p++)i=h[p],n=i.sink(t),(n===e.noMore||t.isEnd())&&f(i);o=!0}finally{u=!1,o||(a=[])}o=!0;while(a.length)t=a.shift(),this.push(t);return r(t),this.hasSubscribers()?e.more:(c(),e.noMore)}return a.push(t),e.more},this.push=function(e){return function(t){return w.inTransaction(t,e,o,[t])}}(this),n==null&&(n=function(e){return this.push(e)}),this.handleEvent=function(e){return function(t){return t.isEnd()&&(i=!0),n.apply(e,[t])}}(this),this.subscribe=function(e){return function(n){var r,s;return i?(n(D()),G):(N(n),r={sink:n},l.push(r),l.length===1&&(s=t(e.handleEvent),c=function(){return s(),c=G}),N(c),function(){f(r);if(!e.hasSubscribers())return c()})}}(this)}return t}(),g=function(t){function n(t,r,i){var s,o,u,a;n.__super__.constructor.call(this,r,i),s=d,o=void 0,a=this.push,r=this.subscribe,u=!1,this.push=function(e){return function(t){return t.isEnd()&&(u=!0),t.hasValue()&&(s=new y(t),o=w.currentEventId()),a.apply(e,[t])}}(this),this.subscribe=function(n){return function(i){var a,f,l,c,h;return f=!1,c=e.more,l=function(){return c===e.noMore?G:u?(i(D()),G):r.apply(this,[i])},s.isDefined&&(n.hasSubscribers()||u)?(a=w.currentEventId(),h=o,!u&&h&&a&&a!==h?(w.whenDoneWith(t,function(){if(o===h)return i(F(s.get().value()))}),l()):(w.inTransaction(void 0,n,function(){return c=i(F(s.get().value()))},[]),l())):l()}}(this)}return dt(n,t),n}(u),r=function(t){function n(){var t,r,i,s,o,u,a,l;i=void 0,u=[],t=!1,r=function(t){return function(t){return function(n){return n.isEnd()?(l(t),e.noMore):i(n)}}}(this),a=function(){var e,t,n,r;r=[];for(t=0,n=u.length;t<n;t++)e=u[t],r.push(typeof e.unsub=="function"?e.unsub():void 0);return r},o=function(e){return e.unsub=e.input.subscribeInternal(r(e.input))},l=function(e){var t,n,r,i;for(t=r=0,i=u.length;r<i;t=++r){n=u[t];if(n.input===e){typeof n.unsub=="function"&&n.unsub(),u.splice(t,1);return}}},s=function(e){return function(e){var t,n,r,s;i=e,s=L(u);for(n=0,r=s.length;n<r;n++)t=s[n],o(t);return a}}(this),n.__super__.constructor.call(this,_(e,"Bus"),s),this.plug=function(e){return function(e){var n;if(t)return;return n={input:e},u.push(n),i!=null&&o(n),function(){return l(e)}}}(this),this.push=function(e){return function(e){return typeof i=="function"?i(Q(e)):void 0}}(this),this.error=function(e){return function(e){return typeof i=="function"?i(new f(e)):void 0}}(this),this.end=function(e){return function(){return t=!0,a(),typeof i=="function"?i(D()):void 0}}(this)}return dt(n,t),n}(c),b=function(){function e(e,t,n,r){this.obs=e,this.sync=t,this.subscribe=n,this.lazy=r!=null?r:!1,this.queue=[],this.subscribe==null&&(this.subscribe=this.obs.subscribeInternal),this.toString=this.obs.toString}return e.prototype.markEnded=function(){return this.ended=!0},e.prototype.consume=function(){return this.lazy?lt.always(this.queue[0]):this.queue[0]},e.prototype.push=function(e){return this.queue=[e]},e.prototype.mayHave=function(){return!0},e.prototype.hasAtLeast=function(){return this.queue.length},e.prototype.flatten=!0,e}(),s=function(e){function t(){return t.__super__.constructor.apply(this,arguments)}return dt(t,e),t.prototype.consume=function(){return this.queue.shift()},t.prototype.push=function(e){return this.queue.push(e)},t.prototype.mayHave=function(e){return!this.ended||this.queue.length>=e},t.prototype.hasAtLeast=function(e){return this.queue.length>=e},t.prototype.flatten=!1,t}(b),t=function(e){function t(e){this.obs=e,t.__super__.constructor.call(this,this.obs,!0,this.obs.subscribeInternal)}return dt(t,e),t.prototype.consume=function(){var e;return e=this.queue,this.queue=[],function(){return e}},t.prototype.push=function(e){return this.queue.push(e())},t.prototype.hasAtLeast=function(){return!0},t}(b),b.isTrigger=function(e){return e instanceof b?e.sync:e instanceof c},b.fromObservable=function(e){return e instanceof b?e:e instanceof m?new b(e,!1):new s(e,!0)},_=function(){var e,t,n;return t=arguments[0],n=arguments[1],e=3<=arguments.length?ht.call(arguments,2):[],(t||n)instanceof o?t||n:new o(t,n,e)},o=function(){function e(e,t,n){var r,i,s,o;s=function(e){return I(e)?lt.flatMap(s,e):U(e)?[e]:e instanceof b?[e.obs]:[]},o=null,r=function(e){var t,n,i,s,u;n=e.internalDeps(),u=[];for(i=0,s=n.length;i<s;i++)t=n[i],o[t.id]=!0,u.push(r(t));return u},i=function(e){return o==null&&(o={},r(this)),o[e.id]},this.apply=function(r){var o;return o=lt.cached(function(){return s([e].concat(n))}),r.internalDeps=r.internalDeps||o,r.dependsOn=i,r.deps=o,r.toString=function(){return lt.toString(e)+"."+lt.toString(t)+"("+lt.map(lt.toString,n)+")"},r.inspect=function(){return r.toString()},r.desc=function(){return{context:e,method:t,args:n}},r}}return e}(),at=function(){var e,t,n;return e=2<=arguments.length?ht.call(arguments,0,n=arguments.length-1):(n=0,[]),t=arguments[n++],_.apply(null,e).apply(t)},e.when=function(){var t,n,r,i,s,o,u,a,f,l,h,p,d,v,m,g,y,E,x,T;l=1<=arguments.length?ht.call(arguments,0):[];if(l.length===0)return e.never();s=l.length,m="when: expecting arguments in the form (Observable+,function)+",S(m,s%2===0),d=[],f=[],n=0;while(n<s){a=lt.toArray(l[n]),t=l[n+1],u={f:R(t)?t:function(){return t},ixs:[]},v=!1;for(g=0,E=a.length;g<E;g++){p=a[g],r=lt.indexOf(d,p),v||(v=b.isTrigger(p)),r<0&&(d.push(p),r=d.length-1),T=u.ixs;for(y=0,x=T.length;y<x;y++)i=T[y],i.index===r&&i.count++;u.ixs.push({index:r,count:1})}S("At least one EventStream required",v||!a.length),a.length>0&&f.push(u),n+=2}return d.length?(d=lt.map(b.fromObservable,d),o=lt.any(d,function(e){return e.flatten})&&O(lt.map(function(e){return e.obs},d)),h=new c(_.apply(null,[e,"when"].concat(ht.call(l))),function(t){var r,i,s,u,a,l,c;return c=[],s=!1,u=function(e){var t,r,i;i=e.ixs;for(t=0,r=i.length;t<r;t++){n=i[t];if(!d[n.index].hasAtLeast(n.count))return!1}return!0},i=function(e){return!e.sync||e.ended},r=function(e){var t,r,i;i=e.ixs;for(t=0,r=i.length;t<r;t++){n=i[t];if(!d[n.index].mayHave(n.count))return!0}},a=function(e){return!e.source.flatten},l=function(l){return function(p){var v,m,g;return m=function(){return w.whenDoneWith(h,v)},g=function(){var r,i,s,l,h,p;if(!(c.length>0))return e.more;s=e.more,l=c.pop();for(h=0,p=f.length;h<p;h++){i=f[h];if(u(i))return r=function(){var e,t,r,s;r=i.ixs,s=[];for(e=0,t=r.length;e<t;e++)n=r[e],s.push(d[n.index].consume());return s}(),s=t(l.e.apply(function(){var e,t;return t=function(){var t,n,i;i=[];for(t=0,n=r.length;t<n;t++)e=r[t],i.push(e());return i}(),i.f.apply(i,t)})),c.length&&o&&(c=lt.filter(a,c)),s===e.noMore?s:g()}},v=function(){var n;n=g();if(s){s=!1;if(lt.all(d,i)||lt.all(f,r))n=e.noMore,t(D())}return n===e.noMore&&p(),n},l.subscribe(function(n){var r;return n.isEnd()?(s=!0,l.markEnded(),m()):n.isError()?r=t(n):(l.push(n.value),l.sync&&(c.push({source:l,e:n}),o?m():v())),r===e.noMore&&p(),r||e.more})}},A.apply(null,function(){var e,t,n;n=[];for(e=0,t=d.length;e<t;e++)p=d[e],n.push(l(p));return n}())})):e.never()},O=function(t,n){var r;return n==null&&(n=[]),r=function(t){var i;return e._.contains(n,t)?!0:(i=t.internalDeps(),i.length?(n.push(t),e._.any(i,r)):(n.push(t),!1))},e._.any(t,r)},e.update=function(){var t,n,r,i;n=arguments[0],i=2<=arguments.length?ht.call(arguments,1):[],r=function(e){return function(){var t;return t=1<=arguments.length?ht.call(arguments,0):[],function(n){return e.apply(null,[n].concat(t))}}},t=i.length-1;while(t>0)i[t]instanceof Function||(i[t]=function(e){return function(){return e}}(i[t])),i[t]=r(i[t]),t-=2;return at.apply(null,[e,"update",n].concat(ht.call(i),[e.when.apply(e,i).scan(n,function(e,t){return t(e)})]))},A=function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],(new i(e)).unsubscribe},i=function(){function e(e){var t,n,r;e==null&&(e=[]),this.unsubscribe=vt(this.unsubscribe,this),this.unsubscribed=!1,this.subscriptions=[],this.starting=[];for(n=0,r=e.length;n<r;n++)t=e[n],this.add(t)}return e.prototype.add=function(e){var t,n,r;if(this.unsubscribed)return;return t=!1,n=G,this.starting.push(e),r=function(r){return function(){if(r.unsubscribed)return;return t=!0,r.remove(n),lt.remove(e,r.starting)}}(this),n=e(this.unsubscribe,r),!this.unsubscribed&&!t&&this.subscriptions.push(n),lt.remove(e,this.starting),n},e.prototype.remove=function(e){if(this.unsubscribed)return;if(lt.remove(e,this.subscriptions)!==void 0)return e()},e.prototype.unsubscribe=function(){var e,t,n,r;if(this.unsubscribed)return;this.unsubscribed=!0,r=this.subscriptions;for(t=0,n=r.length;t<n;t++)e=r[t],e();return this.subscriptions=[],this.starting=[]},e.prototype.count=function(){return this.unsubscribed?0:this.subscriptions.length+this.starting.length},e.prototype.empty=function(){return this.count()===0},e}(),e.CompositeUnsubscribe=i,y=function(){function e(e){this.value=e}return e.prototype.getOrElse=function(){return this.value},e.prototype.get=function(){return this.value},e.prototype.filter=function(t){return t(this.value)?new e(this.value):d},e.prototype.map=function(t){return new e(t(this.value))},e.prototype.forEach=function(e){return e(this.value)},e.prototype.isDefined=!0,e.prototype.toArray=function(){return[this.value]},e.prototype.inspect=function(){return"Some("+this.value+")"},e.prototype.toString=function(){return this.inspect()},e}(),d={getOrElse:function(e){return e},filter:function(){return d},map:function(){return d},forEach:function(){},isDefined:!1,toArray:function(){return[]},inspect:function(){return"None"},toString:function(){return this.inspect()}},w=function(){var t,n,r,i,s,o,u,a,f,l,c;return a=void 0,f=[],n=[],t=function(e){return a?n.push(e):e()},u=function(e){return!lt.any(f,function(t){return e.obs.dependsOn(t.obs)})},l=function(e,t){return a?f.push({obs:e,f:t}):t()},i=function(){while(!u(f[0]))f.push(f.splice(0,1)[0]);return f.splice(0,1)[0]},s=function(){var e;e=[];while(f.length)e.push(i().f());return e},o=function(e,t,r,i){var o;if(a)return r.apply(t,i);a=e;try{o=r.apply(t,i),s()}finally{a=void 0;while(n.length)r=n.splice(0,1)[0],r()}return o},r=function(){return a?a.id:void 0},c=function(n){return function(r){var i,s,o;return o=!1,i=function(){},s=function(){return o=!0,i()},o||(i=n.subscribeInternal(function(n){return t(function(){var t;if(!o){t=r(n);if(t===e.noMore)return s()}})})),s}},{whenDoneWith:l,inTransaction:o,currentEventId:r,wrappedSubscribe:c}}(),e.EventStream=c,e.Property=m,e.Observable=v,e.Bus=r,e.Initial=h,e.Next=p,e.End=a,e.Error=f,G=function(){},z=function(e,t){return t()},B=function(e,t){return e},F=function(e){return new h(lt.always(e))},Q=function(e){return new p(lt.always(e))},D=function(){return new a},rt=function(e){return e instanceof l?e:Q(e)},L=function(e){return e.slice(0)},S=function(e,t){if(!t)throw e},T=function(e){if(!(e instanceof c))throw"not an EventStream : "+e},N=function(e){return S("not a function : "+e,R(e))},R=function(e){return typeof e=="function"},I=function(e){return e instanceof Array},U=function(e){return e instanceof v},x=function(e){if(!I(e))throw"not an array : "+e},C=function(e){return S("no arguments supported",e.length===0)},k=function(e){if(typeof e!="string")throw"not a string : "+e},Y=function(e,t){return function(){var n;return n=1<=arguments.length?ht.call(arguments,0):[],e.apply(null,t.concat(n))}},K=function(e){return e.length===1&&U(e[0])?lt.always(e[0]):V(e)},V=function(e){return e=Array.prototype.slice.call(e),$.apply(null,e)},$=ft(function(){var e,t;return t=arguments[0],e=2<=arguments.length?ht.call(arguments,1):[],R(t)?e.length?Y(t,e):t:q(t)?it(t,e):lt.always(t)}),X=function(e,t){return $.apply(null,[e].concat(ht.call(t)))},J=function(t){return U(t)?t:e.once(t)},q=function(e){return typeof e=="string"&&e.length>1&&e.charAt(0)==="."},e.isFieldKey=q,it=function(e,t){var n,r;return r=e.slice(1).split("."),n=lt.map(ut(t),r),function(t){var r,i;for(r=0,i=n.length;r<i;r++)e=n[r],t=e(t);return t}},ut=function(e){return function(t){return function(n){var r;return n==null?void 0:(r=n[t],R(r)?r.apply(n,e):r)}}},st=function(e){return e.slice(1)},nt=function(e){var t;return R(e)?e:q(e)?(t=st(e),function(e,n){return e[t](n)}):S("not a function or a field key: "+e,!1)},ot=function(e){return e instanceof y||e===d?e:new y(e)},lt={indexOf:Array.prototype.indexOf?function(e,t){return e.indexOf(t)}:function(e,t){var n,r,i,s;for(n=i=0,s=e.length;i<s;n=++i){r=e[n];if(t===r)return n}return-1},indexWhere:function(e,t){var n,r,i,s;for(n=i=0,s=e.length;i<s;n=++i){r=e[n];if(t(r))return n}return-1},head:function(e){return e[0]},always:function(e){return function(){return e}},negate:function(e){return function(t){return!e(t)}},empty:function(e){return e.length===0},tail:function(e){return e.slice(1,e.length)},filter:function(e,t){var n,r,i,s;n=[];for(i=0,s=t.length;i<s;i++)r=t[i],e(r)&&n.push(r);return n},map:function(e,t){var n,r,i,s;s=[];for(r=0,i=t.length;r<i;r++)n=t[r],s.push(e(n));return s},each:function(e,t){var n,r,i;i=[];for(n in e)r=e[n],i.push(t(n,r));return i},toArray:function(e){return I(e)?e:[e]},contains:function(e,t){return lt.indexOf(e,t)!==-1},id:function(e){return e},last:function(e){return e[e.length-1]},all:function(e,t){var n,r,i;t==null&&(t=lt.id);for(r=0,i=e.length;r<i;r++){n=e[r];if(!t(n))return!1}return!0},any:function(e,t){var n,r,i;t==null&&(t=lt.id);for(r=0,i=e.length;r<i;r++){n=e[r];if(t(n))return!0}return!1},without:function(e,t){return lt.filter(function(t){return t!==e},t)},remove:function(e,t){var n;n=lt.indexOf(t,e);if(n>=0)return t.splice(n,1)},fold:function(e,t,n){var r,i,s;for(i=0,s=e.length;i<s;i++)r=e[i],t=n(t,r);return t},flatMap:function(e,t){return lt.fold(t,[],function(t,n){return t.concat(e(n))})},cached:function(e){var t;return t=d,function(){return t===d&&(t=e(),e=null),t}},toString:function(e){var t,n,r,i;try{return Z++,e==null?"undefined":R(e)?"function":I(e)?Z>5?"[..]":"["+lt.map(lt.toString,e).toString()+"]":(e!=null?e.toString:void 0)!=null&&e.toString!==Object.prototype.toString?e.toString():typeof e=="object"?Z>5?"{..}":(n=function(){var n;n=[];for(r in e){if(!pt.call(e,r))continue;i=function(){try{return e[r]}catch(n){return t=n,t}}(),n.push(lt.toString(r)+":"+lt.toString(i))}return n}(),"{"+n+"}"):e}finally{Z--}}},Z=0,e._=lt,e.scheduler={setTimeout:function(e,t){return setTimeout(e,t)},setInterval:function(e,t){return setInterval(e,t)},clearInterval:function(e){return clearInterval(e)},now:function(){return(new Date).getTime()}},typeof n!="undefined"&&n!==null&&n.amd!=null?(n("lib/bacon",[],function(){return e}),this.Bacon=e):typeof module!="undefined"&&module!==null?(module.exports=e,e.Bacon=e):this.Bacon=e}.call(this),!function(e,t){"function"==typeof n&&n.amd?n("lib/tv4",[],t):"undefined"!=typeof module&&module.exports?module.exports=t():e.tv4=t()}(this,function(){function e(e){return encodeURI(e).replace(/%25[0-9][0-9]/g,function(e){return"%"+e.substring(3)})}function t(t){var n="";c[t.charAt(0)]&&(n=t.charAt(0),t=t.substring(1));var r="",i="",s=!0,o=!1,u=!1;"+"===n?s=!1:"."===n?(i=".",r="."):"/"===n?(i="/",r="/"):"#"===n?(i="#",s=!1):";"===n?(i=";",r=";",o=!0,u=!0):"?"===n?(i="?",r="&",o=!0):"&"===n&&(i="&",r="&",o=!0);for(var a=[],f=t.split(","),l=[],p={},d=0;d<f.length;d++){var v=f[d],m=null;if(-1!==v.indexOf(":")){var g=v.split(":");v=g[0],m=parseInt(g[1],10)}for(var y={};h[v.charAt(v.length-1)];)y[v.charAt(v.length-1)]=!0,v=v.substring(0,v.length-1);var b={truncate:m,name:v,suffices:y};l.push(b),p[v]=b,a.push(v)}var w=function(t){for(var n="",a=0,f=0;f<l.length;f++){var c=l[f],h=t(c.name);if(null===h||void 0===h||Array.isArray(h)&&0===h.length||"object"==typeof h&&0===Object.keys(h).length)a++;else if(n+=f===a?i:r||",",Array.isArray(h)){o&&(n+=c.name+"=");for(var p=0;p<h.length;p++)p>0&&(n+=c.suffices["*"]?r||",":",",c.suffices["*"]&&o&&(n+=c.name+"=")),n+=s?encodeURIComponent(h[p]).replace(/!/g,"%21"):e(h[p])}else if("object"==typeof h){o&&!c.suffices["*"]&&(n+=c.name+"=");var d=!0;for(var v in h)d||(n+=c.suffices["*"]?r||",":","),d=!1,n+=s?encodeURIComponent(v).replace(/!/g,"%21"):e(v),n+=c.suffices["*"]?"=":",",n+=s?encodeURIComponent(h[v]).replace(/!/g,"%21"):e(h[v])}else o&&(n+=c.name,u&&""===h||(n+="=")),null!=c.truncate&&(h=h.substring(0,c.truncate)),n+=s?encodeURIComponent(h).replace(/!/g,"%21"):e(h)}return n};return w.varNames=a,{prefix:i,substitution:w}}function n(e){if(!(this instanceof n))return new n(e);for(var r=e.split("{"),i=[r.shift()],s=[],o=[],u=[];r.length>0;){var a=r.shift(),f=a.split("}")[0],l=a.substring(f.length+1),c=t(f);o.push(c.substitution),s.push(c.prefix),i.push(l),u=u.concat(c.substitution.varNames)}this.fill=function(e){for(var t=i[0],n=0;n<o.length;n++){var r=o[n];t+=r(e),t+=i[n+1]}return t},this.varNames=u,this.template=e}function r(e,t){if(e===t)return!0;if("object"==typeof e&&"object"==typeof t){if(Array.isArray(e)!==Array.isArray(t))return!1;if(Array.isArray(e)){if(e.length!==t.length)return!1;for(var n=0;n<e.length;n++)if(!r(e[n],t[n]))return!1}else{var i;for(i in e)if(void 0===t[i]&&void 0!==e[i])return!1;for(i in t)if(void 0===e[i]&&void 0!==t[i])return!1;for(i in e)if(!r(e[i],t[i]))return!1}return!0}return!1}function i(e){var t=String(e).replace(/^\s+|\s+$/g,"").match(/^([^:\/?#]+:)?(\/\/(?:[^:@]*(?::[^:@]*)?@)?(([^:\/?#]*)(?::(\d*))?))?([^?#]*)(\?[^#]*)?(#[\s\S]*)?/);return t?{href:t[0]||"",protocol:t[1]||"",authority:t[2]||"",host:t[3]||"",hostname:t[4]||"",port:t[5]||"",pathname:t[6]||"",search:t[7]||"",hash:t[8]||""}:null}function s(e,t){function n(e){var t=[];return e.replace(/^(\.\.?(\/|$))+/,"").replace(/\/(\.(\/|$))+/g,"/").replace(/\/\.\.$/,"/../").replace(/\/?[^\/]*/g,function(e){"/.."===e?t.pop():t.push(e)}),t.join("").replace(/^\//,"/"===e.charAt(0)?"/":"")}return t=i(t||""),e=i(e||""),t&&e?(t.protocol||e.protocol)+(t.protocol||t.authority?t.authority:e.authority)+n(t.protocol||t.authority||"/"===t.pathname.charAt(0)?t.pathname:t.pathname?(e.authority&&!e.pathname?"/":"")+e.pathname.slice(0,e.pathname.lastIndexOf("/")+1)+t.pathname:e.pathname)+(t.protocol||t.authority||t.pathname?t.search:t.search||e.search)+t.hash:null}function o(e){return e.split("#")[0]}function u(e,t){if(e&&"object"==typeof e)if(void 0===t?t=e.id:"string"==typeof e.id&&(t=s(t,e.id),e.id=t),Array.isArray(e))for(var n=0;n<e.length;n++)u(e[n],t);else{"string"==typeof e.$ref&&(e.$ref=s(t,e.$ref));for(var r in e)"enum"!==r&&u(e[r],t)}}function a(e,t,n,r,i,s){if(Error.call(this),void 0===e)throw new Error("No code supplied for error: "+t);this.message=t,this.params=n,this.code=e,this.dataPath=r||"",this.schemaPath=i||"",this.subErrors=s||null;var o=new Error(this.message);if(this.stack=o.stack||o.stacktrace,!this.stack)try{throw o}catch(o){this.stack=o.stack||o.stacktrace}}function f(e,t){if(t.substring(0,e.length)===e){var n=t.substring(e.length);if(t.length>0&&"/"===t.charAt(e.length-1)||"#"===n.charAt(0)||"?"===n.charAt(0))return!0}return!1}function l(e){var t=new p,n=e||"en",r={addFormat:function(){t.addFormat.apply(t,arguments)},language:function(e){return e?(y[e]||(e=e.split("-")[0]),y[e]?(n=e,e):!1):n},addLanguage:function(e,t){var n;for(n in d)t[n]&&!t[d[n]]&&(t[d[n]]=t[n]);var r=e.split("-")[0];if(y[r]){y[e]=Object.create(y[r]);for(n in t)"undefined"==typeof y[r][n]&&(y[r][n]=t[n]),y[e][n]=t[n]}else y[e]=t,y[r]=t;return this},freshApi:function(e){var t=l();return e&&t.language(e),t},validate:function(e,r,i,s){var o=new p(t,!1,y[n],i,s);"string"==typeof r&&(r={$ref:r}),o.addSchema("",r);var u=o.validateAll(e,r,null,null,"");return!u&&s&&(u=o.banUnknownProperties()),this.error=u,this.missing=o.missing,this.valid=null===u,this.valid},validateResult:function(){var e={};return this.validate.apply(e,arguments),e},validateMultiple:function(e,r,i,s){var o=new p(t,!0,y[n],i,s);"string"==typeof r&&(r={$ref:r}),o.addSchema("",r),o.validateAll(e,r,null,null,""),s&&o.banUnknownProperties();var u={};return u.errors=o.errors,u.missing=o.missing,u.valid=0===u.errors.length,u},addSchema:function(){return t.addSchema.apply(t,arguments)},getSchema:function(){return t.getSchema.apply(t,arguments)},getSchemaMap:function(){return t.getSchemaMap.apply(t,arguments)},getSchemaUris:function(){return t.getSchemaUris.apply(t,arguments)},getMissingUris:function(){return t.getMissingUris.apply(t,arguments)},dropSchemas:function(){t.dropSchemas.apply(t,arguments)},defineKeyword:function(){t.defineKeyword.apply(t,arguments)},defineError:function(e,t,n){if("string"!=typeof e||!/^[A-Z]+(_[A-Z]+)*$/.test(e))throw new Error("Code name must be a string in UPPER_CASE_WITH_UNDERSCORES");if("number"!=typeof t||t%1!==0||1e4>t)throw new Error("Code number must be an integer > 10000");if("undefined"!=typeof d[e])throw new Error("Error already defined: "+e+" as "+d[e]);if("undefined"!=typeof v[t])throw new Error("Error code already used: "+v[t]+" as "+t);d[e]=t,v[t]=e,g[e]=g[t]=n;for(var r in y){var i=y[r];i[e]&&(i[t]=i[t]||i[e])}},reset:function(){t.reset(),this.error=null,this.missing=[],this.valid=!0},missing:[],error:null,valid:!0,normSchema:u,resolveUrl:s,getDocumentUri:o,errorCodes:d};return r}Object.keys||(Object.keys=function(){var e=Object.prototype.hasOwnProperty,t=!{toString:null}.propertyIsEnumerable("toString"),n=["toString","toLocaleString","valueOf","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","constructor"],r=n.length;return function(i){if("object"!=typeof i&&"function"!=typeof i||null===i)throw new TypeError("Object.keys called on non-object");var s=[];for(var o in i)e.call(i,o)&&s.push(o);if(t)for(var u=0;r>u;u++)e.call(i,n[u])&&s.push(n[u]);return s}}()),Object.create||(Object.create=function(){function e(){}return function(t){if(1!==arguments.length)throw new Error("Object.create implementation only accepts one parameter.");return e.prototype=t,new e}}()),Array.isArray||(Array.isArray=function(e){return"[object Array]"===Object.prototype.toString.call(e)}),Array.prototype.indexOf||(Array.prototype.indexOf=function(e){if(null===this)throw new TypeError;var t=Object(this),n=t.length>>>0;if(0===n)return-1;var r=0;if(arguments.length>1&&(r=Number(arguments[1]),r!==r?r=0:0!==r&&1/0!==r&&r!==-1/0&&(r=(r>0||-1)*Math.floor(Math.abs(r)))),r>=n)return-1;for(var i=r>=0?r:Math.max(n-Math.abs(r),0);n>i;i++)if(i in t&&t[i]===e)return i;return-1}),Object.isFrozen||(Object.isFrozen=function(e){for(var t="tv4_test_frozen_key";e.hasOwnProperty(t);)t+=Math.random();try{return e[t]=!0,delete e[t],!1}catch(n){return!0}});var c={"+":!0,"#":!0,".":!0,"/":!0,";":!0,"?":!0,"&":!0},h={"*":!0};n.prototype={toString:function(){return this.template},fillFromObject:function(e){return this.fill(function(t){return e[t]})}};var p=function(e,t,n,r,i){if(this.missing=[],this.missingMap={},this.formatValidators=e?Object.create(e.formatValidators):{},this.schemas=e?Object.create(e.schemas):{},this.collectMultiple=t,this.errors=[],this.handleError=t?this.collectError:this.returnError,r&&(this.checkRecursive=!0,this.scanned=[],this.scannedFrozen=[],this.scannedFrozenSchemas=[],this.scannedFrozenValidationErrors=[],this.validatedSchemasKey="tv4_validation_id",this.validationErrorsKey="tv4_validation_errors_id"),i&&(this.trackUnknownProperties=!0,this.knownPropertyPaths={},this.unknownPropertyPaths={}),this.errorMessages=n,this.definedKeywords={},e)for(var s in e.definedKeywords)this.definedKeywords[s]=e.definedKeywords[s].slice(0)};p.prototype.defineKeyword=function(e,t){this.definedKeywords[e]=this.definedKeywords[e]||[],this.definedKeywords[e].push(t)},p.prototype.createError=function(e,t,n,r,i){var s=this.errorMessages[e]||g[e];if("string"!=typeof s)return new a(e,"Unknown error code "+e+": "+JSON.stringify(t),t,n,r,i);var o=s.replace(/\{([^{}]*)\}/g,function(e,n){var r=t[n];return"string"==typeof r||"number"==typeof r?r:e});return new a(e,o,t,n,r,i)},p.prototype.returnError=function(e){return e},p.prototype.collectError=function(e){return e&&this.errors.push(e),null},p.prototype.prefixErrors=function(e,t,n){for(var r=e;r<this.errors.length;r++)this.errors[r]=this.errors[r].prefixWith(t,n);return this},p.prototype.banUnknownProperties=function(){for(var e in this.unknownPropertyPaths){var t=this.createError(d.UNKNOWN_PROPERTY,{path:e},e,""),n=this.handleError(t);if(n)return n}return null},p.prototype.addFormat=function(e,t){if("object"==typeof e){for(var n in e)this.addFormat(n,e[n]);return this}this.formatValidators[e]=t},p.prototype.resolveRefs=function(e,t){if(void 0!==e.$ref){if(t=t||{},t[e.$ref])return this.createError(d.CIRCULAR_REFERENCE,{urls:Object.keys(t).join(", ")},"","");t[e.$ref]=!0,e=this.getSchema(e.$ref,t)}return e},p.prototype.getSchema=function(e,t){var n;if(void 0!==this.schemas[e])return n=this.schemas[e],this.resolveRefs(n,t);var r=e,i="";if(-1!==e.indexOf("#")&&(i=e.substring(e.indexOf("#")+1),r=e.substring(0,e.indexOf("#"))),"object"==typeof this.schemas[r]){n=this.schemas[r];var s=decodeURIComponent(i);if(""===s)return this.resolveRefs(n,t);if("/"!==s.charAt(0))return void 0;for(var o=s.split("/").slice(1),u=0;u<o.length;u++){var a=o[u].replace(/~1/g,"/").replace(/~0/g,"~");if(void 0===n[a]){n=void 0;break}n=n[a]}if(void 0!==n)return this.resolveRefs(n,t)}void 0===this.missing[r]&&(this.missing.push(r),this.missing[r]=r,this.missingMap[r]=r)},p.prototype.searchSchemas=function(e,t){if(e&&"object"==typeof e){"string"==typeof e.id&&f(t,e.id)&&void 0===this.schemas[e.id]&&(this.schemas[e.id]=e);for(var n in e)if("enum"!==n)if("object"==typeof e[n])this.searchSchemas(e[n],t);else if("$ref"===n){var r=o(e[n]);r&&void 0===this.schemas[r]&&void 0===this.missingMap[r]&&(this.missingMap[r]=r)}}},p.prototype.addSchema=function(e,t){if("string"!=typeof e||"undefined"==typeof t){if("object"!=typeof e||"string"!=typeof e.id)return;t=e,e=t.id}e===o(e)+"#"&&(e=o(e)),this.schemas[e]=t,delete this.missingMap[e],u(t,e),this.searchSchemas(t,e)},p.prototype.getSchemaMap=function(){var e={};for(var t in this.schemas)e[t]=this.schemas[t];return e},p.prototype.getSchemaUris=function(e){var t=[];for(var n in this.schemas)(!e||e.test(n))&&t.push(n);return t},p.prototype.getMissingUris=function(e){var t=[];for(var n in this.missingMap)(!e||e.test(n))&&t.push(n);return t},p.prototype.dropSchemas=function(){this.schemas={},this.reset()},p.prototype.reset=function(){this.missing=[],this.missingMap={},this.errors=[]},p.prototype.validateAll=function(e,t,n,r,i){var s;if(t=this.resolveRefs(t),!t)return null;if(t instanceof a)return this.errors.push(t),t;var o,u=this.errors.length,f=null,l=null;if(this.checkRecursive&&e&&"object"==typeof e){if(s=!this.scanned.length,e[this.validatedSchemasKey]){var c=e[this.validatedSchemasKey].indexOf(t);if(-1!==c)return this.errors=this.errors.concat(e[this.validationErrorsKey][c]),null}if(Object.isFrozen(e)&&(o=this.scannedFrozen.indexOf(e),-1!==o)){var h=this.scannedFrozenSchemas[o].indexOf(t);if(-1!==h)return this.errors=this.errors.concat(this.scannedFrozenValidationErrors[o][h]),null}if(this.scanned.push(e),Object.isFrozen(e))-1===o&&(o=this.scannedFrozen.length,this.scannedFrozen.push(e),this.scannedFrozenSchemas.push([])),f=this.scannedFrozenSchemas[o].length,this.scannedFrozenSchemas[o][f]=t,this.scannedFrozenValidationErrors[o][f]=[];else{if(!e[this.validatedSchemasKey])try{Object.defineProperty(e,this.validatedSchemasKey,{value:[],configurable:!0}),Object.defineProperty(e,this.validationErrorsKey,{value:[],configurable:!0})}catch(p){e[this.validatedSchemasKey]=[],e[this.validationErrorsKey]=[]}l=e[this.validatedSchemasKey].length,e[this.validatedSchemasKey][l]=t,e[this.validationErrorsKey][l]=[]}}var d=this.errors.length,v=this.validateBasic(e,t,i)||this.validateNumeric(e,t,i)||this.validateString(e,t,i)||this.validateArray(e,t,i)||this.validateObject(e,t,i)||this.validateCombinations(e,t,i)||this.validateHypermedia(e,t,i)||this.validateFormat(e,t,i)||this.validateDefinedKeywords(e,t,i)||null;if(s){for(;this.scanned.length;){var m=this.scanned.pop();delete m[this.validatedSchemasKey]}this.scannedFrozen=[],this.scannedFrozenSchemas=[]}if(v||d!==this.errors.length)for(;n&&n.length||r&&r.length;){var g=n&&n.length?""+n.pop():null,y=r&&r.length?""+r.pop():null;v&&(v=v.prefixWith(g,y)),this.prefixErrors(d,g,y)}return null!==f?this.scannedFrozenValidationErrors[o][f]=this.errors.slice(u):null!==l&&(e[this.validationErrorsKey][l]=this.errors.slice(u)),this.handleError(v)},p.prototype.validateFormat=function(e,t){if("string"!=typeof t.format||!this.formatValidators[t.format])return null;var n=this.formatValidators[t.format].call(null,e,t);return"string"==typeof n||"number"==typeof n?this.createError(d.FORMAT_CUSTOM,{message:n}).prefixWith(null,"format"):n&&"object"==typeof n?this.createError(d.FORMAT_CUSTOM,{message:n.message||"?"},n.dataPath||null,n.schemaPath||"/format"):null},p.prototype.validateDefinedKeywords=function(e,t){for(var n in this.definedKeywords)if("undefined"!=typeof t[n])for(var r=this.definedKeywords[n],i=0;i<r.length;i++){var s=r[i],o=s(e,t[n],t);if("string"==typeof o||"number"==typeof o)return this.createError(d.KEYWORD_CUSTOM,{key:n,message:o}).prefixWith(null,"format");if(o&&"object"==typeof o){var u=o.code||d.KEYWORD_CUSTOM;if("string"==typeof u){if(!d[u])throw new Error("Undefined error code (use defineError): "+u);u=d[u]}var a="object"==typeof o.message?o.message:{key:n,message:o.message||"?"},f=o.schemaPath||"/"+n.replace(/~/g,"~0").replace(/\//g,"~1");return this.createError(u,a,o.dataPath||null,f)}}return null},p.prototype.validateBasic=function(e,t,n){var r;return(r=this.validateType(e,t,n))?r.prefixWith(null,"type"):(r=this.validateEnum(e,t,n))?r.prefixWith(null,"type"):null},p.prototype.validateType=function(e,t){if(void 0===t.type)return null;var n=typeof e;null===e?n="null":Array.isArray(e)&&(n="array");var r=t.type;"object"!=typeof r&&(r=[r]);for(var i=0;i<r.length;i++){var s=r[i];if(s===n||"integer"===s&&"number"===n&&e%1===0)return null}return this.createError(d.INVALID_TYPE,{type:n,expected:r.join("/")})},p.prototype.validateEnum=function(e,t){if(void 0===t["enum"])return null;for(var n=0;n<t["enum"].length;n++){var i=t["enum"][n];if(r(e,i))return null}return this.createError(d.ENUM_MISMATCH,{value:"undefined"!=typeof JSON?JSON.stringify(e):e})},p.prototype.validateNumeric=function(e,t,n){return this.validateMultipleOf(e,t,n)||this.validateMinMax(e,t,n)||null},p.prototype.validateMultipleOf=function(e,t){var n=t.multipleOf||t.divisibleBy;return void 0===n?null:"number"==typeof e&&e%n!==0?this.createError(d.NUMBER_MULTIPLE_OF,{value:e,multipleOf:n}):null},p.prototype.validateMinMax=function(e,t){if("number"!=typeof e)return null;if(void 0!==t.minimum){if(e<t.minimum)return this.createError(d.NUMBER_MINIMUM,{value:e,minimum:t.minimum}).prefixWith(null,"minimum");if(t.exclusiveMinimum&&e===t.minimum)return this.createError(d.NUMBER_MINIMUM_EXCLUSIVE,{value:e,minimum:t.minimum}).prefixWith(null,"exclusiveMinimum")}if(void 0!==t.maximum){if(e>t.maximum)return this.createError(d.NUMBER_MAXIMUM,{value:e,maximum:t.maximum}).prefixWith(null,"maximum");if(t.exclusiveMaximum&&e===t.maximum)return this.createError(d.NUMBER_MAXIMUM_EXCLUSIVE,{value:e,maximum:t.maximum}).prefixWith(null,"exclusiveMaximum")}return null},p.prototype.validateString=function(e,t,n){return this.validateStringLength(e,t,n)||this.validateStringPattern(e,t,n)||null},p.prototype.validateStringLength=function(e,t){return"string"!=typeof e?null:void 0!==t.minLength&&e.length<t.minLength?this.createError(d.STRING_LENGTH_SHORT,{length:e.length,minimum:t.minLength}).prefixWith(null,"minLength"):void 0!==t.maxLength&&e.length>t.maxLength?this.createError(d.STRING_LENGTH_LONG,{length:e.length,maximum:t.maxLength}).prefixWith(null,"maxLength"):null},p.prototype.validateStringPattern=function(e,t){if("string"!=typeof e||void 0===t.pattern)return null;var n=new RegExp(t.pattern);return n.test(e)?null:this.createError(d.STRING_PATTERN,{pattern:t.pattern}).prefixWith(null,"pattern")},p.prototype.validateArray=function(e,t,n){return Array.isArray(e)?this.validateArrayLength(e,t,n)||this.validateArrayUniqueItems(e,t,n)||this.validateArrayItems(e,t,n)||null:null},p.prototype.validateArrayLength=function(e,t){var n;return void 0!==t.minItems&&e.length<t.minItems&&(n=this.createError(d.ARRAY_LENGTH_SHORT,{length:e.length,minimum:t.minItems}).prefixWith(null,"minItems"),this.handleError(n))?n:void 0!==t.maxItems&&e.length>t.maxItems&&(n=this.createError(d.ARRAY_LENGTH_LONG,{length:e.length,maximum:t.maxItems}).prefixWith(null,"maxItems"),this.handleError(n))?n:null},p.prototype.validateArrayUniqueItems=function(e,t){if(t.uniqueItems)for(var n=0;n<e.length;n++)for(var i=n+1;i<e.length;i++)if(r(e[n],e[i])){var s=this.createError(d.ARRAY_UNIQUE,{match1:n,match2:i}).prefixWith(null,"uniqueItems");if(this.handleError(s))return s}return null},p.prototype.validateArrayItems=function(e,t,n){if(void 0===t.items)return null;var r,i;if(Array.isArray(t.items)){for(i=0;i<e.length;i++)if(i<t.items.length){if(r=this.validateAll(e[i],t.items[i],[i],["items",i],n+"/"+i))return r}else if(void 0!==t.additionalItems)if("boolean"==typeof t.additionalItems){if(!t.additionalItems&&(r=this.createError(d.ARRAY_ADDITIONAL_ITEMS,{}).prefixWith(""+i,"additionalItems"),this.handleError(r)))return r}else if(r=this.validateAll(e[i],t.additionalItems,[i],["additionalItems"],n+"/"+i))return r}else for(i=0;i<e.length;i++)if(r=this.validateAll(e[i],t.items,[i],["items"],n+"/"+i))return r;return null},p.prototype.validateObject=function(e,t,n){return"object"!=typeof e||null===e||Array.isArray(e)?null:this.validateObjectMinMaxProperties(e,t,n)||this.validateObjectRequiredProperties(e,t,n)||this.validateObjectProperties(e,t,n)||this.validateObjectDependencies(e,t,n)||null},p.prototype.validateObjectMinMaxProperties=function(e,t){var n,r=Object.keys(e);return void 0!==t.minProperties&&r.length<t.minProperties&&(n=this.createError(d.OBJECT_PROPERTIES_MINIMUM,{propertyCount:r.length,minimum:t.minProperties}).prefixWith(null,"minProperties"),this.handleError(n))?n:void 0!==t.maxProperties&&r.length>t.maxProperties&&(n=this.createError(d.OBJECT_PROPERTIES_MAXIMUM,{propertyCount:r.length,maximum:t.maxProperties}).prefixWith(null,"maxProperties"),this.handleError(n))?n:null},p.prototype.validateObjectRequiredProperties=function(e,t){if(void 0!==t.required)for(var n=0;n<t.required.length;n++){var r=t.required[n];if(void 0===e[r]){var i=this.createError(d.OBJECT_REQUIRED,{key:r}).prefixWith(null,""+n).prefixWith(null,"required");if(this.handleError(i))return i}}return null},p.prototype.validateObjectProperties=function(e,t,n){var r;for(var i in e){var s=n+"/"+i.replace(/~/g,"~0").replace(/\//g,"~1"),o=!1;if(void 0!==t.properties&&void 0!==t.properties[i]&&(o=!0,r=this.validateAll(e[i],t.properties[i],[i],["properties",i],s)))return r;if(void 0!==t.patternProperties)for(var u in t.patternProperties){var a=new RegExp(u);if(a.test(i)&&(o=!0,r=this.validateAll(e[i],t.patternProperties[u],[i],["patternProperties",u],s)))return r}if(o)this.trackUnknownProperties&&(this.knownPropertyPaths[s]=!0,delete this.unknownPropertyPaths[s]);else if(void 0!==t.additionalProperties){if(this.trackUnknownProperties&&(this.knownPropertyPaths[s]=!0,delete this.unknownPropertyPaths[s]),"boolean"==typeof t.additionalProperties){if(!t.additionalProperties&&(r=this.createError(d.OBJECT_ADDITIONAL_PROPERTIES,{}).prefixWith(i,"additionalProperties"),this.handleError(r)))return r}else if(r=this.validateAll(e[i],t.additionalProperties,[i],["additionalProperties"],s))return r}else this.trackUnknownProperties&&!this.knownPropertyPaths[s]&&(this.unknownPropertyPaths[s]=!0)}return null},p.prototype.validateObjectDependencies=function(e,t,n){var r;if(void 0!==t.dependencies)for(var i in t.dependencies)if(void 0!==e[i]){var s=t.dependencies[i];if("string"==typeof s){if(void 0===e[s]&&(r=this.createError(d.OBJECT_DEPENDENCY_KEY,{key:i,missing:s}).prefixWith(null,i).prefixWith(null,"dependencies"),this.handleError(r)))return r}else if(Array.isArray(s))for(var o=0;o<s.length;o++){var u=s[o];if(void 0===e[u]&&(r=this.createError(d.OBJECT_DEPENDENCY_KEY,{key:i,missing:u}).prefixWith(null,""+o).prefixWith(null,i).prefixWith(null,"dependencies"),this.handleError(r)))return r}else if(r=this.validateAll(e,s,[],["dependencies",i],n))return r}return null},p.prototype.validateCombinations=function(e,t,n){return this.validateAllOf(e,t,n)||this.validateAnyOf(e,t,n)||this.validateOneOf(e,t,n)||this.validateNot(e,t,n)||null},p.prototype.validateAllOf=function(e,t,n){if(void 0===t.allOf)return null;for(var r,i=0;i<t.allOf.length;i++){var s=t.allOf[i];if(r=this.validateAll(e,s,[],["allOf",i],n))return r}return null},p.prototype.validateAnyOf=function(e,t,n){if(void 0===t.anyOf)return null;var r,i,s=[],o=this.errors.length;this.trackUnknownProperties&&(r=this.unknownPropertyPaths,i=this.knownPropertyPaths);for(var u=!0,a=0;a<t.anyOf.length;a++){this.trackUnknownProperties&&(this.unknownPropertyPaths={},this.knownPropertyPaths={});var f=t.anyOf[a],l=this.errors.length,c=this.validateAll(e,f,[],["anyOf",a],n);if(null===c&&l===this.errors.length){if(this.errors=this.errors.slice(0,o),this.trackUnknownProperties){for(var h in this.knownPropertyPaths)i[h]=!0,delete r[h];for(var p in this.unknownPropertyPaths)i[p]||(r[p]=!0);u=!1;continue}return null}c&&s.push(c.prefixWith(null,""+a).prefixWith(null,"anyOf"))}return this.trackUnknownProperties&&(this.unknownPropertyPaths=r,this.knownPropertyPaths=i),u?(s=s.concat(this.errors.slice(o)),this.errors=this.errors.slice(0,o),this.createError(d.ANY_OF_MISSING,{},"","/anyOf",s)):void 0},p.prototype.validateOneOf=function(e,t,n){if(void 0===t.oneOf)return null;var r,i,s=null,o=[],u=this.errors.length;this.trackUnknownProperties&&(r=this.unknownPropertyPaths,i=this.knownPropertyPaths);for(var a=0;a<t.oneOf.length;a++){this.trackUnknownProperties&&(this.unknownPropertyPaths={},this.knownPropertyPaths={});var f=t.oneOf[a],l=this.errors.length,c=this.validateAll(e,f,[],["oneOf",a],n);if(null===c&&l===this.errors.length){if(null!==s)return this.errors=this.errors.slice(0,u),this.createError(d.ONE_OF_MULTIPLE,{index1:s,index2:a},"","/oneOf");if(s=a,this.trackUnknownProperties){for(var h in this.knownPropertyPaths)i[h]=!0,delete r[h];for(var p in this.unknownPropertyPaths)i[p]||(r[p]=!0)}}else c&&o.push(c)}return this.trackUnknownProperties&&(this.unknownPropertyPaths=r,this.knownPropertyPaths=i),null===s?(o=o.concat(this.errors.slice(u)),this.errors=this.errors.slice(0,u),this.createError(d.ONE_OF_MISSING,{},"","/oneOf",o)):(this.errors=this.errors.slice(0,u),null)},p.prototype.validateNot=function(e,t,n){if(void 0===t.not)return null;var r,i,s=this.errors.length;this.trackUnknownProperties&&(r=this.unknownPropertyPaths,i=this.knownPropertyPaths,this.unknownPropertyPaths={},this.knownPropertyPaths={});var o=this.validateAll(e,t.not,null,null,n),u=this.errors.slice(s);return this.errors=this.errors.slice(0,s),this.trackUnknownProperties&&(this.unknownPropertyPaths=r,this.knownPropertyPaths=i),null===o&&0===u.length?this.createError(d.NOT_PASSED,{},"","/not"):null},p.prototype.validateHypermedia=function(e,t,r){if(!t.links)return null;for(var i,s=0;s<t.links.length;s++){var o=t.links[s];if("describedby"===o.rel){for(var u=new n(o.href),a=!0,f=0;f<u.varNames.length;f++)if(!(u.varNames[f]in e)){a=!1;break}if(a){var l=u.fillFromObject(e),c={$ref:l};if(i=this.validateAll(e,c,[],["links",s],r))return i}}}};var d={INVALID_TYPE:0,ENUM_MISMATCH:1,ANY_OF_MISSING:10,ONE_OF_MISSING:11,ONE_OF_MULTIPLE:12,NOT_PASSED:13,NUMBER_MULTIPLE_OF:100,NUMBER_MINIMUM:101,NUMBER_MINIMUM_EXCLUSIVE:102,NUMBER_MAXIMUM:103,NUMBER_MAXIMUM_EXCLUSIVE:104,STRING_LENGTH_SHORT:200,STRING_LENGTH_LONG:201,STRING_PATTERN:202,OBJECT_PROPERTIES_MINIMUM:300,OBJECT_PROPERTIES_MAXIMUM:301,OBJECT_REQUIRED:302,OBJECT_ADDITIONAL_PROPERTIES:303,OBJECT_DEPENDENCY_KEY:304,ARRAY_LENGTH_SHORT:400,ARRAY_LENGTH_LONG:401,ARRAY_UNIQUE:402,ARRAY_ADDITIONAL_ITEMS:403,FORMAT_CUSTOM:500,KEYWORD_CUSTOM:501,CIRCULAR_REFERENCE:600,UNKNOWN_PROPERTY:1e3},v={};for(var m in d)v[d[m]]=m;var g={INVALID_TYPE:"Invalid type: {type} (expected {expected})",ENUM_MISMATCH:"No enum match for: {value}",ANY_OF_MISSING:'Data does not match any schemas from "anyOf"',ONE_OF_MISSING:'Data does not match any schemas from "oneOf"',ONE_OF_MULTIPLE:'Data is valid against more than one schema from "oneOf": indices {index1} and {index2}',NOT_PASSED:'Data matches schema from "not"',NUMBER_MULTIPLE_OF:"Value {value} is not a multiple of {multipleOf}",NUMBER_MINIMUM:"Value {value} is less than minimum {minimum}",NUMBER_MINIMUM_EXCLUSIVE:"Value {value} is equal to exclusive minimum {minimum}",NUMBER_MAXIMUM:"Value {value} is greater than maximum {maximum}",NUMBER_MAXIMUM_EXCLUSIVE:"Value {value} is equal to exclusive maximum {maximum}",STRING_LENGTH_SHORT:"String is too short ({length} chars), minimum {minimum}",STRING_LENGTH_LONG:"String is too long ({length} chars), maximum {maximum}",STRING_PATTERN:"String does not match pattern: {pattern}",OBJECT_PROPERTIES_MINIMUM:"Too few properties defined ({propertyCount}), minimum {minimum}",OBJECT_PROPERTIES_MAXIMUM:"Too many properties defined ({propertyCount}), maximum {maximum}",OBJECT_REQUIRED:"Missing required property: {key}",OBJECT_ADDITIONAL_PROPERTIES:"Additional properties not allowed",OBJECT_DEPENDENCY_KEY:"Dependency failed - key must exist: {missing} (due to key: {key})",ARRAY_LENGTH_SHORT:"Array is too short ({length}), minimum {minimum}",ARRAY_LENGTH_LONG:"Array is too long ({length}), maximum {maximum}",ARRAY_UNIQUE:"Array items are not unique (indices {match1} and {match2})",ARRAY_ADDITIONAL_ITEMS:"Additional items not allowed",FORMAT_CUSTOM:"Format validation failed ({message})",KEYWORD_CUSTOM:"Keyword failed: {key} ({message})",CIRCULAR_REFERENCE:"Circular $refs: {urls}",UNKNOWN_PROPERTY:"Unknown property (not in schema)"};a.prototype=Object.create(Error.prototype),a.prototype.constructor=a,a.prototype.name="ValidationError",a.prototype.prefixWith=function(e,t){if(null!==e&&(e=e.replace(/~/g,"~0").replace(/\//g,"~1"),this.dataPath="/"+e+this.dataPath),null!==t&&(t=t.replace(/~/g,"~0").replace(/\//g,"~1"),this.schemaPath="/"+t+this.schemaPath),null!==this.subErrors)for(var n=0;n<this.subErrors.length;n++)this.subErrors[n].prefixWith(e,t);return this};var y={},b=l();return b.addLanguage("en-gb",g),b.tv4=b,b}),n("Map",["utils","Draw","Behavior","Scale","build","UndoStack","CallbackManager","KeyManager","Canvas","data_styles","SearchIndex","lib/bacon","lib/tv4"],function(e,t,n,r,i,s,o,u,a,f,l,c,h){function d(i,f,c,h,p,d,v,m,g,y,b){if(v===null){var w=h.get_size();v={x:-w.width,y:-w.height,width:w.width*3,height:w.height*3}}g===undefined||g===null||g==""?g="new_map":g=String(g),y===undefined||y===null||y==""?y=e.random_characters(12):y=String(y),b===undefined||b===null?b="":b=String(b),this.callback_manager=new o,this.svg=i,this.defs=e.setup_defs(i,f),this.canvas=new a(c,v),this.setup_containers(c),this.sel=c,this.zoom_container=h,this.settings=p,this.cobra_model=d,this.largest_ids={reactions:-1,nodes:-1,segments:-1,text_labels:-1},this.scale=new r,this.calc_data_stats("reaction"),this.calc_data_stats("metabolite"),this.scale.connect_to_settings(this.settings,this,q.bind(this)),this.undo_stack=new s,this.behavior=new n(this,this.undo_stack),this.draw=new t(this.behavior,this.settings),this.key_manager=new u(this.settings.get_option("unique_map_id")),this.enable_search=m,this.search_index=new l,this.map_name=g,this.map_id=y,this.map_description=b;var E={x:0,y:0},S=1;this.beziers_enabled=!1,this.has_data_on_reactions=!1,this.has_data_on_nodes=!1,this.nodes={},this.reactions={},this.beziers={},this.text_labels={},this.apply_reaction_data_to_map(null),this.apply_metabolite_data_to_map(null),this.apply_gene_data_to_map(null),this.rotation_on=!1,this.debug=!1}function v(t,n,r,s,o,u,a,f){function P(e,t){return t===undefined&&(t=0),e===undefined?t:Math.max.apply(null,Object.keys(e).map(function(e){return parseInt(e)}).concat([t]))}var l=t[1].canvas,c=t[0].map_name,h=t[0].map_id,d=t[0].map_description.replace(/(\nLast Modified.*)+$/g,"")+"\nLast Modified "+Date(Date.now()).toString(),v=new p(n,r,s,o,u,a,l,f,c,h,d);v.reactions=t[1].reactions,v.nodes=t[1].nodes,v.text_labels=t[1].text_labels;for(var m in v.nodes){var g=v.nodes[m];g.connected_segments=[];if(f){if(g.node_type!="metabolite")continue;v.search_index.insert("n"+m,{name:g.bigg_id,data:{type:"metabolite",node_id:m}}),v.search_index.insert("n_name"+m,{name:g.name,data:{type:"metabolite",node_id:m}})}}for(var y in v.reactions){var b=v.reactions[y];if(f){v.search_index.insert("r"+y,{name:b.bigg_id,data:{type:"reaction",reaction_id:y}}),v.search_index.insert("r_name"+y,{name:b.name,data:{type:"reaction",reaction_id:y}});for(var w in b.genes){var E=b.genes[w];v.search_index.insert("r"+y+"_g"+w,{name:E.bigg_id,data:{type:"reaction",reaction_id:y}}),v.search_index.insert("r"+y+"_g_name"+w,{name:E.name,data:{type:"reaction",reaction_id:y}})}}var S=[];for(var x in b.segments){var T=b.segments[x];T.reversibility=b.reversibility;if(!(T.from_node_id in v.nodes&&T.to_node_id in v.nodes)){console.warn("Bad node references in segment "+x+". Deleting segment."),S.push(x);continue}var N=v.nodes[T.from_node_id],C=v.nodes[T.to_node_id];b.metabolites.forEach(function(e){e.bigg_id==N.bigg_id?T.from_node_coefficient=e.coefficient:e.bigg_id==C.bigg_id&&(T.to_node_coefficient=e.coefficient)}),[N,C].forEach(function(e){e.connected_segments.push({segment_id:x,reaction_id:y})});var k=v.nodes[T.from_node_id],L=v.nodes[T.to_node_id];if(k["node_type"]=="metabolite"||L["node_type"]=="metabolite"){var A=e.c_plus_c(k,e.c_times_scalar(e.c_minus_c(L,k),.5));T.b1===null&&(T.b1=A),T.b2===null&&(T.b2=A)}}S.forEach(function(e){delete b.segments[e]})}if(f)for(var O in v.text_labels){var M=v.text_labels[O];v.search_index.insert("l"+O,{name:M.text,data:{type:"text_label",text_label_id:O}})}v.beziers=i.new_beziers_for_reactions(v.reactions),v.largest_ids.reactions=P(v.reactions),v.largest_ids.nodes=P(v.nodes),v.largest_ids.text_labels=P(v.text_labels);var _=0;for(var D in v.reactions)_=P(v.reactions[D].segments,_);return v.largest_ids.segments=_,v.apply_reaction_data_to_map(null),v.apply_metabolite_data_to_map(null),v.apply_gene_data_to_map(null),v}function m(e){e.append("g").attr("id","reactions"),e.append("g").attr("id","nodes"),e.append("g").attr("id","beziers"),e.append("g").attr("id","text-labels")}function g(){this.sel.select("#reactions").selectAll(".reaction").remove(),this.sel.select("#nodes").selectAll(".node").remove(),this.sel.select("#beziers").selectAll(".bezier").remove(),this.sel.select("#text-labels").selectAll(".text-label").remove()}function y(e,t){this.callback_manager.run("set_status",null,e),window.clearTimeout(this._status_timer),this._status_timer=null,t!==undefined&&(this._status_timer=window.setTimeout(function(){this.callback_manager.run("set_status",null,"")}.bind(this),t))}function b(){this.reactions={},this.beziers={},this.nodes={},this.text_labels={},this.apply_reaction_data_to_map(null),this.apply_metabolite_data_to_map(null),this.apply_gene_data_to_map(null),this.draw_everything()}function w(){return this.cobra_model!==null}function E(){this.draw_all_reactions(!0,!0),this.draw_all_nodes(!0),this.draw_all_text_labels()}function S(e,t){e===undefined&&(e=!0),t===undefined&&(t=!0);var n=[];for(var r in this.reactions)n.push(r);this.draw_these_reactions(n,!1),e&&this.beziers_enabled&&this.draw_all_beziers(),t&&this.clear_deleted_reactions(e)}function x(t,n){n===undefined&&(n=!0);var r=e.object_slice_for_ids_ref(this.reactions,t),s=function(e){return this.draw.update_reaction(e,this.scale,this.cobra_model,this.nodes,this.defs,this.has_data_on_reactions)}.bind(this);e.draw_an_object(this.sel,"#reactions",".reaction",r,"reaction_id",this.draw.create_reaction.bind(this.draw),s);if(n){var o=i.bezier_ids_for_reaction_ids(r);this.draw_these_beziers(o)}}function T(t){function n(t){e.draw_a_nested_object(t,".segment-group","segments","segment_id",null,null,function(e){e.remove()})}t===undefined&&(t=!0),e.draw_an_object(this.sel,"#reactions",".reaction",this.reactions,"reaction_id",null,n,function(e){e.remove()}),t==1&&this.clear_deleted_beziers()}function N(e){e===undefined&&(e=!0);var t=[];for(var n in this.nodes)t.push(n);this.draw_these_nodes(t),e&&this.clear_deleted_nodes()}function C(t){var n=e.object_slice_for_ids_ref(this.nodes,t),r=function(e){return this.draw.create_node(e,this.nodes,this.reactions)}.bind(this),i=function(e){return this.draw.update_node(e,this.scale,this.has_data_on_nodes,this.settings.get_option("identifiers_on_map"),this.settings.get_option("metabolite_styles"),{color:this.settings.get_option("metabolite_no_data_color"),size:this.settings.get_option("metabolite_no_data_size")},this.behavior.selectable_mousedown,this.behavior.selectable_click,this.behavior.node_mouseover,this.behavior.node_mouseout,this.behavior.selectable_drag,this.behavior.node_label_drag)}.bind(this);e.draw_an_object(this.sel,"#nodes",".node",n,"node_id",r,i)}function k(){e.draw_an_object(this.sel,"#nodes",".node",this.nodes,"node_id",null,null,function(e){e.remove()})}function L(){var e=[];for(var t in this.text_labels)e.push(t);this.draw_these_text_labels(e),this.clear_deleted_text_labels()}function A(t){var n=e.object_slice_for_ids_ref(this.text_labels,t),r=function(e){return this.draw.update_text_label(e,this.behavior)}.bind(this);e.draw_an_object(this.sel,"#text-labels",".text-label",n,"text_label_id",this.draw.create_text_label.bind(this.draw),r)}function O(){e.draw_an_object(this.sel,"#text-labels",".text-label",this.text_labels,"text_label_id",null,null,function(e){e.remove()})}function M(){var e=[];for(var t in this.beziers)e.push(t);this.draw_these_beziers(e),this.clear_deleted_beziers()}function _(t){var n=e.object_slice_for_ids_ref(this.beziers,t),r=function(e){return this.draw.update_bezier(e,this.beziers_enabled,this.behavior.bezier_drag,this.behavior.bezier_mouseover,this.behavior.bezier_mouseout,this.nodes,this.reactions)}.bind(this);e.draw_an_object(this.sel,"#beziers",".bezier",n,"bezier_id",this.draw.create_bezier.bind(this.draw),r)}function D(){e.draw_an_object(this.sel,"#beziers",".bezier",this.beziers,"bezier_id",null,null,function(e){e.remove()})}function P(){this.toggle_beziers(!0)}function H(){this.toggle_beziers(!1)}function B(e){e===undefined?this.beziers_enabled=!this.beziers_enabled:this.beziers_enabled=e,this.draw_all_beziers(),this.callback_manager.run("toggle_beziers",null,this.beziers_enabled)}function j(e){var t=this.settings.get_option("reaction_styles"),n=this.settings.get_option("reaction_compare_style"),r=f.apply_reaction_data_to_reactions(this.reactions,e,t,n);return this.has_data_on_reactions=r,this.calc_data_stats("reaction")}function F(e){var t=this.settings.get_option("metabolite_styles"),n=this.settings.get_option("metabolite_compare_style"),r=f.apply_metabolite_data_to_nodes(this.nodes,e,t,n);return this.has_data_on_nodes=r,this.calc_data_stats("metabolite")}function I(e){var t=this.settings.get_option("reaction_styles"),n=this.settings.get_option("reaction_compare_style"),r=this.settings.get_option("identifiers_on_map"),i=this.settings.get_option("and_method_in_gene_reaction_rule"),s=f.apply_gene_data_to_reactions(this.reactions,e,t,r,n,i);return this.has_data_on_reactions=s,this.calc_data_stats("reaction")}function q(){return this.data_statistics}function R(t){function l(e){return function(t){return e.apply(null,t)}}if(["reaction","metabolite"].indexOf(t)==-1)throw new Error("Bad type "+t);"data_statistics"in this?t in this.data_statistics||(this.data_statistics[t]={}):(this.data_statistics={},this.data_statistics[t]={});var n=!0,r=[];if(t=="metabolite")for(var i in this.nodes){var s=this.nodes[i];s.data!==null&&r.push(s.data)}else if(t=="reaction")for(var o in this.reactions){var u=this.reactions[o];u.data!==null&&r.push(u.data)}var a=e.quartiles(r),f=[["min",l(Math.min)],["max",l(Math.max)],["mean",e.mean],["Q1",function(){return a[0]}],["median",function(){return a[1]}],["Q3",function(){return a[2]}]];return f.forEach(function(e){var i,s=e[0];if(r.length==0)i=null;else{var o=e[1];i=o(r)}i!=this.data_statistics[t][s]&&(n=!1),this.data_statistics[t][s]=i}.bind(this)),t=="reaction"?this.callback_manager.run("calc_data_stats__reaction",null,!n):this.callback_manager.run("calc_data_stats__metabolite",null,!n),!n}function U(e){var t=this.nodes[e],n={x:t.x,y:t.y};return n}function z(){var e=[];return this.sel.select("#nodes").selectAll(".selected").each(function(t){e.push(t.node_id)}),e}function W(){var e={},t=this;return this.sel.select("#nodes").selectAll(".selected").each(function(t){e[t.node_id]=this.nodes[t.node_id]}.bind(this)),e}function X(){var e=[];return this.sel.select("#text-labels").selectAll(".selected").each(function(t){e.push(t.text_label_id)}),e}function V(){var e={},t=this;return this.sel.select("#text-labels").selectAll(".selected").each(function(t){e[t.text_label_id]=this.text_labels[t.text_label_id]}.bind(this)),e}function $(){this.sel.selectAll("#nodes,#text-labels").selectAll(".node,.text-label").classed("selected",!0)}function J(){this.sel.selectAll(".selected").classed("selected",!1)}function K(){var e=this.sel.selectAll("#nodes,#text-labels").selectAll(".node,.text-label");e.classed("selected",function(){return!d3.select(this).classed("selected")})}function Q(e){this.deselect_text_labels();var t=this.sel.select("#nodes").selectAll(".node"),n,r;t.classed("selected",function(t){var i=String(t.node_id)==String(e);return i&&(r=t,n={x:t.x,y:t.y}),i}),this.sel.selectAll(".start-reaction-target").style("visibility","hidden"),this.callback_manager.run("select_metabolite_with_id",null,r,n)}function G(e,t){var n=this.sel.selectAll("#nodes,#text-labels").selectAll(".node,.text-label"),r=this.key_manager.held_keys.shift,i;d3.select(e).attr("class").indexOf("text-label")==-1?i=e.parentNode:i=e,r?d3.select(i).classed("selected",!d3.select(i).classed("selected")):(n.classed("selected",!1),d3.select(i).classed("selected",!0));var s=this.sel.select("#nodes").selectAll(".selected"),o=0,u,a;s.each(function(e){a=e,u={x:e.x,y:e.y},o++}),this.callback_manager.run("select_selectable",null,o,a,u)}function Y(){var e=null,t=this,n=this.sel.select("#nodes").selectAll(".selected");return n.classed("selected",function(t,n){return n==0?(e=t,!0):!1}),e}function Z(){var e=this.sel.select("#nodes").selectAll(".node");e.classed("selected",!1),this.callback_manager.run("deselect_nodes")}function et(e,t){this.deselect_nodes();var n=this.sel.select("#text-labels").selectAll(".text-label");n.classed("selected",function(e){return t===e});var r=this.sel.select("#text-labels").selectAll(".selected"),i;r.each(function(e){i={x:e.x,y:e.y}}),this.callback_manager.run("select_text_label")}function tt(){var e=this.sel.select("#text-labels").selectAll(".text-label");e.classed("selected",!1)}function nt(){var e=this.get_selected_nodes(),t=this.get_selected_text_labels();(Object.keys(e).length>=1||Object.keys(t).length>=1)&&this.delete_selectable(e,t,!0)}function rt(t,n,r){var s=this.segments_and_reactions_for_nodes(t),o=s.segment_objs_w_segments,u=s.reactions,a=e.clone(t),f=e.clone(o),l=e.clone(u),c=e.clone(n),h=function(e,n,i,s){this.delete_node_data(Object.keys(t)),this.delete_segment_data(i),this.delete_reaction_data(Object.keys(n)),this.delete_text_label_data(Object.keys(s));var o=!1,u=!1;this.has_data_on_reactions&&(o=this.calc_data_stats("reaction")),this.has_data_on_nodes&&(u=this.calc_data_stats("metabolite")),r&&(o?this.draw_all_reactions(!0,!0):this.clear_deleted_reactions(),u?this.draw_all_nodes(!0):this.clear_deleted_nodes(),this.clear_deleted_text_labels())}.bind(this);h(t,u,o,n),this.undo_stack.push(function(){this.extend_nodes(a),this.extend_reactions(l);var s=Object.keys(l);for(var h in f){var p=f[h],d=p.segment;this.reactions[p.reaction_id].segments[p.segment_id]=d,[d.from_node_id,d.to_node_id].forEach(function(e){if(e in a)return;var t=this.nodes[e];t.connected_segments.push({reaction_id:p.reaction_id,segment_id:p.segment_id})}.bind(this));var v=p.segment_id,m=p.reaction_id,g={};g[v]=p.segment,e.extend(this.beziers,i.new_beziers_for_segments(g,m)),s.indexOf(p.reaction_id)==-1&&s.push(p.reaction_id)}if(this.has_data_on_reactions){var y=this.calc_data_stats("reaction");y?this.draw_all_reactions(!0,!1):this.draw_these_reactions(s)}else r&&this.draw_these_reactions(s);if(this.has_data_on_nodes){var y=this.calc_data_stats("metabolite");r&&(y?this.draw_all_nodes(!1):this.draw_these_nodes(Object.keys(a)))}else r&&this.draw_these_nodes(Object.keys(a));e.extend(this.text_labels,c),r&&this.draw_these_text_labels(Object.keys(c)),n=e.clone(c),t=e.clone(a),o=e.clone(f),u=e.clone(l)}.bind(this),function(){h(t,u,o,n)}.bind(this))}function it(e){e.forEach(function(e){if(this.enable_search&&this.nodes[e].node_type=="metabolite"){var t=this.search_index.remove("n"+e)&&this.search_index.remove("n_name"+e);t||console.warn("Could not find deleted metabolite in search index")}delete this.nodes[e]}.bind(this))}function st(e){for(var t in e){var n=e[t],r=this.reactions[n.reaction_id];if(!(n.segment_id in r.segments))return;var s=r.segments[n.segment_id];[s.from_node_id,s.to_node_id].forEach(function(e){if(!(e in this.nodes))return;var t=this.nodes[e];t.connected_segments=t.connected_segments.filter(function(e){return e.segment_id!=n.segment_id})}.bind(this)),["b1","b2"].forEach(function(e){var t=i.bezier_id_for_segment_id(n.segment_id,e);delete this.beziers[t]}.bind(this)),delete r.segments[n.segment_id]}}function ot(e){e.forEach(function(e){var t=this.reactions[e];for(var n in t.segments)["b1","b2"].forEach(function(e){var t=i.bezier_id_for_segment_id(n,e);delete this.beziers[t]}.bind(this));delete this.reactions[e];var r=this.search_index.remove("r"+e)&&this.search_index.remove("r_name"+e);r||console.warn("Could not find deleted reaction "+e+" in search index");for(var s in t.genes){var r=this.search_index.remove("r"+e+"_g"+s)&&this.search_index.remove("r"+e+"_g_name"+s);r||console.warn("Could not find deleted gene "+s+" in search index")}}.bind(this))}function ut(e){e.forEach(function(e){delete this.text_labels[e];var t=this.search_index.remove("l"+e);t||console.warn("Could not find deleted text label in search index")}.bind(this))}function at(t,n,r){function m(e,t){this.extend_nodes(e);if(this.has_data_on_nodes){var n=this.apply_metabolite_data_to_nodes(e);n?this.draw_all_nodes(!1):this.draw_these_nodes([t])}else this.draw_these_nodes([t])}if(!this.cobra_model)return console.error("No CobraModel. Cannot build new reaction");var i=e.clone(this.cobra_model.reactions[t]);for(var s in i.metabolites){var o=i.metabolites[s],u=this.cobra_model.metabolites[s];if(o<0){var a=String(++this.largest_ids.nodes),f={x:30,y:10},l={connected_segments:[],x:n.x,y:n.y,node_is_primary:!0,label_x:n.x+f.x,label_y:n.y+f.y,name:u.name,bigg_id:s,node_type:"metabolite"},c={};c[a]=l;break}}m.apply(this,[c,a]);var h=e.clone(c),p=this.new_reaction_for_metabolite(t,a,r,!1),d=p.redo,v=p.undo;return this.undo_stack.push(function(){v(),this.delete_node_data(Object.keys(c)),c=e.clone(h),this.clear_deleted_nodes(),this.deselect_nodes()}.bind(this),function(){m.apply(this,[c,a]),d()}.bind(this)),null}function ft(t){if(this.enable_search)for(var n in t){var r=t[n];if(r.node_type!="metabolite")continue;this.search_index.insert("n"+n,{name:r.bigg_id,data:{type:"metabolite",node_id:n}}),this.search_index.insert("n_name"+n,{name:r.name,data:{type:"metabolite",node_id:n}})}e.extend(this.nodes,t)}function lt(t){if(this.enable_search)for(var n in t){var r=t[n];this.search_index.insert("r"+n,{name:r.bigg_id,data:{type:"reaction",reaction_id:n}}),this.search_index.insert("r_name"+n,{name:r.name,data:{type:"reaction",reaction_id:n}});for(var i in r.genes){var s=r.genes[i];this.search_index.insert("r"+n+"_g"+i,{name:s.bigg_id,data:{type:"reaction",reaction_id:n}}),this.search_index.insert("r"+n+"_g_name"+i,{name:s.name,data:{type:"reaction",reaction_id:n}})}}e.extend(this.reactions,t)}function ct(t,n,r,s){function g(t,n,r,i){this.extend_reactions(n),e.extend(this.beziers,r),this.delete_node_data([i]),this.extend_nodes(t);if(this.has_data_on_reactions){var s=this.calc_data_stats("reaction");s?this.draw_all_reactions(!0,!1):this.draw_these_reactions(Object.keys(n))}else this.draw_these_reactions(Object.keys(n));if(this.has_data_on_nodes){var s=this.calc_data_stats("metabolite");s?this.draw_all_nodes(!1):this.draw_these_nodes(Object.keys(t))}else this.draw_these_nodes(Object.keys(t));for(var o in t){var u=t[o];if(u.node_is_primary&&o!=i){this.select_metabolite_with_id(o);var a={x:u.x,y:u.y};this.zoom_container&&this.zoom_container.translate_off_screen(a)}}}s===undefined&&(s=!0);var o=this.nodes[n],u=this.cobra_model.reactions[t],a=i.new_reaction(t,u,this.cobra_model.metabolites,n,e.clone(o),this.largest_ids,this.cobra_model.cofactors,r),f=a.new_nodes,l=a.new_reactions,c=a.new_beziers;g.apply(this,[f,l,c,n]);var h=e.clone(f),p=e.clone(l),d=e.clone(c),v=function(){delete f[n],this.delete_node_data(Object.keys(f)),this.delete_reaction_data(Object.keys(l)),Q.apply(this,[n]),f=e.clone(h),l=e.clone(p),c=e.clone(d);if(this.has_data_on_reactions){var t=this.calc_data_stats("reaction");t?this.draw_all_reactions(!0,!0):this.draw_these_reactions(Object.keys(l))}else this.clear_deleted_reactions(!0);if(this.has_data_on_nodes){var t=this.calc_data_stats("metabolite");t?this.draw_all_nodes(!0):this.draw_these_nodes(Object.keys(f))}else this.clear_deleted_nodes()}.bind(this),m=function(){g.apply(this,[f,l,c,n])}.bind(this);return s&&this.undo_stack.push(v,m),{undo:v,redo:m}}function ht(){var e=this.get_selected_nodes(),t=Object.keys(e)[0],n=e[t],r=this.reactions,i=this.nodes,s=[],o;i[t].connected_segments.forEach(function(e){o=[e.reaction_id];var n;try{n=r[e.reaction_id].segments[e.segment_id];if(n===undefined)throw new Error("undefined segment")}catch(i){console.warn("Could not find connected segment "+e.segment_id);return}s.push(n.from_node_id==t?n.to_node_id:n.from_node_id)});if(s.length!=1){console.error("Only connected nodes with a single reaction can be selected");return}var u=s[0],a=[t],f=[];i[u].connected_segments.forEach(function(e){var n;try{n=r[e.reaction_id].segments[e.segment_id];if(n===undefined)throw new Error("undefined segment")}catch(s){console.warn("Could not find connected segment "+e.segment_id);return}var o=n.from_node_id==u?n.to_node_id:n.from_node_id,f=i[o];f.node_type=="metabolite"&&o!=t&&a.push(String(o))});for(var l=0;l<a.length;l++)if(i[a[l]].connected_segments.length>1){console.error("Only connected nodes with a single reaction can be selected");return}for(var c in e)if(c!=t&&a.indexOf(c)==-1){console.warn("Selected nodes are not on the same reaction");return}var h=[],p=a.length-1,d=i[a[p]],v=d.node_is_primary,m={x:d.x,y:d.y,label_x:d.label_x,label_y:d.label_y};d.connected_segments.length>1&&console.warn("Too many connected segments for node "+d.node_id);var g=d.connected_segments[0],y;try{y=r[g.reaction_id].segments[g.segment_id];if(y===undefined)throw new Error("undefined segment")}catch(b){console.error("Could not find connected segment "+g.segment_id);return}var w={b1:y.b1,b2:y.b2},E;a.forEach(function(e){var t=i[e],n=t.node_is_primary,s={x:t.x,y:t.y,label_x:t.label_x,label_y:t.label_y},o=t.connected_segments[0],u=r[o.reaction_id].segments[o.segment_id],a={b1:u.b1,b2:u.b2};t.node_is_primary=v,t.x=m.x,t.y=m.y,t.label_x=m.label_x,t.label_y=m.label_y,u.b1=w.b1,u.b2=w.b2,v=n,m=s,w=a,t.node_is_primary&&(E=e),h.push(e)});var S=i[u].connected_segments,p=S.length-1,x=[S[p]];S.forEach(function(e,t){if(p==t)return;x.push(e)}),i[u].connected_segments=x,this.draw_these_nodes(h),this.draw_these_reactions(o),this.select_metabolite_with_id(E);return}function pt(){var e=this.get_selected_node_ids(),t=function(e){var t={},n=this.settings.get_option("hide_secondary_metabolites");e.forEach(function(e){if(!(e in this.nodes)){console.warn("Could not find node: "+e);return}var n=this.nodes[e];n.node_type=="metabolite"&&(n.node_is_primary=!n.node_is_primary,t[e]=n)}.bind(this)),this.draw_these_nodes(Object.keys(t));if(n){var r=this.segments_and_reactions_for_nodes(t),i={};for(var s in r.segment_objs_w_segments){var o=r.segment_objs_w_segments[s].reaction_id;i[o]=!0}this.draw_these_reactions(Object.keys(i))}}.bind(this);t(e),this.undo_stack.push(function(){t(e)},function(){t(e)})}function dt(t){var n={},r={},i={},s=this.reactions;for(var o in t){var u=t[o];u.connected_segments.forEach(function(t){var r;try{r=s[t.reaction_id].segments[t.segment_id];if(r===undefined)throw new Error("undefined segment")}catch(o){console.warn("Could not find connected segments for node");return}var u=e.clone(t);u.segment=e.clone(r),n[t.segment_id]=u,t.reaction_id in i||(i[t.reaction_id]=[]),i[t.reaction_id].push(t.segment_id)})}for(var a in i){var f=s[a],l=i[a],c=!0;for(var h in f.segments)l.indexOf(h)==-1&&(c=!1);c&&(r[a]=f)}return{segment_objs_w_segments:n,reactions:r}}function vt(e,t){var n=i.new_text_label(this.largest_ids,t,e);this.text_labels[n.id]=n.label;var r=this.draw_these_text_labels([n.id]);return this.search_index.insert("l"+n.id,{name:t,data:{type:"text_label",text_label_id:n.id}}),n.id}function mt(e,t,n){var r=this.text_labels[e].text,i=function(t,n){this.text_labels[e].text=t,n&&this.draw_these_text_labels([e]);var r="l"+e,i=this.search_index.remove(r);i||console.warn("Could not find modified text label in search index"),this.search_index.insert(r,{name:t,data:{type:"text_label",text_label_id:e}})}.bind(this);i(t,n),this.undo_stack.push(function(){i(r,n)},function(){i(t,n)})}function gt(e){this._zoom_extent(e,"nodes")}function yt(e){this._zoom_extent(e,"canvas")}function bt(e,t){e===undefined&&(e=t=="nodes"?.2:0),t===undefined&&(t="canvas");var n,r,i=this.get_size();e*=i.height;if(t=="nodes"){var s={x:null,y:null},o={x:null,y:null};for(var u in this.nodes){var a=this.nodes[u];s.x===null&&(s.x=a.x),s.y===null&&(s.y=a.y),o.x===null&&(o.x=a.x),o.y===null&&(o.y=a.y),s.x=Math.min(s.x,a.x),s.y=Math.min(s.y,a.y),o.x=Math.max(o.x,a.x),o.y=Math.max(o.y,a.y)}n=Math.min((i.width-e*2)/(o.x-s.x),(i.height-e*2)/(o.y-s.y)),r={x:-(s.x*n)+e+(i.width-e*2-(o.x-s.x)*n)/2,y:-(s.y*n)+e+(i.height-e*2-(o.y-s.y)*n)/2}}else{if(t!="canvas")return console.error("Did not recognize mode");n=Math.min((i.width-e*2)/this.canvas.width,(i.height-e*2)/this.canvas.height),r={x:-(this.canvas.x*n)+e+(i.width-e*2-this.canvas.width*n)/2,y:-(this.canvas.y*n)+e+(i.height-e*2-this.canvas.height*n)/2}}return this.zoom_container.go_to(n,r),null}function wt(){return this.zoom_container.get_size()}function Et(e){var t=this.reactions[e],n=.5,r=this.get_size(),i={x:-t.label_x*n+r.width/2,y:-t.label_y*n+r.height/2};this.zoom_container.go_to(n,i)}function St(e){var t=this.nodes[e],n=.5,r=this.get_size(),i={x:-t.label_x*n+r.width/2,y:-t.label_y*n+r.height/2};this.zoom_container.go_to(n,i)}function xt(e){var t=this.text_labels[e],n=.5,r=this.get_size(),i={x:-t.x*n+r.width/2,y:-t.y*n+r.height/2};this.zoom_container.go_to(n,i)}function Tt(e){this.highlight(this.sel.selectAll("#r"+e).selectAll("text"))}function Nt(e){this.highlight(this.sel.selectAll("#n"+e).selectAll("text"))}function Ct(e){this.highlight(this.sel.selectAll("#l"+e).selectAll("text"))}function kt(e){this.sel.selectAll(".highlight").classed("highlight",!1),e!==null&&e.classed("highlight",!0)}function Lt(){e.download_json(this.map_for_export(),this.map_name)}function At(){var t=[{map_name:this.map_name,map_id:this.map_id,map_description:this.map_description,homepage:"https://escher.github.io",schema:"https://escher.github.io/escher/jsonschema/1-0-0#"},{reactions:e.clone(this.reactions),nodes:e.clone(this.nodes),text_labels:e.clone(this.text_labels),canvas:this.canvas.size_and_location()}];for(var n in t[1].reactions){var r=t[1].reactions[n],i={};["name","bigg_id","reversibility","label_x","label_y","gene_reaction_rule","genes","metabolites"].forEach(function(e){i[e]=r[e]}),i.segments={};for(var s in r.segments){var o=r.segments[s],u={};["from_node_id","to_node_id","b1","b2"].forEach(function(e){u[e]=o[e]}),i.segments[s]=u}t[1].reactions[n]=i}for(var a in t[1].nodes){var f=t[1].nodes[a],l={},c;f.node_type=="metabolite"?c=["node_type","x","y","bigg_id","name","label_x","label_y","node_is_primary"]:c=["node_type","x","y"],c.forEach(function(e){l[e]=f[e]}),t[1].nodes[a]=l}for(var p in t[1].text_labels){var d=t[1].text_labels[p],v={},c=["x","y","text"];c.forEach(function(e){v[e]=d[e]}),t[1].text_labels[p]=v}var m=t[1].canvas,g={},c=["x","y","width","height"];return c.forEach(function(e){g[e]=m[e]}),t[1].canvas=g,this.debug&&d3.json("jsonschema/1-0-0",function(e,n){if(e)throw new Error(e);h.validate(t,n)||console.warn(h.error)}),t}function Ot(){this.callback_manager.run("before_svg_export");var t=this.zoom_container.window_scale,n=this.zoom_container.window_translate,r=this.canvas.size_and_location(),i={w:this.canvas.mouse_node.attr("width"),h:this.canvas.mouse_node.attr("height"),transform:this.canvas.mouse_node.attr("transform")};this.zoom_container.go_to(1,{x:-r.x,y:-r.y},!1),this.svg.attr("width",r.width),this.svg.attr("height",r.height),this.canvas.mouse_node.attr("width","0px"),this.canvas.mouse_node.attr("height","0px"),this.canvas.mouse_node.attr("transform",null);var s=this.sel.selectAll(".multimarker-circle,.midmarker-circle,#canvas").style("visibility","hidden");e.export_svg("saved_map",this.svg,!0),this.zoom_container.go_to(t,n,!1),this.svg.attr("width",null),this.svg.attr("height",null),this.canvas.mouse_node.attr("width",i.w),this.canvas.mouse_node.attr("height",i.h),this.canvas.mouse_node.attr("transform",i.transform),s.style("visibility",null),this.callback_manager.run("after_svg_export")}var p=e.make_class();return p.from_data=v,p.prototype={init:d,setup_containers:m,reset_containers:g,set_status:y,clear_map:b,select_all:$,select_none:J,invert_selection:K,select_selectable:G,select_metabolite_with_id:Q,select_single_node:Y,deselect_nodes:Z,select_text_label:et,deselect_text_labels:tt,new_reaction_from_scratch:at,extend_nodes:ft,extend_reactions:lt,new_reaction_for_metabolite:ct,cycle_primary_node:ht,toggle_selected_node_primary:pt,new_text_label:vt,edit_text_label:mt,delete_selected:nt,delete_selectable:rt,delete_node_data:it,delete_segment_data:st,delete_reaction_data:ot,delete_text_label_data:ut,get_selected_node_ids:z,get_selected_nodes:W,get_selected_text_label_ids:X,get_selected_text_labels:V,segments_and_reactions_for_nodes:dt,draw_everything:E,draw_all_reactions:S,draw_these_reactions:x,clear_deleted_reactions:T,draw_all_nodes:N,draw_these_nodes:C,clear_deleted_nodes:k,draw_all_text_labels:L,draw_these_text_labels:A,clear_deleted_text_labels:O,draw_all_beziers:M,draw_these_beziers:_,clear_deleted_beziers:D,toggle_beziers:B,hide_beziers:H,show_beziers:P,has_cobra_model:w,apply_reaction_data_to_map:j,apply_metabolite_data_to_map:F,apply_gene_data_to_map:I,get_data_statistics:q,calc_data_stats:R,zoom_extent_nodes:gt,zoom_extent_canvas:yt,_zoom_extent:bt,get_size:wt,zoom_to_reaction:Et,zoom_to_node:St,zoom_to_text_label:xt,highlight_reaction:Tt,highlight_node:Nt,highlight_text_label:Ct,highlight:kt,save:Lt,map_for_export:At,save_svg:Ot},p}),n("Brush",["utils"],function(e){function n(e,t,n,r){this.brush_sel=e.append("g").attr("id","brush-container");var i=this.brush_sel.node(),s=e.select(r).node().nextSibling;i!==s&&i.parentNode.insertBefore(i,s),this.enabled=t,this.map=n}function r(){return this.map.sel.select(".brush").empty()}function i(e){e===undefined&&(e=!this.enabled),e?this.selection_brush=this.setup_selection_brush():this.brush_sel.selectAll(".brush").remove()}function s(){var e=this.brush_sel,t=this.map.sel.selectAll("#nodes,#text-labels"),n=this.map.canvas.size_and_location(),r=n.width,i=n.height,s=n.x,o=n.y;e.selectAll("g").remove();var u=d3.svg.brush().x(d3.scale.identity().domain([s,s+r])).y(d3.scale.identity().domain([o,o+i])).on("brush",function(e){var n=e.held_keys.shift,r=d3.event.target.extent(),i;n?i=t.selectAll(".node:not(.selected),.text-label:not(.selected)"):i=t.selectAll(".node,.text-label"),i.classed("selected",function(e){var t=e.x,n=e.y;return r[0][0]<=t&&t<r[1][0]&&r[0][1]<=n&&n<r[1][1]})}.bind(null,this.map.key_manager)).on("brushend",function(){d3.event.target.clear(),d3.select(this).call(d3.event.target)}),a=e.append("g").attr("class","brush").call(u);return e.selectAll(".background").classed("cursor-grab",!1).classed("cursor-grabbing",!1).style("cursor",null),a}var t=e.make_class();return t.prototype={init:n,toggle:i,setup_selection_brush:s},t}),n("ui",["utils","data_styles"],function(e,t){function n(e,t){var n=e.append("button"),r=n.append("span");"id"in t&&n.attr("id",t.id),"classes"in t&&n.attr("class",t.classes),"key_text"in t&&"text"in t&&t.key_text!==null?r.text(t.text+t.key_text):"text"in t&&r.text(t.text),"icon"in t&&r.classed(t.icon,!0),"key"in t&&o(n,t.key),n.attr("title",t.tooltip)}function r(e){var t=e.append("li").attr("class","btn-group-vertical").attr("data-toggle","buttons");return{button:function(e){var n=t.append("label").attr("class","btn btn-default");n.append("input").attr("type","radio");var r=n.append("span");return"id"in e&&n.attr("id",e.id),"key_text"in e&&"text"in e&&e.key_text!==null?r.text(e.text+e.key_text):"text"in e&&r.text(e.text),"icon"in e&&r.classed(e.icon,!0),"key"in e&&o(n,e.key),"tooltip"in e&&n.attr("title",e.tooltip),this}}}function i(e){var t=e.attr("class","btn-group-vertical");return{button:function(e){var n=t.append("button").attr("class","btn btn-default"),r=n.append("span");return"id"in e&&n.attr("id",e.id),"key_text"in e&&"text"in e&&e.key_text!==null?r.text(e.text+e.key_text):"text"in e&&r.text(e.text),"icon"in e&&r.classed(e.icon,!0),"key"in e&&o(n,e.key),"tooltip"in e&&n.attr("title",e.tooltip),this}}}function s(e,t,n){n===undefined&&(n=!1);var r=e.append("li").attr("class","dropdown");r.append("button").text(t+" ").attr("class","btn btn-link btn-sm dropdown-button").attr("data-toggle","dropdown").append("b").attr("class","caret");var i=r.append("ul").attr("class","dropdown-menu").classed("pull-right",n).attr("role","menu").attr("aria-labelledby","dLabel");return{dropdown:r,button:function(e){var t=i.append("li").attr("role","presentation").datum(e),n=t.append("a").attr("href","#"),r=n.append("span").attr("class","dropdown-button-icon"),s=n.append("span").attr("class","dropdown-button-text");"id"in e&&t.attr("id",e.id),"key_text"in e&&"text"in e&&e.key_text!==null?s.text(" "+e.text+e.key_text):"text"in e&&s.text(" "+e.text),"icon"in e&&r.classed(e.icon,!0);if("key"in e)o(n,e.key);else if("input"in e){var f=e.input,l=f.accept_csv?a(n,t,f.pre_fn,f.fn,f.failure_fn):u(n,t,f.pre_fn,f.fn,f.failure_fn);"assign"in f&&"key"in f&&(f.assign[f.key]=l)}return this},divider:function(){return i.append("li").attr("role","presentation").attr("class","divider"),this}}}function o(e,t){e.on("click",function(){t.fn.call(t.target)})}function u(t,n,r,i,s){var o=n.append("input").attr("type","file").style("display","none").on("change",function(){e.load_json(this.files[0],function(e,t){i(e,t),this.value=""}.bind(this),r,s)});return t.on("click",function(e){o.node().click()}),function(){o.node().click()}}function a(n,r,i,s,o){var u=r.append("input").attr("type","file").style("display","none").on("change",function(){e.load_json_or_csv(this.files[0],t.csv_converter,function(e,t){s(e,t),this.value=""}.bind(this),i,o)});return n.on("click",function(e){u.node().click()}),function(){u.node().click()}}return{individual_button:n,radio_button_group:r,button_group:i,dropdown_menu:s,set_json_input_button:u,set_json_or_csv_input_button:a}}),n("SearchBar",["utils","CallbackManager"],function(e,t){function r(e,n,r){var i=e.attr("class","search-container").style("display","none");this.input=i.append("input").attr("class","search-bar");var s=i.append("div").attr("class","btn-group btn-group-sm");s.append("button").attr("class","btn btn-default").on("click",this.previous.bind(this)).append("span").attr("class","glyphicon glyphicon-chevron-left"),s.append("button").attr("class","btn btn-default").on("click",this.next.bind(this)).append("span").attr("class","glyphicon glyphicon-chevron-right"),this.counter=i.append("div").attr("class","search-counter"),i.append("button").attr("class","btn btn-sm btn-default close-button").on("click",function(){this.toggle(!1)}.bind(this)).append("span").attr("class","glyphicon glyphicon-remove"),this.callback_manager=new t,this.selection=i,this.map=r,this.search_index=n,this.current=1,this.results=null,this.input.on("input",function(e){this.current=1,this.results=this.search_index.find(e.value),this.update()}.bind(this,this.input.node()))}function i(){return this.selection.style("display")!="none"}function s(e){e===undefined?this.is_active=!this.is_active:this.is_active=e,this.is_active?(this.selection.style("display",null),this.counter.text(""),this.input.node().value="",this.input.node().focus(),this.escape=this.map.key_manager.add_escape_listener(function(){this.toggle(!1)}.bind(this),"settings"),this.enter=this.map.key_manager.add_enter_listener(function(){this.next()}.bind(this),"settings"),this.callback_manager.run("show")):(this.map.highlight(null),this.selection.style("display","none"),this.results=null,this.escape&&this.escape.clear(),this.escape=null,this.enter&&this.enter.clear(),this.enter=null,this.callback_manager.run("hide"))}function o(){if(this.results==null)this.counter.text(""),this.map.zoom_extent_canvas(),this.map.highlight(null);else if(this.results.length==0)this.counter.text("0 / 0"),this.map.zoom_extent_canvas(),this.map.highlight(null);else{this.counter.text(this.current+" / "+this.results.length);var e=this.results[this.current-1];if(e.type=="reaction")this.map.zoom_to_reaction(e.reaction_id),this.map.highlight_reaction(e.reaction_id);else if(e.type=="metabolite")this.map.zoom_to_node(e.node_id),this.map.highlight_node(e.node_id);else{if(e.type!="text_label")throw new Error("Bad search index data type: "+e.type);this.map.zoom_to_text_label(e.text_label_id),this.map.highlight_text_label(e.text_label_id)}}}function u(){if(this.results==null)return;this.current==this.results.length?this.current=1:this.current+=1,this.update()}function a(){if(this.results==null)return;this.current==1?this.current=this.results.length:this.current-=1,this.update()}var n=e.make_class();return n.prototype={init:r,is_visible:i,toggle:s,update:o,next:u,previous:a},n}),n("Settings",["utils","lib/bacon"],function(e,t){function r(e,n,r){this.set_option=e,this.get_option=n,this.status_bus=new t.Bus,this.force_update_bus=new t.Bus,t.Observable.prototype.convert_to_conditional_stream=i,t.Observable.prototype.force_update_with_bus=s,this.busses={},this.streams={};for(var u=0,a=r.length;u<a;u++){var f=r[u],l=o(f,n(f),e,this.status_bus,this.force_update_bus);this.busses[f]=l.bus,this.streams[f]=l.stream}}function i(e){var n=e.map(function(e){return e=="hold"}).not().toProperty(!0),r=e.scan(!1,function(e,t){return e==0&&(t=="accepted"||t=="rejected")}).not(),i=e.scan(!1,function(e,t){return e==0&&t=="hold"}).not(),s=t.combineAsArray(this,e),o=s.scan([],function(e,t){if(t[1]=="hold")return e.push(t[0]),e;if(t[1]=="accept")return e;if(t[1]=="reject")return[];if(t[1]=="rejected"||t[1]=="accepted")return[t[0]];throw Error("bad status "+t[1])}).filter(n).filter(r).filter(i).flatMap(function(e){return t.fromArray(e)}),u=this.filter(n);return u.merge(o)}function s(e){return t.combineAsArray(this,e.toProperty(!1)).map(function(e){return e[0]})}function o(e,n,r,i,s){var o=new t.Bus,u=o.convert_to_conditional_stream(i).force_update_with_bus(s);return u.onValue(function(t){r(e,t)}),o.push(n),{bus:o,stream:u}}function u(e,t){if(!(e in this.busses))throw new Error("Invalid setting name");this.busses[e].push(t)}function a(){this.status_bus.push("hold")}function f(){this.status_bus.push("reject"),this.status_bus.push("rejected"),this.force_update_bus.push(!0)}function l(){this.status_bus.push("accept"),this.status_bus.push("accepted")}var n=e.make_class();return n.prototype={init:r,set_conditional:u,hold_changes:a,abandon_changes:f,accept_changes:l},n}),n("ScaleEditor",["utils","lib/bacon"],function(e,t){function r(e,t,n,r){var i="grad"+t+this.unique_string;this.w=400,this.h=30,this.x=20,this.input_width=90,this.input_height=24;var s=e.append("div").attr("class","scale-editor");this.data_not_loaded=s.append("div").attr("class","data-not-loaded").text((t=="reaction"?"Reaction and gene":"Metabolite")+" data not loaded"),this.input_label_group=s.append("div").attr("class","input-label-group");var o=s.append("div").style("top",this.input_height*3+56+10+"px").attr("class","no-data");o.append("span").text("Styles for "+t+"s with no data").attr("class","no-data-heading"),this.no_data_container=o.append("div");var u=s.append("div").attr("class","centered");this.add_group=u.append("div"),this.trash_group=u.append("div").attr("class","trash-container");var a=u.append("svg").attr("class","scale-svg");this.input_group=u.append("div").attr("class","input-container"),this.gradient=a.append("defs").append("linearGradient").attr("id",i),a.append("rect").attr("class","rect").attr("fill","url(#"+i+")").attr("width",this.w+"px").attr("height",this.h+"px").attr("x",this.x+"px"),this.pickers_group=a.append("g"),this.type=t,this.settings=n,this.get_data_statistics=r;var f=this.settings.get_option("unique_map_id");this.unique_string=f===null?"":"."+f,this.no_data={},["color","size"].forEach(function(e){this.no_data[e]=null,this.settings.streams[this.type+"_no_data_"+e].onValue(function(t){this.no_data[e]=t,this.update_no_data()}.bind(this))}.bind(this)),this.settings.streams[t+"_scale"].onValue(function(e){this.scale=e,this.update()}.bind(this))}function i(){var e=this.scale,t=this.get_data_statistics()[this.type],n=14,r=35,i=this.x,s=this._data_not_loaded();s&&(e=[{type:"min",color:null,size:null},{type:"max",color:null,size:null}],t={min:0,max:1});var o=d3.scale.linear().domain([0,this.w]).range([t.min,t.max]),u=d3.scale.linear().domain([0,this.w]).range([0,t.max-t.min]),a=function(e,t){this.input_group.selectAll(".input-set").each(function(t){d3.select(this).classed("selected-set",e===t)})}.bind(this),f=function(e){return e.type=="value"?e.value:t[e.type]},l=function(e){this.settings.set_conditional(this.type+"_scale",e),this.scale=e,this.update()}.bind(this),c=e.map(function(e){return{frac:(f(e)-t.min)/(t.max-t.min),color:e.color}}).filter(function(e){return e.frac>=0&&e.frac<=1}).sort(function(e,t){return e.frac-t.frac}),h=this.gradient.selectAll("stop").data(c);h.enter().append("stop"),h.attr("offset",function(e){return e.frac*100+"%"}).style("stop-color",function(e){return e.color===null?"#F1ECFA":e.color}),h.exit().remove(),this.data_not_loaded.style("visibility",s?null:"hidden");var p=this.pickers_group.selectAll(".picker").data(e),d=d3.behavior.drag();d.on("drag",function(r,i){if(e[i].type!="value")return;var s=e[i].value+u(d3.event.dx),o=u(n+2);s>t.max-o&&(s=t.max-o),s<t.min+o&&(s=t.min+o),s=Math.floor(s*100)/100,e[i].value=s,this.settings.set_conditional(this.type+"_scale",e),this.scale=e,this.update()}.bind(this)),p.enter().append("g").attr("class","picker").style("cursor","pointer").append("rect"),p.select("rect").attr("x",function(e,r){var s=f(e),u=n+2;return e.type=="value"&&s<=t.min?o.invert(t.min)-n/2+i-u:e.type=="value"&&s>=t.max?o.invert(t.max)-n/2+i+u:o.invert(s)-n/2+i}).attr("width",n+"px").attr("height",r+"px").call(d).on("mousedown",a),p.exit().remove();var v=this.trash_group.selectAll("span").data(e);v.enter().append("span"),v.attr("class",function(e,t){return e.type=="min"||e.type=="max"?null:"trash glyphicon glyphicon-trash"}).style("left",function(e){return o.invert(f(e))-n/2+i+"px"}).on("click",function(t,n){if(t.type=="min"||t.type=="max")return;e=e.slice(0,n).concat(e.slice(n+1)),this.settings.set_conditional(this.type+"_scale",e),this.scale=e,this.update()}.bind(this)),v.exit().remove();var m=this.add_group.selectAll(".add").data(["add"]);m.enter().append("span").attr("class","add glyphicon glyphicon-plus"),m.on("click",function(r){if(s)return;var i=(t.max+t.min)/2,o=u(n+2),a=0;for(var c=0,h=e.length;c<h;c++){var p=f(e[c]);Math.abs(p-i)<o&&(i+=o,i>t.max-o&&(i=t.max-o),i<t.min+o&&(i=t.min+o)),i>p&&(a=c)}e.push({type:"value",value:i,color:e[a].color,size:e[a].size}),l(e)}.bind(this)),m.exit().remove();var g=this.input_label_group.selectAll(".row-label").data(["Value:","Color:","Size:"]);g.enter().append("div").attr("class","row-label").style("height",this.input_height+"px").style("line-height",this.input_height+"px"),g.style("top",function(e,t){return 56+t*this.input_height+"px"}.bind(this)).text(function(e){return e}),g.exit().remove();var y=this.input_group.selectAll(".input-set").data(e),b=y.enter().append("div").attr("class","input-set");b.append("input").attr("class","domain-input").style("width",this.input_width+"px"),b.append("select").attr("class","domain-type-picker"),b.append("input").attr("class","color-input").style("width",this.input_width+"px"),b.append("input").attr("type","color").style("visibility",function(){return this.type=="text"?"hidden":null}).attr("class","color-picker"),b.append("input").attr("class","size-input").style("width",this.input_width+"px"),y.style("height",this.input_height*3+"px").style("width",this.input_width+"px").style("left",function(e){var r=f(e),s=n+2,u;return e.type=="value"&&r<=t.min?u=o.invert(t.min)-n/2+i-s:e.type=="value"&&r>=t.max?u=o.invert(t.max)-n/2+i+s:u=o.invert(r)-n/2+i,u+this.input_width>this.w+this.x&&(u=u-this.input_width+n/2),u+"px"}.bind(this)).on("mousedown",a);var w=d3.format(".4g");y.select(".domain-input").style("height",this.input_height+"px").each(function(e,t){e.type=="value"?(this.value=f(e),this.disabled=!1):(this.value=e.type+" ("+w(f(e))+")",this.disabled=!0)}).on("change",function(t,r){var i=u(n+2),s=parseFloat(this.value);e[r].value=s,l(e)});var E=y.select(".domain-type-picker"),S=["value"].concat(Object.keys(t)).filter(function(e){return e!="min"&&e!="max"}),x=E.selectAll("option").data(S);x.enter().append("option"),x.attr("value",function(e){return e}).text(function(e){return e}),x.exit().remove(),E.style("visibility",function(e){return e.type=="min"||e.type=="max"?"hidden":null}).style("left",this.input_width-20+"px").style("width","20px").each(function(e,t){var n=0;d3.select(this).selectAll("option").each(function(t,r){this.value==e.type&&(n=r)}),this.selectedIndex=n}).on("change",function(n,r){this.value=="value"&&(e[r].value=t[n.type]),e[r].type=this.value,l(e)}),y.select(".color-input").style("height",this.input_height+"px").style("top",this.input_height+"px").each(function(e,t){this.value=e.color===null?"":e.color,this.disabled=e.color===null}).on("change",function(t,n){e[n].color=this.value,l(e)}),y.select(".color-picker").style("left",this.input_width-this.input_height+"px").style("top",this.input_height+"px").style("width",this.input_height+"px").style("height",this.input_height+"px").each(function(e,t){this.value=e.color===null?"#dddddd":e.color,this.disabled=e.color===null}).on("change",function(t,n){e[n].color=this.value,l(e)}),y.select(".size-input").style("height",this.input_height+"px").style("top",this.input_height*2+"px").each(function(e,t){this.value=e.size===null?"":e.size,this.disabled=e.size===null}).on("change",function(t,n){e[n].size=parseFloat(this.value),l(e)}),y.exit().remove()}function s(){var e=this.no_data,t=this._data_not_loaded(),n=40,r=this.no_data_container.selectAll(".input-group").data([["color","Color:"],["size","Size:"]]),i=r.enter().append("div").attr("class","input-group");i.append("span"),i.append("input"),i.append("input").attr("type","color").style("visibility",function(e){return this.type=="text"||e[0]!="color"?"hidden":null}).attr("class","color-picker"),r.select("span").text(function(e){return e[1]}).style("height",this.input_height+"px").style("line-height",this.input_height+"px").style("left",function(e,t){return(n+this.input_width+10)*t+"px"}.bind(this));var s=function(e){return this.settings.get_option(this.type+"_no_data_"+e)}.bind(this);r.select("input").style("left",function(e,t){return n+(n+this.input_width+10)*t+"px"}.bind(this)).style("height",this.input_height+"px").style("width",this.input_width+"px").each(function(n){this.value=t?"":e[n[0]],this.disabled=t}).on("change",function(e){var t=d3.event.target.value;e[0]=="size"&&(t=parseFloat(t)),this.no_data[e[0]]=t,this.settings.set_conditional(this.type+"_no_data_"+e[0],t),this.update_no_data()}.bind(this)),r.select(".color-picker").style("left",function(e,t){return(n+this.input_width)*(t+1)-this.input_height+"px"}.bind(this)).style("width",this.input_height+"px").style("height",this.input_height+"px").each(function(n,r){this.value=t?"#dddddd":e[n[0]],this.disabled=t}).on("change",function(e,t){var n=d3.event.target.value;this.no_data[e[0]]=n,this.settings.set_conditional(this.type+"_no_data_"+e[0],n),this.update_no_data()}.bind(this)),r.exit().remove()}function o(){var e=this.get_data_statistics()[this.type];return e.max===null||e.min===null}var n=e.make_class();return n.prototype={init:r,update:i,update_no_data:s,_data_not_loaded:o},n}),n("SettingsMenu",["utils","CallbackManager","ScaleEditor"],function(e,t,n){function i(e,r,i,s){this.sel=e,this.settings=r,this.draw=!1;var o=this.settings.get_option("unique_map_id");this.unique_string=o===null?"":"."+o;var u=e.append("div").attr("class","settings-box-background").style("display","none"),a=u.append("div").attr("class","settings-box-container").style("display","none");a.append("button").attr("class","btn btn-sm btn-default settings-button").on("click",function(){this.accept_changes()}.bind(this)).append("span").attr("class","glyphicon glyphicon-ok"),a.append("button").attr("class","btn btn-sm btn-default settings-button settings-button-close").on("click",function(){this.abandon_changes()}.bind(this)).append("span").attr("class","glyphicon glyphicon-remove");var f=a.append("div").attr("class","settings-box");f.append("div").text("Tip: Hover over an option to see more details about it.").style("font-style","italic"),f.append("hr"),f.append("div").text("View and build options").attr("class","settings-section-heading-large"),this.view_gui(f.append("div")),f.append("hr"),f.append("div").text("Reactions").attr("class","settings-section-heading-large");var l=new n(f.append("div"),"reaction",this.settings,i.get_data_statistics.bind(i));i.callback_manager.set("calc_data_stats__reaction",function(e){e&&(l.update(),l.update_no_data())}),f.append("div").text("Reaction or Gene data").attr("class","settings-section-heading"),this.style_gui(f.append("div"),"reaction",function(e){s&&(s("reaction",e),l.update(),l.update_no_data())}),f.append("hr"),f.append("div").text("Metabolites").attr("class","settings-section-heading-large");var c=new n(f.append("div"),"metabolite",this.settings,i.get_data_statistics.bind(i));i.callback_manager.set("calc_data_stats__metabolite",function(e){e&&(c.update(),c.update_no_data())}),f.append("div").text("Metabolite data").attr("class","settings-section-heading"),this.style_gui(f.append("div"),"metabolite",function(e){s&&(s("metabolite",e),c.update(),c.update_no_data())}),this.callback_manager=new t,this.map=i,this.selection=a,this.background=u}function s(){return this.selection.style("display")!="none"}function o(e){e===undefined&&(e=!this.is_visible()),e?(this.hold_changes(),this.selection.style("display","inline-block"),this.background.style("display","block"),this.selection.select("input").node().focus(),this.escape=this.map.key_manager.add_escape_listener(function(){this.abandon_changes()}.bind(this),"settings"),this.enter=this.map.key_manager.add_enter_listener(function(){this.accept_changes()}.bind(this),"settings"),this.callback_manager.run("show")):(this.draw&&this.map.draw_everything(),this.selection.style("display","none"),this.background.style("display","none"),this.escape&&this.escape.clear(),this.enter&&this.enter.clear(),this.escape=null,this.enter=null,this.callback_manager.run("hide"))}function u(){this.settings.hold_changes()}function a(){this.draw=!1,this.settings.abandon_changes(),this.toggle(!1)}function f(){this.sel.selectAll("input").each(function(e){this.blur()}),this.draw=!0,this.settings.accept_changes(),this.toggle(!1)}function l(e,t,n){var r=e.append("table").attr("class","settings-table"),i=this.settings;r.append("tr").call(function(e){e.append("td").text("Options:").attr("class","options-label").attr("title","Options for "+t+" data.");var r=e.append("td"),s=[["Absolute value","abs","If checked, use the absolute value when calculating colors and sizes of "+t+"s on the map"],["Size","size","If checked, then size the "+(t=="metabolite"?"radius of metabolite circles ":"thickness of reaction lines ")+"according to the value of the "+t+" data"],["Color","color","If checked, then color the "+(t=="metabolite"?"metabolite circles ":"reaction lines ")+"according to the value of the "+t+" data"],["Text","text","If checked, then show data values in the "+t+" "+"labels"]],o=r.selectAll(".option-group").data(s),u=o.enter().append("span").attr("class","option-group"),a=[],f=function(){var e=[];return r.selectAll("input").each(function(t){this.checked&&e.push(t[1])}),e};u.append("input").attr("type","checkbox").on("change",function(e){i.set_conditional(t+"_styles",f()),e[1]=="abs"&&n(this.checked)}).each(function(e){i.streams[t+"_styles"].onValue(function(t){this.checked=t.indexOf(e[1])!=-1}.bind(this))}),u.append("span").text(function(e){return e[0]}).attr("title",function(e){return e[2]})}),r.append("tr").call(function(e){e.append("td").text("Comparison:").attr("class","options-label").attr("title","The function that will be used to compare datasets, when paired data is loaded");var n=e.append("td").attr("title","The function that will be used to compare datasets, when paired data is loaded"),r=[["Fold Change","fold"],["Log2(Fold Change)","log2_fold"],["Difference","diff"]],s=n.selectAll(".option-group").data(r),o=s.enter().append("span").attr("class","option-group");o.append("input").attr("type","radio").attr("name",t+"_compare_style"+this.unique_string).attr("value",function(e){return e[1]}).on("change",function(){this.checked&&i.set_conditional(t+"_compare_style",this.value)}).each(function(){i.streams[t+"_compare_style"].onValue(function(e){this.checked=this.value==e}.bind(this))}),o.append("span").text(function(e){return e[0]})}.bind(this));if(t=="reaction"){var r=e.append("table").attr("class","settings-table").attr("title","The function that will be used to evaluate AND connections in gene reaction rules (AND connections generally connect components of an enzyme complex)");r.append("tr").call(function(e){e.append("td").text("Method for evaluating AND:").attr("class","options-label-wide");var t=e.append("td"),n=[["Mean","mean"],["Min","min"]],r=t.selectAll(".option-group").data(n),s=r.enter().append("span").attr("class","option-group"),o="and_method_in_gene_reaction_rule";s.append("input").attr("type","radio").attr("name",o+this.unique_string).attr("value",function(e){return e[1]}).on("change",function(){this.checked&&i.set_conditional(o,this.value)}).each(function(){i.streams[o].onValue(function(e){this.checked=this.value==e}.bind(this))}),s.append("span").text(function(e){return e[0]})}.bind(this))}}function c(e,t,n,r){var i=this.settings,s=e.append("table").attr("class","settings-table");s.append("tr").call(function(e){e.attr("title","The identifiers that are show in the reaction, gene, and metabolite labels on the map."),e.append("td").text("Identifiers:").attr("class","options-label");var t=e.append("td"),n=[["ID's","bigg_id"],["Descriptive names","name"]],r=t.selectAll(".option-group").data(n),s=r.enter().append("span").attr("class","option-group"),o="identifiers_on_map";s.append("input").attr("type","radio").attr("name",o+this.unique_string).attr("value",function(e){return e[1]}).on("change",function(){this.checked&&i.set_conditional(o,this.value)}).each(function(){i.streams[o].onValue(function(e){this.checked=this.value==e}.bind(this))}),s.append("span").text(function(e){return e[0]})}.bind(this));var o=[["hide_secondary_metabolites","Hide secondary metabolites","If checked, then only the primary metabolites will be displayed."],["show_gene_reaction_rules","Show gene reaction rules","If checked, then gene reaction rules will be displayed below each reaction label. (Gene reaction rules are always shown when gene data is loaded.)"],["highlight_missing","Highlight reactions not in model","If checked, then highlight in red all the reactions on the map that are not present in the loaded model."],["allow_building_duplicate_reactions","Allow duplicate reactions","If checked, then allow duplicate reactions during model building."]],u=e.append("div").attr("class","settings-container").selectAll(".option-group").data(o),a=u.enter().append("div").attr("class","option-group");a.append("input").attr("type","checkbox"),a.append("span"),u.attr("title",function(e){return e[2]}),u.select("input").on("change",function(e){i.set_conditional(e[0],this.checked)}).each(function(e){i.streams[e[0]].onValue(function(e){this.checked=e}.bind(this))}),u.select("span").text(function(e){return e[1]}),u.exit().remove()}var r=e.make_class();return r.prototype={init:i,is_visible:s,toggle:o,hold_changes:u,abandon_changes:a,accept_changes:f,style_gui:l,view_gui:c},r}),n("TextEditInput",["utils","PlacedDiv","build"],function(e,t,n){function i(e,n,r){var i=e.append("div").attr("id","text-edit-input");this.placed_div=t(i,n),this.placed_div.hide(),this.input=i.append("input"),this.map=n,this.setup_map_callbacks(n),this.zoom_container=r,this.setup_zoom_callbacks(r)}function s(e){e.callback_manager.set("edit_text_label.text_edit_input",function(e,t){this.show(e,t)}.bind(this)),e.callback_manager.set("new_text_label.text_edit_input",function(e){this.active_target!==null&&this._accept_changes(this.active_target.target),this.hide(),this._add_and_edit(e)}.bind(this)),e.callback_manager.set("hide_text_label_editor.text_edit_input",function(){this.hide()}.bind(this))}function o(e){e.callback_manager.set("zoom.text_edit_input",function(){this.active_target&&this._accept_changes(this.active_target.target),this.hide()}.bind(this)),e.callback_manager.set("go_to.text_edit_input",function(){this.active_target&&this._accept_changes(this.active_target.target),this.hide()}.bind(this))}function u(){return this.placed_div.is_visible()}function a(e,t){this.active_target&&this._accept_changes(this.active_target.target),this.active_target={target:e,coords:t},e.each(function(e){this.input.node().value=e.text}.bind(this)),this.placed_div.place(t),this.input.node().focus(),this.escape=this.map.key_manager.add_escape_listener(function(){this._accept_changes(e),this.hide()}.bind(this)),this.enter=this.map.key_manager.add_enter_listener(function(e){this._accept_changes(e),this.hide()}.bind(this,e))}function f(){this.placed_div.hide(),this.input.attr("value",""),this.active_target=null,this.escape&&this.escape.clear(),this.escape=null,this.enter&&this.enter.clear(),this.enter=null}function l(e){if(this.input.node().value=="")e.each(function(e){var t={};t[e.text_label_id]=this.map.text_labels[e.text_label_id],this.map.delete_selectable({},t,!0)}.bind(this));else{var t=[];e.each(function(e){this.map.edit_text_label(e.text_label_id,this.input.node().value,!0),t.push(e.text_label_id)}.bind(this))}}function c(e){var t=this.map.new_text_label(e,""),n=this.map.sel.select("#text-labels").selectAll(".text-label").filter(function(e){return e.text_label_id==t});n.select("text").classed("edit-text-cursor",!0),this.show(n,e)}var r=e.make_class();return r.prototype={init:i,setup_map_callbacks:s,setup_zoom_callbacks:o,is_visible:u,show:a,hide:f,_accept_changes:l,_add_and_edit:c},r}),n("QuickJump",["utils"],function(e){function n(t,n){var r=t.append("select").attr("id","quick-jump-menu").attr("class","form-control");this.selector=r;var i=e.parse_url_components(window),s="map_name"in i?i.map_name:null,o="quick_jump_path"in i?i.quick_jump_path:null,u="quick_jump"in i?i.quick_jump:[],a="— Jump to map —",f=[a].concat(u);s!==null&&(f=f.filter(function(e){return e!=s})),r.selectAll("option").data(f).enter().append("option").text(function(e){return e.split(".").slice(-1)[0]}),r.style("display",f.length>1?"block":"none");var l=function(e){n(e,o,function(t){t?this.replace_state_for_map_name(e):this.reset_selection()}.bind(this))}.bind(this);r.on("change",function(){var e=this.options[this.selectedIndex].__data__;l(e)})}function r(){this.selector.node().selectedIndex=0}function i(e){var t=window.location.href.replace(/(map_name=)([^&]+)(&|$)/,"$1"+e+"$3");window.history.replaceState("Not implemented","",t)}var t=e.make_class();return t.prototype={init:n,reset_selection:r,replace_state_for_map_name:i},t}),n("Builder",["utils","BuildInput","ZoomContainer","Map","CobraModel","Brush","CallbackManager","ui","SearchBar","Settings","SettingsMenu","TextEditInput","QuickJump","data_styles"],function(e,t,n,r,i,s,o,u,a,f,l,c,h,p){function v(t,n,r,i,s){i||(i=d3.select("body").append("div")),s||(s={}),this.map_data=t,this.model_data=n,this.embedded_css=r,this.selection=i,this.options=e.set_options(s,{menu:"all",scroll_behavior:"pan",enable_editing:!0,enable_keys:!0,enable_search:!0,fill_screen:!1,starting_reaction:null,never_ask_before_quit:!1,unique_map_id:null,primary_metabolite_radius:20,secondary_metabolite_radius:10,marker_radius:5,gene_font_size:18,hide_secondary_metabolites:!1,show_gene_reaction_rules:!1,reaction_data:null,reaction_styles:["color","size","text"],reaction_compare_style:"log2_fold",reaction_scale:[{type:"min",color:"#c8c8c8",size:12},{type:"median",color:"#9696ff",size:20},{type:"max",color:"#ff0000",size:25}],reaction_no_data_color:"#dcdcdc",reaction_no_data_size:8,gene_data:null,and_method_in_gene_reaction_rule:"mean",metabolite_data:null,metabolite_styles:["color","size","text"],metabolite_compare_style:"log2_fold",metabolite_scale:[{type:"min",color:"#fffaf0",size:20},{type:"median",color:"#f1c470",size:30},{type:"max",color:"#800000",size:40}],metabolite_no_data_color:"#ffffff",metabolite_no_data_size:10,identifiers_on_map:"bigg_id",highlight_missing:!1,allow_building_duplicate_reactions:!1,first_load_callback:null},{primary_metabolite_radius:!0,secondary_metabolite_radius:!0,marker_radius:!0,gene_font_size:!0,reaction_no_data_size:!0,metabolite_no_data_size:!0});if(e.check_for_parent_tag(this.selection,"svg"))throw new Error("Builder cannot be placed within an svg node becuase UI elements are html-based.");var u=function(e,t){this.options[e]=t}.bind(this),a=function(e){return this.options[e]}.bind(this),l=["hide_secondary_metabolites","show_gene_reaction_rules","reaction_styles","reaction_compare_style","reaction_scale","reaction_no_data_color","reaction_no_data_size","and_method_in_gene_reaction_rule","metabolite_styles","metabolite_compare_style","metabolite_scale","metabolite_no_data_color","metabolite_no_data_size","identifiers_on_map","highlight_missing","allow_building_duplicate_reactions"];this.settings=new f(u,a,l),["reaction_scale","metabolite_scale"].forEach(function(e){this.settings.streams[e].onValue(function(t){["min","max"].forEach(function(n){var r=t.reduce(function(e,t){return e||t.type==n},!1);r||(t.push({type:n,color:"#ffffff",size:10}),this.settings.set_conditional(e,t))}.bind(this))}.bind(this))}.bind(this)),this.callback_manager=o(),this.options.first_load_callback!==null&&this.callback_manager.set("first_load",this.options.first_load_callback),this.load_model(this.model_data,!1),this.load_map(this.map_data,!1),this._update_data(!0,!0),this.settings.status_bus.onValue(function(e){e=="accepted"&&(this._update_data(!0,!0,["reaction","metabolite"],!1),this.map!==null&&(this.map.draw_all_nodes(!1),this.map.draw_all_reactions(!0,!1)))}.bind(this)),this.callback_manager.run("first_load",this)}function m(e,t){t===undefined&&(t=!0),e===null?this.cobra_model=null:this.cobra_model=i.from_cobra_json(e),this.map&&(this.map.cobra_model=this.cobra_model,t&&this._update_data(!0,!1),this.settings.get_option("highlight_missing")&&this.map.draw_all_reactions(!1,!1)),this.callback_manager.run("load_model",null,e,t)}function g(i,o){o===undefined&&(o=!0);var u=!0,f=!1;e.remove_child_nodes(this.selection);var h=e.setup_svg(this.selection,!1,this.options.fill_screen);this.zoom_container=new n(h,this.selection,this.options.scroll_behavior);var p=this.zoom_container.zoomed_sel;i!==null?(this.map=r.from_data(i,h,this.embedded_css,p,this.zoom_container,this.settings,this.cobra_model,this.options.enable_search),this.zoom_container.reset()):this.map=new r(h,this.embedded_css,p,this.zoom_container,this.settings,this.cobra_model,null,this.options.enable_search),o&&this._update_data(!1,!0),this.build_input=t(this.selection,this.map,this.zoom_container,this.settings),this.text_edit_input=c(this.selection,this.map,this.zoom_container),this.brush=new s(p,!1,this.map,".canvas-group"),this.map.canvas.callback_manager.set("resize",function(){this.brush.toggle(!0)}.bind(this)),this._setup_modes(this.map,this.brush,this.zoom_container);var d=this.selection.append("div").attr("class","search-menu-container").append("div").attr("class","search-menu-container-inline"),v=d.append("div"),m=d.append("div"),g=this.selection.append("div");this.search_bar=a(m,this.map.search_index,this.map),this.search_bar.callback_manager.set("show",function(){this.settings_bar.toggle(!1)}.bind(this));var y=this.selection.append("div");this.settings_bar=l(y,this.settings,this.map,function(e,t){var n=this.options[e+"_styles"];if(t&&n.indexOf("abs")==-1)n.push("abs");else if(!t){var r=n.indexOf("abs");r!=-1&&(this.options[e+"_styles"]=n.slice(0,r).concat(n.slice(r+1)))}this._update_data(!1,!0,e)}.bind(this)),this.settings_bar.callback_manager.set("show",function(){this.search_bar.toggle(!1)}.bind(this));var b=this._get_keys(this.map,this.zoom_container,this.search_bar,this.settings_bar,this.options.enable_editing);this.map.key_manager.assigned_keys=b,this.map.key_manager.input_list=[this.build_input,this.search_bar,this.settings_bar,this.text_edit_input],this.map.key_manager.update(),this.map.key_manager.toggle(this.options.enable_keys),this.options.menu=="all"?this._setup_menu(v,g,this.map,this.zoom_container,this.map.key_manager,b,this.options.enable_editing,this.options.enable_keys):this.options.menu=="zoom"&&this._setup_simple_zoom_buttons(g,b);if(i!==null)this.map.zoom_extent_canvas();else if(this.options.starting_reaction!==null&&this.cobra_model!==null){var w=this.zoom_container.get_size(),E={x:w.width/2,y:w.height/4};this.map.new_reaction_from_scratch(this.options.starting_reaction,E,90),this.map.zoom_extent_nodes()}else this.map.zoom_extent_canvas();var S=this._setup_status(this.selection,this.map);this._setup_quick_jump(this.selection),this.options.enable_editing?this.zoom_mode():this.view_mode(),this.options.enable_editing&&this._setup_confirm_before_exit(),this.map.draw_everything()}function y(e){this.search_bar.toggle(!1),this.build_input.toggle(e=="build"),this.build_input.direction_arrow.toggle(e=="build"),this.options.menu=="all"&&this.options.enable_editing&&this._toggle_direction_buttons(e=="build"),this.brush.toggle(e=="brush"),this.zoom_container.toggle_zoom(e=="zoom"||e=="view"),this.map.canvas.toggle_resize(e=="zoom"||e=="brush"),this.map.behavior.toggle_rotation_mode(e=="rotate"),this.map.behavior.toggle_selectable_click(e=="build"||e=="brush"||e=="rotate"),this.map.behavior.toggle_selectable_drag(e=="brush"||e=="rotate"),this.map.behavior.toggle_label_drag(e=="brush"),this.map.behavior.toggle_label_mousedown(e=="brush"),this.map.behavior.toggle_text_label_edit(e=="text"),this.map.behavior.toggle_bezier_drag(e=="brush"),(e=="view"||e=="text")&&this.map.select_none(),e=="rotate"&&this.map.deselect_text_labels(),this.map.draw_everything()}function b(){this.callback_manager.run("view_mode"),this._set_mode("view")}function w(){this.callback_manager.run("build_mode"),this._set_mode("build")}function E(){this.callback_manager.run("brush_mode"),this._set_mode("brush")}function S(){this.callback_manager.run("zoom_mode"),this._set_mode("zoom")}function x(){this.callback_manager.run("rotate_mode"),this._set_mode("rotate")}function T(){this.callback_manager.run("text_mode"),this._set_mode("text")}function N(e){this.options.reaction_data=e,this._update_data(!0,!0,"reaction")}function C(e){this.options.gene_data=e,this._update_data(!0,!0,"reaction")}function k(e){this.options.metabolite_data=e,this._update_data(!0,!0,"metabolite")}function L(t,n,r,i){function c(t,n,r){var i={};return n!==null&&e.extend(i,n.reactions),r!==null&&e.extend(i,r.reactions,!0),p.import_and_check(t,"gene_data",i)}r===undefined&&(r=["reaction","metabolite"]),i===undefined&&(i=!0);var s=r.indexOf("metabolite")!=-1,o=r.indexOf("reaction")!=-1,u,a,f;s&&n&&this.map!==null&&(u=p.import_and_check(this.options.metabolite_data,"metabolite_data"),this.map.apply_metabolite_data_to_map(u),i&&this.map.draw_all_nodes(!1)),o&&(this.options.reaction_data!==null&&n&&this.map!==null?(a=p.import_and_check(this.options.reaction_data,"reaction_data"),this.map.apply_reaction_data_to_map(a),i&&this.map.draw_all_reactions(!1,!1)):this.options.gene_data!==null&&n&&this.map!==null?(f=c(this.options.gene_data,this.cobra_model,this.map),this.map.apply_gene_data_to_map(f),i&&this.map.draw_all_reactions(!1,!1)):n&&this.map!==null&&(this.map.apply_reaction_data_to_map(null),i&&this.map.draw_all_reactions(!1,!1))),this.update_model_timer&&window.clearTimeout(this.update_model_timer);var l=5;this.update_model_timer=window.setTimeout(function(){s&&t&&this.cobra_model!==null&&(u||(u=p.import_and_check(this.options.metabolite_data,"metabolite_data")),this.cobra_model.apply_metabolite_data(u,this.options.metabolite_styles,this.options.metabolite_compare_style)),o&&(this.options.reaction_data!==null&&t&&this.cobra_model!==null?(a||(a=p.import_and_check(this.options.reaction_data,"reaction_data")),this.cobra_model.apply_reaction_data(a,this.options.reaction_styles,this.options.reaction_compare_style)):this.options.gene_data!==null&&t&&this.cobra_model!==null?(f||(f=c(this.options.gene_data,this.cobra_model,this.map)),this.cobra_model.apply_gene_data(f,this.options.reaction_styles,this.options.identifiers_on_map,this.options.reaction_compare_style,this.options.and_method_in_gene_reaction_rule)):t&&this.cobra_model!==null&&this.cobra_model.apply_reaction_data(null,this.options.reaction_styles,this.options.reaction_compare_style)),this.callback_manager.run("update_data",null,t,n,r,i)}.bind(this),l)}function A(e,t,n,r,i,s,o,a){function b(e,t){function r(e){if(!("map_id"in e[0]&&"reactions"in e[1]&&"nodes"in e[1]&&"canvas"in e[1]))throw new Error("Bad map data.")}if(e){console.warn(e),this.map.set_status("Error loading map: "+e,2e3);return}try{r(t),this.load_map(t),this.map.set_status("Loaded map "+t[0].map_name,3e3)}catch(n){console.warn(n),this.map.set_status("Error loading map: "+n,2e3)}}function w(e,t){if(e){console.warn(e),this.map.set_status("Error loading model: "+e,2e3);return}try{this.load_model(t,!0),this.build_input.toggle(!1),"id"in t?this.map.set_status("Loaded model "+t.id,3e3):this.map.set_status("Loaded model (no model id)",3e3)}catch(n){console.warn(n),this.map.set_status("Error loading model: "+n,2e3)}}function E(e,t){if(e){console.warn(e),this.map.set_status("Could not parse file as JSON or CSV",2e3);return}t!==null&&this.set_gene_data(null),this.set_reaction_data(t)}function S(e,t){if(e){console.warn(e),this.map.set_status("Could not parse file as JSON or CSV",2e3);return}this.set_metabolite_data(t)}function x(e,t){if(e){console.warn(e),this.map.set_status("Could not parse file as JSON or CSV",2e3);return}t!==null&&this.set_reaction_data(null),this.set_gene_data(t)}var f=e.attr("id","menu").append("ul").attr("class","nav nav-pills");u.dropdown_menu(f,"Map").button({key:s.save,text:"Save map JSON",key_text:a?" (Ctrl+S)":null}).button({text:"Load map JSON",key_text:a?" (Ctrl+O)":null,input:{assign:i.assigned_keys.load,key:"fn",fn:b.bind(this),pre_fn:function(){n.set_status("Loading map...")},failure_fn:function(){n.set_status("")}}}).button({key:s.save_svg,text:"Export as SVG",key_text:a?" (Ctrl+Shift+S)":null}).button({key:s.clear_map,text:"Clear map"});var l=u.dropdown_menu(f,"Model").button({text:"Load COBRA model JSON",key_text:a?" (Ctrl+M)":null,input:{assign:i.assigned_keys.load_model,key:"fn",fn:w.bind(this),pre_fn:function(){n.set_status("Loading model...")},failure_fn:function(){n.set_status("")}}}).button({key:s.clear_model,text:"Clear model"}),c=function(){l.dropdown.selectAll("li").classed("escher-disabled",function(e){return e.text=="Clear model"&&this.cobra_model===null?!0:null}.bind(this))}.bind(this);c(),this.callback_manager.set("load_model",c);var h=u.dropdown_menu(f,"Data").button({input:{assign:i.assigned_keys.load_reaction_data,key:"fn",fn:E.bind(this),accept_csv:!0},text:"Load reaction data"}).button({key:s.clear_reaction_data,text:"Clear reaction data"}).divider().button({input:{fn:x.bind(this),accept_csv:!0},text:"Load gene data"}).button({key:s.clear_gene_data,text:"Clear gene data"}).divider().button({input:{fn:S.bind(this),accept_csv:!0},text:"Load metabolite data"}).button({key:s.clear_metabolite_data,text:"Clear metabolite data"}),p=function(){h.dropdown.selectAll("li").classed("escher-disabled",function(e){return e?e.text=="Clear reaction data"&&this.options.reaction_data===null?!0:e.text=="Clear gene data"&&this.options.gene_data===null?!0:e.text=="Clear metabolite data"&&this.options.metabolite_data===null?!0:null:null}.bind(this))}.bind(this);p(),this.callback_manager.set("update_data",p);var d=u.dropdown_menu(f,"Edit",!0);o?d.button({key:s.zoom_mode,id:"zoom-mode-menu-button",text:"Pan mode",key_text:a?" (Z)":null}).button({key:s.brush_mode,id:"brush-mode-menu-button",text:"Select mode",key_text:a?" (V)":null}).button({key:s.build_mode,id:"build-mode-menu-button",text:"Add reaction mode",key_text:a?" (N)":null}).button({key:s.rotate_mode,id:"rotate-mode-menu-button",text:"Rotate mode",key_text:a?" (R)":null}).button({key:s.text_mode,id:"text-mode-menu-button",text:"Text mode",key_text:a?" (T)":null}).divider().button({key:s.delete,text:"Delete",key_text:a?" (Del)":null}).button({key:s.undo,text:"Undo",key_text:a?" (Ctrl+Z)":null}).button({key:s.redo,text:"Redo",key_text:a?" (Ctrl+Shift+Z)":null}).button({key:s.toggle_primary,text:"Toggle primary/secondary",key_text:a?" (P)":null}).button({key:s.cycle_primary,text:"Rotate reactant locations",key_text:a?" (C)":null}).button({key:s.select_all,text:"Select all",key_text:a?" (Ctrl+A)":null}).button({key:s.select_none,text:"Select none",key_text:a?" (Ctrl+Shift+A)":null}).button({key:s.invert_selection,text:"Invert selection"}):d.button({key:s.view_mode,id:"view-mode-menu-button",text:"View mode"});var v=u.dropdown_menu(f,"View",!0).button({key:s.zoom_in,text:"Zoom in",key_text:a?" (Ctrl and +)":null}).button({key:s.zoom_out,text:"Zoom out",key_text:a?" (Ctrl and -)":null}).button({key:s.extent_nodes,text:"Zoom to nodes",key_text:a?" (Ctrl+0)":null}).button({key:s.extent_canvas,text:"Zoom to canvas",key_text:a?" (Ctrl+1)":null}).button({key:s.search,text:"Find",key_text:a?" (Ctrl+F)":null});o&&(v.button({key:s.toggle_beziers,id:"bezier-button",text:"Show control points",key_text:a?" (B)":null}),n.callback_manager.set("toggle_beziers.button",function(e){f.select("#bezier-button").select(".dropdown-button-text").text((e?"Hide":"Show")+" control points"+(a?" (B)":""))})),v.divider().button({key:s.show_settings,text:"Settings",key_text:a?" (Ctrl+,)":null}),f.append("a").attr("class","help-button").attr("target","#").attr("href","https://escher.readthedocs.org").text("?");var m=t.append("ul").attr("class","nav nav-pills nav-stacked").attr("id","button-panel");u.individual_button(m.append("li"),{key:s.zoom_in,icon:"glyphicon glyphicon-plus-sign",classes:"btn btn-default",tooltip:"Zoom in",key_text:a?" (Ctrl and +)":null}),u.individual_button(m.append("li"),{key:s.zoom_out,icon:"glyphicon glyphicon-minus-sign",classes:"btn btn-default",tooltip:"Zoom out",key_text:a?" (Ctrl and -)":null}),u.individual_button(m.append("li"),{key:s.extent_canvas,icon:"glyphicon glyphicon-resize-full",classes:"btn btn-default",tooltip:"Zoom to canvas",key_text:a?" (Ctrl+1)":null});if(o){u.radio_button_group(m.append("li")).button({key:s.zoom_mode,id:"zoom-mode-button",icon:"glyphicon glyphicon-move",tooltip:"Pan mode",key_text:a?" (Z)":null}).button({key:s.brush_mode,id:"brush-mode-button",icon:"glyphicon glyphicon-hand-up",tooltip:"Select mode",key_text:a?" (V)":null}).button({key:s.build_mode,id:"build-mode-button",icon:"glyphicon glyphicon-plus",tooltip:"Add reaction mode",key_text:a?" (N)":null}).button({key:s.rotate_mode,id:"rotate-mode-button",icon:"glyphicon glyphicon-repeat",tooltip:"Rotate mode",key_text:a?" (R)":null}).button({key:s.text_mode,id:"text-mode-button",icon:"glyphicon glyphicon-font",tooltip:"Text mode",key_text:a?" (T)":null}),this.direction_buttons=m.append("li");var g=u.button_group(this.direction_buttons).button({key:s.direction_arrow_left,icon:"glyphicon glyphicon-arrow-left",tooltip:"Direction arrow (←)"}).button({key:s.direction_arrow_right,icon:"glyphicon glyphicon-arrow-right",tooltip:"Direction arrow (→)"}).button({key:s.direction_arrow_up,icon:"glyphicon glyphicon-arrow-up",tooltip:"Direction arrow (↑)"}).button({key:s.direction_arrow_down,icon:"glyphicon glyphicon-arrow-down",tooltip:"Direction arrow (↓)"})}var y=function(e){$(this.selection.node()).find("#"+e).button("toggle");var t=["zoom-mode-menu-button","brush-mode-menu-button","build-mode-menu-button","rotate-mode-menu-button","view-mode-menu-button","text-mode-menu-button"];t.forEach(function(t){var n=t.replace("-menu","");this.selection.select("#"+t).select("span").classed("glyphicon",n==e).classed("glyphicon-ok",n==e)}.bind(this))};this.callback_manager.set("zoom_mode",y.bind(this,"zoom-mode-button")),this.callback_manager.set("brush_mode",y.bind(this,"brush-mode-button")),this.callback_manager.set("build_mode",y.bind(this,"build-mode-button")),this.callback_manager.set("rotate_mode",y.bind(this,"rotate-mode-button")),this.callback_manager.set("view_mode",y.bind(this,"view-mode-button")),this.callback_manager.set("text_mode",y.bind(this,"text-mode-button"))}function O(e,t){var n=e.append("div").attr("id","simple-button-panel");u.individual_button(n.append("div"),{key:t.zoom_in,text:"+",classes:"simple-button",tooltip:"Zoom in (Ctrl +)"}),u.individual_button(n.append("div"),{key:t.zoom_out,text:"–",classes:"simple-button",tooltip:"Zoom out (Ctrl -)"}),u.individual_button(n.append("div"),{key:t.extent_canvas,text:"↔",classes:"simple-button",tooltip:"Zoom to canvas (Ctrl 1)"})}function M(e){e===undefined&&(e=!this.direction_buttons.style("visibility")=="visible"),this.direction_buttons.style("visibility",e?"visible":"hidden")}function _(e,t){var n=e.append("div").attr("id","status");return t.callback_manager.set("set_status",function(e){n.text(e)}),n}function D(t){var n=function(t,n,r){if(this.options.enable_editing&&!this.options.never_ask_before_quit&&!confirm("You will lose any unsaved changes.\n\nAre you sure you want to switch maps?")){r&&r(!1);return}this.map.set_status("Loading map "+t+" ...");var i=e.name_to_url(t,n);d3.json(i,function(e,t){e&&(console.warn("Could not load data: "+e),r&&r(!1)),r&&r(!0),this.load_map(t),this.map.set_status("")}.bind(this))}.bind(this);this.quick_jump=h(t,n)}function P(e,t,n){var r={};e.callback_manager.set("start_rotation",function(){r.brush=t.enabled,t.toggle(!1),r.zoom=n.zoom_on,n.toggle_zoom(!1),r.selectable_mousedown=e.behavior.selectable_mousedown!=null,e.behavior.toggle_selectable_click(!1),r.label_mousedown=e.behavior.label_mousedown!=null,e.behavior.toggle_label_mousedown(!1)}),e.callback_manager.set("end_rotation",function(){t.toggle(r.brush),n.toggle_zoom(r.zoom),e.behavior.toggle_selectable_click(r.selectable_mousedown),e.behavior.toggle_label_mousedown(r.label_mousedown),r={}})}function H(t,n,r,i,s){var o={save:{key:83,modifiers:{control:!0},target:t,fn:t.save},save_svg:{key:83,modifiers:{control:!0,shift:!0},target:t,fn:t.save_svg},load:{key:79,modifiers:{control:!0},fn:null},clear_map:{fn:this.map.clear_map.bind(this.map)},load_model:{key:77,modifiers:{control:!0},fn:null},clear_model:{fn:this.load_model.bind(this,null,!0)},load_reaction_data:{fn:null},clear_reaction_data:{target:this,fn:function(){this.set_reaction_data(null)}},load_metabolite_data:{fn:null},clear_metabolite_data:{target:this,fn:function(){this.set_metabolite_data(null)}},load_gene_data:{fn:null},clear_gene_data:{target:this,fn:function(){this.set_gene_data(null)}},zoom_in:{key:187,modifiers:{control:!0},target:n,fn:n.zoom_in},zoom_out:{key:189,modifiers:{control:!0},target:n,fn:n.zoom_out},extent_nodes:{key:48,modifiers:{control:!0},target:t,fn:t.zoom_extent_nodes},extent_canvas:{key:49,modifiers:{control:!0},target:t,fn:t.zoom_extent_canvas},search:{key:70,modifiers:{control:!0},fn:r.toggle.bind(r,!0)},view_mode:{fn:this.view_mode.bind(this),ignore_with_input:!0},show_settings:{key:188,modifiers:{control:!0},fn:i.toggle.bind(i)}};return s&&e.extend(o,{build_mode:{key:78,fn:this.build_mode.bind(this),ignore_with_input:!0},zoom_mode:{key:90,fn:this.zoom_mode.bind(this),ignore_with_input:!0},brush_mode:{key:86,fn:this.brush_mode.bind(this),ignore_with_input:!0},rotate_mode:{key:82,fn:this.rotate_mode.bind(this),ignore_with_input:!0},text_mode:{key:84,fn:this.text_mode.bind(this),ignore_with_input:!0},toggle_beziers:{key:66,target:t,fn:t.toggle_beziers,ignore_with_input:!0},"delete":{key:8,modifiers:{control:!0},target:t,fn:t.delete_selected,ignore_with_input:!0},delete_del:{key:46,modifiers:{control:!1},target:t,fn:t.delete_selected,ignore_with_input:!0},toggle_primary:{key:80,target:t,fn:t.toggle_selected_node_primary,ignore_with_input:!0},cycle_primary:{key:67,target:t,fn:t.cycle_primary_node,ignore_with_input:!0},direction_arrow_right:{key:39,fn:this.build_input.direction_arrow.right.bind(this.build_input.direction_arrow),ignore_with_input:!0},direction_arrow_down:{key:40,fn:this.build_input.direction_arrow.down.bind(this.build_input.direction_arrow),ignore_with_input:!0},direction_arrow_left:{key:37,fn:this.build_input.direction_arrow.left.bind(this.build_input.direction_arrow),ignore_with_input:!0},direction_arrow_up:{key:38,fn:this.build_input.direction_arrow.up.bind(this.build_input.direction_arrow),ignore_with_input:!0},undo:{key:90,modifiers:{control:!0},target:t.undo_stack,fn:t.undo_stack.undo},redo:{key:90,modifiers:{control:!0,shift:!0},target:t.undo_stack,fn:t.undo_stack.redo},select_all:{key:65,modifiers:{control:!0},fn:t.select_all.bind(t)},select_none:{key:65,modifiers:{control:!0,shift:!0},fn:t.select_none.bind(t)},invert_selection:{fn:t.invert_selection.bind(t)}}),o}function B(){window.onbeforeunload=function(e){return e=e||window.event,this.options.never_ask_before_quit?null:"You will lose any unsaved changes."}.bind(this)}var d=e.make_class();return d.prototype={init:v,load_map:g,load_model:m,_set_mode:y,view_mode:b,build_mode:w,brush_mode:E,zoom_mode:S,rotate_mode:x,text_mode:T,set_reaction_data:N,set_metabolite_data:k,set_gene_data:C,_update_data:L,_toggle_direction_buttons:M,_setup_menu:A,_setup_simple_zoom_buttons:O,_setup_status:_,_setup_quick_jump:D,_setup_modes:P,_get_keys:H,_setup_confirm_before_exit:B},d}),n("DataMenu",["utils"],function(e){return function(t){function s(e,t,n,r,i){n.node().addEventListener("change",function(){o(e,this.value,i,r)},!1);var s=t[0];u(t,n),o(e,s,i,r)}function o(t,r,i,s){e.load_the_file(t,r,function(e,t){if(e)return console.warn(e);n.data=t,s&&s(t)})}function u(e,t){t.selectAll(".menu-option").data(e).enter().append("option").attr("value",function(e){return e}).text(function(e){return e}),t.node().focus()}function a(){return n.data}var n=e.set_options(t,{selection:null,getdatafiles:null,datafiles:null,update_callback:null,target:null});if(n.selection===null)throw new Error("No selection provided for DataMenu");var r=n.selection.select(".data-menu");r.empty()&&(r=n.selection.append("div").attr("class","data-menu"));var i=r.append("form").append("select").attr("class","dropdown-menu");return n.getdatafiles?(n.datafiles&&console.warn("DataMenu: getdatafiles option overrides datafiles"),d3.json(n.getdatafiles,function(e,t){return e?console.warn(e):(s(n.target,t.data,i,n.update_callback,n.selection),null)})):n.datafiles?s(n.target,n.datafiles,i,n.update_callback,n.selection):console.warn("DataMenu: No datafiles given"),{update:u}}}),n("static",["utils"],function(e){function t(t,r,i,s,o){var u=e.parse_url_components(window,s),a=[],f=function(e){e(null)},l=function(e){e(null)};if(u.map_name){var c=n("map",u.map_name,i,t);c&&(f=function(e){d3.json(c,function(t,n){t&&console.warn(t),e(n)})})}if(u.model_name){var h=n("model",u.model_name,i,r);h&&(l=function(e){d3.json(h,function(t,n){t&&console.warn(t),e(n)})})}f(function(e){l(function(t){o(e,t,s)})})}function n(e,t,n,r){var i=n[e+"s"].filter(function(n){return n[e+"_name"]==t});if(i.length==0)throw new Error("Bad "+e+" "+t);return r+encodeURIComponent(i[0].organism)+"/"+encodeURIComponent(i[0][e+"_name"])+".json"}return{load_map_model_from_url:t}}),n("main",["Builder","Map","Behavior","KeyManager","DataMenu","UndoStack","CobraModel","utils","SearchIndex","Settings","data_styles","ui","static"],function(e,t,n,r,i,s,o,u,a,f,l,c,h){return{Builder:e,Map:t,Behavior:n,KeyManager:r,DataMenu:i,UndoStack:s,CobraModel:o,utils:u,SearchIndex:a,Settings:f,data_styles:l,ui:c,"static":h}}),t("main")});