/**
 * almond 0.2.6 Copyright (c) 2011-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */

/**
 * vkBeautify - javascript plugin to pretty-print or minify text in XML, JSON, CSS and SQL formats.
 *
 * Version - 0.99.00.beta
 * Copyright (c) 2012 Vadim Kiryukhin
 * vkiryukhin @ gmail.com
 * http://www.eslinstructor.net/vkbeautify/
 *
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 *   Pretty print
 *
 *        vkbeautify.xml(text [,indent_pattern]);
 *        vkbeautify.json(text [,indent_pattern]);
 *        vkbeautify.css(text [,indent_pattern]);
 *        vkbeautify.sql(text [,indent_pattern]);
 *
 *        @text - String; text to beatufy;
 *        @indent_pattern - Integer | String;
 *                Integer:  number of white spaces;
 *                String:   character string to visualize indentation ( can also be a set of white spaces )
 *   Minify
 *
 *        vkbeautify.xmlmin(text [,preserve_comments]);
 *        vkbeautify.jsonmin(text);
 *        vkbeautify.cssmin(text [,preserve_comments]);
 *        vkbeautify.sqlmin(text);
 *
 *        @text - String; text to minify;
 *        @preserve_comments - Bool; [optional];
 *                Set this flag to true to prevent removing comments from @text ( minxml and mincss functions only. )
 *
 *   Examples:
 *        vkbeautify.xml(text); // pretty print XML
 *        vkbeautify.json(text, 4 ); // pretty print JSON
 *        vkbeautify.css(text, '. . . .'); // pretty print CSS
 *        vkbeautify.sql(text, '----'); // pretty print SQL
 *
 *        vkbeautify.xmlmin(text, true);// minify XML, preserve comments
 *        vkbeautify.jsonmin(text);// minify JSON
 *        vkbeautify.cssmin(text);// minify CSS, remove comments ( default )
 *        vkbeautify.sqlmin(text);// minify SQL
 *
 */

/**
 * complete.ly 1.0.0
 * MIT Licensing
 * Copyright (c) 2013 Lorenzo Puccetti
 * 
 * This Software shall be used for doing good things, not bad things.
 * 
**/

(function(e,t){typeof define=="function"&&define.amd?define("escher",t):e.escher=t()})(this,function(){var e,t,n;return function(r){function d(e,t){return h.call(e,t)}function v(e,t){var n,r,i,s,o,u,a,f,c,h,p=t&&t.split("/"),d=l.map,v=d&&d["*"]||{};if(e&&e.charAt(0)===".")if(t){p=p.slice(0,p.length-1),e=p.concat(e.split("/"));for(f=0;f<e.length;f+=1){h=e[f];if(h===".")e.splice(f,1),f-=1;else if(h===".."){if(f===1&&(e[2]===".."||e[0]===".."))break;f>0&&(e.splice(f-1,2),f-=2)}}e=e.join("/")}else e.indexOf("./")===0&&(e=e.substring(2));if((p||v)&&d){n=e.split("/");for(f=n.length;f>0;f-=1){r=n.slice(0,f).join("/");if(p)for(c=p.length;c>0;c-=1){i=d[p.slice(0,c).join("/")];if(i){i=i[r];if(i){s=i,o=f;break}}}if(s)break;!u&&v&&v[r]&&(u=v[r],a=f)}!s&&u&&(s=u,o=a),s&&(n.splice(0,o,s),e=n.join("/"))}return e}function m(e,t){return function(){return s.apply(r,p.call(arguments,0).concat([e,t]))}}function g(e){return function(t){return v(t,e)}}function y(e){return function(t){a[e]=t}}function b(e){if(d(f,e)){var t=f[e];delete f[e],c[e]=!0,i.apply(r,t)}if(!d(a,e)&&!d(c,e))throw new Error("No "+e);return a[e]}function w(e){var t,n=e?e.indexOf("!"):-1;return n>-1&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function E(e){return function(){return l&&l.config&&l.config[e]||{}}}var i,s,o,u,a={},f={},l={},c={},h=Object.prototype.hasOwnProperty,p=[].slice;o=function(e,t){var n,r=w(e),i=r[0];return e=r[1],i&&(i=v(i,t),n=b(i)),i?n&&n.normalize?e=n.normalize(e,g(t)):e=v(e,t):(e=v(e,t),r=w(e),i=r[0],e=r[1],i&&(n=b(i))),{f:i?i+"!"+e:e,n:e,pr:i,p:n}},u={require:function(e){return m(e)},exports:function(e){var t=a[e];return typeof t!="undefined"?t:a[e]={}},module:function(e){return{id:e,uri:"",exports:a[e],config:E(e)}}},i=function(e,t,n,i){var s,l,h,p,v,g=[],w;i=i||e;if(typeof n=="function"){t=!t.length&&n.length?["require","exports","module"]:t;for(v=0;v<t.length;v+=1){p=o(t[v],i),l=p.f;if(l==="require")g[v]=u.require(e);else if(l==="exports")g[v]=u.exports(e),w=!0;else if(l==="module")s=g[v]=u.module(e);else if(d(a,l)||d(f,l)||d(c,l))g[v]=b(l);else{if(!p.p)throw new Error(e+" missing "+l);p.p.load(p.n,m(i,!0),y(l),{}),g[v]=a[l]}}h=n.apply(a[e],g);if(e)if(s&&s.exports!==r&&s.exports!==a[e])a[e]=s.exports;else if(h!==r||!w)a[e]=h}else e&&(a[e]=n)},e=t=s=function(e,t,n,a,f){return typeof e=="string"?u[e]?u[e](t):b(o(e,t).f):(e.splice||(l=e,t.splice?(e=t,t=n,n=null):e=r),t=t||function(){},typeof n=="function"&&(n=a,a=f),a?i(r,e,t,n):setTimeout(function(){i(r,e,t,n)},4),s)},s.config=function(e){return l=e,l.deps&&s(l.deps,l.callback),s},e._defined=a,n=function(e,t,n){t.splice||(n=t,t=[]),!d(a,e)&&!d(f,e)&&(f[e]=[e,t,n])},n.amd={jQuery:!0}}(),n("../build/almond",function(){}),n("lib/vkbeautify",[],function(){function e(e){var t="    ";if(isNaN(parseInt(e)))t=e;else switch(e){case 1:t=" ";break;case 2:t="  ";break;case 3:t="   ";break;case 4:t="    ";break;case 5:t="     ";break;case 6:t="      ";break;case 7:t="       ";break;case 8:t="        ";break;case 9:t="         ";break;case 10:t="          ";break;case 11:t="           ";break;case 12:t="            "}var n=["\n"];for(ix=0;ix<100;ix++)n.push(n[ix]+t);return n}function t(){this.step="    ",this.shift=e(this.step)}function n(e,t){return t-(e.replace(/\(/g,"").length-e.replace(/\)/g,"").length)}function r(e,t){return e.replace(/\s{1,}/g," ").replace(/ AND /ig,"~::~"+t+t+"AND ").replace(/ BETWEEN /ig,"~::~"+t+"BETWEEN ").replace(/ CASE /ig,"~::~"+t+"CASE ").replace(/ ELSE /ig,"~::~"+t+"ELSE ").replace(/ END /ig,"~::~"+t+"END ").replace(/ FROM /ig,"~::~FROM ").replace(/ GROUP\s{1,}BY/ig,"~::~GROUP BY ").replace(/ HAVING /ig,"~::~HAVING ").replace(/ IN /ig," IN ").replace(/ JOIN /ig,"~::~JOIN ").replace(/ CROSS~::~{1,}JOIN /ig,"~::~CROSS JOIN ").replace(/ INNER~::~{1,}JOIN /ig,"~::~INNER JOIN ").replace(/ LEFT~::~{1,}JOIN /ig,"~::~LEFT JOIN ").replace(/ RIGHT~::~{1,}JOIN /ig,"~::~RIGHT JOIN ").replace(/ ON /ig,"~::~"+t+"ON ").replace(/ OR /ig,"~::~"+t+t+"OR ").replace(/ ORDER\s{1,}BY/ig,"~::~ORDER BY ").replace(/ OVER /ig,"~::~"+t+"OVER ").replace(/\(\s{0,}SELECT /ig,"~::~(SELECT ").replace(/\)\s{0,}SELECT /ig,")~::~SELECT ").replace(/ THEN /ig," THEN~::~"+t+"").replace(/ UNION /ig,"~::~UNION~::~").replace(/ USING /ig,"~::~USING ").replace(/ WHEN /ig,"~::~"+t+"WHEN ").replace(/ WHERE /ig,"~::~WHERE ").replace(/ WITH /ig,"~::~WITH ").replace(/ ALL /ig," ALL ").replace(/ AS /ig," AS ").replace(/ ASC /ig," ASC ").replace(/ DESC /ig," DESC ").replace(/ DISTINCT /ig," DISTINCT ").replace(/ EXISTS /ig," EXISTS ").replace(/ NOT /ig," NOT ").replace(/ NULL /ig," NULL ").replace(/ LIKE /ig," LIKE ").replace(/\s{0,}SELECT /ig,"SELECT ").replace(/\s{0,}UPDATE /ig,"UPDATE ").replace(/ SET /ig," SET ").replace(/~::~{1,}/g,"~::~").split("~::~")}return t.prototype.xml=function(t,n){var r=t.replace(/>\s{0,}</g,"><").replace(/</g,"~::~<").replace(/\s*xmlns\:/g,"~::~xmlns:").replace(/\s*xmlns\=/g,"~::~xmlns=").split("~::~"),i=r.length,s=!1,o=0,u="",a=0,f=n?e(n):this.shift;for(a=0;a<i;a++)if(r[a].search(/<!/)>-1){u+=f[o]+r[a],s=!0;if(r[a].search(/-->/)>-1||r[a].search(/\]>/)>-1||r[a].search(/!DOCTYPE/)>-1)s=!1}else r[a].search(/-->/)>-1||r[a].search(/\]>/)>-1?(u+=r[a],s=!1):/^<\w/.exec(r[a-1])&&/^<\/\w/.exec(r[a])&&/^<[\w:\-\.\,]+/.exec(r[a-1])==/^<\/[\w:\-\.\,]+/.exec(r[a])[0].replace("/","")?(u+=r[a],s||o--):r[a].search(/<\w/)>-1&&r[a].search(/<\//)==-1&&r[a].search(/\/>/)==-1?u=s?u+=r[a]:u+=f[o++]+r[a]:r[a].search(/<\w/)>-1&&r[a].search(/<\//)>-1?u=s?u+=r[a]:u+=f[o]+r[a]:r[a].search(/<\//)>-1?u=s?u+=r[a]:u+=f[--o]+r[a]:r[a].search(/\/>/)>-1?u=s?u+=r[a]:u+=f[o]+r[a]:r[a].search(/<\?/)>-1?u+=f[o]+r[a]:r[a].search(/xmlns\:/)>-1||r[a].search(/xmlns\=/)>-1?u+=f[o]+r[a]:u+=r[a];return u[0]=="\n"?u.slice(1):u},t.prototype.json=function(e,t){var t=t?t:this.step;return typeof JSON=="undefined"?e:typeof e=="string"?JSON.stringify(JSON.parse(e),null,t):typeof e=="object"?JSON.stringify(e,null,t):e},t.prototype.css=function(t,n){var r=t.replace(/\s{1,}/g," ").replace(/\{/g,"{~::~").replace(/\}/g,"~::~}~::~").replace(/\;/g,";~::~").replace(/\/\*/g,"~::~/*").replace(/\*\//g,"*/~::~").replace(/~::~\s{0,}~::~/g,"~::~").split("~::~"),i=r.length,s=0,o="",u=0,a=n?e(n):this.shift;for(u=0;u<i;u++)/\{/.exec(r[u])?o+=a[s++]+r[u]:/\}/.exec(r[u])?o+=a[--s]+r[u]:/\*\\/.exec(r[u])?o+=a[s]+r[u]:o+=a[s]+r[u];return o.replace(/^\n{1,}/,"")},t.prototype.sql=function(t,i){var s=t.replace(/\s{1,}/g," ").replace(/\'/ig,"~::~'").split("~::~"),o=s.length,u=[],a=0,f=this.step,l=!0,c=!1,h=0,p="",d=0,v=i?e(i):this.shift;for(d=0;d<o;d++)d%2?u=u.concat(s[d]):u=u.concat(r(s[d],f));o=u.length;for(d=0;d<o;d++){h=n(u[d],h),/\s{0,}\s{0,}SELECT\s{0,}/.exec(u[d])&&(u[d]=u[d].replace(/\,/g,",\n"+f+f+"")),/\s{0,}\s{0,}SET\s{0,}/.exec(u[d])&&(u[d]=u[d].replace(/\,/g,",\n"+f+f+"")),/\s{0,}\(\s{0,}SELECT\s{0,}/.exec(u[d])?(a++,p+=v[a]+u[d]):/\'/.exec(u[d])?(h<1&&a&&a--,p+=u[d]):(p+=v[a]+u[d],h<1&&a&&a--);var m=0}return p=p.replace(/^\n{1,}/,"").replace(/\n{1,}/g,"\n"),p},t.prototype.xmlmin=function(e,t){var n=t?e:e.replace(/\<![ \r\n\t]*(--([^\-]|[\r\n]|-[^\-])*--[ \r\n\t]*)\>/g,"").replace(/[ \r\n\t]{1,}xmlns/g," xmlns");return n.replace(/>\s{0,}</g,"><")},t.prototype.jsonmin=function(e){return typeof JSON=="undefined"?e:JSON.stringify(JSON.parse(e),null,0)},t.prototype.cssmin=function(e,t){var n=t?e:e.replace(/\/\*([^*]|[\r\n]|(\*+([^*/]|[\r\n])))*\*+\//g,"");return n.replace(/\s{1,}/g," ").replace(/\{\s{1,}/g,"{").replace(/\}\s{1,}/g,"}").replace(/\;\s{1,}/g,";").replace(/\/\*\s{1,}/g,"/*").replace(/\*\/\s{1,}/g,"*/")},t.prototype.sqlmin=function(e){return e.replace(/\s{1,}/g," ").replace(/\s{1,}\(/,"(").replace(/\s{1,}\)/,")")},new t}),n("utils",["lib/vkbeautify"],function(e){function t(e,t){if(e===undefined)return t;var n=-1,r=t;for(var i in e){var s=e[i];s===undefined&&(s=null),r[i]=s}return r}function n(e,t,n,r){var i=function(e,t,n){e&&(d3.select("body").classed("fill-screen-body",!0),t.classed("fill-screen-div",!0));var r=t.append("svg").attr("class","escher-svg").attr("xmlns","http://www.w3.org/2000/svg");return r},s;e.classed("escher-container",!0);if(t)return e;if(e)return i(r,e,n);throw new Error("No selection")}function r(e){var t=e.node();while(t.hasChildNodes())t.removeChild(t.lastChild)}function i(e,t){var n="";return e&&d3.text(e,function(e,r){e&&console.warn(e),n=r,t(n)}),!1}function s(){return"omg yes"}function o(e,t,n,r){function i(e,t){return e.indexOf(t,e.length-t.length)!==-1}if(r){t&&console.warn("File "+t+" overridden by value."),n.call(e,null,r,t);return}if(!t){n.call(e,"No filename",null,t);return}i(t,"json")?d3.json(t,function(e,r){n(e,r,t)}):i(t,"css")?d3.text(t,function(e,r){n(e,r,t)}):n.call(e,"Unrecognized file type",null,t);return}function u(e,t,n){var r=-1,i=t.length,s={};while(++r<t.length){var u=t[r].file;s[u]=t[r].callback,o(e,u,function(t,r,o){s[o].call(e,t,r),--i||n.call(e)},t[r].value)}}function a(){var e,t=function(n){if(!(this instanceof t)){e=!0;var r=new t(arguments);return e=!1,r}typeof this.init=="function"&&this.init.apply(this,e?n:arguments)};return t}function f(e,t){e.select("defs").remove();var n=e.append("defs");return n.append("style").attr("type","text/css").text(t),n}function l(e,t,n,r,i,s){var o=e.select(t).selectAll(n).data(r);o.enter().call(i),o.call(s),o.exit().remove()}function c(e,t,n,r,i,s,o){var u=e.select(t).selectAll(n).data(h(r,i),function(e){return e[i]});u.enter().call(s),u.call(o),u.exit().remove()}function h(e,t){var n=[];for(var r in e){var i=v(e[r]);i[t]=r,n.push(i)}return n}function p(e,t){if(!e||!t)return!1;if(e.length!=t.length)return!1;for(var n=0,r=e.length;n<r;n++)if(e[n]!=t[n])return!1;return!0}function d(e){var t={};for(var n=0,r=e.length;n<r;n++){var i=e[n];for(var s in i)if(s in t)t[s][n]=i[s];else{var o=[];for(var u=0;u<n;u++)o[u]=null;o[n]=i[s],t[s]=o}for(var s in t)for(var u=t[s].length;u<=n;u++)t[s][u]=null}return t}function v(e){if(null==e||"object"!=typeof e)return e;if(e instanceof Array){var t=[];for(var n=0,r=e.length;n<r;n++)t[n]=v(e[n]);return t}if(e instanceof Object){var t={};for(var i in e)e.hasOwnProperty(i)&&(t[i]=v(e[i]));return t}throw new Error("Unable to copy obj! Its type isn't supported.")}function m(e,t){for(var n in t)n in e?console.error("Attribute "+n+" already in object."):e[n]=t[n]}function g(e){var t=[];return e.forEach(function(e){e.forEach(function(e){t.indexOf(e)<0&&t.push(e)})}),t}function y(e,t){return e===null||t===null||e===undefined||t===undefined?null:{x:e.x+t.x,y:e.y+t.y}}function b(e,t){return e===null||t===null||e===undefined||t===undefined?null:{x:e.x-t.x,y:e.y-t.y}}function w(e,t){return{x:e.x*t,y:e.y*t}}function E(e,t){function s(e){return window.btoa(unescape(encodeURIComponent(e)))}var n=document.createElement("a");n.download=t+".json";var r=JSON.stringify(e);n.setAttribute("href-lang","text/json"),n.href="data:image/svg+xml;base64,"+s(r);var i=document.createEvent("MouseEvents");i.initMouseEvent("click",!0,!1,self,0,0,0,0,0,!1,!1,!1,!1,0,null),n.dispatchEvent(i)}function S(e,t,n){window.File&&window.FileReader&&window.FileList&&window.Blob||t.call(n,"The File APIs are not fully supported in this browser.",null);var r=new window.FileReader;r.onload=function(e){var r=JSON.parse(e.target.result);t.call(n,null,r)},r.readAsText(e)}function x(t,n,r){function u(e){return window.btoa(unescape(encodeURIComponent(e)))}var i=document.createElement("a"),s,o;i.download=t+".svg",s=(new XMLSerializer).serializeToString(n.node()),r&&(s=e.xml(s)),s='<?xml version="1.0" encoding="utf-8"?>\n             <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN"\n         "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n'+s,i.setAttribute("href-lang","image/svg+xml"),i.href="data:image/svg+xml;base64,"+u(s),o=document.createEvent("MouseEvents"),o.initMouseEvent("click",!0,!1,self,0,0,0,0,0,!1,!1,!1,!1,0,null),i.dispatchEvent(o)}function T(e,t,n){var r=function(e){return N(e,t,n)};return e.map(r)}function N(e,t,n){var r=Math.cos(-t)*(e.x-n.x)+Math.sin(-t)*(e.y-n.y)+n.x-e.x,i=-Math.sin(-t)*(e.x-n.x)+Math.cos(-t)*(e.y-n.y)+n.y-e.y;return{x:r,y:i}}function C(e){var t=e[1].x-e[0].x,n=e[1].y-e[0].y;return t==0&&n>=0?Math.PI/2:t==0&&n<0?3*Math.PI/2:t>=0&&n>=0?Math.atan(n/t):t>=0?Math.atan(n/t)+2*Math.PI:Math.atan(n/t)+Math.PI}function k(e){return e*180/Math.PI}function L(e,t,n){var r=Math.atan2(t.x-n.x,n.y-t.y),i=Math.atan2(t.x-n.x+e.x,n.y-t.y-e.y),s=i-r;return s}function A(e,t){return Math.sqrt(Math.pow(t.y-e.y,2)+Math.pow(t.x-e.x,2))}function O(e,t){t.map(function(n,r){e[r]===undefined&&console.error("Argument is undefined: "+String(t[r]))})}function M(e,t){return e+"_"+t}function _(e){function n(e){var t=/(.*)_([a-z0-9]{1,2})$/,n=t.exec(e);return n===null?null:n.slice(1,3)}var t=n(e);return t===null&&(t=[e,null]),t}function D(e,t,n){if(typeof t=="string"){var r;if(t=="String")r=function(e){return typeof e=="string"};else if(t=="Float")r=function(e){return typeof e=="number"};else if(t=="Integer")r=function(e){return typeof e=="number"&&parseFloat(e,10)==parseInt(e,10)};else if(t=="Boolean")r=function(e){return typeof e=="boolean"};else if(t!="*")throw new Error("Bad spec string: "+t);if(!r(e))throw new Error("Bad type: "+String(e)+" should be "+t)}else if(t instanceof Array)e.forEach(function(e){D(e,t[0],n)});else{var i=Object.keys(t)[0];if(i=="*")for(var s in e){if(e[s]===null&&n.indexOf(s)!=-1)continue;D(e[s],t[i],n)}else for(var s in t){if(!(s in e))throw new Error("Missing key: %s"%s);if(e[s]===null&&n.indexOf(s)!=-1)continue;D(e[s],t[s],n)}}}function P(e){var t=e.reduce(function(e,t){return e+t}),n=t/e.length;return n}function H(e,t){e instanceof Array&&(e=e.node());while(e.parentNode!==null){e=e.parentNode;if(e.tagName===undefined)continue;if(e.tagName.toLowerCase()===t.toLowerCase())return!0}return!1}return{set_options:t,setup_svg:n,remove_child_nodes:r,load_css:i,load_files:u,load_the_file:o,make_class:a,setup_defs:f,draw_an_array:l,draw_an_object:c,make_array:h,compare_arrays:p,array_to_object:d,clone:v,extend:m,unique_concat:g,c_plus_c:y,c_minus_c:b,c_times_scalar:w,download_json:E,load_json:S,export_svg:x,rotate_coords_recursive:T,rotate_coords:N,get_angle:C,to_degrees:k,angle_for_event:L,distance:A,check_undefined:O,compartmentalize:M,decompartmentalize:_,check_r:D,mean:P,check_for_parent_tag:H}}),n("lib/complete.ly",[],function(){return function(e,t){function h(e){return l===undefined&&(l=document.createElement("span"),l.style.visibility="hidden",l.style.position="fixed",l.style.outline="0",l.style.margin="0",l.style.padding="0",l.style.border="0",l.style.left="0",l.style.whiteSpace="pre",l.style.fontSize=t.fontSize,l.style.fontFamily=t.fontFamily,l.style.fontWeight="normal",document.body.appendChild(l)),l.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),l.getBoundingClientRect().right}t=t||{},t.fontSize=t.fontSize||"16px",t.fontFamily=t.fontFamily||"sans-serif",t.promptInnerHTML=t.promptInnerHTML||"",t.color=t.color||"#333",t.hintColor=t.hintColor||"#aaa",t.backgroundColor=t.backgroundColor||"#fff",t.dropDownBorderColor=t.dropDownBorderColor||"#aaa",t.dropDownZIndex=t.dropDownZIndex||"100",t.dropDownOnHoverBackgroundColor=t.dropDownOnHoverBackgroundColor||"#ddd";var n=document.createElement("input");n.type="text",n.spellcheck=!1,n.style.fontSize=t.fontSize,n.style.fontFamily=t.fontFamily,n.style.color=t.color,n.style.backgroundColor=t.backgroundColor,n.style.width="100%",n.style.outline="0",n.style.border="0",n.style.margin="0",n.style.padding="0";var r=n.cloneNode();r.disabled="",r.style.position="absolute",r.style.top="0",r.style.left="0",r.style.borderColor="transparent",r.style.boxShadow="none",r.style.color=t.hintColor,n.style.backgroundColor="transparent",n.style.verticalAlign="top",n.style.position="relative";var i=document.createElement("div");i.style.position="relative",i.style.outline="0",i.style.border="0",i.style.margin="0",i.style.padding="0";var s=document.createElement("div");s.style.position="absolute",s.style.outline="0",s.style.margin="0",s.style.padding="0",s.style.border="0",s.style.fontSize=t.fontSize,s.style.fontFamily=t.fontFamily,s.style.color=t.color,s.style.backgroundColor=t.backgroundColor,s.style.top="0",s.style.left="0",s.style.overflow="hidden",s.innerHTML=t.promptInnerHTML,s.style.background="transparent";if(document.body===undefined)throw"document.body is undefined. The library was wired up incorrectly.";document.body.appendChild(s);var o=s.getBoundingClientRect().right;i.appendChild(s),s.style.visibility="visible",s.style.left="-"+o+"px",i.style.marginLeft=o+"px",i.appendChild(r),i.appendChild(n);var u=document.createElement("div");u.style.position="absolute",u.style.visibility="hidden",u.style.outline="0",u.style.margin="0",u.style.padding="0",u.style.textAlign="left",u.style.fontSize=t.fontSize,u.style.fontFamily=t.fontFamily,u.style.backgroundColor=t.backgroundColor,u.style.zIndex=t.dropDownZIndex,u.style.cursor="default",u.style.borderStyle="solid",u.style.borderWidth="1px",u.style.borderColor=t.dropDownBorderColor,u.style.overflowX="hidden",u.style.whiteSpace="pre",u.style.overflowY="scroll";var a=function(e){var n=[],r=0,i=-1,s=function(){this.style.outline="1px solid #ddd"},o=function(){this.style.outline="0"},u=function(){a.hide(),a.onmouseselection(this.__hint)},a={hide:function(){e.style.visibility="hidden"},refresh:function(i,f){e.style.visibility="hidden",r=0,e.innerHTML="";var l=window.innerHeight||document.documentElement.clientHeight,c=e.parentNode.getBoundingClientRect(),h=c.top-6,p=l-c.bottom-6;n=[];for(var d=0;d<f.length;d++){if(f[d].indexOf(i)!==0)continue;var v=document.createElement("div");v.style.color=t.color,v.onmouseover=s,v.onmouseout=o,v.onmousedown=u,v.__hint=f[d],v.innerHTML=i+"<b>"+f[d].substring(i.length)+"</b>",n.push(v),e.appendChild(v)}if(n.length===0)return;if(n.length===1&&i===n[0].__hint)return;if(n.length<2)return;a.highlight(0),h>p*3?(e.style.maxHeight=h+"px",e.style.top="",e.style.bottom="100%"):(e.style.top="100%",e.style.bottom="",e.style.maxHeight=p+"px"),e.style.visibility="visible"},highlight:function(e){i!=-1&&n[i]&&(n[i].style.backgroundColor=t.backgroundColor),n[e].style.backgroundColor=t.dropDownOnHoverBackgroundColor,i=e},move:function(t){return e.style.visibility==="hidden"?"":r+t===-1||r+t===n.length?n[r].__hint:(r+=t,a.highlight(r),n[r].__hint)},onmouseselection:function(){}};return a},f=a(u);f.onmouseselection=function(e){n.value=r.value=c+e,p.onChange(n.value),d=n.value,setTimeout(function(){n.focus()},0)},i.appendChild(u),e.appendChild(i);var l,c,p={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},onChange:function(){p.repaint()},startFrom:0,options:[],wrapper:i,input:n,hint:r,dropDown:u,prompt:s,setText:function(e){r.value=e,n.value=e},getText:function(){return n.value},hideDropDown:function(){f.hide()},repaint:function(){var e=n.value,t=p.startFrom,i=p.options,s=i.length,o=e.substring(t);c=e.substring(0,t),r.value="";for(var a=0;a<s;a++){var l=i[a];if(l.indexOf(o)===0){r.value=c+l;break}}u.style.left=h(c)+"px",f.refresh(o,p.options)}},d,v=function(e,t){d=e.value;var n=function(){var n=e.value;d!==n&&(d=n,t(n))};e.addEventListener?(e.addEventListener("input",n,!1),e.addEventListener("keyup",n,!1),e.addEventListener("change",n,!1)):(e.attachEvent("oninput",n),e.attachEvent("onkeyup",n),e.attachEvent("onchange",n))};v(n,function(e){p.onChange(e)});var m=function(e){e=e||window.event;var t=e.keyCode;if(t==33)return;if(t==34)return;if(t==39||t==35||t==9){t==9&&(e.preventDefault(),e.stopPropagation(),r.value.length==0&&p.onTab());if(r.value.length>0){f.hide(),n.value=r.value;var i=d!=n.value;d=n.value,i&&p.onChange(n.value)}return}if(t==13){if(r.value.length==0)p.onEnter();else{var s=u.style.visibility=="hidden";f.hide();if(s){r.value=n.value,n.focus(),p.onEnter();return}n.value=r.value;var i=d!=n.value;d=n.value,i&&p.onChange(n.value)}return}if(t==40){var o=f.move(1);o==""&&p.onArrowDown(),r.value=c+o;return}if(t==38){var o=f.move(-1);o==""&&p.onArrowUp(),r.value=c+o,e.preventDefault(),e.stopPropagation();return}r.value=""};return n.addEventListener?n.addEventListener("keydown",m,!1):n.attachEvent("onkeydown",m),p}}),n("data_styles",["utils"],function(e){function t(t,n,r){if(t===null)return null;t instanceof Array||(t=[t]);var i=function(){return t===null?null:t.length==1?null:t.length==2&&n.indexOf("Diff")!=-1?null:console.warn("Bad data style: "+r)};return i(),t=e.array_to_object(t),t}function n(e,t,n){n===undefined&&(n=!1);if(e===null)return null;var r=null;e.length==1&&(r=e[0]);if(e.length==2&&t.indexOf("Diff")!=-1){if(e[0]===null||e[1]===null)return null;r=e[1]-e[0]}return t.indexOf("Abs")!=-1&&!n&&(r=Math.abs(r)),r}function r(e,t){function o(e,t){return e===null?"(nd)":t(e)}if(e===null)return o(null);var r=n(e,t,!0);if(e.length==1){var i=d3.format(".4g");return o(r,i)}if(e.length==2&&t.indexOf("Diff")!=-1){var i=d3.format(".3g"),s=o(e[0],i);return s+=", "+o(e[1],i),s+=": "+o(r,i),s}return""}return{import_and_check:t,text_for_data:r,float_for_data:n}}),n("draw",["utils","data_styles"],function(e,t){function n(e){e.on("mousedown.drag",null),e.on("touchstart.drag",null)}function r(t){e.check_undefined(arguments,["enter_selection"]),t.append("rect").attr("class","membrane")}function i(t){e.check_undefined(arguments,["enter_selection"]),t.attr("width",function(e){return e.width}).attr("height",function(e){return e.height}).attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).style("stroke-width",function(e){return 10}).attr("rx",function(e){return 20}).attr("ry",function(e){return 20})}function s(t){e.check_undefined(arguments,["enter_selection"]);var n=t.append("g").attr("id",function(e){return"r"+e.reaction_id}).attr("class","reaction").call(u);return}function o(t,n,r,i,s,o,u,c,h,p){e.check_undefined(arguments,["update_selection","scale","drawn_nodes","show_beziers","defs","default_reaction_color","has_reaction_data","reaction_data_styles","bezier_drag_behavior","label_drag_behavior"]),t.select(".reaction-label").call(function(e){return a(e,u,c,p)});var d=t.selectAll(".segment-group").data(function(t){return e.make_array(t.segments,"segment_id")},function(e){return e.segment_id});d.enter().call(f),d.call(function(e){return l(e,n,r,i,s,o,u,c,h)}),d.exit().remove()}function u(t){e.check_undefined(arguments,["sel"]),t.append("text").attr("class","reaction-label label").style("cursor","default")}function a(t,r,i,s){e.check_undefined(arguments,["sel","has_reaction_data","reaction_data_styles","label_drag_behavior"]);var o=d3.format(".4g");t.text(function(e){var t=e.bigg_id;return r&&(t+=" "+e.data_string),t}).attr("transform",function(e){return"translate("+e.label_x+","+e.label_y+")"}).style("font-size",function(e){return String(30)+"px"}).call(n).call(s)}function f(t){e.check_undefined(arguments,["enter_selection"]);var n=t.append("g").attr("class","segment-group").attr("id",function(e){return"s"+e.segment_id});n.append("path").attr("class","segment"),n.append("g").attr("class","arrowheads"),n.append("g").attr("class","beziers")}function l(t,r,i,s,o,u,a,f,l){function d(t){e.check_undefined(arguments,["enter_selection"]),t.append("circle").attr("class",function(e){return"bezier bezier"+e.bezier}).style("stroke-width",String(1)+"px").attr("r",String(5)+"px").on("mouseover",function(e){d3.select(this).style("stroke-width",String(3)+"px")}).on("mouseout",function(e){d3.select(this).style("stroke-width",String(1)+"px")})}function m(t,r,i){e.check_undefined(arguments,["update_selection","show_beziers","drag_behavior"]),t.call(n).call(i),r?t.attr("visibility","visible").attr("transform",function(e){return e.x==null||e.y==null?"":"translate("+e.x+","+e.y+")"}):t.attr("visibility","hidden")}e.check_undefined(arguments,["update_selection","scale","drawn_nodes","show_beziers","defs","default_reaction_color","has_reaction_data","reaction_data_styles","bezier_drag_behavior"]);var c=function(e,t){return e||t>0?32:20};t.selectAll(".segment").datum(function(){return this.parentNode.__data__}).attr("d",function(e){if(e.from_node_id==null||e.to_node_id==null)return null;var t=i[e.from_node_id],n=i[e.to_node_id],r=e.b1,s=e.b2;if(t["node_type"]=="metabolite"&&r!==null){var o=c(e.reversibility,e.from_node_coefficient),u=r===null?n:r;t=v(o,t,u,"start")}if(n["node_type"]=="metabolite"){var o=c(e.reversibility,e.to_node_coefficient),u=s===null?t:s;n=v(o,u,n,"end")}var a="M"+t.x+","+t.y+" ";return r!==null&&s!==null&&(a+="C"+r.x+","+r.y+" "+s.x+","+s.y+" "),a+=n.x+","+n.y,a}).style("stroke",function(e){if(a&&f.indexOf("Color")!==-1){var t=e.data;return r.reaction_color(t===null?0:t)}return u}).style("stroke-width",function(e){if(a&&f.indexOf("Size")!==-1){var t=e.data;return r.reaction_size(t===null?0:t)}return r.reaction_size(0)});var h=t.select(".arrowheads").selectAll(".arrowhead").data(function(t){var n=[],r=this.parentNode.parentNode.parentNode.__data__.reaction_id,s=this.parentNode.parentNode.__data__.segment_id,o=i[t.from_node_id],u=t.b1;if(o.node_type=="metabolite"&&(t.reversibility||t.from_node_coefficient>0)){var a=c(t.reversibility,t.from_node_coefficient),f=u===null?h:u,l=e.to_degrees(e.get_angle([o,f]))+90;o=v(a,o,f,"start"),n.push({data:t.data,x:o.x,y:o.y,rotation:l})}var h=i[t.to_node_id],p=t.b2;if(h.node_type=="metabolite"&&(t.reversibility||t.to_node_coefficient>0)){var a=c(t.reversibility,t.to_node_coefficient),f=p===null?o:p,l=e.to_degrees(e.get_angle([h,f]))+90;h=v(a,f,h,"end"),n.push({data:t.data,x:h.x,y:h.y,rotation:l})}return n});h.enter().append("path").classed("arrowhead",!0),h.attr("d",function(e){var t=20,n=13;if(a&&f.indexOf("Size")!==-1){var i=e.data;t+=r.reaction_size(i)-r.reaction_size(0)}return"M"+[-t/2,0]+" L"+[0,n]+" L"+[t/2,0]+" Z"}).attr("transform",function(e){return"translate("+e.x+","+e.y+")rotate("+e.rotation+")"}).attr("fill",function(e){var t;if(a&&f.indexOf("Color")!==-1){var n=e.data;t=r.reaction_color(n===null?0:n)}else t=u;return t}),h.exit().remove();var p=t.select(".beziers").selectAll(".bezier").data(function(e){var t=[],n=this.parentNode.parentNode.parentNode.__data__.reaction_id,r=this.parentNode.parentNode.__data__.segment_id;return e.b1!=null&&e.b1.x!=null&&e.b1.y!=null&&t.push({bezier:1,x:e.b1.x,y:e.b1.y,reaction_id:n,segment_id:r}),e.b2!=null&&e.b2.x!=null&&e.b2.y!=null&&t.push({bezier:2,x:e.b2.x,y:e.b2.y,reaction_id:n,segment_id:r}),t},function(e){return e.bezier});p.enter().call(function(e){return d(e)}),p.call(function(e){return m(e,s,l)}),p.exit().remove()}function c(t,n,r){e.check_undefined(arguments,["enter_selection","drawn_nodes","drawn_reactions"]);var i=t.append("g").attr("class","node").attr("id",function(e){return"n"+e.node_id});i.append("circle").attr("class",function(e){return e.node_type=="metabolite"?"node-circle metabolite-circle":"node-circle"}),i.filter(function(e){return e.node_type=="metabolite"}).append("text").attr("class","node-label label").style("cursor","default")}function h(t,r,i,s,o,u,a,f,l){e.check_undefined(arguments,["update_selection","scale","has_metabolite_data","metabolite_data_styles","click_fn","mouseover_fn","mouseout_fn","drag_behavior","label_drag_behavior"]);var c=t.select(".node-circle").attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).attr("r",function(e){if(e.node_type=="metabolite"){if(i&&s.indexOf("Size")!==-1){var t=e.data;return r.metabolite_size(t===null?0:t)}return e.node_is_primary?15:10}return 5}).style("fill",function(e){if(e.node_type=="metabolite"){if(i&&s.indexOf("Color")!==-1){var t=e.data;return r.metabolite_color(t===null?0:t)}return"rgb(224, 134, 91)"}return null}).call(n).call(f).on("click",o).on("mouseover",u).on("mouseout",a);t.select(".node-label").attr("transform",function(e){return"translate("+e.label_x+","+e.label_y+")"}).style("font-size",function(e){return String(20)+"px"}).text(function(e){var t=e.bigg_id;return i&&(t+=" "+e.data_string),t}).call(n).call(l)}function p(t){e.check_undefined(arguments,["enter_selection"]),t.append("text").attr("class","text-label label").style("cursor","default").text(function(e){return e.text})}function d(t,r,i){e.check_undefined(arguments,["update_selection","label_click","label_drag_behavior"]),t.attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).on("click",r).call(n).call(i)}function v(t,n,r,i){e.check_undefined(arguments,["reaction_arrow_displacement","start","end","displace"]);var s=t,o=e.distance(n,r),u,a;return(!s||!o)&&console.error("Bad value"),i=="start"?(u=n.x+s*(r.x-n.x)/o,a=n.y+s*(r.y-n.y)/o):i=="end"?(u=r.x-s*(r.x-n.x)/o,a=r.y-s*(r.y-n.y)/o):console.error("bad displace value: "+i),{x:u,y:a}}return{create_reaction:s,update_reaction:o,create_node:c,update_node:h,create_text_label:p,update_text_label:d,create_membrane:r,update_membrane:i}}),n("build",["utils"],function(e){function t(t,r,i,o,u,a,f,l){l=Math.PI/180*l;var c=String(++a.reactions),h={x:u.x,y:u.y},p=300,d=[h,e.c_plus_c(h,{x:p,y:0})],v={x:(d[0].x+d[1].x)/2,y:(d[0].y+d[1].y)/2},m;Math.abs(l)<Math.PI/4||Math.abs(l-Math.PI)<Math.PI/4?m={x:-50,y:-40}:m={x:30,y:10};var g=20,y={bigg_id:t,reversibility:r.reversibility,metabolites:e.clone(r.metabolites),label_x:v.x+m.x,label_y:v.y+m.y,name:r.name,segments:{}},b=[],w=[],E=0,S=0,x=!1;for(var T in y.metabolites){var N=i[T],C=y.metabolites[T],k=N.formula,L={coefficient:C,bigg_id:T,name:N.name};if(C<0){L.index=E;var A=/C([0-9]+)/.exec(k);u.bigg_id==L.bigg_id?b.push([L.index,Infinity]):A&&f.indexOf(e.decompartmentalize(L.bigg_id)[0])==-1&&b.push([L.index,parseInt(A[1])]),E++}else{L.index=S;var A=/C([0-9]+)/.exec(k);u.bigg_id==L.bigg_id?(w.push([L.index,Infinity]),x=!0):A&&f.indexOf(e.decompartmentalize(L.bigg_id)[0])==-1&&w.push([L.index,parseInt(A[1])]),S++}y.metabolites[T]=L}var O=function(e,t){return t[1]>e[1]?t:e},M=b.reduce(O,[0,0])[0],_=w.reduce(O,[0,0])[0];for(var T in y.metabolites){var N=y.metabolites[T];N.coefficient<0?(N.index==M&&(N.is_primary=!0),N.count=E+1):(N.index==_&&(N.is_primary=!0),N.count=S+1)}var D={},P=[{node_type:"anchor_reactants",dis:{x:g*(x?1:-1),y:0}},{node_type:"center",dis:{x:0,y:0}},{node_type:"anchor_products",dis:{x:g*(x?-1:1),y:0}}],H={};P.map(function(e){var t=String(++a.nodes),n=e.node_type=="center"?"midmarker":"multimarker";D[t]={node_type:n,x:v.x+e.dis.x,y:v.y+e.dis.y,connected_segments:[],name:null,bigg_id:null,label_x:null,label_y:null,node_is_primary:null},H[e.node_type]=t});var B=[[H.anchor_reactants,H.center],[H.anchor_products,H.center]];B.map(function(e){var t=e[0],n=e[1],r=String(++a.segments);y.segments[r]={b1:null,b2:null,from_node_id:t,to_node_id:n,from_node_coefficient:null,to_node_coefficient:null,reversibility:y.reversibility},D[t].connected_segments.push({segment_id:r,reaction_id:c}),D[n].connected_segments.push({segment_id:r,reaction_id:c})});var j=D;for(var T in y.metabolites){var N=y.metabolites[T],F,I;N.coefficient<0?(F=M,I=H.anchor_reactants):(F=_,I=H.anchor_products);var q=s(N,F,d,v,p,x);if(u.bigg_id==N.bigg_id){var R=String(++a.segments);y.segments[R]={b1:q.b1,b2:q.b2,from_node_id:I,to_node_id:o,from_node_coefficient:null,to_node_coefficient:N.coefficient,reversibility:y.reversibility},u.connected_segments.push({segment_id:R,reaction_id:c}),j[I].connected_segments.push({segment_id:R,reaction_id:c})}else{var R=String(++a.segments),U=String(++a.nodes);y.segments[R]={b1:q.b1,b2:q.b2,from_node_id:I,to_node_id:U,from_node_coefficient:null,to_node_coefficient:N.coefficient,reversibility:y.reversibility},j[U]={connected_segments:[{segment_id:R,reaction_id:c}],x:q.circle.x,y:q.circle.y,node_is_primary:Boolean(N.is_primary),label_x:q.circle.x+m.x,label_y:q.circle.y+m.y,name:N.name,bigg_id:N.bigg_id,node_type:"metabolite"},j[I].connected_segments.push({segment_id:R,reaction_id:c})}}for(var t in y.metabolites)y.metabolites[t]={coefficient:y.metabolites[t].coefficient};var z={};z[c]=y,j[o]=u;var W=n(j,z,l,h);return{new_reactions:z,new_nodes:j}}function n(t,n,r,s){var o=function(t){return t===null?null:e.rotate_coords(t,r,s)},u=[],a=[];for(var f in t){var l=t[f],c=o({x:l.x,y:l.y}),h=i(l,n,c);l.connected_segments.map(function(t){var r=n[t.reaction_id];if(r===undefined)return;var i=r.segments[t.segment_id];if(i.to_node_id==f&&i.b2){var s=o(i.b2);i.b2=e.c_plus_c(i.b2,s)}else if(i.from_node_id==f&&i.b1){var s=o(i.b1);i.b1=e.c_plus_c(i.b1,s)}}),a=e.unique_concat([a,h.reaction_ids]),u.push(f)}return{node_ids:u,reaction_ids:a}}function r(t,n,r,s){var o=i(t,r,s);return t.connected_segments.map(function(t){var i=r[t.reaction_id];if(i===undefined)return;var u=i.segments[t.segment_id];u.from_node_id==n&&u.b1&&(u.b1=e.c_plus_c(u.b1,s)),u.to_node_id==n&&u.b2&&(u.b2=e.c_plus_c(u.b2,s)),o.reaction_ids.indexOf(t.reaction_id)<0&&o.reaction_ids.push(t.reaction_id)}),o}function i(e,t,n){e.x=e.x+n.x,e.y=e.y+n.y,e.label_x=e.label_x+n.x,e.label_y=e.label_y+n.y;var r=[];return e.connected_segments.map(function(i){var s=t[i.reaction_id];r.indexOf(i.reaction_id)<0&&(r.push(i.reaction_id),e.node_type=="midmarker"&&(s.label_x=s.label_x+n.x,s.label_y=s.label_y+n.y))}),{reaction_ids:r}}function s(t,n,r,i,s,o){var u=r[0],r=[e.c_minus_c(r[0],u),e.c_minus_c(r[1],u)],i=e.c_minus_c(i,u),a=80,f=.4,l=.25,c=a*.7,h=40,p=Math.min(2,t.count-1),d,v,m;t.is_primary?d=20:(d=10,t.index>n?v=t.index-1:v=t.index);var g=s-d,y=[{x:d,y:0},{x:g,y:0}],b,w,E,S;t.coefficient<0!=o&&t.is_primary?(b={x:y[0].x,y:y[0].y},E={x:i.x*(1-f)+y[0].x*f,y:i.y*(1-f)+y[0].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[0].x,y:r[0].y}):t.coefficient<0!=o?(b={x:y[0].x+h,y:y[0].y+(c*v-c*(p-1)/2)},E={x:i.x*(1-f)+y[0].x*f,y:i.y*(1-f)+y[0].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[0].x+h,y:r[0].y+(a*v-a*(p-1)/2)}):t.coefficient>0!=o&&t.is_primary?(b={x:y[1].x,y:y[1].y},E={x:i.x*(1-f)+y[1].x*f,y:i.y*(1-f)+y[1].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[1].x,y:r[1].y}):t.coefficient>0!=o&&(b={x:y[1].x-h,y:y[1].y+(c*v-c*(p-1)/2)},E={x:i.x*(1-f)+y[1].x*f,y:i.y*(1-f)+y[1].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[1].x-h,y:r[1].y+(a*v-a*(p-1)/2)});var x={};return x.b1=e.c_plus_c(u,E),x.b2=e.c_plus_c(u,S),x.circle=e.c_plus_c(u,w),x}return{new_reaction:t,rotate_nodes:n,move_node_and_dependents:r}}),n("Behavior",["utils","build"],function(e,t){function r(e,t){this.map=e,this.undo_stack=t,this.empty_behavior=function(){},this.rotation_mode_enabled=!1,this.rotation_drag=d3.behavior.drag(),this.node_click=null,this.node_mouseover=null,this.node_mouseout=null,this.node_drag=this.empty_behavior,this.bezier_drag=this.empty_behavior,this.reaction_label_drag=this.empty_behavior,this.node_label_drag=this.empty_behavior,this.text_label_click=null,this.text_label_drag=this.empty_behavior,this.turn_everything_on()}function i(){this.toggle_node_click(!0),this.toggle_node_drag(!0),this.toggle_text_label_click(!0),this.toggle_label_drag(!0)}function s(){this.toggle_node_click(!1),this.toggle_node_drag(!1),this.toggle_text_label_click(!1),this.toggle_label_drag(!1)}function o(n){function v(){var e=this.map.sel.selectAll("#rotation-center").data([0]),t=e.enter().append("g").attr("id","rotation-center");t.append("path").attr("d","M-22 0 L22 0").attr("class","rotation-center-line"),t.append("path").attr("d","M0 -22 L0 22").attr("class","rotation-center-line"),e.attr("transform","translate("+this.center.x+","+this.center.y+")").attr("visibility","visible"),e.call(d3.behavior.drag().on("drag",function(e){var t=d3.transform(e.attr("transform")),n=[d3.event.dx+t.translate[0],d3.event.dy+t.translate[1]];e.attr("transform","translate("+n+")"),this.center={x:n[0],y:n[1]}}.bind(this,e))),e.on("mouseover",function(){var e=parseFloat(this.selectAll("path").style("stroke-width"));this.selectAll("path").style("stroke-width",e*2+"px")}.bind(e)),e.on("mouseout",function(){this.selectAll("path").style("stroke-width",null)}.bind(e))}function m(e){this.map.sel.select("#rotation-center").attr("visibility","hidden")}function g(t){var n=[],r=[];for(var i in t){var s=t[i];s.x!==undefined&&n.push(s.x),s.y!==undefined&&r.push(s.y)}return{x:e.mean(n),y:e.mean(r)}}n===undefined?this.rotation_mode_enabled=!this.rotation_mode_enabled:this.rotation_mode_enabled=n;var r=this.map.sel.selectAll(".node-circle"),i=this.map.sel.selectAll("#canvas");if(this.rotation_mode_enabled){this.map.callback_manager.run("start_rotation");var s=this.map.get_selected_nodes();if(Object.keys(s).length==0){console.log("No selected nodes");return}this.center=g(s),v.call(this);var o=this.map,u=Object.keys(s),a=this.map.reactions,f=this.map.nodes,l=function(e){d3.event.sourceEvent.stopPropagation()},c=function(n,r,i,u){var f=e.angle_for_event(r,u,this.center),l=t.rotate_nodes(s,a,f,this.center);o.draw_these_nodes(l.node_ids),o.draw_these_reactions(l.reaction_ids)}.bind(this),h=function(e){},p=function(n,r,i){var s=e.angle_for_event(r,i,this.center),o={};u.forEach(function(e){o[e]=f[e]});var l=t.rotate_nodes(o,a,-s,e.clone(this.center));self.draw_these_nodes(l.node_ids),self.draw_these_reactions(l.reaction_ids)}.bind(this),d=function(n,r,i){var s=e.angle_for_event(r,i,this.center),o={};u.forEach(function(e){o[e]=f[e]});var l=t.rotate_nodes(o,a,s,e.clone(this.center));self.draw_these_nodes(l.node_ids),self.draw_these_reactions(l.reaction_ids)}.bind(this);this.rotation_drag=this.get_generic_drag(l,c,h,p,d,this.map.sel),i.call(this.rotation_drag)}else m.call(this),r.on("mousedown.center",null),i.on("mousedown.center",null),i.on("mousedown.drag",null),i.on("touchstart.drag",null),this.rotation_drag=null}function u(e){e===undefined&&(e=this.node_click==null);if(e){var t=this.map;this.node_click=function(e){t.select_metabolite(this,e),d3.event.stopPropagation()},this.node_mouseover=function(e){d3.select(this).style("stroke-width",null);var t=parseFloat(d3.select(this).style("stroke-width"));d3.select(this).style("stroke-width",t*2+"px")},this.node_mouseout=function(e){d3.select(this).style("stroke-width",null)}}else this.node_click=null,this.node_mouseover=null,this.node_mouseout=null,this.map.sel.select("#nodes").selectAll(".node-circle").style("stroke-width",null)}function a(e){e===undefined&&(e=this.text_label_click==null);if(e){var t=this.map;this.text_label_click=function(e){t.select_text_label(this,e),d3.event.stopPropagation()}}else this.text_label_click=null}function f(e){e===undefined&&(e=this.node_drag===this.empty_behavior),e?(this.node_drag=this.get_node_drag(this.map,this.undo_stack),this.bezier_drag=this.get_bezier_drag(this.map,this.undo_stack)):this.node_drag=this.empty_behavior}function l(e){e===undefined&&(e=this.label_drag===this.empty_behavior),e?(this.reaction_label_drag=this.get_reaction_label_drag(this.map),this.node_label_drag=this.get_node_label_drag(this.map),this.text_label_drag=this.get_text_label_drag(this.map)):(this.reaction_label_drag=this.empty_behavior,this.node_label_drag=this.empty_behavior,this.text_label_drag=this.empty_behavior)}function c(n,r){function f(t,r){var i=n.nodes[r],s=n.nodes[t],o=[];return i.connected_segments.forEach(function(i){var u=n.reactions[i.reaction_id].segments[i.segment_id];if(u.from_node_id==r)u.from_node_id=t;else{if(u.to_node_id!=r)return console.error("Segment does not connect to dragged node");u.to_node_id=t}return s.connected_segments.push(i),o.push(e.clone(i)),null}),n.delete_node_data([r]),n.sel.selectAll(".node-to-combine").classed("node-to-combine",!1),n.draw_everything(),o}var i=d3.behavior.drag(),s=null,o=null,u=null,a=null;return i.on("dragstart",function(){var e=this.parentNode.__data__,t=e.bigg_id,r=this.parentNode;d3.event.sourceEvent.stopPropagation(),s={},a=window.setTimeout(function(){r.parentNode.insertBefore(r,r.parentNode.firstChild)},200),n.sel.selectAll(".metabolite-circle").on("mouseover.combine",function(n){n.bigg_id==t&&n.node_id!=e.node_id&&d3.select(this).style("stroke-width",String(12)+"px").classed("node-to-combine",!0)}).on("mouseout.combine",function(e){e.bigg_id==t&&n.sel.selectAll(".node-to-combine").style("stroke-width",String(2)+"px").classed("node-to-combine",!1)})}),i.on("drag",function(){var r=this.parentNode.__data__.node_id,i=n.get_selected_node_ids();o=[],i.indexOf(r)==-1?o.push(r):o=i,u=[],o.forEach(function(r){var i=n.nodes[r],o={x:d3.event.dx,y:d3.event.dy},a=t.move_node_and_dependents(i,r,n.reactions,o);u=e.unique_concat([u,a.reaction_ids]),r in s||(s[r]={x:0,y:0}),s[r]=e.c_plus_c(s[r],o)}),n.draw_these_nodes(o),n.draw_these_reactions(u)}),i.on("dragend",function(){if(o===null){s=null,o=null,u=null,a=null;return}var i=[];n.sel.selectAll(".node-to-combine").each(function(e){i.push(e.node_id)});if(i.length==1){var l=i[0],c=this.parentNode.__data__.node_id,h=e.clone(n.nodes[c]),p=f(l,c);r.push(function(){n.nodes[c]=h;var e=n.nodes[l],t=[];p.forEach(function(r){var i=n.reactions[r.reaction_id].segments[r.segment_id];i.from_node_id==l?i.from_node_id=c:i.to_node_id==l?i.to_node_id=c:console.error("Segment does not connect to fixed node"),e.connected_segments=e.connected_segments.filter(function(e){return e.reaction_id!=r.reaction_id||e.segment_id!=r.segment_id}),t.indexOf(r.reaction_id)==-1&&t.push(r.reaction_id)}),n.draw_these_nodes([c]),n.draw_these_reactions(t)},function(){f(l,c)})}else{var d=e.clone(s),v=e.clone(o),m=e.clone(u);r.push(function(){v.forEach(function(r){var i=n.nodes[r];t.move_node_and_dependents(i,r,n.reactions,e.c_times_scalar(d[r],-1))}),n.draw_these_nodes(v),n.draw_these_reactions(m)},function(){v.forEach(function(e){var r=n.nodes[e];t.move_node_and_dependents(r,e,n.reactions,d[e])}),n.draw_these_nodes(v),n.draw_these_reactions(m)})}n.sel.selectAll(".metabolite-circle").on("mouseover.combine",null).on("mouseout.combine",null),window.clearTimeout(a),s=null,o=null,u=null,a=null}),i}function h(t){var n=function(n,r,i,s){var o=t.reactions[n].segments[r];o["b"+i]=e.c_plus_c(o["b"+i],s)},r=function(e){},i=function(e,r,i){n(e.reaction_id,e.segment_id,e.bezier,r),t.draw_these_reactions([e.reaction_id])},s=function(e){},o=function(r,i){n(r.reaction_id,r.segment_id,r.bezier,e.c_times_scalar(i,-1)),t.draw_these_reactions([r.reaction_id])},u=function(e,r){n(e.reaction_id,e.segment_id,e.bezier,r),t.draw_these_reactions([e.reaction_id])};return this.get_generic_drag(r,i,s,o,u,this.map.sel)}function p(t){var n=function(e,n){var r=t.reactions[e];r.label_x=r.label_x+n.x,r.label_y=r.label_y+n.y},r=function(e){},i=function(e,r,i){n(e.reaction_id,r),t.draw_these_reactions([e.reaction_id])},s=function(e){},o=function(r,i){n(r.reaction_id,e.c_times_scalar(i,-1)),t.draw_these_reactions([r.reaction_id])},u=function(e,r){n(e.reaction_id,r),t.draw_these_reactions([e.reaction_id])};return this.get_generic_drag(r,i,s,o,u,this.map.sel)}function d(t){var n=function(e,n){var r=t.nodes[e];r.label_x=r.label_x+n.x,r.label_y=r.label_y+n.y},r=function(e){},i=function(e,r,i){n(e.node_id,r),t.draw_these_nodes([e.node_id])},s=function(e){},o=function(r,i){n(r.node_id,e.c_times_scalar(i,-1)),t.draw_these_nodes([r.node_id])},u=function(e,r){n(e.node_id,r),t.draw_these_nodes([e.node_id])};return this.get_generic_drag(r,i,s,o,u,this.map.sel)}function v(t){var n=function(e,n){var r=t.text_labels[e];r.x=r.x+n.x,r.y=r.y+n.y},r=function(e){},i=function(e,r,i){n(e.text_label_id,r),t.draw_these_text_labels([e.text_label_id])},s=function(e){},o=function(r,i){n(r.text_label_id,e.c_times_scalar(i,-1)),t.draw_these_text_labels([r.text_label_id])},u=function(e,r){n(e.text_label_id,r),t.draw_these_text_labels([e.text_label_id])};return this.get_generic_drag(r,i,s,o,u,this.map.sel)}function m(t,n,r,i,s,o){var u=d3.behavior.drag(),a,f=this.undo_stack,l=o.node();return u.on("dragstart",function(e){d3.event.sourceEvent.stopPropagation(),a={x:0,y:0},t(e)}),u.on("drag",function(t){var r={x:d3.event.dx,y:d3.event.dy},i={x:d3.mouse(l)[0],y:d3.mouse(l)[1]};a=e.c_plus_c(a,r),n(t,r,a,i)}),u.on("dragend",function(t){var n=e.clone(t),o=e.clone(a),u={x:d3.mouse(l)[0],y:d3.mouse(l)[1]};f.push(function(){i(n,o,u)},function(){s(n,o,u)}),r(t)}),u}var n=e.make_class();return n.prototype={init:r,toggle_rotation_mode:o,turn_everything_on:i,turn_everything_off:s,toggle_node_click:u,toggle_node_drag:f,toggle_text_label_click:a,toggle_label_drag:l,get_node_drag:c,get_bezier_drag:h,get_reaction_label_drag:p,get_node_label_drag:d,get_text_label_drag:v,get_generic_drag:m},n}),n("Scale",["utils"],function(e){function n(t){var n=e.set_options(t,{reaction_color:d3.scale.linear().domain([0,1e-6,1,8,50]).range(["rgb(200,200,200)","rgb(190,190,255)","rgb(100,100,255)","blue","red"])});n.x=d3.scale.linear(),n.y=d3.scale.linear(),n.x_size=d3.scale.linear(),n.y_size=d3.scale.linear(),n.size=d3.scale.linear(),n.reaction_size=d3.scale.linear().domain([0,40]).range([6,12]),n.metabolite_size=d3.scale.linear().range([8,15]),n.metabolite_color=d3.scale.linear().range(["white","red"]),n.scale_path=function(e){var t=n.x,r=n.y,i=d3.format(".2f"),e=e.replace(/(M|L)([0-9-.]+),?\s*([0-9-.]+)/g,function(e,n,s,o){return n+[i(t(parseFloat(s))),i(r(parseFloat(o)))].join(", ")}),s=/C([0-9-.]+),?\s*([0-9-.]+)\s*([0-9-.]+),?\s*([0-9-.]+)\s*([0-9-.]+),?\s*([0-9-.]+)/g;return e=e.replace(s,function(e,n,s,o,u,a,f){return"C"+i(t(parseFloat(n)))+","+i(r(parseFloat(s)))+" "+i(t(parseFloat(o)))+","+i(r(parseFloat(u)))+" "+[i(t(parseFloat(a)))+","+i(r(parseFloat(f)))]}),e},n.scale_decimals=function(e,t,n){var r=d3.format("."+String(n)+"f");return e=e.replace(/([0-9.]+)/g,function(e,n){return r(t(parseFloat(n)))}),e};var r=window.Object.keys(n),i=-1;while(++i<r.length)this[r[i]]=n[r[i]]}var t=e.make_class();return t.prototype={init:n},t}),n("UndoStack",["utils"],function(e){function n(){var e=40;this.stack=Array(e),this.current=-1,this.oldest=-1,this.newest=-1,this.end_of_stack=!0,this.top_of_stack=!0}function r(e,t){this.current=o(this.current,this.stack.length),this.end_of_stack?this.oldest=this.current:this.oldest==this.current&&(this.oldest=o(this.oldest,this.stack.length)),this.stack[this.current]={undo:e,redo:t},this.newest=this.current,this.top_of_stack=!0,this.end_of_stack=!1}function i(){if(this.end_of_stack)return console.warn("End of stack.");this.stack[this.current].undo(),this.current==this.oldest?this.end_of_stack=!0:this.current=u(this.current,this.stack.length),this.top_of_stack=!1}function s(){if(this.top_of_stack)return console.warn("Top of stack.");this.end_of_stack||(this.current=o(this.current,this.stack.length)),this.stack[this.current].redo(),this.current==this.newest&&(this.top_of_stack=!0),this.end_of_stack=!1}function o(e,t){return e+1>t-1?0:e+1}function u(e,t){return e-1<0?t-1:e-1}var t=e.make_class();return t.prototype={init:n,push:r,undo:i,redo:s},t}),n("CallbackManager",["utils"],function(e){function n(){}function r(e,t){return this.callbacks===undefined&&(this.callbacks={}),this.callbacks[e]===undefined&&(this.callbacks[e]=[]),this.callbacks[e].push(t),this}function i(e){return(this.callbacks===undefined||Object.keys(this.callbacks).length==0)&&console.warn("No callbacks to remove"),delete this.callbacks[e],this}function s(e){if(this.callbacks===undefined)return this;var t=Array.prototype.slice.call(arguments,1);for(var n in this.callbacks){var r=n.split(".")[0];r==e&&this.callbacks[n].forEach(function(e){e.apply(null,t)})}return this}var t=e.make_class();return t.prototype={init:n,set:r,remove:i,run:s},t}),n("KeyManager",["utils"],function(e){function n(e){e.command=!1,e.control=!1,e.option=!1,e.shift=!1}function r(e,t,r,i){e===undefined?this.assigned_keys={}:this.assigned_keys=e,t===undefined?this.reaction_input=null:this.reaction_input=t,r===undefined?this.search_bar=null:this.search_bar=r,i===undefined&&(i=!0),this.ctrl_equals_cmd=i,this.held_keys={},n(this.held_keys),this.enabled=!0,this.update()}function i(){function o(e,t,n,r){for(var i in e)e[i]==n&&(t[i]=r)}function u(t,n,r,i){if(t.key!=n)return!1;var s=e.clone(t.modifiers);s===undefined&&(s={control:!1,command:!1,option:!1,shift:!1});for(var o in r){if(i&&s.control&&(o=="command"||o=="command_right"||o=="control")&&(r.command||r.command_right||r.control))continue;s[o]===undefined&&(s[o]=!1);if(s[o]!=r[o])return!1}return!0}var t=this.held_keys,r=this.assigned_keys,i=this,s={command:91,command_right:93,control:17,option:18,shift:16};d3.select(window).on("keydown.key_manager",null),d3.select(window).on("keyup.key_manager",null);if(!this.enabled)return;d3.select(window).on("keydown.key_manager",function(e,i,a){var f=d3.event.keyCode,l=(i?i.is_visible():!1)||(a?a.is_visible():!1),c=!0;o(s,t,f,!0);for(var h in r){var p=r[h];if(u(p,f,t,e)){c=!1;if(!p.ignore_with_input||!l)p.fn?p.fn.call(p.target):console.warn("No function for key"),d3.event.preventDefault()}}for(var d in s)s[d]==f&&(c=!1);c&&n(t)}.bind(null,this.ctrl_equals_cmd,this.reaction_input,this.search_bar)).on("keyup.key_manager",function(){o(s,t,d3.event.keyCode,!1)})}function s(e){e===undefined&&(e=!this.enabled),this.enabled=e,this.update()}function o(e){this.add_key_listener(e,13)}function u(e){this.add_key_listener(e,27)}function a(e,t){var n=d3.select(window);return n.on("keydown."+t,function(){d3.event.keyCode==t&&e()}),{clear:function(){n.on("keydown."+t,null)}}}var t=e.make_class();return t.reset_held_keys=n,t.prototype={init:r,update:i,toggle:s,add_escape_listener:u,add_enter_listener:o,add_key_listener:a},t}),n("Canvas",["utils","CallbackManager"],function(e,t){function r(e,n){this.selection=e,this.x=n.x,this.y=n.y,this.width=n.width,this.height=n.height,this.resize_enabled=!0,this.callback_manager=new t,this.setup()}function i(e){e===undefined&&(e=!this.resize_enabled),e?this.selection.selectAll(".drag-rect").style("pointer-events","auto"):this.selection.selectAll(".drag-rect").style("pointer-events","none")}function s(){function v(){d3.event.sourceEvent.stopPropagation()}function m(e,t,n){var r=d3.transform(n),i=r.translate;return e!==null&&(i[0]=e),t!==null&&(i[1]=t),"translate("+i+")"}function g(t){var i=t.x;t.x=Math.min(t.x+e.width-n/2,d3.event.x),e.x=t.x,e.width=e.width+(i-t.x),c.attr("transform",function(e){return m(e.x-n/2,null,c.attr("transform"))}),s.attr("transform",function(e){return m(e.x,null,s.attr("transform"))}).attr("width",e.width*r),o.attr("transform",function(e){return m(e.x,null,o.attr("transform"))}).attr("width",e.width),p.attr("transform",function(e){return m(e.x+n/2,null,p.attr("transform"))}).attr("width",e.width-n),d.attr("transform",function(e){return m(e.x+n/2,null,d.attr("transform"))}).attr("width",e.width-n),e.callback_manager.run("resize")}function y(t){d3.event.sourceEvent.stopPropagation();var i=Math.max(t.x+n/2,t.x+e.width+d3.event.dx);e.width=i-t.x,h.attr("transform",function(e){return m(i-n/2,null,h.attr("transform"))}),s.attr("width",e.width*r),o.attr("width",e.width),p.attr("width",e.width-n),d.attr("width",e.width-n),e.callback_manager.run("resize")}function b(t){d3.event.sourceEvent.stopPropagation();var i=t.y;t.y=Math.min(t.y+e.height-n/2,d3.event.y),e.y=t.y,e.height=e.height+(i-t.y),p.attr("transform",function(e){return m(null,e.y-n/2,p.attr("transform"))}),s.attr("transform",function(e){return m(null,e.y,s.attr("transform"))}).attr("width",e.height*r),o.attr("transform",function(e){return m(null,e.y,o.attr("transform"))}).attr("height",e.height),c.attr("transform",function(e){return m(null,e.y+n/2,c.attr("transform"))}).attr("height",e.height-n),h.attr("transform",function(e){return m(null,e.y+n/2,h.attr("transform"))}).attr("height",e.height-n),e.callback_manager.run("resize")}function w(t){d3.event.sourceEvent.stopPropagation();var i=Math.max(t.y+n/2,t.y+e.height+d3.event.dy);e.height=i-t.y,d.attr("transform",function(e){return m(null,i-n/2,d.attr("transform"))}),s.attr("height",e.height*r),o.attr("height",e.height),c.attr("height",e.height-n),h.attr("height",e.height-n),e.callback_manager.run("resize")}var e=this,t={x:this.width,y:this.height},n=20,r=10,i=this.selection.append("g").classed("canvas-group",!0).data([{x:this.x,y:this.y}]),s=i.append("rect").attr("id","mouse-node").attr("width",this.width*r).attr("height",this.height*r).attr("transform","translate("+[e.x-this.width*r/2,e.y-this.height*r/2]+")").attr("pointer-events","all");this.mouse_node=s;var o=i.append("rect").attr("id","canvas").attr("width",this.width).attr("height",this.height).attr("transform","translate("+[e.x,e.y]+")"),u=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",y),a=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",g),f=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",b),l=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",w),c=i.append("rect").classed("drag-rect",!0).attr("transform",function(e){return"translate("+[e.x-n/2,e.y+n/2]+")"}).attr("height",this.height-n).attr("id","dragleft").attr("width",n).attr("cursor","ew-resize").classed("resize-rect",!0).call(a),h=i.append("rect").classed("drag-rect",!0).attr("transform",function(t){return"translate("+[t.x+e.width-n/2,t.y+n/2]+")"}).attr("id","dragright").attr("height",this.height-n).attr("width",n).attr("cursor","ew-resize").classed("resize-rect",!0).call(u),p=i.append("rect").classed("drag-rect",!0).attr("transform",function(e){return"translate("+[e.x+n/2,e.y-n/2]+")"}).attr("height",n).attr("id","dragtop").attr("width",this.width-n).attr("cursor","ns-resize").classed("resize-rect",!0).call(f),d=i.append("rect").classed("drag-rect",!0).attr("transform",function(t){return"translate("+[t.x+n/2,t.y+e.height-n/2]+")"}).attr("id","dragbottom").attr("height",n).attr("width",this.width-n).attr("cursor","ns-resize").classed("resize-rect",!0).call(l)}function o(){return{x:this.x,y:this.y,width:this.width,height:this.height}}var n=e.make_class();return n.prototype={init:r,toggle_resize:i,setup:s,size_and_location:o},n}),n("SearchIndex",["utils"],function(e){function n(){this.index={}}function r(e,t,n,r){if(!n&&e in this.index)throw new Error("id is already in the index");if(!(!r||"name"in t&&"data"in t))throw new Error("malformed record");this.index[e]=t}function i(e){return e in this.index?(delete this.index[e],!0):!1}function s(e){var t=RegExp(e,"i"),n=[];for(var r in this.index){var i=this.index[r];t.exec(i.name)&&n.push(i.data)}return n}var t=e.make_class();return t.prototype={init:n,insert:r,remove:i,find:s},t}),n("Map",["utils","draw","Behavior","Scale","build","UndoStack","CallbackManager","KeyManager","Canvas","data_styles","SearchIndex"],function(e,t,n,r,i,s,o,u,a,f,l){function h(t,i,c,h,p,d,v,m,g,y,b){if(y===null){var w=h.get_size();y={x:-w.width,y:-w.height,width:w.width*3,height:w.height*3}}this.default_reaction_color="#334E75",this.svg=t,this.defs=e.setup_defs(t,i),this.canvas=new a(c,y),this.setup_containers(c),this.sel=c,this.zoom_container=h,this.reaction_data_object=f.import_and_check(p,d,"reaction_data"),this.reaction_data_styles=d,this.metabolite_data_object=f.import_and_check(v,m,"metabolite_data"),this.metabolite_data_styles=m,this.set_model(g),this.largest_ids={reactions:-1,nodes:-1,segments:-1},this.scale=new r,this.undo_stack=new s,this.behavior=new n(this,this.undo_stack),this.key_manager=new u,this.enable_search=b,this.search_index=new l;var E={x:0,y:0},S=1;this.beziers_enabled=!1,this.callback_manager=new o,this.nodes={},this.reactions={},this.membranes=[],this.text_labels={},this.info={},this.rotation_on=!1,this.debug=!1}function p(t,n,r,i,s,o,u,a,f,l,h){function L(e,t){return t===undefined&&(t=0),e===undefined?t:Math.max.apply(null,Object.keys(e).map(function(e){return parseInt(e)}).concat([t]))}e.check_undefined(arguments,["map_data","svg","css","selection","zoom_container","reaction_data","reaction_data_styles","metabolite_data","metabolite_data_styles","cobra_model","enable_search"]),this.debug&&d3.json("map_spec.json",function(n,r){if(n){console.warn(n);return}e.check_r(t,r.spec,r.can_be_none)});var p=t.canvas,d=new c(n,r,i,s,o,u,a,f,l,p,h);d.reactions=t.reactions,d.nodes=t.nodes,d.membranes=t.membranes,d.text_labels=t.text_labels,d.info=t.info;for(var v in d.reactions){var m=d.reactions[v];h&&d.search_index.insert("r"+v,{name:m.bigg_id,data:{type:"reaction",reaction_id:v}});for(var g in m.segments){var y=m.segments[g];y.reversibility=m.reversibility;var b=d.nodes[y.from_node_id].bigg_id;b in m.metabolites&&(y.from_node_coefficient=m.metabolites[b].coefficient);var w=d.nodes[y.to_node_id].bigg_id;w in m.metabolites&&(y.to_node_coefficient=m.metabolites[w].coefficient);var E=d.nodes[y.from_node_id],S=d.nodes[y.to_node_id];if(E["node_type"]=="metabolite"||S["node_type"]=="metabolite"){var x=e.c_plus_c(E,e.c_times_scalar(e.c_minus_c(S,E),.5));y.b1===null&&(y.b1=x),y.b2===null&&(y.b2=x)}}}if(h)for(var T in d.nodes){var N=d.nodes[T];if(N.node_type!="metabolite")continue;d.search_index.insert("n"+T,{name:N.bigg_id,data:{type:"metabolite",node_id:T}})}d.largest_ids.reactions=L(d.reactions),d.largest_ids.nodes=L(d.nodes),d.largest_ids.text_labels=L(d.text_labels);var C=0;for(var k in d.reactions)C=L(d.reactions[k].segments,C);return d.largest_ids.segments=C,d.apply_reaction_data_to_map(),d.apply_metabolite_data_to_map(),d}function d(e){e.append("g").attr("id","membranes"),e.append("g").attr("id","reactions"),e.append("g").attr("id","nodes"),e.append("g").attr("id","text-labels")}function v(){this.sel.select("#membranes").selectAll(".membrane").remove(),this.sel.select("#reactions").selectAll(".reaction").remove(),this.sel.select("#nodes").selectAll(".node").remove(),this.sel.select("#text-labels").selectAll(".text-label").remove()}function m(e){this.status=e,this.callback_manager.run("set_status",e)}function g(e){this.cobra_model=e,this.cobra_model!==null&&(this.cobra_model.apply_reaction_data(this.reaction_data_object,this.reaction_data_styles),this.cobra_model.apply_metabolite_data(this.metabolite_data_object,this.metabolite_data_styles))}function y(e){this.reaction_data_object=f.import_and_check(e,this.reaction_data_styles,"reaction_data"),this.apply_reaction_data_to_map(),this.cobra_model!==null&&this.cobra_model.apply_reaction_data(this.reaction_data_object,this.reaction_data_styles),this.draw_all_reactions()}function b(e){this.metabolite_data_object=f.import_and_check(e,this.metabolite_data_styles,"metabolite_data"),this.apply_metabolite_data_to_map(),this.cobra_model!==null&&this.cobra_model.apply_metabolite_data(this.metabolite_data_object,this.metabolite_data_styles),this.draw_all_nodes()}function w(){this.reactions={},this.nodes={},this.membranes=[],this.text_labels={},this.apply_reaction_data_to_map(),this.apply_metabolite_data_to_map(),this.draw_everything()}function E(){return this.reaction_data_object!==null}function S(){return this.metabolite_data_object!==null}function x(){var n=this.sel,r=this.membranes,i=this.scale,s=this.reactions,o=this.nodes,u=this.text_labels,a=this.defs,f=this.default_reaction_color,l=this.behavior.bezier_drag,c=this.behavior.node_click,h=this.behavior.node_mouseover,p=this.behavior.node_mouseout,d=this.behavior.node_drag,v=this.behavior.reaction_label_drag,m=this.behavior.node_label_drag,g=this.behavior.text_label_click,y=this.behavior.text_label_drag,b=this.has_reaction_data(),w=this.reaction_data_styles,E=this.has_metabolite_data(),S=this.metabolite_data_styles,x=this.beziers_enabled;e.draw_an_array(n,"#membranes",".membrane",r,t.create_membrane,t.update_membrane),e.draw_an_object(n,"#reactions",".reaction",s,"reaction_id",t.create_reaction,function(e){return t.update_reaction(e,i,o,x,a,f,b,w,l,v)}),e.draw_an_object(n,"#nodes",".node",o,"node_id",function(e){return t.create_node(e,o,s)},function(e){return t.update_node(e,i,E,S,c,h,p,d,m)}),e.draw_an_object(n,"#text-labels",".text-label",u,"text_label_id",function(e){return t.create_text_label(e)},function(e){return t.update_text_label(e,g,y)})}function T(){var e=[];for(var t in this.reactions)e.push(t);this.draw_these_reactions(e)}function N(n){var r=this.scale,i=this.reactions,s=this.nodes,o=this.defs,u=this.default_reaction_color,a=this.behavior.bezier_drag,f=this.behavior.reaction_label_drag,l=this.has_reaction_data(),c=this.reaction_data_styles,h=this.beziers_enabled,p={},d=-1;while(++d<n.length)p[n[d]]=e.clone(i[n[d]]);n.length!=Object.keys(p).length&&console.warn("did not find correct reaction subset");var v=this.sel.select("#reactions").selectAll(".reaction").data(e.make_array(p,"reaction_id"),function(e){return e.reaction_id});v.enter().call(t.create_reaction),v.call(function(e){return t.update_reaction(e,r,s,h,o,u,l,c,a,f)}),v.exit()}function C(){var e=[];for(var t in this.nodes)e.push(t);this.draw_these_nodes(e)}function k(n){var r=this.scale,i=this.reactions,s=this.nodes,o=this.behavior.node_click,u=this.behavior.node_mouseover,a=this.behavior.node_mouseout,f=this.behavior.node_drag,l=this.behavior.node_label_drag,c=this.metabolite_data_styles,h=this.has_metabolite_data(),p={},d=-1;while(++d<n.length)p[n[d]]=e.clone(s[n[d]]);n.length!=Object.keys(p).length&&console.warn("did not find correct node subset");var v=this.sel.select("#nodes").selectAll(".node").data(e.make_array(p,"node_id"),function(e){return e.node_id});v.enter().call(function(e){return t.create_node(e,s,i)}),v.call(function(e){return t.update_node(e,r,h,c,o,u,a,f,l)}),v.exit()}function L(n){var r=this.text_labels,i=this.behavior.text_label_click,s=this.behavior.text_label_drag,o={},u=-1;while(++u<n.length)o[n[u]]=e.clone(r[n[u]]);n.length!=Object.keys(o).length&&console.warn("did not find correct text label subset");var a=this.sel.select("#text-labels").selectAll(".text-label").data(e.make_array(o,"text_label_id"),function(e){return e.text_label_id});a.enter().call(function(e){return t.create_text_label(e)}),a.call(function(e){return t.update_text_label(e,i,s)}),a.exit()}function A(){return this.apply_reaction_data_to_reactions(this.reactions)}function O(e){if(!this.has_reaction_data()){for(var t in e){var n=e[t];n.data=null,n.data_string="";for(var r in n.segments){var i=n.segments[r];i.data=null}}return!1}var s=this.reaction_data_object,o=this.reaction_data_styles;for(var t in e){var n=e[t],u=n.bigg_id in s?s[n.bigg_id]:null,a=f.float_for_data(u,o),l=f.text_for_data(u,o);n.data=a,n.data_string=l;for(var r in n.segments){var i=n.segments[r];i.data=a}}return this.update_reaction_data_domain()}function M(){var t=[];for(var n in this.reactions){var r=this.reactions[n];r.data!==null&&t.push(r.data)}var i=this.scale.reaction_color.domain(),s,o,u;if(this.reaction_data_styles.indexOf("Abs")!=-1){var a=0,f=0;t.length>0&&(t=t.map(function(e){return Math.abs(e)}),a=Math.min.apply(null,t),f=Math.max.apply(null,t)),f==0&&(f=a=10),a==f&&(a=f/2),s=[-f,-a,0,a,f],o=["red","blue","rgb(200,200,200)","blue","red"],u=[12,6,6,6,12]}else{var a=0,f=0;t.push(0),t.length>0&&(a=Math.min.apply(null,t),f=Math.max.apply(null,t)),s=[a,f],o=["blue","red"],u=[6,12]}return this.scale.reaction_color.domain(s).range(o),this.scale.reaction_size.domain(s).range(u),this.callback_manager.run("update_reaction_data_domain"),!e.compare_arrays(i,s)}function _(){return this.apply_metabolite_data_to_nodes(this.nodes)}function D(e){if(!this.has_metabolite_data()){for(var t in e)e[t].data=null,e[t].data_string="";return!1}var n=this.metabolite_data_object,r=this.metabolite_data_styles;for(var t in e){var i=e[t],s=i.bigg_id in n?n[i.bigg_id]:null,o=f.float_for_data(s,r),u=f.text_for_data(s,r);i.data=o,i.data_string=u}return this.update_metabolite_data_domain()}function P(){var t=0,n=0,r=[];for(var i in this.nodes){var s=this.nodes[i];s.data!==null&&r.push(s.data)}r.length>0&&(t=Math.min.apply(null,r),n=Math.max.apply(null,r));var o=this.scale.metabolite_size.domain(),u,a,f;if(this.metabolite_data_styles.indexOf("Abs")!=-1){var t=0,n=0;r.length>0&&(r=r.map(function(e){return Math.abs(e)}),t=Math.min.apply(null,r),n=Math.max.apply(null,r)),n==0&&(n=t=10),t==n&&(t=n/2),u=[-n,-t,0,t,n],a=["red","white","white","white","red"],f=[15,8,8,8,18]}else{var t=0,n=0;r.push(0),r.length>0&&(t=Math.min.apply(null,r),n=Math.max.apply(null,r)),u=[t,n],a=["white","red"],f=[8,15]}return this.scale.metabolite_color.domain(u).range(a),this.scale.metabolite_size.domain(u).range(f),this.callback_manager.run("update_metabolite_data_domain"),!e.compare_arrays(o,u)}function H(e){var t=this.nodes[e],n={x:t.x,y:t.y};return n}function B(){var e=[];return this.sel.select("#nodes").selectAll(".selected").each(function(t){e.push(t.node_id)}),e}function j(){var e={},t=this;return this.sel.select("#nodes").selectAll(".selected").each(function(n){e[n.node_id]=t.nodes[n.node_id]}),e}function F(){var e=[];return this.sel.select("#text-labels").selectAll(".selected").each(function(t){e.push(t.text_label_id)}),e}function I(){var e={},t=this;return this.sel.select("#text-labels").selectAll(".selected").each(function(n){e[n.text_label_id]=t.text_labels[n.text_label_id]}),e}function q(){this.sel.selectAll(".selected").classed("selected",!1)}function R(e){this.deselect_text_labels();var t=this.sel.select("#nodes").selectAll(".node"),n,r;t.classed("selected",function(t){var i=String(t.node_id)==String(e);return i&&(r=t,n={x:t.x,y:t.y}),i}),this.sel.selectAll(".start-reaction-target").style("visibility","hidden"),this.callback_manager.run("select_metabolite_with_id",r,n)}function U(e,t){this.deselect_text_labels();var n=this.sel.select("#nodes").selectAll(".node"),r=this.key_manager.held_keys.shift;r?d3.select(e.parentNode).classed("selected",!d3.select(e.parentNode).classed("selected")):n.classed("selected",function(e){return t===e});var i=this.sel.select("#nodes").selectAll(".selected"),s=0,o,u;i.each(function(e){u=e,o={x:e.x,y:e.y},s++}),this.callback_manager.run("select_metabolite",s,u,o)}function z(){var e=null,t=this,n=this.sel.select("#nodes").selectAll(".selected");return n.classed("selected",function(t,n){return n==0?(e=t,!0):!1}),e}function W(){var e=this.sel.select("#nodes").selectAll(".node");e.classed("selected",!1)}function X(e,t){this.deselect_nodes();var n=this.sel.select("#text-labels").selectAll(".text-label");n.classed("selected",function(e){return t===e});var r=this.sel.select("#text-labels").selectAll(".selected"),i;r.each(function(e){i={x:e.x,y:e.y}}),this.callback_manager.run("select_text_label")}function V(){var e=this.sel.select("#text-labels").selectAll(".text-label");e.classed("selected",!1)}function $(){var e=this.get_selected_nodes();Object.keys(e).length>=1&&this.delete_nodes(e);var t=this.get_selected_text_labels();Object.keys(t).length>=1&&this.delete_text_labels(t)}function J(t){var n=this.segments_and_reactions_for_nodes(t),r=n.reactions,i=n.segment_objs_w_segments,s=e.clone(t),o=e.clone(i),u=e.clone(r),a=function(e,n,r){this.delete_node_data(Object.keys(t)),this.delete_segment_data(r),this.delete_reaction_data(Object.keys(n)),this.draw_everything()}.bind(this);a(t,r,i),this.undo_stack.push(function(){this.extend_nodes(s),this.extend_reactions(u);var n=Object.keys(u);o.forEach(function(e){var t=e.segment;this.reactions[e.reaction_id].segments[e.segment_id]=t,[t.from_node_id,t.to_node_id].forEach(function(t){if(t in s)return;var n=this.nodes[t];n.connected_segments.push({reaction_id:e.reaction_id,segment_id:e.segment_id})}.bind(this)),n.indexOf(e.reaction_id)==-1&&n.push(e.reaction_id)}.bind(this)),this.draw_these_nodes(Object.keys(s)),this.draw_these_reactions(n),t=e.clone(s),i=e.clone(o),r=e.clone(u)}.bind(this),function(){a(t,r,i)}.bind(this))}function K(t){var n=e.clone(t),r=this,i=function(e){r.delete_text_label_data(Object.keys(t)),r.draw_everything()};i(t),this.undo_stack.push(function(){e.extend(r.text_labels,n),r.draw_these_text_labels(Object.keys(n)),t=e.clone(n)},function(){i(t)})}function Q(e){e.forEach(function(e){if(this.enable_search&&this.nodes[e].node_type=="metabolite"){var t=this.search_index.remove("n"+e);t||console.warn("Could not find deleted metabolite in search index")}delete this.nodes[e]}.bind(this))}function G(e){e.forEach(function(e){var t=this.reactions[e.reaction_id];if(!(e.segment_id in t.segments))return;var n=t.segments[e.segment_id];[n.from_node_id,n.to_node_id].forEach(function(t){if(!(t in this.nodes))return;var n=this.nodes[t];n.connected_segments=n.connected_segments.filter(function(t){return t.segment_id!=e.segment_id})}.bind(this)),delete t.segments[e.segment_id]}.bind(this))}function Y(e){e.forEach(function(e){delete this.reactions[e];var t=this.search_index.remove("r"+e);t||console.warn("Could not find deleted reaction in search index")}.bind(this))}function Z(e){e.forEach(function(e){delete this.text_labels[e]}.bind(this))}function et(){this.toggle_beziers(!0)}function tt(){this.toggle_beziers(!1)}function nt(e){e===undefined?this.beziers_enabled=!this.beziers_enabled:this.beziers_enabled=e,this.draw_everything(),this.callback_manager.run("toggle_beziers",this.beziers_enabled)}function rt(t,n,r){function v(e,t){this.extend_nodes(e);if(this.has_metabolite_data()){var n=this.apply_metabolite_data_to_nodes(e);n?this.draw_all_nodes():this.draw_these_nodes([t])}else this.draw_these_nodes([t])}for(var i in this.reactions)if(this.reactions[i].bigg_id==t)return console.warn("reaction is already drawn"),null;if(!this.cobra_model)return console.error("No CobraModel. Cannot build new reaction");var s=e.clone(this.cobra_model.reactions[t]);for(var o in s.metabolites){var u=s.metabolites[o],a=this.cobra_model.metabolites[o];if(u<0){var f=String(++this.largest_ids.nodes),l={x:30,y:10},c={connected_segments:[],x:n.x,y:n.y,node_is_primary:!0,label_x:n.x+l.x,label_y:n.y+l.y,name:a.name,bigg_id:o,node_type:"metabolite"},h={};h[f]=c;break}}v.apply(this,[h,f]);var p=e.clone(h),d=this;return this.undo_stack.push(function(){d.delete_node_data(Object.keys(h)),h=e.clone(p),d.draw_everything()},function(){v.apply(d,[h,f])}),this.new_reaction_for_metabolite(t,f,r),null}function it(t){if(this.enable_search)for(var n in t){var r=t[n];if(r.node_type!="metabolite")continue;this.search_index.insert("n"+n,{name:r.bigg_id,data:{type:"metabolite",node_id:n}})}e.extend(this.nodes,t)}function st(t){for(var n in t){var r=t[n];this.enable_search&&this.search_index.insert("r"+n,{name:r.bigg_id,data:{type:"reaction",reaction_id:n}})}e.extend(this.reactions,t)}function ot(t,n,r){function d(e,t,n){this.extend_reactions(t),this.delete_node_data([n]),this.extend_nodes(e);if(this.has_reaction_data()){var r=this.apply_reaction_data_to_reactions(t);r?this.draw_all_reactions():this.draw_these_reactions(Object.keys(t))}else this.draw_these_reactions(Object.keys(t));if(this.has_metabolite_data()){var r=this.apply_metabolite_data_to_nodes(e);r?this.draw_all_nodes():this.draw_these_nodes(Object.keys(e))}else this.draw_these_nodes(Object.keys(e));for(var i in e){var s=e[i];if(s.node_is_primary&&i!=n){this.select_metabolite_with_id(i);var o={x:s.x,y:s.y};this.zoom_container&&this.zoom_container.translate_off_screen(o)}}}for(var s in this.reactions)if(this.reactions[s].bigg_id==t){console.warn("reaction is already drawn");return}var o=this.nodes[n],u=this.cobra_model.reactions[t],a=i.new_reaction(t,u,this.cobra_model.metabolites,n,e.clone(o),this.largest_ids,this.cobra_model.cofactors,r),f=a.new_nodes,l=a.new_reactions;d.apply(this,[f,l,n]);var c=e.clone(f),h=e.clone(l),p=this;this.undo_stack.push(function(){delete f[n],p.delete_node_data(Object.keys(f)),p.delete_reaction_data(Object.keys(l)),R.apply(p,[n]),f=e.clone(c),l=e.clone(h),p.draw_everything()},function(){d.apply(p,[f,l,n])})}function ut(){var e=this.get_selected_nodes(),t=Object.keys(e)[0],n=e[t],r=this.reactions,i=this.nodes,s=[],o;i[t].connected_segments.forEach(function(e){o=[e.reaction_id];var n=r[e.reaction_id].segments[e.segment_id];s.push(n.from_node_id==t?n.to_node_id:n.from_node_id)});if(s.length!=1)return console.error("Only connected nodes with a single reaction can be selected");var u=s[0],a=[t],f=[];i[u].connected_segments.forEach(function(e){var n=r[e.reaction_id].segments[e.segment_id],s=n.from_node_id==u?n.to_node_id:n.from_node_id,o=i[s];o.node_type=="metabolite"&&s!=t&&a.push(String(s))});for(var l=0;l<a.length;l++)if(i[a[l]].connected_segments.length>1)return console.error("Only connected nodes with a single reaction can be selected");for(var c in e)if(c!=t&&a.indexOf(c)==-1)return console.warn("Selected nodes are not on the same reaction");var h=[],p=a.length-1,d=i[a[p]],v=d.node_is_primary,m={x:d.x,y:d.y,label_x:d.label_x,label_y:d.label_y},g=d.connected_segments[0],y=r[g.reaction_id].segments[g.segment_id],b={b1:y.b1,b2:y.b2},w;a.forEach(function(e){var t=i[e],n=t.node_is_primary,s={x:t.x,y:t.y,label_x:t.label_x,label_y:t.label_y},o=t.connected_segments[0],u=r[o.reaction_id].segments[o.segment_id],a={b1:u.b1,b2:u.b2};t.node_is_primary=v,t.x=m.x,t.y=m.y,t.label_x=m.label_x,t.label_y=m.label_y,u.b1=b.b1,u.b2=b.b2,v=n,m=s,b=a,t.node_is_primary&&(w=e),h.push(e)});var E=i[u].connected_segments,p=E.length-1,S=[E[p]];E.forEach(function(e,t){if(p==t)return;S.push(e)}),i[u].connected_segments=S,this.draw_these_nodes(h),this.draw_these_reactions(o),this.select_metabolite_with_id(w)}function at(){var e=this.get_selected_nodes(),t=this.reactions,n=this.nodes;if(Object.keys(e).length!=1)return console.error("Only one node can be selected");var r=Object.keys(e)[0],i=e[r];n[r].node_is_primary=!0;var s=[r],o=[];n[r].connected_segments.forEach(function(e){var n=t[e.reaction_id].segments[e.segment_id];o.push(n.from_node_id==r?n.to_node_id:n.from_node_id)}),o.forEach(function(e){var i=[];n[e].connected_segments.forEach(function(i){var o=t[i.reaction_id].segments[i.segment_id],u=o.from_node_id==e?o.to_node_id:o.from_node_id,a=n[u];a.node_type=="metabolite"&&u!=r&&(a.node_is_primary=!1,s.push(u))})}),this.draw_these_nodes(s)}function ft(t){var n=[],r={},i={},s=this.reactions;for(var o in t){var u=t[o];u.connected_segments.forEach(function(t){var r=s[t.reaction_id],o=r.segments[t.segment_id],u=e.clone(t);u.segment=e.clone(o),n.push(u),t.reaction_id in i||(i[t.reaction_id]=[]),i[t.reaction_id].push(t.segment_id)})}for(var a in i){var f=s[a],l=i[a],c=!0;for(var h in f.segments)l.indexOf(h)==-1&&(c=!1);c&&(r[a]=f)}return{segment_objs_w_segments:n,reactions:r}}function m(e){var t=d3.select("body").select("#status");return t.empty()&&(t=d3.select("body").append("text").attr("id","status")),t.text(e),this}function lt(e){this._zoom_extent(e,"nodes")}function ct(e){this._zoom_extent(e,"canvas")}function ht(e,t){e===undefined&&(e=t=="nodes"?.2:0),t===undefined&&(t="canvas");var n,r,i=this.get_size();e*=i.height;if(t=="nodes"){var s={x:null,y:null},o={x:null,y:null};for(var u in this.nodes){var a=this.nodes[u];s.x===null&&(s.x=a.x),s.y===null&&(s.y=a.y),o.x===null&&(o.x=a.x),o.y===null&&(o.y=a.y),s.x=Math.min(s.x,a.x),s.y=Math.min(s.y,a.y),o.x=Math.max(o.x,a.x),o.y=Math.max(o.y,a.y)}n=Math.min((i.width-e*2)/(o.x-s.x),(i.height-e*2)/(o.y-s.y)),r={x:-(s.x*n)+e+(i.width-e*2-(o.x-s.x)*n)/2,y:-(s.y*n)+e+(i.height-e*2-(o.y-s.y)*n)/2}}else{if(t!="canvas")return console.error("Did not recognize mode");n=Math.min((i.width-e*2)/this.canvas.width,(i.height-e*2)/this.canvas.height),r={x:-(this.canvas.x*n)+e+(i.width-e*2-this.canvas.width*n)/2,y:-(this.canvas.y*n)+e+(i.height-e*2-this.canvas.height*n)/2}}return this.zoom_container.go_to(n,r),null}function pt(){return this.zoom_container.get_size()}function dt(e){var t=this.reactions[e],n=.6,r=this.get_size(),i={x:-t.label_x*n+r.width/2,y:-t.label_y*n+r.height/2};this.zoom_container.go_to(n,i)}function vt(e){var t=this.nodes[e],n=.6,r=this.get_size(),i={x:-t.label_x*n+r.width/2,y:-t.label_y*n+r.height/2};this.zoom_container.go_to(n,i)}function mt(e){this.highlight(this.sel.selectAll("#r"+e).selectAll("text"))}function gt(e){this.highlight(this.sel.selectAll("#n"+e).selectAll("text"))}function yt(e){this.sel.selectAll(".highlight").classed("highlight",!1),e!==null&&e.classed("highlight",!0)}function bt(){console.log("Saving"),e.download_json(this.map_for_export(),"saved_map")}function wt(){var t={reactions:e.clone(this.reactions),nodes:e.clone(this.nodes),membranes:e.clone(this.membranes),text_labels:e.clone(this.text_labels),canvas:this.canvas.size_and_location()};for(var n in t.reactions){var r=t.reactions[n];delete r.data,delete r.data_string;for(var i in r.segments){var s=r.segments[i];delete s.reversibility,delete s.from_node_coefficient,delete s.to_node_coefficient,delete s.data}}for(var o in t.nodes){var u=t.nodes[o];delete u.data,delete u.data_string}return this.debug&&d3.json("map_spec.json",function(n,r){if(n){console.warn(n);return}e.check_r(t,r.spec,r.can_be_none)}),t}function Et(){console.log("Exporting SVG"),this.callback_manager.run("before_svg_export");var t=this.zoom_container.window_scale,n=this.zoom_container.window_translate,r=this.canvas.size_and_location(),i={w:this.canvas.mouse_node.attr("width"),h:this.canvas.mouse_node.attr("height"),transform:this.canvas.mouse_node.attr("transform")};this.zoom_container.go_to(1,{x:-r.x,y:-r.y},!1),this.svg.attr("width",r.width),this.svg.attr("height",r.height),this.canvas.mouse_node.attr("width","0px"),this.canvas.mouse_node.attr("height","0px"),this.canvas.mouse_node.attr("transform",null),e.export_svg("saved_map",this.svg,!0),this.zoom_container.go_to(t,n,!1),this.svg.attr("width",null),this.svg.attr("height",null),this.canvas.mouse_node.attr("width",i.w),this.canvas.mouse_node.attr("height",i.h),this.canvas.mouse_node.attr("transform",i.transform),this.callback_manager.run("after_svg_export")}var c=e.make_class();return c.from_data=p,c.prototype={init:h,setup_containers:d,reset_containers:v,set_status:m,set_model:g,set_reaction_data:y,set_metabolite_data:b,clear_map:w,select_none:q,select_metabolite:U,select_metabolite_with_id:R,select_single_node:z,deselect_nodes:W,select_text_label:X,deselect_text_labels:V,new_reaction_from_scratch:rt,new_reaction_for_metabolite:ot,cycle_primary_node:ut,make_selected_node_primary:at,extend_nodes:it,extend_reactions:st,delete_selected:$,delete_nodes:J,delete_text_labels:K,delete_node_data:Q,delete_segment_data:G,delete_reaction_data:Y,delete_text_label_data:Z,get_selected_node_ids:B,get_selected_nodes:j,get_selected_text_label_ids:F,get_selected_text_labels:I,segments_and_reactions_for_nodes:ft,has_reaction_data:E,has_metabolite_data:S,draw_everything:x,draw_all_reactions:T,draw_these_reactions:N,draw_all_nodes:C,draw_these_nodes:k,draw_these_text_labels:L,apply_reaction_data_to_map:A,apply_reaction_data_to_reactions:O,update_reaction_data_domain:M,apply_metabolite_data_to_map:_,apply_metabolite_data_to_nodes:D,update_metabolite_data_domain:P,get_selected_node_ids:B,toggle_beziers:nt,hide_beziers:tt,show_beziers:et,zoom_extent_nodes:lt,zoom_extent_canvas:ct,_zoom_extent:ht,get_size:pt,zoom_to_reaction:dt,zoom_to_node:vt,highlight_reaction:mt,highlight_node:gt,highlight:yt,save:bt,map_for_export:wt,save_svg:Et},c}),n("ZoomContainer",["utils","CallbackManager"],function(e,t){function r(e,n,r){this.zoom_on=!0,this.initial_zoom=1,this.window_translate={x:0,y:0},this.window_scale=1,this.callback_manager=new t,this.size_container=n,e.select("#zoom-container").remove();var i=e.append("g").attr("id","zoom-container");this.zoomed_sel=i.append("g");var s=function(e,t){e.zoom_on&&(e.zoomed_sel.attr("transform","translate("+t.translate+")"+"scale("+t.scale+")"),e.window_translate={x:t.translate[0],y:t.translate[1]},e.window_scale=t.scale,e.callback_manager.run("zoom"))},o=this;this.zoom_behavior=d3.behavior.zoom().on("zoom",function(){s(o,d3.event)}),i.call(this.zoom_behavior),(r=="none"||r=="pan")&&i.on("mousewheel.zoom",null).on("DOMMouseScroll.zoom",null).on("wheel.zoom",null).on("dblclick.zoom",null);if(r=="pan"){var u=function(){var e=d3.event,t=.5;e.stopPropagation(),e.preventDefault(),e.returnValue=!1,this.go_to(this.window_scale,{x:this.window_translate.x-(e.wheelDeltaX!==undefined?-e.wheelDeltaX/1.5:e.deltaX)*t,y:this.window_translate.y-(e.wheelDeltaY!==undefined?-e.wheelDeltaY/1.5:e.deltaY)*t},!1)}.bind(this);i.on("mousewheel.escher",u),i.on("DOMMouseScroll.escher",u),i.on("wheel.escher",u)}this.saved_scale=null,this.saved_translate=null}function i(t){t===undefined?this.zoom_on=!this.zoom_on:this.zoom_on=t,this.zoom_on?(this.saved_scale!==null&&(this.zoom_behavior.scale(this.saved_scale),this.saved_scale=null),this.saved_translate!==null&&(this.zoom_behavior.translate(this.saved_translate),this.saved_translate=null),this.zoomed_sel.classed("cursor-grab",!0).classed("cursor-grabbing",!1),this.zoomed_sel.on("mousedown.cursor",function(e){e.classed("cursor-grab",!1).classed("cursor-grabbing",!0)}.bind(null,this.zoomed_sel)).on("mouseup.cursor",function(e){e.classed("cursor-grab",!0).classed("cursor-grabbing",!1)}.bind(null,this.zoomed_sel))):(this.saved_scale===null&&(this.saved_scale=e.clone(this.zoom_behavior.scale())),this.saved_translate===null&&(this.saved_translate=e.clone(this.zoom_behavior.translate())),this.zoomed_sel.style("cursor",null).classed("cursor-grab",!1).classed("cursor-grabbing",!1),this.zoomed_sel.on("mousedown.cursor",null),this.zoomed_sel.on("mouseup.cursor",null))}function s(t,n,r){e.check_undefined(arguments,["scale","translate"]),r===undefined&&(r=!0);if(!t)throw new Error("Bad scale value");if(!!n&&"x"in n&&"y"in n&&!isNaN(n.x)&&!isNaN(n.y)){this.zoom_behavior.scale(t),this.window_scale=t,this.saved_scale!==null&&(this.saved_scale=t);var i=[n.x,n.y];this.zoom_behavior.translate(i),this.window_translate=n,this.saved_translate!==null&&(this.saved_translate=i);var s=r?this.zoomed_sel.transition():this.zoomed_sel;return s.attr("transform","translate("+this.window_translate.x+","+this.window_translate.y+")"+"scale("+this.window_scale+")"),null}return console.error("Bad translate value")}function o(t){var n=this.get_size(),r={x:n.width/2-((n.width/2-this.window_translate.x)*t+this.window_translate.x),y:n.height/2-((n.height/2-this.window_translate.y)*t+this.window_translate.y)};this.go_to(this.window_scale*t,e.c_plus_c(this.window_translate,r),!0)}function u(){this.zoom_by(1.5)}function a(){this.zoom_by(.667)}function f(){return{width:parseInt(this.size_container.style("width"),10),height:parseInt(this.size_container.style("height"),10)}}function l(e){var t=120,n=this.get_size(),r={x:{min:-this.window_translate.x/this.window_scale+t/this.window_scale,max:-this.window_translate.x/this.window_scale+(n.width-t)/this.window_scale},y:{min:-this.window_translate.y/this.window_scale+t/this.window_scale,max:-this.window_translate.y/this.window_scale+(n.height-t)/this.window_scale}};e.x<r.x.min?(this.window_translate.x=this.window_translate.x-(e.x-r.x.min)*this.window_scale,this.go_to(this.window_scale,this.window_translate)):e.x>r.x.max&&(this.window_translate.x=this.window_translate.x-(e.x-r.x.max)*this.window_scale,this.go_to(this.window_scale,this.window_translate)),e.y<r.y.min?(this.window_translate.y=this.window_translate.y-(e.y-r.y.min)*this.window_scale,this.go_to(this.window_scale,this.window_translate)):e.y>r.y.max&&(this.window_translate.y=this.window_translate.y-(e.y-r.y.max)*this.window_scale,this.go_to(this.window_scale,this.window_translate))}function c(){this.go_to(1,{x:0,y:0})}var n=e.make_class();return n.prototype={init:r,toggle_zoom:i,go_to:s,zoom_by:o,zoom_in:u,zoom_out:a,get_size:f,translate_off_screen:l,reset:c},n}),n("DirectionArrow",["utils"],function(e){function n(e){function t(){return"M0 -5 L0 5 L20 5 L20 10 L30 0 L20 -10 L20 -5 Z"}this.arrow_container=e.append("g").attr("id","direction-arrow-container").attr("transform","translate(0,0)rotate(0)"),this.arrow=this.arrow_container.append("path").classed("direction-arrow",!0).attr("d",t()).style("visibility","hidden").attr("transform","translate(30,0)scale(2.5)"),this.sel=e,this.center={x:0,y:0},this._setup_drag(),this.dragging=!1,this.is_visible=!1,this.show()}function r(e){this.center=e;var t=d3.transform(this.arrow_container.attr("transform"));this.arrow_container.attr("transform","translate("+e.x+","+e.y+")rotate("+t.rotate+")")}function i(e){var t=d3.transform(this.arrow_container.attr("transform"));this.arrow_container.attr("transform","translate("+t.translate+")rotate("+e+")")}function s(e){var t=d3.transform(this.arrow_container.attr("transform"));this.arrow_container.attr("transform","translate("+t.translate+")"+"rotate("+(t.rotate+e)+")")}function o(){return d3.transform(this.arrow_container.attr("transform")).rotate}function u(e){e===undefined?this.is_visible=!this.is_visible:this.is_visible=e,this.arrow.style("visibility",this.is_visible?"visible":"hidden")}function a(){this.toggle(!0)}function f(){this.toggle(!1)}function l(){this.set_rotation(0)}function c(){this.set_rotation(90)}function h(){this.set_rotation(180)}function p(){this.set_rotation(270)}function d(){var t=d3.behavior.drag().on("dragstart",function(e){d3.event.sourceEvent.stopPropagation(),this.dragging=!0}.bind(this)).on("drag.direction_arrow",function(t){var n={x:d3.event.dx,y:d3.event.dy},r={x:d3.mouse(this.sel.node())[0],y:d3.mouse(this.sel.node())[1]},i=e.angle_for_event(n,r,this.center);this.displace_rotation(e.to_degrees(i))}.bind(this)).on("dragend",function(e){window.setTimeout(function(){this.dragging=!1}.bind(this),200)}.bind(this));this.arrow_container.call(t)}var t=e.make_class();return t.prototype={init:n,set_location:r,set_rotation:i,displace_rotation:s,get_rotation:o,toggle:u,show:a,hide:f,right:l,left:h,up:p,down:c,_setup_drag:d},t}),n("Input",["utils","lib/complete.ly","Map","ZoomContainer","CallbackManager","draw","DirectionArrow"],function(e,t,n,r,i,s,o){function a(e,s,u){var a=e.append("div").attr("id","rxn-input"),f=t(a.node(),{backgroundColor:"#eee"});d3.select(f.input).on("input",function(){this.value=this.value.replace(" ","").replace("\\","").replace("<","")}),this.selection=a,this.completely=f,a.append("button").attr("class","button input-close-button").text("×").on("click",function(){this.hide_dropdown()}.bind(this));if(s instanceof n){this.map=s;var l=90;this.direction_arrow=new o(s.sel),this.direction_arrow.set_rotation(l),this.setup_map_callbacks(s)}else console.error("Cannot set the map. It is not an instance of builder/Map");u instanceof r?(this.zoom_container=u,this.setup_zoom_callbacks()):console.error("Cannot set the zoom_container. It is not an instance of builder/ZoomContainer"),this.callback_manager=new i,this.toggle(!1),this.target_coords=null}function f(e){e.callback_manager.set("select_metabolite_with_id.input",function(e,t){this.is_active&&this.reload(e,t,!1),this.hide_target()}.bind(this)),e.callback_manager.set("select_metabolite.input",function(e,t,n){this.hide_target(),e==1&&this.is_active&&n?this.reload(t,n,!1):this.toggle(!1)}.bind(this)),e.callback_manager.set("before_svg_export",function(){this.direction_arrow.hide(),this.hide_target()}.bind(this))}function l(){this.zoom_container.callback_manager.set("zoom.input",function(){this.is_active&&this.place_at_selected()}.bind(this))}function c(){return this.selection.style("display")!="none"}function h(e){e===undefined?this.is_active=!this.is_active:this.is_active=e,this.is_active?(this.toggle_start_reaction_listener(!0),this.target_coords!==null?this.show_dropdown(this.target_coords):this.reload_at_selected(),this.map.set_status("Click on the canvas or an existing metabolite"),this.direction_arrow.show(),this.escape=this.map.key_manager.add_escape_listener(function(){this.hide_dropdown()}.bind(this))):(this.toggle_start_reaction_listener(!1),this.selection.style("display","none"),this.completely.input.blur(),this.completely.hideDropDown(),this.map.set_status(null),this.direction_arrow.hide(),this.escape&&this.escape.clear(),this.escape=null)}function p(e){this.selection.style("display","block"),this.completely.input.blur(),this.completely.repaint(),this.completely.setText(""),this.completely.input.focus()}function d(){this.selection.style("display","none"),this.completely.hideDropDown()}function v(){this.map.deselect_text_labels();var e=this.map.select_single_node();if(e==null)return;var t={x:e.x,y:e.y};this.place(t)}function m(e){var t={x:240,y:0},n=this.map.zoom_container.window_translate,r=this.map.zoom_container.window_scale,i=this.map.get_size(),s=Math.max(20,Math.min(i.width-270,r*e.x+n.x-t.x)),o=Math.max(20,Math.min(i.height-40,r*e.y+n.y-t.y));this.selection.style("position","absolute").style("display","block").style("left",s+"px").style("top",o+"px"),this.direction_arrow.set_location(e),this.direction_arrow.show()}function g(){this.map.deselect_text_labels();var e=this.map.select_single_node();if(e==null)return!1;var t={x:e.x,y:e.y};return this.reload(e,t,!1),!0}function y(t,n,r){function w(e,t){for(var n in t)if(t[n].bigg_id==e)return!0;return!1}t===undefined&&!r&&console.error("No selected node, and not starting from scratch"),this.place(n),this.completely.input.blur(),this.completely.repaint();if(this.map.cobra_model===null){this.completely.setText("Cannot add: No model.");return}var i=[],s=this.map.cobra_model.reactions,o=this.map.cobra_model.metabolites,u=this.map.reactions,a=this.map.has_reaction_data(),f=this.map.reaction_data,l=this.map.reaction_data_styles;for(var c in s){var h=s[c];if(w(c,u))continue;for(var p in h.metabolites)if(r||p==t.bigg_id){if(c in i)continue;a?i[c]={reaction_data:h.data,string:c+": "+h.data_string}:i[c]={string:c}}}var d=[],v=e.make_array(i,"reaction_abbreviation");a?v.sort(function(e,t){return Math.abs(t.reaction_data)-Math.abs(e.reaction_data)}):v.sort(function(e,t){return e.string.toLowerCase()<t.string.toLowerCase()?-1:1}),v.forEach(function(e){d.push(e.string)});var m=20,g=this.completely;g.options=d,d.length==1?g.setText(d[0]):g.setText(""),g.onChange=function(e){if(e.length==0){g.options=d,g.repaint();return}var t=d.map(function(t){return t.toLowerCase().indexOf(e.toLowerCase())==0?e+t.slice(e.length):null}).filter(function(e){return e!==null});g.options=t,g.repaint()};var y=this.direction_arrow,b=this.map;g.onEnter=function(){var e=this.getText();this.setText(""),v.forEach(function(i){i.string.toLowerCase()==e.toLowerCase()&&(r?b.new_reaction_from_scratch(i.reaction_abbreviation,n,y.get_rotation()):b.new_reaction_for_metabolite(i.reaction_abbreviation,t.node_id,y.get_rotation()))})},g.repaint(),this.completely.input.focus()}function b(e){if(e===undefined)this.start_reaction_listener=!this.start_reaction_listener;else{if(this.start_reaction_listener==e)return;this.start_reaction_listener=e}this.start_reaction_listener?(this.map.sel.on("click.start_reaction",function(e){if(this.direction_arrow.dragging)return;var t={x:d3.mouse(e)[0],y:d3.mouse(e)[1]};this.map.deselect_nodes(),this.map.deselect_text_labels(),this.reload(null,t,!0),this.show_target(this.map,t)}.bind(this,this.map.sel.node())),this.map.sel.classed("start-reaction-cursor",!0)):(this.map.sel.on("click.start_reaction",null),this.map.sel.classed("start-reaction-cursor",!1),this.hide_target())}function w(){this.target_coords&&this.map.sel.selectAll(".start-reaction-target").remove(),this.target_coords=null}function E(e,t){var n=e.sel.selectAll(".start-reaction-target").data([12,5]);n.enter().append("circle").classed("start-reaction-target",!0).attr("r",function(e){return e}).style("stroke-width",4),n.style("visibility","visible").attr("transform","translate("+t.x+","+t.y+")"),this.target_coords=t}var u=e.make_class();return u.prototype={init:a,setup_map_callbacks:f,setup_zoom_callbacks:l,is_visible:c,toggle:h,show_dropdown:p,hide_dropdown:d,place_at_selected:v,place:m,reload_at_selected:g,reload:y,toggle_start_reaction_listener:b,hide_target:w,show_target:E},u}),n("CobraModel",["utils","data_styles"],function(e,t){function r(e){if(!e.reactions||!e.metabolites)throw new Error("Bad model data.");this.reactions={};for(var t=0,n=e.reactions.length;t<n;t++){var r=e.reactions[t],i=r.id;delete r.id,this.reactions[i]=r}this.metabolites={};for(var t=0,n=e.metabolites.length;t<n;t++){var r=e.metabolites[t],i=r.id;delete r.id,this.metabolites[i]=r}"cofactors"in e?e.cofactors instanceof Array?this.cofactors=e.cofactors:(console.warn("model_data.cofactors should be an array. Ignoring it"),this.cofactors=[]):this.cofactors=[]}function i(e,n){for(var r in this.reactions){var i=this.reactions[r];if(e===null)i.data=null,i.data_string="";else{var s=r in e?e[r]:null,o=t.float_for_data(s,n),u=t.text_for_data(s,n);i.data=o,i.data_string=u}}}function s(e,n){for(var r in this.metabolites){var i=this.metabolites[r];if(e===null)i.data=null,i.data_string="";else{var s=r in e?e[r]:null,o=t.float_for_data(s,n),u=t.text_for_data(s,n);i.data=o,i.data_string=u}}}var n=e.make_class();return n.prototype={init:r,apply_reaction_data:i,apply_metabolite_data:s},n}),n("Brush",["utils"],function(e){function n(e,t,n,r){this.brush_sel=e.append("g").attr("id","brush-container");var i=this.brush_sel.node(),s=e.select(r).node().nextSibling;i!==s&&i.parentNode.insertBefore(i,s),this.enabled=t,this.map=n}function r(){return this.map.sel.select(".brush").empty()}function i(e){e===undefined&&(e=!this.enabled),e?this.selection_brush=this.setup_selection_brush():this.brush_sel.selectAll(".brush").remove()}function s(){var e=this.brush_sel,t=this.map.sel.select("#nodes"),n=this.map.canvas.size_and_location(),r=n.width,i=n.height,s=n.x,o=n.y,u=d3.svg.brush().x(d3.scale.identity().domain([s,s+r])).y(d3.scale.identity().domain([o,o+i])).on("brush",function(e){var n=e.held_keys.shift,r=d3.event.target.extent(),i;n?i=t.selectAll(".node:not(.selected)"):i=t.selectAll(".node"),i.classed("selected",function(e){var t=e.x,n=e.y;return r[0][0]<=t&&t<r[1][0]&&r[0][1]<=n&&n<r[1][1]})}.bind(null,this.map.key_manager)).on("brushend",function(){d3.event.target.clear(),d3.select(this).call(d3.event.target)}),a=e.append("g").attr("class","brush").call(u);return e.selectAll(".background").classed("cursor-grab",!1).classed("cursor-grabbing",!1).style("cursor",null),a}var t=e.make_class();return t.prototype={init:n,toggle:i,setup_selection_brush:s},t}),n("ui",["utils"],function(e){function t(e,t){var n=e.append("button"),r=n.append("span");"id"in t&&n.attr("id",t.id),"classes"in t&&n.attr("class",t.classes),"text"in t&&r.text(t.text),"icon"in t&&r.classed(t.icon,!0),"key"in t&&s(n,t.key),n.attr("title",t.tooltip)}function n(e){var t=e.append("li").attr("class","btn-group-vertical").attr("data-toggle","buttons");return{button:function(e){var n=t.append("label").attr("class","btn btn-default");n.append("input").attr("type","radio");var r=n.append("span");return"id"in e&&n.attr("id",e.id),"text"in e&&r.text(e.text),"icon"in e&&r.classed(e.icon,!0),"key"in e&&s(n,e.key),"tooltip"in e&&n.attr("title",e.tooltip),this}}}function r(e){var t=e.attr("class","btn-group-vertical");return{button:function(e){var n=t.append("button").attr("class","btn btn-default"),r=n.append("span");return"id"in e&&n.attr("id",e.id),"text"in e&&r.text(e.text),"icon"in e&&r.classed(e.icon,!0),"key"in e&&s(n,e.key),"tooltip"in e&&n.attr("title",e.tooltip),this}}}function i(e,t,n){n===undefined&&(n=!1);var r=e.append("li").attr("class","dropdown");r.append("button").text(t+" ").attr("class","btn btn-link btn-sm dropdown-button").attr("data-toggle","dropdown").append("b").attr("class","caret");var i=r.append("ul").attr("class","dropdown-menu").classed("pull-right",n).attr("role","menu").attr("aria-labelledby","dLabel");return{button:function(e){var t=i.append("li").attr("role","presentation"),n=t.append("a").attr("href","#"),r=n.append("span").attr("class","dropdown-button-icon"),u=n.append("span").attr("class","dropdown-button-text");"id"in e&&t.attr("id",e.id),"text"in e&&u.text(" "+e.text),"icon"in e&&r.classed(e.icon,!0);if("key"in e)s(n,e.key);else if("input"in e){var a=e.input,f=o(n,t,a.fn,a.target);"assign"in a&&"key"in a&&(a.assign[a.key]=f)}return this},divider:function(){return i.append("li").attr("role","presentation").attr("class","divider"),this}}}function s(e,t,n){n!==undefined&&e.text(n),e.on("click",function(){t.fn.call(t.target)})}function o(t,n,r,i){var s=n.append("input").attr("type","file").style("display","none").on("change",function(){e.load_json(this.files[0],r,i)});return t.on("click",function(e){s.node().click()}),function(){s.node().click()}}return{individual_button:t,radio_button_group:n,button_group:r,dropdown_menu:i,set_button:s,set_input_button:o}}),n("SearchBar",["utils"],function(e){function n(e,t,n){var r=e.attr("class","search-container").style("display","none");this.input=r.append("input").attr("class","search-bar");var i=r.append("div").attr("class","btn-group btn-group-sm");i.append("button").attr("class","btn btn-default").on("click",this.previous.bind(this)).append("span").attr("class","glyphicon glyphicon-chevron-left"),i.append("button").attr("class","btn btn-default").on("click",this.next.bind(this)).append("span").attr("class","glyphicon glyphicon-chevron-right"),this.counter=r.append("div").attr("class","search-counter"),r.append("button").attr("class","btn btn-sm btn-default search-close-button").on("click",function(){this.toggle(!1)}.bind(this)).append("span").attr("class","glyphicon glyphicon-remove"),this.selection=r,this.map=n,this.search_index=t,this.current=1,this.results=null,this.input.on("input",function(e){this.current=1,this.results=this.search_index.find(e.value),this.update()}.bind(this,this.input.node()))}function r(){return this.selection.style("display")!="none"}function i(e){e===undefined?this.is_active=!this.is_active:this.is_active=e,this.is_active?(this.selection.style("display",null),this.counter.text(""),this.input.node().value="",this.input.node().focus(),this.escape=this.map.key_manager.add_escape_listener(function(){this.toggle(!1)}.bind(this)),this.escape=this.map.key_manager.add_enter_listener(function(){this.next()}.bind(this))):(this.map.highlight(null),this.selection.style("display","none"),this.results=null,this.escape&&this.escape.clear(),this.escape=null,this.enter&&this.enter.clear(),this.enter=null)}function s(){if(this.results==null)this.counter.text(""),this.map.zoom_extent_canvas(),this.map.highlight(null);else if(this.results.length==0)this.counter.text("0 / 0"),this.map.zoom_extent_canvas(),this.map.highlight(null);else{this.counter.text(this.current+" / "+this.results.length);var e=this.results[this.current-1];if(e.type=="reaction")this.map.zoom_to_reaction(e.reaction_id),this.map.highlight_reaction(e.reaction_id);else{if(e.type!="metabolite")throw new Error("Bad search index data type: "+e.type);this.map.zoom_to_node(e.node_id),this.map.highlight_node(e.node_id)}}}function o(){if(this.results==null)return;this.current==this.results.length?this.current=1:this.current+=1,this.update()}function u(){if(this.results==null)return;this.current==1?this.current=this.results.length:this.current-=1,this.update()}var t=e.make_class();return t.prototype={init:n,is_visible:r,toggle:i,update:s,next:o,previous:u},t}),n("Builder",["utils","Input","ZoomContainer","Map","CobraModel","Brush","CallbackManager","ui","SearchBar"],function(e,t,n,r,i,s,o,u,a){function l(t){function i(e,t){e&&console.warn(e),this.o.map_data=t}function s(e,t){e&&console.warn(e),this.o.cobra_model=t}function o(e,t){e&&console.warn(e),this.o.css=t}function u(e,t){e&&console.warn(e),this.o.reaction_data=t}function a(e,t){e&&console.warn(e),this.o.metabolite_data=t}var n=e.set_options(t,{selection:d3.select("body").append("div"),menu:"all",scroll_behavior:"pan",enable_editing:!0,enable_keys:!0,enable_search:!0,fillScreen:!1,on_load:null,map_path:null,map:null,cobra_model_path:null,cobra_model:null,css_path:null,css:null,reaction_data_path:null,reaction_data:null,reaction_data_styles:["Color","Size","Abs","Diff"],metabolite_data:null,metabolite_data_path:null,metabolite_data_styles:["Color","Size","Diff"],show_beziers:!1,debug:!1,starting_reaction:"GLCtex",margins:{top:0,right:0,bottom:0,left:0}});if(e.check_for_parent_tag(n.selection,"svg"))throw new Error("Builder cannot be placed within an svg node becuase UI elements are html-based.");this.o=n;var r=[{file:n.map_path,value:n.map,callback:i},{file:n.cobra_model_path,value:n.cobra_model,callback:s},{file:n.css_path,value:n.css,callback:o},{file:n.reaction_data_path,value:n.reaction_data,callback:u},{file:n.metabolite_data_path,value:n.metabolite_data,callback:a}];e.load_files(this,r,c);return}function c(){var u=!0,f=!1;this.callback_manager=o();var l=null;this.o.cobra_model!==null?l=i(this.o.cobra_model):console.warn("No cobra model was loaded."),e.remove_child_nodes(this.o.selection);var c=e.setup_svg(this.o.selection,this.o.selection_is_svg,this.o.margins,this.o.fill_screen);this.zoom_container=new n(c,this.o.selection,this.o.scroll_behavior);var h=this.zoom_container.zoomed_sel;this.o.map_data!==null?(this.map=r.from_data(this.o.map_data,c,this.o.css,h,this.zoom_container,this.o.reaction_data,this.o.reaction_data_styles,this.o.metabolite_data,this.o.metabolite_data_styles,l,this.o.enable_search),this.zoom_container.reset()):this.map=new r(c,this.o.css,h,this.zoom_container,this.o.reaction_data,this.o.reaction_data_styles,this.o.metabolite_data,this.o.metabolite_data_styles,l,null,this.o.enable_search),this.reaction_input=t(this.o.selection,this.map,this.zoom_container),this.brush=new s(h,!1,this.map,".canvas-group"),this._setup_modes(this.map,this.brush,this.zoom_container);var p=this.o.selection.append("div").attr("class","search-menu-container").append("div").attr("class","search-menu-container-inline"),d=p.append("div"),v=p.append("div"),m=this.o.selection.append("div");this.search_bar=a(v,this.map.search_index,this.map);var g=this._get_keys(this.map,this.zoom_container,this.search_bar,this.o.enable_editing);this.map.key_manager.assigned_keys=g,this.map.key_manager.reaction_input=this.reaction_input,this.map.key_manager.search_bar=this.search_bar,this.map.key_manager.update(),this.map.key_manager.toggle(this.o.enable_keys),this.o.menu=="all"?this._setup_menu(d,m,this.map,this.zoom_container,this.map.key_manager,g,this.o.enable_editing):this.o.menu=="zoom"&&this._setup_simple_zoom_buttons(m,g);var y=this._setup_status(this.o.selection,this.map);if(this.o.map_data!==null)this.map.zoom_extent_canvas();else if(this.o.starting_reaction!==null&&l!==null){var b=this.zoom_container.get_size(),w={x:b.width/2,y:b.height/4};this.map.new_reaction_from_scratch(this.o.starting_reaction,w,90),this.map.zoom_extent_nodes()}else this.map.zoom_extent_canvas();this.o.enable_editing?this.zoom_mode():this.view_mode(),this.map.draw_everything(),this.o.on_load!==null&&this.o.on_load()}function h(e){this.search_bar.toggle(!1),this.reaction_input.toggle(e=="build"),this.reaction_input.direction_arrow.toggle(e=="build"),this.o.menu=="all"&&this.o.enable_editing&&this._toggle_direction_buttons(e=="build"),this.brush.toggle(e=="brush"),this.zoom_container.toggle_zoom(e=="zoom"||e=="view"),this.map.canvas.toggle_resize(e=="zoom"||e=="brush"),this.map.behavior.toggle_rotation_mode(e=="rotate"),this.map.behavior.toggle_node_click(e=="build"||e=="brush"),this.map.behavior.toggle_node_drag(e=="brush"),this.map.behavior.toggle_text_label_click(e=="brush"),this.map.behavior.toggle_label_drag(e=="brush"),e=="view"&&this.map.select_none(),this.map.draw_everything()}function p(){this.callback_manager.run("view_mode"),this.set_mode("view")}function d(){this.callback_manager.run("build_mode"),this.set_mode("build")}function v(){this.callback_manager.run("brush_mode"),this.set_mode("brush")}function m(){this.callback_manager.run("zoom_mode"),this.set_mode("zoom")}function g(){this.callback_manager.run("rotate_mode"),this.set_mode("rotate")}function y(e,t,n,r,s,o,a){function m(e,t){e&&console.warn(e),this.o.map_data=t,this.reload_builder()}function g(e,t){e&&console.warn(e);var n=i(t);this.map.set_model(n),this.reaction_input.toggle(!1)}function y(e,t){e&&console.warn(e),this.map.set_reaction_data(t)}function b(e,t){e&&console.warn(e),this.map.set_metabolite_data(t)}var f=e.attr("id","menu").append("ul").attr("class","nav nav-pills");u.dropdown_menu(f,"Map").button({key:o.save,text:"Save as JSON (Ctrl s)"}).button({text:"Load map JSON (Ctrl o)",input:{assign:s.assigned_keys.load,key:"fn",fn:m,target:this}}).button({key:o.save_svg,text:"Export as SVG (Ctrl Shift s)"}).button({key:o.clear_map,text:"Clear map"}),u.dropdown_menu(f,"Model").button({text:"Load COBRA model JSON (Ctrl m)",input:{assign:s.assigned_keys.load_model,key:"fn",fn:g,target:this}});var l=u.dropdown_menu(f,"Data").button({input:{assign:s.assigned_keys.load_reaction_data,key:"fn",fn:y,target:this},text:"Load reaction data"}).button({key:o.clear_reaction_data,text:"Clear reaction data"}).button({input:{fn:b,target:this},text:"Load metabolite data"}).button({key:o.clear_metabolite_data,text:"Clear metabolite data"}),c=u.dropdown_menu(f,"Edit",!0);a?c.button({key:o.build_mode,id:"build-mode-menu-button",text:"Build mode (n)"}).button({key:o.zoom_mode,id:"zoom-mode-menu-button",text:"Pan mode (z)"}).button({key:o.brush_mode,id:"brush-mode-menu-button",text:"Select mode (v)"}).button({key:o.rotate_mode,id:"rotate-mode-menu-button",text:"Rotate mode (r)"}).divider().button({key:o.delete,text:"Delete (Ctrl Del)"}).button({key:o.undo,text:"Undo (Ctrl z)"}).button({key:o.redo,text:"Redo (Ctrl Shift z)"}).button({key:o.make_primary,text:"Make primary metabolite (p)"}).button({key:o.cycle_primary,text:"Cycle primary metabolite (c)"}).button({key:o.select_none,text:"Select none (Ctrl Shift a)"}):c.button({key:o.view_mode,id:"view-mode-menu-button",text:"View mode"});var h=u.dropdown_menu(f,"View",!0).button({key:o.zoom_in,text:"Zoom in (Ctrl +)"}).button({key:o.zoom_out,text:"Zoom out (Ctrl -)"}).button({key:o.extent_nodes,text:"Zoom to nodes (Ctrl 0)"}).button({key:o.extent_canvas,text:"Zoom to canvas (Ctrl 1)"}).button({key:o.search,text:"Find (Ctrl f)"});a&&(h.button({key:o.toggle_beziers,id:"bezier-button",text:"Show control points (b)"}),n.callback_manager.set("toggle_beziers.button",function(e){f.select("#bezier-button").select(".dropdown-button-text").text((e?"Hide":"Show")+" control points (b)")}));var p=t.append("ul").attr("class","nav nav-pills nav-stacked").attr("id","button-panel");u.individual_button(p.append("li"),{key:o.zoom_in,icon:"glyphicon glyphicon-plus-sign",classes:"btn btn-default",tooltip:"Zoom in (Ctrl +)"}),u.individual_button(p.append("li"),{key:o.zoom_out,icon:"glyphicon glyphicon-minus-sign",classes:"btn btn-default",tooltip:"Zoom out (Ctrl -)"}),u.individual_button(p.append("li"),{key:o.extent_canvas,icon:"glyphicon glyphicon-resize-full",classes:"btn btn-default",tooltip:"Zoom to canvas (Ctrl 1)"});if(a){u.radio_button_group(p.append("li")).button({key:o.build_mode,id:"build-mode-button",icon:"glyphicon glyphicon-plus",tooltip:"Build mode (n)"}).button({key:o.zoom_mode,id:"zoom-mode-button",icon:"glyphicon glyphicon-move",tooltip:"Pan mode (z)"}).button({key:o.brush_mode,id:"brush-mode-button",icon:"glyphicon glyphicon-screenshot",tooltip:"Select mode (v)"}).button({key:o.rotate_mode,id:"rotate-mode-button",icon:"glyphicon glyphicon-repeat",tooltip:"Rotate mode (r)"}),this.direction_buttons=p.append("li");var d=u.button_group(this.direction_buttons).button({key:o.direction_arrow_left,icon:"glyphicon glyphicon-arrow-left",tooltip:"Direction arrow (←)"}).button({key:o.direction_arrow_right,icon:"glyphicon glyphicon-arrow-right",tooltip:"Direction arrow (→)"}).button({key:o.direction_arrow_up,icon:"glyphicon glyphicon-arrow-up",tooltip:"Direction arrow (↑)"}).button({key:o.direction_arrow_down,icon:"glyphicon glyphicon-arrow-down",tooltip:"Direction arrow (↓)"})}var v=function(e){var t=["#build-mode-menu-button","#zoom-mode-menu-button","#brush-mode-menu-button","#rotate-mode-menu-button","#view-mode-menu-button"];for(var n=0,r=t.length;n<r;n++){var i=t[n];d3.select(i).select("span").classed("glyphicon",i==e).classed("glyphicon-ok",i==e)}};this.callback_manager.set("build_mode",function(){$("#build-mode-button").button("toggle"),v("#build-mode-menu-button")}),this.callback_manager.set("zoom_mode",function(){$("#zoom-mode-button").button("toggle"),v("#zoom-mode-menu-button")}),this.callback_manager.set("brush_mode",function(){$("#brush-mode-button").button("toggle"),v("#brush-mode-menu-button")}),this.callback_manager.set("rotate_mode",function(){$("#rotate-mode-button").button("toggle"),v("#rotate-mode-menu-button")}),this.callback_manager.set("view_mode",function(){$("#view-mode-button").button("toggle"),v("#view-mode-menu-button")})}function b(e,t){var n=e.append("div").attr("id","simple-button-panel");u.individual_button(n.append("div"),{key:t.zoom_in,text:"+",classes:"simple-button",tooltip:"Zoom in (Ctrl +)"}),u.individual_button(n.append("div"),{key:t.zoom_out,text:"–",classes:"simple-button",tooltip:"Zoom out (Ctrl -)"}),u.individual_button(n.append("div"),{key:t.extent_canvas,text:"↔",classes:"simple-button",tooltip:"Zoom to canvas (Ctrl 1)"})}function w(e){e===undefined&&(e=!this.direction_buttons.style("visibility")=="visible"),this.direction_buttons.style("visibility",e?"visible":"hidden")}function E(e,t){var n=e.append("div").attr("id","status");return t.callback_manager.set("set_status",function(e){n.text(e)}),n}function S(e,t,n){var r={};e.callback_manager.set("start_rotation",function(){r.brush=t.enabled,t.toggle(!1),r.zoom=n.zoom_on,n.toggle_zoom(!1),r.node_click=e.behavior.node_click!=null,e.behavior.toggle_node_click(!1)}),e.callback_manager.set("end_rotation",function(){t.toggle(r.brush),n.toggle_zoom(r.zoom),e.behavior.toggle_node_click(r.node_click),r={}})}function x(t,n,r,i){var s={save:{key:83,modifiers:{control:!0},target:t,fn:t.save},save_svg:{key:83,modifiers:{control:!0,shift:!0},target:t,fn:t.save_svg},load:{key:79,modifiers:{control:!0},fn:null},clear_map:{target:t,fn:function(){this.clear_map()}},load_model:{key:77,modifiers:{control:!0},fn:null},load_reaction_data:{fn:null},clear_reaction_data:{target:t,fn:function(){this.set_reaction_data(null)}},load_metabolite_data:{fn:null},clear_metabolite_data:{target:t,fn:function(){this.set_metabolite_data(null)}},zoom_in:{key:187,modifiers:{control:!0},target:n,fn:n.zoom_in},zoom_out:{key:189,modifiers:{control:!0},target:n,fn:n.zoom_out},extent_nodes:{key:48,modifiers:{control:!0},target:t,fn:t.zoom_extent_nodes},extent_canvas:{key:49,modifiers:{control:!0},target:t,fn:t.zoom_extent_canvas},search:{key:70,modifiers:{control:!0},fn:r.toggle.bind(r,!0)},view_mode:{fn:this.view_mode.bind(this),ignore_with_input:!0}};return i&&e.extend(s,{build_mode:{key:78,target:this,fn:this.build_mode,ignore_with_input:!0},zoom_mode:{key:90,target:this,fn:this.zoom_mode,ignore_with_input:!0},brush_mode:{key:86,target:this,fn:this.brush_mode,ignore_with_input:!0},rotate_mode:{key:82,target:this,fn:this.rotate_mode,ignore_with_input:!0},toggle_beziers:{key:66,target:t,fn:t.toggle_beziers,ignore_with_input:!0},"delete":{key:8,modifiers:{control:!0},target:t,fn:t.delete_selected,ignore_with_input:!0},delete_del:{key:46,modifiers:{control:!0},target:t,fn:t.delete_selected,ignore_with_input:!0},make_primary:{key:80,target:t,fn:t.make_selected_node_primary,ignore_with_input:!0},cycle_primary:{key:67,target:t,fn:t.cycle_primary_node,ignore_with_input:!0},direction_arrow_right:{key:39,fn:this.reaction_input.direction_arrow.right.bind(this.reaction_input.direction_arrow),ignore_with_input:!0},direction_arrow_down:{key:40,fn:this.reaction_input.direction_arrow.down.bind(this.reaction_input.direction_arrow),ignore_with_input:!0},direction_arrow_left:{key:37,fn:this.reaction_input.direction_arrow.left.bind(this.reaction_input.direction_arrow),ignore_with_input:!0},direction_arrow_up:{key:38,fn:this.reaction_input.direction_arrow.up.bind(this.reaction_input.direction_arrow),ignore_with_input:!0},undo:{key:90,modifiers:{control:!0},target:t.undo_stack,fn:t.undo_stack.undo},redo:{key:90,modifiers:{control:!0,shift:!0},target:t.undo_stack,fn:t.undo_stack.redo},select_none:{key:65,modifiers:{control:!0,shift:!0},target:t,fn:t.select_none}}),s}var f=e.make_class();return f.prototype={init:l,reload_builder:c,set_mode:h,view_mode:p,build_mode:d,brush_mode:v,zoom_mode:m,rotate_mode:g,_toggle_direction_buttons:w,_setup_menu:y,_setup_simple_zoom_buttons:b,_setup_status:E,_setup_modes:S,_get_keys:x},f}),n("DataMenu",["utils"],function(e){return function(t){function s(e,t,n,r,i){n.node().addEventListener("change",function(){o(e,this.value,i,r)},!1);var s=t[0];u(t,n),o(e,s,i,r)}function o(t,r,i,s){e.load_the_file(t,r,function(e,t){if(e)return console.warn(e);n.data=t,s&&s(t)})}function u(e,t){t.selectAll(".menu-option").data(e).enter().append("option").attr("value",function(e){return e}).text(function(e){return e}),t.node().focus()}function a(){return n.data}var n=e.set_options(t,{selection:null,getdatafiles:null,datafiles:null,update_callback:null,target:null});if(n.selection===null)throw new Error("No selection provided for DataMenu");var r=n.selection.select(".data-menu");r.empty()&&(r=n.selection.append("div").attr("class","data-menu"));var i=r.append("form").append("select").attr("class","dropdown-menu");return n.getdatafiles?(n.datafiles&&console.warn("DataMenu: getdatafiles option overrides datafiles"),d3.json(n.getdatafiles,function(e,t){return e?console.warn(e):(s(n.target,t.data,i,n.update_callback,n.selection),null)})):n.datafiles?s(n.target,n.datafiles,i,n.update_callback,n.selection):console.warn("DataMenu: No datafiles given"),{update:u}}}),n("main",["Builder","Map","Behavior","KeyManager","DataMenu","UndoStack","CobraModel","utils","SearchIndex"],function(e,t,n,r,i,s,o,u,a){return{Builder:e,Map:t,Behavior:n,KeyManager:r,DataMenu:i,UndoStack:s,CobraModel:o,utils:u,SearchIndex:a}}),t("main")});