/**
 * almond 0.2.6 Copyright (c) 2011-2012, The Dojo Foundation All Rights Reserved.
 * Available via the MIT or new BSD license.
 * see: http://github.com/jrburke/almond for details
 */

/**
 * vkBeautify - javascript plugin to pretty-print or minify text in XML, JSON, CSS and SQL formats.
 *
 * Version - 0.99.00.beta
 * Copyright (c) 2012 Vadim Kiryukhin
 * vkiryukhin @ gmail.com
 * http://www.eslinstructor.net/vkbeautify/
 *
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 *   Pretty print
 *
 *        vkbeautify.xml(text [,indent_pattern]);
 *        vkbeautify.json(text [,indent_pattern]);
 *        vkbeautify.css(text [,indent_pattern]);
 *        vkbeautify.sql(text [,indent_pattern]);
 *
 *        @text - String; text to beatufy;
 *        @indent_pattern - Integer | String;
 *                Integer:  number of white spaces;
 *                String:   character string to visualize indentation ( can also be a set of white spaces )
 *   Minify
 *
 *        vkbeautify.xmlmin(text [,preserve_comments]);
 *        vkbeautify.jsonmin(text);
 *        vkbeautify.cssmin(text [,preserve_comments]);
 *        vkbeautify.sqlmin(text);
 *
 *        @text - String; text to minify;
 *        @preserve_comments - Bool; [optional];
 *                Set this flag to true to prevent removing comments from @text ( minxml and mincss functions only. )
 *
 *   Examples:
 *        vkbeautify.xml(text); // pretty print XML
 *        vkbeautify.json(text, 4 ); // pretty print JSON
 *        vkbeautify.css(text, '. . . .'); // pretty print CSS
 *        vkbeautify.sql(text, '----'); // pretty print SQL
 *
 *        vkbeautify.xmlmin(text, true);// minify XML, preserve comments
 *        vkbeautify.jsonmin(text);// minify JSON
 *        vkbeautify.cssmin(text);// minify CSS, remove comments ( default )
 *        vkbeautify.sqlmin(text);// minify SQL
 *
 */

/**
 * complete.ly 1.0.0
 * MIT Licensing
 * Copyright (c) 2013 Lorenzo Puccetti
 * 
 * This Software shall be used for doing good things, not bad things.
 * 
**/

(function(e,t){typeof define=="function"&&define.amd?define("escher",t):e.escher=t()})(this,function(){var e,t,n;return function(r){function d(e,t){return h.call(e,t)}function v(e,t){var n,r,i,s,o,u,a,f,c,h,p=t&&t.split("/"),d=l.map,v=d&&d["*"]||{};if(e&&e.charAt(0)===".")if(t){p=p.slice(0,p.length-1),e=p.concat(e.split("/"));for(f=0;f<e.length;f+=1){h=e[f];if(h===".")e.splice(f,1),f-=1;else if(h===".."){if(f===1&&(e[2]===".."||e[0]===".."))break;f>0&&(e.splice(f-1,2),f-=2)}}e=e.join("/")}else e.indexOf("./")===0&&(e=e.substring(2));if((p||v)&&d){n=e.split("/");for(f=n.length;f>0;f-=1){r=n.slice(0,f).join("/");if(p)for(c=p.length;c>0;c-=1){i=d[p.slice(0,c).join("/")];if(i){i=i[r];if(i){s=i,o=f;break}}}if(s)break;!u&&v&&v[r]&&(u=v[r],a=f)}!s&&u&&(s=u,o=a),s&&(n.splice(0,o,s),e=n.join("/"))}return e}function m(e,t){return function(){return s.apply(r,p.call(arguments,0).concat([e,t]))}}function g(e){return function(t){return v(t,e)}}function y(e){return function(t){a[e]=t}}function b(e){if(d(f,e)){var t=f[e];delete f[e],c[e]=!0,i.apply(r,t)}if(!d(a,e)&&!d(c,e))throw new Error("No "+e);return a[e]}function w(e){var t,n=e?e.indexOf("!"):-1;return n>-1&&(t=e.substring(0,n),e=e.substring(n+1,e.length)),[t,e]}function E(e){return function(){return l&&l.config&&l.config[e]||{}}}var i,s,o,u,a={},f={},l={},c={},h=Object.prototype.hasOwnProperty,p=[].slice;o=function(e,t){var n,r=w(e),i=r[0];return e=r[1],i&&(i=v(i,t),n=b(i)),i?n&&n.normalize?e=n.normalize(e,g(t)):e=v(e,t):(e=v(e,t),r=w(e),i=r[0],e=r[1],i&&(n=b(i))),{f:i?i+"!"+e:e,n:e,pr:i,p:n}},u={require:function(e){return m(e)},exports:function(e){var t=a[e];return typeof t!="undefined"?t:a[e]={}},module:function(e){return{id:e,uri:"",exports:a[e],config:E(e)}}},i=function(e,t,n,i){var s,l,h,p,v,g=[],w;i=i||e;if(typeof n=="function"){t=!t.length&&n.length?["require","exports","module"]:t;for(v=0;v<t.length;v+=1){p=o(t[v],i),l=p.f;if(l==="require")g[v]=u.require(e);else if(l==="exports")g[v]=u.exports(e),w=!0;else if(l==="module")s=g[v]=u.module(e);else if(d(a,l)||d(f,l)||d(c,l))g[v]=b(l);else{if(!p.p)throw new Error(e+" missing "+l);p.p.load(p.n,m(i,!0),y(l),{}),g[v]=a[l]}}h=n.apply(a[e],g);if(e)if(s&&s.exports!==r&&s.exports!==a[e])a[e]=s.exports;else if(h!==r||!w)a[e]=h}else e&&(a[e]=n)},e=t=s=function(e,t,n,a,f){return typeof e=="string"?u[e]?u[e](t):b(o(e,t).f):(e.splice||(l=e,t.splice?(e=t,t=n,n=null):e=r),t=t||function(){},typeof n=="function"&&(n=a,a=f),a?i(r,e,t,n):setTimeout(function(){i(r,e,t,n)},4),s)},s.config=function(e){return l=e,l.deps&&s(l.deps,l.callback),s},e._defined=a,n=function(e,t,n){t.splice||(n=t,t=[]),!d(a,e)&&!d(f,e)&&(f[e]=[e,t,n])},n.amd={jQuery:!0}}(),n("../build/almond",function(){}),n("lib/vkbeautify",[],function(){function e(e){var t="    ";if(isNaN(parseInt(e)))t=e;else switch(e){case 1:t=" ";break;case 2:t="  ";break;case 3:t="   ";break;case 4:t="    ";break;case 5:t="     ";break;case 6:t="      ";break;case 7:t="       ";break;case 8:t="        ";break;case 9:t="         ";break;case 10:t="          ";break;case 11:t="           ";break;case 12:t="            "}var n=["\n"];for(ix=0;ix<100;ix++)n.push(n[ix]+t);return n}function t(){this.step="    ",this.shift=e(this.step)}function n(e,t){return t-(e.replace(/\(/g,"").length-e.replace(/\)/g,"").length)}function r(e,t){return e.replace(/\s{1,}/g," ").replace(/ AND /ig,"~::~"+t+t+"AND ").replace(/ BETWEEN /ig,"~::~"+t+"BETWEEN ").replace(/ CASE /ig,"~::~"+t+"CASE ").replace(/ ELSE /ig,"~::~"+t+"ELSE ").replace(/ END /ig,"~::~"+t+"END ").replace(/ FROM /ig,"~::~FROM ").replace(/ GROUP\s{1,}BY/ig,"~::~GROUP BY ").replace(/ HAVING /ig,"~::~HAVING ").replace(/ IN /ig," IN ").replace(/ JOIN /ig,"~::~JOIN ").replace(/ CROSS~::~{1,}JOIN /ig,"~::~CROSS JOIN ").replace(/ INNER~::~{1,}JOIN /ig,"~::~INNER JOIN ").replace(/ LEFT~::~{1,}JOIN /ig,"~::~LEFT JOIN ").replace(/ RIGHT~::~{1,}JOIN /ig,"~::~RIGHT JOIN ").replace(/ ON /ig,"~::~"+t+"ON ").replace(/ OR /ig,"~::~"+t+t+"OR ").replace(/ ORDER\s{1,}BY/ig,"~::~ORDER BY ").replace(/ OVER /ig,"~::~"+t+"OVER ").replace(/\(\s{0,}SELECT /ig,"~::~(SELECT ").replace(/\)\s{0,}SELECT /ig,")~::~SELECT ").replace(/ THEN /ig," THEN~::~"+t+"").replace(/ UNION /ig,"~::~UNION~::~").replace(/ USING /ig,"~::~USING ").replace(/ WHEN /ig,"~::~"+t+"WHEN ").replace(/ WHERE /ig,"~::~WHERE ").replace(/ WITH /ig,"~::~WITH ").replace(/ ALL /ig," ALL ").replace(/ AS /ig," AS ").replace(/ ASC /ig," ASC ").replace(/ DESC /ig," DESC ").replace(/ DISTINCT /ig," DISTINCT ").replace(/ EXISTS /ig," EXISTS ").replace(/ NOT /ig," NOT ").replace(/ NULL /ig," NULL ").replace(/ LIKE /ig," LIKE ").replace(/\s{0,}SELECT /ig,"SELECT ").replace(/\s{0,}UPDATE /ig,"UPDATE ").replace(/ SET /ig," SET ").replace(/~::~{1,}/g,"~::~").split("~::~")}return t.prototype.xml=function(t,n){var r=t.replace(/>\s{0,}</g,"><").replace(/</g,"~::~<").replace(/\s*xmlns\:/g,"~::~xmlns:").replace(/\s*xmlns\=/g,"~::~xmlns=").split("~::~"),i=r.length,s=!1,o=0,u="",a=0,f=n?e(n):this.shift;for(a=0;a<i;a++)if(r[a].search(/<!/)>-1){u+=f[o]+r[a],s=!0;if(r[a].search(/-->/)>-1||r[a].search(/\]>/)>-1||r[a].search(/!DOCTYPE/)>-1)s=!1}else r[a].search(/-->/)>-1||r[a].search(/\]>/)>-1?(u+=r[a],s=!1):/^<\w/.exec(r[a-1])&&/^<\/\w/.exec(r[a])&&/^<[\w:\-\.\,]+/.exec(r[a-1])==/^<\/[\w:\-\.\,]+/.exec(r[a])[0].replace("/","")?(u+=r[a],s||o--):r[a].search(/<\w/)>-1&&r[a].search(/<\//)==-1&&r[a].search(/\/>/)==-1?u=s?u+=r[a]:u+=f[o++]+r[a]:r[a].search(/<\w/)>-1&&r[a].search(/<\//)>-1?u=s?u+=r[a]:u+=f[o]+r[a]:r[a].search(/<\//)>-1?u=s?u+=r[a]:u+=f[--o]+r[a]:r[a].search(/\/>/)>-1?u=s?u+=r[a]:u+=f[o]+r[a]:r[a].search(/<\?/)>-1?u+=f[o]+r[a]:r[a].search(/xmlns\:/)>-1||r[a].search(/xmlns\=/)>-1?u+=f[o]+r[a]:u+=r[a];return u[0]=="\n"?u.slice(1):u},t.prototype.json=function(e,t){var t=t?t:this.step;return typeof JSON=="undefined"?e:typeof e=="string"?JSON.stringify(JSON.parse(e),null,t):typeof e=="object"?JSON.stringify(e,null,t):e},t.prototype.css=function(t,n){var r=t.replace(/\s{1,}/g," ").replace(/\{/g,"{~::~").replace(/\}/g,"~::~}~::~").replace(/\;/g,";~::~").replace(/\/\*/g,"~::~/*").replace(/\*\//g,"*/~::~").replace(/~::~\s{0,}~::~/g,"~::~").split("~::~"),i=r.length,s=0,o="",u=0,a=n?e(n):this.shift;for(u=0;u<i;u++)/\{/.exec(r[u])?o+=a[s++]+r[u]:/\}/.exec(r[u])?o+=a[--s]+r[u]:/\*\\/.exec(r[u])?o+=a[s]+r[u]:o+=a[s]+r[u];return o.replace(/^\n{1,}/,"")},t.prototype.sql=function(t,i){var s=t.replace(/\s{1,}/g," ").replace(/\'/ig,"~::~'").split("~::~"),o=s.length,u=[],a=0,f=this.step,l=!0,c=!1,h=0,p="",d=0,v=i?e(i):this.shift;for(d=0;d<o;d++)d%2?u=u.concat(s[d]):u=u.concat(r(s[d],f));o=u.length;for(d=0;d<o;d++){h=n(u[d],h),/\s{0,}\s{0,}SELECT\s{0,}/.exec(u[d])&&(u[d]=u[d].replace(/\,/g,",\n"+f+f+"")),/\s{0,}\s{0,}SET\s{0,}/.exec(u[d])&&(u[d]=u[d].replace(/\,/g,",\n"+f+f+"")),/\s{0,}\(\s{0,}SELECT\s{0,}/.exec(u[d])?(a++,p+=v[a]+u[d]):/\'/.exec(u[d])?(h<1&&a&&a--,p+=u[d]):(p+=v[a]+u[d],h<1&&a&&a--);var m=0}return p=p.replace(/^\n{1,}/,"").replace(/\n{1,}/g,"\n"),p},t.prototype.xmlmin=function(e,t){var n=t?e:e.replace(/\<![ \r\n\t]*(--([^\-]|[\r\n]|-[^\-])*--[ \r\n\t]*)\>/g,"").replace(/[ \r\n\t]{1,}xmlns/g," xmlns");return n.replace(/>\s{0,}</g,"><")},t.prototype.jsonmin=function(e){return typeof JSON=="undefined"?e:JSON.stringify(JSON.parse(e),null,0)},t.prototype.cssmin=function(e,t){var n=t?e:e.replace(/\/\*([^*]|[\r\n]|(\*+([^*/]|[\r\n])))*\*+\//g,"");return n.replace(/\s{1,}/g," ").replace(/\{\s{1,}/g,"{").replace(/\}\s{1,}/g,"}").replace(/\;\s{1,}/g,";").replace(/\/\*\s{1,}/g,"/*").replace(/\*\/\s{1,}/g,"*/")},t.prototype.sqlmin=function(e){return e.replace(/\s{1,}/g," ").replace(/\s{1,}\(/,"(").replace(/\s{1,}\)/,")")},new t}),n("utils",["lib/vkbeautify"],function(e){function t(e,t){if(e===undefined)return t;var n=-1,r=t;for(var i in e){var s=e[i];s===undefined&&(s=null),r[i]=s}return r}function n(e,t,n){var r=function(e,t){e&&(d3.select("body").classed("fill-screen-body",!0),t.classed("fill-screen-div",!0));var n=t.append("svg").attr("class","escher-svg").attr("xmlns","http://www.w3.org/2000/svg");return n},i;e.classed("escher-container",!0);if(t)return e;if(e)return r(n,e);throw new Error("No selection")}function r(e){var t=e.node();while(t.hasChildNodes())t.removeChild(t.lastChild)}function i(e,t){var n="";return e&&d3.text(e,function(e,r){e&&console.warn(e),n=r,t(n)}),!1}function s(){return"omg yes"}function o(e,t,n,r){function i(e,t){return e.indexOf(t,e.length-t.length)!==-1}if(r){t&&console.warn("File "+t+" overridden by value."),n.call(e,null,r,t);return}if(!t){n.call(e,"No filename",null,t);return}i(t,"json")?d3.json(t,function(e,r){n(e,r,t)}):i(t,"css")?d3.text(t,function(e,r){n(e,r,t)}):n.call(e,"Unrecognized file type",null,t);return}function u(e,t,n){var r=-1,i=t.length,s={};while(++r<t.length){var u=t[r].file;s[u]=t[r].callback,o(e,u,function(t,r,o){s[o].call(e,t,r),--i||n.call(e)},t[r].value)}}function a(){var e,t=function(n){if(!(this instanceof t)){e=!0;var r=new t(arguments);return e=!1,r}typeof this.init=="function"&&this.init.apply(this,e?n:arguments)};return t}function f(e,t){e.select("defs").remove();var n=e.append("defs");return n.append("style").attr("type","text/css").text(t),n}function l(e,t,n,r,i,s){var o=e.select(t).selectAll(n).data(r);o.enter().call(i),o.call(s),o.exit().remove()}function c(e,t,n,r,i,s,o){var u=e.select(t).selectAll(n).data(h(r,i),function(e){return e[i]});u.enter().call(s),u.call(o),u.exit().remove()}function h(e,t){var n=[];for(var r in e){var i=v(e[r]);i[t]=r,n.push(i)}return n}function p(e,t){if(!e||!t)return!1;if(e.length!=t.length)return!1;for(var n=0,r=e.length;n<r;n++)if(e[n]!=t[n])return!1;return!0}function d(e){var t={};for(var n=0,r=e.length;n<r;n++){var i=e[n];for(var s in i)if(s in t)t[s][n]=i[s];else{var o=[];for(var u=0;u<n;u++)o[u]=null;o[n]=i[s],t[s]=o}for(var s in t)for(var u=t[s].length;u<=n;u++)t[s][u]=null}return t}function v(e){if(null==e||"object"!=typeof e)return e;if(e instanceof Array){var t=[];for(var n=0,r=e.length;n<r;n++)t[n]=v(e[n]);return t}if(e instanceof Object){var t={};for(var i in e)e.hasOwnProperty(i)&&(t[i]=v(e[i]));return t}throw new Error("Unable to copy obj! Its type isn't supported.")}function m(e,t){for(var n in t)n in e?console.error("Attribute "+n+" already in object."):e[n]=t[n]}function g(e){var t=[];return e.forEach(function(e){e.forEach(function(e){t.indexOf(e)<0&&t.push(e)})}),t}function y(e,t){return e===null||t===null||e===undefined||t===undefined?null:{x:e.x+t.x,y:e.y+t.y}}function b(e,t){return e===null||t===null||e===undefined||t===undefined?null:{x:e.x-t.x,y:e.y-t.y}}function w(e,t){return{x:e.x*t,y:e.y*t}}function E(e,t){function s(e){return window.btoa(unescape(encodeURIComponent(e)))}var n=document.createElement("a");n.download=t+".json";var r=JSON.stringify(e);n.setAttribute("href-lang","application/json"),n.href="data:application/json,"+r;var i=document.createEvent("MouseEvents");i.initMouseEvent("click",!0,!1,self,0,0,0,0,0,!1,!1,!1,!1,0,null),n.dispatchEvent(i)}function S(e,t){window.File&&window.FileReader&&window.FileList&&window.Blob||t("The File APIs are not fully supported in this browser.",null);var n=new window.FileReader;n.onload=function(e){var n=JSON.parse(e.target.result);t(null,n)},n.readAsText(e)}function x(t,n,r){function u(e){return window.btoa(unescape(encodeURIComponent(e)))}var i=document.createElement("a"),s,o;i.download=t+".svg",s=(new XMLSerializer).serializeToString(n.node()),r&&(s=e.xml(s)),s='<?xml version="1.0" encoding="utf-8"?>\n             <!DOCTYPE svg PUBLIC "-//W3C//DTD SVG 1.1//EN"\n         "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd">\n'+s,i.setAttribute("href-lang","image/svg+xml"),i.href="data:image/svg+xml;base64,"+u(s),o=document.createEvent("MouseEvents"),o.initMouseEvent("click",!0,!1,self,0,0,0,0,0,!1,!1,!1,!1,0,null),i.dispatchEvent(o)}function T(e,t,n){var r=function(e){return N(e,t,n)};return e.map(r)}function N(e,t,n){var r=Math.cos(-t)*(e.x-n.x)+Math.sin(-t)*(e.y-n.y)+n.x-e.x,i=-Math.sin(-t)*(e.x-n.x)+Math.cos(-t)*(e.y-n.y)+n.y-e.y;return{x:r,y:i}}function C(e){var t=e[1].x-e[0].x,n=e[1].y-e[0].y;return t==0&&n>=0?Math.PI/2:t==0&&n<0?3*Math.PI/2:t>=0&&n>=0?Math.atan(n/t):t>=0?Math.atan(n/t)+2*Math.PI:Math.atan(n/t)+Math.PI}function k(e){return e*180/Math.PI}function L(e,t,n){var r=Math.atan2(t.x-n.x,n.y-t.y),i=Math.atan2(t.x-n.x+e.x,n.y-t.y-e.y),s=i-r;return s}function A(e,t){return Math.sqrt(Math.pow(t.y-e.y,2)+Math.pow(t.x-e.x,2))}function O(e,t){t.map(function(n,r){e[r]===undefined&&console.error("Argument is undefined: "+String(t[r]))})}function M(e,t){return e+"_"+t}function _(e){function n(e){var t=/(.*)_([a-z0-9]{1,2})$/,n=t.exec(e);return n===null?null:n.slice(1,3)}var t=n(e);return t===null&&(t=[e,null]),t}function D(e,t,n){if(typeof t=="string"){var r;if(t=="String")r=function(e){return typeof e=="string"};else if(t=="Float")r=function(e){return typeof e=="number"};else if(t=="Integer")r=function(e){return typeof e=="number"&&parseFloat(e,10)==parseInt(e,10)};else if(t=="Boolean")r=function(e){return typeof e=="boolean"};else if(t!="*")throw new Error("Bad spec string: "+t);if(!r(e))throw new Error("Bad type: "+String(e)+" should be "+t)}else if(t instanceof Array)e.forEach(function(e){D(e,t[0],n)});else{var i=Object.keys(t)[0];if(i=="*")for(var s in e){if(e[s]===null&&n.indexOf(s)!=-1)continue;D(e[s],t[i],n)}else for(var s in t){if(!(s in e))throw new Error("Missing key: %s"%s);if(e[s]===null&&n.indexOf(s)!=-1)continue;D(e[s],t[s],n)}}}function P(e){var t=e.reduce(function(e,t){return e+t}),n=t/e.length;return n}function H(e,t){e instanceof Array&&(e=e.node());while(e.parentNode!==null){e=e.parentNode;if(e.tagName===undefined)continue;if(e.tagName.toLowerCase()===t.toLowerCase())return!0}return!1}return{set_options:t,setup_svg:n,remove_child_nodes:r,load_css:i,load_files:u,load_the_file:o,make_class:a,setup_defs:f,draw_an_array:l,draw_an_object:c,make_array:h,compare_arrays:p,array_to_object:d,clone:v,extend:m,unique_concat:g,c_plus_c:y,c_minus_c:b,c_times_scalar:w,download_json:E,load_json:S,export_svg:x,rotate_coords_recursive:T,rotate_coords:N,get_angle:C,to_degrees:k,angle_for_event:L,distance:A,check_undefined:O,compartmentalize:M,decompartmentalize:_,check_r:D,mean:P,check_for_parent_tag:H}}),n("lib/complete.ly",[],function(){return function(e,t){function h(e){return l===undefined&&(l=document.createElement("span"),l.style.visibility="hidden",l.style.position="fixed",l.style.outline="0",l.style.margin="0",l.style.padding="0",l.style.border="0",l.style.left="0",l.style.whiteSpace="pre",l.style.fontSize=t.fontSize,l.style.fontFamily=t.fontFamily,l.style.fontWeight="normal",document.body.appendChild(l)),l.innerHTML=String(e).replace(/&/g,"&amp;").replace(/"/g,"&quot;").replace(/'/g,"&#39;").replace(/</g,"&lt;").replace(/>/g,"&gt;"),l.getBoundingClientRect().right}t=t||{},t.fontSize=t.fontSize||"16px",t.fontFamily=t.fontFamily||"sans-serif",t.promptInnerHTML=t.promptInnerHTML||"",t.color=t.color||"#333",t.hintColor=t.hintColor||"#aaa",t.backgroundColor=t.backgroundColor||"#fff",t.dropDownBorderColor=t.dropDownBorderColor||"#aaa",t.dropDownZIndex=t.dropDownZIndex||"100",t.dropDownOnHoverBackgroundColor=t.dropDownOnHoverBackgroundColor||"#ddd";var n=document.createElement("input");n.type="text",n.spellcheck=!1,n.style.fontSize=t.fontSize,n.style.fontFamily=t.fontFamily,n.style.color=t.color,n.style.backgroundColor=t.backgroundColor,n.style.width="100%",n.style.outline="0",n.style.border="0",n.style.margin="0",n.style.padding="0";var r=n.cloneNode();r.disabled="",r.style.position="absolute",r.style.top="0",r.style.left="0",r.style.borderColor="transparent",r.style.boxShadow="none",r.style.color=t.hintColor,n.style.backgroundColor="transparent",n.style.verticalAlign="top",n.style.position="relative";var i=document.createElement("div");i.style.position="relative",i.style.outline="0",i.style.border="0",i.style.margin="0",i.style.padding="0";var s=document.createElement("div");s.style.position="absolute",s.style.outline="0",s.style.margin="0",s.style.padding="0",s.style.border="0",s.style.fontSize=t.fontSize,s.style.fontFamily=t.fontFamily,s.style.color=t.color,s.style.backgroundColor=t.backgroundColor,s.style.top="0",s.style.left="0",s.style.overflow="hidden",s.innerHTML=t.promptInnerHTML,s.style.background="transparent";if(document.body===undefined)throw"document.body is undefined. The library was wired up incorrectly.";document.body.appendChild(s);var o=s.getBoundingClientRect().right;i.appendChild(s),s.style.visibility="visible",s.style.left="-"+o+"px",i.style.marginLeft=o+"px",i.appendChild(r),i.appendChild(n);var u=document.createElement("div");u.style.position="absolute",u.style.visibility="hidden",u.style.outline="0",u.style.margin="0",u.style.padding="0",u.style.textAlign="left",u.style.fontSize=t.fontSize,u.style.fontFamily=t.fontFamily,u.style.backgroundColor=t.backgroundColor,u.style.zIndex=t.dropDownZIndex,u.style.cursor="default",u.style.borderStyle="solid",u.style.borderWidth="1px",u.style.borderColor=t.dropDownBorderColor,u.style.overflowX="hidden",u.style.whiteSpace="pre",u.style.overflowY="scroll";var a=function(e){var n=[],r=0,i=-1,s=function(){this.style.outline="1px solid #ddd"},o=function(){this.style.outline="0"},u=function(){a.hide(),a.onmouseselection(this.__hint)},a={hide:function(){e.style.visibility="hidden"},refresh:function(i,f){e.style.visibility="hidden",r=0,e.innerHTML="";var l=window.innerHeight||document.documentElement.clientHeight,c=e.parentNode.getBoundingClientRect(),h=c.top-6,p=l-c.bottom-6;n=[];for(var d=0;d<f.length;d++){if(f[d].indexOf(i)!==0)continue;var v=document.createElement("div");v.style.color=t.color,v.onmouseover=s,v.onmouseout=o,v.onmousedown=u,v.__hint=f[d],v.innerHTML=i+"<b>"+f[d].substring(i.length)+"</b>",n.push(v),e.appendChild(v)}if(n.length===0)return;if(n.length===1&&i===n[0].__hint)return;if(n.length<2)return;a.highlight(0),h>p*3?(e.style.maxHeight=h+"px",e.style.top="",e.style.bottom="100%"):(e.style.top="100%",e.style.bottom="",e.style.maxHeight=p+"px"),e.style.visibility="visible"},highlight:function(e){i!=-1&&n[i]&&(n[i].style.backgroundColor=t.backgroundColor),n[e].style.backgroundColor=t.dropDownOnHoverBackgroundColor,i=e},move:function(t){return e.style.visibility==="hidden"?"":r+t===-1||r+t===n.length?n[r].__hint:(r+=t,a.highlight(r),n[r].__hint)},onmouseselection:function(){}};return a},f=a(u);f.onmouseselection=function(e){n.value=r.value=c+e,p.onChange(n.value),d=n.value,setTimeout(function(){n.focus()},0)},i.appendChild(u),e.appendChild(i);var l,c,p={onArrowDown:function(){},onArrowUp:function(){},onEnter:function(){},onTab:function(){},onChange:function(){p.repaint()},startFrom:0,options:[],wrapper:i,input:n,hint:r,dropDown:u,prompt:s,setText:function(e){r.value=e,n.value=e},getText:function(){return n.value},hideDropDown:function(){f.hide()},repaint:function(){var e=n.value,t=p.startFrom,i=p.options,s=i.length,o=e.substring(t);c=e.substring(0,t),r.value="";for(var a=0;a<s;a++){var l=i[a];if(l.indexOf(o)===0){r.value=c+l;break}}u.style.left=h(c)+"px",f.refresh(o,p.options)}},d,v=function(e,t){d=e.value;var n=function(){var n=e.value;d!==n&&(d=n,t(n))};e.addEventListener?(e.addEventListener("input",n,!1),e.addEventListener("keyup",n,!1),e.addEventListener("change",n,!1)):(e.attachEvent("oninput",n),e.attachEvent("onkeyup",n),e.attachEvent("onchange",n))};v(n,function(e){p.onChange(e)});var m=function(e){e=e||window.event;var t=e.keyCode;if(t==33)return;if(t==34)return;if(t==39||t==35||t==9){t==9&&(e.preventDefault(),e.stopPropagation(),r.value.length==0&&p.onTab());if(r.value.length>0){f.hide(),n.value=r.value;var i=d!=n.value;d=n.value,i&&p.onChange(n.value)}return}if(t==13){if(r.value.length==0)p.onEnter();else{var s=u.style.visibility=="hidden";f.hide();if(s){r.value=n.value,n.focus(),p.onEnter();return}n.value=r.value;var i=d!=n.value;d=n.value,i&&p.onChange(n.value)}return}if(t==40){var o=f.move(1);o==""&&p.onArrowDown(),r.value=c+o;return}if(t==38){var o=f.move(-1);o==""&&p.onArrowUp(),r.value=c+o,e.preventDefault(),e.stopPropagation();return}r.value=""};return n.addEventListener?n.addEventListener("keydown",m,!1):n.attachEvent("onkeydown",m),p}}),n("data_styles",["utils"],function(e){function t(t,n,r){if(t===null)return null;t instanceof Array||(t=[t]);var i=function(){return t===null?null:t.length==1?null:t.length==2?null:console.warn("Bad data style: "+r)};return i(),t=e.array_to_object(t),t}function n(e,t,n){n===undefined&&(n=!1);if(e===null)return null;var r=null;e.length==1&&(r=e[0]);if(e.length==2){if(e[0]===null||e[1]===null)return null;r=e[1]-e[0]}return t.indexOf("abs")!=-1&&!n&&(r=Math.abs(r)),r}function r(e,t){return e===null?null:e.length==1?e[0]<=0:e.length==2?e[1]-e[0]<=0:!0}function i(e,t){function o(e,t){return e===null?"(nd)":t(e)}if(e===null)return o(null);var r=n(e,t,!0);if(e.length==1){var i=d3.format(".4g");return o(r,i)}if(e.length==2){var i=d3.format(".3g"),s=o(e[0],i);return s+=", "+o(e[1],i),s+=": "+o(r,i),s}return""}return{import_and_check:t,text_for_data:i,float_for_data:n,reverse_flux_for_data:r}}),n("draw",["utils","data_styles"],function(e,t){function n(e){e.on("mousedown.drag",null),e.on("touchstart.drag",null)}function r(t){e.check_undefined(arguments,["enter_selection"]),t.append("rect").attr("class","membrane")}function i(t){e.check_undefined(arguments,["enter_selection"]),t.attr("width",function(e){return e.width}).attr("height",function(e){return e.height}).attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).style("stroke-width",function(e){return 10}).attr("rx",function(e){return 20}).attr("ry",function(e){return 20})}function s(t){e.check_undefined(arguments,["enter_selection"]);var n=t.append("g").attr("id",function(e){return"r"+e.reaction_id}).attr("class","reaction").call(u);return}function o(t,n,r,i,s,o,u,c,h,p){e.check_undefined(arguments,["update_selection","scale","drawn_nodes","show_beziers","defs","default_reaction_color","has_reaction_data","reaction_data_styles","bezier_drag_behavior","label_drag_behavior"]),t.select(".reaction-label").call(function(e){return a(e,u,c,p)});var d=t.selectAll(".segment-group").data(function(t){return e.make_array(t.segments,"segment_id")},function(e){return e.segment_id});d.enter().call(f),d.call(function(e){return l(e,n,r,i,s,o,u,c,h)}),d.exit().remove()}function u(t){e.check_undefined(arguments,["sel"]),t.append("text").attr("class","reaction-label label").style("cursor","default")}function a(t,r,i,s,o){e.check_undefined(arguments,["sel","has_reaction_data","reaction_data_styles","label_drag_behavior"]);var u=d3.format(".4g");t.text(function(e){var t=e.bigg_id;return r&&i.indexOf("text")!=-1&&(t+=" "+e.data_string),t}).attr("transform",function(e){return"translate("+e.label_x+","+e.label_y+")"}).style("font-size",function(e){return String(30)+"px"}).call(n).call(s)}function f(t){e.check_undefined(arguments,["enter_selection"]);var n=t.append("g").attr("class","segment-group").attr("id",function(e){return"s"+e.segment_id});n.append("path").attr("class","segment"),n.append("g").attr("class","arrowheads"),n.append("g").attr("class","beziers")}function l(t,r,i,s,o,u,a,f,l){function d(t){e.check_undefined(arguments,["enter_selection"]);var n=t.append("g").attr("class",function(e){return"bezier-group"});n.append("circle").attr("class",function(e){return"bezier bezier"+e.bezier}).style("stroke-width",String(1)+"px").attr("r",String(7)+"px").on("mouseover",function(e){d3.select(this).style("stroke-width",String(3)+"px"),d3.select(this.parentNode.parentNode).selectAll(".connect-line").attr("visibility","visible")}).on("mouseout",function(e){d3.select(this).style("stroke-width",String(1)+"px"),d3.select(this.parentNode.parentNode).selectAll(".connect-line").attr("visibility","hidden")})}function m(t,r,i,s){function u(e){e.append("path").attr("class",function(e){return"connect-line"}).attr("visibility","hidden")}function a(e){e.attr("d",function(e){return e.x==null||e.y==null||e.source_x==null||e.source_y==null?"":"M0, 0 "+(e.source_x-e.x)+","+(e.source_y-e.y)})}e.check_undefined(arguments,["update_selection","show_beziers","drag_behavior","drawn_nodes"]),t.call(n).call(i);if(!r){t.attr("visibility","hidden");return}t.attr("visibility","visible").attr("transform",function(e){return e.x==null||e.y==null?"":"translate("+e.x+","+e.y+")"});var o=t.selectAll(".connect-line").data(function(e){var t,n,r=this.parentNode.parentNode.parentNode.__data__;return n=e.bezier==1?s[r.from_node_id]:s[r.to_node_id],t={x:e.x,y:e.y,source_x:n.x,source_y:n.y},[t]});o.enter().call(function(e){return u(e)}),o.call(function(e){return a(e)}),o.exit().remove()}e.check_undefined(arguments,["update_selection","scale","drawn_nodes","show_beziers","defs","default_reaction_color","has_reaction_data","reaction_data_styles","bezier_drag_behavior"]);var c=function(e,t){return e||t>0?32:20};t.selectAll(".segment").datum(function(){return this.parentNode.__data__}).attr("d",function(e){if(e.from_node_id==null||e.to_node_id==null)return null;var t=i[e.from_node_id],n=i[e.to_node_id],r=e.b1,s=e.b2;if(t["node_type"]=="metabolite"&&r!==null){var o=c(e.reversibility,e.from_node_coefficient),u=r===null?n:r;t=v(o,t,u,"start")}if(n["node_type"]=="metabolite"){var o=c(e.reversibility,e.to_node_coefficient),u=s===null?t:s;n=v(o,u,n,"end")}var a="M"+t.x+","+t.y+" ";return r!==null&&s!==null&&(a+="C"+r.x+","+r.y+" "+s.x+","+s.y+" "),a+=n.x+","+n.y,a}).style("stroke",function(e){if(a&&f.indexOf("color")!==-1){var t=e.data;return r.reaction_color(t===null?0:t)}return u}).style("stroke-width",function(e){if(a&&f.indexOf("size")!==-1){var t=e.data;return r.reaction_size(t===null?0:t)}return r.reaction_size(0)});var h=t.select(".arrowheads").selectAll(".arrowhead").data(function(t){var n=[],r=this.parentNode.parentNode.parentNode.__data__.reaction_id,s=this.parentNode.parentNode.__data__.segment_id,o=i[t.from_node_id],u=t.b1;if(o.node_type=="metabolite"&&(t.reversibility||t.from_node_coefficient>0)){var a=c(t.reversibility,t.from_node_coefficient),f=u===null?h:u,l=e.to_degrees(e.get_angle([o,f]))+90;o=v(a,o,f,"start"),n.push({data:t.data,x:o.x,y:o.y,rotation:l,show_arrowhead_flux:t.from_node_coefficient<0==t.reverse_flux||t.data==0})}var h=i[t.to_node_id],p=t.b2;if(h.node_type=="metabolite"&&(t.reversibility||t.to_node_coefficient>0)){var a=c(t.reversibility,t.to_node_coefficient),f=p===null?o:p,l=e.to_degrees(e.get_angle([h,f]))+90;h=v(a,f,h,"end"),n.push({data:t.data,x:h.x,y:h.y,rotation:l,show_arrowhead_flux:t.to_node_coefficient<0==t.reverse_flux||t.data==0})}return n});h.enter().append("path").classed("arrowhead",!0),h.attr("d",function(e){var t=20,n=13;if(a&&f.indexOf("size")!==-1){var i=e.data;t+=r.reaction_size(i)-r.reaction_size(0)}return"M"+[-t/2,0]+" L"+[0,n]+" L"+[t/2,0]+" Z"}).attr("transform",function(e){return"translate("+e.x+","+e.y+")rotate("+e.rotation+")"}).attr("fill",function(e){if(a&&f.indexOf("color")!==-1){if(e.show_arrowhead_flux){var t=e.data;return r.reaction_color(t===null?0:t)}return"#FFFFFF"}return u}).attr("stroke",function(e){if(a&&f.indexOf("color")!==-1){var t=e.data;return r.reaction_color(t===null?0:t)}return u}),h.exit().remove();var p=t.select(".beziers").selectAll(".bezier-group").data(function(e){var t=[],n=this.parentNode.parentNode.parentNode.__data__.reaction_id,r=this.parentNode.parentNode.__data__.segment_id;return e.b1!=null&&e.b1.x!=null&&e.b1.y!=null&&t.push({bezier:1,x:e.b1.x,y:e.b1.y,reaction_id:n,segment_id:r}),e.b2!=null&&e.b2.x!=null&&e.b2.y!=null&&t.push({bezier:2,x:e.b2.x,y:e.b2.y,reaction_id:n,segment_id:r}),t},function(e){return e.bezier});p.enter().call(function(e){return d(e)}),p.call(function(e){return m(e,s,l,i)}),p.exit().remove()}function c(t,n,r){e.check_undefined(arguments,["enter_selection","drawn_nodes","drawn_reactions"]);var i=t.append("g").attr("class","node").attr("id",function(e){return"n"+e.node_id});i.append("circle").attr("class",function(e){return e.node_type=="metabolite"?"node-circle metabolite-circle":"node-circle"}),i.filter(function(e){return e.node_type=="metabolite"}).append("text").attr("class","node-label label").style("cursor","default")}function h(t,r,i,s,o,u,a,f,l){e.check_undefined(arguments,["update_selection","scale","has_metabolite_data","metabolite_data_styles","click_fn","mouseover_fn","mouseout_fn","drag_behavior","label_drag_behavior"]);var c=t.select(".node-circle").attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).attr("r",function(e){if(e.node_type=="metabolite"){if(i&&s.indexOf("size")!==-1){var t=e.data;return r.metabolite_size(t===null?0:t)}return e.node_is_primary?15:10}return 5}).style("fill",function(e){if(e.node_type=="metabolite"){if(i&&s.indexOf("color")!==-1){var t=e.data;return r.metabolite_color(t===null?0:t)}return"rgb(224, 134, 91)"}return null}).call(n).call(f).on("click",o).on("mouseover",u).on("mouseout",a);t.select(".node-label").attr("transform",function(e){return"translate("+e.label_x+","+e.label_y+")"}).style("font-size",function(e){return String(20)+"px"}).text(function(e){var t=e.bigg_id;return i&&s.indexOf("text")!=-1&&(t+=" "+e.data_string),t}).call(n).call(l)}function p(t){e.check_undefined(arguments,["enter_selection"]),t.append("text").attr("class","text-label label").style("cursor","default").text(function(e){return e.text})}function d(t,r,i){e.check_undefined(arguments,["update_selection","label_click","label_drag_behavior"]),t.attr("transform",function(e){return"translate("+e.x+","+e.y+")"}).on("click",r).call(n).call(i)}function v(t,n,r,i){e.check_undefined(arguments,["reaction_arrow_displacement","start","end","displace"]);var s=t,o=e.distance(n,r),u,a;return(!s||!o)&&console.error("Bad value"),i=="start"?(u=n.x+s*(r.x-n.x)/o,a=n.y+s*(r.y-n.y)/o):i=="end"?(u=r.x-s*(r.x-n.x)/o,a=r.y-s*(r.y-n.y)/o):console.error("bad displace value: "+i),{x:u,y:a}}return{create_reaction:s,update_reaction:o,create_node:c,update_node:h,create_text_label:p,update_text_label:d,create_membrane:r,update_membrane:i}}),n("build",["utils"],function(e){function t(t,r,i,o,u,a,f,l){l=Math.PI/180*l;var c=String(++a.reactions),h={x:u.x,y:u.y},p=300,d=[h,e.c_plus_c(h,{x:p,y:0})],v={x:(d[0].x+d[1].x)/2,y:(d[0].y+d[1].y)/2},m;Math.abs(l)<Math.PI/4||Math.abs(l-Math.PI)<Math.PI/4?m={x:-50,y:-40}:m={x:30,y:10};var g=20,y={bigg_id:t,reversibility:r.reversibility,metabolites:e.clone(r.metabolites),label_x:v.x+m.x,label_y:v.y+m.y,name:r.name,segments:{}},b=[],w=[],E=0,S=0,x=!1;for(var T in y.metabolites){var N=i[T],C=y.metabolites[T],k=N.formula,L={coefficient:C,bigg_id:T,name:N.name};if(C<0){L.index=E;var A=/C([0-9]+)/.exec(k);u.bigg_id==L.bigg_id?b.push([L.index,Infinity]):A&&f.indexOf(e.decompartmentalize(L.bigg_id)[0])==-1&&b.push([L.index,parseInt(A[1])]),E++}else{L.index=S;var A=/C([0-9]+)/.exec(k);u.bigg_id==L.bigg_id?(w.push([L.index,Infinity]),x=!0):A&&f.indexOf(e.decompartmentalize(L.bigg_id)[0])==-1&&w.push([L.index,parseInt(A[1])]),S++}y.metabolites[T]=L}var O=function(e,t){return t[1]>e[1]?t:e},M=b.reduce(O,[0,0])[0],_=w.reduce(O,[0,0])[0];for(var T in y.metabolites){var N=y.metabolites[T];N.coefficient<0?(N.index==M&&(N.is_primary=!0),N.count=E+1):(N.index==_&&(N.is_primary=!0),N.count=S+1)}var D={},P=[{node_type:"anchor_reactants",dis:{x:g*(x?1:-1),y:0}},{node_type:"center",dis:{x:0,y:0}},{node_type:"anchor_products",dis:{x:g*(x?-1:1),y:0}}],H={};P.map(function(e){var t=String(++a.nodes),n=e.node_type=="center"?"midmarker":"multimarker";D[t]={node_type:n,x:v.x+e.dis.x,y:v.y+e.dis.y,connected_segments:[],name:null,bigg_id:null,label_x:null,label_y:null,node_is_primary:null},H[e.node_type]=t});var B=[[H.anchor_reactants,H.center],[H.anchor_products,H.center]];B.map(function(e){var t=e[0],n=e[1],r=String(++a.segments);y.segments[r]={b1:null,b2:null,from_node_id:t,to_node_id:n,from_node_coefficient:null,to_node_coefficient:null,reversibility:y.reversibility},D[t].connected_segments.push({segment_id:r,reaction_id:c}),D[n].connected_segments.push({segment_id:r,reaction_id:c})});var j=D;for(var T in y.metabolites){var N=y.metabolites[T],F,I;N.coefficient<0?(F=M,I=H.anchor_reactants):(F=_,I=H.anchor_products);var q=s(N,F,d,v,p,x);if(u.bigg_id==N.bigg_id){var R=String(++a.segments);y.segments[R]={b1:q.b1,b2:q.b2,from_node_id:I,to_node_id:o,from_node_coefficient:null,to_node_coefficient:N.coefficient,reversibility:y.reversibility},u.connected_segments.push({segment_id:R,reaction_id:c}),j[I].connected_segments.push({segment_id:R,reaction_id:c})}else{var R=String(++a.segments),U=String(++a.nodes);y.segments[R]={b1:q.b1,b2:q.b2,from_node_id:I,to_node_id:U,from_node_coefficient:null,to_node_coefficient:N.coefficient,reversibility:y.reversibility},j[U]={connected_segments:[{segment_id:R,reaction_id:c}],x:q.circle.x,y:q.circle.y,node_is_primary:Boolean(N.is_primary),label_x:q.circle.x+m.x,label_y:q.circle.y+m.y,name:N.name,bigg_id:N.bigg_id,node_type:"metabolite"},j[I].connected_segments.push({segment_id:R,reaction_id:c})}}for(var t in y.metabolites)y.metabolites[t]={coefficient:y.metabolites[t].coefficient};var z={};z[c]=y,j[o]=u;var W=n(j,z,l,h);return{new_reactions:z,new_nodes:j}}function n(t,n,r,s){var o=function(t){return t===null?null:e.rotate_coords(t,r,s)},u=[],a=[];for(var f in t){var l=t[f],c=o({x:l.x,y:l.y}),h=i(l,n,c);l.connected_segments.map(function(t){var r=n[t.reaction_id];if(r===undefined)return;var i=r.segments[t.segment_id];if(i.to_node_id==f&&i.b2){var s=o(i.b2);i.b2=e.c_plus_c(i.b2,s)}else if(i.from_node_id==f&&i.b1){var s=o(i.b1);i.b1=e.c_plus_c(i.b1,s)}}),a=e.unique_concat([a,h.reaction_ids]),u.push(f)}return{node_ids:u,reaction_ids:a}}function r(t,n,r,s){var o=i(t,r,s);return t.connected_segments.map(function(t){var i=r[t.reaction_id];if(i===undefined)return;var u=i.segments[t.segment_id];u.from_node_id==n&&u.b1&&(u.b1=e.c_plus_c(u.b1,s)),u.to_node_id==n&&u.b2&&(u.b2=e.c_plus_c(u.b2,s)),o.reaction_ids.indexOf(t.reaction_id)<0&&o.reaction_ids.push(t.reaction_id)}),o}function i(e,t,n){e.x=e.x+n.x,e.y=e.y+n.y,e.label_x=e.label_x+n.x,e.label_y=e.label_y+n.y;var r=[];return e.connected_segments.map(function(i){var s=t[i.reaction_id];r.indexOf(i.reaction_id)<0&&(r.push(i.reaction_id),e.node_type=="midmarker"&&(s.label_x=s.label_x+n.x,s.label_y=s.label_y+n.y))}),{reaction_ids:r}}function s(t,n,r,i,s,o){var u=r[0],r=[e.c_minus_c(r[0],u),e.c_minus_c(r[1],u)],i=e.c_minus_c(i,u),a=80,f=.4,l=.25,c=a*.7,h=40,p=Math.min(2,t.count-1),d,v,m;t.is_primary?d=20:(d=10,t.index>n?v=t.index-1:v=t.index);var g=s-d,y=[{x:d,y:0},{x:g,y:0}],b,w,E,S;t.coefficient<0!=o&&t.is_primary?(b={x:y[0].x,y:y[0].y},E={x:i.x*(1-f)+y[0].x*f,y:i.y*(1-f)+y[0].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[0].x,y:r[0].y}):t.coefficient<0!=o?(b={x:y[0].x+h,y:y[0].y+(c*v-c*(p-1)/2)},E={x:i.x*(1-f)+y[0].x*f,y:i.y*(1-f)+y[0].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[0].x+h,y:r[0].y+(a*v-a*(p-1)/2)}):t.coefficient>0!=o&&t.is_primary?(b={x:y[1].x,y:y[1].y},E={x:i.x*(1-f)+y[1].x*f,y:i.y*(1-f)+y[1].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[1].x,y:r[1].y}):t.coefficient>0!=o&&(b={x:y[1].x-h,y:y[1].y+(c*v-c*(p-1)/2)},E={x:i.x*(1-f)+y[1].x*f,y:i.y*(1-f)+y[1].y*f},S={x:i.x*l+b.x*(1-l),y:i.y*l+b.y*(1-l)},w={x:r[1].x-h,y:r[1].y+(a*v-a*(p-1)/2)});var x={};return x.b1=e.c_plus_c(u,E),x.b2=e.c_plus_c(u,S),x.circle=e.c_plus_c(u,w),x}return{new_reaction:t,rotate_nodes:n,move_node_and_dependents:r}}),n("Behavior",["utils","build"],function(e,t){function r(e,t){this.map=e,this.undo_stack=t,this.empty_behavior=function(){},this.rotation_mode_enabled=!1,this.rotation_drag=d3.behavior.drag(),this.node_click=null,this.node_mouseover=null,this.node_mouseout=null,this.node_drag=this.empty_behavior,this.bezier_drag=this.empty_behavior,this.reaction_label_drag=this.empty_behavior,this.node_label_drag=this.empty_behavior,this.text_label_click=null,this.text_label_drag=this.empty_behavior,this.turn_everything_on()}function i(){this.toggle_node_click(!0),this.toggle_node_drag(!0),this.toggle_text_label_click(!0),this.toggle_label_drag(!0)}function s(){this.toggle_node_click(!1),this.toggle_node_drag(!1),this.toggle_text_label_click(!1),this.toggle_label_drag(!1)}function o(n){function v(){var e=this.map.sel.selectAll("#rotation-center").data([0]),t=e.enter().append("g").attr("id","rotation-center");t.append("path").attr("d","M-22 0 L22 0").attr("class","rotation-center-line"),t.append("path").attr("d","M0 -22 L0 22").attr("class","rotation-center-line"),e.attr("transform","translate("+this.center.x+","+this.center.y+")").attr("visibility","visible"),e.call(d3.behavior.drag().on("drag",function(e){var t=d3.transform(e.attr("transform")),n=[d3.event.dx+t.translate[0],d3.event.dy+t.translate[1]];e.attr("transform","translate("+n+")"),this.center={x:n[0],y:n[1]}}.bind(this,e))),e.on("mouseover",function(){var e=parseFloat(this.selectAll("path").style("stroke-width"));this.selectAll("path").style("stroke-width",e*2+"px")}.bind(e)),e.on("mouseout",function(){this.selectAll("path").style("stroke-width",null)}.bind(e))}function m(e){this.map.sel.select("#rotation-center").attr("visibility","hidden")}function g(t){var n=[],r=[];for(var i in t){var s=t[i];s.x!==undefined&&n.push(s.x),s.y!==undefined&&r.push(s.y)}return{x:e.mean(n),y:e.mean(r)}}n===undefined?this.rotation_mode_enabled=!this.rotation_mode_enabled:this.rotation_mode_enabled=n;var r=this.map.sel.selectAll(".node-circle"),i=this.map.sel.selectAll("#canvas");if(this.rotation_mode_enabled){this.map.callback_manager.run("start_rotation");var s=this.map.get_selected_nodes();if(Object.keys(s).length==0){console.log("No selected nodes");return}this.center=g(s),v.call(this);var o=this.map,u=Object.keys(s),a=this.map.reactions,f=this.map.nodes,l=function(e){d3.event.sourceEvent.stopPropagation()},c=function(n,r,i,u){var f=e.angle_for_event(r,u,this.center),l=t.rotate_nodes(s,a,f,this.center);o.draw_these_nodes(l.node_ids),o.draw_these_reactions(l.reaction_ids)}.bind(this),h=function(e){},p=function(n,r,i){var s=e.angle_for_event(r,i,this.center),l={};u.forEach(function(e){l[e]=f[e]});var c=t.rotate_nodes(l,a,-s,e.clone(this.center));o.draw_these_nodes(c.node_ids),o.draw_these_reactions(c.reaction_ids)}.bind(this),d=function(n,r,i){var s=e.angle_for_event(r,i,this.center),l={};u.forEach(function(e){l[e]=f[e]});var c=t.rotate_nodes(l,a,s,e.clone(this.center));o.draw_these_nodes(c.node_ids),o.draw_these_reactions(c.reaction_ids)}.bind(this);this.rotation_drag=this.get_generic_drag(l,c,h,p,d,this.map.sel),i.call(this.rotation_drag)}else m.call(this),r.on("mousedown.center",null),i.on("mousedown.center",null),i.on("mousedown.drag",null),i.on("touchstart.drag",null),this.rotation_drag=null}function u(e){e===undefined&&(e=this.node_click==null);if(e){var t=this.map;this.node_click=function(e){t.select_metabolite(this,e),d3.event.stopPropagation()},this.node_mouseover=function(e){d3.select(this).style("stroke-width",null);var t=parseFloat(d3.select(this).style("stroke-width"));d3.select(this).style("stroke-width",t*2+"px")},this.node_mouseout=function(e){d3.select(this).style("stroke-width",null)}}else this.node_click=null,this.node_mouseover=null,this.node_mouseout=null,this.map.sel.select("#nodes").selectAll(".node-circle").style("stroke-width",null)}function a(e){e===undefined&&(e=this.text_label_click==null);if(e){var t=this.map;this.text_label_click=function(e){t.select_text_label(this,e),d3.event.stopPropagation()}}else this.text_label_click=null}function f(e){e===undefined&&(e=this.node_drag===this.empty_behavior),e?(this.node_drag=this.get_node_drag(this.map,this.undo_stack),this.bezier_drag=this.get_bezier_drag(this.map,this.undo_stack)):(this.node_drag=this.empty_behavior,this.bezier_drag=this.empty_behavior)}function l(e){e===undefined&&(e=this.label_drag===this.empty_behavior),e?(this.reaction_label_drag=this.get_reaction_label_drag(this.map),this.node_label_drag=this.get_node_label_drag(this.map),this.text_label_drag=this.get_text_label_drag(this.map)):(this.reaction_label_drag=this.empty_behavior,this.node_label_drag=this.empty_behavior,this.text_label_drag=this.empty_behavior)}function c(n,r){function f(t,r){var i=n.nodes[r],s=n.nodes[t],o=[];return i.connected_segments.forEach(function(i){var u=n.reactions[i.reaction_id].segments[i.segment_id];if(u.from_node_id==r)u.from_node_id=t;else{if(u.to_node_id!=r)return console.error("Segment does not connect to dragged node");u.to_node_id=t}return s.connected_segments.push(i),o.push(e.clone(i)),null}),n.delete_node_data([r]),n.sel.selectAll(".node-to-combine").classed("node-to-combine",!1),n.draw_everything(),o}var i=d3.behavior.drag(),s=null,o=null,u=null,a=null;return i.on("dragstart",function(){var e=this.parentNode.__data__,t=e.bigg_id,r=this.parentNode;d3.event.sourceEvent.stopPropagation(),s={},a=window.setTimeout(function(){r.parentNode.insertBefore(r,r.parentNode.firstChild)},200),n.sel.selectAll(".metabolite-circle").on("mouseover.combine",function(n){n.bigg_id==t&&n.node_id!=e.node_id&&d3.select(this).style("stroke-width",String(12)+"px").classed("node-to-combine",!0)}).on("mouseout.combine",function(e){e.bigg_id==t&&n.sel.selectAll(".node-to-combine").style("stroke-width",String(2)+"px").classed("node-to-combine",!1)})}),i.on("drag",function(){var r=this.parentNode.__data__.node_id,i=n.get_selected_node_ids();o=[],i.indexOf(r)==-1?o.push(r):o=i,u=[],o.forEach(function(r){var i=n.nodes[r],o={x:d3.event.dx,y:d3.event.dy},a=t.move_node_and_dependents(i,r,n.reactions,o);u=e.unique_concat([u,a.reaction_ids]),r in s||(s[r]={x:0,y:0}),s[r]=e.c_plus_c(s[r],o)}),n.draw_these_nodes(o),n.draw_these_reactions(u)}),i.on("dragend",function(){if(o===null){s=null,o=null,u=null,a=null;return}var i=[];n.sel.selectAll(".node-to-combine").each(function(e){i.push(e.node_id)});if(i.length==1){var l=i[0],c=this.parentNode.__data__.node_id,h=e.clone(n.nodes[c]),p=f(l,c);r.push(function(){n.nodes[c]=h;var e=n.nodes[l],t=[];p.forEach(function(r){var i=n.reactions[r.reaction_id].segments[r.segment_id];i.from_node_id==l?i.from_node_id=c:i.to_node_id==l?i.to_node_id=c:console.error("Segment does not connect to fixed node"),e.connected_segments=e.connected_segments.filter(function(e){return e.reaction_id!=r.reaction_id||e.segment_id!=r.segment_id}),t.indexOf(r.reaction_id)==-1&&t.push(r.reaction_id)}),n.draw_these_nodes([c]),n.draw_these_reactions(t)},function(){f(l,c)})}else{var d=e.clone(s),v=e.clone(o),m=e.clone(u);r.push(function(){v.forEach(function(r){var i=n.nodes[r];t.move_node_and_dependents(i,r,n.reactions,e.c_times_scalar(d[r],-1))}),n.draw_these_nodes(v),n.draw_these_reactions(m)},function(){v.forEach(function(e){var r=n.nodes[e];t.move_node_and_dependents(r,e,n.reactions,d[e])}),n.draw_these_nodes(v),n.draw_these_reactions(m)})}n.sel.selectAll(".metabolite-circle").on("mouseover.combine",null).on("mouseout.combine",null),window.clearTimeout(a),s=null,o=null,u=null,a=null}),i}function h(t){var n=function(n,r,i,s){var o=t.reactions[n].segments[r];o["b"+i]=e.c_plus_c(o["b"+i],s)},r=function(e){},i=function(e,r,i){n(e.reaction_id,e.segment_id,e.bezier,r),t.draw_these_reactions([e.reaction_id])},s=function(e){},o=function(r,i){n(r.reaction_id,r.segment_id,r.bezier,e.c_times_scalar(i,-1)),t.draw_these_reactions([r.reaction_id])},u=function(e,r){n(e.reaction_id,e.segment_id,e.bezier,r),t.draw_these_reactions([e.reaction_id])};return this.get_generic_drag(r,i,s,o,u,this.map.sel)}function p(t){var n=function(e,n){var r=t.reactions[e];r.label_x=r.label_x+n.x,r.label_y=r.label_y+n.y},r=function(e){},i=function(e,r,i){n(e.reaction_id,r),t.draw_these_reactions([e.reaction_id])},s=function(e){},o=function(r,i){n(r.reaction_id,e.c_times_scalar(i,-1)),t.draw_these_reactions([r.reaction_id])},u=function(e,r){n(e.reaction_id,r),t.draw_these_reactions([e.reaction_id])};return this.get_generic_drag(r,i,s,o,u,this.map.sel)}function d(t){var n=function(e,n){var r=t.nodes[e];r.label_x=r.label_x+n.x,r.label_y=r.label_y+n.y},r=function(e){},i=function(e,r,i){n(e.node_id,r),t.draw_these_nodes([e.node_id])},s=function(e){},o=function(r,i){n(r.node_id,e.c_times_scalar(i,-1)),t.draw_these_nodes([r.node_id])},u=function(e,r){n(e.node_id,r),t.draw_these_nodes([e.node_id])};return this.get_generic_drag(r,i,s,o,u,this.map.sel)}function v(t){var n=function(e,n){var r=t.text_labels[e];r.x=r.x+n.x,r.y=r.y+n.y},r=function(e){},i=function(e,r,i){n(e.text_label_id,r),t.draw_these_text_labels([e.text_label_id])},s=function(e){},o=function(r,i){n(r.text_label_id,e.c_times_scalar(i,-1)),t.draw_these_text_labels([r.text_label_id])},u=function(e,r){n(e.text_label_id,r),t.draw_these_text_labels([e.text_label_id])};return this.get_generic_drag(r,i,s,o,u,this.map.sel)}function m(t,n,r,i,s,o){var u=d3.behavior.drag(),a,f=this.undo_stack,l=o.node();return u.on("dragstart",function(e){d3.event.sourceEvent.stopPropagation(),a={x:0,y:0},t(e)}),u.on("drag",function(t){var r={x:d3.event.dx,y:d3.event.dy},i={x:d3.mouse(l)[0],y:d3.mouse(l)[1]};a=e.c_plus_c(a,r),n(t,r,a,i)}),u.on("dragend",function(t){var n=e.clone(t),o=e.clone(a),u={x:d3.mouse(l)[0],y:d3.mouse(l)[1]};f.push(function(){i(n,o,u)},function(){s(n,o,u)}),r(t)}),u}var n=e.make_class();return n.prototype={init:r,toggle_rotation_mode:o,turn_everything_on:i,turn_everything_off:s,toggle_node_click:u,toggle_node_drag:f,toggle_text_label_click:a,toggle_label_drag:l,get_node_drag:c,get_bezier_drag:h,get_reaction_label_drag:p,get_node_label_drag:d,get_text_label_drag:v,get_generic_drag:m},n}),n("Scale",["utils"],function(e){function n(){this.x=d3.scale.linear(),this.y=d3.scale.linear(),this.x_size=d3.scale.linear(),this.y_size=d3.scale.linear(),this.size=d3.scale.linear(),this.reaction_color=d3.scale.linear(),this.reaction_size=d3.scale.linear(),this.metabolite_size=d3.scale.linear(),this.metabolite_color=d3.scale.linear(),this.scale_path=function(e){var t=this.x,n=this.y,r=d3.format(".2f"),e=e.replace(/(M|L)([0-9-.]+),?\s*([0-9-.]+)/g,function(e,i,s,o){return i+[r(t(parseFloat(s))),r(n(parseFloat(o)))].join(", ")}),i=/C([0-9-.]+),?\s*([0-9-.]+)\s*([0-9-.]+),?\s*([0-9-.]+)\s*([0-9-.]+),?\s*([0-9-.]+)/g;return e=e.replace(i,function(e,i,s,o,u,a,f){return"C"+r(t(parseFloat(i)))+","+r(n(parseFloat(s)))+" "+r(t(parseFloat(o)))+","+r(n(parseFloat(u)))+" "+[r(t(parseFloat(a)))+","+r(n(parseFloat(f)))]}),e}.bind(this),this.scale_decimals=function(e,t,n){var r=d3.format("."+String(n)+"f");return e=e.replace(/([0-9.]+)/g,function(e,n){return r(t(parseFloat(n)))}),e}}function r(e){e.domain_stream.reaction.onValue(function(e){this.reaction_color.domain(e),this.reaction_size.domain(e)}.bind(this)),e.domain_stream.metabolite.onValue(function(e){this.metabolite_color.domain(e),this.metabolite_size.domain(e)}.bind(this)),e.range_stream.reaction.color.onValue(function(e){this.reaction_color.range(e)}.bind(this)),e.range_stream.reaction.size.onValue(function(e){this.reaction_size.range(e)}.bind(this)),e.range_stream.metabolite.color.onValue(function(e){this.metabolite_color.range(e)}.bind(this)),e.range_stream.metabolite.size.onValue(function(e){this.metabolite_size.range(e)}.bind(this))}var t=e.make_class();return t.prototype={init:n,connect_to_settings:r},t}),n("UndoStack",["utils"],function(e){function n(){var e=40;this.stack=Array(e),this.current=-1,this.oldest=-1,this.newest=-1,this.end_of_stack=!0,this.top_of_stack=!0}function r(e,t){this.current=o(this.current,this.stack.length),this.end_of_stack?this.oldest=this.current:this.oldest==this.current&&(this.oldest=o(this.oldest,this.stack.length)),this.stack[this.current]={undo:e,redo:t},this.newest=this.current,this.top_of_stack=!0,this.end_of_stack=!1}function i(){if(this.end_of_stack)return console.warn("End of stack.");this.stack[this.current].undo(),this.current==this.oldest?this.end_of_stack=!0:this.current=u(this.current,this.stack.length),this.top_of_stack=!1}function s(){if(this.top_of_stack)return console.warn("Top of stack.");this.end_of_stack||(this.current=o(this.current,this.stack.length)),this.stack[this.current].redo(),this.current==this.newest&&(this.top_of_stack=!0),this.end_of_stack=!1}function o(e,t){return e+1>t-1?0:e+1}function u(e,t){return e-1<0?t-1:e-1}var t=e.make_class();return t.prototype={init:n,push:r,undo:i,redo:s},t}),n("CallbackManager",["utils"],function(e){function n(){}function r(e,t){return this.callbacks===undefined&&(this.callbacks={}),this.callbacks[e]===undefined&&(this.callbacks[e]=[]),this.callbacks[e].push(t),this}function i(e){return(this.callbacks===undefined||Object.keys(this.callbacks).length==0)&&console.warn("No callbacks to remove"),delete this.callbacks[e],this}function s(e){if(this.callbacks===undefined)return this;var t=Array.prototype.slice.call(arguments,1);for(var n in this.callbacks){var r=n.split(".")[0];r==e&&this.callbacks[n].forEach(function(e){e.apply(null,t)})}return this}var t=e.make_class();return t.prototype={init:n,set:r,remove:i,run:s},t}),n("KeyManager",["utils"],function(e){function n(e){e.command=!1,e.control=!1,e.option=!1,e.shift=!1}function r(e,t,r){e===undefined?this.assigned_keys={}:this.assigned_keys=e,t===undefined?this.input_list=[]:this.input_list=t,r===undefined&&(r=!0),this.ctrl_equals_cmd=r,this.held_keys={},n(this.held_keys),this.enabled=!0,this.update()}function i(){function o(e,t,n,r){for(var i in e)e[i]==n&&(t[i]=r)}function u(t,n,r,i){if(t.key!=n)return!1;var s=e.clone(t.modifiers);s===undefined&&(s={control:!1,command:!1,option:!1,shift:!1});for(var o in r){if(i&&s.control&&(o=="command"||o=="command_right"||o=="control")&&(r.command||r.command_right||r.control))continue;s[o]===undefined&&(s[o]=!1);if(s[o]!=r[o])return!1}return!0}var t=this.held_keys,r=this.assigned_keys,i=this,s={command:91,command_right:93,control:17,option:18,shift:16};d3.select(window).on("keydown.key_manager",null),d3.select(window).on("keyup.key_manager",null);if(!this.enabled)return;d3.select(window).on("keydown.key_manager",function(e,i){var a=d3.event.keyCode,f=!0,l=!1;i.forEach(function(e){e.is_visible()&&(l=!0)}),o(s,t,a,!0);for(var c in r){var h=r[c];if(u(h,a,t,e)){f=!1;if(!h.ignore_with_input||!l)h.fn?h.fn.call(h.target):console.warn("No function for key"),d3.event.preventDefault()}}for(var p in s)s[p]==a&&(f=!1);f&&n(t)}.bind(null,this.ctrl_equals_cmd,this.input_list)).on("keyup.key_manager",function(){o(s,t,d3.event.keyCode,!1)})}function s(e){e===undefined&&(e=!this.enabled),this.enabled=e,this.update()}function o(e){this.add_key_listener(e,13)}function u(e){this.add_key_listener(e,27)}function a(e,t){var n=d3.select(window);return n.on("keydown."+t,function(){d3.event.keyCode==t&&e()}),{clear:function(){n.on("keydown."+t,null)}}}var t=e.make_class();return t.reset_held_keys=n,t.prototype={init:r,update:i,toggle:s,add_escape_listener:u,add_enter_listener:o,add_key_listener:a},t}),n("Canvas",["utils","CallbackManager"],function(e,t){function r(e,n){this.selection=e,this.x=n.x,this.y=n.y,this.width=n.width,this.height=n.height,this.resize_enabled=!0,this.callback_manager=new t,this.setup()}function i(e){e===undefined&&(e=!this.resize_enabled),e?this.selection.selectAll(".drag-rect").style("pointer-events","auto"):this.selection.selectAll(".drag-rect").style("pointer-events","none")}function s(){function v(){d3.event.sourceEvent.stopPropagation()}function m(e,t,n){var r=d3.transform(n),i=r.translate;return e!==null&&(i[0]=e),t!==null&&(i[1]=t),"translate("+i+")"}function g(t){var i=t.x;t.x=Math.min(t.x+e.width-n/2,d3.event.x),e.x=t.x,e.width=e.width+(i-t.x),c.attr("transform",function(e){return m(e.x-n/2,null,c.attr("transform"))}),s.attr("transform",function(e){return m(e.x,null,s.attr("transform"))}).attr("width",e.width*r),o.attr("transform",function(e){return m(e.x,null,o.attr("transform"))}).attr("width",e.width),p.attr("transform",function(e){return m(e.x+n/2,null,p.attr("transform"))}).attr("width",e.width-n),d.attr("transform",function(e){return m(e.x+n/2,null,d.attr("transform"))}).attr("width",e.width-n),e.callback_manager.run("resize")}function y(t){d3.event.sourceEvent.stopPropagation();var i=Math.max(t.x+n/2,t.x+e.width+d3.event.dx);e.width=i-t.x,h.attr("transform",function(e){return m(i-n/2,null,h.attr("transform"))}),s.attr("width",e.width*r),o.attr("width",e.width),p.attr("width",e.width-n),d.attr("width",e.width-n),e.callback_manager.run("resize")}function b(t){d3.event.sourceEvent.stopPropagation();var i=t.y;t.y=Math.min(t.y+e.height-n/2,d3.event.y),e.y=t.y,e.height=e.height+(i-t.y),p.attr("transform",function(e){return m(null,e.y-n/2,p.attr("transform"))}),s.attr("transform",function(e){return m(null,e.y,s.attr("transform"))}).attr("width",e.height*r),o.attr("transform",function(e){return m(null,e.y,o.attr("transform"))}).attr("height",e.height),c.attr("transform",function(e){return m(null,e.y+n/2,c.attr("transform"))}).attr("height",e.height-n),h.attr("transform",function(e){return m(null,e.y+n/2,h.attr("transform"))}).attr("height",e.height-n),e.callback_manager.run("resize")}function w(t){d3.event.sourceEvent.stopPropagation();var i=Math.max(t.y+n/2,t.y+e.height+d3.event.dy);e.height=i-t.y,d.attr("transform",function(e){return m(null,i-n/2,d.attr("transform"))}),s.attr("height",e.height*r),o.attr("height",e.height),c.attr("height",e.height-n),h.attr("height",e.height-n),e.callback_manager.run("resize")}var e=this,t={x:this.width,y:this.height},n=20,r=10,i=this.selection.append("g").classed("canvas-group",!0).data([{x:this.x,y:this.y}]),s=i.append("rect").attr("id","mouse-node").attr("width",this.width*r).attr("height",this.height*r).attr("transform","translate("+[e.x-this.width*r/2,e.y-this.height*r/2]+")").attr("pointer-events","all");this.mouse_node=s;var o=i.append("rect").attr("id","canvas").attr("width",this.width).attr("height",this.height).attr("transform","translate("+[e.x,e.y]+")"),u=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",y),a=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",g),f=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",b),l=d3.behavior.drag().origin(Object).on("dragstart",v).on("drag",w),c=i.append("rect").classed("drag-rect",!0).attr("transform",function(e){return"translate("+[e.x-n/2,e.y+n/2]+")"}).attr("height",this.height-n).attr("id","dragleft").attr("width",n).attr("cursor","ew-resize").classed("resize-rect",!0).call(a),h=i.append("rect").classed("drag-rect",!0).attr("transform",function(t){return"translate("+[t.x+e.width-n/2,t.y+n/2]+")"}).attr("id","dragright").attr("height",this.height-n).attr("width",n).attr("cursor","ew-resize").classed("resize-rect",!0).call(u),p=i.append("rect").classed("drag-rect",!0).attr("transform",function(e){return"translate("+[e.x+n/2,e.y-n/2]+")"}).attr("height",n).attr("id","dragtop").attr("width",this.width-n).attr("cursor","ns-resize").classed("resize-rect",!0).call(f),d=i.append("rect").classed("drag-rect",!0).attr("transform",function(t){return"translate("+[t.x+n/2,t.y+e.height-n/2]+")"}).attr("id","dragbottom").attr("height",n).attr("width",this.width-n).attr("cursor","ns-resize").classed("resize-rect",!0).call(l)}function o(){return{x:this.x,y:this.y,width:this.width,height:this.height}}var n=e.make_class();return n.prototype={init:r,toggle_resize:i,setup:s,size_and_location:o},n}),n("SearchIndex",["utils"],function(e){function n(){this.index={}}function r(e,t,n,r){if(!n&&e in this.index)throw new Error("id is already in the index");if(!(!r||"name"in t&&"data"in t))throw new Error("malformed record");this.index[e]=t}function i(e){return e in this.index?(delete this.index[e],!0):!1}function s(e){var t=RegExp(e,"i"),n=[];for(var r in this.index){var i=this.index[r];t.exec(i.name)&&n.push(i.data)}return n}var t=e.make_class();return t.prototype={init:n,insert:r,remove:i,find:s},t}),function(){var e,t,r,i,s,o,u,a,f,l,c,h,p,d,v,m,g,y,b,w,E,S,x,T,N,C,k,L,A,O,M,_,D,P,H,B,j,F,I,q,R,U,z,W,X,V,$,J,K,Q,G,Y,Z,et,tt,nt,rt,it,st,ot,ut,at,ft,lt,ct,ht=[].slice,pt={}.hasOwnProperty,dt=function(e,t){function r(){this.constructor=e}for(var n in t)pt.call(t,n)&&(e[n]=t[n]);return r.prototype=t.prototype,e.prototype=new r,e.__super__=t.prototype,e},vt=function(e,t){return function(){return e.apply(t,arguments)}};e={toString:function(){return"Bacon"}},e.version="0.7.12",e.fromBinder=function(t,n){return n==null&&(n=lt.id),new c(_(e,"fromBinder",t,n),function(r){var i;return i=t(function(){var t,s,o,u,a,f;t=1<=arguments.length?ht.call(arguments,0):[],u=n.apply(null,t),I(u)&&lt.last(u)instanceof l||(u=[u]),o=e.more;for(a=0,f=u.length;a<f;a++){s=u[a],o=r(s=rt(s));if(o===e.noMore||s.isEnd())return i!=null?i():e.scheduler.setTimeout(function(){return i()},0),o}return o})})},e.$={asEventStream:function(t,n,r){var i;return R(n)&&(i=[n,null],r=i[0],n=i[1]),at(this.selector||this,"asEventStream",t,e.fromBinder(function(e){return function(r){return e.on(t,n,r),function(){return e.off(t,n,r)}}}(this),r))}},(ct=typeof jQuery!=="undefined"&&jQuery!==null?jQuery:typeof Zepto!=="undefined"&&Zepto!==null?Zepto:null)!=null&&(ct.fn.asEventStream=e.$.asEventStream),e.fromEventTarget=function(t,n,r){var i,s,o,u,a,f;return i=(o=t.addEventListener)!=null?o:(u=t.addListener)!=null?u:t.bind,s=(a=t.removeEventListener)!=null?a:(f=t.removeListener)!=null?f:t.unbind,at(e,"fromEventTarget",t,n,e.fromBinder(function(e){return i.call(t,n,e),function(){return s.call(t,n,e)}},r))},e.fromPromise=function(t,n){return at(e,"fromPromise",t,e.fromBinder(function(e){return t.then(e,function(t){return e(new f(t))}),function(){if(n)return typeof t.abort=="function"?t.abort():void 0}},function(e){return[e,D()]}))},e.noMore=["<no-more>"],e.more=["<more>"],e.later=function(t,n){return at(e,"later",t,n,e.sequentially(t,[n]))},e.sequentially=function(t,n){var r;return r=0,at(e,"sequentially",t,n,e.fromPoll(t,function(){var e;return e=n[r++],r<n.length?e:r===n.length?[e,D()]:D()}))},e.repeatedly=function(t,n){var r;return r=0,at(e,"repeatedly",t,n,e.fromPoll(t,function(){return n[r++%n.length]}))},e.spy=function(e){return tt.push(e)},tt=[],et=function(e){var t,n,r,i;if(tt.length&&!et.running)try{et.running=!0,i=[];for(n=0,r=tt.length;n<r;n++)t=tt[n],i.push(t(e));return i}finally{delete et.running}},ft=function(e){return function(){var t,n,r,i;return r=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],typeof r=="object"&&t.length&&(n=r,i=t[0],r=function(){return n[i].apply(n,arguments)},t=t.slice(1)),e.apply(null,[r].concat(ht.call(t)))}},W=function(t,n){return ft(function(){var r,i,s;return i=arguments[0],r=2<=arguments.length?ht.call(arguments,1):[],s=Y(n,[function(e,t){return i.apply(null,ht.call(e).concat([t]))}]),at.apply(null,[e,t,i].concat(ht.call(r),[e.combineAsArray(r).flatMap(s)]))})},e.fromCallback=W("fromCallback",function(){var t,n;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],e.fromBinder(function(e){return X(n,t)(e),G},function(e){return[e,D()]})}),e.fromNodeCallback=W("fromNodeCallback",function(){var t,n;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],e.fromBinder(function(e){return X(n,t)(e),G},function(e,t){return e?[new f(e),D()]:[t,D()]})}),e.fromPoll=function(t,n){return at(e,"fromPoll",t,n,e.fromBinder(function(n){var r;return r=e.scheduler.setInterval(n,t),function(){return e.scheduler.clearInterval(r)}},n))},e.interval=function(t,n){return n==null&&(n={}),at(e,"interval",t,n,e.fromPoll(t,function(){return Q(n)}))},e.constant=function(t){return new m(_(e,"constant",t),function(e){return e(F(t)),e(D()),G})},e.never=function(){return at(e,"never",e.fromArray([]))},e.once=function(t){return at(e,"once",t,e.fromArray([t]))},e.fromArray=function(t){return x(t),t=L(t),new c(_(e,"fromArray",t),function(n){var r,i;return i=!1,r=function(){var s,o;if(lt.empty(t))return n(D());o=t.splice(0,1)[0],s=n(rt(o));if(s!==e.noMore&&!i)return r()},r(),function(){return i=!0}})},e.mergeAll=function(){var t;return t=1<=arguments.length?ht.call(arguments,0):[],I(t[0])&&(t=t[0]),t.length?new c(_.apply(null,[e,"mergeAll"].concat(ht.call(t))),function(n){var r,i,s;return r=0,s=function(i){return function(s){return i.subscribeInternal(function(i){var o;return i.isEnd()?(r++,r===t.length?n(D()):e.more):(o=n(i),o===e.noMore&&s(),o)})}},i=lt.map(s,t),A.apply(null,i)}):e.never()},e.zipAsArray=function(){var t;return t=1<=arguments.length?ht.call(arguments,0):[],I(t[0])&&(t=t[0]),at.apply(null,[e,"zipAsArray"].concat(ht.call(t),[e.zipWith(t,function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],e})]))},e.zipWith=function(){var t,n,r;return t=arguments[0],n=2<=arguments.length?ht.call(arguments,1):[],R(t)||(r=[t,n[0]],n=r[0],t=r[1]),n=lt.map(function(e){return e.toEventStream()},n),at.apply(null,[e,"zipWith",t].concat(ht.call(n),[e.when(n,t)]))},e.groupSimultaneous=function(){var n,r,i;return i=1<=arguments.length?ht.call(arguments,0):[],i.length===1&&I(i[0])&&(i=i[0]),r=function(){var e,r,s;s=[];for(e=0,r=i.length;e<r;e++)n=i[e],s.push(new t(n));return s}(),at.apply(null,[e,"groupSimultaneous"].concat(ht.call(i),[e.when(r,function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],e})]))},e.combineAsArray=function(){var t,n,r,i,s,o,u;s=1<=arguments.length?ht.call(arguments,0):[],s.length===1&&I(s[0])&&(s=s[0]);for(t=o=0,u=s.length;o<u;t=++o)i=s[t],U(i)||(s[t]=e.constant(i));return s.length?(r=function(){var e,t,r;r=[];for(e=0,t=s.length;e<t;e++)n=s[e],r.push(new b(n,!0,n.subscribeInternal));return r}(),at.apply(null,[e,"combineAsArray"].concat(ht.call(s),[e.when(r,function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],e}).toProperty()]))):e.constant([])},e.onValues=function(){var t,n,r;return n=2<=arguments.length?ht.call(arguments,0,r=arguments.length-1):(r=0,[]),t=arguments[r++],e.combineAsArray(n).onValues(t)},e.combineWith=function(){var t,n;return t=arguments[0],n=2<=arguments.length?ht.call(arguments,1):[],at.apply(null,[e,"combineWith",t].concat(ht.call(n),[e.combineAsArray(n).map(function(e){return t.apply(null,e)})]))},e.combineTemplate=function(t){var n,r,i,s,o,u,a,f,l,c;return a=[],c=[],u=function(e){return e[e.length-1]},l=function(e,t,n){return u(e)[t]=n},n=function(e,t){return function(n,r){return l(n,e,r[t])}},o=function(e,t){return function(n){return l(n,e,t)}},f=function(e){return I(e)?[]:{}},i=function(e,t){var r,i;return U(t)?(c.push(t),a.push(n(e,c.length-1))):t!==Object(t)||typeof t=="function"||t instanceof RegExp||t instanceof Date?a.push(o(e,t)):(i=function(e){return function(n){var r;return r=f(t),l(n,e,r),n.push(r)}},r=function(e){return e.pop()},a.push(i(e)),s(t),a.push(r))},s=function(e){return lt.each(e,i)},s(t),r=function(e){var n,r,i,s,o;i=f(t),n=[i];for(s=0,o=a.length;s<o;s++)r=a[s],r(n,e);return i},at(e,"combineTemplate",t,e.combineAsArray(c).map(r))},e.retry=function(t){var n,r,i,s,o,u;if(!R(t.source))throw"'source' option has to be a function";return u=t.source,s=t.retries||0,i=t.maxRetries||s,n=t.interval||function(){return 0},r=t.isRetryable||function(){return!0},o=function(t){var o;return o={source:u,retries:s-1,maxRetries:i,interval:n,isRetryable:r},e.later(n(t)).filter(!1).concat(e.retry(o))},at(e,"retry",t,u().flatMapError(function(t){return r(t)&&s>0?o({error:t,retriesDone:i-s}):e.once(new e.Error(t))}))},P=0,l=function(){function e(){this.id=++P}return e.prototype.isEvent=function(){return!0},e.prototype.isEnd=function(){return!1},e.prototype.isInitial=function(){return!1},e.prototype.isNext=function(){return!1},e.prototype.isError=function(){return!1},e.prototype.hasValue=function(){return!1},e.prototype.filter=function(){return!0},e.prototype.inspect=function(){return this.toString()},e.prototype.log=function(){return this.toString()},e}(),p=function(e){function t(e){t.__super__.constructor.call(this),R(e)?this.value=lt.cached(e):this.value=lt.always(e)}return dt(t,e),t.prototype.isNext=function(){return!0},t.prototype.hasValue=function(){return!0},t.prototype.fmap=function(e){var t;return t=this.value,this.apply(function(){return e(t())})},t.prototype.apply=function(e){return new t(e)},t.prototype.filter=function(e){return e(this.value())},t.prototype.toString=function(){return lt.toString(this.value())},t.prototype.log=function(){return this.value()},t}(l),h=function(e){function t(){return t.__super__.constructor.apply(this,arguments)}return dt(t,e),t.prototype.isInitial=function(){return!0},t.prototype.isNext=function(){return!1},t.prototype.apply=function(e){return new t(e)},t.prototype.toNext=function(){return new p(this.value)},t}(p),a=function(e){function t(){return t.__super__.constructor.apply(this,arguments)}return dt(t,e),t.prototype.isEnd=function(){return!0},t.prototype.fmap=function(){return this},t.prototype.apply=function(){return this},t.prototype.toString=function(){return"<end>"},t}(l),f=function(e){function t(e){this.error=e}return dt(t,e),t.prototype.isError=function(){return!0},t.prototype.fmap=function(){return this},t.prototype.apply=function(){return this},t.prototype.toString=function(){return"<error> "+lt.toString(this.error)},t}(l),j=0,v=function(){function t(e){this.flatMapError=vt(this.flatMapError,this),this.id=++j,at(e,this)}return t.prototype.onValue=function(){var e;return e=V(arguments),this.subscribe(function(t){if(t.hasValue())return e(t.value())})},t.prototype.onValues=function(e){return this.onValue(function(t){return e.apply(null,t)})},t.prototype.onError=function(){var e;return e=V(arguments),this.subscribe(function(t){if(t.isError())return e(t.error)})},t.prototype.onEnd=function(){var e;return e=V(arguments),this.subscribe(function(t){if(t.isEnd())return e()})},t.prototype.errors=function(){return at(this,"errors",this.filter(function(){return!1}))},t.prototype.filter=function(){var t,n;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],M(this,n,t,function(t){return at(this,"filter",t,this.withHandler(function(n){return n.filter(t)?this.push(n):e.more}))})},t.prototype.takeWhile=function(){var t,n;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],M(this,n,t,function(t){return at(this,"takeWhile",t,this.withHandler(function(n){return n.filter(t)?this.push(n):(this.push(D()),e.noMore)}))})},t.prototype.endOnError=function(){var e,t;return t=arguments[0],e=2<=arguments.length?ht.call(arguments,1):[],t==null&&(t=!0),M(this,t,e,function(e){return at(this,"endOnError",this.withHandler(function(t){return t.isError()&&e(t.error)?(this.push(t),this.push(D())):this.push(t)}))})},t.prototype.take=function(t){return t<=0?e.never():at(this,"take",t,this.withHandler(function(n){return n.hasValue()?(t--,t>0?this.push(n):(t===0&&this.push(n),this.push(D()),e.noMore)):this.push(n)}))},t.prototype.map=function(){var e,t;return t=arguments[0],e=2<=arguments.length?ht.call(arguments,1):[],t instanceof m?t.sampledBy(this,B):M(this,t,e,function(e){return at(this,"map",e,this.withHandler(function(t){return this.push(t.fmap(e))}))})},t.prototype.mapError=function(){var e;return e=V(arguments),at(this,"mapError",e,this.withHandler(function(t){return t.isError()?this.push(Q(e(t.error))):this.push(t)}))},t.prototype.mapEnd=function(){var t;return t=V(arguments),at(this,"mapEnd",t,this.withHandler(function(n){return n.isEnd()?(this.push(Q(t(n))),this.push(D()),e.noMore):this.push(n)}))},t.prototype.doAction=function(){var e;return e=V(arguments),at(this,"doAction",e,this.withHandler(function(t){return t.hasValue()&&e(t.value()),this.push(t)}))},t.prototype.skip=function(t){return at(this,"skip",t,this.withHandler(function(n){return n.hasValue()?t>0?(t--,e.more):this.push(n):this.push(n)}))},t.prototype.skipDuplicates=function(e){return e==null&&(e=function(e,t){return e===t}),at(this,"skipDuplicates",this.withStateMachine(d,function(t,n){return n.hasValue()?n.isInitial()||t===d||!e(t.get(),n.value())?[new y(n.value()),[n]]:[t,[]]:[t,[n]]}))},t.prototype.skipErrors=function(){return at(this,"skipErrors",this.withHandler(function(t){return t.isError()?e.more:this.push(t)}))},t.prototype.withStateMachine=function(t,n){var r;return r=t,at(this,"withStateMachine",t,n,this.withHandler(function(t){var i,s,o,u,a,f,l;i=n(r,t),s=i[0],u=i[1],r=s,a=e.more;for(f=0,l=u.length;f<l;f++){o=u[f],a=this.push(o);if(a===e.noMore)return a}return a}))},t.prototype.scan=function(t,n,r){var i,s,o,u;return s=nt(n),n=r?s:function(e,t){return s(e(),t())},i=ot(t).map(function(e){return lt.always(e)}),u=function(t){return function(r){var s,u,a,f;return s=!1,f=G,u=e.more,a=function(){if(!s)return i.forEach(function(t){s=!0,u=r(new h(t));if(u===e.noMore)return f(),f=G})},f=t.subscribeInternal(function(t){var o,f;if(t.hasValue())return s&&t.isInitial()?e.more:(t.isInitial()||a(),s=!0,f=i.getOrElse(function(){return void 0}),o=lt.cached(function(){return n(f,t.value)}),i=new y(o),r(t.apply(o)));t.isEnd()&&(u=a());if(u!==e.noMore)return r(t)}),w.whenDoneWith(o,a),f}}(this),o=new m(_(this,"scan",t,n),u)},t.prototype.fold=function(e,t){return at(this,"fold",e,t,this.scan(e,t).sampledBy(this.filter(!1).mapEnd().toProperty()))},t.prototype.zip=function(t,n){return n==null&&(n=Array),at(this,"zip",t,e.zipWith([this,t],n))},t.prototype.diff=function(e,t){return t=nt(t),at(this,"diff",e,t,this.scan([e],function(e,n){return[n,t(e[0],n)]}).filter(function(e){return e.length===2}).map(function(e){return e[1]}))},t.prototype.flatMap=function(){return H(this,K(arguments))},t.prototype.flatMapFirst=function(){return H(this,K(arguments),!0)},t.prototype.flatMapLatest=function(){var e,t;return e=K(arguments),t=this.toEventStream(),at(this,"flatMapLatest",e,t.flatMap(function(n){return J(e(n)).takeUntil(t)}))},t.prototype.flatMapError=function(t){return at(this,"flatMapError",t,this.mapError(function(t){return new e.Error(t)}).flatMap(function(n){return n instanceof e.Error?t(n.error):e.once(n)}))},t.prototype.not=function(){return at(this,"not",this.map(function(e){return!e}))},t.prototype.log=function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],this.subscribe(function(t){return typeof console!="undefined"&&console!==null?typeof console.log=="function"?console.log.apply(console,ht.call(e).concat([t.log()])):void 0:void 0}),this},t.prototype.slidingWindow=function(e,t){return t==null&&(t=0),at(this,"slidingWindow",e,t,this.scan([],function(t,n){return t.concat([n]).slice(-e)}).filter(function(e){return e.length>=t}))},t.prototype.combine=function(t,n){var r;return r=nt(n),at(this,"combine",t,n,e.combineAsArray(this,t).map(function(e){return r(e[0],e[1])}))},t.prototype.decode=function(t){return at(this,"decode",t,this.combine(e.combineTemplate(t),function(e,t){return t[e]}))},t.prototype.awaiting=function(t){return at(this,"awaiting",t,e.groupSimultaneous(this,t).map(function(e){var t,n;return t=e[0],n=e[1],n.length===0}).toProperty(!1).skipDuplicates())},t.prototype.name=function(e){return this.toString=function(){return e},this},t.prototype.withDescription=function(){return _.apply(null,arguments).apply(this)},t}(),v.prototype.reduce=v.prototype.fold,v.prototype.assign=v.prototype.onValue,H=function(t,n,r){return new c(_(t,"flatMap"+(r?"First":""),n),function(s){var o,u;return u=new i,o=function(e){e();if(u.empty())return s(D())},u.add(function(i,a){return t.subscribeInternal(function(t){var i;return t.isEnd()?o(a):t.isError()?s(t):r&&u.count()>1?e.more:u.unsubscribed?e.noMore:(i=J(n(t.value())),u.add(function(t,n){return i.subscribeInternal(function(r){var i;return r.isEnd()?(o(n),e.noMore):(r instanceof h&&(r=r.toNext()),i=s(r),i===e.noMore&&t(),i)})}))})}),u.unsubscribe})},c=function(t){function n(e,t){var r;R(e)&&(t=e,e=[]),n.__super__.constructor.call(this,e),N(t),r=new u(t),this.subscribeInternal=r.subscribe,this.subscribe=w.wrappedSubscribe(this),this.hasSubscribers=r.hasSubscribers,et(this)}return dt(n,t),n.prototype.delay=function(t){return at(this,"delay",t,this.flatMap(function(n){return e.later(t,n)}))},n.prototype.debounce=function(t){return at(this,"debounce",t,this.flatMapLatest(function(n){return e.later(t,n)}))},n.prototype.debounceImmediate=function(t){return at(this,"debounceImmediate",t,this.flatMapFirst(function(n){return e.once(n).concat(e.later(t).filter(!1))}))},n.prototype.throttle=function(e){return at(this,"throttle",e,this.bufferWithTime(e).map(function(e){return e[e.length-1]}))},n.prototype.bufferWithTime=function(e){return at(this,"bufferWithTime",e,this.bufferWithTimeOrCount(e,Number.MAX_VALUE))},n.prototype.bufferWithCount=function(e){return at(this,"bufferWithCount",e,this.bufferWithTimeOrCount(void 0,e))},n.prototype.bufferWithTimeOrCount=function(e,t){var n;return n=function(n){if(n.values.length===t)return n.flush();if(e!==void 0)return n.schedule()},at(this,"bufferWithTimeOrCount",e,t,this.buffer(e,n,n))},n.prototype.buffer=function(t,n,r){var i,s,o;return n==null&&(n=function(){}),r==null&&(r=function(){}),i={scheduled:!1,end:null,values:[],flush:function(){var t;this.scheduled=!1;if(this.values.length>0){t=this.push(Q(this.values)),this.values=[];if(this.end!=null)return this.push(this.end);if(t!==e.noMore)return r(this)}else if(this.end!=null)return this.push(this.end)},schedule:function(){if(!this.scheduled)return this.scheduled=!0,t(function(e){return function(){return e.flush()}}(this))}},o=e.more,R(t)||(s=t,t=function(t){return e.scheduler.setTimeout(t,s)}),at(this,"buffer",this.withHandler(function(e){return i.push=this.push,e.isError()?o=this.push(e):e.isEnd()?(i.end=e,i.scheduled||i.flush()):(i.values.push(e.value()),n(i)),o}))},n.prototype.merge=function(t){var n;return T(t),n=this,at(n,"merge",t,e.mergeAll(this,t))},n.prototype.toProperty=function(e){return arguments.length===0&&(e=d),at(this,"toProperty",e,this.scan(e,z,!0))},n.prototype.toEventStream=function(){return this},n.prototype.sampledBy=function(e,t){return at(this,"sampledBy",e,t,this.toProperty().sampledBy(e,t))},n.prototype.concat=function(e){var t;return t=this,new n(_(t,"concat",e),function(n){var r,i;return i=G,r=t.subscribeInternal(function(t){return t.isEnd()?i=e.subscribeInternal(n):n(t)}),function(){return r(),i()}})},n.prototype.takeUntil=function(t){var n;return n={},at(this,"takeUntil",t,e.groupSimultaneous(this.mapEnd(n),t.skipErrors()).withHandler(function(r){var i,s,o,u,a,f;if(!r.hasValue())return this.push(r);f=r.value(),i=f[0],t=f[1];if(t.length)return this.push(D());s=e.more;for(u=0,a=i.length;u<a;u++)o=i[u],o===n?s=this.push(D()):s=this.push(Q(o));return s}))},n.prototype.skipUntil=function(e){var t;return t=e.take(1).map(!0).toProperty(!1),at(this,"skipUntil",e,this.filter(t))},n.prototype.skipWhile=function(){var t,n,r;return n=arguments[0],t=2<=arguments.length?ht.call(arguments,1):[],r=!1,M(this,n,t,function(t){return at(this,"skipWhile",t,this.withHandler(function(n){return r||!n.hasValue()||!t(n.value())?(n.hasValue()&&(r=!0),this.push(n)):e.more}))})},n.prototype.startWith=function(t){return at(this,"startWith",t,e.once(t).concat(this))},n.prototype.withHandler=function(e){var t;return t=new u(this.subscribeInternal,e),new n(_(this,"withHandler",e),t.subscribe)},n}(v),m=function(t){function n(e,t,r){R(e)&&(r=t,t=e,e=[]),n.__super__.constructor.call(this,e),N(t),r===!0?this.subscribeInternal=t:this.subscribeInternal=(new g(this,t,r)).subscribe,this.subscribe=w.wrappedSubscribe(this),et(this)}return dt(n,t),n.prototype.sampledBy=function(t,r){var i,s,o,u,a;return r!=null?r=nt(r):(i=!0,r=function(e){return e()}),a=new b(this,!1,this.subscribeInternal,i),o=new b(t,!0,t.subscribeInternal,i),u=e.when([a,o],r),s=t instanceof n?u.toProperty():u,at(this,"sampledBy",t,r,s)},n.prototype.sample=function(t){return at(this,"sample",t,this.sampledBy(e.interval(t,{})))},n.prototype.changes=function(){return new c(_(this,"changes"),function(e){return function(t){return e.subscribeInternal(function(e){if(!e.isInitial())return t(e)})}}(this))},n.prototype.withHandler=function(e){return new n(_(this,"withHandler",e),this.subscribeInternal,e)},n.prototype.toProperty=function(){return C(arguments),this},n.prototype.toEventStream=function(){return new c(_(this,"toEventStream"),function(e){return function(t){return e.subscribeInternal(function(e){return e.isInitial()&&(e=e.toNext()),t(e)})}}(this))},n.prototype.and=function(e){return at(this,"and",e,this.combine(e,function(e,t){return e&&t}))},n.prototype.or=function(e){return at(this,"or",e,this.combine(e,function(e,t){return e||t}))},n.prototype.delay=function(e){return this.delayChanges("delay",e,function(t){return t.delay(e)})},n.prototype.debounce=function(e){return this.delayChanges("debounce",e,function(t){return t.debounce(e)})},n.prototype.throttle=function(e){return this.delayChanges("throttle",e,function(t){return t.throttle(e)})},n.prototype.delayChanges=function(){var e,t,n;return e=2<=arguments.length?ht.call(arguments,0,n=arguments.length-1):(n=0,[]),t=arguments[n++],at.apply(null,[this].concat(ht.call(e),[E(this,t(this.changes()))]))},n.prototype.takeUntil=function(e){var t;return t=this.changes().takeUntil(e),at(this,"takeUntil",e,E(this,t))},n.prototype.startWith=function(e){return at(this,"startWith",e,this.scan(e,function(e,t){return t}))},n}(v),M=function(e,t,n,r){var i;return t instanceof m?(i=t.sampledBy(e,function(e,t){return[e,t]}),r.apply(i,[function(e){var t,n;return t=e[0],n=e[1],t}]).map(function(e){var t,n;return t=e[0],n=e[1],n})):(t=X(t,n),r.apply(e,[t]))},E=function(t,n){var r;return r=new c(_(t,"justInitValue"),function(n){var i,s;return s=null,i=t.subscribeInternal(function(t){return t.hasValue()&&(s=t),e.noMore}),w.whenDoneWith(r,function(){return s!=null&&n(s),n(D())}),i}),r.concat(n).toProperty()},u=function(){function t(t,n){var r,i,s,o,u,a,f,l,c,h;t==null&&(t=function(){return G}),l=[],a=[],u=!1,i=!1,this.hasSubscribers=function(){return l.length>0},s=null,c=G,f=function(e){return l=lt.without(e,l)},h=null,r=function(){var e,t,n,r,i;if(h!=null){t=h,h=null,i=[];for(n=0,r=t.length;n<r;n++)e=t[n],i.push(e());return i}},o=function(t){var n,i,o,h,p,d;if(!u){if(t===s)return;t.isError()&&(s=t),o=!1;try{u=!0,h=l;for(p=0,d=h.length;p<d;p++)i=h[p],n=i.sink(t),(n===e.noMore||t.isEnd())&&f(i);o=!0}finally{u=!1,o||(a=[])}o=!0;while(a.length)t=a.shift(),this.push(t);return r(t),this.hasSubscribers()?e.more:(c(),e.noMore)}return a.push(t),e.more},this.push=function(e){return function(t){return w.inTransaction(t,e,o,[t])}}(this),n==null&&(n=function(e){return this.push(e)}),this.handleEvent=function(e){return function(t){return t.isEnd()&&(i=!0),n.apply(e,[t])}}(this),this.subscribe=function(e){return function(n){var r,s;return i?(n(D()),G):(N(n),r={sink:n},l.push(r),l.length===1&&(s=t(e.handleEvent),c=function(){return s(),c=G}),N(c),function(){f(r);if(!e.hasSubscribers())return c()})}}(this)}return t}(),g=function(t){function n(t,r,i){var s,o,u,a;n.__super__.constructor.call(this,r,i),s=d,o=void 0,a=this.push,r=this.subscribe,u=!1,this.push=function(e){return function(t){return t.isEnd()&&(u=!0),t.hasValue()&&(s=new y(t),o=w.currentEventId()),a.apply(e,[t])}}(this),this.subscribe=function(n){return function(i){var a,f,l,c,h;return f=!1,c=e.more,l=function(){return c===e.noMore?G:u?(i(D()),G):r.apply(this,[i])},s.isDefined&&(n.hasSubscribers()||u)?(a=w.currentEventId(),h=o,!u&&h&&a&&a!==h?(w.whenDoneWith(t,function(){if(o===h)return i(F(s.get().value()))}),l()):(w.inTransaction(void 0,n,function(){return c=i(F(s.get().value()))},[]),l())):l()}}(this)}return dt(n,t),n}(u),r=function(t){function n(){var t,r,i,s,o,u,a,l;i=void 0,u=[],t=!1,r=function(t){return function(t){return function(n){return n.isEnd()?(l(t),e.noMore):i(n)}}}(this),a=function(){var e,t,n,r;r=[];for(t=0,n=u.length;t<n;t++)e=u[t],r.push(typeof e.unsub=="function"?e.unsub():void 0);return r},o=function(e){return e.unsub=e.input.subscribeInternal(r(e.input))},l=function(e){var t,n,r,i;for(t=r=0,i=u.length;r<i;t=++r){n=u[t];if(n.input===e){typeof n.unsub=="function"&&n.unsub(),u.splice(t,1);return}}},s=function(e){return function(e){var t,n,r,s;i=e,s=L(u);for(n=0,r=s.length;n<r;n++)t=s[n],o(t);return a}}(this),n.__super__.constructor.call(this,_(e,"Bus"),s),this.plug=function(e){return function(e){var n;if(t)return;return n={input:e},u.push(n),i!=null&&o(n),function(){return l(e)}}}(this),this.push=function(e){return function(e){return typeof i=="function"?i(Q(e)):void 0}}(this),this.error=function(e){return function(e){return typeof i=="function"?i(new f(e)):void 0}}(this),this.end=function(e){return function(){return t=!0,a(),typeof i=="function"?i(D()):void 0}}(this)}return dt(n,t),n}(c),b=function(){function e(e,t,n,r){this.obs=e,this.sync=t,this.subscribe=n,this.lazy=r!=null?r:!1,this.queue=[],this.subscribe==null&&(this.subscribe=this.obs.subscribeInternal),this.toString=this.obs.toString}return e.prototype.markEnded=function(){return this.ended=!0},e.prototype.consume=function(){return this.lazy?lt.always(this.queue[0]):this.queue[0]},e.prototype.push=function(e){return this.queue=[e]},e.prototype.mayHave=function(){return!0},e.prototype.hasAtLeast=function(){return this.queue.length},e.prototype.flatten=!0,e}(),s=function(e){function t(){return t.__super__.constructor.apply(this,arguments)}return dt(t,e),t.prototype.consume=function(){return this.queue.shift()},t.prototype.push=function(e){return this.queue.push(e)},t.prototype.mayHave=function(e){return!this.ended||this.queue.length>=e},t.prototype.hasAtLeast=function(e){return this.queue.length>=e},t.prototype.flatten=!1,t}(b),t=function(e){function t(e){this.obs=e,t.__super__.constructor.call(this,this.obs,!0,this.obs.subscribeInternal)}return dt(t,e),t.prototype.consume=function(){var e;return e=this.queue,this.queue=[],function(){return e}},t.prototype.push=function(e){return this.queue.push(e())},t.prototype.hasAtLeast=function(){return!0},t}(b),b.isTrigger=function(e){return e instanceof b?e.sync:e instanceof c},b.fromObservable=function(e){return e instanceof b?e:e instanceof m?new b(e,!1):new s(e,!0)},_=function(){var e,t,n;return t=arguments[0],n=arguments[1],e=3<=arguments.length?ht.call(arguments,2):[],(t||n)instanceof o?t||n:new o(t,n,e)},o=function(){function e(e,t,n){var r,i,s,o;s=function(e){return I(e)?lt.flatMap(s,e):U(e)?[e]:e instanceof b?[e.obs]:[]},o=null,r=function(e){var t,n,i,s,u;n=e.internalDeps(),u=[];for(i=0,s=n.length;i<s;i++)t=n[i],o[t.id]=!0,u.push(r(t));return u},i=function(e){return o==null&&(o={},r(this)),o[e.id]},this.apply=function(r){var o;return o=lt.cached(function(){return s([e].concat(n))}),r.internalDeps=r.internalDeps||o,r.dependsOn=i,r.deps=o,r.toString=function(){return lt.toString(e)+"."+lt.toString(t)+"("+lt.map(lt.toString,n)+")"},r.inspect=function(){return r.toString()},r.desc=function(){return{context:e,method:t,args:n}},r}}return e}(),at=function(){var e,t,n;return e=2<=arguments.length?ht.call(arguments,0,n=arguments.length-1):(n=0,[]),t=arguments[n++],_.apply(null,e).apply(t)},e.when=function(){var t,n,r,i,s,o,u,a,f,l,h,p,d,v,m,g,y,E,x,T;l=1<=arguments.length?ht.call(arguments,0):[];if(l.length===0)return e.never();s=l.length,m="when: expecting arguments in the form (Observable+,function)+",S(m,s%2===0),d=[],f=[],n=0;while(n<s){a=lt.toArray(l[n]),t=l[n+1],u={f:R(t)?t:function(){return t},ixs:[]},v=!1;for(g=0,E=a.length;g<E;g++){p=a[g],r=lt.indexOf(d,p),v||(v=b.isTrigger(p)),r<0&&(d.push(p),r=d.length-1),T=u.ixs;for(y=0,x=T.length;y<x;y++)i=T[y],i.index===r&&i.count++;u.ixs.push({index:r,count:1})}S("At least one EventStream required",v||!a.length),a.length>0&&f.push(u),n+=2}return d.length?(d=lt.map(b.fromObservable,d),o=lt.any(d,function(e){return e.flatten})&&O(lt.map(function(e){return e.obs},d)),h=new c(_.apply(null,[e,"when"].concat(ht.call(l))),function(t){var r,i,s,u,a,l,c;return c=[],s=!1,u=function(e){var t,r,i;i=e.ixs;for(t=0,r=i.length;t<r;t++){n=i[t];if(!d[n.index].hasAtLeast(n.count))return!1}return!0},i=function(e){return!e.sync||e.ended},r=function(e){var t,r,i;i=e.ixs;for(t=0,r=i.length;t<r;t++){n=i[t];if(!d[n.index].mayHave(n.count))return!0}},a=function(e){return!e.source.flatten},l=function(l){return function(p){var v,m,g;return m=function(){return w.whenDoneWith(h,v)},g=function(){var r,i,s,l,h,p;if(!(c.length>0))return e.more;s=e.more,l=c.pop();for(h=0,p=f.length;h<p;h++){i=f[h];if(u(i))return r=function(){var e,t,r,s;r=i.ixs,s=[];for(e=0,t=r.length;e<t;e++)n=r[e],s.push(d[n.index].consume());return s}(),s=t(l.e.apply(function(){var e,t;return t=function(){var t,n,i;i=[];for(t=0,n=r.length;t<n;t++)e=r[t],i.push(e());return i}(),i.f.apply(i,t)})),c.length&&o&&(c=lt.filter(a,c)),s===e.noMore?s:g()}},v=function(){var n;n=g();if(s){s=!1;if(lt.all(d,i)||lt.all(f,r))n=e.noMore,t(D())}return n===e.noMore&&p(),n},l.subscribe(function(n){var r;return n.isEnd()?(s=!0,l.markEnded(),m()):n.isError()?r=t(n):(l.push(n.value),l.sync&&(c.push({source:l,e:n}),o?m():v())),r===e.noMore&&p(),r||e.more})}},A.apply(null,function(){var e,t,n;n=[];for(e=0,t=d.length;e<t;e++)p=d[e],n.push(l(p));return n}())})):e.never()},O=function(t,n){var r;return n==null&&(n=[]),r=function(t){var i;return e._.contains(n,t)?!0:(i=t.internalDeps(),i.length?(n.push(t),e._.any(i,r)):(n.push(t),!1))},e._.any(t,r)},e.update=function(){var t,n,r,i;n=arguments[0],i=2<=arguments.length?ht.call(arguments,1):[],r=function(e){return function(){var t;return t=1<=arguments.length?ht.call(arguments,0):[],function(n){return e.apply(null,[n].concat(t))}}},t=i.length-1;while(t>0)i[t]instanceof Function||(i[t]=function(e){return function(){return e}}(i[t])),i[t]=r(i[t]),t-=2;return at.apply(null,[e,"update",n].concat(ht.call(i),[e.when.apply(e,i).scan(n,function(e,t){return t(e)})]))},A=function(){var e;return e=1<=arguments.length?ht.call(arguments,0):[],(new i(e)).unsubscribe},i=function(){function e(e){var t,n,r;e==null&&(e=[]),this.unsubscribe=vt(this.unsubscribe,this),this.unsubscribed=!1,this.subscriptions=[],this.starting=[];for(n=0,r=e.length;n<r;n++)t=e[n],this.add(t)}return e.prototype.add=function(e){var t,n,r;if(this.unsubscribed)return;return t=!1,n=G,this.starting.push(e),r=function(r){return function(){if(r.unsubscribed)return;return t=!0,r.remove(n),lt.remove(e,r.starting)}}(this),n=e(this.unsubscribe,r),!this.unsubscribed&&!t&&this.subscriptions.push(n),lt.remove(e,this.starting),n},e.prototype.remove=function(e){if(this.unsubscribed)return;if(lt.remove(e,this.subscriptions)!==void 0)return e()},e.prototype.unsubscribe=function(){var e,t,n,r;if(this.unsubscribed)return;this.unsubscribed=!0,r=this.subscriptions;for(t=0,n=r.length;t<n;t++)e=r[t],e();return this.subscriptions=[],this.starting=[]},e.prototype.count=function(){return this.unsubscribed?0:this.subscriptions.length+this.starting.length},e.prototype.empty=function(){return this.count()===0},e}(),e.CompositeUnsubscribe=i,y=function(){function e(e){this.value=e}return e.prototype.getOrElse=function(){return this.value},e.prototype.get=function(){return this.value},e.prototype.filter=function(t){return t(this.value)?new e(this.value):d},e.prototype.map=function(t){return new e(t(this.value))},e.prototype.forEach=function(e){return e(this.value)},e.prototype.isDefined=!0,e.prototype.toArray=function(){return[this.value]},e.prototype.inspect=function(){return"Some("+this.value+")"},e.prototype.toString=function(){return this.inspect()},e}(),d={getOrElse:function(e){return e},filter:function(){return d},map:function(){return d},forEach:function(){},isDefined:!1,toArray:function(){return[]},inspect:function(){return"None"},toString:function(){return this.inspect()}},w=function(){var t,n,r,i,s,o,u,a,f,l,c;return a=void 0,f=[],n=[],t=function(e){return a?n.push(e):e()},u=function(e){return!lt.any(f,function(t){return e.obs.dependsOn(t.obs)})},l=function(e,t){return a?f.push({obs:e,f:t}):t()},i=function(){while(!u(f[0]))f.push(f.splice(0,1)[0]);return f.splice(0,1)[0]},s=function(){var e;e=[];while(f.length)e.push(i().f());return e},o=function(e,t,r,i){var o;if(a)return r.apply(t,i);a=e;try{o=r.apply(t,i),s()}finally{a=void 0;while(n.length)r=n.splice(0,1)[0],r()}return o},r=function(){return a?a.id:void 0},c=function(n){return function(r){var i,s,o;return o=!1,i=function(){},s=function(){return o=!0,i()},o||(i=n.subscribeInternal(function(n){return t(function(){var t;if(!o){t=r(n);if(t===e.noMore)return s()}})})),s}},{whenDoneWith:l,inTransaction:o,currentEventId:r,wrappedSubscribe:c}}(),e.EventStream=c,e.Property=m,e.Observable=v,e.Bus=r,e.Initial=h,e.Next=p,e.End=a,e.Error=f,G=function(){},z=function(e,t){return t()},B=function(e,t){return e},F=function(e){return new h(lt.always(e))},Q=function(e){return new p(lt.always(e))},D=function(){return new a},rt=function(e){return e instanceof l?e:Q(e)},L=function(e){return e.slice(0)},S=function(e,t){if(!t)throw e},T=function(e){if(!(e instanceof c))throw"not an EventStream : "+e},N=function(e){return S("not a function : "+e,R(e))},R=function(e){return typeof e=="function"},I=function(e){return e instanceof Array},U=function(e){return e instanceof v},x=function(e){if(!I(e))throw"not an array : "+e},C=function(e){return S("no arguments supported",e.length===0)},k=function(e){if(typeof e!="string")throw"not a string : "+e},Y=function(e,t){return function(){var n;return n=1<=arguments.length?ht.call(arguments,0):[],e.apply(null,t.concat(n))}},K=function(e){return e.length===1&&U(e[0])?lt.always(e[0]):V(e)},V=function(e){return e=Array.prototype.slice.call(e),$.apply(null,e)},$=ft(function(){var e,t;return t=arguments[0],e=2<=arguments.length?ht.call(arguments,1):[],R(t)?e.length?Y(t,e):t:q(t)?it(t,e):lt.always(t)}),X=function(e,t){return $.apply(null,[e].concat(ht.call(t)))},J=function(t){return U(t)?t:e.once(t)},q=function(e){return typeof e=="string"&&e.length>1&&e.charAt(0)==="."},e.isFieldKey=q,it=function(e,t){var n,r;return r=e.slice(1).split("."),n=lt.map(ut(t),r),function(t){var r,i;for(r=0,i=n.length;r<i;r++)e=n[r],t=e(t);return t}},ut=function(e){return function(t){return function(n){var r;return n==null?void 0:(r=n[t],R(r)?r.apply(n,e):r)}}},st=function(e){return e.slice(1)},nt=function(e){var t;return R(e)?e:q(e)?(t=st(e),function(e,n){return e[t](n)}):S("not a function or a field key: "+e,!1)},ot=function(e){return e instanceof y||e===d?e:new y(e)},lt={indexOf:Array.prototype.indexOf?function(e,t){return e.indexOf(t)}:function(e,t){var n,r,i,s;for(n=i=0,s=e.length;i<s;n=++i){r=e[n];if(t===r)return n}return-1},indexWhere:function(e,t){var n,r,i,s;for(n=i=0,s=e.length;i<s;n=++i){r=e[n];if(t(r))return n}return-1},head:function(e){return e[0]},always:function(e){return function(){return e}},negate:function(e){return function(t){return!e(t)}},empty:function(e){return e.length===0},tail:function(e){return e.slice(1,e.length)},filter:function(e,t){var n,r,i,s;n=[];for(i=0,s=t.length;i<s;i++)r=t[i],e(r)&&n.push(r);return n},map:function(e,t){var n,r,i,s;s=[];for(r=0,i=t.length;r<i;r++)n=t[r],s.push(e(n));return s},each:function(e,t){var n,r,i;i=[];for(n in e)r=e[n],i.push(t(n,r));return i},toArray:function(e){return I(e)?e:[e]},contains:function(e,t){return lt.indexOf(e,t)!==-1},id:function(e){return e},last:function(e){return e[e.length-1]},all:function(e,t){var n,r,i;t==null&&(t=lt.id);for(r=0,i=e.length;r<i;r++){n=e[r];if(!t(n))return!1}return!0},any:function(e,t){var n,r,i;t==null&&(t=lt.id);for(r=0,i=e.length;r<i;r++){n=e[r];if(t(n))return!0}return!1},without:function(e,t){return lt.filter(function(t){return t!==e},t)},remove:function(e,t){var n;n=lt.indexOf(t,e);if(n>=0)return t.splice(n,1)},fold:function(e,t,n){var r,i,s;for(i=0,s=e.length;i<s;i++)r=e[i],t=n(t,r);return t},flatMap:function(e,t){return lt.fold(t,[],function(t,n){return t.concat(e(n))})},cached:function(e){var t;return t=d,function(){return t===d&&(t=e(),e=null),t}},toString:function(e){var t,n,r,i;try{return Z++,e==null?"undefined":R(e)?"function":I(e)?Z>5?"[..]":"["+lt.map(lt.toString,e).toString()+"]":(e!=null?e.toString:void 0)!=null&&e.toString!==Object.prototype.toString?e.toString():typeof e=="object"?Z>5?"{..}":(n=function(){var n;n=[];for(r in e){if(!pt.call(e,r))continue;i=function(){try{return e[r]}catch(n){return t=n,t}}(),n.push(lt.toString(r)+":"+lt.toString(i))}return n}(),"{"+n+"}"):e}finally{Z--}}},Z=0,e._=lt,e.scheduler={setTimeout:function(e,t){return setTimeout(e,t)},setInterval:function(e,t){return setInterval(e,t)},clearInterval:function(e){return clearInterval(e)},now:function(){return(new Date).getTime()}},typeof n!="undefined"&&n!==null&&n.amd!=null?(n("lib/bacon",[],function(){return e}),this.Bacon=e):typeof module!="undefined"&&module!==null?(module.exports=e,e.Bacon=e):this.Bacon=e}.call(this),n("Map",["utils","draw","Behavior","Scale","build","UndoStack","CallbackManager","KeyManager","Canvas","data_styles","SearchIndex","lib/bacon"],function(e,t,n,r,i,s,o,u,a,f,l,c){function p(t,i,c,h,p,d,v,m,g,y){if(g===null){var b=h.get_size();g={x:-b.width,y:-b.height,width:b.width*3,height:b.height*3}}this.default_reaction_color="#334E75",this.svg=t,this.defs=e.setup_defs(t,i),this.canvas=new a(c,g),this.setup_containers(c),this.sel=c,this.zoom_container=h,this.settings=p,this.settings.data_styles_stream.reaction.onValue(function(e){this.apply_reaction_data_to_map()}.bind(this)),this.settings.data_styles_stream.metabolite.onValue(function(e){this.apply_metabolite_data_to_map()}.bind(this)),this.reaction_data_object=f.import_and_check(d,p.data_styles.reaction,"reaction_data"),this.metabolite_data_object=f.import_and_check(v,p.data_styles.metabolite,"metabolite_data"),this.set_model(m),this.largest_ids={reactions:-1,nodes:-1,segments:-1},this.scale=new r,this.scale.connect_to_settings(this.settings),this.undo_stack=new s,this.behavior=new n(this,this.undo_stack),this.key_manager=new u,this.enable_search=y,this.search_index=new l;var w={x:0,y:0},E=1;this.beziers_enabled=!1,this.callback_manager=new o,this.nodes={},this.reactions={},this.membranes=[],this.text_labels={},this.info={},this.rotation_on=!1,this.debug=!1}function d(t,n,r,i,s,o,u,a,f,l){function k(e,t){return t===undefined&&(t=0),e===undefined?t:Math.max.apply(null,Object.keys(e).map(function(e){return parseInt(e)}).concat([t]))}e.check_undefined(arguments,["map_data","svg","css","selection","zoom_container","settings","reaction_data","metabolite_data","cobra_model","enable_search"]),this.debug&&d3.json("map_spec.json",function(n,r){if(n){console.warn(n);return}e.check_r(t,r.spec,r.can_be_none)});var c=t.canvas,p=new h(n,r,i,s,o,u,a,f,c,l);p.reactions=t.reactions,p.nodes=t.nodes,p.membranes=t.membranes,p.text_labels=t.text_labels,p.info=t.info;for(var d in p.reactions){var v=p.reactions[d];l&&p.search_index.insert("r"+d,{name:v.bigg_id,data:{type:"reaction",reaction_id:d}});for(var m in v.segments){var g=v.segments[m];g.reversibility=v.reversibility;var y=p.nodes[g.from_node_id].bigg_id;y in v.metabolites&&(g.from_node_coefficient=v.metabolites[y].coefficient);var b=p.nodes[g.to_node_id].bigg_id;b in v.metabolites&&(g.to_node_coefficient=v.metabolites[b].coefficient);var w=p.nodes[g.from_node_id],E=p.nodes[g.to_node_id];if(w["node_type"]=="metabolite"||E["node_type"]=="metabolite"){var S=e.c_plus_c(w,e.c_times_scalar(e.c_minus_c(E,w),.5));g.b1===null&&(g.b1=S),g.b2===null&&(g.b2=S)}}}if(l)for(var x in p.nodes){var T=p.nodes[x];if(T.node_type!="metabolite")continue;p.search_index.insert("n"+x,{name:T.bigg_id,data:{type:"metabolite",node_id:x}})}p.largest_ids.reactions=k(p.reactions),p.largest_ids.nodes=k(p.nodes),p.largest_ids.text_labels=k(p.text_labels);var N=0;for(var C in p.reactions)N=k(p.reactions[C].segments,N);return p.largest_ids.segments=N,p.apply_reaction_data_to_map(),p.apply_metabolite_data_to_map(),p}function v(e){e.append("g").attr("id","nodes"),e.append("g").attr("id","reactions"),e.append("g").attr("id","text-labels"),e.append("g").attr("id","membranes")}function m(){this.sel.select("#nodes").selectAll(".node").remove(),this.sel.select("#reactions").selectAll(".reaction").remove(),this.sel.select("#text-labels").selectAll(".text-label").remove(),this.sel.select("#membranes").selectAll(".membrane").remove()}function g(e,t){if(e=="reaction"&&t=="size")return this.scale.reaction_size;if(e=="reaction"&&t=="color")return this.scale.reaction_color;if(e=="metabolite"&&t=="size")return this.scale.metabolite_size;if(e=="metabolite"&&t=="color")return this.scale.metabolite_color;throw Error("Bad value for data or type: "+e+", "+t)}function y(e,t,n,r){function i(e,t,n){t!==null&&e.domain(t),n!==null&&e.range(n)}n===undefined&&(n=null),r===undefined&&(r=null),n!==null&&(this.settings.auto_domain["reaction"]==1||this.settings.auto_domain["metabolite"]==1)&&(console.warn("Cannot set domain manually if auto_*_domain is true"),n=null);if(e=="reaction"&&t=="size")i(this.scale.reaction_size,n,r);else if(e=="reaction"&&t=="color")i(this.scale.reaction_color,n,r);else if(e=="metabolite"&&t=="size")i(this.scale.metabolite_size,n,r);else{if(e!="metabolite"||t!="color")throw Error("Bad value for data or type: "+e+", "+t);i(this.scale.metabolite_color,n,r)}}function b(e){this.status=e,this.callback_manager.run("set_status",e)}function w(e){this.cobra_model=e,this.cobra_model!==null&&(this.cobra_model.apply_reaction_data(this.reaction_data_object,this.settings.data_styles.reaction),this.cobra_model.apply_metabolite_data(this.metabolite_data_object,this.settings.data_styles.metabolite))}function E(e){this.reaction_data_object=f.import_and_check(e,this.settings.data_styles.reaction,"reaction_data"),this.apply_reaction_data_to_map(),this.cobra_model!==null&&this.cobra_model.apply_reaction_data(this.reaction_data_object,this.settings.data_styles.metabolite),this.draw_all_reactions()}function S(e){this.metabolite_data_object=f.import_and_check(e,this.settings.data_styles.metabolite,"metabolite_data"),this.apply_metabolite_data_to_map(),this.cobra_model!==null&&this.cobra_model.apply_metabolite_data(this.metabolite_data_object,this.settings.data_styles.metabolite),this.draw_all_nodes()}function x(){this.reactions={},this.nodes={},this.membranes=[],this.text_labels={},this.apply_reaction_data_to_map(),this.apply_metabolite_data_to_map(),this.draw_everything()}function T(){return this.reaction_data_object!==null}function N(){return this.metabolite_data_object!==null}function C(){var n=this.sel,r=this.membranes,i=this.scale,s=this.reactions,o=this.nodes,u=this.text_labels,a=this.defs,f=this.default_reaction_color,l=this.behavior.bezier_drag,c=this.behavior.node_click,h=this.behavior.node_mouseover,p=this.behavior.node_mouseout,d=this.behavior.node_drag,v=this.behavior.reaction_label_drag,m=this.behavior.node_label_drag,g=this.behavior.text_label_click,y=this.behavior.text_label_drag,b=this.has_reaction_data(),w=this.settings.data_styles.reaction,E=this.has_metabolite_data(),S=this.settings.data_styles.metabolite,x=this.beziers_enabled;e.draw_an_array(n,"#membranes",".membrane",r,t.create_membrane,t.update_membrane),e.draw_an_object(n,"#reactions",".reaction",s,"reaction_id",t.create_reaction,function(e){return t.update_reaction(e,i,o,x,a,f,b,w,l,v)}),e.draw_an_object(n,"#nodes",".node",o,"node_id",function(e){return t.create_node(e,o,s)},function(e){return t.update_node(e,i,E,S,c,h,p,d,m)}),e.draw_an_object(n,"#text-labels",".text-label",u,"text_label_id",function(e){return t.create_text_label(e)},function(e){return t.update_text_label(e,g,y)})}function k(){var e=[];for(var t in this.reactions)e.push(t);this.draw_these_reactions(e)}function L(n){var r=this.scale,i=this.reactions,s=this.nodes,o=this.defs,u=this.default_reaction_color,a=this.behavior.bezier_drag,f=this.behavior.reaction_label_drag,l=this.has_reaction_data(),c=this.settings.data_styles.reaction,h=this.beziers_enabled,p={},d=-1;while(++d<n.length)p[n[d]]=e.clone(i[n[d]]);n.length!=Object.keys(p).length&&console.warn("did not find correct reaction subset");var v=this.sel.select("#reactions").selectAll(".reaction").data(e.make_array(p,"reaction_id"),function(e){return e.reaction_id});v.enter().call(t.create_reaction),v.call(function(e){return t.update_reaction(e,r,s,h,o,u,l,c,a,f)}),v.exit()}function A(){var e=[];for(var t in this.nodes)e.push(t);this.draw_these_nodes(e)}function O(n){var r=this.scale,i=this.reactions,s=this.nodes,o=this.behavior.node_click,u=this.behavior.node_mouseover,a=this.behavior.node_mouseout,f=this.behavior.node_drag,l=this.behavior.node_label_drag,c=this.settings.data_styles.metabolite,h=this.has_metabolite_data(),p={},d=-1;while(++d<n.length)p[n[d]]=e.clone(s[n[d]]);n.length!=Object.keys(p).length&&console.warn("did not find correct node subset");var v=this.sel.select("#nodes").selectAll(".node").data(e.make_array(p,"node_id"),function(e){return e.node_id});v.enter().call(function(e){return t.create_node(e,s,i)}),v.call(function(e){return t.update_node(e,r,h,c,o,u,a,f,l)}),v.exit()}function M(n){var r=this.text_labels,i=this.behavior.text_label_click,s=this.behavior.text_label_drag,o={},u=-1;while(++u<n.length)o[n[u]]=e.clone(r[n[u]]);n.length!=Object.keys(o).length&&console.warn("did not find correct text label subset");var a=this.sel.select("#text-labels").selectAll(".text-label").data(e.make_array(o,"text_label_id"),function(e){return e.text_label_id});a.enter().call(function(e){return t.create_text_label(e)}),a.call(function(e){return t.update_text_label(e,i,s)}),a.exit()}function _(){return this.apply_reaction_data_to_reactions(this.reactions)}function D(e){if(!this.has_reaction_data()){for(var t in e){var n=e[t];n.data=null,n.data_string="";for(var r in n.segments){var i=n.segments[r];i.data=null}}return!1}var s=this.reaction_data_object,o=this.settings.data_styles.reaction;for(var t in e){var n=e[t],u=n.bigg_id in s?s[n.bigg_id]:null,a=f.float_for_data(u,o),l=f.reverse_flux_for_data(u,o),c=f.text_for_data(u,o);n.data=a,n.data_string=c,n.reverse_flux=l;for(var r in n.segments){var i=n.segments[r];i.data=n.data,i.reverse_flux=n.reverse_flux}}return this.update_reaction_data_domain()}function P(){if(!this.settings.auto_domain.reaction)return!1;var t=[];for(var n in this.reactions){var r=this.reactions[n];r.data!==null&&t.push(r.data)}var i=this.settings.domain.reaction.color,s,o,u;return t.length>0?(this.settings.data_styles["reaction"].indexOf("abs")!=-1&&(t=t.map(function(e){return Math.abs(e)})),o=Math.min.apply(null,t),u=Math.max.apply(null,t)):(o=0,u=0),s=[0,o,u].sort(),this.settings.set_domain("reaction",s),!e.compare_arrays(i,s)}function H(){return this.apply_metabolite_data_to_nodes(this.nodes)}function B(e){if(!this.has_metabolite_data()){for(var t in e)e[t].data=null,e[t].data_string="";return!1}var n=this.metabolite_data_object,r=this.settings.data_styles.metabolite;for(var t in e){var i=e[t],s=i.bigg_id in n?n[i.bigg_id]:null,o=f.float_for_data(s,r),u=f.text_for_data(s,r);i.data=o,i.data_string=u}return this.update_metabolite_data_domain()}function j(){if(!this.settings.auto_domain.metabolite)return!1;var t=[];for(var n in this.nodes){var r=this.nodes[n];r.data!==null&&t.push(r.data)}var i=this.settings.domain.metabolite.color,s,o,u;return t.length>0?(this.settings.data_styles["metabolite"].indexOf("abs")!=-1&&(t=t.map(function(e){return Math.abs(e)})),o=Math.min.apply(null,t),u=Math.max.apply(null,t)):(o=0,u=0),s=[0,o,u].sort(),this.settings.set_domain("metabolite",s),!e.compare_arrays(i,s)}function F(e){var t=this.nodes[e],n={x:t.x,y:t.y};return n}function I(){var e=[];return this.sel.select("#nodes").selectAll(".selected").each(function(t){e.push(t.node_id)}),e}function q(){var e={},t=this;return this.sel.select("#nodes").selectAll(".selected").each(function(n){e[n.node_id]=t.nodes[n.node_id]}),e}function R(){var e=[];return this.sel.select("#text-labels").selectAll(".selected").each(function(t){e.push(t.text_label_id)}),e}function U(){var e={},t=this;return this.sel.select("#text-labels").selectAll(".selected").each(function(n){e[n.text_label_id]=t.text_labels[n.text_label_id]}),e}function z(){this.sel.selectAll(".selected").classed("selected",!1)}function W(e){this.deselect_text_labels();var t=this.sel.select("#nodes").selectAll(".node"),n,r;t.classed("selected",function(t){var i=String(t.node_id)==String(e);return i&&(r=t,n={x:t.x,y:t.y}),i}),this.sel.selectAll(".start-reaction-target").style("visibility","hidden"),this.callback_manager.run("select_metabolite_with_id",r,n)}function X(e,t){this.deselect_text_labels();var n=this.sel.select("#nodes").selectAll(".node"),r=this.key_manager.held_keys.shift;r?d3.select(e.parentNode).classed("selected",!d3.select(e.parentNode).classed("selected")):n.classed("selected",function(e){return t===e});var i=this.sel.select("#nodes").selectAll(".selected"),s=0,o,u;i.each(function(e){u=e,o={x:e.x,y:e.y},s++}),this.callback_manager.run("select_metabolite",s,u,o)}function V(){var e=null,t=this,n=this.sel.select("#nodes").selectAll(".selected");return n.classed("selected",function(t,n){return n==0?(e=t,!0):!1}),e}function $(){var e=this.sel.select("#nodes").selectAll(".node");e.classed("selected",!1)}function J(e,t){this.deselect_nodes();var n=this.sel.select("#text-labels").selectAll(".text-label");n.classed("selected",function(e){return t===e});var r=this.sel.select("#text-labels").selectAll(".selected"),i;r.each(function(e){i={x:e.x,y:e.y}}),this.callback_manager.run("select_text_label")}function K(){var e=this.sel.select("#text-labels").selectAll(".text-label");e.classed("selected",!1)}function Q(){var e=this.get_selected_nodes();Object.keys(e).length>=1&&this.delete_nodes(e);var t=this.get_selected_text_labels();Object.keys(t).length>=1&&this.delete_text_labels(t)}function G(t){var n=this.segments_and_reactions_for_nodes(t),r=n.reactions,i=n.segment_objs_w_segments,s=e.clone(t),o=e.clone(i),u=e.clone(r),a=function(e,n,r){this.delete_node_data(Object.keys(t)),this.delete_segment_data(r),this.delete_reaction_data(Object.keys(n)),this.has_reaction_data()&&this.update_reaction_data_domain(),this.has_metabolite_data()&&this.apply_metabolite_data_domain(),this.draw_everything()}.bind(this);a(t,r,i),this.undo_stack.push(function(){this.extend_nodes(s),this.extend_reactions(u);var n=Object.keys(u);o.forEach(function(e){var t=e.segment;this.reactions[e.reaction_id].segments[e.segment_id]=t,[t.from_node_id,t.to_node_id].forEach(function(t){if(t in s)return;var n=this.nodes[t];n.connected_segments.push({reaction_id:e.reaction_id,segment_id:e.segment_id})}.bind(this)),n.indexOf(e.reaction_id)==-1&&n.push(e.reaction_id)}.bind(this));if(this.has_reaction_data()){var a=this.update_reaction_data_domain();a?this.draw_all_reactions():this.draw_these_reactions(Object.keys(n))}else this.draw_these_reactions(Object.keys(n));if(this.has_metabolite_data()){var a=this.update_metabolite_data_domain();a?this.draw_all_nodes():this.draw_these_nodes(Object.keys(s))}else this.draw_these_nodes(Object.keys(s));t=e.clone(s),i=e.clone(o),r=e.clone(u)}.bind(this),function(){a(t,r,i)}.bind(this))}function Y(t){var n=e.clone(t),r=this,i=function(e){r.delete_text_label_data(Object.keys(t)),r.draw_everything()};i(t),this.undo_stack.push(function(){e.extend(r.text_labels,n),r.draw_these_text_labels(Object.keys(n)),t=e.clone(n)},function(){i(t)})}function Z(e){e.forEach(function(e){if(this.enable_search&&this.nodes[e].node_type=="metabolite"){var t=this.search_index.remove("n"+e);t||console.warn("Could not find deleted metabolite in search index")}delete this.nodes[e]}.bind(this))}function et(e){e.forEach(function(e){var t=this.reactions[e.reaction_id];if(!(e.segment_id in t.segments))return;var n=t.segments[e.segment_id];[n.from_node_id,n.to_node_id].forEach(function(t){if(!(t in this.nodes))return;var n=this.nodes[t];n.connected_segments=n.connected_segments.filter(function(t){return t.segment_id!=e.segment_id})}.bind(this)),delete t.segments[e.segment_id]}.bind(this))}function tt(e){e.forEach(function(e){delete this.reactions[e];var t=this.search_index.remove("r"+e);t||console.warn("Could not find deleted reaction in search index")}.bind(this))}function nt(e){e.forEach(function(e){delete this.text_labels[e]}.bind(this))}function rt(){this.toggle_beziers(!0)}function it(){this.toggle_beziers(!1)}function st(e){e===undefined?this.beziers_enabled=!this.beziers_enabled:this.beziers_enabled=e,this.draw_everything(),this.callback_manager.run("toggle_beziers",this.beziers_enabled)}function ot(t,n,r){function v(e,t){this.extend_nodes(e);if(this.has_metabolite_data()){var n=this.apply_metabolite_data_to_nodes(e);n?this.draw_all_nodes():this.draw_these_nodes([t])}else this.draw_these_nodes([t])}for(var i in this.reactions)if(this.reactions[i].bigg_id==t)return console.warn("reaction is already drawn"),null;if(!this.cobra_model)return console.error("No CobraModel. Cannot build new reaction");var s=e.clone(this.cobra_model.reactions[t]);for(var o in s.metabolites){var u=s.metabolites[o],a=this.cobra_model.metabolites[o];if(u<0){var f=String(++this.largest_ids.nodes),l={x:30,y:10},c={connected_segments:[],x:n.x,y:n.y,node_is_primary:!0,label_x:n.x+l.x,label_y:n.y+l.y,name:a.name,bigg_id:o,node_type:"metabolite"},h={};h[f]=c;break}}v.apply(this,[h,f]);var p=e.clone(h),d=this;return this.undo_stack.push(function(){d.delete_node_data(Object.keys(h)),h=e.clone(p),d.draw_everything()},function(){v.apply(d,[h,f])}),this.new_reaction_for_metabolite(t,f,r),null}function ut(t){if(this.enable_search)for(var n in t){var r=t[n];if(r.node_type!="metabolite")continue;this.search_index.insert("n"+n,{name:r.bigg_id,data:{type:"metabolite",node_id:n}})}e.extend(this.nodes,t)}function at(t){for(var n in t){var r=t[n];this.enable_search&&this.search_index.insert("r"+n,{name:r.bigg_id,data:{type:"reaction",reaction_id:n}})}e.extend(this.reactions,t)}function ft(t,n,r){function d(e,t,n){this.extend_reactions(t),this.delete_node_data([n]),this.extend_nodes(e);if(this.has_reaction_data()){var r=this.apply_reaction_data_to_reactions(t);r?this.draw_all_reactions():this.draw_these_reactions(Object.keys(t))}else this.draw_these_reactions(Object.keys(t));if(this.has_metabolite_data()){var r=this.apply_metabolite_data_to_nodes(e);r?this.draw_all_nodes():this.draw_these_nodes(Object.keys(e))}else this.draw_these_nodes(Object.keys(e));for(var i in e){var s=e[i];if(s.node_is_primary&&i!=n){this.select_metabolite_with_id(i);var o={x:s.x,y:s.y};this.zoom_container&&this.zoom_container.translate_off_screen(o)}}}for(var s in this.reactions)if(this.reactions[s].bigg_id==t){console.warn("reaction is already drawn");return}var o=this.nodes[n],u=this.cobra_model.reactions[t],a=i.new_reaction(t,u,this.cobra_model.metabolites,n,e.clone(o),this.largest_ids,this.cobra_model.cofactors,r),f=a.new_nodes,l=a.new_reactions;d.apply(this,[f,l,n]);var c=e.clone(f),h=e.clone(l),p=this;this.undo_stack.push(function(){delete f[n],p.delete_node_data(Object.keys(f)),p.delete_reaction_data(Object.keys(l)),W.apply(p,[n]),f=e.clone(c),l=e.clone(h),p.draw_everything()},function(){d.apply(p,[f,l,n])})}function lt(){var e=this.get_selected_nodes(),t=Object.keys(e)[0],n=e[t],r=this.reactions,i=this.nodes,s=[],o;i[t].connected_segments.forEach(function(e){o=[e.reaction_id];var n=r[e.reaction_id].segments[e.segment_id];s.push(n.from_node_id==t?n.to_node_id:n.from_node_id)});if(s.length!=1)return console.error("Only connected nodes with a single reaction can be selected");var u=s[0],a=[t],f=[];i[u].connected_segments.forEach(function(e){var n=r[e.reaction_id].segments[e.segment_id],s=n.from_node_id==u?n.to_node_id:n.from_node_id,o=i[s];o.node_type=="metabolite"&&s!=t&&a.push(String(s))});for(var l=0;l<a.length;l++)if(i[a[l]].connected_segments.length>1)return console.error("Only connected nodes with a single reaction can be selected");for(var c in e)if(c!=t&&a.indexOf(c)==-1)return console.warn("Selected nodes are not on the same reaction");var h=[],p=a.length-1,d=i[a[p]],v=d.node_is_primary,m={x:d.x,y:d.y,label_x:d.label_x,label_y:d.label_y},g=d.connected_segments[0],y=r[g.reaction_id].segments[g.segment_id],b={b1:y.b1,b2:y.b2},w;a.forEach(function(e){var t=i[e],n=t.node_is_primary,s={x:t.x,y:t.y,label_x:t.label_x,label_y:t.label_y},o=t.connected_segments[0],u=r[o.reaction_id].segments[o.segment_id],a={b1:u.b1,b2:u.b2};t.node_is_primary=v,t.x=m.x,t.y=m.y,t.label_x=m.label_x,t.label_y=m.label_y,u.b1=b.b1,u.b2=b.b2,v=n,m=s,b=a,t.node_is_primary&&(w=e),h.push(e)});var E=i[u].connected_segments,p=E.length-1,S=[E[p]];E.forEach(function(e,t){if(p==t)return;S.push(e)}),i[u].connected_segments=S,this.draw_these_nodes(h),this.draw_these_reactions(o),this.select_metabolite_with_id(w)}function ct(){var e=this.get_selected_nodes(),t=this.reactions,n=this.nodes;if(Object.keys(e).length!=1)return console.error("Only one node can be selected");var r=Object.keys(e)[0],i=e[r];n[r].node_is_primary=!0;var s=[r],o=[];n[r].connected_segments.forEach(function(e){var n=t[e.reaction_id].segments[e.segment_id];o.push(n.from_node_id==r?n.to_node_id:n.from_node_id)}),o.forEach(function(e){var i=[];n[e].connected_segments.forEach(function(i){var o=t[i.reaction_id].segments[i.segment_id],u=o.from_node_id==e?o.to_node_id:o.from_node_id,a=n[u];a.node_type=="metabolite"&&u!=r&&(a.node_is_primary=!1,s.push(u))})}),this.draw_these_nodes(s)}function ht(t){var n=[],r={},i={},s=this.reactions;for(var o in t){var u=t[o];u.connected_segments.forEach(function(t){var r=s[t.reaction_id],o=r.segments[t.segment_id],u=e.clone(t);u.segment=e.clone(o),n.push(u),t.reaction_id in i||(i[t.reaction_id]=[]),i[t.reaction_id].push(t.segment_id)})}for(var a in i){var f=s[a],l=i[a],c=!0;for(var h in f.segments)l.indexOf(h)==-1&&(c=!1);c&&(r[a]=f)}return{segment_objs_w_segments:n,reactions:r}}function b(e){var t=d3.select("body").select("#status");return t.empty()&&(t=d3.select("body").append("text").attr("id","status")),t.text(e),this}function pt(e){this._zoom_extent(e,"nodes")}function dt(e){this._zoom_extent(e,"canvas")}function vt(e,t){e===undefined&&(e=t=="nodes"?.2:0),t===undefined&&(t="canvas");var n,r,i=this.get_size();e*=i.height;if(t=="nodes"){var s={x:null,y:null},o={x:null,y:null};for(var u in this.nodes){var a=this.nodes[u];s.x===null&&(s.x=a.x),s.y===null&&(s.y=a.y),o.x===null&&(o.x=a.x),o.y===null&&(o.y=a.y),s.x=Math.min(s.x,a.x),s.y=Math.min(s.y,a.y),o.x=Math.max(o.x,a.x),o.y=Math.max(o.y,a.y)}n=Math.min((i.width-e*2)/(o.x-s.x),(i.height-e*2)/(o.y-s.y)),r={x:-(s.x*n)+e+(i.width-e*2-(o.x-s.x)*n)/2,y:-(s.y*n)+e+(i.height-e*2-(o.y-s.y)*n)/2}}else{if(t!="canvas")return console.error("Did not recognize mode");n=Math.min((i.width-e*2)/this.canvas.width,(i.height-e*2)/this.canvas.height),r={x:-(this.canvas.x*n)+e+(i.width-e*2-this.canvas.width*n)/2,y:-(this.canvas.y*n)+e+(i.height-e*2-this.canvas.height*n)/2}}return this.zoom_container.go_to(n,r),null}function mt(){return this.zoom_container.get_size()}function gt(e){var t=this.reactions[e],n=.6,r=this.get_size(),i={x:-t.label_x*n+r.width/2,y:-t.label_y*n+r.height/2};this.zoom_container.go_to(n,i)}function yt(e){var t=this.nodes[e],n=.6,r=this.get_size(),i={x:-t.label_x*n+r.width/2,y:-t.label_y*n+r.height/2};this.zoom_container.go_to(n,i)}function bt(e){this.highlight(this.sel.selectAll("#r"+e).selectAll("text"))}function wt(e){this.highlight(this.sel.selectAll("#n"+e).selectAll("text"))}function Et(e){this.sel.selectAll(".highlight").classed("highlight",!1),e!==null&&e.classed("highlight",!0)}function St(){console.log("Saving"),e.download_json(this.map_for_export(),"saved_map")}function xt(){var t={reactions:e.clone(this.reactions),nodes:e.clone(this.nodes),membranes:e.clone(this.membranes),text_labels:e.clone(this.text_labels),canvas:this.canvas.size_and_location()};for(var n in t.reactions){var r=t.reactions[n];delete r.data,delete r.data_string;for(var i in r.segments){var s=r.segments[i];delete s.reversibility,delete s.from_node_coefficient,delete s.to_node_coefficient,delete s.data}}for(var o in t.nodes){var u=t.nodes[o];delete u.data,delete u.data_string}return this.debug&&d3.json("map_spec.json",function(n,r){if(n){console.warn(n);return}e.check_r(t,r.spec,r.can_be_none)}),t}function Tt(){console.log("Exporting SVG"),this.callback_manager.run("before_svg_export");var t=this.zoom_container.window_scale,n=this.zoom_container.window_translate,r=this.canvas.size_and_location(),i={w:this.canvas.mouse_node.attr("width"),h:this.canvas.mouse_node.attr("height"),transform:this.canvas.mouse_node.attr("transform")};this.zoom_container.go_to(1,{x:-r.x,y:-r.y},!1),this.svg.attr("width",r.width),this.svg.attr("height",r.height),this.canvas.mouse_node.attr("width","0px"),this.canvas.mouse_node.attr("height","0px"),this.canvas.mouse_node.attr("transform",null),e.export_svg("saved_map",this.svg,!0),this.zoom_container.go_to(t,n,!1),this.svg.attr("width",null),this.svg.attr("height",null),this.canvas.mouse_node.attr("width",i.w),this.canvas.mouse_node.attr("height",i.h),this.canvas.mouse_node.attr("transform",i.transform),this.callback_manager.run("after_svg_export")}var h=e.make_class();return h.from_data=d,h.prototype={init:p,setup_containers:v,reset_containers:m,get_scale:g,set_scale:y,set_status:b,set_model:w,set_reaction_data:E,set_metabolite_data:S,clear_map:x,select_none:z,select_metabolite:X,select_metabolite_with_id:W,select_single_node:V,deselect_nodes:$,select_text_label:J,deselect_text_labels:K,new_reaction_from_scratch:ot,new_reaction_for_metabolite:ft,cycle_primary_node:lt,make_selected_node_primary:ct,extend_nodes:ut,extend_reactions:at,delete_selected:Q,delete_nodes:G,delete_text_labels:Y,delete_node_data:Z,delete_segment_data:et,delete_reaction_data:tt,delete_text_label_data:nt,get_selected_node_ids:I,get_selected_nodes:q,get_selected_text_label_ids:R,get_selected_text_labels:U,segments_and_reactions_for_nodes:ht,has_reaction_data:T,has_metabolite_data:N,draw_everything:C,draw_all_reactions:k,draw_these_reactions:L,draw_all_nodes:A,draw_these_nodes:O,draw_these_text_labels:M,apply_reaction_data_to_map:_,apply_reaction_data_to_reactions:D,update_reaction_data_domain:P,apply_metabolite_data_to_map:H,apply_metabolite_data_to_nodes:B,update_metabolite_data_domain:j,get_selected_node_ids:I,toggle_beziers:st,hide_beziers:it,show_beziers:rt,zoom_extent_nodes:pt,zoom_extent_canvas:dt,_zoom_extent:vt,get_size:mt,zoom_to_reaction:gt,zoom_to_node:yt,highlight_reaction:bt,highlight_node:wt,highlight:Et,save:St,map_for_export:xt,save_svg:Tt},h}),n("ZoomContainer",["utils","CallbackManager"],function(e,t){function r(e,n,r){this.zoom_on=!0,this.initial_zoom=1,this.window_translate={x:0,y:0},this.window_scale=1,this.callback_manager=new t,this.size_container=n,e.select("#zoom-container").remove();var i=e.append("g").attr("id","zoom-container");this.zoomed_sel=i.append("g");var s=function(e,t){e.zoom_on&&(e.zoomed_sel.attr("transform","translate("+t.translate+")"+"scale("+t.scale+")"),e.window_translate={x:t.translate[0],y:t.translate[1]},e.window_scale=t.scale,e.callback_manager.run("zoom"))},o=this;this.zoom_behavior=d3.behavior.zoom().on("zoom",function(){s(o,d3.event)}),i.call(this.zoom_behavior),(r=="none"||r=="pan")&&i.on("mousewheel.zoom",null).on("DOMMouseScroll.zoom",null).on("wheel.zoom",null).on("dblclick.zoom",null);if(r=="pan"){var u=function(){var e=d3.event,t=.5;e.stopPropagation(),e.preventDefault(),e.returnValue=!1,this.go_to(this.window_scale,{x:this.window_translate.x-(e.wheelDeltaX!==undefined?-e.wheelDeltaX/1.5:e.deltaX)*t,y:this.window_translate.y-(e.wheelDeltaY!==undefined?-e.wheelDeltaY/1.5:e.deltaY)*t},!1)}.bind(this);i.on("mousewheel.escher",u),i.on("DOMMouseScroll.escher",u),i.on("wheel.escher",u)}this.saved_scale=null,this.saved_translate=null}function i(t){t===undefined?this.zoom_on=!this.zoom_on:this.zoom_on=t,this.zoom_on?(this.saved_scale!==null&&(this.zoom_behavior.scale(this.saved_scale),this.saved_scale=null),this.saved_translate!==null&&(this.zoom_behavior.translate(this.saved_translate),this.saved_translate=null),this.zoomed_sel.classed("cursor-grab",!0).classed("cursor-grabbing",!1),this.zoomed_sel.on("mousedown.cursor",function(e){e.classed("cursor-grab",!1).classed("cursor-grabbing",!0)}.bind(null,this.zoomed_sel)).on("mouseup.cursor",function(e){e.classed("cursor-grab",!0).classed("cursor-grabbing",!1)}.bind(null,this.zoomed_sel))):(this.saved_scale===null&&(this.saved_scale=e.clone(this.zoom_behavior.scale())),this.saved_translate===null&&(this.saved_translate=e.clone(this.zoom_behavior.translate())),this.zoomed_sel.style("cursor",null).classed("cursor-grab",!1).classed("cursor-grabbing",!1),this.zoomed_sel.on("mousedown.cursor",null),this.zoomed_sel.on("mouseup.cursor",null))}function s(t,n,r){e.check_undefined(arguments,["scale","translate"]),r===undefined&&(r=!0);if(!t)throw new Error("Bad scale value");if(!!n&&"x"in n&&"y"in n&&!isNaN(n.x)&&!isNaN(n.y)){this.zoom_behavior.scale(t),this.window_scale=t,this.saved_scale!==null&&(this.saved_scale=t);var i=[n.x,n.y];this.zoom_behavior.translate(i),this.window_translate=n,this.saved_translate!==null&&(this.saved_translate=i);var s=r?this.zoomed_sel.transition():this.zoomed_sel;return s.attr("transform","translate("+this.window_translate.x+","+this.window_translate.y+")"+"scale("+this.window_scale+")"),null}return console.error("Bad translate value")}function o(t){var n=this.get_size(),r={x:n.width/2-((n.width/2-this.window_translate.x)*t+this.window_translate.x),y:n.height/2-((n.height/2-this.window_translate.y)*t+this.window_translate.y)};this.go_to(this.window_scale*t,e.c_plus_c(this.window_translate,r),!0)}function u(){this.zoom_by(1.5)}function a(){this.zoom_by(.667)}function f(){return{width:parseInt(this.size_container.style("width"),10),height:parseInt(this.size_container.style("height"),10)}}function l(e){var t=120,n=this.get_size(),r={x:{min:-this.window_translate.x/this.window_scale+t/this.window_scale,max:-this.window_translate.x/this.window_scale+(n.width-t)/this.window_scale},y:{min:-this.window_translate.y/this.window_scale+t/this.window_scale,max:-this.window_translate.y/this.window_scale+(n.height-t)/this.window_scale}};e.x<r.x.min?(this.window_translate.x=this.window_translate.x-(e.x-r.x.min)*this.window_scale,this.go_to(this.window_scale,this.window_translate)):e.x>r.x.max&&(this.window_translate.x=this.window_translate.x-(e.x-r.x.max)*this.window_scale,this.go_to(this.window_scale,this.window_translate)),e.y<r.y.min?(this.window_translate.y=this.window_translate.y-(e.y-r.y.min)*this.window_scale,this.go_to(this.window_scale,this.window_translate)):e.y>r.y.max&&(this.window_translate.y=this.window_translate.y-(e.y-r.y.max)*this.window_scale,this.go_to(this.window_scale,this.window_translate))}function c(){this.go_to(1,{x:0,y:0})}var n=e.make_class();return n.prototype={init:r,toggle_zoom:i,go_to:s,zoom_by:o,zoom_in:u,zoom_out:a,get_size:f,translate_off_screen:l,reset:c},n}),n("DirectionArrow",["utils"],function(e){function n(e){function t(){return"M0 -5 L0 5 L20 5 L20 10 L30 0 L20 -10 L20 -5 Z"}this.arrow_container=e.append("g").attr("id","direction-arrow-container").attr("transform","translate(0,0)rotate(0)"),this.arrow=this.arrow_container.append("path").classed("direction-arrow",!0).attr("d",t()).style("visibility","hidden").attr("transform","translate(30,0)scale(2.5)"),this.sel=e,this.center={x:0,y:0},this._setup_drag(),this.dragging=!1,this.is_visible=!1,this.show()}function r(e){this.center=e;var t=d3.transform(this.arrow_container.attr("transform"));this.arrow_container.attr("transform","translate("+e.x+","+e.y+")rotate("+t.rotate+")")}function i(e){var t=d3.transform(this.arrow_container.attr("transform"));this.arrow_container.attr("transform","translate("+t.translate+")rotate("+e+")")}function s(e){var t=d3.transform(this.arrow_container.attr("transform"));this.arrow_container.attr("transform","translate("+t.translate+")"+"rotate("+(t.rotate+e)+")")}function o(){return d3.transform(this.arrow_container.attr("transform")).rotate}function u(e){e===undefined?this.is_visible=!this.is_visible:this.is_visible=e,this.arrow.style("visibility",this.is_visible?"visible":"hidden")}function a(){this.toggle(!0)}function f(){this.toggle(!1)}function l(){this.set_rotation(0)}function c(){this.set_rotation(90)}function h(){this.set_rotation(180)}function p(){this.set_rotation(270)}function d(){var t=d3.behavior.drag().on("dragstart",function(e){d3.event.sourceEvent.stopPropagation(),this.dragging=!0}.bind(this)).on("drag.direction_arrow",function(t){var n={x:d3.event.dx,y:d3.event.dy},r={x:d3.mouse(this.sel.node())[0],y:d3.mouse(this.sel.node())[1]},i=e.angle_for_event(n,r,this.center);this.displace_rotation(e.to_degrees(i))}.bind(this)).on("dragend",function(e){window.setTimeout(function(){this.dragging=!1}.bind(this),200)}.bind(this));this.arrow_container.call(t)}var t=e.make_class();return t.prototype={init:n,set_location:r,set_rotation:i,displace_rotation:s,get_rotation:o,toggle:u,show:a,hide:f,right:l,left:h,up:p,down:c,_setup_drag:d},t}),n("Input",["utils","lib/complete.ly","Map","ZoomContainer","CallbackManager","draw","DirectionArrow"],function(e,t,n,r,i,s,o){function a(e,s,u){var a=e.append("div").attr("id","rxn-input"),f=t(a.node(),{backgroundColor:"#eee"});d3.select(f.input).on("input",function(){this.value=this.value.replace(" ","").replace("\\","").replace("<","")}),this.selection=a,this.completely=f,a.append("button").attr("class","button input-close-button").text("×").on("click",function(){this.hide_dropdown()}.bind(this));if(s instanceof n){this.map=s;var l=90;this.direction_arrow=new o(s.sel),this.direction_arrow.set_rotation(l),this.setup_map_callbacks(s)}else console.error("Cannot set the map. It is not an instance of builder/Map");u instanceof r?(this.zoom_container=u,this.setup_zoom_callbacks()):console.error("Cannot set the zoom_container. It is not an instance of builder/ZoomContainer"),this.callback_manager=new i,this.toggle(!1),this.target_coords=null}function f(e){e.callback_manager.set("select_metabolite_with_id.input",function(e,t){this.is_active&&this.reload(e,t,!1),this.hide_target()}.bind(this)),e.callback_manager.set("select_metabolite.input",function(e,t,n){this.hide_target(),e==1&&this.is_active&&n?this.reload(t,n,!1):this.toggle(!1)}.bind(this)),e.callback_manager.set("before_svg_export",function(){this.direction_arrow.hide(),this.hide_target()}.bind(this))}function l(){this.zoom_container.callback_manager.set("zoom.input",function(){this.is_active&&this.place_at_selected()}.bind(this))}function c(){return this.selection.style("display")!="none"}function h(e){e===undefined?this.is_active=!this.is_active:this.is_active=e,this.is_active?(this.toggle_start_reaction_listener(!0),this.target_coords!==null?this.show_dropdown(this.target_coords):this.reload_at_selected(),this.map.set_status("Click on the canvas or an existing metabolite"),this.direction_arrow.show(),this.escape=this.map.key_manager.add_escape_listener(function(){this.hide_dropdown()}.bind(this))):(this.toggle_start_reaction_listener(!1),this.selection.style("display","none"),this.completely.input.blur(),this.completely.hideDropDown(),this.map.set_status(null),this.direction_arrow.hide(),this.escape&&this.escape.clear(),this.escape=null)}function p(e){this.selection.style("display","block"),this.completely.input.blur(),this.completely.repaint(),this.completely.setText(""),this.completely.input.focus()}function d(){this.selection.style("display","none"),this.completely.hideDropDown()}function v(){this.map.deselect_text_labels();var e=this.map.select_single_node();if(e==null)return;var t={x:e.x,y:e.y};this.place(t)}function m(e){var t={x:240,y:0},n=this.map.zoom_container.window_translate,r=this.map.zoom_container.window_scale,i=this.map.get_size(),s=Math.max(20,Math.min(i.width-270,r*e.x+n.x-t.x)),o=Math.max(20,Math.min(i.height-40,r*e.y+n.y-t.y));this.selection.style("position","absolute").style("display","block").style("left",s+"px").style("top",o+"px"),this.direction_arrow.set_location(e),this.direction_arrow.show()}function g(){this.map.deselect_text_labels();var e=this.map.select_single_node();if(e==null)return!1;var t={x:e.x,y:e.y};return this.reload(e,t,!1),!0}function y(t,n,r){function w(e,t){for(var n in t)if(t[n].bigg_id==e)return!0;return!1}t===undefined&&!r&&console.error("No selected node, and not starting from scratch"),this.place(n),this.completely.input.blur(),this.completely.repaint();if(this.map.cobra_model===null){this.completely.setText("Cannot add: No model.");return}var i=[],s=this.map.cobra_model.reactions,o=this.map.cobra_model.metabolites,u=this.map.reactions,a=this.map.has_reaction_data(),f=this.map.reaction_data,l=this.map.reaction_data_styles;for(var c in s){var h=s[c];if(w(c,u))continue;for(var p in h.metabolites)if(r||p==t.bigg_id){if(c in i)continue;a?i[c]={reaction_data:h.data,string:c+": "+h.data_string}:i[c]={string:c}}}var d=[],v=e.make_array(i,"reaction_abbreviation");a?v.sort(function(e,t){return Math.abs(t.reaction_data)-Math.abs(e.reaction_data)}):v.sort(function(e,t){return e.string.toLowerCase()<t.string.toLowerCase()?-1:1}),v.forEach(function(e){d.push(e.string)});var m=20,g=this.completely;g.options=d,d.length==1?g.setText(d[0]):g.setText(""),g.onChange=function(e){if(e.length==0){g.options=d,g.repaint();return}var t=d.map(function(t){return t.toLowerCase().indexOf(e.toLowerCase())==0?e+t.slice(e.length):null}).filter(function(e){return e!==null});g.options=t,g.repaint()};var y=this.direction_arrow,b=this.map;g.onEnter=function(){var e=this.getText();this.setText(""),v.forEach(function(i){i.string.toLowerCase()==e.toLowerCase()&&(r?b.new_reaction_from_scratch(i.reaction_abbreviation,n,y.get_rotation()):b.new_reaction_for_metabolite(i.reaction_abbreviation,t.node_id,y.get_rotation()))})},g.repaint(),this.completely.input.focus()}function b(e){if(e===undefined)this.start_reaction_listener=!this.start_reaction_listener;else{if(this.start_reaction_listener==e)return;this.start_reaction_listener=e}this.start_reaction_listener?(this.map.sel.on("click.start_reaction",function(e){if(this.direction_arrow.dragging)return;var t={x:d3.mouse(e)[0],y:d3.mouse(e)[1]};this.map.deselect_nodes(),this.map.deselect_text_labels(),this.reload(null,t,!0),this.show_target(this.map,t)}.bind(this,this.map.sel.node())),this.map.sel.classed("start-reaction-cursor",!0)):(this.map.sel.on("click.start_reaction",null),this.map.sel.classed("start-reaction-cursor",!1),this.hide_target())}function w(){this.target_coords&&this.map.sel.selectAll(".start-reaction-target").remove(),this.target_coords=null}function E(e,t){var n=e.sel.selectAll(".start-reaction-target").data([12,5]);n.enter().append("circle").classed("start-reaction-target",!0).attr("r",function(e){return e}).style("stroke-width",4),n.style("visibility","visible").attr("transform","translate("+t.x+","+t.y+")"),this.target_coords=t}var u=e.make_class();return u.prototype={init:a,setup_map_callbacks:f,setup_zoom_callbacks:l,is_visible:c,toggle:h,show_dropdown:p,hide_dropdown:d,place_at_selected:v,place:m,reload_at_selected:g,reload:y,toggle_start_reaction_listener:b,hide_target:w,show_target:E},u}),n("CobraModel",["utils","data_styles"],function(e,t){function r(t){if(!t.reactions||!t.metabolites)throw new Error("Bad model data.");this.reactions={};for(var n=0,r=t.reactions.length;n<r;n++){var i=t.reactions[n],s=i.id;this.reactions[s]=e.clone(i),delete this.reactions[s].id}this.metabolites={};for(var n=0,r=t.metabolites.length;n<r;n++){var i=t.metabolites[n],s=i.id;this.metabolites[s]=e.clone(i),delete this.metabolites[s].id}"cofactors"in t?t.cofactors instanceof Array?this.cofactors=t.cofactors:(console.warn("model_data.cofactors should be an array. Ignoring it"),this.cofactors=[]):this.cofactors=[]}function i(e,n){for(var r in this.reactions){var i=this.reactions[r];if(e===null)i.data=null,i.data_string="";else{var s=r in e?e[r]:null,o=t.float_for_data(s,n),u=t.text_for_data(s,n);i.data=o,i.data_string=u}}}function s(e,n){for(var r in this.metabolites){var i=this.metabolites[r];if(e===null)i.data=null,i.data_string="";else{var s=r in e?e[r]:null,o=t.float_for_data(s,n),u=t.text_for_data(s,n);i.data=o,i.data_string=u}}}var n=e.make_class();return n.prototype={init:r,apply_reaction_data:i,apply_metabolite_data:s},n}),n("Brush",["utils"],function(e){function n(e,t,n,r){this.brush_sel=e.append("g").attr("id","brush-container");var i=this.brush_sel.node(),s=e.select(r).node().nextSibling;i!==s&&i.parentNode.insertBefore(i,s),this.enabled=t,this.map=n}function r(){return this.map.sel.select(".brush").empty()}function i(e){e===undefined&&(e=!this.enabled),e?this.selection_brush=this.setup_selection_brush():this.brush_sel.selectAll(".brush").remove()}function s(){var e=this.brush_sel,t=this.map.sel.select("#nodes"),n=this.map.canvas.size_and_location(),r=n.width,i=n.height,s=n.x,o=n.y,u=d3.svg.brush().x(d3.scale.identity().domain([s,s+r])).y(d3.scale.identity().domain([o,o+i])).on("brush",function(e){var n=e.held_keys.shift,r=d3.event.target.extent(),i;n?i=t.selectAll(".node:not(.selected)"):i=t.selectAll(".node"),i.classed("selected",function(e){var t=e.x,n=e.y;return r[0][0]<=t&&t<r[1][0]&&r[0][1]<=n&&n<r[1][1]})}.bind(null,this.map.key_manager)).on("brushend",function(){d3.event.target.clear(),d3.select(this).call(d3.event.target)}),a=e.append("g").attr("class","brush").call(u);return e.selectAll(".background").classed("cursor-grab",!1).classed("cursor-grabbing",!1).style("cursor",null),a}var t=e.make_class();return t.prototype={init:n,toggle:i,setup_selection_brush:s},t}),n("ui",["utils"],function(e){function t(e,t){var n=e.append("button"),r=n.append("span");"id"in t&&n.attr("id",t.id),"classes"in t&&n.attr("class",t.classes),"text"in t&&r.text(t.text),"icon"in t&&r.classed(t.icon,!0),"key"in t&&s(n,t.key),n.attr("title",t.tooltip)}function n(e){var t=e.append("li").attr("class","btn-group-vertical").attr("data-toggle","buttons");return{button:function(e){var n=t.append("label").attr("class","btn btn-default");n.append("input").attr("type","radio");var r=n.append("span");return"id"in e&&n.attr("id",e.id),"text"in e&&r.text(e.text),"icon"in e&&r.classed(e.icon,!0),"key"in e&&s(n,e.key),"tooltip"in e&&n.attr("title",e.tooltip),this}}}function r(e){var t=e.attr("class","btn-group-vertical");return{button:function(e){var n=t.append("button").attr("class","btn btn-default"),r=n.append("span");return"id"in e&&n.attr("id",e.id),"text"in e&&r.text(e.text),"icon"in e&&r.classed(e.icon,!0),"key"in e&&s(n,e.key),"tooltip"in e&&n.attr("title",e.tooltip),this}}}function i(e,t,n){n===undefined&&(n=!1);var r=e.append("li").attr("class","dropdown");r.append("button").text(t+" ").attr("class","btn btn-link btn-sm dropdown-button").attr("data-toggle","dropdown").append("b").attr("class","caret");var i=r.append("ul").attr("class","dropdown-menu").classed("pull-right",n).attr("role","menu").attr("aria-labelledby","dLabel");return{button:function(e){var t=i.append("li").attr("role","presentation"),n=t.append("a").attr("href","#"),r=n.append("span").attr("class","dropdown-button-icon"),u=n.append("span").attr("class","dropdown-button-text");"id"in e&&t.attr("id",e.id),"text"in e&&u.text(" "+e.text),"icon"in e&&r.classed(e.icon,!0);if("key"in e)s(n,e.key);else if("input"in e){var a=e.input,f=o(n,t,a.fn);"assign"in a&&"key"in a&&(a.assign[a.key]=f)}return this},divider:function(){return i.append("li").attr("role","presentation").attr("class","divider"),this}}}function s(e,t,n){n!==undefined&&e.text(n),e.on("click",function(){t.fn.call(t.target)})}function o(t,n,r){var i=n.append("input").attr("type","file").style("display","none").on("change",function(){e.load_json(this.files[0],function(e,t){r(e,t),this.value=""}.bind(this))});return t.on("click",function(e){i.node().click()}),function(){i.node().click()}}return{individual_button:t,radio_button_group:n,button_group:r,dropdown_menu:i,set_button:s,set_input_button:o}}),n("SearchBar",["utils","CallbackManager"],function(e,t){function r(e,n,r){var i=e.attr("class","search-container").style("display","none");this.input=i.append("input").attr("class","search-bar");var s=i.append("div").attr("class","btn-group btn-group-sm");s.append("button").attr("class","btn btn-default").on("click",this.previous.bind(this)).append("span").attr("class","glyphicon glyphicon-chevron-left"),s.append("button").attr("class","btn btn-default").on("click",this.next.bind(this)).append("span").attr("class","glyphicon glyphicon-chevron-right"),this.counter=i.append("div").attr("class","search-counter"),i.append("button").attr("class","btn btn-sm btn-default close-button").on("click",function(){this.toggle(!1)}.bind(this)).append("span").attr("class","glyphicon glyphicon-remove"),this.callback_manager=new t,this.selection=i,this.map=r,this.search_index=n,this.current=1,this.results=null,this.input.on("input",function(e){this.current=1,this.results=this.search_index.find(e.value),this.update()}.bind(this,this.input.node()))}function i(){return this.selection.style("display")!="none"}function s(e){e===undefined?this.is_active=!this.is_active:this.is_active=e,this.is_active?(this.selection.style("display",null),this.counter.text(""),this.input.node().value="",this.input.node().focus(),this.escape=this.map.key_manager.add_escape_listener(function(){this.toggle(!1)}.bind(this)),this.escape=this.map.key_manager.add_enter_listener(function(){this.next()}.bind(this)),this.callback_manager.run("show")):(this.map.highlight(null),this.selection.style("display","none"),this.results=null,this.escape&&this.escape.clear(),this.escape=null,this.enter&&this.enter.clear(),this.enter=null,this.callback_manager.run("hide"))}function o(){if(this.results==null)this.counter.text(""),this.map.zoom_extent_canvas(),this.map.highlight(null);else if(this.results.length==0)this.counter.text("0 / 0"),this.map.zoom_extent_canvas(),this.map.highlight(null);else{this.counter.text(this.current+" / "+this.results.length);var e=this.results[this.current-1];if(e.type=="reaction")this.map.zoom_to_reaction(e.reaction_id),this.map.highlight_reaction(e.reaction_id);else{if(e.type!="metabolite")throw new Error("Bad search index data type: "+e.type);this.map.zoom_to_node(e.node_id),this.map.highlight_node(e.node_id)}}}function u(){if(this.results==null)return;this.current==this.results.length?this.current=1:this.current+=1,this.update()}function a(){if(this.results==null)return;this.current==1?this.current=this.results.length:this.current-=1,this.update()}var n=e.make_class();return n.prototype={init:r,is_visible:i,toggle:s,update:o,next:u,previous:a},n}),n("Settings",["utils","lib/bacon"],function(e,t){function r(e){if(["reaction","metabolite"].indexOf(e)==-1)throw new Error("Bad type")}function i(e,n,r,i){function s(e){var n=e.map(function(e){return e=="hold"}).not().toProperty(!0),r=e.scan(!1,function(e,t){return e==0&&t=="clear"}).not(),i=e.scan(!1,function(e,t){return e==0&&t=="hold"}).not(),s=t.combineAsArray(this,e),o=s.scan([],function(e,t){if(t[1]=="hold")return e.push(t[0]),e;if(t[1]=="accept")return e;if(t[1]=="reject")return[];if(t[1]=="clear")return[t[0]];throw Error("bad status "+t[1])}).filter(n).filter(r).filter(i).flatMap(function(e){return t.fromArray(e)}),u=this.filter(n);return u.merge(o)}function o(e){return t.combineAsArray(this,e.toProperty(!1)).map(function(e){return e[0]})}e===undefined&&(e={reaction:["color","size","abs","text"],metabolite:["color","size","text"]}),n===undefined&&(n={reaction:!0,metabolite:!0}),r===undefined&&(r={reaction:[-10,0,10],metabolite:[-10,0,10]}),i===undefined&&(i={reaction:{color:["rgb(200,200,200)","rgb(150,150,255)","purple"],size:[4,8,12]},metabolite:{color:["green","white","red"],size:[6,8,10]}}),this.data_styles={},this.data_styles_bus={},this.data_styles_stream={},this.auto_domain={},this.auto_domain_bus={},this.auto_domain_stream={},this.domain={},this.domain_bus={},this.domain_stream={},this.range={},this.range_bus={},this.range_stream={},this.status_bus=new t.Bus,this.force_update_bus=new t.Bus,t.Observable.prototype.convert_to_conditional_stream=s,t.Observable.prototype.force_update_with_bus=o,["metabolite","reaction"].forEach(function(s){this.data_styles_bus[s]=new t.Bus,this.data_styles_stream[s]=this.data_styles_bus[s].convert_to_conditional_stream(this.status_bus).scan([],function(e,t){return t===null?e:t.on_off&&e.indexOf(t.style)==-1?e.concat([t.style]):!t.on_off&&e.indexOf(t.style)!=-1?e.filter(function(e){return e!=t.style}):e}).force_update_with_bus(this.force_update_bus),this.data_styles_stream[s].onValue(function(e){this.data_styles[s]=e}.bind(this));var o=e[s];o.forEach(function(e){this.data_styles_bus[s].push({style:e,on_off:!0})}.bind(this)),this.auto_domain_bus[s]=new t.Bus,this.auto_domain_stream[s]=this.auto_domain_bus[s].convert_to_conditional_stream(this.status_bus).force_update_with_bus(this.force_update_bus),this.auto_domain_stream[s].onValue(function(e){this.auto_domain[s]=e}.bind(this));var o=n[s];this.auto_domain_bus[s].push(o),this.domain_bus[s]=new t.Bus,this.domain_stream[s]=this.domain_bus[s].convert_to_conditional_stream(this.status_bus).scan([],function(e,t){return e[t.index]=t.value,e}).force_update_with_bus(this.force_update_bus),this.domain_stream[s].onValue(function(e){this.domain[s]=e}.bind(this));var o=r[s];o.forEach(function(e,t){this.domain_bus[s].push({index:t,value:e})}.bind(this)),this.range_bus[s]={},this.range_stream[s]={},this.range[s]={},["color","size"].forEach(function(e){this.range_bus[s][e]=new t.Bus,this.range_stream[s][e]=this.range_bus[s][e].convert_to_conditional_stream(this.status_bus).scan([],function(e,t){return e[t.index]=t.value,e}).force_update_with_bus(this.force_update_bus),this.range_stream[s][e].onValue(function(t){this.range[s][e]=t}.bind(this));var n=i[s][e];n.forEach(function(t,n){this.range_bus[s][e].push({index:n,value:t})}.bind(this))}.bind(this))}.bind(this))}function s(e,t){r(e),this.auto_domain_bus[e].push(t)}function o(e,t,n){r(e),this.data_styles_bus[e].push({style:t,on_off:n})}function u(e,t,n){r(e),this.domain_bus[e].push({index:t,value:n})}function a(e,t){r(e),t.forEach(function(t,n){this.domain_bus[e].push({index:n,value:t})}.bind(this))}function f(e,t,n,i){r(e),this.range_bus[e][t].push({index:n,value:i})}function l(){this.status_bus.push("hold")}function c(){this.status_bus.push("reject"),this.status_bus.push("clear"),this.force_update_bus.push(!0)}function h(){this.status_bus.push("accept"),this.status_bus.push("clear")}var n=e.make_class();return n.check_type=r,n.prototype={init:i,change_data_style:o,set_auto_domain:s,set_domain_value:u,set_domain:a,set_range_value:f,hold_changes:l,abandon_changes:c,accept_changes:h},n}),n("SettingsBar",["utils","CallbackManager","lib/bacon"],function(e,t,n){function i(e,n,r){this.sel=e,this.settings=n,this.draw=!1;var i=e.append("div").attr("class","settings-box").style("display","none");i.append("button").attr("class","btn btn-sm btn-default close-button").on("click",function(){this.accept_changes()}.bind(this)).append("span").attr("class","glyphicon glyphicon-ok"),i.append("button").attr("class","btn btn-sm btn-default close-button").on("click",function(){this.abandon_changes()}.bind(this)).append("span").attr("class","glyphicon glyphicon-remove"),i.append("div").text("Reaction data").attr("class","settings-section-heading"),this.scale_gui(i.append("div"),"reaction"),i.append("div").text("Metabolite data").attr("class","settings-section-heading"),this.scale_gui(i.append("div"),"metabolite"),this.callback_manager=new t,this.map=r,this.selection=i}function s(){return this.selection.style("display")!="none"}function o(e){e===undefined&&(e=!this.is_visible()),e?(this.hold_changes(),this.selection.style("display","block"),this.selection.select("input").node().focus(),this.escape=this.map.key_manager.add_escape_listener(function(){this.abandon_changes()}.bind(this)),this.enter=this.map.key_manager.add_enter_listener(function(){this.accept_changes()}.bind(this)),this.callback_manager.run("show")):(this.draw&&this.map.draw_everything(),this.selection.style("display","none"),this.escape&&this.escape.clear(),this.enter&&this.enter.clear(),this.escape=null,this.enter=null,this.callback_manager.run("hide"))}function u(){this.settings.hold_changes()}function a(){this.draw=!1,this.settings.abandon_changes(),this.toggle(!1)}function f(){this.sel.selectAll("input").each(function(e){this.blur()}),this.draw=!0,this.settings.accept_changes(),this.toggle(!1)}function l(e,t){var r=e.append("table").attr("class","settings-table"),i=[],s=[],o=[0,1,2],u=this.settings;r.append("tr").selectAll(".settings-number").data([""].concat(o)).enter().append("td").attr("class","settings-number").text(function(e){return e===""?e:"— "+e+" —"}),r.append("tr").call(function(e){e.append("td").text("Domain:");var r=e.selectAll(".input-cell").data(o);r.enter().append("td").attr("class","input-cell").append("input").attr("class","scale-bar-input").each(function(e){n.fromEventTarget(this,"change").onValue(function(n){u.set_domain_value(t,e,n.target.value)}),u.domain_stream[t].onValue(function(t){this.value=t[e]}.bind(this))}),e.append("td").call(function(e){e.append("span").text("auto "),e.append("input").attr("type","checkbox").each(function(){n.fromEventTarget(this,"change").onValue(function(e){var n=e.target.checked;u.set_auto_domain(t,n),r.selectAll("input").attr("disabled",n?"true":null)}),u.auto_domain_stream[t].onValue(function(e){this.checked=e,r.selectAll("input").attr("disabled",e?"true":null)}.bind(this))})})}.bind(this)),[["size","Size"],["color","Color"]].forEach(function(e){var i=r.append("tr");i.append("td").text(e[1]+":");var s=i.selectAll(".input-cell").data(o);s.enter().append("td").attr("class","input-cell").append("input").attr("class","scale-bar-input").each(function(r){n.fromEventTarget(this,"change").onValue(function(n){u.set_range_value(t,e[0],r,n.target.value)}),u.range_stream[t][e[0]].onValue(function(e){this.value=e[r]}.bind(this))})}),r.append("tr").call(function(e){e.append("td").text("Styles:");var r=e.append("td").attr("colspan",o.length+1),i=["abs","size","color","text"],s=r.selectAll(".style-span").data(i),a=s.enter().append("span").attr("class","style-span");a.append("span").text(function(e){return e}),a.append("input").attr("type","checkbox").each(function(e){var r=n.fromEventTarget(this,"change").onValue(function(n){u.change_data_style(t,e,n.target.checked)});u.data_styles_stream[t].onValue(function(t){this.checked=t.indexOf(e)!=-1}.bind(this))})})}var r=e.make_class();return r.prototype={init:i,is_visible:s,toggle:o,hold_changes:u,abandon_changes:a,accept_changes:f,scale_gui:l},r}),n("Builder",["utils","Input","ZoomContainer","Map","CobraModel","Brush","CallbackManager","ui","SearchBar","Settings","SettingsBar"],function(e,t,n,r,i,s,o,u,a,f,l){function h(t){function r(e,t){e&&console.warn(e),this.options.map_data=t}function i(e,t){e&&console.warn(e),this.options.cobra_model=t}function s(e,t){e&&console.warn(e),this.options.css=t}function o(e,t){e&&console.warn(e),this.options.reaction_data=t}function u(e,t){e&&console.warn(e),this.options.metabolite_data=t}this.options=e.set_options(t,{selection:d3.select("body").append("div"),menu:"all",scroll_behavior:"pan",enable_editing:!0,enable_keys:!0,enable_search:!0,fillScreen:!1,map_path:null,map:null,cobra_model_path:null,cobra_model:null,css_path:null,css:null,starting_reaction:null,auto_reaction_domain:!0,reaction_data_path:null,reaction_data:null,reaction_styles:["color","size","abs","text"],reaction_domain:[-10,0,10],reaction_color_range:["rgb(200,200,200)","rgb(150,150,255)","purple"],reaction_size_range:[4,8,12],metabolite_data:null,metabolite_data_path:null,metabolite_styles:["color","size","text"],auto_metabolite_domain:!0,metabolite_domain:[-10,0,10],metabolite_color_range:["green","white","red"],metabolite_size_range:[6,8,10]}),this.settings=new f({reaction:this.options.reaction_styles,metabolite:this.options.metabolite_styles},{reaction:this.options.auto_reaction_domain,metabolite:this.options.auto_metabolite_domain},{reaction:this.options.reaction_domain,metabolite:this.options.metabolite_domain},{reaction:{color:this.options.reaction_color_range,size:this.options.reaction_size_range},metabolite:{color:this.options.metabolite_color_range,size:this.options.metabolite_size_range}});if(e.check_for_parent_tag(this.options.selection,"svg"))throw new Error("Builder cannot be placed within an svg node becuase UI elements are html-based.");var n=[{file:this.options.map_path,value:this.options.map,callback:r},{file:this.options.cobra_model_path,value:this.options.cobra_model,callback:i},{file:this.options.css_path,value:this.options.css,callback:s},{file:this.options.reaction_data_path,value:this.options.reaction_data,callback:o},{file:this.options.metabolite_data_path,value:this.options.metabolite_data,callback:u}];e.load_files(this,n,p);return}function p(){var u=!0,f=!1;this.callback_manager=o();var c=null;this.options.cobra_model!==null?c=i(this.options.cobra_model):console.warn("No cobra model was loaded."),e.remove_child_nodes(this.options.selection);var h=e.setup_svg(this.options.selection,this.options.selection_is_svg,this.options.fill_screen);this.zoom_container=new n(h,this.options.selection,this.options.scroll_behavior);var p=this.zoom_container.zoomed_sel;this.options.map_data!==null?(this.map=r.from_data(this.options.map_data,h,this.options.css,p,this.zoom_container,this.settings,this.options.reaction_data,this.options.metabolite_data,c,this.options.enable_search),this.zoom_container.reset()):this.map=new r(h,this.options.css,p,this.zoom_container,this.settings,this.options.reaction_data,this.options.metabolite_data,c,null,this.options.enable_search),this.reaction_input=t(this.options.selection,this.map,this.zoom_container),this.brush=new s(p,!1,this.map,".canvas-group"),this._setup_modes(this.map,this.brush,this.zoom_container);var d=this.options.selection.append("div").attr("class","search-menu-container").append("div").attr("class","search-menu-container-inline"),v=d.append("div"),m=d.append("div"),g=d.append("div"),y=this.options.selection.append("div");this.search_bar=a(m,this.map.search_index,this.map),this.settings_page=l(g,this.settings,this.map),this.search_bar.callback_manager.set("show",function(){this.settings_page.toggle(!1)}.bind(this)),this.settings_page.callback_manager.set("show",function(){this.search_bar.toggle(!1)}.bind(this));var b=this._get_keys(this.map,this.zoom_container,this.search_bar,this.settings_page,this.options.enable_editing);this.map.key_manager.assigned_keys=b,this.map.key_manager.input_list=[this.reaction_input,this.search_bar,this.settings_page],this.map.key_manager.update(),this.map.key_manager.toggle(this.options.enable_keys),this.options.menu=="all"?this._setup_menu(v,y,this.map,this.zoom_container,this.map.key_manager,b,this.options.enable_editing):this.options.menu=="zoom"&&this._setup_simple_zoom_buttons(y,b);var w=this._setup_status(this.options.selection,this.map);if(this.options.map_data!==null)this.map.zoom_extent_canvas();else if(this.options.starting_reaction!==null&&c!==null){var E=this.zoom_container.get_size(),S={x:E.width/2,y:E.height/4};this.map.new_reaction_from_scratch(this.options.starting_reaction,S,90),this.map.zoom_extent_nodes()}else this.map.zoom_extent_canvas();this.options.enable_editing?this.zoom_mode():this.view_mode(),this.map.draw_everything()}function d(e){this.search_bar.toggle(!1),this.reaction_input.toggle(e=="build"),this.reaction_input.direction_arrow.toggle(e=="build"),this.options.menu=="all"&&this.options.enable_editing&&this._toggle_direction_buttons(e=="build"),this.brush.toggle(e=="brush"),this.zoom_container.toggle_zoom(e=="zoom"||e=="view"),this.map.canvas.toggle_resize(e=="zoom"||e=="brush"),this.map.behavior.toggle_rotation_mode(e=="rotate"),this.map.behavior.toggle_node_click(e=="build"||e=="brush"),this.map.behavior.toggle_node_drag(e=="brush"),this.map.behavior.toggle_text_label_click(e=="brush"),this.map.behavior.toggle_label_drag(e=="brush"),e=="view"&&this.map.select_none(),this.map.draw_everything()}function v(){this.callback_manager.run("view_mode"),this.set_mode("view")}function m(){this.callback_manager.run("build_mode"),this.set_mode("build")}function g(){this.callback_manager.run("brush_mode"),this.set_mode("brush")}function y(){this.callback_manager.run("zoom_mode"),this.set_mode("zoom")}function b(){this.callback_manager.run("rotate_mode"),this.set_mode("rotate")}function w(e,t,n,r,s,o,a){function m(e,t){e&&console.warn(e),this.options.map_data=t,this.reload_builder()}function g(e,t){e&&console.warn(e);var n=i(t);this.map.set_model(n),this.reaction_input.toggle(!1)}function y(e,t){e&&console.warn(e),this.map.set_reaction_data(t)}function b(e,t){e&&console.warn(e),this.map.set_metabolite_data(t)}var f=e.attr("id","menu").append("ul").attr("class","nav nav-pills");u.dropdown_menu(f,"Map").button({key:o.save,text:"Save as JSON (Ctrl s)"}).button({text:"Load map JSON (Ctrl o)",input:{assign:s.assigned_keys.load,key:"fn",fn:m.bind(this)}}).button({key:o.save_svg,text:"Export as SVG (Ctrl Shift s)"}).button({key:o.clear_map,text:"Clear map"}),u.dropdown_menu(f,"Model").button({text:"Load COBRA model JSON (Ctrl m)",input:{assign:s.assigned_keys.load_model,key:"fn",fn:g.bind(this)}});var l=u.dropdown_menu(f,"Data").button({input:{assign:s.assigned_keys.load_reaction_data,key:"fn",fn:y.bind(this)},text:"Load reaction data"}).button({key:o.clear_reaction_data,text:"Clear reaction data"}).button({input:{fn:b.bind(this)},text:"Load metabolite data"}).button({key:o.clear_metabolite_data,text:"Clear metabolite data"}).button({key:o.show_settings,text:"Settings (Ctrl ,)"}),c=u.dropdown_menu(f,"Edit",!0);a?c.button({key:o.build_mode,id:"build-mode-menu-button",text:"Add reaction mode (n)"}).button({key:o.zoom_mode,id:"zoom-mode-menu-button",text:"Pan mode (z)"}).button({key:o.brush_mode,id:"brush-mode-menu-button",text:"Select mode (v)"}).button({key:o.rotate_mode,id:"rotate-mode-menu-button",text:"Rotate mode (r)"}).divider().button({key:o.delete,text:"Delete (Ctrl Del)"}).button({key:o.undo,text:"Undo (Ctrl z)"}).button({key:o.redo,text:"Redo (Ctrl Shift z)"}).button({key:o.make_primary,text:"Make primary metabolite (p)"}).button({key:o.cycle_primary,text:"Cycle primary metabolite (c)"}).button({key:o.select_none,text:"Select none (Ctrl Shift a)"}):c.button({key:o.view_mode,id:"view-mode-menu-button",text:"View mode"});var h=u.dropdown_menu(f,"View",!0).button({key:o.zoom_in,text:"Zoom in (Ctrl +)"}).button({key:o.zoom_out,text:"Zoom out (Ctrl -)"}).button({key:o.extent_nodes,text:"Zoom to nodes (Ctrl 0)"}).button({key:o.extent_canvas,text:"Zoom to canvas (Ctrl 1)"}).button({key:o.search,text:"Find (Ctrl f)"});a&&(h.button({key:o.toggle_beziers,id:"bezier-button",text:"Show control points (b)"}),n.callback_manager.set("toggle_beziers.button",function(e){f.select("#bezier-button").select(".dropdown-button-text").text((e?"Hide":"Show")+" control points (b)")}));var p=t.append("ul").attr("class","nav nav-pills nav-stacked").attr("id","button-panel");u.individual_button(p.append("li"),{key:o.zoom_in,icon:"glyphicon glyphicon-plus-sign",classes:"btn btn-default",tooltip:"Zoom in (Ctrl +)"}),u.individual_button(p.append("li"),{key:o.zoom_out,icon:"glyphicon glyphicon-minus-sign",classes:"btn btn-default",tooltip:"Zoom out (Ctrl -)"}),u.individual_button(p.append("li"),{key:o.extent_canvas,icon:"glyphicon glyphicon-resize-full",classes:"btn btn-default",tooltip:"Zoom to canvas (Ctrl 1)"});if(a){u.radio_button_group(p.append("li")).button({key:o.build_mode,id:"build-mode-button",icon:"glyphicon glyphicon-plus",tooltip:"Add reaction mode (n)"}).button({key:o.zoom_mode,id:"zoom-mode-button",icon:"glyphicon glyphicon-move",tooltip:"Pan mode (z)"}).button({key:o.brush_mode,id:"brush-mode-button",icon:"glyphicon glyphicon-hand-up",tooltip:"Select mode (v)"}).button({key:o.rotate_mode,id:"rotate-mode-button",icon:"glyphicon glyphicon-repeat",tooltip:"Rotate mode (r)"}),this.direction_buttons=p.append("li");var d=u.button_group(this.direction_buttons).button({key:o.direction_arrow_left,icon:"glyphicon glyphicon-arrow-left",tooltip:"Direction arrow (←)"}).button({key:o.direction_arrow_right,icon:"glyphicon glyphicon-arrow-right",tooltip:"Direction arrow (→)"}).button({key:o.direction_arrow_up,icon:"glyphicon glyphicon-arrow-up",tooltip:"Direction arrow (↑)"}).button({key:o.direction_arrow_down,icon:"glyphicon glyphicon-arrow-down",tooltip:"Direction arrow (↓)"})}var v=function(e){var t=["#build-mode-menu-button","#zoom-mode-menu-button","#brush-mode-menu-button","#rotate-mode-menu-button","#view-mode-menu-button"];for(var n=0,r=t.length;n<r;n++){var i=t[n];d3.select(i).select("span").classed("glyphicon",i==e).classed("glyphicon-ok",i==e)}};this.callback_manager.set("build_mode",function(){$("#build-mode-button").button("toggle"),v("#build-mode-menu-button")}),this.callback_manager.set("zoom_mode",function(){$("#zoom-mode-button").button("toggle"),v("#zoom-mode-menu-button")}),this.callback_manager.set("brush_mode",function(){$("#brush-mode-button").button("toggle"),v("#brush-mode-menu-button")}),this.callback_manager.set("rotate_mode",function(){$("#rotate-mode-button").button("toggle"),v("#rotate-mode-menu-button")}),this.callback_manager.set("view_mode",function(){$("#view-mode-button").button("toggle"),v("#view-mode-menu-button")})}function E(e,t){var n=e.append("div").attr("id","simple-button-panel");u.individual_button(n.append("div"),{key:t.zoom_in,text:"+",classes:"simple-button",tooltip:"Zoom in (Ctrl +)"}),u.individual_button(n.append("div"),{key:t.zoom_out,text:"–",classes:"simple-button",tooltip:"Zoom out (Ctrl -)"}),u.individual_button(n.append("div"),{key:t.extent_canvas,text:"↔",classes:"simple-button",tooltip:"Zoom to canvas (Ctrl 1)"})}function S(e){e===undefined&&(e=!this.direction_buttons.style("visibility")=="visible"),this.direction_buttons.style("visibility",e?"visible":"hidden")}function x(e,t){var n=e.append("div").attr("id","status");return t.callback_manager.set("set_status",function(e){n.text(e)}),n}function T(e,t,n){var r={};e.callback_manager.set("start_rotation",function(){r.brush=t.enabled,t.toggle(!1),r.zoom=n.zoom_on,n.toggle_zoom(!1),r.node_click=e.behavior.node_click!=null,e.behavior.toggle_node_click(!1)}),e.callback_manager.set("end_rotation",function(){t.toggle(r.brush),n.toggle_zoom(r.zoom),e.behavior.toggle_node_click(r.node_click),r={}})}function N(t,n,r,i,s){var o={save:{key:83,modifiers:{control:!0},target:t,fn:t.save},save_svg:{key:83,modifiers:{control:!0,shift:!0},target:t,fn:t.save_svg},load:{key:79,modifiers:{control:!0},fn:null},clear_map:{target:t,fn:function(){this.clear_map()}},load_model:{key:77,modifiers:{control:!0},fn:null},load_reaction_data:{fn:null},clear_reaction_data:{target:t,fn:function(){this.set_reaction_data(null)}},load_metabolite_data:{fn:null},clear_metabolite_data:{target:t,fn:function(){this.set_metabolite_data(null)}},zoom_in:{key:187,modifiers:{control:!0},target:n,fn:n.zoom_in},zoom_out:{key:189,modifiers:{control:!0},target:n,fn:n.zoom_out},extent_nodes:{key:48,modifiers:{control:!0},target:t,fn:t.zoom_extent_nodes},extent_canvas:{key:49,modifiers:{control:!0},target:t,fn:t.zoom_extent_canvas},search:{key:70,modifiers:{control:!0},fn:r.toggle.bind(r,!0)},view_mode:{fn:this.view_mode.bind(this),ignore_with_input:!0}};return s&&e.extend(o,{build_mode:{key:78,target:this,fn:this.build_mode,ignore_with_input:!0},zoom_mode:{key:90,target:this,fn:this.zoom_mode,ignore_with_input:!0},brush_mode:{key:86,target:this,fn:this.brush_mode,ignore_with_input:!0},rotate_mode:{key:82,target:this,fn:this.rotate_mode,ignore_with_input:!0},toggle_beziers:{key:66,target:t,fn:t.toggle_beziers,ignore_with_input:!0},"delete":{key:8,modifiers:{control:!0},target:t,fn:t.delete_selected,ignore_with_input:!0},delete_del:{key:46,modifiers:{control:!0},target:t,fn:t.delete_selected,ignore_with_input:!0},make_primary:{key:80,target:t,fn:t.make_selected_node_primary,ignore_with_input:!0},cycle_primary:{key:67,target:t,fn:t.cycle_primary_node,ignore_with_input:!0},direction_arrow_right:{key:39,fn:this.reaction_input.direction_arrow.right.bind(this.reaction_input.direction_arrow),ignore_with_input:!0},direction_arrow_down:{key:40,fn:this.reaction_input.direction_arrow.down.bind(this.reaction_input.direction_arrow),ignore_with_input:!0},direction_arrow_left:{key:37,fn:this.reaction_input.direction_arrow.left.bind(this.reaction_input.direction_arrow),ignore_with_input:!0},direction_arrow_up:{key:38,fn:this.reaction_input.direction_arrow.up.bind(this.reaction_input.direction_arrow),ignore_with_input:!0},undo:{key:90,modifiers:{control:!0},target:t.undo_stack,fn:t.undo_stack.undo},redo:{key:90,modifiers:{control:!0,shift:!0},target:t.undo_stack,fn:t.undo_stack.redo},select_none:{key:65,modifiers:{control:!0,shift:!0},target:t,fn:t.select_none},show_settings:{key:188,modifiers:{control:!0},fn:i.toggle.bind(i)}}),o}var c=e.make_class();return c.prototype={init:h,reload_builder:p,set_mode:d,view_mode:v,build_mode:m,brush_mode:g,zoom_mode:y,rotate_mode:b,_toggle_direction_buttons:S,_setup_menu:w,_setup_simple_zoom_buttons:E,_setup_status:x,_setup_modes:T,_get_keys:N},c}),n("DataMenu",["utils"],function(e){return function(t){function s(e,t,n,r,i){n.node().addEventListener("change",function(){o(e,this.value,i,r)},!1);var s=t[0];u(t,n),o(e,s,i,r)}function o(t,r,i,s){e.load_the_file(t,r,function(e,t){if(e)return console.warn(e);n.data=t,s&&s(t)})}function u(e,t){t.selectAll(".menu-option").data(e).enter().append("option").attr("value",function(e){return e}).text(function(e){return e}),t.node().focus()}function a(){return n.data}var n=e.set_options(t,{selection:null,getdatafiles:null,datafiles:null,update_callback:null,target:null});if(n.selection===null)throw new Error("No selection provided for DataMenu");var r=n.selection.select(".data-menu");r.empty()&&(r=n.selection.append("div").attr("class","data-menu"));var i=r.append("form").append("select").attr("class","dropdown-menu");return n.getdatafiles?(n.datafiles&&console.warn("DataMenu: getdatafiles option overrides datafiles"),d3.json(n.getdatafiles,function(e,t){return e?console.warn(e):(s(n.target,t.data,i,n.update_callback,n.selection),null)})):n.datafiles?s(n.target,n.datafiles,i,n.update_callback,n.selection):console.warn("DataMenu: No datafiles given"),{update:u}}}),n("main",["Builder","Map","Behavior","KeyManager","DataMenu","UndoStack","CobraModel","utils","SearchIndex","Settings"],function(e,t,n,r,i,s,o,u,a,f){return{Builder:e,Map:t,Behavior:n,KeyManager:r,DataMenu:i,UndoStack:s,CobraModel:o,utils:u,SearchIndex:a,Settings:f}}),t("main")});