from etb.wrapper import Tool

class List(Tool):
    @Tool.predicate("+v: value")
    def nil(self, v):
        if len(v.get_args()) == 0:
            return [{}]
        else:
            return []

    @Tool.predicate("+v: value")
    def cons(self, v):
        if len(v.get_args()) == 0:
            return []
        else:
            return [{}]
        
    @Tool.predicate("+list: value, -head: value")
    def hd(self, l, head):
        if l.is_const() or len(l.get_args()) == 0:
            return []
        else:
            return [self.bindResult(head, l.get_args()[0])]

    @Tool.predicate("+list: value, -tail: value")
    def tl(self, l, tail):
        if l.is_const() or len(l.get_args()) == 0:
            return []
        else:
            return [self.bindResult(tail, l.get_args()[1:])]
        
def register(etb):
    "Register the tool"
    etb.add_tool(List(etb))
