# Batch wrapper for HybridSAL

import os.path

from etb.wrapper import Tool, BatchTool

class HybridSAL(BatchTool):

    @Tool.predicate("+hsal_file: file, -sal_file: file")
    def hsal(self, hsal_file, sal_file) :
        out_file = os.path.splitext(hsal_file['file'])[0] + '.sal'
        self.callTool('hsal2hasal', hsal_file['file'])
        out_ref = self.fs.put_file(out_file)
        return [self.bindResult(sal_file, out_ref)]
        
def register(etb):
    "Register the tool"
    etb.add_tool(HybridSAL(etb))

