# ETB wrapper for sal-inf-bmc

from etb.wrapper import Tool, BatchTool

class Sal(BatchTool):

    @Tool.predicate("+model:file, +prop:value, +depth:value, -ans:value, -cex:value")
    def sal_inf_bmc(self, model, prop, depth, ans, cex):
        '''Calls sal-inf-bmc'''
        (ret, out, _) = self.callTool('sal-inf-bmc', '-i', '-d', str(depth.val), model['file'], str(prop.val))
        if (ret == 0):
            if 'no counter-example' in out:
                bindings = self.bindResult(cex, '')
                bindings = [self.bindResult(ans, 'no counter-example between [0..%s]' % str(depth.val), bindings)]
            else:
                bindings = []
        else:
            return { 'claims': [ 'error("sal_inf_bmc")']}
        return bindings

    @Tool.predicate("+model:file, +prop:value, +depth:value, -ans:value, -cex:value")
    def sal_inf_bmc_induction(self, model, prop, depth, ans, cex):
        '''Calls sal-inf-bmc with k-induction'''
        (ret, out, _) = self.callTool('sal-inf-bmc', '-i', '-d', str(depth.val), model['file'], str(prop.val))
        if (ret == 0):
            if 'proved.' in out:
                bindings = self.bindResult(cex, '')
                bindings = [self.bindResult(ans, 'proved', bindings)]
            else:
                bindings = self.bindResult(cex, out)
                bindings = [self.bindResult(ans, 'invalid', bindings)]
        else:
            return { 'claims': [ 'error("sal_inf_bmc_induction")']}
        return bindings
    
def register(etb):
    "Register the tool"
    etb.add_tool(Sal(etb))
