# Test for changing a file in place

from etb.wrapper import Tool, Lemmata, Queries, Substitutions, Success, Failure

import etb.terms

class InPlace(Tool):

  @Tool.predicate('+infile: file, +text: value, -outfile: file')
  def inplace(self, infile, text, outfile):
    ifile = infile['file']
    with open(ifile, "a") as myfile:
      myfile.write(text.val)
    ifref = self.fs.put_file(ifile)
    print 'inplace: infile = {0}'.format(infile)
    return Substitutions(self, [self.bindResult(outfile, ifref)])

        
def register(etb):
    etb.add_tool(InPlace(etb))


