% -*- prolog -*-

% sample rules, for testing 

good_int(X) :- in_range(1, 6, X).
bad_int(X) :- in_range(5, 10, X).

controversial_int(X) :- good_int(X), bad_int(X).

% Examples of HiLiTe workflow

valid_model(Spec, Model) :- spec_contains_ranges(Spec, SpecRanges),
                            hilite_ranges(Model, ModelRanges),
                            match_ranges(SpecRanges, ModelRanges).

% Iterators

forall(P, cons(X, nil)) :- P(X).
forall(P, cons(X, Y)) :- P(X), forall(P, Y).

% A SAL workflow


prove(F,M,P) :- sal_file(F), sal_smc(F,P), sal_deadlock_check(F,M).

% sat_dimacs(I, O) :- yices_dimacs(I, O).

sat_dimacs(I, Sat, Model) :- yices_dimacs(I, Sat, Model).
