%% Rules for lists

%% All these predicates are defined over non-empty lists.

list_forall(P, L) :- hd(L, Hd), tl(L, Tl), P(Hd), nil(Tl).
list_forall(P, L) :- hd(L, Hd), tl(L, Tl), P(Hd), list_forall(P, Tl).

list_exists(P, L) :- hd(L, Hd), P(Hd).
list_exists(P, L) :- tl(L, Tl), list_exists(P, Tl).

list_fold(P, L, Acc, Result) :- hd(L, Hd), tl(L, Tl), P(Hd, Acc, Result), nil(Tl).
list_fold(P, L, Acc, Result) :- hd(L, Hd), tl(L, Tl), 
                                P(Hd, Acc, Intermediate), 
                                list_fold(P, Tl, Intermediate, Result).

list_map(P, L, Result) :- hd(L, Hd), tl(L, Tl),
                          P(Hd, RHd), nil(Tl), nil(RTl),
                          cons(RHd, RTl, Result).
list_map(P, L, Result) :- hd(L, Hd), tl(L, Tl),
                          P(Hd, RHd), list_map(P, Tl, RTl),
                          cons(RHd, RTl, Result).
