# Batch wrapper for pydoc

from etb.wrapper import Tool, BatchTool

class Pydoc(BatchTool):
    """Batch wrapper for Pydoc"""

    @Tool.predicate("+src:file, -result:file")
    def pydoc(self, src, result) :
        """Calls pydoc on the source file, output html in the result."""
        return self.run(result, 'pydoc', '-w', src)

def register(toolbus):
    "Register the tool"
    toolbus.add_tool(Pydoc(toolbus))
