# ETB wrapper around SALenv

import json
import re
import os.path
import subprocess
import logging

from etb.wrappers import Tool, InteractiveTool, isvariable, Literal

from multiprocessing import Process

class SALenv(InteractiveTool) :
    """ETB wrapper around SALenv."""

    def __init__(self, *args, **kwargs) :
        pass

    @Tool.predicate("-session: value")
    def get_new_session(self, session) :
        def call_salenv() :
            subprocess.Popen('salenv')
        p = Process(target=call_salenv, args=())
        p.start()
        return [{session: p}]

    @Tool.predicate("")
    def eval(self, session, str) :
        pass

    @Tool.predicate("")
    def close_session(self, session) :
        pass

def register(etb) :
    """Register SALenv"""
    etb.add_tool(SALenv())
