from __future__ import with_statement
import os
import sys

import ctypes
import tempfile
import re

class yicesContextManager(object):
    """  A context manager for Yices that encapsulates the operations on a context.  """

    def __init__(self, libyices):
        """
        Creates a fresh context.
        """
        self.libyices = libyices
        self.context = yices_library.yices_mk_context()

    def yices_command(self, command):
        return self.libyices.yices_parse_command(cxt, command)

    def version(self):
        ''' Return the version of yices.  Not used anywhere.'''
        return libyices.yices_version()

    def yices_assert_plus(self, formula):
        """retractable assertion of formula. """
        yicesexpr = libyices.yices_parse_expression(self.context,yformula);
        if yicesexpr:
            return self.libyices.yices_assert_retractable(self.context, yicesexpr)
        else:
            return 0

    def yices_push(self):
        ''' Utility for pushing the scope in a context.'''
        return self.libyices.yices_parse_command(self.context, '(push)')

    def yices_pop(self):
        return self.libyices.yices_parse_command(self.context, '(pop)')

    def yices_check(self):
        result = self.libyices.yices_check(self.context)
        return yices_lbool_results[result + 1]

