# Yices wrapper

import os
import re

from etb.wrapper import Tool, InteractiveTool

class Yices(InteractiveTool):
    """ETB wrapper for yices"""

    def parse_stop(self, s):
        return (s == '') or (s == 'yices >')

    def parse_error(self, s):
        error = re.search('Error: (.*)', s)
        if error is None:
            return None
        else:
            return error.group(0)

    @Tool.predicate("-Session:handle")
    def yices_start(self, session):
        s = self.connect('yices', '-i')
        self.write(s, '\n')
        return [{ session: s }]

    @Tool.predicate("+SessionIn:handle, +declaration:value, -SessionOut:handle")
    def yices_declare(self, sessionIn, decl, sessionOut):
        self.write(sessionIn, decl + '\n')
        print 'Declared'
        return [{ sessionOut: self.updateSession(sessionIn) }]

    @Tool.predicate("+SessionIn:handle, +YicesFile:file, -SessionOut:handle")
    def yices_include(self, sessionIn, yices_file, sessionOut):
        self.write(sessionIn, '(include "%s")\n' % yices_file)
        return [{ sessionOut: self.updateSession(sessionIn) }]

    @Tool.predicate("+SessionIn:handle, -SessionOut:handle")
    def yices_reset(self, sessionIn, sessionOut):
        self.write(sessionIn, '(reset)\n')
        return [{ sessionOut: self.updateSession(sessionIn) }]

    @Tool.predicate("+SessionIn:handle, +Expr:value, -SessionOut:handle")
    def yices_assert(self, sessionIn, expr, sessionOut):
        self.write(sessionIn, '(assert (%s))\n' % expr)
        return [{ sessionOut: self.updateSession(sessionIn) }]

def register(etb) :
    """Register Yices"""
    etb.add_tool(Yices(etb))
