"""Keeping track of TimeStamps for Goals

.. warning::
       **DEPRECATED:** Originally stored in :class:`etb.datalog.graph.Annotation` used by the
       termination code called from :func:`etb.datalog.graph.DependencyGraph.close` ; no longer used.
"""

class TimeStamp(object):
    def __init__(self, state):
        self.state = state
        # a dictionary mapping goals to times
        self.timestamps = {}

    def get_timestamp(self, goal):
        if goal in self.timestamps:
            return self.timestamps[goal]
        else:
            return 0

    def set_timestamp(self, goal, stamp):
        self.timestamps[goal] = stamp

    def inc(self, goal):
        if goal in self.timestamps:
            self.timestamps[goal] += 1
        else:
            self.timestamps[goal] = self.state.get_global_time() + 1

    def close_timestamps(self, term_factory):
        closed_timestamps = {}
        for goal in self.timestamps:
            closed_goal = term_factory.close_literal(goal)
            closed_timestamps[closed_goal] = self.timestamps[goal]
        return closed_timestamps




