import sys
from etb.wrapper import Tool, Lemmata, Substitutions, Success, Failure

class Airline (Tool):
  
  @Tool.predicate("+src_airport: value, +dest_airport: value, -claims: value")
  def have_flight(self, src_airport, dest_airport, claims):
    sys.stderr.write('Current dir = {0}\n'.format(self.etb.etb_dir))
    src = src_airport.unquote()
    dest = dest_airport.unquote()
    # The route data is of the form:
    # route("#C7", "\N", "MAO", "2551", "CIZ", "7398", "", "0", "EMB").
    # route("2G", "1654", "OVB", "4078", "MJZ", "2925", "", "0", "A81").

    # Define a test for matching claims:
    def src_and_dest_match(pred, args):
      return pred == "route" and (args[2] == src or args[4] == dest)
    # Find matching claims using test:
    mclaims = self.clms.find_claims(src_and_dest_match)
    # We can also use regular expressions as defined in the re module
    mclaims.extend(self.clms.find_claims('"OVB".*"2925"'))
    # Example query:
    # q = query(have_flight("MAO", "CIZ", C))
    
    return Substitutions(self, self.bindResult(claims, mclaims))

def register(etb):
    etb.add_tool(Airline(etb))
  
