from etb.wrapper import Tool

import etb.terms

class Wrapping(Tool):

    @Tool.sync
    @Tool.predicate("+low: value, +up: value, -result: value")
    def in_range(self, low, up, result):
        """Result in [low, up] range."""
        low = int(low.val)
        up = int(up.val)
        if low > up:
            return []
        if result.is_var():
            return [{result : etb.terms.mk_const(i)} for i in range(low, up+1) ]
        else:
            result = int(result.val)
            if low <= result <= up:
                return [{}]
            else:
                return []

    @Tool.sync
    @Tool.predicate("+arg0: value, +arg1: value")
    def lt(self, arg0, arg1):
        """Result in [low, up] range."""
        arg0 = int(arg0.val)
        arg1 = int(arg1.val)
        if arg1 > arg0:
            return [{}]
        else:
            return []

def register(etb):
    "Register the tool"
    etb.add_tool(Wrapping(etb))

