import os.path
import platform
from etb.wrapper import Tool, BatchTool

import etb.terms as terms

class F(BatchTool):
    
    #just takes a look around and prints stuff;
    #the return value is always true, could be otherwise
    #volatile so that you can do it more than once
    @Tool.volatile
    @Tool.predicate("-result: value")
    def metaF(self, result):
        print "\nmetaF() = %s\n" % (True)
        print "self.etb = %s" % repr(self.etb)
        done_queries = self.etb.done_queries
        print "done_queries = %s - %s " % (done_queries, type (done_queries))
        for qid in self.etb.done_queries:
            print "query %s =  %s " % (qid, self.etb.get_query(qid))

        #dump the local logic state
        print "\nLogic State:\n"
        state = self.etb.logic_state
        with state:
            claims = [c for c in state.claims()]
            rules = [c for c in state.rules()]
            print "claims: %s" % claims     
            print "rules: %s" % rules     

        #take a peek at the neighbors
        print "\nNetworking State:\n"
        me =  self.etb.id
        networking = self.etb.networking
        neighbors = networking.neighbors
        print "neighbors: %s" % neighbors     
        for n in neighbors:
            # n.b.: a node is its own neighbor so this local/remote split is artificial
            if n.id != me:
                print "remote neighbor: %s" % n.id
                remote_claims = self.get_claims(n)
                print "remote claims: %s" % remote_claims
                for c in remote_claims:
                    print "remote claims: %s %s" % (repr(c), type(c))
                remote_rules = self.get_rules(n)
                print "remote rules: %s" % remote_rules
                for r in remote_rules:
                    print "remote rule: %s %s" % (repr(r), type(r))
        return [ self.bindResult(result, True) ]

    def get_rules(self, node):
        try:
            raw = node.proxy.dump_rules()
            cs = terms.loads(raw)
            return cs 
        except Exception, e:
            print e
            return []

    def get_claims(self, node):
        try:
            raw = node.proxy.get_all_claims()
            cs = terms.loads(raw)
            return cs 
        except Exception, e:
            print e
            return []




def register(etb):
    etb.add_tool(F(etb))


