# Wrappers used by SAL

from etb.wrapper import Tool, BatchTool

class SalInternal(BatchTool):
    """Wrapper used by SAL"""

    # @Tool.predicate("+in: file, -out: file")
    # def yices_dimacs(self, inF, outF):
    #     '''Call yices on a dimacs file'''
    #     (r, out, err) = self.callTool('yices', '--evidence', '--dimacs',
    #                                   '-v', '3', inF['file'])
    #     with open('sal.out', 'w') as oc:
    #         print >>oc, out
    #     outref = self.fs.put_file('sal.out')
    #     return [self.bindResult(outF, outref)]

    @Tool.predicate("+in: file, -sat: value, -model: value")
    def yices_dimacs(self, inF, sat, model):
        '''Call yices on a dimacs file'''
        (ret, out, err) = self.callTool('yices', '--evidence', '--dimacs',
                                      '-v', '3', inF['file'])
        if ret != 0:
            self.log.error(err)
            return { 'substs' : [],
                     'claims' : [ 'error("yices", "%s")' % err ]}
        output = out.split('\n')
        if output[0] == 'sat':
            s = self.bindResult(sat, output[0])
            s = self.bindResult(model, ''.join(output[1:]), current=s)
        else:
            s = self.bindResult(sat, output[0])
            s = self.bindResult(model, [], current=s)
        if s == []:
            return s
        else:
            return [s]
    
def register(etb):
    "Register the tool"
    etb.add_tool(SalInternal(etb))
