from __future__ import with_statement
import os
import sys

import ctypes
import tempfile
import re

if sys.platform == 'darwin':
    libext = ".dylib" #set DYLD_LIBRARY_PATH to point to the directory with libyices.dylib
else: libext = ".so"  #set LD_LIBRARY_PATH to point to the directory with libyices.so

libyices = ctypes.CDLL('libyices.2%s' % libext)

libyices.yices_version.restype = ctypes.c_char_p
libyices.yices_new_context.restype = ctypes.c_void_p
libyices.yices_free_context.argtypes = [ctypes.c_void_p]
libyices.yices_context_status.argtypes = [ctypes.c_void_p]
libyices.yices_reset_context.argtypes = [ctypes.c_void_p]
libyices.yices_push.argtypes = [ctypes.c_void_p]
libyices.yices_pop.argtypes = [ctypes.c_void_p]


class Yices2ContextManager(object):
    """  A context manager for Yices that encapsulates the operations on a context.  """

    def __init__(self, libyices):
        """
        Creates a fresh context.
        """
        self.libyices = libyices
        self.context = self.libyices.yices_new_context()
        self.allvars = []
        self.allvars_stack = []
        self.commands = []
        self.commands_stack = []
        self.last_error_msg = ''
        self.model = {}


    def version(self):
        ''' Return the version of yices.  Not used anywhere.'''
        return libyices.yices_version()


from etb.wrapper_ns import Tool, InteractiveTool

