# Batch wrapper for PVS

import subprocess
from etb.wrapper import Tool, BatchTool

class PVSBatch(BatchTool):
  '''Runs PVS batch commands, collecting dependencies and running PVS'''

  # Don't want to call PVS twice, want the info at the end
  @Volatile
  @Tool.predicate("-info: value"):
  def pvs_meta_info(self, info):
    pass
  
  @Tool.predicate("-env: value, -files: files"):
  def pvs_dependencies(self, env, files):
    pass
    
  @Tool.predicate("+info: value, +pvsfile: file, -status: value")
  def pvs_typecheck(self, info, pvsfile, status):
    pvs = subprocess.Popen(['pvs', ''])
  
