from etb.wrapper import Tool, BatchTool
import time

class ClaimsTest(Tool):
    """Testing how to get information while tools are running"""

    @Tool.predicate("+x: value, +y: value, -result: value")
    def test1(self, x, y, result):
        """Result is x * y after sleeping."""
        ix = int(x.val)
        iy = int(y.val)
        print('test1: take 10')
        time.sleep(10)
        print('test1: done')
        if result.is_var():
            # result product
            return [ self.bindResult(result, ix * iy) ]
        else:
            result = int(result.val)
            if ix * iy == result:
                # singleton answer (check)
                return [{}]
            else:
                return []

    @Tool.predicate("+x: value, +y: value, -result: value")
    def test2(self, x, y, result):
        """Result is x + y after sleeping."""
        ix = int(x.val)
        iy = int(y.val)
        print('test2: take 30')
        time.sleep(30)
        print('test2: done')
        if result.is_var():
            # result sum
            return [ self.bindResult(result, ix + iy) ]
        else:
            result = int(result.val)
            if ix + iy == result:
                # singleton answer (check)
                return [{}]
            else:
                return []

def register(etb):
    "Register the tool"
    etb.add_tool(ClaimsTest(etb))
