import os
import tempfile
import datetime
from etb.wrapper import Tool, BatchTool
from etb.terms import mk_term

class yices_batch(BatchTool):
    @Tool.volatile
    @Tool.predicate("-version: value")
    def yices_version(self, version):
        (ret, out, err) = self.callTool('yices', '--version')
        version_string = out.strip()
        print('yices version = {0}'.format(out))
        return [ self.bindResult(version, version_string) ]

    @Tool.predicate("+version: value, +inf: file, -result: value")
    def yices_call(self, version, file, result):
        (ret, out, err) = self.callTool('yices', inf['file'])
        print('yices_call called')
        return [ self.bindResult(result, out) ]
    
def register(etb):
    etb.add_tool(yices_batch(etb))
