"""
Wrappers around list values.
"""

from etb.wrapper import Tool, Substitutions, Success, Failure, Errors

class List(Tool):
    """Some predicates for lists"""

    @Tool.sync
    @Tool.predicate("-l: value")
    def nil(self, l):
        if l.is_var():
            return Substitutions(self, [self.bindResult(l, [])])
        elif l.is_array():
            if len(l.get_args()) == 0:
                return Success(self)
            else:
                return Failure(self)
        else:
            return Errors(self, "nil: invalid argument")
    
    @Tool.sync
    @Tool.predicate('+hd: value, +tl: value, -l: value')
    def cons(self, hd, tl, l):
        if l.is_var() and hd.is_const() and tl.is_array():
            return Substitutions(self, [self.bindResult(l, [hd.val] + list(tl.get_args()))])
        elif l.is_array() and hd.is_const() and tl.is_array():
            if ([hd] + list(tl.get_args())) == list(l.get_args()):
                return Success(self)
            else:
                return Failure(self)
        else:
            return Errors(self, "cons: invalid argument")

    @Tool.sync
    @Tool.predicate('+l: value, -h: value')
    def hd(self, l, h):
        if l.is_array():
            if len(l.get_args()) >= 1:
                if h.is_var():
                    return Substitutions(self, [self.bindResult(h, l.get_args()[0])])
                elif h.is_const() and h.val == l.get_args()[0].val:
                    return Success(self)
                else:
                    return Failure(self)
            else:
                return Failure(self)
        else:
            return Errors(self, "hd: invalid argument")

    @Tool.sync
    @Tool.predicate('+l: value, -h: value')
    def tl(self, l, t):
        if l.is_array():
            if len(l.get_args()) >= 1:
                if t.is_var():
                    return Substitutions(self, [self.bindResult(t, l.get_args()[1:])])
                elif t.is_array() and t.get_args() == l.get_args()[1:]:
                    return Success(self)
                else:
                    return Failure(self)
            else:
                return Failure(self)
        else:
            return Errors(self, "tl: invalid argument")
    
def register(etb):
    etb.add_tool(List(etb))
