from etb.wrapper import Tool, BatchTool
import etb.parser

class Requirements(BatchTool):
  def __init__(self, etb):
    # BatchTool.__init__(self, etb)
    super(Requirements, self).__init__(etb)
    self.etb = etb
      
  @Tool.predicate("+metainfo: value, +reqdoc: file")
  def requirements_written(self, metainfo, reqdoc):
    # Could add checks here for Author, etc., even authenticating
    print 'requirements_written({0}, {1})'.format(metainfo, reqdoc)
    return [{}]
    
  @Tool.predicate("+metainfo: value, +reqdoc: file, +reviews: files")
  def requirements_reviewed(self, metainfo, reqdoc, files):
    goal = etb.parser.parse_term('requirements_written(MI, reqdoc)')
    if self.etb.logic_state.match_claims_against(goal) is not None:
      return [{}]
    else:
      return []

def register(etb):
  "Register the tool"
  etb.add_tool(Requirements(etb))
