#!/usr/bin/env python

import re
import os
import sys
from distutils.core import setup

sys.path.insert(0, os.path.join(os.path.dirname(__file__), 'src'))
import ext_manager

author = re.match('(.*)\s<(.*)>', ext_manager.__author__).groups()

setup(
    name='Ext.Manager',
    version='.'.join(str(c) for c in ext_manager.__version__),
    description='Extension manager for classes using object composition.',
    author=author[0],
    author_email=author[1],
    url="http://pypi.python.org/pypi/Ext.Manager",
    py_modules=['src/ext_manager'],
)

