#  _________________________________________________________________________
#
#  FAST: Python tools for software testing.
#  Copyright (c) 2008 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  For more information, see the FAST README.txt file.
#  _________________________________________________________________________

import tester
from pyutilib.component.core import *
import subprocess
import glob
import string
import os
import sys

PluginGlobals.push_env("fast.testing")


class Test(tester.Test):

    def run(self):
        self.artifacts = self.tester.run(self.data)
        return self.artifacts

        
class Tester(tester.BaseTester):
    """Execute runners generated by CxxTest"""

    def __init__(self, package, dir, cmd="runner"):
        tester.BaseTester.__init__(self, package=package, type="cxxtest", tags=["serial", "unit"], dir=dir)
        self.name="CxxTest"
        self.cmd = cmd

    def run(self, path):
        artifacts = []
        cwd = os.getcwd()
        os.chdir(path)
        for file in glob.glob(self.cmd):
            print ". Running CxxTest test with "+path+os.sep+file+" ...",
            sys.stdout.flush()
            if os.path.exists(file):
                output = subprocess.Popen(os.path.abspath(file), stdout=subprocess.PIPE, stderr=subprocess.STDOUT).communicate()[0]
                OUTPUT = open(file+".out","w")
                print >>OUTPUT, output
                OUTPUT.close()
                artifacts.append(file+".out")
                print "OK"
            else:
                print "Missing executable "+cmd
            sys.stdout.flush()
        artifacts += glob.glob("TEST*.xml")
        os.chdir(cwd)
        return map( lambda x: path+os.sep+x, artifacts)

    def generate(self, identifiers, options):
        tmp = string.Template(self.dir)
        return map(lambda x:Test(x,self), self.list_matching_dirs(os.getcwd(), tmp.substitute(identifiers)))


PluginGlobals.pop_env()
