#  _________________________________________________________________________
#
#  FAST: Python tools for software testing.
#  Copyright (c) 2008 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  For more information, see the FAST README.txt file.
#  _________________________________________________________________________

import tester
from pyutilib.component.core import *
import subprocess
import glob
import string
import pyutilib.misc
import os
import sys

PluginGlobals.push_env("fast.testing")


class Test(tester.Test):

    def run(self):
        self.artifacts = self.tester.run(self.data)
        return self.artifacts

        
class Tester(tester.BaseTester):
    """Execute runners generated by fast.exact"""

    def __init__(self, package, dir, cmd="exact"):
        tester.BaseTester.__init__(self, package=package, type="exact", tags=["serial", "system"], dir=dir)
        self.name="EXACT"
        self.cmd = cmd

    def run(self, data):
        artifacts = []
        cwd = os.getcwd()
        os.chdir(data.dir)
        print ". Running EXACT test with "+data.file+" ...",
        sys.stdout.flush()
        exp = data.file.split(".")[0]
        pyutilib.misc.recursive_delete(exp,True)
        #
        # Setup the EXACT command line.  This is a bit of a hack,
        # since EXACT has an independent notion of tags.  Here, we use
        # the tag specified by this object to filter out certain tests.
        #
        cmd = "exact -f "
        for tag in data.tags:
            if tag != "system" and tag != "serial":
                cmd += " --tag="+tag+" "
        cmd += data.file
        output = subprocess.Popen(cmd.split(), stdout=subprocess.PIPE, stderr=subprocess.STDOUT).communicate()[0]
        OUTPUT = open(data.file+".out","w")
        print >>OUTPUT, output
        OUTPUT.close()
        artifacts.append(data.file+".out")
        if os.path.exists(exp):
            os.chdir(exp)
            artifacts += map(lambda x: os.path.abspath(x), glob.glob("TEST*.xml"))
            print "OK"
        else:
            print "WARNING: Expected directory %s with test results" % exp
            print "WARNING: These results may have been generated for the specified tags."
        sys.stdout.flush()
        os.chdir(cwd)
        return artifacts

    def generate(self, identifiers, options):
        tmp = string.Template(self.dir)
        dirs = self.list_matching_dirs(os.getcwd(), tmp.substitute(identifiers))
        ans = []
        for dir in dirs:
            for file in glob.glob(os.path.join(dir,"*.study.xml")):
                ans.append( Test(pyutilib.misc.Bunch(dir=dir,file=file,tags=options.taglist),self) )
        return ans


PluginGlobals.pop_env()
