from setuptools import setup, find_packages
from codecs import open  # To use a consistent encoding
from os import path

here = path.abspath(path.dirname(__file__))

# Get the long description from the relevant file
with open(path.join(here, 'README.rst'), encoding='utf-8') as f:
    long_description = f.read()

setup(
  name = 'FORD',
  packages = ['ford'],
  include_package_data = True,
  version = '0.4',
  description = 'FORD, standing for FORtran Documenter, is an automatic documentation generator for modern Fortran programs.',
  long_description = long_description,
  author = 'Chris MacMackin',
  author_email = 'cmacmackin@gmail.com',
  url = 'https://github.com/cmacmackin/ford/', 
  download_url = 'https://github.com/cmacmackin/ford/tarball/v0.4',
  keywords = ['Markdown', 'Fortran', 'documentation', 'comments'],
  classifiers=[
        # How mature is this project? Common values are
        #   3 - Alpha
        #   4 - Beta
        #   5 - Production/Stable
        'Development Status :: 5 - Production/Stable',

        # Indicate who your project is intended for
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Documentation',
        'Topic :: Text Processing :: Markup :: HTML',
        'Topic :: Documentation',
        'Topic :: Utilities',

        # Pick your license as you wish (should match "license" above)
        'License :: OSI Approved :: GNU General Public License v3 (GPLv3)',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
    ],
  install_requires = ['markdown','markdown-include','toposort','jinja2',
                      'pygments','beautifulsoup4'],
  entry_points = {
    'console_scripts': [
        'ford=ford:main',
    ],
  }
)
