'''
Project: Farnswroth

Author: Karandeep Singh Nagra
'''

from django.contrib import admin
from base.models import ProfileRequest
from managers.models import Manager, RequestType, Request, Response, Announcement

class ManagerAdmin(admin.ModelAdmin):
    list_display = ('title', 'incumbent', 'email')
    search_fields = ('title', 'incumbent', 'email', 'duties')
    list_filter = ('email',)

class RequestTypeAdmin(admin.ModelAdmin):
    list_display = ('name', 'enabled')
    search_fields = ('name', 'managers')
    list_filter = ('name', 'managers')

class RequestAdmin(admin.ModelAdmin):
    list_display = ('owner', 'post_date', 'status')
    search_fields = ('owner', 'body', 'post_date', 'change_date', 'status')
    list_filter = ('status',)
    date_hierarchy = 'post_date'
    ordering = ('-post_date',)
    readonly_fields = ('post_date',)

class ResponseAdmin(admin.ModelAdmin):
    list_display = ('owner', 'post_date', 'request', 'action')
    search_fields = ('owner', 'body', 'request', 'action')
    list_filter = ('action',)
    date_hierarchy = 'post_date'
    ordering = ('-post_date',)
    readonly_fields = ('post_date',)

class ProfileRequestAdmin(admin.ModelAdmin):
    list_display = ('username', 'last_name', 'first_name', 'email')
    search_fields = ('username', 'last_name', 'first_name', 'email')
    date_hierarchy = 'request_date'
    list_filter = ('request_date',)
    ordering = ('request_date',)
    readonly_fields = ('username', 'last_name', 'first_name', 'email')

class AnnouncementAdmin(admin.ModelAdmin):
    list_display = ('manager', 'incumbent', 'post_date', 'pinned')
    search_fields = ('manager', 'incumbent', 'body')
    date_hierarchy = 'post_date'
    list_filter = ('pinned',)
    ordering = ('-post_date', 'pinned')
    readonly_fields = ('manager', 'incumbent', 'post_date', 'body')

admin.site.register(Manager, ManagerAdmin)
admin.site.register(RequestType, RequestTypeAdmin)
admin.site.register(Request, RequestAdmin)
admin.site.register(Response, ResponseAdmin)
admin.site.register(ProfileRequest, ProfileRequestAdmin)
admin.site.register(Announcement, AnnouncementAdmin)
