# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import models, migrations
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Announcement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('body', models.TextField(help_text='The body of the announcement.')),
                ('post_date', models.DateTimeField(help_text='The date this announcement was posted.', auto_now_add=True)),
                ('pinned', models.BooleanField(default=False, help_text='Whether this announcment should be pinned permanently.')),
                ('change_date', models.DateTimeField(help_text='The last time this request was modified.', auto_now_add=True)),
                ('incumbent', models.ForeignKey(help_text='The incumbent who made this announcement.', to='base.UserProfile')),
            ],
            options={
                'ordering': ['-post_date'],
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='Manager',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(help_text='The title of this management position.', unique=True, max_length=255)),
                ('url_title', models.CharField(help_text='The unique URL key for this manager. Autogenerated from custom interface.', max_length=255)),
                ('compensation', models.TextField(help_text='The compensation for this manager.', null=True, blank=True)),
                ('duties', models.TextField(help_text='The duties of this manager.', null=True, blank=True)),
                ('email', models.EmailField(help_text='The e-mail address of this manager.', max_length=255, null=True, blank=True)),
                ('president', models.BooleanField(default=False, help_text='Whether this manager has president privileges (edit managers, bylaws, etc.).')),
                ('workshift_manager', models.BooleanField(default=False, help_text='Whether this manager has workshift manager privileges (assign workshifts, etc.).')),
                ('active', models.BooleanField(default=True, help_text='Whether this is an active manager position (visible in directory, etc.).')),
                ('incumbent', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='base.UserProfile', help_text='The incumbent for this position.', null=True)),
            ],
            options={
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='announcement',
            name='manager',
            field=models.ForeignKey(help_text='The manager who made this announcement.', to='managers.Manager'),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Request',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('body', models.TextField(help_text='The body of this request.')),
                ('post_date', models.DateTimeField(help_text='The date this request was posted.', auto_now_add=True)),
                ('change_date', models.DateTimeField(help_text='The last time this request was modified.', auto_now_add=True)),
                ('filled', models.BooleanField(default=False, help_text='Whether the manager deems this request filled.')),
                ('closed', models.BooleanField(default=False, help_text='Whether the manager has closed this request.')),
                ('number_of_responses', models.PositiveSmallIntegerField(default=0, help_text='The number of responses to this request.')),
                ('owner', models.ForeignKey(help_text='The user who made this request.', to='base.UserProfile')),
                ('upvotes', models.ManyToManyField(to='base.UserProfile', null=True, blank=True)),
            ],
            options={
                'ordering': ['-post_date'],
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name='RequestType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(help_text='Name of the request type.', unique=True, max_length=255)),
                ('url_name', models.CharField(help_text='Unique URL key for this manager.  Autogenerated from custom interface.', unique=True, max_length=255)),
                ('enabled', models.BooleanField(default=True, help_text='Whether this type of request is currently accepted. Toggle this to off to temporarily disable accepting this type of request.')),
                ('glyphicon', models.CharField(help_text='Glyphicon for this request type (e.g., cutlery).  Check Bootstrap documentation for more info.', max_length=100, null=True, blank=True)),
                ('managers', models.ManyToManyField(to='managers.Manager')),
            ],
            options={
                'ordering': ['name'],
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name='request',
            name='request_type',
            field=models.ForeignKey(help_text='The type of request this is.', to='managers.RequestType'),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name='Response',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('body', models.TextField(help_text='The body of this response.')),
                ('post_date', models.DateTimeField(help_text='The date this response was posted.', auto_now_add=True)),
                ('manager', models.BooleanField(default=False, help_text='Whether this is a relevant manager response.')),
                ('owner', models.ForeignKey(help_text='The user who posted this response.', to='base.UserProfile')),
                ('request', models.ForeignKey(help_text='The request to which this is a response.', to='managers.Request')),
            ],
            options={
                'ordering': ['post_date'],
            },
            bases=(models.Model,),
        ),
    ]
