from distutils.core import setup

setup(
    name="FastStringComparator",
    version="1.0",
    py_modules=["fastcomp"],
    author="Seiji Fujimoto",
    author_email="fujimoto@writingarchives.sakura.ne.jp",
    url="http://writingarchives.sakura.ne.jp/fastcomp/index.html",
    description="Faster Computation of Levenshtein Distance for Spell Checkers",
    long_description="""
Fast String Comparator is an efficient algorithm for computating Levenshtein distance up to *two*. Given two strings of length m and n (m &lt;= n), the computation requires O(1) space and O(n) time, which is much smaller and faster than Wagner-Fisher algorithm.

It is mainly targeted at the use in spell checkers, where considering words within two edit distance suffices. 

Documentation
=============

http://writingarchives.sakura.ne.jp/fastcomp/index.html

Demo
====

http://writingarchives.sakura.ne.jp/fastcomp/demo/index.html

Bug report
==========

Please email to <fujimoto at writingarchives.sakura.ne.jp>
""",
    classifiers=[
        "Programming Language :: Python",
        "Development Status :: 4 - Beta",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 3",
        "Topic :: Scientific/Engineering",
        "Topic :: Text Processing"
    ]
)
