#!/usr/bin/env python

from distutils.core import setup
import sys

# Copied from: https://github.com/rg3/youtube-dl/blob/master/setup.py
exec(compile(open('version.py').read(),
             'version.py', 'exec'))

if sys.platform == 'win32':
    enc = 'simple-crypt'
else:
    enc = 'triplesec'

setup(
    name='FileCrypt',
    version=__version__,
    description='Simple file encryption wrapper for triplesec/simple-crypt',
    author='Johny Mo Swag',
    author_email='johnymoswag@gmail.com',
    url='https://github.com/JohnyMoSwag/filecrypt',
    download_url=('https://github.com/JohnyMoSwag/filecrypt'
                  '/archive/master.zip'),
    license='MIT',
    install_requires=[
        enc,
        ],
    py_modules=['filecrypt'],
    scripts = ['filecrypt.py'],
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Operating System :: OS Independent',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 2.7'],
    )
