#!/usr/bin/python
# coding: utf-8
#
# Copyright (c) 2009, Norfello Oy
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#    * Redistributions of source code must retain the above copyright
#      notice, this list of conditions and the following disclaimer.
#    * Redistributions in binary form must reproduce the above copyright
#      notice, this list of conditions and the following disclaimer in the
#      documentation and/or other materials provided with the distribution.
#    * Neither the name of the Norfello Oy nor the
#      names of its contributors may be used to endorse or promote products
#      derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY NORFELLO OY ''AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL NORFELLO OY BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


from finvoicelib.elements import AccountElement
from finvoicelib.elements import Element
from finvoicelib.elements import ReferenceNumberElement


class EpiAccountID(AccountElement):
    """
    EpiAccountID
    """
    tag = 'EpiAccountID'


class EpiBei(Element):
    """
    EpiBei
    """
    tag = 'EpiBei'


class EpiBfiIdentifier(Element):
    """
    EpiBfiIdentifier
    """
    tag = 'EpiBfiIdentifier'


class EpiBfiPartyDetails(Element):
    """
    EpiBfiPartyDetails
    """
    tag = 'EpiBfiPartyDetails'
    aggregate = [EpiBfiIdentifier]


class EpiCharge(Element):
    """
    EpiCharge
    """
    tag = 'EpiCharge'


class EpiDate(Element):
    """
    EpiDate
    """
    tag = 'EpiDate'


class EpiDateOptionDate(Element):
    """
    EpiDateOptionDate
    """
    tag = 'EpiDateOptionDate'


class EpiInstructedAmount(Element):
    """
    EpiInstructedAmount
    """
    tag = 'EpiInstructedAmount'


class EpiReference(Element):
    """
    EpiReference
    """
    tag = 'EpiReference'


class EpiRemittanceInfoIdentifier(ReferenceNumberElement):
    """
    EpiRemittanceInfoIdentifier
    """
    tag = 'EpiRemittanceInfoIdentifier'
    required = True


class EpiNameAddressDetails(Element):
    """
    EpiNameAddressDetails
    """
    tag = 'EpiNameAddressDetails'


class EpiBeneficiaryPartyDetails(Element):
    """
    EpiBeneficiaryPartyDetails
    """
    tag = 'EpiBeneficiaryPartyDetails'
    aggregate = [EpiNameAddressDetails, EpiBei, EpiAccountID]


class EpiIdentificationDetails(Element):
    """
    EpiIdentificationDetails
    """
    tag = 'EpiIdentificationDetails'
    aggregate = [EpiDate, EpiReference]


class EpiPartyDetails(Element):
    """
    EpiPartyDetails
    """
    tag = 'EpiPartyDetails'
    aggregate = [EpiBfiPartyDetails,
        EpiBeneficiaryPartyDetails]


class EpiPaymentInstructionDetails(Element):
    """
    EpiPaymentInstructionDetails
    """
    tag = 'EpiPaymentInstructionDetails'
    aggregate = [
        EpiRemittanceInfoIdentifier,
        EpiInstructedAmount,
        EpiCharge,
        EpiDateOptionDate, ]


class EpiDetails(Element):
    """
    EpiDetails
    """
    tag = 'EpiDetails'
    aggregate = [
        EpiIdentificationDetails,
        EpiPartyDetails,
        EpiPaymentInstructionDetails, ]
