

include "config.pxi" #config.pxi is generated by the build script

from libcpp cimport bool
import sys

import os
import traceback
import math

cdef extern from "stddef.h":
    ctypedef void wchar_t

IF PLATFORM != 'WINDOWS':
    cdef extern from "Utils.h" namespace "lime":
        ctypedef char OSChar

ELSE:
    cdef extern from "Utils.h" namespace "lime":
        ctypedef wchar_t OSChar
    cdef extern from "Windows.h":
        GetWindowsDirectory(char *buff, unsigned int size)

IF PLATFORM == 'ANDROID':
    def _request_render():
        AndroidRequestRender()
ELSE:
    _request_render = None

cdef extern from "Utils.h":
    ctypedef unsigned char uint8

cdef extern from "Utils.h" namespace "lime":
    cdef cppclass WString:
        WString()
        WString(const wchar_t *inStr)
        const wchar_t *c_str()

    string WideToUTF8(WString &inWideString)

    wchar_t*    UTF8ToWideCStr(char *inStr, int &outLen)
    WString     UTF8ToWide(char *inStr)

cdef extern from "LimeThread.h" namespace "lime":
    bool        IsMainThread()
    void        SetMainThread()

cdef extern from "string" namespace "std":
    cdef cppclass string:
        char* c_str()

ctypedef unsigned int uint32

include "geom.pxi"
include "event.pxi"
include "object.pxi"
include "matrix.pxi"
include "surface.pxi"
include "tilesheet.pxi"
include "graphics.pxi"
include "display.pxi"
include "textfield.pxi"
include "directrenderer.pxi"

_py_event_handler = None
_py_on_main_frame_created = None
_py_cwd = '.'

cdef void _print_exc_traceback(exc):
    print(str(exc))
    traceback.print_exc(file=sys.stdout)
    print(str(sys.exc_type))
    print(str(sys.exc_value))
    print(str(sys.exc_traceback))

cdef void _event_handler_proxy(Event &ioEvent, void *userData):
    e = _Event()
    e.thisptr = &ioEvent
    if _py_event_handler != None:
        try:
            _py_event_handler(e)
        except Exception as exc:
            _print_exc_traceback(exc)
            stop()

cdef void _on_main_frame_created(Frame* frame):
    cdef Stage *stage = NULL
    
    SetMainThread()

    stage = frame.GetStage()
    stage.setScaleMode(ssmNoScale)
    stage.RenderStage()

    os.chdir(_py_cwd)

    stage.SetEventHandler(_event_handler_proxy, NULL)

    try:
        from flappy import _gl
        _gl._init_extensions()
    except Exception as exc:
        _print_exc_traceback(exc)
        stop()
    
    
    obj = None

    try:
        obj = _py_on_main_frame_created()
    except Exception as exc:
        _print_exc_traceback(exc)
        stop()

    if obj and isinstance(obj, _DisplayObject):
        from flappy.display import Stage
        Stage._get_instance().addChild(obj)


def _set_event_handler(handler):
    global _py_event_handler
    _py_event_handler = handler


def start(startup, int width, int height, const char* title, **kw_flags):
    cdef unsigned int flags = 0
    fvalues = {
        'fullscreen'        : (wfFullScreen, False),
        'borderless'        : (wfBorderless, False),
        'resizable'         : (wfResizable, False),
        'hardware'          : (wfHardware, True),
        'vsync'             : (wfVSync, False),
        'aa'                : (wfHW_AA, False),
        'aa_hires'          : (wfHW_AA_HIRES, False),
        'allow_shaders'     : (wfAllowShaders, True),
        'require_shaders'   : (wfRequireShaders, True),
    }
    for k in fvalues:
        if k in kw_flags:
            flags |= fvalues[k][0] if kw_flags[k] else 0
        else:
            flags |= fvalues[k][0] if fvalues[k][1] else 0

    for k in kw_flags:
        if k not in fvalues:
            raise ValueError('Wrong argument: "%s"' % k)

#FIXME: the current directory changes for some reason after CreateMainFrame on Mac OSX.
#        _py_cwd holds it for changing it back later
    global _py_cwd
    _py_cwd = os.getcwd()

    global _py_on_main_frame_created
    _py_on_main_frame_created = startup
    CreateMainFrame(_on_main_frame_created , width, height, flags, title, NULL)

def stop():
    StopAnimation()
