/**
 * Sinon core utilities. For internal use only.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Spy functions
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Stub functions
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Mock functions.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Collections of stubs, spies and mocks.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Fake timer API
 * setTimeout
 * setInterval
 * clearTimeout
 * clearInterval
 * tick
 * reset
 * Date
 *
 * Inspired by jsUnitMockTimeOut from JsUnit
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Minimal Event interface implementation
 *
 * Original implementation by Sven Fuchs: https://gist.github.com/995028
 * Modifications and tests by Christian Johansen.
 *
 * @author Sven Fuchs (svenfuchs@artweb-design.de)
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2011 Sven Fuchs, Christian Johansen
 */
/**
 * Fake XMLHttpRequest object
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * The Sinon "server" mimics a web server that receives requests from
 * sinon.FakeXMLHttpRequest and provides an API to respond to those requests,
 * both synchronously and asynchronously. To respond synchronuously, canned
 * answers have to be provided upfront.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Add-on for sinon.fakeServer that automatically handles a fake timer along with
 * the FakeXMLHttpRequest. The direct inspiration for this add-on is jQuery
 * 1.3.x, which does not use xhr object's onreadystatehandler at all - instead,
 * it polls the object for completion with setInterval. Dispite the direct
 * motivation, there is nothing jQuery-specific in this file, so it can be used
 * in any environment where the ajax implementation depends on setInterval or
 * setTimeout.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Manages fake collections as well as fake utilities such as Sinon's
 * timers and fake XHR implementation in one convenient object.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Test function, sandboxes fakes
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Test case, sandboxes all test functions
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
/**
 * Assertions matching the test spy retrieval interface.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2011 Christian Johansen
 */
var sinon=function(){var buster=function(a,b){function c(a){if(!a)return;for(var b=1,c=arguments.length,d;b<c;++b)for(d in arguments[b])a[d]=arguments[b][d];return a}var d=typeof document!="undefined"&&document.createElement("div");return c(a,{bind:function(a,b){var c=typeof b=="string"?a[b]:b,d=Array.prototype.slice.call(arguments,2);return function(){var b=d.concat(Array.prototype.slice.call(arguments));return c.apply(a,b)}},create:function(){function a(){}return function b(b){return a.prototype=b,new a}}(),extend:c,nextTick:function(a){if(typeof process!="undefined"&&process.nextTick)return process.nextTick(a);b(a,0)},functionName:function(a){if(!a)return"";if(a.displayName)return a.displayName;if(a.name)return a.name;var b=a.toString().match(/function\s+([^\(]+)/m);return b&&b[1]||""},isNode:function(a){if(!d)return!1;try{a.appendChild(d),a.removeChild(d)}catch(b){return!1}return!0},isElement:function(b){return b&&a.isNode(b)&&b.nodeType===1}})}(buster||{},setTimeout);typeof module=="object"&&typeof require=="function"&&(module.exports=buster,buster.eventEmitter=require("./buster-event-emitter"),Object.defineProperty(buster,"defineVersionGetter",{get:function(){return require("./define-version-getter")}})),typeof require!="undefined"&&(buster=require("buster-core")),buster.format=buster.format||{},buster.format.excludeConstructors=["Object",/^.$/],buster.format.quoteStrings=!0,buster.format.ascii=function(){function a(a){var b=Object.keys&&Object.keys(a)||[];if(b.length==0)for(var c in a)a.hasOwnProperty(c)&&b.push(c);return b.sort()}function b(a,b){if(typeof a!="object")return!1;for(var c=0,d=b.length;c<d;++c)if(b[c]===a)return!0;return!1}function c(a,d,e){if(typeof a=="string"){var f=typeof this.quoteStrings!="boolean"||this.quoteStrings;return d||f?'"'+a+'"':a}return typeof a!="function"||a instanceof RegExp?(d=d||[],b(a,d)?"[Circular]":Object.prototype.toString.call(a)=="[object Array]"?c.array(a):a?buster.isElement(a)?c.element(a):a.toString!==Object.prototype.toString?a.toString():c.object.call(this,a,d,e):""+a):c.func(a)}return c.func=function(a){return"function "+buster.functionName(a)+"() {}"},c.array=function(a,b){b=b||[],b.push(a);var d=[];for(var e=0,f=a.length;e<f;++e)d.push(c(a[e],b));return"["+d.join(", ")+"]"},c.object=function(d,e,f){e=e||[],e.push(d),f=f||0;var g=[],h=a(d),i,j,k,l="",m=3;for(var n=0,o=f;n<o;++n)l+=" ";for(n=0,o=h.length;n<o;++n)i=h[n],k=d[i],b(k,e)?j="[Circular]":j=c.call(this,k,e,f+2),j=(/\s/.test(i)?'"'+i+'"':i)+": "+j,m+=j.length,g.push(j);var p=c.constructorName.call(this,d),q=p?"["+p+"] ":"";return m+f>80?q+"{\n  "+l+g.join(",\n  "+l)+"\n"+l+"}":q+"{ "+g.join(", ")+" }"},c.element=function(a){var b=a.tagName.toLowerCase(),c=a.attributes,d,e=[],f;for(var g=0,h=c.length;g<h;++g){d=c.item(g),f=d.nodeName.toLowerCase().replace("html:","");if(f=="contenteditable"&&d.nodeValue=="inherit")continue;!d.nodeValue||e.push(f+'="'+d.nodeValue+'"')}var i="<"+b+(e.length>0?" ":""),j=a.innerHTML;j.length>20&&(j=j.substr(0,20)+"[...]");var k=i+e.join(" ")+">"+j+"</"+b+">";return k.replace(/ contentEditable="inherit"/,"")},c.constructorName=function(a){var b=buster.functionName(a&&a.constructor),c=this.excludeConstructors||buster.format.excludeConstructors||[];for(var d=0,e=c.length;d<e;++d){if(typeof c[d]=="string"&&c[d]==b)return"";if(c[d].test&&c[d].test(b))return""}return b},c}(),typeof module!="undefined"&&(module.exports=buster.format);var sinon=function(a){function d(a){var c=!1;try{a.appendChild(b),c=b.parentNode==a}catch(d){return!1}finally{try{a.removeChild(b)}catch(d){}}return c}function e(a){return b&&a&&a.nodeType===1&&d(a)}function f(a){return!!(a&&a.constructor&&a.call&&a.apply)}function g(a,b){for(var d in b)c.call(a,d)||(a[d]=b[d])}var b=typeof document!="undefined"&&document.createElement("div"),c=Object.prototype.hasOwnProperty,h={wrapMethod:function(a,b,d){if(!a)throw new TypeError("Should wrap property of object");if(typeof d!="function")throw new TypeError("Method wrapper should be function");var e=a[b];if(!f(e))throw new TypeError("Attempted to wrap "+typeof e+" property "+b+" as function");if(e.restore&&e.restore.sinon)throw new TypeError("Attempted to wrap "+b+" which is already wrapped");if(e.calledBefore){var h=e.returns?"stubbed":"spied on";throw new TypeError("Attempted to wrap "+b+" which is already "+h)}var i=c.call(a,b);return a[b]=d,d.displayName=b,d.restore=function(){i?a[b]=e:delete a[b]},d.restore.sinon=!0,g(d,e),d},extend:function(a){for(var b=1,c=arguments.length;b<c;b+=1)for(var d in arguments[b])arguments[b].hasOwnProperty(d)&&(a[d]=arguments[b][d]),arguments[b].hasOwnProperty("toString")&&arguments[b].toString!=a.toString&&(a.toString=arguments[b].toString);return a},create:function(a){var b=function(){};return b.prototype=a,new b},deepEqual:function p(a,b){if(typeof a!="object"||typeof b!="object")return a===b;if(e(a)||e(b))return a===b;if(a===b)return!0;var c=Object.prototype.toString.call(a);if(c!=Object.prototype.toString.call(b))return!1;if(c=="[object Array]"){if(a.length!==b.length)return!1;for(var d=0,f=a.length;d<f;d+=1)if(!p(a[d],b[d]))return!1;return!0}var g,h=0,i=0;for(g in a){h+=1;if(!p(a[g],b[g]))return!1}for(g in b)i+=1;return h!=i?!1:!0},functionName:function(a){var b=a.displayName||a.name;if(!b){var c=a.toString().match(/function ([^\s\(]+)/);b=c&&c[1]}return b},functionToString:function(){if(this.getCall&&this.callCount){var a,b,c=this.callCount;while(c--){a=this.getCall(c).thisValue;for(b in a)if(a[b]===this)return b}}return this.displayName||"sinon fake"},getConfig:function(a){var b={};a=a||{};var c=h.defaultConfig;for(var d in c)c.hasOwnProperty(d)&&(b[d]=a.hasOwnProperty(d)?a[d]:c[d]);return b},format:function(a){return""+a},defaultConfig:{injectIntoThis:!0,injectInto:null,properties:["spy","stub","mock","clock","server","requests"],useFakeTimers:!0,useFakeServer:!0},timesInWords:function(a){return a==1&&"once"||a==2&&"twice"||a==3&&"thrice"||(a||0)+" times"},calledInOrder:function(a){for(var b=1,c=a.length;b<c;b++)if(!a[b-1].calledBefore(a[b]))return!1;return!0},orderByFirstCall:function(a){return a.sort(function(a,b){var c=a.getCall(0),d=b.getCall(0),e=c&&c.callId||-1,f=d&&d.callId||-1;return e<f?-1:1})},log:function(){},logError:function(a,b){var c=a+" threw exception: ";h.log(c+"["+b.name+"] "+b.message),b.stack&&h.log(b.stack),setTimeout(function(){throw b.message=c+b.message,b},0)}},i=typeof module=="object"&&typeof require=="function";if(i){try{a={format:require("buster-format")}}catch(j){}module.exports=h,module.exports.spy=require("./sinon/spy"),module.exports.stub=require("./sinon/stub"),module.exports.mock=require("./sinon/mock"),module.exports.collection=require("./sinon/collection"),module.exports.assert=require("./sinon/assert"),module.exports.sandbox=require("./sinon/sandbox"),module.exports.test=require("./sinon/test"),module.exports.testCase=require("./sinon/test_case"),module.exports.assert=require("./sinon/assert")}if(a){var k=h.create(a.format);k.quoteStrings=!1,h.format=function(){return k.ascii.apply(k,arguments)}}else if(i)try{var l=require("util");h.format=function(a){return typeof a=="object"?l.inspect(a):a}}catch(j){}return h}(typeof buster=="object"&&buster);(function(a){function g(b,c){if(!c&&typeof b=="function")return g.create(b);if(!b||!c)return g.create(function(){});var d=b[c];return a.wrapMethod(b,c,g.create(d))}var b=typeof module=="object"&&typeof require=="function",c,d=0,e=[].push,f=Array.prototype.slice;!a&&b&&(a=require("../sinon"));if(!a)return;a.extend(g,function(){function b(a,b,c,d,e){a[b]=function(){if(!this.called)return e?e.apply(this,arguments):!1;var a,f=0;for(var g=0,h=this.callCount;g<h;g+=1){a=this.getCall(g);if(a[d||b].apply(a,arguments)){f+=1;if(c)return!0}}return f===this.callCount}}function h(a,b,c){if(!a)return;var d=b.length;for(var e=0,f=a.length;e<f;e++)if(a[e].matches(b,c))return a[e]}function i(){this.called=!0,this.callCount+=1,this.calledOnce=this.callCount==1,this.calledTwice=this.callCount==2,this.calledThrice=this.callCount==3}function j(){this.firstCall=this.getCall(0),this.secondCall=this.getCall(1),this.thirdCall=this.getCall(2),this.lastCall=this.getCall(this.callCount-1)}var k=0,l={reset:function(){this.called=!1,this.calledOnce=!1,this.calledTwice=!1,this.calledThrice=!1,this.callCount=0,this.firstCall=null,this.secondCall=null,this.thirdCall=null,this.lastCall=null,this.args=[],this.returnValues=[],this.thisValues=[],this.exceptions=[],this.callIds=[]},create:function(b){function d(){return d.invoke(b,this,f.call(arguments))}var c;return typeof b!="function"?b=function(){}:c=a.functionName(b),a.extend(d,g),delete d.create,a.extend(d,b),d.reset(),d.prototype=b.prototype,d.displayName=c||"spy",d.toString=a.functionToString,d._create=a.spy.create,d.id="spy#"+k++,d},invoke:function(a,b,c){var f=h(this.fakes,c),g,k;i.call(this),e.call(this.thisValues,b),e.call(this.args,c),e.call(this.callIds,d++);try{f?k=f.invoke(a,b,c):k=(this.func||a).apply(b,c)}catch(l){throw e.call(this.returnValues,undefined),g=l,l}finally{e.call(this.exceptions,g)}return e.call(this.returnValues,k),j.call(this),k},getCall:function(a){return a<0||a>=this.callCount?null:c.create(this,this.thisValues[a],this.args[a],this.returnValues[a],this.exceptions[a],this.callIds[a])},calledBefore:function(a){return this.called?a.called?this.callIds[0]<a.callIds[a.callIds.length-1]:!0:!1},calledAfter:function(a){return!this.called||!a.called?!1:this.callIds[this.callCount-1]>a.callIds[a.callCount-1]},withArgs:function(){var a=f.call(arguments);if(this.fakes){var b=h(this.fakes,a,!0);if(b)return b}else this.fakes=[];var c=this,d=this._create();d.matchingAguments=a,e.call(this.fakes,d),d.withArgs=function(){return c.withArgs.apply(c,arguments)};for(var g=0;g<this.args.length;g++)d.matches(this.args[g])&&(i.call(d),e.call(d.thisValues,this.thisValues[g]),e.call(d.args,this.args[g]),e.call(d.returnValues,this.returnValues[g]),e.call(d.exceptions,this.exceptions[g]),e.call(d.callIds,this.callIds[g]));return j.call(d),d},matches:function(b,c){var d=this.matchingAguments;if(d.length<=b.length&&a.deepEqual(d,b.slice(0,d.length)))return!c||d.length==b.length},printf:function(b){var c=this,d=f.call(arguments,1),e;return(b||"").replace(/%(.)/g,function(b,f){return e=l.formatters[f],typeof e=="function"?e.call(null,c,d):isNaN(parseInt(f),10)?"%"+f:a.format(d[f-1])})}};return b(l,"calledOn",!0),b(l,"alwaysCalledOn",!1,"calledOn"),b(l,"calledWith",!0),b(l,"alwaysCalledWith",!1,"calledWith"),b(l,"calledWithExactly",!0),b(l,"alwaysCalledWithExactly",!1,"calledWithExactly"),b(l,"neverCalledWith",!1,"notCalledWith",function(){return!0}),b(l,"threw",!0),b(l,"alwaysThrew",!1,"threw"),b(l,"returned",!0),b(l,"alwaysReturned",!1,"returned"),b(l,"calledWithNew",!0),b(l,"alwaysCalledWithNew",!1,"calledWithNew"),b(l,"callArg",!1,"callArgWith",function(){throw new Error(this.toString()+" cannot call arg since it was not yet invoked.")}),l.callArgWith=l.callArg,b(l,"yield",!1,"yield",function(){throw new Error(this.toString()+" cannot yield since it was not yet invoked.")}),l.invokeCallback=l.yield,b(l,"yieldTo",!1,"yieldTo",function(a){throw new Error(this.toString()+" cannot yield to '"+a+"' since it was not yet invoked.")}),l.formatters={c:function(b){return a.timesInWords(b.callCount)},n:function(a){return a.toString()},C:function(a){var b=[];for(var c=0,d=a.callCount;c<d;++c)e.call(b,"    "+a.getCall(c).toString());return b.length>0?"\n"+b.join("\n"):""},t:function(b){var c=[];for(var d=0,f=b.callCount;d<f;++d)e.call(c,a.format(b.thisValues[d]));return c.join(", ")},"*":function(a,b){return b.join(", ")}},l}()),c=function(){function b(b,c,d){var e=a.functionName(b)+c;throw d.length&&(e+=" Received ["+f.call(d).join(", ")+"]"),new Error(e)}return{create:function g(b,e,f,g,h,i){var j=a.create(c);return delete j.create,j.proxy=b,j.thisValue=e,j.args=f,j.returnValue=g,j.exception=h,j.callId=typeof i=="number"&&i||d++,j},calledOn:function(a){return this.thisValue===a},calledWith:function(){for(var b=0,c=arguments.length;b<c;b+=1)if(!a.deepEqual(arguments[b],this.args[b]))return!1;return!0},calledWithExactly:function(){return arguments.length==this.args.length&&this.calledWith.apply(this,arguments)},notCalledWith:function(){for(var b=0,c=arguments.length;b<c;b+=1)if(!a.deepEqual(arguments[b],this.args[b]))return!0;return!1},returned:function(a){return this.returnValue===a},threw:function(a){return typeof a=="undefined"||!this.exception?!!this.exception:typeof a=="string"?this.exception.name==a:this.exception===a},calledWithNew:function(a){return this.thisValue instanceof this.proxy},calledBefore:function(a){return this.callId<a.callId},calledAfter:function(a){return this.callId>a.callId},callArg:function(a){this.args[a]()},callArgWith:function(a){var b=f.call(arguments,1);this.args[a].apply(null,b)},yield:function(){var a=this.args;for(var c=0,d=a.length;c<d;++c)if(typeof a[c]=="function"){a[c].apply(null,f.call(arguments));return}b(this.proxy," cannot yield since no callback was passed.",a)},yieldTo:function(a){var c=this.args;for(var d=0,e=c.length;d<e;++d)if(c[d]&&typeof c[d][a]=="function"){c[d][a].apply(null,f.call(arguments,1));return}b(this.proxy," cannot yield to '"+a+"' since no callback was passed.",c)},toString:function(){var b=this.proxy.toString()+"(",c=[];for(var d=0,f=this.args.length;d<f;++d)e.call(c,a.format(this.args[d]));return b=b+c.join(", ")+")",typeof this.returnValue!="undefined"&&(b+=" => "+a.format(this.returnValue)),this.exception&&(b+=" !"+this.exception.name,this.exception.message&&(b+="("+this.exception.message+")")),b}}}(),g.spyCall=c,a.spyCall=c,b?module.exports=g:a.spy=g})(typeof sinon=="object"&&sinon||null),function(a){function c(b,d,e){if(!e||typeof e=="function"){var f;e?f=a.spy&&a.spy.create?a.spy.create(e):e:f=c.create();if(!b&&!d)return a.stub.create();if(!d&&!!b&&typeof b=="object"){for(var g in b)typeof b[g]=="function"&&c(b,g);return b}return a.wrapMethod(b,d,f)}throw new TypeError("Custom stub should be function")}function d(a,b){if(a.callArgAt<0){for(var c=0,d=b.length;c<d;++c){if(!a.callArgProp&&typeof b[c]=="function")return b[c];if(a.callArgProp&&b[c]&&typeof b[c][a.callArgProp]=="function")return b[c][a.callArgProp]}return null}return b[a.callArgAt]}function f(b,c,d){if(b.callArgAt<0){var f;return b.callArgProp?f=a.functionName(b)+" expected to yield to '"+b.callArgProp+"', but no object with such a property was passed.":f=a.functionName(b)+" expected to yield, but no callback was passed.",d.length>0&&(f+=" Received ["+e.call(d,", ")+"]"),f}return"argument at index "+b.callArgAt+" is not a function: "+c}function g(a,b){if(typeof a.callArgAt=="number"){var c=d(a,b);if(typeof c!="function")throw new TypeError(f(a,c,b));c.apply(a.callbackContext,a.callbackArguments)}}var b=typeof module=="object"&&typeof require=="function";!a&&b&&(a=require("../sinon"));if(!a)return;var e=Array.prototype.join,h=0;a.extend(c,function(){function d(a,b){return typeof a=="string"?(this.exception=new Error(b||""),this.exception.name=a):a?this.exception=a:this.exception=new Error("Error"),this}var b=Array.prototype.slice;return{create:function(){var b=function(){if(b.exception)throw b.exception;return typeof b.returnArgAt=="number"?arguments[b.returnArgAt]:(g(b,arguments),b.returnValue)};b.id="stub#"+h++;var d=b;return b=a.spy.create(b),b.func=d,a.extend(b,c),b._create=a.stub.create,b.displayName="stub",b.toString=a.functionToString,b},returns:function(a){return this.returnValue=a,this},returnsArg:function(a){if(typeof a!="number")throw new TypeError("argument index is not number");return this.returnArgAt=a,this},"throws":d,throwsException:d,callsArg:function(a){if(typeof a!="number")throw new TypeError("argument index is not number");return this.callArgAt=a,this.callbackArguments=[],this},callsArgOn:function(a,b){if(typeof a!="number")throw new TypeError("argument index is not number");if(typeof b!="object")throw new TypeError("argument context is not an object");return this.callArgAt=a,this.callbackArguments=[],this.callbackContext=b,this},callsArgWith:function(a){if(typeof a!="number")throw new TypeError("argument index is not number");return this.callArgAt=a,this.callbackArguments=b.call(arguments,1),this},callsArgOnWith:function(a,c){if(typeof a!="number")throw new TypeError("argument index is not number");if(typeof c!="object")throw new TypeError("argument context is not an object");return this.callArgAt=a,this.callbackArguments=b.call(arguments,2),this.callbackContext=c,this},yields:function(){return this.callArgAt=-1,this.callbackArguments=b.call(arguments,0),this},yieldsOn:function(a){if(typeof a!="object")throw new TypeError("argument context is not an object");return this.callArgAt=-1,this.callbackArguments=b.call(arguments,1),this.callbackContext=a,this},yieldsTo:function(a){return this.callArgAt=-1,this.callArgProp=a,this.callbackArguments=b.call(arguments,1),this},yieldsToOn:function(a,c){if(typeof c!="object")throw new TypeError("argument context is not an object");return this.callArgAt=-1,this.callArgProp=a,this.callbackArguments=b.call(arguments,2),this.callbackContext=c,this}}}()),b?module.exports=c:a.stub=c}(typeof sinon=="object"&&sinon||null),function(a){function d(b){return b?d.create(b):a.expectation.create("Anonymous mock")}var b=typeof module=="object"&&typeof require=="function",c=[].push;!a&&b&&(a=require("../sinon"));if(!a)return;a.mock=d,a.extend(d,function(){function b(a,b){if(!a)return;for(var c=0,d=a.length;c<d;c+=1)b(a[c])}return{create:function(b){if(!b)throw new TypeError("object is null");var c=a.extend({},d);return c.object=b,delete c.create,c},expects:function(b){if(!b)throw new TypeError("method is falsy");this.expectations||(this.expectations={},this.proxies=[]);if(!this.expectations[b]){this.expectations[b]=[];var d=this;a.wrapMethod(this.object,b,function(){return d.invokeMethod(b,this,arguments)}),c.call(this.proxies,b)}var e=a.expectation.create(b);return c.call(this.expectations[b],e),e},restore:function(){var a=this.object;b(this.proxies,function(b){typeof a[b].restore=="function"&&a[b].restore()})},verify:function(){var d=this.expectations||{},e=[],f=[];return b(this.proxies,function(a){b(d[a],function(a){a.met()?c.call(f,a.toString()):c.call(e,a.toString())})}),this.restore(),e.length>0&&a.expectation.fail(e.concat(f).join("\n")),!0},invokeMethod:function i(b,d,e){var f=this.expectations&&this.expectations[b],g=f&&f.length||0;for(var h=0;h<g;h+=1)if(!f[h].met()&&f[h].allowsCall(d,e))return f[h].apply(d,e);var i=[];for(h=0;h<g;h+=1)c.call(i,"    "+f[h].toString());i.unshift("Unexpected call: "+a.spyCall.toString.call({proxy:b,args:e})),a.expectation.fail(i.join("\n"))}}}());var e=a.timesInWords;a.expectation=function(){function f(a){return a==0?"never called":"called "+e(a)}function g(a){var b=a.minCalls,c=a.maxCalls;if(typeof b=="number"&&typeof c=="number"){var d=e(b);return b!=c&&(d="at least "+d+" and at most "+e(c)),d}return typeof b=="number"?"at least "+e(b):"at most "+e(c)}function h(a){var b=typeof a.minCalls=="number";return!b||a.callCount>=a.minCalls}function i(a){return typeof a.maxCalls!="number"?!1:a.callCount==a.maxCalls}var b=Array.prototype.slice,d=a.spy.invoke;return{minCalls:1,maxCalls:1,create:function(b){var c=a.extend(a.stub.create(),a.expectation);return delete c.create,c.method=b,c},invoke:function(a,b,c){return this.verifyCallAllowed(b,c),d.apply(this,arguments)},atLeast:function(a){if(typeof a!="number")throw new TypeError("'"+a+"' is not number");return this.limitsSet||(this.maxCalls=null,this.limitsSet=!0),this.minCalls=a,this},atMost:function(a){if(typeof a!="number")throw new TypeError("'"+a+"' is not number");return this.limitsSet||(this.minCalls=null,this.limitsSet=!0),this.maxCalls=a,this},never:function(){return this.exactly(0)},once:function(){return this.exactly(1)},twice:function(){return this.exactly(2)},thrice:function(){return this.exactly(3)},exactly:function(a){if(typeof a!="number")throw new TypeError("'"+a+"' is not a number");return this.atLeast(a),this.atMost(a)},met:function(){return!this.failed&&h(this)},verifyCallAllowed:function(b,c){i(this)&&(this.failed=!0,a.expectation.fail(this.method+" already called "+e(this.maxCalls))),"expectedThis"in this&&this.expectedThis!==b&&a.expectation.fail(this.method+" called with "+b+" as thisValue, expected "+this.expectedThis);if(!("expectedArguments"in this))return;(!c||c.length===0)&&a.expectation.fail(this.method+" received no arguments, expected "+this.expectedArguments.join()),c.length<this.expectedArguments.length&&a.expectation.fail(this.method+" received too few arguments ("+c.join()+"), expected "+this.expectedArguments.join()),this.expectsExactArgCount&&c.length!=this.expectedArguments.length&&a.expectation.fail(this.method+" received too many arguments ("+c.join()+"), expected "+this.expectedArguments.join());for(var d=0,f=this.expectedArguments.length;d<f;d+=1)a.deepEqual(this.expectedArguments[d],c[d])||a.expectation.fail(this.method+" received wrong arguments ("+c.join()+"), expected "+this.expectedArguments.join())},allowsCall:function(b,c){if(this.met())return!1;if("expectedThis"in this&&this.expectedThis!==b)return!1;if("expectedArguments"in this){c=c||[];if(c.length<this.expectedArguments.length)return!1;if(this.expectsExactArgCount&&c.length!=this.expectedArguments.length)return!1;for(var d=0,e=this.expectedArguments.length;d<e;d+=1)if(!a.deepEqual(this.expectedArguments[d],c[d]))return!1;return!0}return!0},withArgs:function(){return this.expectedArguments=b.call(arguments),this},withExactArgs:function(){return this.withArgs.apply(this,arguments),this.expectsExactArgCount=!0,this},on:function(a){return this.expectedThis=a,this},toString:function(){var b=(this.expectedArguments||[]).slice();this.expectsExactArgCount||c.call(b,"[...]");var d=a.spyCall.toString.call({proxy:this.method,args:b}),e=d.replace(", [...","[, ...")+" "+g(this);return this.met()?"Expectation met: "+e:"Expected "+e+" ("+f(this.callCount)+")"},verify:function(){return this.met()||a.expectation.fail(this.toString()),!0},fail:function(a){var b=new Error(a);throw b.name="ExpectationError",b}}}(),b?module.exports=d:a.mock=d}(typeof sinon=="object"&&sinon||null),function(a){function d(a){return a.fakes||(a.fakes=[]),a.fakes}function e(a,b){var c=d(a);for(var e=0,f=c.length;e<f;e+=1)typeof c[e][b]=="function"&&c[e][b]()}function f(a){var b=d(a),c=0;while(c<b.length)b.splice(c,1)}var b=typeof module=="object"&&typeof require=="function",c=[].push;!a&&b&&(a=require("../sinon"));if(!a)return;var g={verify:function(){e(this,"verify")},restore:function(){e(this,"restore"),f(this)},verifyAndRestore:function(){var a;try{this.verify()}catch(b){a=b}this.restore();if(a)throw a},add:function(a){return c.call(d(this),a),a},spy:function(){return this.add(a.spy.apply(a,arguments))},stub:function(b,c,d){if(c){var e=b[c];if(typeof e!="function"){if(!b.hasOwnProperty(c))throw new TypeError("Cannot stub non-existent own property "+c);return b[c]=d,this.add({restore:function(){b[c]=e}})}}return this.add(a.stub.apply(a,arguments))},mock:function(){return this.add(a.mock.apply(a,arguments))},inject:function(a){var b=this;return a.spy=function(){return b.spy.apply(b,arguments)},a.stub=function(){return b.stub.apply(b,arguments)},a.mock=function(){return b.mock.apply(b,arguments)},a}};b?module.exports=g:a.collection=g}(typeof sinon=="object"&&sinon||null);if(typeof sinon=="undefined")var sinon={};(function(global){function addTimer(a,b){if(a.length===0)throw new Error("Function requires at least 1 parameter");var c=id++,d=a[1]||0;return this.timeouts||(this.timeouts={}),this.timeouts[c]={id:c,func:a[0],callAt:this.now+d},b===!0&&(this.timeouts[c].interval=d),c}function parseTime(a){if(!a)return 0;var b=a.split(":"),c=b.length,d=c,e=0,f;if(c>3||!/^(\d\d:){0,2}\d\d?$/.test(a))throw new Error("tick only understands numbers and 'h:m:s'");while(d--){f=parseInt(b[d],10);if(f<60)e+=f*Math.pow(60,c-d-1);else throw new Error("Invalid time "+a)}return e*1e3}function createObject(a){var b;if(Object.create)b=Object.create(a);else{var c=function(){};c.prototype=a,b=new c}return b.Date.clock=b,b}function mirrorDateProperties(a,b){return b.now?a.now=function(){return a.clock.now}:delete a.now,b.toSource?a.toSource=function(){return b.toSource()}:delete a.toSource,a.toString=function(){return b.toString()},a.prototype=b.prototype,a.parse=b.parse,a.UTC=b.UTC,a.prototype.toUTCString=b.prototype.toUTCString,a}function restore(){var a;for(var b=0,c=this.methods.length;b<c;b++)a=this.methods[b],global[a]=this["_"+a]}function stubGlobal(a,b){b["_"+a]=global[a];if(a=="Date"){var c=mirrorDateProperties(b[a],global[a]);global[a]=c}else{global[a]=function(){return b[a].apply(b,arguments)};for(var d in b[a])b[a].hasOwnProperty(d)&&(global[a][d]=b[a][d])}global[a].clock=b}var id=1;sinon.clock={now:0,create:function(a){var b=createObject(this);typeof a=="number"&&(b.now=a);if(!a||typeof a!="object")return b;throw new TypeError("now should be milliseconds since UNIX epoch")},setTimeout:function(a,b){return addTimer.call(this,arguments,!1)},clearTimeout:function(a){this.timeouts||(this.timeouts=[]),a in this.timeouts&&delete this.timeouts[a]},setInterval:function(a,b){return addTimer.call(this,arguments,!0)},clearInterval:function(a){this.clearTimeout(a)},tick:function(a){a=typeof a=="number"?a:parseTime(a);var b=this.now,c=this.now+a,d=this.now,e=this.firstTimerInRange(b,c),f;while(e&&b<=c){if(this.timeouts[e.id]){b=this.now=e.callAt;try{this.callTimer(e)}catch(g){f=f||g}}e=this.firstTimerInRange(d,c),d=b}this.now=c;if(f)throw f},firstTimerInRange:function(a,b){var c,d,e;for(var f in this.timeouts)if(this.timeouts.hasOwnProperty(f)){if(this.timeouts[f].callAt<a||this.timeouts[f].callAt>b)continue;if(!d||this.timeouts[f].callAt<d)e=this.timeouts[f],d=this.timeouts[f].callAt,c={func:this.timeouts[f].func,callAt:this.timeouts[f].callAt,interval:this.timeouts[f].interval,id:this.timeouts[f].id}}return c||null},callTimer:function(timer){try{typeof timer.func=="function"?timer.func.call(null):eval(timer.func)}catch(e){var exception=e}if(!this.timeouts[timer.id]){if(exception)throw exception;return}typeof timer.interval=="number"?this.timeouts[timer.id].callAt+=timer.interval:delete this.timeouts[timer.id];if(exception)throw exception},reset:function(){this.timeouts={}},Date:function(){function b(c,d,e,f,g,h,i){switch(arguments.length){case 0:return new a(b.clock.now);case 1:return new a(c);case 2:return new a(c,d);case 3:return new a(c,d,e);case 4:return new a(c,d,e,f);case 5:return new a(c,d,e,f,g);case 6:return new a(c,d,e,f,g,h);default:return new a(c,d,e,f,g,h,i)}}var a=Date;return mirrorDateProperties(b,a)}()};var methods=["Date","setTimeout","setInterval","clearTimeout","clearInterval"];sinon.useFakeTimers=function(a){var b=sinon.clock.create(a);b.restore=restore,b.methods=Array.prototype.slice.call(arguments,typeof a=="number"?1:0),b.methods.length===0&&(b.methods=methods);for(var c=0,d=b.methods.length;c<d;c++)stubGlobal(b.methods[c],b);return b}})(typeof global!="undefined"&&typeof global!="function"?global:this),sinon.timers={setTimeout:setTimeout,clearTimeout:clearTimeout,setInterval:setInterval,clearInterval:clearInterval,Date:Date},typeof module=="object"&&typeof require=="function"&&(module.exports=sinon),typeof sinon=="undefined"&&(this.sinon={}),function(){var a=[].push;sinon.Event=function b(a,b,c){this.initEvent(a,b,c)},sinon.Event.prototype={initEvent:function(a,b,c){this.type=a,this.bubbles=b,this.cancelable=c},stopPropagation:function(){},preventDefault:function(){this.defaultPrevented=!0}},sinon.EventTarget={addEventListener:function c(b,c,d){this.eventListeners=this.eventListeners||{},this.eventListeners[b]=this.eventListeners[b]||[],a.call(this.eventListeners[b],c)},removeEventListener:function d(a,b,c){var d=this.eventListeners&&this.eventListeners[a]||[];for(var e=0,f=d.length;e<f;++e)if(d[e]==b)return d.splice(e,1)},dispatchEvent:function(a){var b=a.type,c=this.eventListeners&&this.eventListeners[b]||[];for(var d=0;d<c.length;d++)typeof c[d]=="function"?c[d].call(this,a):c[d].handleEvent(a);return!!a.defaultPrevented}}}(),typeof sinon=="undefined"&&(this.sinon={}),sinon.xhr={XMLHttpRequest:this.XMLHttpRequest},function(a){function d(){this.readyState=d.UNSENT,this.requestHeaders={},this.requestBody=null,this.status=0,this.statusText="",typeof d.onCreate=="function"&&d.onCreate(this)}function e(a){if(a.readyState!==d.OPENED)throw new Error("INVALID_STATE_ERR");if(a.sendFlag)throw new Error("INVALID_STATE_ERR")}function f(a,b){if(!a)return;for(var c=0,d=a.length;c<d;c+=1)b(a[c])}function g(a,b){for(var c=0;c<a.length;c++)if(b(a[c])===!0)return!0;return!1}function j(a){if(a.readyState==d.DONE)throw new Error("Request done")}function k(a){if(a.async&&a.readyState!=d.HEADERS_RECEIVED)throw new Error("No headers received")}function l(a){if(typeof a!="string"){var b=new Error("Attempted to respond to fake XMLHttpRequest with "+a+", which is not a string.");throw b.name="InvalidBodyException",b}}var b=sinon.xhr;b.GlobalXMLHttpRequest=a.XMLHttpRequest,b.GlobalActiveXObject=a.ActiveXObject,b.supportsActiveX=typeof b.GlobalActiveXObject!="undefined",b.supportsXHR=typeof b.GlobalXMLHttpRequest!="undefined",b.workingXHR=b.supportsXHR?b.GlobalXMLHttpRequest:b.supportsActiveX?function(){return new b.GlobalActiveXObject("MSXML2.XMLHTTP.3.0")}:!1;var c={"Accept-Charset":!0,"Accept-Encoding":!0,Connection:!0,"Content-Length":!0,Cookie:!0,Cookie2:!0,"Content-Transfer-Encoding":!0,Date:!0,Expect:!0,Host:!0,"Keep-Alive":!0,Referer:!0,TE:!0,Trailer:!0,"Transfer-Encoding":!0,Upgrade:!0,"User-Agent":!0,Via:!0},h=function(a,b,c){switch(c.length){case 0:return a[b]();case 1:return a[b](c[0]);case 2:return a[b](c[0],c[1]);case 3:return a[b](c[0],c[1],c[2]);case 4:return a[b](c[0],c[1],c[2],c[3]);case 5:return a[b](c[0],c[1],c[2],c[3],c[4])}};d.filters=[],d.addFilter=function(a){this.filters.push(a)};var i=/MSIE 6/;d.defake=function(a,b){var c=new sinon.xhr.workingXHR;f(["open","setRequestHeader","send","abort","getResponseHeader","getAllResponseHeaders","addEventListener","overrideMimeType","removeEventListener"],function(b){a[b]=function(){return h(c,b,arguments)}});var e=function(b){f(b,function(b){try{a[b]=c[b]}catch(d){if(!i.test(navigator.userAgent))throw d}})},g=function(){a.readyState=c.readyState,c.readyState>=d.HEADERS_RECEIVED&&e(["status","statusText"]),c.readyState>=d.LOADING&&e(["responseText"]),c.readyState===d.DONE&&e(["responseXML"]),a.onreadystatechange&&a.onreadystatechange.call(a)};if(c.addEventListener){for(var j in a.eventListeners)a.eventListeners.hasOwnProperty(j)&&f(a.eventListeners[j],function(a){c.addEventListener(j,a)});c.addEventListener("readystatechange",g)}else c.onreadystatechange=g;h(c,"open",b)},d.useFilters=!1,sinon.extend(d.prototype,sinon.EventTarget,{async:!0,open:function(a,b,c,e,f){this.method=a,this.url=b,this.async=typeof c=="boolean"?c:!0,this.username=e,this.password=f,this.responseText=null,this.responseXML=null,this.requestHeaders={},this.sendFlag=!1;if(sinon.FakeXMLHttpRequest.useFilters===!0){var h=arguments,i=g(d.filters,function(a){return a.apply(this,h)});if(i)return sinon.FakeXMLHttpRequest.defake(this,arguments)}this.readyStateChange(d.OPENED)},readyStateChange:function(a){this.readyState=a;if(typeof this.onreadystatechange=="function")try{this.onreadystatechange()}catch(b){sinon.logError("Fake XHR onreadystatechange handler",b)}this.dispatchEvent(new sinon.Event("readystatechange"))},setRequestHeader:function(a,b){e(this);if(c[a]||/^(Sec-|Proxy-)/.test(a))throw new Error('Refused to set unsafe header "'+a+'"');this.requestHeaders[a]?this.requestHeaders[a]+=","+b:this.requestHeaders[a]=b},setResponseHeaders:function(a){this.responseHeaders={};for(var b in a)a.hasOwnProperty(b)&&(this.responseHeaders[b]=a[b]);this.async&&this.readyStateChange(d.HEADERS_RECEIVED)},send:function(a){e(this);if(!/^(get|head)$/i.test(this.method)){if(this.requestHeaders["Content-Type"]){var b=this.requestHeaders["Content-Type"].split(";");this.requestHeaders["Content-Type"]=b[0]+";charset=utf-8"}else this.requestHeaders["Content-Type"]="text/plain;charset=utf-8";this.requestBody=a}this.errorFlag=!1,this.sendFlag=this.async,this.readyStateChange(d.OPENED),typeof this.onSend=="function"&&this.onSend(this)},abort:function(){this.aborted=!0,this.responseText=null,this.errorFlag=!0,this.requestHeaders={},this.readyState>sinon.FakeXMLHttpRequest.UNSENT&&this.sendFlag&&(this.readyStateChange(sinon.FakeXMLHttpRequest.DONE),this.sendFlag=!1),this.readyState=sinon.FakeXMLHttpRequest.UNSENT},getResponseHeader:function(a){if(this.readyState<d.HEADERS_RECEIVED)return null;if(/^Set-Cookie2?$/i.test(a))return null;a=a.toLowerCase();for(var b in this.responseHeaders)if(b.toLowerCase()==a)return this.responseHeaders[b];return null},getAllResponseHeaders:function(){if(this.readyState<d.HEADERS_RECEIVED)return"";var a="";for(var b in this.responseHeaders)this.responseHeaders.hasOwnProperty(b)&&!/^Set-Cookie2?$/i.test(b)&&(a+=b+": "+this.responseHeaders[b]+"\r\n");return a},setResponseBody:function(a){j(this),k(this),l(a);var b=this.chunkSize||10,c=0;this.responseText="";do this.async&&this.readyStateChange(d.LOADING),this.responseText+=a.substring(c,c+b),c+=b;while(c<a.length);var e=this.getResponseHeader("Content-Type");if(this.responseText&&(!e||/(text\/xml)|(application\/xml)|(\+xml)/.test(e)))try{this.responseXML=d.parseXML(this.responseText)}catch(f){}this.async?this.readyStateChange(d.DONE):this.readyState=d.DONE},respond:function(a,b,c){this.setResponseHeaders(b||{}),this.status=typeof a=="number"?a:200,this.statusText=d.statusCodes[this.status],this.setResponseBody(c||"")}}),sinon.extend(d,{UNSENT:0,OPENED:1,HEADERS_RECEIVED:2,LOADING:3,DONE:4}),d.parseXML=function(a){var b;if(typeof DOMParser!="undefined"){var c=new DOMParser;b=c.parseFromString(a,"text/xml")}else b=new ActiveXObject("Microsoft.XMLDOM"),b.async="false",b.loadXML(a);return b},d.statusCodes={100:"Continue",101:"Switching Protocols",200:"OK",201:"Created",202:"Accepted",203:"Non-Authoritative Information",204:"No Content",205:"Reset Content",206:"Partial Content",300:"Multiple Choice",301:"Moved Permanently",302:"Found",303:"See Other",304:"Not Modified",305:"Use Proxy",307:"Temporary Redirect",400:"Bad Request",401:"Unauthorized",402:"Payment Required",403:"Forbidden",404:"Not Found",405:"Method Not Allowed",406:"Not Acceptable",407:"Proxy Authentication Required",408:"Request Timeout",409:"Conflict",410:"Gone",411:"Length Required",412:"Precondition Failed",413:"Request Entity Too Large",414:"Request-URI Too Long",415:"Unsupported Media Type",416:"Requested Range Not Satisfiable",417:"Expectation Failed",422:"Unprocessable Entity",500:"Internal Server Error",501:"Not Implemented",502:"Bad Gateway",503:"Service Unavailable",504:"Gateway Timeout",505:"HTTP Version Not Supported"},sinon.useFakeXMLHttpRequest=function(){return sinon.FakeXMLHttpRequest.restore=function c(c){b.supportsXHR&&(a.XMLHttpRequest=b.GlobalXMLHttpRequest),b.supportsActiveX&&(a.ActiveXObject=b.GlobalActiveXObject),delete sinon.FakeXMLHttpRequest.restore,c!==!0&&delete sinon.FakeXMLHttpRequest.onCreate},b.supportsXHR&&(a.XMLHttpRequest=sinon.FakeXMLHttpRequest),b.supportsActiveX&&(a.ActiveXObject=function(a){return a=="Microsoft.XMLHTTP"||/^Msxml2\.XMLHTTP/i.test(a)?new sinon.FakeXMLHttpRequest:new b.GlobalActiveXObject(a)}),sinon.FakeXMLHttpRequest},sinon.FakeXMLHttpRequest=d}(this),typeof module=="object"&&typeof require=="function"&&(module.exports=sinon);if(typeof sinon=="undefined")var sinon={};sinon.fakeServer=function(){function b(){}function c(a){return b.prototype=a,new b}function d(a){var b=a;Object.prototype.toString.call(a)!="[object Array]"&&(b=[200,{},a]);if(typeof b[2]!="string")throw new TypeError("Fake server response body should be string, but was "+typeof b[2]);return b}function g(a,b,c){var d=a.method,e=!d||d.toLowerCase()==b.toLowerCase(),f=a.url,g=!f||f==c||typeof f.test=="function"&&f.test(c);return e&&g}function h(a,b){var c=this.getHTTPMethod(b),d=b.url;if(!/^https?:\/\//.test(d)||f.test(d))d=d.replace(f,"");if(g(a,this.getHTTPMethod(b),d)){if(typeof a.response=="function"){var e=a.url,h=[b].concat(e?d.match(e).slice(1):[]);return a.response.apply(a,h)}return!0}return!1}var a=[].push,e=window.location,f=new RegExp("^"+e.protocol+"//"+e.host);return{create:function(){var a=c(this);return this.xhr=sinon.useFakeXMLHttpRequest(),a.requests=[],this.xhr.onCreate=function(b){a.addRequest(b)},a},addRequest:function(b){var c=this;a.call(this.requests,b),b.onSend=function(){c.handleRequest(this)},this.autoRespond&&!this.responding&&(setTimeout(function(){c.responding=!1,c.respond()},this.autoRespondAfter||10),this.responding=!0)},getHTTPMethod:function(a){if(this.fakeHTTPMethods&&/post/i.test(a.method)){var b=(a.requestBody||"").match(/_method=([^\b;]+)/);return b?b[1]:a.method}return a.method},handleRequest:function(b){b.async?(this.queue||(this.queue=[]),a.call(this.queue,b)):this.processRequest(b)},respondWith:function(b,c,e){if(arguments.length==1&&typeof b!="function"){this.response=d(b);return}this.responses||(this.responses=[]),arguments.length==1&&(e=b,c=b=null),arguments.length==2&&(e=c,c=b,b=null),a.call(this.responses,{method:b,url:c,response:typeof e=="function"?e:d(e)})},respond:function(){arguments.length>0&&this.respondWith.apply(this,arguments);var a=this.queue||[],b;while(b=a.shift())this.processRequest(b)},processRequest:function(a){try{if(a.aborted)return;var b=this.response||[404,{},""];if(this.responses)for(var c=0,d=this.responses.length;c<d;c++)if(h.call(this,this.responses[c],a)){b=this.responses[c].response;break}a.readyState!=4&&a.respond(b[0],b[1],b[2])}catch(e){sinon.logError("Fake server request processing",e)}},restore:function(){return this.xhr.restore&&this.xhr.restore.apply(this.xhr,arguments)}}}(),typeof module=="object"&&typeof require=="function"&&(module.exports=sinon),function(){function a(){}a.prototype=sinon.fakeServer,sinon.fakeServerWithClock=new a,sinon.fakeServerWithClock.addRequest=function b(a){if(a.async){typeof setTimeout.clock=="object"?this.clock=setTimeout.clock:(this.clock=sinon.useFakeTimers(),this.resetClock=!0);if(!this.longestTimeout){var b=this.clock.setTimeout,c=this.clock.setInterval,d=this;this.clock.setTimeout=function(a,c){return d.longestTimeout=Math.max(c,d.longestTimeout||0),b.apply(this,arguments)},this.clock.setInterval=function(a,b){return d.longestTimeout=Math.max(b,d.longestTimeout||0),c.apply(this,arguments)}}}return sinon.fakeServer.addRequest.call(this,a)},sinon.fakeServerWithClock.respond=function(){var a=sinon.fakeServer.respond.apply(this,arguments);return this.clock&&(this.clock.tick(this.longestTimeout||0),this.longestTimeout=0,this.resetClock&&(this.clock.restore(),this.resetClock=!1)),a},sinon.fakeServerWithClock.restore=function(){return this.clock&&this.clock.restore(),sinon.fakeServer.restore.apply(this,arguments)}}();if(typeof module=="object"&&typeof require=="function"){var sinon=require("../sinon");sinon.extend(sinon,require("./util/fake_timers"))}return function(){function b(b,c,d,e){if(!e)return;c.injectInto?c.injectInto[d]=e:a.call(b.args,e)}function c(a){var b=sinon.create(sinon.sandbox);return a.useFakeServer&&(typeof a.useFakeServer=="object"&&(b.serverPrototype=a.useFakeServer),b.useFakeServer()),a.useFakeTimers&&(typeof a.useFakeTimers=="object"?b.useFakeTimers.apply(b,a.useFakeTimers):b.useFakeTimers()),b}var a=[].push;sinon.sandbox=sinon.extend(sinon.create(sinon.collection),{useFakeTimers:function(){return this.clock=sinon.useFakeTimers.apply(sinon,arguments),this.add(this.clock)},serverPrototype:sinon.fakeServer,useFakeServer:function(){var a=this.serverPrototype||sinon.fakeServer;return!a||!a.create?null:(this.server=a.create(),this.add(this.server))},inject:function(a){return sinon.collection.inject.call(this,a),this.clock&&(a.clock=this.clock),this.server&&(a.server=this.server,a.requests=this.server.requests),a},create:function(a){if(!a)return sinon.create(sinon.sandbox);var d=c(a);d.args=d.args||[];var e,f,g=d.inject({});if(a.properties)for(var h=0,i=a.properties.length;h<i;h++)e=a.properties[h],f=g[e]||e=="sandbox"&&d,b(d,a,e,f);else b(d,a,"sandbox",f);return d}}),sinon.sandbox.useFakeXMLHttpRequest=sinon.sandbox.useFakeServer,typeof module=="object"&&typeof require=="function"&&(module.exports=sinon.sandbox)}(),function(a){function c(b){var c=typeof b;if(c!="function")throw new TypeError("sinon.test needs to wrap a test function, got "+c);return function(){var c=a.getConfig(a.config);c.injectInto=c.injectIntoThis&&this||c.injectInto;var d=a.sandbox.create(c),e,f,g=Array.prototype.slice.call(arguments).concat(d.args);try{f=b.apply(this,g)}finally{d.verifyAndRestore()}return f}}var b=typeof module=="object"&&typeof require=="function";!a&&b&&(a=require("../sinon"));if(!a)return;c.config={injectIntoThis:!0,injectInto:null,properties:["spy","stub","mock","clock","server","requests"],useFakeTimers:!0,useFakeServer:!0},b?module.exports=c:a.test=c}(typeof sinon=="object"&&sinon||null),function(a){function c(a,b,c){return function(){b&&b.apply(this,arguments);var d,e;try{e=a.apply(this,arguments)}catch(f){d=f}c&&c.apply(this,arguments);if(d)throw d;return e}}function d(b,d){if(!b||typeof b!="object")throw new TypeError("sinon.testCase needs an object with test functions");d=d||"test";var e=new RegExp("^"+d),f={},g,h,i,j=b.setUp,k=b.tearDown;for(g in b)if(b.hasOwnProperty(g)){h=b[g];if(/^(setUp|tearDown)$/.test(g))continue;if(typeof h=="function"&&e.test(g)){i=h;if(j||k)i=c(h,j,k);f[g]=a.test(i)}else f[g]=b[g]}return f}var b=typeof module=="object"&&typeof require=="function";!a&&b&&(a=require("../sinon"));if(!a||!Object.prototype.hasOwnProperty)return;b?module.exports=d:a.testCase=d}(typeof sinon=="object"&&sinon||null),function(a,b){function f(){var a;for(var b=0,c=arguments.length;b<c;++b)a=arguments[b],a||e.fail("fake is not a spy"),typeof a!="function"&&e.fail(a+" is not a function"),typeof a.getCall!="function"&&e.fail(a+" is not stubbed")}function g(a,c){a=a||b;var d=a.fail||e.fail;d.call(a,c)}function h(a,b,c){arguments.length==2&&(c=b,b=a),e[a]=function(h){f(h);var i=d.call(arguments,1),j=!1;typeof b=="function"?j=!b(h):j=typeof h[b]=="function"?!h[b].apply(h,i):!h[b],j?g(this,h.printf.apply(h,[c].concat(i))):e.pass(a)}}function i(a,b){return!a||/^fail/.test(b)?b:a+b.slice(0,1).toUpperCase()+b.slice(1)}var c=typeof module=="object"&&typeof require=="function",d=Array.prototype.slice,e;!a&&c&&(a=require("../sinon"));if(!a)return;e={failException:"AssertError",fail:function(a){var b=new Error(a);throw b.name=this.failException||e.failException,b},pass:function(a){},callOrder:function(){f.apply(null,arguments);var b="",c="";if(!a.calledInOrder(arguments)){try{b=[].join.call(arguments,", "),c=a.orderByFirstCall(d.call(arguments)).join(", ")}catch(h){}g(this,"expected "+b+" to be "+"called in order but were called as "+c)}else e.pass("callOrder")},callCount:function(b,c){f(b);if(b.callCount!=c){var d="expected %n to be called "+a.timesInWords(c)+" but was called %c%C";g(this,b.printf(d))}else e.pass("callCount")},expose:function(a,b){if(!a)throw new TypeError("target is null or undefined");var c=b||{},d=typeof c.prefix=="undefined"&&"assert"||c.prefix,e=typeof c.includeFail=="undefined"||!!c.includeFail;for(var f in this)f!="export"&&(e||!/^(fail)/.test(f))&&(a[i(d,f)]=this[f]);return a}},h("called","expected %n to have been called at least once but was never called"),h("notCalled",function(a){return!a.called},"expected %n to not have been called but was called %c%C"),h("calledOnce","expected %n to be called once but was called %c%C"),h("calledTwice","expected %n to be called twice but was called %c%C"),h("calledThrice","expected %n to be called thrice but was called %c%C"),h("calledOn","expected %n to be called with %1 as this but was called with %t"),h("alwaysCalledOn","expected %n to always be called with %1 as this but was called with %t"),h("calledWith","expected %n to be called with arguments %*%C"),h("alwaysCalledWith","expected %n to always be called with arguments %*%C"),h("calledWithExactly","expected %n to be called with exact arguments %*%C"),h("alwaysCalledWithExactly","expected %n to always be called with exact arguments %*%C"),h("neverCalledWith","expected %n to never be called with arguments %*%C"),h("threw","%n did not throw exception%C"),h("alwaysThrew","%n did not always throw exception%C"),c?module.exports=e:a.assert=e}(typeof sinon=="object"&&sinon||null,typeof window!="undefined"?window:global),sinon}.call(typeof window!="undefined"&&window||{})