"""
Module to provide plug-and-play authentication support for Google App Engine
using flask-auth.
"""

from google.appengine.ext import db
from flaskext.auth import AuthUser

class User(db.Model, AuthUser):
    """
    Implementation of User for persistence in Google's App Engine datastore.
    """
    username = db.StringProperty(required=True)
    password = db.StringProperty(required=True)
    salt = db.StringProperty()
    role = db.StringProperty()
    created = db.DateTimeProperty(auto_now_add=True)
    modified = db.DateTimeProperty(auto_now=True)

    def __init__(self, *args, **kwargs):
        super(User, self).__init__(*args, **kwargs)
        password = kwargs.get('password')
        if password is not None and not self.has_key():
            # Initialize and encrypt password before first save.
            self.set_and_encrypt_password(password)
