# -*- encoding: utf-8 -*-
"""
    fidji_bridgekeeper.duty
    -----------------------

    :copyright: (c) 2013 by Morgan Delahaye-Prat.
    :license: BSD, see LICENSE for more details.
"""


from __future__ import absolute_import
from __future__ import unicode_literals


class DutySet(set):
    """
    A set supporting only Duty objects.
    """

    def update(self, items):
        for item in items:
            self.add(item)

    def add(self, item):
        if item not in self and type(item) is Duty:
            super(DutySet, self).add(item)

    def __contains__(self, item):
        return bool([obj for obj in self if obj == item])


class Duty(object):
    """
    Implements a user's duty defined by a `type` and an `id`.
    """

    def __init__(self, _type, _id):
        self.type = _type
        self.id = _id

    def __repr__(self):
        return '<Duty 0x{} type="{}", id="{}">'.format(id(self),
                                                       self.type,
                                                       self.id)

    def __eq__(self, other):
        """
        Duty object are equal if their identifier and type is the same.
        """
        return self.id == other.id and self.type == self.type

