# -*- encoding: utf-8 -*-
"""
    flask_bridgekeeper.tools
    ------------------------

    A set of tools for common task related to *Bridgekeeper*.

    :copyright: (c) 2013 by Morgan Delahaye-Prat.
    :license: BSD, see LICENSE for more details.
"""


from __future__ import absolute_import
from __future__ import unicode_literals

from functools import partial
from werkzeug import LocalStack, LocalProxy
from flask import _app_ctx_stack

def _lookup_identity_object(name):
    top = _app_ctx_stack.top
    if top is None:
        raise RuntimeError('working outside of application context')
    return getattr(getattr(top, 'g'), name, None)

current_identity = LocalProxy(partial(_lookup_identity_object, 'bridgekeeper'))
