from pyga.requests import Tracker, Visitor, Session, Page


class MxitGA(object):
	def __init__(self, app=None):
		self.app = app
		if app is not None:
			self.init_app(app)
		tracking_id = app.config['GA']['ID']
		domain = app.config['GA']['DOMAIN']
		self.tracker = Tracker(tracking_id, domain)

	def init_app(self, app):
		if hasattr(app, 'teardown_appcontext'):
			app.teardown_appcontext(self.teardown)
		else:
			app.teardown_request(self.teardown)

	def connect(self):
		pass

	def teardown(self, exception):
		pass

	def track(self, request):
		if 'X-Forwarded-For' not in request.headers:
			print("Doesn't look like a mxit request.")
			return
		try:
			visitor = Visitor()
			visitor.ip_address = request['X-Forwarded-For']
			#TODO: Persist sessions.
			session = Session()
			page = Page(request.url)
			self.tracker.track_pageview(page, session, visitor)
			print('Tracked page')
		except Exception:
			print('Problem tracking event: %s' % str(request))