from pyga.requests import Tracker, Visitor, Session, Page
from flask import request

class MxitGA(object):
	def __init__(self, app=None):
		self.app = app
		tracking_id = app.config['GA']['ID']
		domain = app.config['GA']['DOMAIN']
		self.tracker = Tracker(tracking_id, domain)

	def register_blueprint(self, blueprint):
		def f(response):
			self.track(request)
			return response
		blueprint.after_request(f)

	def track(self, request):
		if 'X-Forwarded-For' not in request.headers:
			print("Doesn't look like a mxit request.")
			return
		try:
			visitor = Visitor()
			visitor.ip_address = request.headers['X-Forwarded-For'].split(',')[0].strip()
			#TODO: Persist sessions.
			session = Session()
			page = Page(request.path)
			self.tracker.track_pageview(page, session, visitor)
		except Exception as e:
			print('Problem tracking event: %s\nProblem:\n%s' % (str(request), e))
