# -*- coding: utf-8 -*-

from werkzeug.routing import BaseConverter


class RegexConverter(BaseConverter):
    def __init__(self, url_map, *items):
        super(RegexConverter, self).__init__(url_map)
        self.regex = items[0]


class Reggie(object):
    """ Enables Flask Regex Routes """

    def __init__(self, app=None):
        self.app = app

        if self.app:
            self.init_app(self.app)

    def init_app(self, app):
        """ Configures the Regex Converter """

        app.url_map.converters['regex'] = RegexConverter
