/*
Copyright (c) 2010 Jeremy Faivre

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is furnished
to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
var YamlParseException=function(d,a,c,b){this.rawMessage=d;this.parsedLine=(a!==undefined)?a:-1;this.snippet=(c!==undefined)?c:null;this.parsedFile=(b!==undefined)?b:null;this.updateRepr();this.message=d};YamlParseException.prototype={name:"YamlParseException",message:null,parsedFile:null,parsedLine:-1,snippet:null,rawMessage:null,isDefined:function(a){return a!=undefined&&a!=null},getSnippet:function(){return this.snippet},setSnippet:function(a){this.snippet=a;this.updateRepr()},getParsedFile:function(){return this.parsedFile},setParsedFile:function(a){this.parsedFile=a;this.updateRepr()},getParsedLine:function(){return this.parsedLine},setParsedLine:function(a){this.parsedLine=a;this.updateRepr()},updateRepr:function(){this.message=this.rawMessage;dot=false;if("."===this.message.charAt(this.message.length-1)){this.message=this.message.substring(0,this.message.length-1);dot=true}if(null!==this.parsedFile){this.message+=" in "+JSON.stringify(this.parsedFile)}if(this.parsedLine>=0){this.message+=" at line "+this.parsedLine}if(this.snippet){this.message+=' (near "'+this.snippet+'")'}if(dot){this.message+="."}}};var Yaml=function(){};Yaml.prototype={parseFile:function(c,f){if(f==undefined){var a=this.getFileContents(c);var b=null;try{b=this.parse(a)}catch(d){if(d instanceof YamlParseException){d.setParsedFile(c)}throw d}return b}this.getFileContents(c,function(e){f(new Yaml().parse(e))})},parse:function(a){var b=new YamlParser();return b.parse(a)},dump:function(c,b){if(b==undefined){b=2}var a=new YamlDumper();return a.dump(c,b)},getXHR:function(){if(window.XMLHttpRequest){return new XMLHttpRequest()}if(window.ActiveXObject){var c=["Msxml2.XMLHTTP.6.0","Msxml2.XMLHTTP.3.0","Msxml2.XMLHTTP","Microsoft.XMLHTTP"];for(var a=0;a<4;a++){try{return new ActiveXObject(c[a])}catch(b){}}}return null},getFileContents:function(a,c){var b=this.getXHR();if(c==undefined){b.open("GET",a,false);b.send(null);if(b.status==200||b.status==0){return b.responseText}return null}b.onreadystatechange=function(){if(b.readyState==4){if(b.status==200||b.status==0){c(b.responseText)}else{c(null)}}};b.open("GET",a,true);b.send(null)}};var YAML={encode:function(a,b){return new Yaml().dump(a,b)},decode:function(a){return new Yaml().parse(a)},load:function(a,b){return new Yaml().parseFile(a,b)}};var YamlInline=function(){};YamlInline.prototype={i:null,parse:function(b){var a=null;b=this.trim(b);if(0==b.length){return""}switch(b.charAt(0)){case"[":a=this.parseSequence(b);break;case"{":a=this.parseMapping(b);break;default:a=this.parseScalar(b);if(b.substr(this.i).replace(/^\s+#.*$/,"")){throw new YamlParseException('Unexpected characters near "'+b.substr(this.i)+'".')}}return a},dump:function(b){if(undefined==b||null==b){return"null"}if(b instanceof Date){return b.toISOString()}if(typeof(b)=="object"){return this.dumpObject(b)}if(typeof(b)=="boolean"){return b?"true":"false"}if(/^\d+$/.test(b)){return typeof(b)=="string"?"'"+b+"'":parseInt(b)}if(this.isNumeric(b)){return typeof(b)=="string"?"'"+b+"'":parseFloat(b)}if(typeof(b)=="number"){return b==Infinity?".Inf":(b==-Infinity?"-.Inf":(isNaN(b)?".NAN":b))}var a=new YamlEscaper();if(a.requiresDoubleQuoting(b)){return a.escapeWithDoubleQuotes(b)}if(a.requiresSingleQuoting(b)){return a.escapeWithSingleQuotes(b)}if(""==b){return""}if(this.getTimestampRegex().test(b)){return"'"+b+"'"}if(this.inArray(b.toLowerCase(),["null","~","true","false"])){return"'"+b+"'"}return b},dumpObject:function(e){var d=this.getKeys(e);var b=null;var c;var a=d.length;if(e instanceof Array){b=[];for(c=0;c<a;c++){b.push(this.dump(e[d[c]]))}return"["+b.join(", ")+"]"}b=[];for(c=0;c<a;c++){b.push(this.dump(d[c])+": "+this.dump(e[d[c]]))}return"{ "+b.join(", ")+" }"},parseScalar:function(a,h,j,e,b){if(h==undefined){h=null}if(j==undefined){j=['"',"'"]}if(e==undefined){e=0}if(b==undefined){b=true}var c=null;var g=null;var f=null;if(this.inArray(a[e],j)){c=this.parseQuotedScalar(a,e);e=this.i;if(null!==h){var d=a.substr(e).replace(/^\s+/,"");if(!this.inArray(d.charAt(0),h)){throw new YamlParseException("Unexpected characters ("+a.substr(e)+").")}}}else{if(!h){c=(a+"").substring(e);e+=c.length;g=c.indexOf(" #");if(g!=-1){c=c.substr(0,g).replace(/\s+$/g,"")}}else{if(f=new RegExp("^(.+?)("+h.join("|")+")").exec((a+"").substring(e))){c=f[1];e+=c.length}else{throw new YamlParseException("Malformed inline YAML string ("+a+").")}}c=b?this.evaluateScalar(c):c}this.i=e;return c},parseQuotedScalar:function(b,c){var e=null;if(!(e=new RegExp("^"+YamlInline.REGEX_QUOTED_STRING).exec((b+"").substring(c)))){throw new YamlParseException("Malformed inline YAML string ("+(b+"").substring(c)+").")}var a=e[0].substr(1,e[0].length-2);var d=new YamlUnescaper();if('"'==(b+"").charAt(c)){a=d.unescapeDoubleQuotedString(a)}else{a=d.unescapeSingleQuotedString(a)}c+=e[0].length;this.i=c;return a},parseSequence:function(g,c){if(c==undefined){c=0}var b=[];var a=g.length;c+=1;while(c<a){switch(g.charAt(c)){case"[":b.push(this.parseSequence(g,c));c=this.i;break;case"{":b.push(this.parseMapping(g,c));c=this.i;break;case"]":this.i=c;return b;case",":case" ":break;default:isQuoted=this.inArray(g.charAt(c),['"',"'"]);var d=this.parseScalar(g,[",","]"],['"',"'"],c);c=this.i;if(!isQuoted&&(d+"").indexOf(": ")!=-1){try{d=this.parseMapping("{"+d+"}")}catch(f){if(!(f instanceof YamlParseException)){throw f}}}b.push(d);c--}c++}throw new YamlParseException('Malformed inline YAML string "'+g+'"')},parseMapping:function(d,f){if(f==undefined){f=0}var c={};var a=d.length;f+=1;var b=false;var g=false;while(f<a){g=false;switch(d.charAt(f)){case" ":case",":f++;g=true;break;case"}":this.i=f;return c}if(g){continue}var e=this.parseScalar(d,[":"," "],['"',"'"],f,false);f=this.i;b=false;while(f<a){switch(d.charAt(f)){case"[":c[e]=this.parseSequence(d,f);f=this.i;b=true;break;case"{":c[e]=this.parseMapping(d,f);f=this.i;b=true;break;case":":case" ":break;default:c[e]=this.parseScalar(d,[",","}"],['"',"'"],f);f=this.i;b=true;f--}++f;if(b){g=true;break}}if(g){continue}}throw new YamlParseException('Malformed inline YAML string "'+d+'"')},evaluateScalar:function(b){b=this.trim(b);var c=null;var a=null;if(("null"==b.toLowerCase())||(""==b)||("~"==b)){return null}if((b+"").indexOf("!str ")==0){return(""+b).substring(5)}if((b+"").indexOf("! ")==0){return parseInt(this.parseScalar((b+"").substr(2)))}if(/^\d+$/.test(b)){c=b;a=parseInt(b);return"0"==b.charAt(0)?this.octdec(b):((""+c==""+a)?a:c)}if("true"==(b+"").toLowerCase()){return true}if("false"==(b+"").toLowerCase()){return false}if(this.isNumeric(b)){return"0x"==(b+"").substr(0,2)?this.hexdec(b):parseFloat(b)}if(b.toLowerCase()==".inf"){return Infinity}if(b.toLowerCase()==".nan"){return NaN}if(b.toLowerCase()=="-.inf"){return -Infinity}if(/^(-|\+)?[0-9,]+(\.[0-9]+)?$/.test(b)){return parseFloat(b.split(",").join(""))}if(this.getTimestampRegex().test(b)){return new Date(this.strtotime(b))}return""+b},getTimestampRegex:function(){return new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:.([0-9]*))?(?:[ \t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?)?$","gi")},trim:function(a){return(a+"").replace(/^\s+/,"").replace(/\s+$/,"")},isNumeric:function(a){return(a-0)==a&&a.length>0&&a.replace(/\s+/g,"")!=""},inArray:function(c,d){var b;var a=d.length;for(b=0;b<a;b++){if(c==d[b]){return true}}return false},getKeys:function(c){var b=[];for(var a in c){if(c.hasOwnProperty(a)){b.push(a)}}return b},octdec:function(a){return parseInt((a+"").replace(/[^0-7]/gi,""),8)},hexdec:function(a){a=this.trim(a);if((a+"").substr(0,2)=="0x"){a=(a+"").substring(2)}return parseInt((a+"").replace(/[^a-f0-9]/gi,""),16)},strtotime:function(m,s){var o,r,n,i,q="";m=(m+"").replace(/\s{2,}|^\s|\s$/g," ").replace(/[\t\r\n]/g,"");if(m==="now"){return s===null||isNaN(s)?new Date().getTime()||0:s||0}else{if(!isNaN(q=Date.parse(m))){return q||0}else{if(s){s=new Date(s)}else{s=new Date()}}}m=m.toLowerCase();var p={day:{sun:0,mon:1,tue:2,wed:3,thu:4,fri:5,sat:6},mon:["jan","feb","mar","apr","may","jun","jul","aug","sep","oct","nov","dec"]};var t=function(b){var d=(b[2]&&b[2]==="ago");var e=(e=b[0]==="last"?-1:1)*(d?-1:1);switch(b[0]){case"last":case"next":switch(b[1].substring(0,3)){case"yea":s.setFullYear(s.getFullYear()+e);break;case"wee":s.setDate(s.getDate()+(e*7));break;case"day":s.setDate(s.getDate()+e);break;case"hou":s.setHours(s.getHours()+e);break;case"min":s.setMinutes(s.getMinutes()+e);break;case"sec":s.setSeconds(s.getSeconds()+e);break;case"mon":if(b[1]==="month"){s.setMonth(s.getMonth()+e);break}default:var a=p.day[b[1].substring(0,3)];if(typeof a!=="undefined"){var c=a-s.getDay();if(c===0){c=7*e}else{if(c>0){if(b[0]==="last"){c-=7}}else{if(b[0]==="next"){c+=7}}}s.setDate(s.getDate()+c);s.setHours(0,0,0,0)}}break;default:if(/\d+/.test(b[0])){e*=parseInt(b[0],10);switch(b[1].substring(0,3)){case"yea":s.setFullYear(s.getFullYear()+e);break;case"mon":s.setMonth(s.getMonth()+e);break;case"wee":s.setDate(s.getDate()+(e*7));break;case"day":s.setDate(s.getDate()+e);break;case"hou":s.setHours(s.getHours()+e);break;case"min":s.setMinutes(s.getMinutes()+e);break;case"sec":s.setSeconds(s.getSeconds()+e);break}}else{return false}break}return true};n=m.match(/^(\d{2,4}-\d{2}-\d{2})(?:\s(\d{1,2}:\d{2}(:\d{2})?)?(?:\.(\d+))?)?$/);if(n!==null){if(!n[2]){n[2]="00:00:00"}else{if(!n[3]){n[2]+=":00"}}i=n[1].split(/-/g);i[1]=p.mon[i[1]-1]||i[1];i[0]=+i[0];i[0]=(i[0]>=0&&i[0]<=69)?"20"+(i[0]<10?"0"+i[0]:i[0]+""):(i[0]>=70&&i[0]<=99)?"19"+i[0]:i[0]+"";return parseInt(this.strtotime(i[2]+" "+i[1]+" "+i[0]+" "+n[2])+(n[4]?n[4]:""),10)}var l="([+-]?\\d+\\s(years?|months?|weeks?|days?|hours?|min|minutes?|sec|seconds?|sun\\.?|sunday|mon\\.?|monday|tue\\.?|tuesday|wed\\.?|wednesday|thu\\.?|thursday|fri\\.?|friday|sat\\.?|saturday)|(last|next)\\s(years?|months?|weeks?|days?|hours?|min|minutes?|sec|seconds?|sun\\.?|sunday|mon\\.?|monday|tue\\.?|tuesday|wed\\.?|wednesday|thu\\.?|thursday|fri\\.?|friday|sat\\.?|saturday))(\\sago)?";n=m.match(new RegExp(l,"gi"));if(n===null){return false}for(o=0,r=n.length;o<r;o++){if(!t(n[o].split(" "))){return false}}return s.getTime()||0}};YamlInline.REGEX_QUOTED_STRING="(?:\"(?:[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*)\"|'(?:[^']*(?:''[^']*)*)')";var YamlParser=function(a){this.offset=(a!==undefined)?a:0};YamlParser.prototype={offset:0,lines:[],currentLineNb:-1,currentLine:"",refs:{},parse:function(o){this.currentLineNb=-1;this.currentLine="";this.lines=this.cleanup(o).split("\n");var x=null;var d=null;while(this.moveToNextLine()){if(this.isCurrentLineEmpty()){continue}if(this.currentLine.charAt(0)=="\t"){throw new YamlParseException("A YAML file cannot contain tabs as indentation.",this.getRealCurrentLineNb()+1,this.currentLine)}var m=false;var u=false;var t=false;var b=null;var a=null;var w=null;var f=null;var g=null;var y=null;var l=null;var r=null;var h=null;if(b=/^\-((\s+)(.+?))?\s*$/.exec(this.currentLine)){if(d&&"mapping"==d){throw new YamlParseException("You cannot define a sequence item when in a mapping",this.getRealCurrentLineNb()+1,this.currentLine)}d="sequence";if(!this.isDefined(x)){x=[]}b={leadspaces:b[2],value:b[3]};if(this.isDefined(b.value)&&(a=/^&([^ ]+) *(.*)/.exec(b.value))){a={ref:a[1],value:a[2]};m=a.ref;b.value=a.value}if(!this.isDefined(b.value)||""==this.trim(b.value)||b.value.replace(/^ +/,"").charAt(0)=="#"){w=this.getRealCurrentLineNb()+1;f=new YamlParser(w);f.refs=this.refs;x.push(f.parse(this.getNextEmbedBlock()));this.refs=f.refs}else{if(this.isDefined(b.leadspaces)&&" "==b.leadspaces&&(a=new RegExp("^("+YamlInline.REGEX_QUOTED_STRING+"|[^ '\"{[].*?) *:(\\s+(.+?))?\\s*$").exec(b.value))){a={key:a[1],value:a[3]};w=this.getRealCurrentLineNb();f=new YamlParser(w);f.refs=this.refs;g=b.value;if(!this.isNextLineIndented()){g+="\n"+this.getNextEmbedBlock(this.getCurrentLineIndentation()+2)}x.push(f.parse(g));this.refs=f.refs}else{x.push(this.parseValue(b.value))}}}else{if(b=new RegExp("^("+YamlInline.REGEX_QUOTED_STRING+"|[^ '\"[{].*?) *:(\\s+(.+?))?\\s*$").exec(this.currentLine)){if(!this.isDefined(x)){x={}}if(d&&"sequence"==d){throw new YamlParseException("You cannot define a mapping item when in a sequence",this.getRealCurrentLineNb()+1,this.currentLine)}d="mapping";b={key:b[1],value:b[3]};try{y=new YamlInline().parseScalar(b.key)}catch(s){if(s instanceof YamlParseException){s.setParsedLine(this.getRealCurrentLineNb()+1);s.setSnippet(this.currentLine)}throw s}if("<<"==y){if(this.isDefined(b.value)&&"*"==(b.value+"").charAt(0)){u=b.value.substr(1);if(this.refs[u]==undefined){throw new YamlParseException('Reference "'+o+'" does not exist',this.getRealCurrentLineNb()+1,this.currentLine)}}else{if(this.isDefined(b.value)&&b.value!=""){o=b.value}else{o=this.getNextEmbedBlock()}w=this.getRealCurrentLineNb()+1;f=new YamlParser(w);f.refs=this.refs;l=f.parse(o);this.refs=f.refs;var v=[];if(!this.isObject(l)){throw new YamlParseException("YAML merge keys used with a scalar value instead of an array",this.getRealCurrentLineNb()+1,this.currentLine)}else{if(this.isDefined(l[0])){h=this.reverseArray(l);r=h.length;for(var q=0;q<r;q++){var n=h[q];if(!this.isObject(h[q])){throw new YamlParseException("Merge items must be arrays",this.getRealCurrentLineNb()+1,this.currentLine)}v=this.mergeObject(h[q],v)}}else{v=this.mergeObject(v,l)}}t=v}}else{if(this.isDefined(b.value)&&(a=/^&([^ ]+) *(.*)/.exec(b.value))){a={ref:a[1],value:a[2]};m=a.ref;b.value=a.value}}if(t){x=t}else{if(!this.isDefined(b.value)||""==this.trim(b.value)||this.trim(b.value).charAt(0)=="#"){if(this.isNextLineIndented()&&!this.isNextLineUnIndentedCollection()){x[y]=null}else{w=this.getRealCurrentLineNb()+1;f=new YamlParser(w);f.refs=this.refs;x[y]=f.parse(this.getNextEmbedBlock());this.refs=f.refs}}else{if(u){x=this.refs[u]}else{x[y]=this.parseValue(b.value)}}}}else{if(2==this.lines.length&&this.isEmpty(this.lines[1])){try{o=new YamlInline().parse(this.lines[0])}catch(s){if(s instanceof YamlParseException){s.setParsedLine(this.getRealCurrentLineNb()+1);s.setSnippet(this.currentLine)}throw s}if(this.isObject(o)){first=o[0];if(typeof(o)=="string"&&"*"==first.charAt(0)){x=[];r=o.length;for(var q=0;q<r;q++){x.push(this.refs[o[q].substr(1)])}o=x}}return o}throw new YamlParseException("Unable to parse.",this.getRealCurrentLineNb()+1,this.currentLine)}}if(m){if(x instanceof Array){this.refs[m]=x[x.length-1]}else{var j=null;for(var p in x){if(x.hasOwnProperty(p)){j=p}}this.refs[m]=x[p]}}}return this.isEmpty(x)?null:x},getRealCurrentLineNb:function(){return this.currentLineNb+this.offset},getCurrentLineIndentation:function(){return this.currentLine.length-this.currentLine.replace(/^ +/g,"").length},getNextEmbedBlock:function(c){this.moveToNextLine();var b=null;var a=null;if(!this.isDefined(c)){b=this.getCurrentLineIndentation();var g=this.isStringUnIndentedCollectionItem(this.currentLine);if(!this.isCurrentLineEmpty()&&0==b&&!g){throw new YamlParseException("Indentation problem A",this.getRealCurrentLineNb()+1,this.currentLine)}}else{b=c}var f=[this.currentLine.substr(b)];var d=this.isStringUnIndentedCollectionItem(this.currentLine);while(this.moveToNextLine()){if(d&&!this.isStringUnIndentedCollectionItem(this.currentLine)){this.moveToPreviousLine();break}if(this.isCurrentLineEmpty()){if(this.isCurrentLineBlank()){f.push(this.currentLine.substr(b))}continue}a=this.getCurrentLineIndentation();var e;if(e=/^( *)$/.exec(this.currentLine)){f.push(e[1])}else{if(a>=b){f.push(this.currentLine.substr(b))}else{if(0==a){this.moveToPreviousLine();break}else{throw new YamlParseException("Indentation problem B",this.getRealCurrentLineNb()+1,this.currentLine)}}}}return f.join("\n")},moveToNextLine:function(){if(this.currentLineNb>=this.lines.length-1){return false}this.currentLineNb++;this.currentLine=this.lines[this.currentLineNb];return true},moveToPreviousLine:function(){this.currentLineNb--;this.currentLine=this.lines[this.currentLineNb]},parseValue:function(c){if("*"==(c+"").charAt(0)){if(this.trim(c).charAt(0)=="#"){c=(c+"").substr(1,c.indexOf("#")-2)}else{c=(c+"").substr(1)}if(this.refs[c]==undefined){throw new YamlParseException('Reference "'+c+'" does not exist',this.getRealCurrentLineNb()+1,this.currentLine)}return this.refs[c]}var b=null;if(b=/^(\||>)(\+|\-|\d+|\+\d+|\-\d+|\d+\+|\d+\-)?( +#.*)?$/.exec(c)){b={separator:b[1],modifiers:b[2],comments:b[3]};var a=this.isDefined(b.modifiers)?b.modifiers:"";return this.parseFoldedScalar(b.separator,a.replace(/\d+/g,""),Math.abs(parseInt(a)))}try{return new YamlInline().parse(c)}catch(d){if(d instanceof YamlParseException){d.setParsedLine(this.getRealCurrentLineNb()+1);d.setSnippet(this.currentLine)}throw d}},parseFoldedScalar:function(c,h,f){if(h==undefined){h=""}if(f==undefined){f=0}c="|"==c?"\n":" ";var i="";var g=null;var b=this.moveToNextLine();while(b&&this.isCurrentLineBlank()){i+="\n";b=this.moveToNextLine()}if(!b){return""}var d=null;if(!(d=new RegExp("^("+(f?this.strRepeat(" ",f):" +")+")(.*)$").exec(this.currentLine))){this.moveToPreviousLine();return""}d={indent:d[1],text:d[2]};var a=d.indent;var e=0;i+=d.text+c;while(this.currentLineNb+1<this.lines.length){this.moveToNextLine();if(d=new RegExp("^( {"+a.length+",})(.+)$").exec(this.currentLine)){d={indent:d[1],text:d[2]};if(" "==c&&e!=d.indent){i=i.substr(0,i.length-1)+"\n"}e=d.indent;g=d.indent.length-a.length;i+=this.strRepeat(" ",g)+d.text+(g!=0?"\n":c)}else{if(d=/^( *)$/.exec(this.currentLine)){i+=d[1].replace(new RegExp("^ {1,"+a.length+"}","g"),"")+"\n"}else{this.moveToPreviousLine();break}}}if(" "==c){i=i.replace(/ (\n*)$/g,"\n$1")}switch(h){case"":i=i.replace(/\n+$/g,"\n");break;case"+":break;case"-":i=i.replace(/\n+$/g,"");break}return i},isNextLineIndented:function(){var b=this.getCurrentLineIndentation();var c=this.moveToNextLine();while(c&&this.isCurrentLineEmpty()){c=this.moveToNextLine()}if(false==c){return false}var a=false;if(this.getCurrentLineIndentation()<=b){a=true}this.moveToPreviousLine();return a},isCurrentLineEmpty:function(){return this.isCurrentLineBlank()||this.isCurrentLineComment()},isCurrentLineBlank:function(){return""==this.trim(this.currentLine)},isCurrentLineComment:function(){var a=this.currentLine.replace(/^ +/g,"");return a.charAt(0)=="#"},cleanup:function(d){d=d.split("\r\n").join("\n").split("\r").join("\n");if(!/\n$/.test(d)){d+="\n"}var c=0;var b=/^\%YAML[: ][\d\.]+.*\n/;while(b.test(d)){d=d.replace(b,"");c++}this.offset+=c;b=/^(#.*?\n)+/;if(b.test(d)){var a=d.replace(b,"");this.offset+=this.subStrCount(d,"\n")-this.subStrCount(a,"\n");d=a}b=/^\-\-\-.*?\n/;if(b.test(d)){a=d.replace(b,"");this.offset+=this.subStrCount(d,"\n")-this.subStrCount(a,"\n");d=a;d=d.replace(/\.\.\.\s*$/g,"")}return d},isNextLineUnIndentedCollection:function(){var b=this.getCurrentLineIndentation();var c=this.moveToNextLine();while(c&&this.isCurrentLineEmpty()){c=this.moveToNextLine()}if(false===c){return false}var a=false;if(this.getCurrentLineIndentation()==b&&this.isStringUnIndentedCollectionItem(this.currentLine)){a=true}this.moveToPreviousLine();return a},isStringUnIndentedCollectionItem:function(a){return(0===this.currentLine.indexOf("- "))},isObject:function(a){return typeof(a)=="object"&&this.isDefined(a)},isEmpty:function(a){return a==undefined||a==null||a==""||a==0||a=="0"||a==false},isDefined:function(a){return a!=undefined&&a!=null},reverseArray:function(c){var b=[];var a=c.length;for(var d=a-1;d>=0;d--){b.push(c[d])}return b},merge:function(e,d){var g={};var f;for(f in e){if(e.hasOwnProperty(f)){if(/^\d+$/.test(f)){g.push(e)}else{g[f]=e[f]}}}for(f in d){if(d.hasOwnProperty(f)){if(/^\d+$/.test(f)){g.push(d)}else{g[f]=d[f]}}}return g},strRepeat:function(d,c){var b;var a="";for(b=0;b<c;b++){a+=d}return a},subStrCount:function(d,b,j,f){var h=0;d=""+d;b=""+b;if(j!=undefined){d=d.substr(j)}if(f!=undefined){d=d.substr(0,f)}var a=d.length;var g=b.length;for(var e=0;e<a;e++){if(b==d.substr(e,g)){h++}e+=g-1}return h},trim:function(a){return(a+"").replace(/^ +/,"").replace(/ +$/,"")}};YamlEscaper=function(){};YamlEscaper.prototype={requiresDoubleQuoting:function(a){return new RegExp(YamlEscaper.REGEX_CHARACTER_TO_ESCAPE).test(a)},escapeWithDoubleQuotes:function(f){f=f+"";var a=YamlEscaper.escapees.length;var e=YamlEscaper.escaped.length;var b=YamlEscaper.escaped;for(var d=0;d<a;++d){if(d>=e){b.push("")}}var c="";c=f.replace(new RegExp(YamlEscaper.escapees.join("|"),"g"),function(h){for(var g=0;g<a;++g){if(h==YamlEscaper.escapees[g]){return b[g]}}});return'"'+c+'"'},requiresSingleQuoting:function(a){return/[\s'":{}[\],&*#?]|^[-?|<>=!%@`]/.test(a)},escapeWithSingleQuotes:function(a){return"'"+a.replace(/'/g,"''")+"'"}};YamlEscaper.REGEX_CHARACTER_TO_ESCAPE="[\\x00-\\x1f]|\xc2\x85|\xc2\xa0|\xe2\x80\xa8|\xe2\x80\xa9";YamlEscaper.escapees=["\\\\",'\\"','"',"\x00","\x01","\x02","\x03","\x04","\x05","\x06","\x07","\x08","\x09","\x0a","\x0b","\x0c","\x0d","\x0e","\x0f","\x10","\x11","\x12","\x13","\x14","\x15","\x16","\x17","\x18","\x19","\x1a","\x1b","\x1c","\x1d","\x1e","\x1f","\xc2\x85","\xc2\xa0","\xe2\x80\xa8","\xe2\x80\xa9"];YamlEscaper.escaped=['\\"',"\\\\",'\\"',"\\0","\\x01","\\x02","\\x03","\\x04","\\x05","\\x06","\\a","\\b","\\t","\\n","\\v","\\f","\\r","\\x0e","\\x0f","\\x10","\\x11","\\x12","\\x13","\\x14","\\x15","\\x16","\\x17","\\x18","\\x19","\\x1a","\\e","\\x1c","\\x1d","\\x1e","\\x1f","\\N","\\_","\\L","\\P"];var YamlUnescaper=function(){};YamlUnescaper.prototype={unescapeSingleQuotedString:function(a){return a.replace(/''/g,"'")},unescapeDoubleQuotedString:function(a){var b=function(c){return new YamlUnescaper().unescapeCharacter(c)};return a.replace(new RegExp(YamlUnescaper.REGEX_ESCAPED_CHARACTER,"g"),b)},unescapeCharacter:function(a){switch(a.charAt(1)){case"0":return String.fromCharCode(0);case"a":return String.fromCharCode(7);case"b":return String.fromCharCode(8);case"t":return"\t";case"\t":return"\t";case"n":return"\n";case"v":return String.fromCharCode(11);case"f":return String.fromCharCode(12);case"r":return String.fromCharCode(13);case"e":return"\x1b";case" ":return" ";case'"':return'"';case"/":return"/";case"\\":return"\\";case"N":return"\x00\x85";case"_":return"\x00\xA0";case"L":return"\x20\x28";case"P":return"\x20\x29";case"x":return this.pack("n",new YamlInline().hexdec(a.substr(2,2)));case"u":return this.pack("n",new YamlInline().hexdec(a.substr(2,4)));case"U":return this.pack("N",new YamlInline().hexdec(a.substr(2,8)))}},pack:function(U){var ab=0,X=1,Y="",Z="",i=0,W=[],P,R,S,k,aa,af;var ae,ag,n,J,N,ad,V,T,Q,O,r,ah,L,M,j,K,ac;while(ab<U.length){P=U.charAt(ab);R="";ab++;while((ab<U.length)&&(U.charAt(ab).match(/[\d\*]/)!==null)){R+=U.charAt(ab);ab++}if(R===""){R="1"}switch(P){case"n":if(R==="*"){R=arguments.length-X}if(R>(arguments.length-X)){throw new Error("Warning:  pack() Type "+P+": too few arguments")}for(i=0;i<R;i++){Y+=String.fromCharCode(arguments[X]>>8&255);Y+=String.fromCharCode(arguments[X]&255);X++}break;case"N":if(R==="*"){R=arguments.length-X}if(R>(arguments.length-X)){throw new Error("Warning:  pack() Type "+P+": too few arguments")}for(i=0;i<R;i++){Y+=String.fromCharCode(arguments[X]>>24&255);Y+=String.fromCharCode(arguments[X]>>16&255);Y+=String.fromCharCode(arguments[X]>>8&255);Y+=String.fromCharCode(arguments[X]&255);X++}break;default:throw new Error("Warning:  pack() Type "+P+": unknown format code")}}if(X<arguments.length){throw new Error("Warning: pack(): "+(arguments.length-X)+" arguments unused")}return Y}};YamlUnescaper.REGEX_ESCAPED_CHARACTER='\\\\([0abt\tnvfre "\\/\\\\N_LP]|x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|U[0-9a-fA-F]{8})';var YamlDumper=function(){};YamlDumper.prototype={dump:function(g,f,c){if(f==undefined){f=0}if(c==undefined){c=0}var b="";var e=c?this.strRepeat(" ",c):"";var i;if(f<=0||!this.isObject(g)||this.isEmpty(g)){i=new YamlInline();b+=e+i.dump(g)}else{var d=!this.arrayEquals(this.getKeys(g),this.range(0,g.length-1));var a;for(var h in g){if(g.hasOwnProperty(h)){a=f-1<=0||!this.isObject(g[h])||this.isEmpty(g[h]);if(d){i=new YamlInline()}b+=e+""+(d?i.dump(h)+":":"-")+""+(a?" ":"\n")+""+this.dump(g[h],f-1,(a?0:c+2))+""+(a?"\n":"")}}}return b},strRepeat:function(d,c){var b;var a="";for(b=0;b<c;b++){a+=d}return a},isObject:function(a){return this.isDefined(a)&&typeof(a)=="object"},isEmpty:function(a){var b=a==undefined||a==null||a==""||a==0||a=="0"||a==false;if(!b&&typeof(a)=="object"&&!(a instanceof Array)){var d=0;for(var c in a){if(a.hasOwnProperty(c)){d++}}b=!d}return b},isDefined:function(a){return a!=undefined&&a!=null},getKeys:function(c){var b=[];for(var a in c){if(c.hasOwnProperty(a)){b.push(a)}}return b},range:function(d,a){if(d>a){return[]}var b=[];for(var c=d;c<=a;c++){b.push(c)}return b},arrayEquals:function(e,d){if(e.length!=d.length){return false}var c=e.length;for(var f=0;f<c;f++){if(e[f]!=d[f]){return false}}return true}};
