import re
import os

class XFGUI:
    def __init__(self):
        self.path = r"c:\xfgui"
    
    def GUI2XF(self):
        script = ""
        for file in os.listdir(self.path):
            m = self.Match(r"(.)XFGUI_(.*)\.xml", file)
            if m:
                script += ("gui2xf %s l:=%s;" % (m.group(2), m.group(1)))
        self.Run(script)

    def XF2GUI(self):
        with open(r"c:\report.txt", "r") as fr:
            script = ""
            for line in fr:
                m1 = self.Match(r".*\\(.*)\.oxf", line)
                m2 = self.Match(r"(.*) changes:", line)
                m = m1 if m1 else m2
                if m:
                    print(m.group(1))
                    for c in "JG":
                        script += ("xf2gui %s l:=%s;" % (m.group(1),c))
            self.Run(script)

    def Clear(self):
        for file in os.listdir(self.path):
            m = self.Match(r".XFGUI_.*\.xml", file)
            if m:
                os.remove(os.path.join(self.path, file))

    def Run(self, script):
        if len(script) != 0:
            os.system(r"F:\c\vc32\origin85 -h -rs %s;exit;" % script)

    def Match(self, pattern, string):
        return re.match(pattern, string, re.I)





import shutil
import zipfile

exclamination = '!!!!!!!!!!!'

class CopyBuild(object):
    def __init__(self, key, srcPath, desPath, desZipPath):
        self.key = key
        self.srcPath = srcPath
        self.desPath = desPath
        self.desZipPath = desZipPath
        pass

    @staticmethod
    def pattern1(key):
        return r"(IR[\d]-[\d]+[\w]?_%ssr[\d].+?)$" % key

    def pattern(self):
        return CopyBuild.pattern1(self.key)

    def do(self):
        for f in os.listdir(self.srcPath):
            file = os.path.join(self.srcPath, f)

            if os.path.isfile(file):
                continue
            
            if not re.match(self.pattern(), f):
                continue

            desfile = os.path.join(self.desPath, f)
            print("Copying {} to {} ...".format(f, self.desPath))
            shutil.copytree(file, desfile)
            print("Done{}\n".format(exclamination))

            with zipfile.ZipFile(os.path.join(self.desZipPath, f) + '.zip', 'w') as myzip:
                print("Zipping {} to {} ...".format(file, self.desZipPath))
                for ff in os.listdir(file):
                    myzip.write(os.path.join(file, ff), ff, zipfile.ZIP_DEFLATED)
                print("Done{}\n".format(exclamination))

            return True

        return False

     
from ftplib import FTP

class GetBuildFromFTP(object):
    def __init__(self, key, srcpath, despath):
        self.key = key
        self.srcpath = srcpath
        self.despath = despath

    def pattern(self):
        return CopyBuild.pattern1(self.key)
    
    def ftpsite(self):
        return '207.180.39.173'

    def fetch(self):
        with FTP(self.ftpsite(), 'gzoffice', 'labtalk') as ftp:
            try:
                ftp.cwd(self.srcpath)
            except:
                print("Build directory changed{}\n".format(exclamination))
                return None

            build = []
            def get(s):
                match = re.search(self.pattern(), s)
                if match:
                    build.append(match.group(0))

            ftp.dir(get)
            if build:
                build.sort(reverse=True)
                return build[0]

    def do(self):
        file = self.fetch()
        if file:
            cmd = r'flashget ftp://{}/"{}"{} {}'\
                  .format(self.ftpsite(), self.srcpath, file, os.path.join(self.despath, file))
            print('Downloading {}'.format(file))
            os.system(cmd)
            print('Downloaded{}\n'.format(exclamination))




import time
import stat

class CopySourceFiles(object):
    def stat_time(self, file):
        return int(os.stat(file).st_mtime)

    def make_file_writable(self, myfile):
        os.chmod(myfile, stat.S_IWRITE)

    def copy_files(self, desPath, srcPath, recursive = False):
        files_except = ('test.c', 'testNLParametersManager.c')
        p = re.compile('.*\.(h|c|cpp|oxf)', re.I)
        for file in os.listdir(srcPath):
            filepath = os.path.join(srcPath, file)
            if os.path.isfile(filepath):
                if p.match(file) and file not in files_except:
                    desfile = os.path.join(desPath, file)
                    if not os.path.isfile(desfile):
                        shutil.copyfile(filepath, desfile)
                    elif self.stat_time(filepath) != self.stat_time(desfile):
                        self.make_file_writable(desfile)
                        shutil.copy2(filepath, desfile)
                    else:
                        continue
                    print(filepath)
            elif recursive:
                desFilePath = os.path.join(desPath, file)
                if not os.path.isdir(desFilePath):
                    os.mkdir(desFilePath)
                self.copy_files(desFilePath, filepath, recursive)


