#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
**testsShell.py**

**Platform:**
	Windows, Linux, Mac Os X.

**Description:**
	Defines units tests for :mod:`foundations.shell` module.

**Others:**

"""

#**********************************************************************************************************************
#***	Future imports.
#**********************************************************************************************************************
from __future__ import unicode_literals

#**********************************************************************************************************************
#***	External imports.
#**********************************************************************************************************************
import sys

if sys.version_info[:2] <= (2, 6):
	import unittest2 as unittest
else:
	import unittest

#**********************************************************************************************************************
#***	Internal imports.
#**********************************************************************************************************************
import foundations.shell
from foundations.shell import AnsiEscapeCodes

#**********************************************************************************************************************
#***	Module attributes.
#**********************************************************************************************************************
__author__ = "Thomas Mansencal"
__copyright__ = "Copyright (C) 2008 - 2013 - Thomas Mansencal"
__license__ = "GPL V3.0 - http://www.gnu.org/licenses/"
__maintainer__ = "Thomas Mansencal"
__email__ = "thomas.mansencal@gmail.com"
__status__ = "Production"

__all__ = ["ANSI_ESCAPE_CODES", "AnsiEscapeCodesTestCase", "ColorizeTestCase"]

ANSI_ESCAPE_CODES = {"bBlack": "\033[40m",
					 "bBlue": "\033[44m",
					 "bCyan": "\033[46m",
					 "bGreen": "\033[42m",
					 "bHighBlack": "\033[100m",
					 "bHighBlue": "\033[104m",
					 "bHighCyan": "\033[106m",
					 "bHighGreen": "\033[102m",
					 "bHighPurple": "\033[105m",
					 "bHighRed": "\033[101m",
					 "bHighWhite": "\033[107m",
					 "bHighYellow": "\033[103m",
					 "bPurple": "\033[45m",
					 "bRed": "\033[41m",
					 "bWhite": "\033[47m",
					 "bYellow": "\033[43m",
					 "black": "\033[30m",
					 "blackBBlack": "\033[30m\033[40m",
					 "blackBBlue": "\033[30m\033[44m",
					 "blackBCyan": "\033[30m\033[46m",
					 "blackBGreen": "\033[30m\033[42m",
					 "blackBHighBlack": "\033[30m\033[100m",
					 "blackBHighBlue": "\033[30m\033[104m",
					 "blackBHighCyan": "\033[30m\033[106m",
					 "blackBHighGreen": "\033[30m\033[102m",
					 "blackBHighPurple": "\033[30m\033[105m",
					 "blackBHighRed": "\033[30m\033[101m",
					 "blackBHighWhite": "\033[30m\033[107m",
					 "blackBHighYellow": "\033[30m\033[103m",
					 "blackBPurple": "\033[30m\033[45m",
					 "blackBRed": "\033[30m\033[41m",
					 "blackBWhite": "\033[30m\033[47m",
					 "blackBYellow": "\033[30m\033[43m",
					 "blue": "\033[34m",
					 "blueBBlack": "\033[34m\033[40m",
					 "blueBBlue": "\033[34m\033[44m",
					 "blueBCyan": "\033[34m\033[46m",
					 "blueBGreen": "\033[34m\033[42m",
					 "blueBHighBlack": "\033[34m\033[100m",
					 "blueBHighBlue": "\033[34m\033[104m",
					 "blueBHighCyan": "\033[34m\033[106m",
					 "blueBHighGreen": "\033[34m\033[102m",
					 "blueBHighPurple": "\033[34m\033[105m",
					 "blueBHighRed": "\033[34m\033[101m",
					 "blueBHighWhite": "\033[34m\033[107m",
					 "blueBHighYellow": "\033[34m\033[103m",
					 "blueBPurple": "\033[34m\033[45m",
					 "blueBRed": "\033[34m\033[41m",
					 "blueBWhite": "\033[34m\033[47m",
					 "blueBYellow": "\033[34m\033[43m",
					 "boldBlack": "\033[1;30m",
					 "boldBlackBBlack": "\033[1;30m\033[40m",
					 "boldBlackBBlue": "\033[1;30m\033[44m",
					 "boldBlackBCyan": "\033[1;30m\033[46m",
					 "boldBlackBGreen": "\033[1;30m\033[42m",
					 "boldBlackBHighBlack": "\033[1;30m\033[100m",
					 "boldBlackBHighBlue": "\033[1;30m\033[104m",
					 "boldBlackBHighCyan": "\033[1;30m\033[106m",
					 "boldBlackBHighGreen": "\033[1;30m\033[102m",
					 "boldBlackBHighPurple": "\033[1;30m\033[105m",
					 "boldBlackBHighRed": "\033[1;30m\033[101m",
					 "boldBlackBHighWhite": "\033[1;30m\033[107m",
					 "boldBlackBHighYellow": "\033[1;30m\033[103m",
					 "boldBlackBPurple": "\033[1;30m\033[45m",
					 "boldBlackBRed": "\033[1;30m\033[41m",
					 "boldBlackBWhite": "\033[1;30m\033[47m",
					 "boldBlackBYellow": "\033[1;30m\033[43m",
					 "boldBlue": "\033[1;34m",
					 "boldBlueBBlack": "\033[1;34m\033[40m",
					 "boldBlueBBlue": "\033[1;34m\033[44m",
					 "boldBlueBCyan": "\033[1;34m\033[46m",
					 "boldBlueBGreen": "\033[1;34m\033[42m",
					 "boldBlueBHighBlack": "\033[1;34m\033[100m",
					 "boldBlueBHighBlue": "\033[1;34m\033[104m",
					 "boldBlueBHighCyan": "\033[1;34m\033[106m",
					 "boldBlueBHighGreen": "\033[1;34m\033[102m",
					 "boldBlueBHighPurple": "\033[1;34m\033[105m",
					 "boldBlueBHighRed": "\033[1;34m\033[101m",
					 "boldBlueBHighWhite": "\033[1;34m\033[107m",
					 "boldBlueBHighYellow": "\033[1;34m\033[103m",
					 "boldBlueBPurple": "\033[1;34m\033[45m",
					 "boldBlueBRed": "\033[1;34m\033[41m",
					 "boldBlueBWhite": "\033[1;34m\033[47m",
					 "boldBlueBYellow": "\033[1;34m\033[43m",
					 "boldCyan": "\033[1;36m",
					 "boldCyanBBlack": "\033[1;36m\033[40m",
					 "boldCyanBBlue": "\033[1;36m\033[44m",
					 "boldCyanBCyan": "\033[1;36m\033[46m",
					 "boldCyanBGreen": "\033[1;36m\033[42m",
					 "boldCyanBHighBlack": "\033[1;36m\033[100m",
					 "boldCyanBHighBlue": "\033[1;36m\033[104m",
					 "boldCyanBHighCyan": "\033[1;36m\033[106m",
					 "boldCyanBHighGreen": "\033[1;36m\033[102m",
					 "boldCyanBHighPurple": "\033[1;36m\033[105m",
					 "boldCyanBHighRed": "\033[1;36m\033[101m",
					 "boldCyanBHighWhite": "\033[1;36m\033[107m",
					 "boldCyanBHighYellow": "\033[1;36m\033[103m",
					 "boldCyanBPurple": "\033[1;36m\033[45m",
					 "boldCyanBRed": "\033[1;36m\033[41m",
					 "boldCyanBWhite": "\033[1;36m\033[47m",
					 "boldCyanBYellow": "\033[1;36m\033[43m",
					 "boldGreen": "\033[1;32m",
					 "boldGreenBBlack": "\033[1;32m\033[40m",
					 "boldGreenBBlue": "\033[1;32m\033[44m",
					 "boldGreenBCyan": "\033[1;32m\033[46m",
					 "boldGreenBGreen": "\033[1;32m\033[42m",
					 "boldGreenBHighBlack": "\033[1;32m\033[100m",
					 "boldGreenBHighBlue": "\033[1;32m\033[104m",
					 "boldGreenBHighCyan": "\033[1;32m\033[106m",
					 "boldGreenBHighGreen": "\033[1;32m\033[102m",
					 "boldGreenBHighPurple": "\033[1;32m\033[105m",
					 "boldGreenBHighRed": "\033[1;32m\033[101m",
					 "boldGreenBHighWhite": "\033[1;32m\033[107m",
					 "boldGreenBHighYellow": "\033[1;32m\033[103m",
					 "boldGreenBPurple": "\033[1;32m\033[45m",
					 "boldGreenBRed": "\033[1;32m\033[41m",
					 "boldGreenBWhite": "\033[1;32m\033[47m",
					 "boldGreenBYellow": "\033[1;32m\033[43m",
					 "boldPurple": "\033[1;35m",
					 "boldPurpleBBlack": "\033[1;35m\033[40m",
					 "boldPurpleBBlue": "\033[1;35m\033[44m",
					 "boldPurpleBCyan": "\033[1;35m\033[46m",
					 "boldPurpleBGreen": "\033[1;35m\033[42m",
					 "boldPurpleBHighBlack": "\033[1;35m\033[100m",
					 "boldPurpleBHighBlue": "\033[1;35m\033[104m",
					 "boldPurpleBHighCyan": "\033[1;35m\033[106m",
					 "boldPurpleBHighGreen": "\033[1;35m\033[102m",
					 "boldPurpleBHighPurple": "\033[1;35m\033[105m",
					 "boldPurpleBHighRed": "\033[1;35m\033[101m",
					 "boldPurpleBHighWhite": "\033[1;35m\033[107m",
					 "boldPurpleBHighYellow": "\033[1;35m\033[103m",
					 "boldPurpleBPurple": "\033[1;35m\033[45m",
					 "boldPurpleBRed": "\033[1;35m\033[41m",
					 "boldPurpleBWhite": "\033[1;35m\033[47m",
					 "boldPurpleBYellow": "\033[1;35m\033[43m",
					 "boldRed": "\033[1;31m",
					 "boldRedBBlack": "\033[1;31m\033[40m",
					 "boldRedBBlue": "\033[1;31m\033[44m",
					 "boldRedBCyan": "\033[1;31m\033[46m",
					 "boldRedBGreen": "\033[1;31m\033[42m",
					 "boldRedBHighBlack": "\033[1;31m\033[100m",
					 "boldRedBHighBlue": "\033[1;31m\033[104m",
					 "boldRedBHighCyan": "\033[1;31m\033[106m",
					 "boldRedBHighGreen": "\033[1;31m\033[102m",
					 "boldRedBHighPurple": "\033[1;31m\033[105m",
					 "boldRedBHighRed": "\033[1;31m\033[101m",
					 "boldRedBHighWhite": "\033[1;31m\033[107m",
					 "boldRedBHighYellow": "\033[1;31m\033[103m",
					 "boldRedBPurple": "\033[1;31m\033[45m",
					 "boldRedBRed": "\033[1;31m\033[41m",
					 "boldRedBWhite": "\033[1;31m\033[47m",
					 "boldRedBYellow": "\033[1;31m\033[43m",
					 "boldWhite": "\033[1;37m",
					 "boldWhiteBBlack": "\033[1;37m\033[40m",
					 "boldWhiteBBlue": "\033[1;37m\033[44m",
					 "boldWhiteBCyan": "\033[1;37m\033[46m",
					 "boldWhiteBGreen": "\033[1;37m\033[42m",
					 "boldWhiteBHighBlack": "\033[1;37m\033[100m",
					 "boldWhiteBHighBlue": "\033[1;37m\033[104m",
					 "boldWhiteBHighCyan": "\033[1;37m\033[106m",
					 "boldWhiteBHighGreen": "\033[1;37m\033[102m",
					 "boldWhiteBHighPurple": "\033[1;37m\033[105m",
					 "boldWhiteBHighRed": "\033[1;37m\033[101m",
					 "boldWhiteBHighWhite": "\033[1;37m\033[107m",
					 "boldWhiteBHighYellow": "\033[1;37m\033[103m",
					 "boldWhiteBPurple": "\033[1;37m\033[45m",
					 "boldWhiteBRed": "\033[1;37m\033[41m",
					 "boldWhiteBWhite": "\033[1;37m\033[47m",
					 "boldWhiteBYellow": "\033[1;37m\033[43m",
					 "boldYellow": "\033[1;33m",
					 "boldYellowBBlack": "\033[1;33m\033[40m",
					 "boldYellowBBlue": "\033[1;33m\033[44m",
					 "boldYellowBCyan": "\033[1;33m\033[46m",
					 "boldYellowBGreen": "\033[1;33m\033[42m",
					 "boldYellowBHighBlack": "\033[1;33m\033[100m",
					 "boldYellowBHighBlue": "\033[1;33m\033[104m",
					 "boldYellowBHighCyan": "\033[1;33m\033[106m",
					 "boldYellowBHighGreen": "\033[1;33m\033[102m",
					 "boldYellowBHighPurple": "\033[1;33m\033[105m",
					 "boldYellowBHighRed": "\033[1;33m\033[101m",
					 "boldYellowBHighWhite": "\033[1;33m\033[107m",
					 "boldYellowBHighYellow": "\033[1;33m\033[103m",
					 "boldYellowBPurple": "\033[1;33m\033[45m",
					 "boldYellowBRed": "\033[1;33m\033[41m",
					 "boldYellowBWhite": "\033[1;33m\033[47m",
					 "boldYellowBYellow": "\033[1;33m\033[43m",
					 "cyan": "\033[36m",
					 "cyanBBlack": "\033[36m\033[40m",
					 "cyanBBlue": "\033[36m\033[44m",
					 "cyanBCyan": "\033[36m\033[46m",
					 "cyanBGreen": "\033[36m\033[42m",
					 "cyanBHighBlack": "\033[36m\033[100m",
					 "cyanBHighBlue": "\033[36m\033[104m",
					 "cyanBHighCyan": "\033[36m\033[106m",
					 "cyanBHighGreen": "\033[36m\033[102m",
					 "cyanBHighPurple": "\033[36m\033[105m",
					 "cyanBHighRed": "\033[36m\033[101m",
					 "cyanBHighWhite": "\033[36m\033[107m",
					 "cyanBHighYellow": "\033[36m\033[103m",
					 "cyanBPurple": "\033[36m\033[45m",
					 "cyanBRed": "\033[36m\033[41m",
					 "cyanBWhite": "\033[36m\033[47m",
					 "cyanBYellow": "\033[36m\033[43m",
					 "green": "\033[32m",
					 "greenBBlack": "\033[32m\033[40m",
					 "greenBBlue": "\033[32m\033[44m",
					 "greenBCyan": "\033[32m\033[46m",
					 "greenBGreen": "\033[32m\033[42m",
					 "greenBHighBlack": "\033[32m\033[100m",
					 "greenBHighBlue": "\033[32m\033[104m",
					 "greenBHighCyan": "\033[32m\033[106m",
					 "greenBHighGreen": "\033[32m\033[102m",
					 "greenBHighPurple": "\033[32m\033[105m",
					 "greenBHighRed": "\033[32m\033[101m",
					 "greenBHighWhite": "\033[32m\033[107m",
					 "greenBHighYellow": "\033[32m\033[103m",
					 "greenBPurple": "\033[32m\033[45m",
					 "greenBRed": "\033[32m\033[41m",
					 "greenBWhite": "\033[32m\033[47m",
					 "greenBYellow": "\033[32m\033[43m",
					 "highBlack": "\033[0;90m",
					 "highBlackBBlack": "\033[0;90m\033[40m",
					 "highBlackBBlue": "\033[0;90m\033[44m",
					 "highBlackBCyan": "\033[0;90m\033[46m",
					 "highBlackBGreen": "\033[0;90m\033[42m",
					 "highBlackBHighBlack": "\033[0;90m\033[100m",
					 "highBlackBHighBlue": "\033[0;90m\033[104m",
					 "highBlackBHighCyan": "\033[0;90m\033[106m",
					 "highBlackBHighGreen": "\033[0;90m\033[102m",
					 "highBlackBHighPurple": "\033[0;90m\033[105m",
					 "highBlackBHighRed": "\033[0;90m\033[101m",
					 "highBlackBHighWhite": "\033[0;90m\033[107m",
					 "highBlackBHighYellow": "\033[0;90m\033[103m",
					 "highBlackBPurple": "\033[0;90m\033[45m",
					 "highBlackBRed": "\033[0;90m\033[41m",
					 "highBlackBWhite": "\033[0;90m\033[47m",
					 "highBlackBYellow": "\033[0;90m\033[43m",
					 "highBlue": "\033[0;94m",
					 "highBlueBBlack": "\033[0;94m\033[40m",
					 "highBlueBBlue": "\033[0;94m\033[44m",
					 "highBlueBCyan": "\033[0;94m\033[46m",
					 "highBlueBGreen": "\033[0;94m\033[42m",
					 "highBlueBHighBlack": "\033[0;94m\033[100m",
					 "highBlueBHighBlue": "\033[0;94m\033[104m",
					 "highBlueBHighCyan": "\033[0;94m\033[106m",
					 "highBlueBHighGreen": "\033[0;94m\033[102m",
					 "highBlueBHighPurple": "\033[0;94m\033[105m",
					 "highBlueBHighRed": "\033[0;94m\033[101m",
					 "highBlueBHighWhite": "\033[0;94m\033[107m",
					 "highBlueBHighYellow": "\033[0;94m\033[103m",
					 "highBlueBPurple": "\033[0;94m\033[45m",
					 "highBlueBRed": "\033[0;94m\033[41m",
					 "highBlueBWhite": "\033[0;94m\033[47m",
					 "highBlueBYellow": "\033[0;94m\033[43m",
					 "highBoldBlack": "\033[1;90m",
					 "highBoldBlackBBlack": "\033[1;90m\033[40m",
					 "highBoldBlackBBlue": "\033[1;90m\033[44m",
					 "highBoldBlackBCyan": "\033[1;90m\033[46m",
					 "highBoldBlackBGreen": "\033[1;90m\033[42m",
					 "highBoldBlackBHighBlack": "\033[1;90m\033[100m",
					 "highBoldBlackBHighBlue": "\033[1;90m\033[104m",
					 "highBoldBlackBHighCyan": "\033[1;90m\033[106m",
					 "highBoldBlackBHighGreen": "\033[1;90m\033[102m",
					 "highBoldBlackBHighPurple": "\033[1;90m\033[105m",
					 "highBoldBlackBHighRed": "\033[1;90m\033[101m",
					 "highBoldBlackBHighWhite": "\033[1;90m\033[107m",
					 "highBoldBlackBHighYellow": "\033[1;90m\033[103m",
					 "highBoldBlackBPurple": "\033[1;90m\033[45m",
					 "highBoldBlackBRed": "\033[1;90m\033[41m",
					 "highBoldBlackBWhite": "\033[1;90m\033[47m",
					 "highBoldBlackBYellow": "\033[1;90m\033[43m",
					 "highBoldBlue": "\033[1;94m",
					 "highBoldBlueBBlack": "\033[1;94m\033[40m",
					 "highBoldBlueBBlue": "\033[1;94m\033[44m",
					 "highBoldBlueBCyan": "\033[1;94m\033[46m",
					 "highBoldBlueBGreen": "\033[1;94m\033[42m",
					 "highBoldBlueBHighBlack": "\033[1;94m\033[100m",
					 "highBoldBlueBHighBlue": "\033[1;94m\033[104m",
					 "highBoldBlueBHighCyan": "\033[1;94m\033[106m",
					 "highBoldBlueBHighGreen": "\033[1;94m\033[102m",
					 "highBoldBlueBHighPurple": "\033[1;94m\033[105m",
					 "highBoldBlueBHighRed": "\033[1;94m\033[101m",
					 "highBoldBlueBHighWhite": "\033[1;94m\033[107m",
					 "highBoldBlueBHighYellow": "\033[1;94m\033[103m",
					 "highBoldBlueBPurple": "\033[1;94m\033[45m",
					 "highBoldBlueBRed": "\033[1;94m\033[41m",
					 "highBoldBlueBWhite": "\033[1;94m\033[47m",
					 "highBoldBlueBYellow": "\033[1;94m\033[43m",
					 "highBoldCyan": "\033[1;96m",
					 "highBoldCyanBBlack": "\033[1;96m\033[40m",
					 "highBoldCyanBBlue": "\033[1;96m\033[44m",
					 "highBoldCyanBCyan": "\033[1;96m\033[46m",
					 "highBoldCyanBGreen": "\033[1;96m\033[42m",
					 "highBoldCyanBHighBlack": "\033[1;96m\033[100m",
					 "highBoldCyanBHighBlue": "\033[1;96m\033[104m",
					 "highBoldCyanBHighCyan": "\033[1;96m\033[106m",
					 "highBoldCyanBHighGreen": "\033[1;96m\033[102m",
					 "highBoldCyanBHighPurple": "\033[1;96m\033[105m",
					 "highBoldCyanBHighRed": "\033[1;96m\033[101m",
					 "highBoldCyanBHighWhite": "\033[1;96m\033[107m",
					 "highBoldCyanBHighYellow": "\033[1;96m\033[103m",
					 "highBoldCyanBPurple": "\033[1;96m\033[45m",
					 "highBoldCyanBRed": "\033[1;96m\033[41m",
					 "highBoldCyanBWhite": "\033[1;96m\033[47m",
					 "highBoldCyanBYellow": "\033[1;96m\033[43m",
					 "highBoldGreen": "\033[1;92m",
					 "highBoldGreenBBlack": "\033[1;92m\033[40m",
					 "highBoldGreenBBlue": "\033[1;92m\033[44m",
					 "highBoldGreenBCyan": "\033[1;92m\033[46m",
					 "highBoldGreenBGreen": "\033[1;92m\033[42m",
					 "highBoldGreenBHighBlack": "\033[1;92m\033[100m",
					 "highBoldGreenBHighBlue": "\033[1;92m\033[104m",
					 "highBoldGreenBHighCyan": "\033[1;92m\033[106m",
					 "highBoldGreenBHighGreen": "\033[1;92m\033[102m",
					 "highBoldGreenBHighPurple": "\033[1;92m\033[105m",
					 "highBoldGreenBHighRed": "\033[1;92m\033[101m",
					 "highBoldGreenBHighWhite": "\033[1;92m\033[107m",
					 "highBoldGreenBHighYellow": "\033[1;92m\033[103m",
					 "highBoldGreenBPurple": "\033[1;92m\033[45m",
					 "highBoldGreenBRed": "\033[1;92m\033[41m",
					 "highBoldGreenBWhite": "\033[1;92m\033[47m",
					 "highBoldGreenBYellow": "\033[1;92m\033[43m",
					 "highBoldPurple": "\033[1;95m",
					 "highBoldPurpleBBlack": "\033[1;95m\033[40m",
					 "highBoldPurpleBBlue": "\033[1;95m\033[44m",
					 "highBoldPurpleBCyan": "\033[1;95m\033[46m",
					 "highBoldPurpleBGreen": "\033[1;95m\033[42m",
					 "highBoldPurpleBHighBlack": "\033[1;95m\033[100m",
					 "highBoldPurpleBHighBlue": "\033[1;95m\033[104m",
					 "highBoldPurpleBHighCyan": "\033[1;95m\033[106m",
					 "highBoldPurpleBHighGreen": "\033[1;95m\033[102m",
					 "highBoldPurpleBHighPurple": "\033[1;95m\033[105m",
					 "highBoldPurpleBHighRed": "\033[1;95m\033[101m",
					 "highBoldPurpleBHighWhite": "\033[1;95m\033[107m",
					 "highBoldPurpleBHighYellow": "\033[1;95m\033[103m",
					 "highBoldPurpleBPurple": "\033[1;95m\033[45m",
					 "highBoldPurpleBRed": "\033[1;95m\033[41m",
					 "highBoldPurpleBWhite": "\033[1;95m\033[47m",
					 "highBoldPurpleBYellow": "\033[1;95m\033[43m",
					 "highBoldRed": "\033[1;91m",
					 "highBoldRedBBlack": "\033[1;91m\033[40m",
					 "highBoldRedBBlue": "\033[1;91m\033[44m",
					 "highBoldRedBCyan": "\033[1;91m\033[46m",
					 "highBoldRedBGreen": "\033[1;91m\033[42m",
					 "highBoldRedBHighBlack": "\033[1;91m\033[100m",
					 "highBoldRedBHighBlue": "\033[1;91m\033[104m",
					 "highBoldRedBHighCyan": "\033[1;91m\033[106m",
					 "highBoldRedBHighGreen": "\033[1;91m\033[102m",
					 "highBoldRedBHighPurple": "\033[1;91m\033[105m",
					 "highBoldRedBHighRed": "\033[1;91m\033[101m",
					 "highBoldRedBHighWhite": "\033[1;91m\033[107m",
					 "highBoldRedBHighYellow": "\033[1;91m\033[103m",
					 "highBoldRedBPurple": "\033[1;91m\033[45m",
					 "highBoldRedBRed": "\033[1;91m\033[41m",
					 "highBoldRedBWhite": "\033[1;91m\033[47m",
					 "highBoldRedBYellow": "\033[1;91m\033[43m",
					 "highBoldWhite": "\033[1;97m",
					 "highBoldWhiteBBlack": "\033[1;97m\033[40m",
					 "highBoldWhiteBBlue": "\033[1;97m\033[44m",
					 "highBoldWhiteBCyan": "\033[1;97m\033[46m",
					 "highBoldWhiteBGreen": "\033[1;97m\033[42m",
					 "highBoldWhiteBHighBlack": "\033[1;97m\033[100m",
					 "highBoldWhiteBHighBlue": "\033[1;97m\033[104m",
					 "highBoldWhiteBHighCyan": "\033[1;97m\033[106m",
					 "highBoldWhiteBHighGreen": "\033[1;97m\033[102m",
					 "highBoldWhiteBHighPurple": "\033[1;97m\033[105m",
					 "highBoldWhiteBHighRed": "\033[1;97m\033[101m",
					 "highBoldWhiteBHighWhite": "\033[1;97m\033[107m",
					 "highBoldWhiteBHighYellow": "\033[1;97m\033[103m",
					 "highBoldWhiteBPurple": "\033[1;97m\033[45m",
					 "highBoldWhiteBRed": "\033[1;97m\033[41m",
					 "highBoldWhiteBWhite": "\033[1;97m\033[47m",
					 "highBoldWhiteBYellow": "\033[1;97m\033[43m",
					 "highBoldYellow": "\033[1;93m",
					 "highBoldYellowBBlack": "\033[1;93m\033[40m",
					 "highBoldYellowBBlue": "\033[1;93m\033[44m",
					 "highBoldYellowBCyan": "\033[1;93m\033[46m",
					 "highBoldYellowBGreen": "\033[1;93m\033[42m",
					 "highBoldYellowBHighBlack": "\033[1;93m\033[100m",
					 "highBoldYellowBHighBlue": "\033[1;93m\033[104m",
					 "highBoldYellowBHighCyan": "\033[1;93m\033[106m",
					 "highBoldYellowBHighGreen": "\033[1;93m\033[102m",
					 "highBoldYellowBHighPurple": "\033[1;93m\033[105m",
					 "highBoldYellowBHighRed": "\033[1;93m\033[101m",
					 "highBoldYellowBHighWhite": "\033[1;93m\033[107m",
					 "highBoldYellowBHighYellow": "\033[1;93m\033[103m",
					 "highBoldYellowBPurple": "\033[1;93m\033[45m",
					 "highBoldYellowBRed": "\033[1;93m\033[41m",
					 "highBoldYellowBWhite": "\033[1;93m\033[47m",
					 "highBoldYellowBYellow": "\033[1;93m\033[43m",
					 "highCyan": "\033[0;96m",
					 "highCyanBBlack": "\033[0;96m\033[40m",
					 "highCyanBBlue": "\033[0;96m\033[44m",
					 "highCyanBCyan": "\033[0;96m\033[46m",
					 "highCyanBGreen": "\033[0;96m\033[42m",
					 "highCyanBHighBlack": "\033[0;96m\033[100m",
					 "highCyanBHighBlue": "\033[0;96m\033[104m",
					 "highCyanBHighCyan": "\033[0;96m\033[106m",
					 "highCyanBHighGreen": "\033[0;96m\033[102m",
					 "highCyanBHighPurple": "\033[0;96m\033[105m",
					 "highCyanBHighRed": "\033[0;96m\033[101m",
					 "highCyanBHighWhite": "\033[0;96m\033[107m",
					 "highCyanBHighYellow": "\033[0;96m\033[103m",
					 "highCyanBPurple": "\033[0;96m\033[45m",
					 "highCyanBRed": "\033[0;96m\033[41m",
					 "highCyanBWhite": "\033[0;96m\033[47m",
					 "highCyanBYellow": "\033[0;96m\033[43m",
					 "highGreen": "\033[0;92m",
					 "highGreenBBlack": "\033[0;92m\033[40m",
					 "highGreenBBlue": "\033[0;92m\033[44m",
					 "highGreenBCyan": "\033[0;92m\033[46m",
					 "highGreenBGreen": "\033[0;92m\033[42m",
					 "highGreenBHighBlack": "\033[0;92m\033[100m",
					 "highGreenBHighBlue": "\033[0;92m\033[104m",
					 "highGreenBHighCyan": "\033[0;92m\033[106m",
					 "highGreenBHighGreen": "\033[0;92m\033[102m",
					 "highGreenBHighPurple": "\033[0;92m\033[105m",
					 "highGreenBHighRed": "\033[0;92m\033[101m",
					 "highGreenBHighWhite": "\033[0;92m\033[107m",
					 "highGreenBHighYellow": "\033[0;92m\033[103m",
					 "highGreenBPurple": "\033[0;92m\033[45m",
					 "highGreenBRed": "\033[0;92m\033[41m",
					 "highGreenBWhite": "\033[0;92m\033[47m",
					 "highGreenBYellow": "\033[0;92m\033[43m",
					 "highPurple": "\033[0;95m",
					 "highPurpleBBlack": "\033[0;95m\033[40m",
					 "highPurpleBBlue": "\033[0;95m\033[44m",
					 "highPurpleBCyan": "\033[0;95m\033[46m",
					 "highPurpleBGreen": "\033[0;95m\033[42m",
					 "highPurpleBHighBlack": "\033[0;95m\033[100m",
					 "highPurpleBHighBlue": "\033[0;95m\033[104m",
					 "highPurpleBHighCyan": "\033[0;95m\033[106m",
					 "highPurpleBHighGreen": "\033[0;95m\033[102m",
					 "highPurpleBHighPurple": "\033[0;95m\033[105m",
					 "highPurpleBHighRed": "\033[0;95m\033[101m",
					 "highPurpleBHighWhite": "\033[0;95m\033[107m",
					 "highPurpleBHighYellow": "\033[0;95m\033[103m",
					 "highPurpleBPurple": "\033[0;95m\033[45m",
					 "highPurpleBRed": "\033[0;95m\033[41m",
					 "highPurpleBWhite": "\033[0;95m\033[47m",
					 "highPurpleBYellow": "\033[0;95m\033[43m",
					 "highRed": "\033[0;91m",
					 "highRedBBlack": "\033[0;91m\033[40m",
					 "highRedBBlue": "\033[0;91m\033[44m",
					 "highRedBCyan": "\033[0;91m\033[46m",
					 "highRedBGreen": "\033[0;91m\033[42m",
					 "highRedBHighBlack": "\033[0;91m\033[100m",
					 "highRedBHighBlue": "\033[0;91m\033[104m",
					 "highRedBHighCyan": "\033[0;91m\033[106m",
					 "highRedBHighGreen": "\033[0;91m\033[102m",
					 "highRedBHighPurple": "\033[0;91m\033[105m",
					 "highRedBHighRed": "\033[0;91m\033[101m",
					 "highRedBHighWhite": "\033[0;91m\033[107m",
					 "highRedBHighYellow": "\033[0;91m\033[103m",
					 "highRedBPurple": "\033[0;91m\033[45m",
					 "highRedBRed": "\033[0;91m\033[41m",
					 "highRedBWhite": "\033[0;91m\033[47m",
					 "highRedBYellow": "\033[0;91m\033[43m",
					 "highWhite": "\033[0;97m",
					 "highWhiteBBlack": "\033[0;97m\033[40m",
					 "highWhiteBBlue": "\033[0;97m\033[44m",
					 "highWhiteBCyan": "\033[0;97m\033[46m",
					 "highWhiteBGreen": "\033[0;97m\033[42m",
					 "highWhiteBHighBlack": "\033[0;97m\033[100m",
					 "highWhiteBHighBlue": "\033[0;97m\033[104m",
					 "highWhiteBHighCyan": "\033[0;97m\033[106m",
					 "highWhiteBHighGreen": "\033[0;97m\033[102m",
					 "highWhiteBHighPurple": "\033[0;97m\033[105m",
					 "highWhiteBHighRed": "\033[0;97m\033[101m",
					 "highWhiteBHighWhite": "\033[0;97m\033[107m",
					 "highWhiteBHighYellow": "\033[0;97m\033[103m",
					 "highWhiteBPurple": "\033[0;97m\033[45m",
					 "highWhiteBRed": "\033[0;97m\033[41m",
					 "highWhiteBWhite": "\033[0;97m\033[47m",
					 "highWhiteBYellow": "\033[0;97m\033[43m",
					 "highYellow": "\033[0;93m",
					 "highYellowBBlack": "\033[0;93m\033[40m",
					 "highYellowBBlue": "\033[0;93m\033[44m",
					 "highYellowBCyan": "\033[0;93m\033[46m",
					 "highYellowBGreen": "\033[0;93m\033[42m",
					 "highYellowBHighBlack": "\033[0;93m\033[100m",
					 "highYellowBHighBlue": "\033[0;93m\033[104m",
					 "highYellowBHighCyan": "\033[0;93m\033[106m",
					 "highYellowBHighGreen": "\033[0;93m\033[102m",
					 "highYellowBHighPurple": "\033[0;93m\033[105m",
					 "highYellowBHighRed": "\033[0;93m\033[101m",
					 "highYellowBHighWhite": "\033[0;93m\033[107m",
					 "highYellowBHighYellow": "\033[0;93m\033[103m",
					 "highYellowBPurple": "\033[0;93m\033[45m",
					 "highYellowBRed": "\033[0;93m\033[41m",
					 "highYellowBWhite": "\033[0;93m\033[47m",
					 "highYellowBYellow": "\033[0;93m\033[43m",
					 "purple": "\033[35m",
					 "purpleBBlack": "\033[35m\033[40m",
					 "purpleBBlue": "\033[35m\033[44m",
					 "purpleBCyan": "\033[35m\033[46m",
					 "purpleBGreen": "\033[35m\033[42m",
					 "purpleBHighBlack": "\033[35m\033[100m",
					 "purpleBHighBlue": "\033[35m\033[104m",
					 "purpleBHighCyan": "\033[35m\033[106m",
					 "purpleBHighGreen": "\033[35m\033[102m",
					 "purpleBHighPurple": "\033[35m\033[105m",
					 "purpleBHighRed": "\033[35m\033[101m",
					 "purpleBHighWhite": "\033[35m\033[107m",
					 "purpleBHighYellow": "\033[35m\033[103m",
					 "purpleBPurple": "\033[35m\033[45m",
					 "purpleBRed": "\033[35m\033[41m",
					 "purpleBWhite": "\033[35m\033[47m",
					 "purpleBYellow": "\033[35m\033[43m",
					 "red": "\033[31m",
					 "redBBlack": "\033[31m\033[40m",
					 "redBBlue": "\033[31m\033[44m",
					 "redBCyan": "\033[31m\033[46m",
					 "redBGreen": "\033[31m\033[42m",
					 "redBHighBlack": "\033[31m\033[100m",
					 "redBHighBlue": "\033[31m\033[104m",
					 "redBHighCyan": "\033[31m\033[106m",
					 "redBHighGreen": "\033[31m\033[102m",
					 "redBHighPurple": "\033[31m\033[105m",
					 "redBHighRed": "\033[31m\033[101m",
					 "redBHighWhite": "\033[31m\033[107m",
					 "redBHighYellow": "\033[31m\033[103m",
					 "redBPurple": "\033[31m\033[45m",
					 "redBRed": "\033[31m\033[41m",
					 "redBWhite": "\033[31m\033[47m",
					 "redBYellow": "\033[31m\033[43m",
					 "reset": "\033[0m",
					 "underlineBlack": "\033[4;30m",
					 "underlineBlackBBlack": "\033[4;30m\033[40m",
					 "underlineBlackBBlue": "\033[4;30m\033[44m",
					 "underlineBlackBCyan": "\033[4;30m\033[46m",
					 "underlineBlackBGreen": "\033[4;30m\033[42m",
					 "underlineBlackBHighBlack": "\033[4;30m\033[100m",
					 "underlineBlackBHighBlue": "\033[4;30m\033[104m",
					 "underlineBlackBHighCyan": "\033[4;30m\033[106m",
					 "underlineBlackBHighGreen": "\033[4;30m\033[102m",
					 "underlineBlackBHighPurple": "\033[4;30m\033[105m",
					 "underlineBlackBHighRed": "\033[4;30m\033[101m",
					 "underlineBlackBHighWhite": "\033[4;30m\033[107m",
					 "underlineBlackBHighYellow": "\033[4;30m\033[103m",
					 "underlineBlackBPurple": "\033[4;30m\033[45m",
					 "underlineBlackBRed": "\033[4;30m\033[41m",
					 "underlineBlackBWhite": "\033[4;30m\033[47m",
					 "underlineBlackBYellow": "\033[4;30m\033[43m",
					 "underlineBlue": "\033[4;34m",
					 "underlineBlueBBlack": "\033[4;34m\033[40m",
					 "underlineBlueBBlue": "\033[4;34m\033[44m",
					 "underlineBlueBCyan": "\033[4;34m\033[46m",
					 "underlineBlueBGreen": "\033[4;34m\033[42m",
					 "underlineBlueBHighBlack": "\033[4;34m\033[100m",
					 "underlineBlueBHighBlue": "\033[4;34m\033[104m",
					 "underlineBlueBHighCyan": "\033[4;34m\033[106m",
					 "underlineBlueBHighGreen": "\033[4;34m\033[102m",
					 "underlineBlueBHighPurple": "\033[4;34m\033[105m",
					 "underlineBlueBHighRed": "\033[4;34m\033[101m",
					 "underlineBlueBHighWhite": "\033[4;34m\033[107m",
					 "underlineBlueBHighYellow": "\033[4;34m\033[103m",
					 "underlineBlueBPurple": "\033[4;34m\033[45m",
					 "underlineBlueBRed": "\033[4;34m\033[41m",
					 "underlineBlueBWhite": "\033[4;34m\033[47m",
					 "underlineBlueBYellow": "\033[4;34m\033[43m",
					 "underlineCyan": "\033[4;36m",
					 "underlineCyanBBlack": "\033[4;36m\033[40m",
					 "underlineCyanBBlue": "\033[4;36m\033[44m",
					 "underlineCyanBCyan": "\033[4;36m\033[46m",
					 "underlineCyanBGreen": "\033[4;36m\033[42m",
					 "underlineCyanBHighBlack": "\033[4;36m\033[100m",
					 "underlineCyanBHighBlue": "\033[4;36m\033[104m",
					 "underlineCyanBHighCyan": "\033[4;36m\033[106m",
					 "underlineCyanBHighGreen": "\033[4;36m\033[102m",
					 "underlineCyanBHighPurple": "\033[4;36m\033[105m",
					 "underlineCyanBHighRed": "\033[4;36m\033[101m",
					 "underlineCyanBHighWhite": "\033[4;36m\033[107m",
					 "underlineCyanBHighYellow": "\033[4;36m\033[103m",
					 "underlineCyanBPurple": "\033[4;36m\033[45m",
					 "underlineCyanBRed": "\033[4;36m\033[41m",
					 "underlineCyanBWhite": "\033[4;36m\033[47m",
					 "underlineCyanBYellow": "\033[4;36m\033[43m",
					 "underlineGreen": "\033[4;32m",
					 "underlineGreenBBlack": "\033[4;32m\033[40m",
					 "underlineGreenBBlue": "\033[4;32m\033[44m",
					 "underlineGreenBCyan": "\033[4;32m\033[46m",
					 "underlineGreenBGreen": "\033[4;32m\033[42m",
					 "underlineGreenBHighBlack": "\033[4;32m\033[100m",
					 "underlineGreenBHighBlue": "\033[4;32m\033[104m",
					 "underlineGreenBHighCyan": "\033[4;32m\033[106m",
					 "underlineGreenBHighGreen": "\033[4;32m\033[102m",
					 "underlineGreenBHighPurple": "\033[4;32m\033[105m",
					 "underlineGreenBHighRed": "\033[4;32m\033[101m",
					 "underlineGreenBHighWhite": "\033[4;32m\033[107m",
					 "underlineGreenBHighYellow": "\033[4;32m\033[103m",
					 "underlineGreenBPurple": "\033[4;32m\033[45m",
					 "underlineGreenBRed": "\033[4;32m\033[41m",
					 "underlineGreenBWhite": "\033[4;32m\033[47m",
					 "underlineGreenBYellow": "\033[4;32m\033[43m",
					 "underlinePurple": "\033[4;35m",
					 "underlinePurpleBBlack": "\033[4;35m\033[40m",
					 "underlinePurpleBBlue": "\033[4;35m\033[44m",
					 "underlinePurpleBCyan": "\033[4;35m\033[46m",
					 "underlinePurpleBGreen": "\033[4;35m\033[42m",
					 "underlinePurpleBHighBlack": "\033[4;35m\033[100m",
					 "underlinePurpleBHighBlue": "\033[4;35m\033[104m",
					 "underlinePurpleBHighCyan": "\033[4;35m\033[106m",
					 "underlinePurpleBHighGreen": "\033[4;35m\033[102m",
					 "underlinePurpleBHighPurple": "\033[4;35m\033[105m",
					 "underlinePurpleBHighRed": "\033[4;35m\033[101m",
					 "underlinePurpleBHighWhite": "\033[4;35m\033[107m",
					 "underlinePurpleBHighYellow": "\033[4;35m\033[103m",
					 "underlinePurpleBPurple": "\033[4;35m\033[45m",
					 "underlinePurpleBRed": "\033[4;35m\033[41m",
					 "underlinePurpleBWhite": "\033[4;35m\033[47m",
					 "underlinePurpleBYellow": "\033[4;35m\033[43m",
					 "underlineRed": "\033[4;31m",
					 "underlineRedBBlack": "\033[4;31m\033[40m",
					 "underlineRedBBlue": "\033[4;31m\033[44m",
					 "underlineRedBCyan": "\033[4;31m\033[46m",
					 "underlineRedBGreen": "\033[4;31m\033[42m",
					 "underlineRedBHighBlack": "\033[4;31m\033[100m",
					 "underlineRedBHighBlue": "\033[4;31m\033[104m",
					 "underlineRedBHighCyan": "\033[4;31m\033[106m",
					 "underlineRedBHighGreen": "\033[4;31m\033[102m",
					 "underlineRedBHighPurple": "\033[4;31m\033[105m",
					 "underlineRedBHighRed": "\033[4;31m\033[101m",
					 "underlineRedBHighWhite": "\033[4;31m\033[107m",
					 "underlineRedBHighYellow": "\033[4;31m\033[103m",
					 "underlineRedBPurple": "\033[4;31m\033[45m",
					 "underlineRedBRed": "\033[4;31m\033[41m",
					 "underlineRedBWhite": "\033[4;31m\033[47m",
					 "underlineRedBYellow": "\033[4;31m\033[43m",
					 "underlineWhite": "\033[4;37m",
					 "underlineWhiteBBlack": "\033[4;37m\033[40m",
					 "underlineWhiteBBlue": "\033[4;37m\033[44m",
					 "underlineWhiteBCyan": "\033[4;37m\033[46m",
					 "underlineWhiteBGreen": "\033[4;37m\033[42m",
					 "underlineWhiteBHighBlack": "\033[4;37m\033[100m",
					 "underlineWhiteBHighBlue": "\033[4;37m\033[104m",
					 "underlineWhiteBHighCyan": "\033[4;37m\033[106m",
					 "underlineWhiteBHighGreen": "\033[4;37m\033[102m",
					 "underlineWhiteBHighPurple": "\033[4;37m\033[105m",
					 "underlineWhiteBHighRed": "\033[4;37m\033[101m",
					 "underlineWhiteBHighWhite": "\033[4;37m\033[107m",
					 "underlineWhiteBHighYellow": "\033[4;37m\033[103m",
					 "underlineWhiteBPurple": "\033[4;37m\033[45m",
					 "underlineWhiteBRed": "\033[4;37m\033[41m",
					 "underlineWhiteBWhite": "\033[4;37m\033[47m",
					 "underlineWhiteBYellow": "\033[4;37m\033[43m",
					 "underlineYellow": "\033[4;33m",
					 "underlineYellowBBlack": "\033[4;33m\033[40m",
					 "underlineYellowBBlue": "\033[4;33m\033[44m",
					 "underlineYellowBCyan": "\033[4;33m\033[46m",
					 "underlineYellowBGreen": "\033[4;33m\033[42m",
					 "underlineYellowBHighBlack": "\033[4;33m\033[100m",
					 "underlineYellowBHighBlue": "\033[4;33m\033[104m",
					 "underlineYellowBHighCyan": "\033[4;33m\033[106m",
					 "underlineYellowBHighGreen": "\033[4;33m\033[102m",
					 "underlineYellowBHighPurple": "\033[4;33m\033[105m",
					 "underlineYellowBHighRed": "\033[4;33m\033[101m",
					 "underlineYellowBHighWhite": "\033[4;33m\033[107m",
					 "underlineYellowBHighYellow": "\033[4;33m\033[103m",
					 "underlineYellowBPurple": "\033[4;33m\033[45m",
					 "underlineYellowBRed": "\033[4;33m\033[41m",
					 "underlineYellowBWhite": "\033[4;33m\033[47m",
					 "underlineYellowBYellow": "\033[4;33m\033[43m",
					 "white": "\033[37m",
					 "whiteBBlack": "\033[37m\033[40m",
					 "whiteBBlue": "\033[37m\033[44m",
					 "whiteBCyan": "\033[37m\033[46m",
					 "whiteBGreen": "\033[37m\033[42m",
					 "whiteBHighBlack": "\033[37m\033[100m",
					 "whiteBHighBlue": "\033[37m\033[104m",
					 "whiteBHighCyan": "\033[37m\033[106m",
					 "whiteBHighGreen": "\033[37m\033[102m",
					 "whiteBHighPurple": "\033[37m\033[105m",
					 "whiteBHighRed": "\033[37m\033[101m",
					 "whiteBHighWhite": "\033[37m\033[107m",
					 "whiteBHighYellow": "\033[37m\033[103m",
					 "whiteBPurple": "\033[37m\033[45m",
					 "whiteBRed": "\033[37m\033[41m",
					 "whiteBWhite": "\033[37m\033[47m",
					 "whiteBYellow": "\033[37m\033[43m",
					 "yellow": "\033[33m",
					 "yellowBBlack": "\033[33m\033[40m",
					 "yellowBBlue": "\033[33m\033[44m",
					 "yellowBCyan": "\033[33m\033[46m",
					 "yellowBGreen": "\033[33m\033[42m",
					 "yellowBHighBlack": "\033[33m\033[100m",
					 "yellowBHighBlue": "\033[33m\033[104m",
					 "yellowBHighCyan": "\033[33m\033[106m",
					 "yellowBHighGreen": "\033[33m\033[102m",
					 "yellowBHighPurple": "\033[33m\033[105m",
					 "yellowBHighRed": "\033[33m\033[101m",
					 "yellowBHighWhite": "\033[33m\033[107m",
					 "yellowBHighYellow": "\033[33m\033[103m",
					 "yellowBPurple": "\033[33m\033[45m",
					 "yellowBRed": "\033[33m\033[41m",
					 "yellowBWhite": "\033[33m\033[47m",
					 "yellowBYellow": "\033[33m\033[43m"}

#**********************************************************************************************************************
#***	Module classes and definitions.
#**********************************************************************************************************************
class AnsiEscapeCodesTestCase(unittest.TestCase):
	"""
	Defines :class:`foundations.shell.AnsiEscapeCodes` class units tests methods.
	"""

	def testRequiredAttributes(self):
		"""
		Tests presence of required attributes.
		"""

		requiredAttributes = ["reset"]
		requiredAttributes.extend(ANSI_ESCAPE_CODES)

		for attribute in requiredAttributes:
			self.assertIn(attribute, dir(AnsiEscapeCodes))

		for attribute, value in ANSI_ESCAPE_CODES.iteritems():
			self.assertEqual(value, getattr(AnsiEscapeCodes, attribute))

class ColorizeTestCase(unittest.TestCase):
	"""
	Defines :func:`foundations.shell.colorize` definition units tests methods.
	"""

	def testColorize(self):
		"""
		Tests :func:`foundations.shell.colorize` definition.
		"""

		self.assertEqual(foundations.shell.colorize("Hello", "red"), "\x1b[31mHello\x1b[0m")
		self.assertEqual(foundations.shell.colorize("Hello", "bCyan"), "\x1b[46mHello\x1b[0m")
		self.assertEqual(foundations.shell.colorize("Hello", "boldRedBCyan"), "\x1b[1;31m\x1b[46mHello\x1b[0m")

if __name__ == "__main__":
	import foundations.tests.utilities
	unittest.main()
