#!/usr/bin/env python
import os
from setuptools import setup, find_packages

from grunner import __version__

with open(os.path.join(os.path.dirname(__file__), 'README.rst')) as f:
    long_description = f.read()

setup(
    name='GRunner',
    version=__version__,
    author='wei zhuo',
    author_email='zeaphoo@gmail.com',
    license = 'MIT',
    description='Lightweight gevent program runner',
    long_description = long_description,
    packages=find_packages(),
    include_package_data = True,
    zip_safe = False,
    classifiers = [
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: POSIX",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2.6",
        "Programming Language :: Python :: 2.7",
        "Topic :: Software Development :: Libraries :: Python Modules",
        ],
    entry_points={
        'console_scripts': [
            'grunner = grunner.runner:run']},
)