################################################################################
#
#       This file is part of Gato (Graph Animation Toolbox) 
#
#	file:   GatoIcons.py
#
#       NOTE:   Automatically created by mkGatoIcons.pl
#               Do *not* edit this file manually
#
#
#
#       Copyright (C) 1998-2010, Alexander Schliep, Winfried Hochstaettler and 
#       Copyright 1998-2001 ZAIK/ZPR, Universitaet zu Koeln
#                                   
#       Contact: alexander@schliep.org, winfried.hochstaettler@fernuni-hagen.de             
#
#       Information: http://gato.sf.net
#
#       This library is free software; you can redistribute it and/or
#       modify it under the terms of the GNU Library General Public
#       License as published by the Free Software Foundation; either
#       version 2 of the License, or (at your option) any later version.
#
#       This library is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#       Library General Public License for more details.
#
#       You should have received a copy of the GNU Library General Public
#       License along with this library; if not, write to the Free
#       Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#
#
#
################################################################################
black = """
R0lGODdhHgAeAPcAAAAAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABm
MwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/
ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNm
mTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/
zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm
/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kA
AJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZ
M5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wA
ZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZ
mcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8A
zP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z
///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoaGigoKDU1NUNDQ1BQ
UF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx8f///wAAAAEBAQICAgMDAwQEBAUF
BQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxI
sKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

blacknde = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////ywAAAAAGgAYAAMEgPDJSau9eILMJTAfEIBbNxmBCKzsaD5sOKZtianHSoM5yYUs0IOWmt2I
KA1paaOESCxYUbe6qGg9GIgZsDJ1UmrKYKFeP9rVtlpeA8NTkXVKTDPJbfW7dp2LATk5T1FeQDFn
aDcqHyMiUEk/gIdBNCYsOTMobC8wk5ucoKGioxMRADs=
"""

bledge = """
R0lGODdhHgAeAPcAAACZzAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABm
MwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/
ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNm
mTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/
zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm
/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kA
AJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZ
M5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wA
ZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZ
mcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8A
zP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z
///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoaGigoKDU1NUNDQ1BQ
UF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx8f///wAAAAEBAQICAgMDAwQEBAUF
BQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxI
sKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

bluenode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////ywAAAAAGgAYAAMEWPDJSau9eILMJfgg2FHhx5TjEzJse4oZ6M7sx5kzQNuX3PouWAWXo716
up2RN0wWd5um8bSMSpVQ5LKqxeasJOK0xryOyTEx9wYMCtMlVMoTL8/v+LxeEiEAOw==
"""

catbox_splash = """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"""

delete = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAgACAA
BwiTAAMIHEiwoMGDCBMqXMiwocOHECNKNAigosWLFiUCOMCxo8cDFSNu/PhxIwCII0l6NPkwpUqO
I082dPkypcyFNFW6vJkwp86OPBH6JLkT58uSK40eBZpU4VCiTYUuXRn1IMarGEs6ncoUqFKuNhk+
RQpTLFeYZc2eZTnzLEiQDseuDLp1Ld2eWPNO3Mu3r9+/CwMCADs=
"""

delete_1 = """
R0lGODlhGwAbAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAbABsA
AAjUAD0IHEiw4MAVCFcYXMjQQ8KEDSN6CEQx0EOJCytWvIhxoEaNHDF+DARgI0SJFUuS/Hiy4bWX
KlWCRBjx5TUA11ayXGHRJUyYIxEGsqJwoU2cN1/OHLrCilGbP21SFErUqUGoOZFCpcrz6TVWrCxi
/WqFqdWCSjWODctKqNecYANhZVt1ISuoH23S7WoQ7F2lawOxqtv3K9ixL/cGYnjYb+DBTRsKvuv3
71fBRBdHtNK4shXOhFF2Hgyab0fOlD9DPttx4uHSmlsP/Ew7suyCZd3KDggAOw==
"""

delete_2 = """
R0lGODlhGwAbAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAbABsA
AAj/AD0IHEiw4MAvI748MsiwoYdHX75EiDDCoUUPrTK2khhh4UWDGhNpnFjx48CQI1olSjnR40eU
rQCMEMmxpEWNMmPO1Cjxy8VrQAFklCkyYyKSFoFeA3BNZ1GVIyIk8tlQKdOlO41GhWizoNWgQEek
XCmVYiCGSr8qFbsVoRW0aQNdTRv16IizBpWyYhVoRVqgrKxwfZv3WqDDh/9e48tKLF6vSgPtDfSX
sZURhAuyiouYMmDJVlY8Jrh3M1DPaS2vyEx68V7FnwOLbvi6tGLVrAtK3lza9GIrskczBM67txXg
oXM33O06MPLZJj0Q//1c+UXmz4VHP859dfThfaFHAg8IADs=
"""

delete_3 = """
R0lGODlhGwAbAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAbABsA
AAjnAD0IHEiw4MABCAcYXMjQQ8KEDSN6SEQx0UOJCytWvIhxoEaNHDF+TATgC8WQDSuWJGlyI0KJ
12KuXAnyZcOY1wBcY/kRYQSFDHHqzNnS5U+gBoXKjFnzaKCFOJXiPDngqBWoUb8MjeoT4dOkMVu1
0rUiakxWVqxi1cWWrdlrrAKx8oo1pi6xuszGRTvgqkFWUdu6PSvXyoqvBVkpxplXb+EVfhPDXfwW
7mPEiQErBuwYLeSGcjVvxrnXMOaFVhZvVmwlteHIEUNPRuv6cEeBqTW39gy7o+zap2+3Hv75tkEr
gVbYNh4QADs=
"""

dkblnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////ywAAAAAGgAYAAMEefDJSau9eILMJfgg2FGhADCfuY0h4zouKmYgA8N27nzcl7+nl4t3qeVA
NyCx8kkeY7ol6WT47XQxqeaEwwGcMO3D133GbuJxEGfj/mRFd3ItTJOh1/JuxfRh/zJ8fW9sUYJ9
ckJehxYtP1UhLCGTaTSUlSOZmpucGBEAOw==
"""

dkgnnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////ywAAAAAGgAYAAMEhvDJSau9eILMJfgg2FHhZ5TjEyoHa7AhB7rG8BrtuWXf8eYAnEL4wYB+
OkAOWLR8hksFAEptVkwtH0zItZKUQ9Yw6HJ5PeQaDjfVas9orliJhO2u4PW4/L5/62w3S3AqPXVR
PiIXJlQ+XC+EaEEDfGIHkRpHSAJJfkYloCmZoJ6ipqeoqQ8RADs=
"""

edge = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAgACAA
Bwh0AAMIHEiwoMGDCBMqXMiwocOHDAFIBABxIYAEGBNQrHjwYkaMGzkS9PgxpEiBJDOaPJkS5MmC
KSW+hDlx4kyENm8azKlzpMyePlf25Ak0AFGgR4f+LGp0aVGbNZXGHPrR5c2WGnViFcpxK1WVT5My
HUs2YUAAOw==
"""

edge_1 = """
R0lGODlhHgAeAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAeAB4A
AAi3AD0IHEiwoEGBVqyssBLooMOHClldY7Wi4cOLAgMtDMQqkEKLGB1uXLiCVcKQED12XLkCpUgr
rCTG1OjyoEaJ1yYurGnwGoCSOTfyJOgTAACFH4cO9FmRIUOQQ5lCVbr0pxWqPX9Oxcr0KlaiWr+C
3SlWoNSyZq2i9XAWbVeqC8O2HWoFgMyfapUGstpxhVEAWBciJdkSKwCVM+t+PRpzYt+vdXFOPPp1
L9C5cPH63aq0YkXOPAMCADs=
"""

edge_2 = """
R0lGODlhHgAeAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAeAB4A
AAjEAD0IHEiwoEGBVqyssBLooMOHClldY7Wi4cOLAgMtDMQqkEKLGB1uXLiCVcKQED12XLkCpUgr
rCTG1OjyoEaJ1yYurGlwAICSOTfyJPgoghUACj8OHXgtwpcBDBmCHFp0hJWlB5smmopVYNWrXQk2
/cK169ewYiNsRTvwLFsPY8tidctWq9yQC382pMvzqMyfTu9iDPQTpkYAULsuTEqyZVcAKmceDYs0
5sSOjrH6zTkRaVjCQK/pRbvip2nBNStWRI0yIAA7
"""

edge_3 = """
R0lGODlhHgAeAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAeAB4A
AAjCAD0IHEiwoEGBVqyssBLooMOHClldY7Wi4cOLAgMtDMQqkEKLGB1uXLiCVcKQED12XLkCpUgr
rCTG1OjyoEaJ1yYurGlwAICSOTfyJPhlgAAACj8OHdhqgFGGDEEOLTpA6lKmTq1cNUjV6tamA7Ru
JerU61WwYscK7KoWa9i2a8vC9YD26sKfDdkutQJA5s+sVwP9hKkRQNWtC5OSbLkVgMqZfMcijTmx
I+OrfHFORDpWMNBreNWu+Ena7NCKFU3XDAgAOw==
"""

edit = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAAALAAAAAAgACAA
Bwh0AAEIHEiwoMGDCBMqXMgQgUMEDCMCeEgRosSEDglmvHhwo0aLHD8a9BhSIEmTIEuiFKnyY8WU
LVGevPiyZs2GNnPOHKkzJ86eNxcCtflzKMWiRncWTFoRaVKnRqEOlQqUak+rOrH6FMr0oVaiMcOK
HUu2ZEAAOw==
"""

edit_1 = """
R0lGODlhIAAgAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAgACAA
AAj/AD0IHEiwoC5dBRMqXEjwIMOHEB1CnOghkBUrAKwczAigI8WCFq2wYhWI1cGSJTEC+HiR1bWX
MA/ChGlxxcOWM2fKzPky0AqbCUXy1KlrKE2gA4XOBJBzJ0ymM30mdZkTasyiS3lKLWkUqpVrB7++
tJozEACqQ72C1SX2GtmyQ9sy/Rp2LMy2RtuK9VrX7Uu9Rq8B9quRrV/BdwP/XezWoswVahFLNssY
caCUGcMCWGGRsVizHiJbsUh6ReGfVkybZsxqpUC1FhNKJAhZbOuCXlm97thxI2/XGFfcTgig5GuD
CAkC97jQteuGyZUff8gcucLqH6Fnzz57e8To3h92Ew+/cDx52eDPo1fP0Dx7ge4XBgQAOw==
"""

edit_2 = """
R0lGODlhIAAgAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAgACAA
AAj/AHV5GEiwoMGDCAkKTMiwocKFDiMa1AXRYCArVgBk3Aigo0OKFjGyYhWIpMmSGQEwBDlQ5LWX
MGPGvLgiIUWXMnPmDLSi5kRdrHQK1cnToBWKMQEMhal0pk8PVlghZbr0ZVOnHkq+nGr1pRWYX7sS
BRB0q66kXsFSFRpI5k2qYa+FvRpX6NGzc9PKFRu3rsy7e68pDfu1ad+qSOde3LvCsN6wgRybDYRS
I8aMKxYHhqxS8s2LPK307Cm6tF5WKgc6DsTSYeOwqA0alqqro+3btlsCWBH7IICSA1snTJ2SYWoA
woerdujRQ3KEzSU6ryhd4vPqK6ljb3h9+8Hu3n+GC/+ofbx48zbLMwwIADs=
"""

edit_3 = """
R0lGODlhIAAgAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAgACAA
AAj/AD0IHEiwoMGDAnXpQsiw4UCFDiMahNgwkBUrAKyswIgRAICDFA9atMKKVaCSJlN2JBiy4EVW
12LKnDnT4oqEC12SpMmzZ6AVLQXu7EmUZ9ChMgEUTSpT4c+BSJkuvaY0psJrT08SrWpFZteYVa9d
jRkIAMytMb9eUxt2LNmebNd6BdtU11K1X7mmpbv2qlqeeOl+7crV79TBYC3KXVFYF2KsevcGOslx
JIAVFhU+LushshWLk39eXEFao5WxX1l9FKjXYkSFjFOvHsiVVWePuHN7hIhxheqDAE6ybqhw9UqE
q2cjhJjcoUeHIZ9LhJ5zusSg1olXz66d+/Xt3kGCDA8/cTz5h+bP47QeEAA7
"""

gato = """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"""

gato_128 = """
R0lGODlhgACAAOYAAAAAAP///5ycxsjI8MjI762txrW1ztjY5e/v+bW1va2v4c7P7QgQpRggqyEp
rSkxtSkwsTlAt0pQvVpgw2twyXuAz4yP1Zyf272/597f8zE5rTlCtUJKtUpSvUpSrVJatVpjxmNr
xmtzzgAQpQgYpRAhrREgqxgnqyExtSIwsSk3sTNAtzlGt0RQvUpWvVBcw1Vgw1plw2ZwyWt0yXB6
znN7zmtzvXeAz3uEz3uEzoCJ03N7vYSM1oiP1YyU1oyT1YCHw5Sc3pmf26qv4a2y4bu/573B58zP
7c7R7d3f897g8+Di9ODi8+7v+e/w+RgprRgppSAwsic3sic3qzA/uDlKvUJSvXR/zpyj26+15LK4
5L/E6VJjxnWCypyl3qWt3rG56FJjvWt7zra+58jO7XOEzsDI6Ors9b7H58bGxv///wAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5
BAEAAGoALAAAAACAAIAAAAf/gAGCg4SFhoeIiYoBQEBnZwIFBmmUaYuXmJmXHlYbGxqfoaCjoqWk
p6apqKCeVh1hITk+XmMDCZq4uZlVGg8oKA4oT8DCxMPBx8XIxszLzsrEwQ+eHSBiPF4HA5a63d6E
Gw8OUE8l5CXlT+Xn6evp6O7o8Obv6vTy9E/BGlawOUFg0HD7RjDXA3VPSJQgoZChQ4YLH0KUOJFi
RIsNS5hzMK1DrCBfBBYcmanLwYsUU6pcyXIlOlAey/gIOZCkzUMfxl1kQIKnz55AfwoNSnSoUaAO
zaHYYAWELJo3oxrKCWUhzxEMRowgoTVr1q1dsWrlKvYrWa9jw6LF6lAfP6cz/0VKnRugi4OEDMGK
BXs2bV++YQHvJauXK08S+ja8qhG3Jl2bOfF+Nas2bVnLa/tSFmt4LEQoHK3EavxYauSHmP0G5vqX
9Wq9m8FmZZi4KWOopW/aLdcZbeewvznvFf6V+GXWCks40PDqqdzcJE/ndT3beOfr1rNb3nq4Nojb
z6EXzBkxdnHC57UOR6+efXXfCkE/aOrcsXhvdqGgzv5etn/s/REmIF+IOcBUGPXdN1JkCxkX2HDF
RaiehMBddl5yy1UDnn0K5iJdcAHy9592ev3XnYH0kdbhN3Zp1JNqA24XY4kDolWdX/GF9p2KK3bz
4V8iAjjijTRaV+CBCfboo/9OQoI44ZMPSugbhO1hyBxcuCmZy24OUVlhiGAWmVZ1hrWF4o5ZaqkJ
eVbBKJiYcAqZHnC0nbmhmh7etR+FQZJY44isbTQfgjziiUl+DYbpZJRP2ujlcRAZWE2ShmLy4aMS
NimcjH6eyBSa4VWqCJsvAubaqe2lOuaInJKZ46CUiqoIl11i+qSmrbL635Gi3SnrIlQlOuSwjDrK
p6OeaZQhoWn+ipOeeR0LpZ+phqjaYbyCyqGzg7TIEGWohlukteOWOFudn8bKbSE/MurupuVit+qp
gjZX6LqEMKipohZeViyV5yokqbb4HkLrorbOiKuuSLmVYrMFB0AquKZW/GX/nPBi95md90ZM1Z7T
SvnmwvLuqg+sHRe8m7D7mttoyP72m6xyimEZqsfQIpwpYPzOm2qZ6NqWMr4Tu4nqu0SWXHLAtTF7
s8rjgPyvxlT+aTVf9RIccb53sUwin6giKzOkAivm9LbrXiotdTzfWm287Z34lroRe1uquA+y5+TV
Pm/8qa9bC9IuwMPqTW3SnBWIMsQFB7vw2uVWJvKFytZMN9R47V242zv7fK2Zfw+dtgMuUpz324az
zXfivJ4d+CCDT0nu0pzDHah8GorOLaK0/7uzkJK/nJSkrr8ucc7CkQwv5J5zV+fcujtbdMyraxq2
7TmGzji+B5OlPOLb7Yz4/7kn93M50UzGPPnLxhI7NkQ0Txr9r5d+jzHSRQKdLeCB2206w30SF+1A
Z775ySp2GUsgp/BHtVflbnuj483y1Nev9rWsMsMz2/nWdbDkoU5VcJJWhcYit4c9DX2lC97V+CXA
tiFnI9o74ej0U6vqgXBGIjRS+Yr3upWpjnDts2CfKEczoUGQW/X74AJDCLPTYQs0/AjDbcZACeNN
by2bY2HFxMU0He1gJrW4RQ+j9q3mKeyGTXwUckDjCRCIgAcCIINA0Ea/rrEteEGs4BB3pZAnTMMf
IEHDHOlYqSSC736IPCNSyAGTENwmJAQwQyUmSclKWvKSmMxkJf13sZa1LP+PazkXOlDEBRvIwgtf
OMAY0LBKQbrylbCMpSxnSctaouFDsTnjEnWJPcVxwCMikEUQUPmFYhrzmMhMpjKXycxmFpMMjvMP
KPUoxDABpzt+ZAowa5ADHvDAB+AMpzjHSc5ymvOc6ARnEDrIy3aiMVcC2tg0XAGLEIhgBzXIpz73
yc9++vOfAP1nDgY60Ctm8aC90eO8sKWO5WygCh14BRdAAIIwUPSiGM2oRjfK0Y52NAQgxeUu35lI
JRbGIeTwIyuqwAEOuMIKnOjAL2NKU1fUtAM3zalNd4pTnsbUCq54Be+kSc2iOgp4MvsJRBrKkQf0
QgNQBcU0okrVqlr1qlj/zWpVPbEBDiRxpGDFGPi89xCNIMQBaA3GL9L6i7a69a1wjatc5xoNjmzA
oJ7co9jkJBuJaEQjVVmHPARLWHPII7CGLSxiF3vYxqYjpWg9WC7R2IIbGOEIhCjCEHCwAniikUzY
8mtDkjPalpj2tCoBrAOimdD2NeAGGbhEEipgAie1LzBeUSpqd8vb05r1q3CaQRNw0YQbnECBrPIe
W45yFeYW5bnOjS5RlspJ/pjACN5IQgs2t6rB4BYzyiXTVlrwgyS4YIvobWG4GAIFkYopBUgoCA4+
K6bWpOa+I4CADIYwXEG0IIcADllb9EVUr6wAASS5wNiOuqnJXMsvMIiv/yGOy68KDyk57FRVCpxg
kxvYsD+FOd1wKoCINAbYXQMmXZuMI+GRHEFpE/QZiMV7A0SoN704flF8PlbGEuFgEUroAQxa4AIY
3KAIh2iCCkyaV2v1BsmHsBX+3vWQJ/iQqBFQRBMoUMEU1JgQE6AgFk+8l/RA2RBNRui8NAJcEpzZ
EEc4bq5UgNkA/IDJe5TXHbEb5SlLucwEQgxeW5CIJrDgcEJAQgIP6U4HVwcDhyjCjSctmNnwxBz5
cQhlhpCI+Xp2LCYwY54ViJ43D6IIfyazg1Mswc5AIBEZUGhRg8eoFLSgAjfItQRS8JopccXUgpD0
qLPCAhjgGgdDFiCbkf9Hli8f4gafhpuMRxADISD4EEfAQainpJVjJ+EQCCiCuDEg7iKEudawTfIF
/ss6K5Oux1lpsSEgAMDZJdAEN+DwJRAgA5eRoBspEBcO+quIIRwXKOZw778RkQRpO/w6JriALqAt
Xl0cIUomAHahV0A+1mKF0IgQgtjySGus3IDguYiBv3RRgf+YYAG5cMIK4JdhZxvC0wAUdVZOoHFN
NEHOYtFFCiRU51wYmjZX5DQi2L3Ch4/g2wSRAZly8WLA/OAbGThBwnP2FT4fYrsw1rlsZFAQVBOG
3EZA+SCagHZxczksK9ByEZSgiB8gZqiGUTshgChmTEHdEEkYAq57Lgj/2Y1A46imzHsI3/KsSKDo
hqBCCZKoiLDXe0QUMIQQIgAbspc4SogH0lfijgguu8YEkCcEFp5wRUW8jQUtkACRW0B7F8R+9rXn
dYnoLggj6P43JFC6IRpQMa8TwggeBAsWEIH8ykggEVOQ7AhIj4ikCQEXLb8ODALQBJWDj8RfZ8/h
I+05BuhdEDBAHMwPcQWPPx8RTegX+DNxAwoJgd693sr2DyEB4xh/EBjgJSQAcocAPD2ACFlQPwRo
CMJmGZ6XCfPVM/3hAksHepEmL1lhc4SwAOUSA4iwBNX1foeAfBOIC9AmVlGygITQf6jyf733QS4o
CEOwVyrINZmTFTU4/wgXRyMmgH3cpRewZ3saOAgtIH6INz5/Vwg4hx09iAgExhUiGGXIYoIiFAM9
AGmZ0H/9EYOJ1y+J4GGEkwjs1IQ29jYxiAgR+B8pYG26EGoQEnogdAJfyDCJ0HqJkDHCdwknKCA3
cG26IF5cEYMk+B85iH7pUR11SEalom99BmOz0XPZxxnX9w0uM34MiDiFGADnNT5iaEeyQXjsVnJZ
0XP1NyEHSBCGJ4jsk4nbNTaJmDlgIXGIsIlwwwA9l4YDOBIhA4dEQoGIwIKok4gpZHJzmHMjcIZ7
OAJYmAhHgAGC13OAeIzklynUZwhgiDidSEOlwgKJoAC1uBWQCBYpoP8I2pYWQygIlQiH8jKH1vKK
DdIZflgITTByT0KKX/Fjv/gf5xgAqXgIARg+I/CFtkWGU8FsWjGJh9BZWXSLXZGHqgdC+GgIu3iB
1tFzFuA2WuGLBvNupZIVHogICsZLyPgV8kYIUmch+xiNXPgossiA10MC+2cITKBwT5cIS6YopAgW
iQB2qbKP6UiRAPKAheAEVTMC81cIWuBxXrGPATAE+MOQWbGTAZKS/uePaPRqiMBrIJZ6g0ADGaYV
J3B+giAE+0KKhpEIKrcdEVkIE2kITYBU62eNIDKOiCAFeDUCTNmUoTYjJTkILacVsXUIPWAsp2gI
wOgaPWcCvyOUhKD/BG7oGst3CFnQXly3KmcoCE3wA0w3AhFwA7z3bKzRc01QW+3BmIQAhmrRczPg
H4EhlgtAmllhmoPgAu5WFXeEFSkQjyPReCNwdYiwAAE3Aq+lCBmgmCViAfDHkywgA52xloWAAD2Q
a8toCESwbLAoLzFJEqiZnZGWdpcgBMmTlwEAZf8oFlypCU6gAoKmYh35H7LpDbxpfjaBBU9Cl5hw
KivAiLlAAfEhfePynrlgBArJFeKpCTPoH5dZCBw3IdyZCT2QYrZZYBOyAkmYC0lgesIRl5hwnkmw
bRMqloWwmu8hA/p5CYO5FdbZJWETLSfgnJiABMxpHS+XCUcwnIUQtwHREi0xUKKgaSor0JfgpnJV
5kPfghzicgI3AKSFsAA9wAJXoaLTcQIJKoMnwBBvNgPI4aMJigRC+qRXMQNKyn3aVqQ7dhK9xRAn
4AI4gANG0KZEsKYuUKW85QJEwHwx8BAnUKcBgAWnxQI/4HVK8KYscFoqgAN/2qZYgAMukBJmFQAa
oBMushARIakZUamUeqmWmqmYuhAvMAM6gAM64AJRoKk4sAVap6moOqmjtamVmqoZsRGBAAA7
"""

getgray = """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"""

gnedge = """
R0lGODdhHgAeAPcAAH7+qX3+qX39qXz9qXv8qnv7qnz8qXv8qXv7qXr7qnr6qnn6qnj5q3f5q3b3
rG7xrgAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm
/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMA
ADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZ
MzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YA
ZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZ
mWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkA
zJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ
/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wz
AMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzM
M8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8z
Zv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/M
mf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoaGigoKDU1NUNDQ1BQUF1dXWtra3h4eIaG
hpOTk6Ghoa6urru7u8nJydbW1uTk5PHx8f///wAAAAEBAQICAgMDAywAAAAAHgAeAAcIrQAfOHCg
wIACBQIMGBDAEICAAAwjMoTY0OHAggolVgTAEUAAjh85CugYIOPIjihTqlwZcaXLlx0fwpxJs6bN
mzhz6tzJs6fPn0BVhgxKtKjRozs3BtW4VONQngkWajy5swGDAgwQDGCq04BWAgcWTG258qlIqQcO
CDiwdaxQkB8pMhzQduzYAHg9lnyIl2LdiFJbbhw5USTFwIHdniQ8eKLdxxKl9u0L+bFUAwF1ADs=
"""

gred = """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"""

greennde = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////ywAAAAAGgAYAAMEWPDJSau9eILMJfgg2FHhp5TjEypse4oZ6M7sx5kzQNuX3PouWAWXo716
up2RN0wWd5um8bSMSpVQ5LKqxeasJOK0xryOyTEx9wYMCtMlVMoTL8/v+LxeEiEAOw==
"""

grey = """
R0lGODdhHgAeAPcAAL6+vgAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABm
MwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/
ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNm
mTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/
zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm
/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kA
AJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZ
M5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wA
ZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZ
mcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8A
zP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z
///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoaGigoKDU1NUNDQ1BQ
UF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx8f///wAAAAEBAQICAgMDAwQEBAUF
BQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxI
sKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

greynode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////ywAAAAAGgAYAAMEXvDJSau9eILMJfgg2FHhh5TjEyJse4oZ6M7sx5kzQNuX3PouWAXnOuh2
GwsxeED2jjlW85ckQaNO5fVHez2721rVCgaPNcuu+IxW59jo8LuzQvJupXwqrt/7/4CBFREAOw==
"""

ltblnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////ywAAAAAGgAYAAMEhfDJSau9eILMJfgg2FHhx5TjExoO67QhB7YOYxg2U38ykNMAF8vAu8yG
RxysWPncaqyTMupgkgA1Ggs7RG4sTpqOqNTZrJ4gdHjSutBp6lM9PX2b3KzOp10ag2NIUVRwKh8t
g1ldIn9yWmZVd2BhdYhEkn+UQ5GFeCUoKWmfmKGlpqeoDxEAOw==
"""

ltgnnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////ywAAAAAGgAYAAMElvDJSau9eILMJfgg2FGgAAiOKY4l4iyP8yjqln2C+zrKHD8mzse1QBhz
u4Xjg8EheqlhD6q6fHa+pVH2QjAtQ6JMMXA8s0EwQDzzQpWzgI20fnNz8N23cs0q12ZTQHN0Z28o
WS57hWZYOXZehBpSD4YxSi9VVoBKLn5Gi3xDgW1nS5JqYWYukaGbIbCoQrGuI7a3uLkcEQA7
"""

pink = """
R0lGODdhHgAeAPcAAL8/vwAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABm
MwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/
ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNm
mTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/
zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm
/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kA
AJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZ
M5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wA
ZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZ
mcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8A
zP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z
///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoaGigoKDU1NUNDQ1BQ
UF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx8f///wAAAAEBAQICAgMDAwQEBAUF
BQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxI
sKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

red = """
R0lGODdhHgAeAPcAAP8AAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABm
MwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/
ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNm
mTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/
zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm
/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kA
AJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZ
M5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wA
ZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZ
mcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8A
zP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z
///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoaGigoKDU1NUNDQ1BQ
UF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx8f///wAAAAEBAQICAgMDAwQEBAUF
BQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxI
sKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBDihxJsqTJkyhTngwoADs=
"""

rednode = """
R0lGODdhGgAYAPEAAP///wAAAP8AAL8/vywAAAAAGgAYAAACU4SPqcsXDU2YlEZUp8gXVAGGm9VQ
4glOkHYGqLqYoSySCduiY+y+Onzr5V6PoG7zKxp9RN4v6WS2lBjcMQVcXrElK3RFq9m6GU5HUs6e
1+y221AAADs=
"""

swap = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAgACAA
BwixAAMIHEiwoMGDCBMGSKCwYcIEDB1KHAgx4kSHFS1eDACgY8GMGicCqAiAIsiMIkkKPMkypMGR
EEuubAmyYUeZJivm1LlxJsSPKBHePMiTYM2DQ4m6XBi0YFKiSosSfHrx6FSqE60OvImzqlSBXHv6
dBlW6MOfL7Fu7WoUbVqPb6MmLHsVbk+uXfE6tSsUr1+7MBOwffu3bODBSAsDVnmXLli+Fx2LjTt5
LuLKWzFrHhgQADs=
"""

swap_1 = """
R0lGODlhHgAeAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAeAB4A
AAjEAD0IHEiwoEGBVqyssBLooMOHClldY7Wi4cOLAgMtDMQqkEKLGB1uXLiCVcKQED12XLkCpUgr
rCTG1OjyoEaJ1yYurGkwEICSOTfWBEC0aFGFH3l68OiR6EaGIJVeO6r04NSFAKJW9XC1IQArWwde
Besha1iuP0F+DTu2oFaXXc8SbCtXYNy6aHdWxVox71uUVgDI/PmTrFKfCzuuKBp2IVKSLcNmhTkz
8NmvMScqPhsY58S1YRHjTCt3sWmzdStW/MszIAA7
"""

swap_2 = """
R0lGODlhHgAeAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAeAB4A
AAjVAD0IHEiwoEGBVqyssBLooMOHClldY7Wi4cOLAgMtDMQqkEKLGB1uXLiCVcKQED12XLkCpUgr
rCTG1OjyoEaJ1yYurGlwAICSOTfyJPgoghUACj8OHXgtwpcBDBmCHFp0xNSlTCMksoLVYNWrXZt+
4dqVaASrXUcQbLq1bASLX8t6GMFVLFm3geLKnftF612eC382jOAULMqjMn+OOMtYrctAP2FqBCDA
o2WGLhcmJdmyKwCVM4+WRRpzYsfOWBHnnIi0LGSg1wTLXfGztuGhFSverhkQADs=
"""

swap_3 = """
R0lGODlhHgAeAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAeAB4A
AAjUAD0IHEiwoEGBVqyssBLooMOHClldY7Wi4cOLAgMtDMQqkEKLGB1uXLiCVcKQED12XLkCpUgr
rCTG1OjyoEaJ1yYurGkwEICSOTfWHEC06AABABR+5OnBo0cBRxkyBMm0VVErTA9aHWBlANWsHrZi
5Qp24FaLXsuGJYpVIFmXAwieLfj1Ytq1b8uSnavWg1exfd12vct04c+GV8FaASDzp9GiNX0u7LgC
gACnUuu+VEqyZVkAKmcuVps05kTKahfjnJhUrWSch/tWng06sIeKFTXzDAgAOw==
"""

vertex = """
R0lGODdhIAAgAPcPAAAAAIAAAACAAICAAAAAgIAAgACAgMDAwICAgP8AAAD/AP//AAAA//8A/wD/
/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAAgACAA
BwixAAMIHEiwoMGDCBMqXMiwocMACCJKRPAQYcSDFysKzJiQY0OKDkEyFEkQgMmTAAaS7FgQpUuT
EEeWPJmgps0EKFcaFEnzpk+cAHQS5Gnyp1GTQjcOLGr0aEqLApk2dQo1gNSpPmFitAoA61StBSle
9XoT7FCuZKliHJsWqEW2ac2G7dq27NO1de0qhItVrsGebf3+pRv37l6+WQUfBNz0ZEWUThUvfOlS
4+DKljNrzhwQADs=
"""

vertex_1 = """
R0lGODlhGAAZAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAYABkA
AAj2AD0IHOghkBUrAFZYWWEwEMGHAw0mXJGw4gqFViAOXAhgoZVA11h9XKjQIcRACT+yYnWtZchA
BjE+PAgg0EqXOFnFLBmR4oqbK1fCBCn04kGBPht+HArzYEmSGT2kPEi1qlWoKzx4ZPi0qciYHhfG
TKnUYNCvI7ciVNjVytmVHg2KvZgSo0qbeOWSDKQQQEe7TAMrJcm2q1KdaOUqpRjX5tugganyVSj0
8VnHrC5K9Mgy582cVaWWtImzdEudJJGSJW369EqeBRE2/Fz6tdGoWinCPOvyLGOTERH+3f0SY0qN
TivOXdsR+EmaPi2O1Piw7EiDGgMCADs=
"""

vertex_2 = """
R0lGODlhGAAZAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAYABkA
AAj/AD0IHOghUCsrA75Y+RLISiCCEAdaSZTwS8KLXxQ+jCgwkMVEXxK1uvZIJMiQVjgiDNlqxIhr
MK+NaNUKZKKNAwNRbPkyZsxHNTMmSilwYcIRj0i6RNoq6aOZQjda/FKzKtCriWyWFCowYdavYMNm
FfqlYEiqLBMBVcv27NiDU03WLIkUKduSNkN6DVmS7lKXWt9m3Pu1qWGgNceiRTjAZtaWkGdKNnlS
odCqVRNNzizXqFaXT0PXfdoS71ChS0X/He0yo8PGIXv+ROqTJN6HXuvW3v30pMC4S3fHXIqy4061
tHmPyBgSp1GaoGU/bd2YaE6KsGk6bRWSIkOVIC+CFeTuvTrHjhMxYhyK83xBh/AbNuQYEAA7
"""

vertex_3 = """
R0lGODlhGAAZAPcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBm
ZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/
mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNm
zDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP/
/2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZ
AGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkA
M5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZ
ZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswA
mcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZ
zMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A
//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///M
AP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAkMAB4ALAAAAAAYABkA
AAj/AD0IHOghkJUIAgZYGRAoQiCCEAc2TDggocUBAxxGHLiQYoRE11pF+BIBYwQrGwNRHNCq1bWX
Ib+QzPiQ4EGKiVzCDNlqZkaUAgNVxJizZUuZX4x+MVlTgMeMSJFGKDmyZEaBCaeanMq1q9aMAwoK
oEqyLMlEVcFq/SKUbFWSRkWW1UrVqVu4cUVCXauQatekgHuS/LrUit0Bg6Mqnmu1ot+Rc3vKrfr2
5FizeeMqpqq2bKucRT8nSvSlKEYrKp3C3Ql6Z0itD8dWXO0a5mefAh1P/azTtVGMAoDe3NtyJ+9E
GGlKHFoyNE/RjoFyRCgbsVKwCWtCbDjUaXeLJzcKEUSNsDtz1OIJGlyPGrV2ggEBADs=
"""

whitnode = """
R0lGODdhGgAYALMAAAAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD/
/////ywAAAAAGgAYAAMETPDJSau9eILMJfgg2FHh95TjKVoht2YmvFUzWdOxl2s7f90+FtDzG6p+
RSHG2NMhlVBaMkqa4oxCbNOa7Wxt25a3RE7xyFizes1eR2wAOw==
"""

yellow = """
R0lGODdhHgAeAPcAAP//AAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABm
MwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/
ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNm
mTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/
zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm
/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kA
AJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZ
M5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wA
ZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZ
mcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8A
zP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z
///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///wAAAA0NDRoaGigoKDU1NUNDQ1BQ
UF1dXWtra3h4eIaGhpOTk6Ghoa6urru7u8nJydbW1uTk5PHx8f///wAAAAEBAQICAgMDAwQEBAUF
BQYGBgcHBwgICAkJCQoKCgsLCwwMDA0NDQ4ODg8PDxAQEBERERISEiwAAAAAHgAeAAcIMgABCBxI
sKDBgwgTKlzIsKHDhxAjSpxIsaLFixgzatzIsaPHjyBDihxJsqTJkyhTngwIADs=
"""

def Init():
    import GatoUtil
    imageCache = GatoUtil.ImageCache() # singleton
    imageCache.AddImage("Icons/black.gif",black)
    imageCache.AddImage("Icons/blacknde.gif",blacknde)
    imageCache.AddImage("Icons/bledge.gif",bledge)
    imageCache.AddImage("Icons/bluenode.gif",bluenode)
    imageCache.AddImage("Icons/catbox_splash.gif",catbox_splash)
    imageCache.AddImage("Icons/delete.gif",delete)
    imageCache.AddImage("Icons/delete_1.gif",delete_1)
    imageCache.AddImage("Icons/delete_2.gif",delete_2)
    imageCache.AddImage("Icons/delete_3.gif",delete_3)
    imageCache.AddImage("Icons/dkblnode.gif",dkblnode)
    imageCache.AddImage("Icons/dkgnnode.gif",dkgnnode)
    imageCache.AddImage("Icons/edge.gif",edge)
    imageCache.AddImage("Icons/edge_1.gif",edge_1)
    imageCache.AddImage("Icons/edge_2.gif",edge_2)
    imageCache.AddImage("Icons/edge_3.gif",edge_3)
    imageCache.AddImage("Icons/edit.gif",edit)
    imageCache.AddImage("Icons/edit_1.gif",edit_1)
    imageCache.AddImage("Icons/edit_2.gif",edit_2)
    imageCache.AddImage("Icons/edit_3.gif",edit_3)
    imageCache.AddImage("Icons/gato.gif",gato)
    imageCache.AddImage("Icons/gato_128.gif",gato_128)
    imageCache.AddImage("Icons/getgray.gif",getgray)
    imageCache.AddImage("Icons/gnedge.gif",gnedge)
    imageCache.AddImage("Icons/gred.gif",gred)
    imageCache.AddImage("Icons/greennde.gif",greennde)
    imageCache.AddImage("Icons/grey.gif",grey)
    imageCache.AddImage("Icons/greynode.gif",greynode)
    imageCache.AddImage("Icons/ltblnode.gif",ltblnode)
    imageCache.AddImage("Icons/ltgnnode.gif",ltgnnode)
    imageCache.AddImage("Icons/pink.gif",pink)
    imageCache.AddImage("Icons/red.gif",red)
    imageCache.AddImage("Icons/rednode.gif",rednode)
    imageCache.AddImage("Icons/swap.gif",swap)
    imageCache.AddImage("Icons/swap_1.gif",swap_1)
    imageCache.AddImage("Icons/swap_2.gif",swap_2)
    imageCache.AddImage("Icons/swap_3.gif",swap_3)
    imageCache.AddImage("Icons/vertex.gif",vertex)
    imageCache.AddImage("Icons/vertex_1.gif",vertex_1)
    imageCache.AddImage("Icons/vertex_2.gif",vertex_2)
    imageCache.AddImage("Icons/vertex_3.gif",vertex_3)
    imageCache.AddImage("Icons/whitnode.gif",whitnode)
    imageCache.AddImage("Icons/yellow.gif",yellow)

