from setuptools import setup, find_packages
import sys, os

version = '0.3.1'

setup(name='GeoFormAlchemy',
      version=version,
      author='Camptocamp',
      url='http://github.com/camptocamp/GeoFormAlchemy',
      description="GeoFormAlchemy - a extension for FormAlchemy that adds support for spatial databases",
      long_description=open('README.rst').read(),
      classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Framework :: Pylons',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Topic :: Software Development :: User Interfaces',
        'Topic :: Text Processing :: Markup :: HTML'
        ], # Get strings from http://pypi.python.org/pypi?%3Aaction=list_classifiers
      keywords='gis sqlalchemy geoalchemy formalchemy',
      license='MIT',
      packages=find_packages(exclude=['tests']),
      include_package_data=True,
      zip_safe=True,
      install_requires=[
            'FormAlchemy>=1.3.0',
            'GeoAlchemy>=0.4'
      ],
      entry_points="""
       [paste.paster_create_template]
        geo_fa = geoformalchemy.pylons.paster_template:PylonsTemplate
      """,
      )
